<?php
use yii\helpers\Url;
use yii\helpers\Html;


?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>管理登录</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="<?= \Yii::$app->request->hostInfo ?>/statics/lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="<?= \Yii::$app->request->hostInfo ?>/statics/css/site.css">
    <script src="<?= \Yii::$app->request->hostInfo?>/statics/lib/layui/layui.js"></script>
    <script>
        var $ = null;
        layui.use('element', function(){
            $ = layui.$
        });
    </script>
    <style>
        #LAY_app,body,html {
            height: 100%
        }

        .layui-layout-body {
            overflow: auto
        }

        #LAY-user-login,.layadmin-user-display-show {
            display: block!important
        }

        .layadmin-user-login {
            position: relative;
            left: 0;
            top: 0;
            padding: 110px 0;
            min-height: 100%;
            box-sizing: border-box
        }

        .layadmin-user-login-main {
            width: 375px;
            margin: 0 auto;
            box-sizing: border-box
        }

        .layadmin-user-login-box {
            padding: 20px
        }

        .layadmin-user-login-header {
            text-align: center
        }

        .layadmin-user-login-header h2 {
            margin-top: 10px;
            font-weight: 300;
            font-size: 28px;
            color: #000
        }

        .layadmin-user-login-header p {
            font-weight: 300;
            color: #999
        }

        .layadmin-user-login-body .layui-form-item {
            position: relative
        }

        .layadmin-user-login-icon {
            position: absolute;
            left: 1px;
            top: 1px;
            width: 38px;
            line-height: 36px;
            text-align: center;
            color: #d2d2d2
        }

        .layadmin-user-login-body .layui-form-item .layui-input {
            padding-left: 38px
        }

        .layadmin-user-login-codeimg {
            max-height: 38px;
            width: 100%;
            cursor: pointer;
            box-sizing: border-box
        }

        .layadmin-user-login-other {
            position: relative;
            font-size: 0;
            line-height: 38px;
            padding-top: 20px
        }

        .layadmin-user-login-other>* {
            display: inline-block;
            vertical-align: middle;
            margin-right: 10px;
            font-size: 14px
        }

        .layadmin-user-login-other .layui-icon {
            position: relative;
            top: 2px;
            font-size: 26px
        }

        .layadmin-user-login-other a:hover {
            opacity: .8
        }



        .layadmin-user-login-footer {
            position: absolute;
            left: 0;
            bottom: 0;
            width: 100%;
            line-height: 30px;
            padding: 20px;
            text-align: center;
            box-sizing: border-box;
            color: rgba(0,0,0,.5)
        }

        .layadmin-user-login-footer span {
            padding: 0 5px
        }

        .layadmin-user-login-footer a {
            padding: 0 5px;
            color: rgba(0,0,0,.5)
        }

        .layadmin-user-login-footer a:hover {
            color: rgba(0,0,0,1)
        }

        .layadmin-user-login-main[bgimg] {
            background-color: #fff;
            box-shadow: 0 0 5px rgba(0,0,0,.05)
        }


        .ladmin-user-login-theme ul {
            display: inline-block;
            padding: 5px;
            background-color: #fff
        }

        .ladmin-user-login-theme ul li {
            display: inline-block;
            vertical-align: top;
            width: 64px;
            height: 43px;
            cursor: pointer;
            transition: all .3s;
            -webkit-transition: all .3s;
            background-color: #f2f2f2
        }

        .ladmin-user-login-theme ul li:hover {
            opacity: .9
        }

        @media screen and (max-width: 768px) {
            .layadmin-user-login {
                padding-top:60px
            }

            .layadmin-user-login-main {
                width: 300px
            }
            .layadmin-user-login-box {
                padding: 10px
            }
        }
        .layadmin-user-login{
            background-image: url('https://storage.zheyings.com/zjzapi/supplier-login-bg.png');
            background-size: 100% 100%;
        }
        .layadmin-user-login-main{
            width: 400px;
            margin: 0;
            position: absolute;
            right: 40%;
            top:25%;
            background: rgba(255,255,255,.8);
            border-radius: 4px;
            box-shadow: 0 0 5px #ccc;
        }
        .layadmin-user-login-footer a{
            color: #fff;
        }

    </style>
</head>
<body>
<div class="layadmin-user-login layadmin-user-display-show" id="LAY-user-login">

    <div class="layadmin-user-login-main">
        <div class="layadmin-user-login-box layadmin-user-login-header">
            <h2>管理登录</h2>
        </div>
        <div class="layadmin-user-login-box layadmin-user-login-body layui-form">
            <div class="layui-form-item">
                <label class="layadmin-user-login-icon layui-icon layui-icon-username"></label>
                <input type="text" name="username"  lay-verify="required" lay-verType="tips" placeholder="管理账号" class="layui-input">
            </div>
            <div class="layui-form-item">
                <label class="layadmin-user-login-icon layui-icon layui-icon-password"></label>
                <input type="password" name="password" lay-verify="required" lay-verType="tips" placeholder="登录密码" class="layui-input">
            </div>
            <div class="layui-form-item">
                <div class="layui-row">
                    <div class="layui-col-xs7">
                        <label class="layadmin-user-login-icon layui-icon layui-icon-vercode"></label>
                        <input type="text" name="code"  lay-verify="required" lay-verType="tips" placeholder="图形验证码" class="layui-input">
                    </div>
                    <div class="layui-col-xs5">
                        <div style="margin-left: 10px;">
                            <img title="点击刷新验证码" src="<?php echo Url::to(['common/captcha','refresh'=>243243]);?>" class="layadmin-user-login-codeimg" id="get-vercode">
                        </div>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <button  type="button" style=" background-color: #4C84FF;border-color: #4C84FF;" class="layui-btn layui-btn-fluid" lay-submit lay-filter="login">登 录</button>
            </div>
        </div>
    </div>
    <div class="layui-trans layadmin-user-login-footer">
        <p style="color: #333;">© 2021 <a style="color: #333;" href="<?php echo \Yii::$app->request->hostInfo?>" target="_blank"><?php echo \Yii::$app->request->hostInfo?></a></p>
    </div>
</div>
<script>
    layui.use(['layer', 'form'], function(){
        var layer = layui.layer,form = layui.form;
        var $ = layui.$;
        function vercode() {
            var img = $("#get-vercode");
            $.ajax({
                type: "get",
                url: "<?= Url::to(['common/captcha','refresh'=>'']) ?>",
                dataType: "json",
                success: function (res) {
                    img.attr('src', res.url);
                }
            });

        }
        vercode();
        $("#get-vercode").click(function(){
            var img = $(this);
            $.ajax({
                type: "get",
                url: "<?= Url::to(['common/captcha','refresh'=>'']) ?>",
                dataType: "json",
                success: function (res) {
                    console.log(res);
                    img.attr('src', res.url);
                }
            });
        });
        form.on('submit(login)', function(data){
            layer.msg('登录中', {
                icon: 16,
                shade: 0.01
            });
            data.field['_csrf_zzzy'] = "<?php echo Yii::$app->request->csrfToken?>";
            $.ajax({
                type: "POST",
                url: "<?= Url::to(['common/login']) ?>",
                data: data.field,
                dataType: "json",
                success: function (result) {
                    layer.closeAll('loading');
                    if (result.code === 0) {
                        layer.msg(result.msg, {anim: 0, time: 1500}, function () {
                            window.location.href = "<?php echo Url::to(['site/run'])?>";
                        });
                    } else {
                        vercode();
                        layer.msg(result.msg, {anim: 0, time: 1500});
                    }
                }
            });
        });
    });
</script>

</body>
</html>


