DROP TABLE IF EXISTS `zzzy_idcardv1_issue`;
CREATE TABLE `zzzy_idcardv1_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `content` varchar(255) NOT NULL,
  `created_at` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='常见问题';

DROP TABLE IF EXISTS `zzzy_idcardv1_item`;
CREATE TABLE `zzzy_idcardv1_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '微擎id',
  `name` varchar(255) NOT NULL COMMENT '名称',
  `color` varchar(255) NOT NULL DEFAULT '' COMMENT '支持颜色-json',
  `is_home` tinyint(1) DEFAULT '0' COMMENT '1=首页显示',
  `icon_url` varchar(255) DEFAULT NULL,
  `width_px` int(11) NOT NULL DEFAULT '0' COMMENT '像素-宽',
  `height_px` int(11) NOT NULL DEFAULT '0' COMMENT '像素-高',
  `width_mm` int(11) NOT NULL DEFAULT '0' COMMENT '尺寸-宽',
  `height_mm` int(11) NOT NULL DEFAULT '0' COMMENT '尺寸-高',
  `sort` tinyint(3) DEFAULT '100' COMMENT '排序',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '价格',
  `api_id` int(11) NOT NULL DEFAULT '0' COMMENT '接口id',
  `category` tinyint(1) DEFAULT '0' COMMENT '规格分类：1=常用寸照，2=各类签证，3=各类证件',
  `dpi` int(11) DEFAULT '0',
  `file_size_msg` varchar(255) DEFAULT '',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态：1=显示 ，0=不显示',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='证件照表';

DROP TABLE IF EXISTS `zzzy_idcardv1_make`;
CREATE TABLE `zzzy_idcardv1_make` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `openid` varchar(255) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `created_at` int(11) DEFAULT '0',
  `is_platform` tinyint(2) NOT NULL DEFAULT '1' COMMENT '平台：1=小程序,2=H5',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='制作统计表';

DROP TABLE IF EXISTS `zzzy_idcardv1_photo`;
CREATE TABLE `zzzy_idcardv1_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `image_url` varchar(255) NOT NULL,
  `openid` varchar(255) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `created_at` int(11) DEFAULT '0',
  `is_platform` tinyint(2) NOT NULL DEFAULT '1' COMMENT '平台：1=小程序,2=H5',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='我的证件照';

DROP TABLE IF EXISTS `zzzy_idcardv1_wxapp`;
CREATE TABLE `zzzy_idcardv1_wxapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(255) DEFAULT NULL,
  `app_secret` varchar(255) DEFAULT NULL,
  `application_name` varchar(255) DEFAULT NULL COMMENT '小程序名称',
  `created_at` int(11) DEFAULT '0' COMMENT '创建时间',
  `uniacid` int(11) DEFAULT '0',
  `service_tel` varchar(255) DEFAULT NULL COMMENT '客服电话',
  `service_time` varchar(255) DEFAULT NULL COMMENT '服务时间',
  `is_download` tinyint(1) DEFAULT '0' COMMENT '下载设置：1=免费下载,2=分享后可下载',
  `specs_detail_status` tinyint(1) DEFAULT '1' COMMENT '规格详情页广告:1=关闭，2=Banner广告,3=视频广告',
  `specs_detail_unit_id` varchar(255) DEFAULT NULL COMMENT '规格详情unit_id',
  `mine_status` tinyint(1) DEFAULT '1' COMMENT '我的页广告:1=关闭，2=Banner广告,3=视频广告',
  `mine_unit_id` varchar(255) DEFAULT NULL COMMENT '我的unit_id',
  `service_status` tinyint(1) DEFAULT '1' COMMENT '帮助页广告:1=关闭，2=Banner广告,3=视频广告',
  `service_unit_id` varchar(255) DEFAULT NULL COMMENT '客服unit_id',
  `video_unit_id` varchar(255) DEFAULT NULL COMMENT '',
  `banner_unit_id` varchar(255) DEFAULT NULL COMMENT '',
  `index_interstitial` varchar(255) DEFAULT NULL COMMENT '首页插屏广告',
  `specs_video` varchar(255) DEFAULT NULL COMMENT '规格详情视频广告',
  `mine_video` varchar(255) DEFAULT NULL COMMENT '我的视频广告',
  `service_video` varchar(255) DEFAULT NULL COMMENT '帮助视频广告',
  `theme` tinyint(1) DEFAULT '1' COMMENT '主题颜色：1=蓝色，2=黄色',
  `safety_api` tinyint(1) DEFAULT '0' COMMENT '内容安全API，0=关闭，1=开启',
  `home_title` varchar(255) DEFAULT '' COMMENT '首页标题',
  `anew_num` tinyint(3) DEFAULT '0' COMMENT '制作限制',
  `zjzapi_key` varchar(255) DEFAULT '' COMMENT '证件照api-key',
  `is_beauty` tinyint(1) DEFAULT '0' COMMENT '美颜：0=关闭，1=开启',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='微信小程序配置表';

DROP TABLE IF EXISTS `zzzy_idcardv1_wxapp_user`;
CREATE TABLE `zzzy_idcardv1_wxapp_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `access_token` varchar(255) DEFAULT '',
  `auth_key` varchar(255) DEFAULT '',
  `openid` varchar(255) DEFAULT NULL COMMENT '小程序openid',
  `nickname` varchar(255) DEFAULT NULL COMMENT '微信昵称',
  `avatar_url` varchar(255) DEFAULT NULL COMMENT '微信头像',
  `union_id` varchar(255) DEFAULT NULL COMMENT '微信用户union id',
  `created_at` int(11) DEFAULT NULL COMMENT '注册时间',
  `country` varchar(30) DEFAULT '' COMMENT '国家 ',
  `province` varchar(30) DEFAULT '' COMMENT '省',
  `city` varchar(30) DEFAULT '' COMMENT '市',
  `gender` tinyint(1) DEFAULT '0' COMMENT '用户的性别，值为1时是男性，值为2时是女性，值为0时是未知',
  `phone` varchar(20) DEFAULT '' COMMENT '手机号',
  `uniacid` int(11) DEFAULT '0' COMMENT '微擎id',
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='小程序会员表';


DROP TABLE IF EXISTS `zzzy_idcardv1_more`;
CREATE TABLE `zzzy_idcardv1_more` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL COMMENT '小程序名称',
  `icon_url` varchar(255) NOT NULL COMMENT '图标',
  `appid` varchar(255) NOT NULL COMMENT 'appid',
  `path` varchar(255) NOT NULL COMMENT '路径',
  `qrcode_url` varchar(255)  COMMENT '二维码',
  `info` varchar(255) NOT NULL COMMENT '介绍',
  `created_at` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='跳转';

DROP TABLE IF EXISTS `zzzy_idcardv1_web`;
CREATE TABLE `zzzy_idcardv1_web` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` int(11) DEFAULT '0' COMMENT '创建时间',
  `uniacid` int(11) DEFAULT '0',
  `service_tel` varchar(255) DEFAULT NULL COMMENT '客服电话',
  `service_time` varchar(255) DEFAULT NULL COMMENT '服务时间',
  `is_download` tinyint(1) DEFAULT '0' COMMENT '下载设置：1=免费下载,2=关注公众号后可下载',
  `h5_url` varchar(255) DEFAULT NULL,
  `h5_qrcode` varchar(255) DEFAULT NULL,
  `wx_qrcode` varchar(255) DEFAULT NULL COMMENT '公众号二维码',
  `wx_name` varchar(255) DEFAULT NULL COMMENT '公众号名称',
  `wx_account` varchar(255) DEFAULT NULL COMMENT '公众号账号',
  `wx_appid` varchar(255) DEFAULT NULL COMMENT 'appid',
  `wx_secret` varchar(255) DEFAULT NULL COMMENT 'secret',
  `theme` tinyint(1) DEFAULT '1' COMMENT '主题颜色：1=蓝色，2=黄色',
  `zjzapi_key` varchar(255) DEFAULT '' COMMENT '证件照api-key',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='h5配置表';

DROP TABLE IF EXISTS `zzzy_idcardv1_web_user`;
CREATE TABLE `zzzy_idcardv1_web_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `access_token` varchar(255) DEFAULT '',
  `auth_key` varchar(255) DEFAULT '',
  `openid` varchar(255) DEFAULT NULL COMMENT '小程序openid',
  `nickname` varchar(255) DEFAULT NULL COMMENT '微信昵称',
  `avatar_url` varchar(255) DEFAULT NULL COMMENT '微信头像',
  `union_id` varchar(255) DEFAULT NULL COMMENT '微信用户union id',
  `created_at` int(11) DEFAULT NULL COMMENT '注册时间',
  `country` varchar(30) DEFAULT '' COMMENT '国家 ',
  `province` varchar(30) DEFAULT '' COMMENT '省',
  `city` varchar(30) DEFAULT '' COMMENT '市',
  `gender` tinyint(1) DEFAULT '0' COMMENT '用户的性别，值为1时是男性，值为2时是女性，值为0时是未知',
  `phone` varchar(20) DEFAULT '' COMMENT '手机号',
  `uniacid` int(11) DEFAULT '0' COMMENT '微擎id',
  `password` varchar(255) DEFAULT NULL,
  `subscribe` tinyint(1) DEFAULT '0' COMMENT '关注状态：1=关注，0=未关注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='h5会员表';

DROP TABLE IF EXISTS `zzzy_idcardv1_admin`;
CREATE TABLE `zzzy_idcardv1_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) DEFAULT NULL COMMENT '账号',
  `password` varchar(255) DEFAULT NULL COMMENT '密码',
  `nickname` varchar(255) DEFAULT NULL COMMENT '昵称',
  `created_at` int(11) DEFAULT '0' COMMENT '添加时间',
  `updated_at` int(11) DEFAULT '0' COMMENT '编辑时间',
  `access_token` varchar(255) DEFAULT NULL,
  `auth_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `zzzy_idcardv1_pc`;
CREATE TABLE `zzzy_idcardv1_pc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `created_at` int(11) DEFAULT '0' COMMENT '创建时间',
  `updated_at` int(11) DEFAULT '0' COMMENT '修改时间',
  `main_title` varchar(255) DEFAULT '' COMMENT '网站标题',
  `secondary_title` varchar(255) DEFAULT '' COMMENT '网站副标题',
  `description` text COMMENT '网站描述',
  `keywords` text COMMENT '网站关键词',
  `policeicp` varchar(255) DEFAULT '' COMMENT '备案信息',
  `xapp_qrcode` varchar(255) DEFAULT '' COMMENT '小程序二维码',
  `xapp_bg` varchar(255) DEFAULT '',
  `copyright` varchar(255) NOT NULL DEFAULT '' COMMENT '版权信息',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;