<?php

namespace app\models;

use Yii;
use yii\web\IdentityInterface;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%wxapp_user}}".
 *
 * @property int $id
 * @property string|null $access_token
 * @property string|null $auth_key
 * @property string|null $openid 小程序openid
 * @property string|null $nickname 微信昵称
 * @property string|null $avatar_url 微信头像
 * @property string|null $union_id 微信用户union id
 * @property int|null $created_at 注册时间
 * @property string|null $country 国家
 * @property string|null $province 省
 * @property string|null $city 市
 * @property int|null $gender 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
 * @property string|null $phone 手机号
 * @property int|null $uniacid 微擎id
 * @property string|null $password
 */
class WxappUser extends \yii\db\ActiveRecord implements IdentityInterface
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%wxapp_user}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at', 'gender', 'uniacid'], 'integer'],
            [['access_token', 'auth_key', 'openid', 'nickname', 'avatar_url', 'union_id', 'password'], 'string', 'max' => 255],
            [['country', 'province', 'city'], 'string', 'max' => 30],
            [['phone'], 'string', 'max' => 20],
        ];
    }

    public static function findIdentity($id)
    {
        return static::findOne($id);
    }

    public static function findIdentityByAccessToken($token, $type = null)
    {

        return static::findOne(['access_token' => $token]);
    }

    public function getId()
    {
        return $this->id;
    }

    public function getAuthKey()
    {
        return $this->auth_key;
    }

    public function validateAuthKey($authKey)
    {
        return $this->getAuthKey() === $authKey;
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'access_token' => 'Access Token',
            'auth_key' => 'Auth Key',
            'openid' => '小程序openid',
            'nickname' => '微信昵称',
            'avatar_url' => '微信头像',
            'union_id' => '微信用户union id',
            'created_at' => '注册时间',
            'country' => '国家 ',
            'province' => '省',
            'city' => '市',
            'gender' => '用户的性别，值为1时是男性，值为2时是女性，值为0时是未知',
            'phone' => '手机号',
            'uniacid' => '微擎id',
            'password' => 'Password',
        ];
    }

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at']
                ]
            ]
        ];
    }
}
