<?php

namespace app\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%wxapp}}".
 *
 * @property int $id
 * @property string|null $appid
 * @property string|null $app_secret
 * @property string|null $application_name 小程序名称
 * @property int|null $created_at 创建时间
 * @property int|null $uniacid
 * @property string|null $service_tel 客服电话
 * @property string|null $service_time 服务时间
 * @property int|null $is_download 下载设置：1=免费下载,2=分享后可下载
 * @property int|null $specs_detail_status 规格详情页广告:1=关闭，2=Banner广告,3=视频广告
 * @property string|null $specs_detail_unit_id 规格详情unit_id
 * @property int|null $mine_status 我的页广告:1=关闭，2=Banner广告,3=视频广告
 * @property string|null $mine_unit_id 我的unit_id
 * @property int|null $service_status 帮助页广告:1=关闭，2=Banner广告,3=视频广告
 * @property string|null $service_unit_id 客服unit_id
 * @property string|null $video_unit_id
 * @property string|null $banner_unit_id
 * @property string|null $index_interstitial 首页插屏广告
 * @property string|null $specs_video 规格详情视频广告
 * @property string|null $mine_video 我的视频广告
 * @property string|null $service_video 帮助视频广告
 * @property int|null $theme 主题颜色：1=蓝色，2=黄色
 * @property int|null $safety_api 内容安全API，0=关闭，1=开启
 * @property string|null $home_title 首页标题
 * @property int|null $anew_num 制作限制
 * @property string|null $zjzapi_key 证件照api-key
 * @property int|null $is_beauty 美颜：0=关闭，1=开启
 */
class Wxapp extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%wxapp}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at', 'uniacid', 'is_download', 'specs_detail_status', 'mine_status', 'service_status', 'theme', 'safety_api', 'anew_num', 'is_beauty'], 'integer'],
            [['appid', 'app_secret', 'application_name', 'service_tel', 'service_time', 'specs_detail_unit_id', 'mine_unit_id', 'service_unit_id', 'video_unit_id', 'banner_unit_id', 'index_interstitial', 'specs_video', 'mine_video', 'service_video', 'home_title', 'zjzapi_key'], 'string', 'max' => 255],
        ];
    }


    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at']
                ]
            ]
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'appid' => 'Appid',
            'app_secret' => 'App Secret',
            'application_name' => '小程序名称',
            'created_at' => '创建时间',
            'uniacid' => 'Uniacid',
            'service_tel' => '客服电话',
            'service_time' => '服务时间',
            'is_download' => '下载设置：1=免费下载,2=分享后可下载',
            'specs_detail_status' => '规格详情页广告:1=关闭，2=Banner广告,3=视频广告',
            'specs_detail_unit_id' => '规格详情unit_id',
            'mine_status' => '我的页广告:1=关闭，2=Banner广告,3=视频广告',
            'mine_unit_id' => '我的unit_id',
            'service_status' => '帮助页广告:1=关闭，2=Banner广告,3=视频广告',
            'service_unit_id' => '客服unit_id',
            'video_unit_id' => 'Video Unit ID',
            'banner_unit_id' => 'Banner Unit ID',
            'index_interstitial' => '首页插屏广告',
            'specs_video' => '规格详情视频广告',
            'mine_video' => '我的视频广告',
            'service_video' => '帮助视频广告',
            'theme' => '主题颜色：1=蓝色，2=黄色',
            'safety_api' => '内容安全API，0=关闭，1=开启',
            'home_title' => '首页标题',
            'anew_num' => '制作限制',
            'zjzapi_key' => '证件照api-key',
            'is_beauty' => '美颜：0=关闭，1=开启',
        ];
    }
    static public function getConfig($uniacid)
    {
        return self::find()->where(['uniacid' => $uniacid])->asArray()->one();
    }

    public function afterSave($insert, $changedAttributes)
    {
        \Yii::$app->cache->flush();
        parent::afterSave($insert, $changedAttributes);
    }

}
