<?php

namespace app\models;

use Yii;
use yii\behaviors\TimestampBehavior;
/**
 * This is the model class for table "{{%web}}".
 *
 * @property int $id
 * @property int|null $created_at 创建时间
 * @property int|null $uniacid
 * @property string|null $service_tel 客服电话
 * @property string|null $service_time 服务时间
 * @property int|null $is_download 下载设置：1=免费下载,2=关注公众号后可下载
 * @property string|null $h5_url
 * @property string|null $h5_qrcode
 * @property string|null $wx_qrcode 公众号二维码
 * @property string|null $wx_name 公众号名称
 * @property string|null $wx_account 公众号账号
 * @property string|null $wx_appid appid
 * @property string|null $wx_secret secret
 * @property int|null $theme 主题颜色：1=蓝色，2=黄色
 * @property string|null $zjzapi_key 证件照api-key
 */
class Web extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%web}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at', 'uniacid', 'is_download', 'theme'], 'integer'],
            [['service_tel', 'service_time', 'h5_url', 'h5_qrcode', 'wx_qrcode', 'wx_name', 'wx_account', 'wx_appid', 'wx_secret', 'zjzapi_key'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => '创建时间',
            'uniacid' => 'Uniacid',
            'service_tel' => '客服电话',
            'service_time' => '服务时间',
            'is_download' => '下载设置：1=免费下载,2=关注公众号后可下载',
            'h5_url' => 'H5 Url',
            'h5_qrcode' => 'H5 Qrcode',
            'wx_qrcode' => '公众号二维码',
            'wx_name' => '公众号名称',
            'wx_account' => '公众号账号',
            'wx_appid' => 'appid',
            'wx_secret' => 'secret',
            'theme' => '主题颜色：1=蓝色，2=黄色',
            'zjzapi_key' => '证件照api-key',
        ];
    }

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at']
                ]
            ]
        ];
    }

    static public function getConfig($uniacid)
    {
        return self::find()->where(['uniacid' => $uniacid])->asArray()->one();
    }

    public function afterSave($insert, $changedAttributes)
    {
        \Yii::$app->cache->flush();
        parent::afterSave($insert, $changedAttributes);
    }
}