<?php

namespace app\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%photo}}".
 *
 * @property int $id
 * @property int $uniacid
 * @property string $image_url
 * @property string $openid
 * @property int $item_id
 * @property int|null $created_at
 * @property int $is_platform 平台：1=小程序,2=H5
 */
class Photo extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%photo}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['uniacid', 'item_id', 'created_at', 'is_platform'], 'integer'],
            [['image_url', 'openid'], 'required'],
            [['image_url', 'openid'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uniacid' => 'Uniacid',
            'image_url' => 'Image Url',
            'openid' => 'Openid',
            'item_id' => 'Item ID',
            'created_at' => 'Created At',
            'is_platform' => '平台：1=小程序,2=H5',
        ];
    }

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at']
                ]
            ]
        ];
    }
}
