<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%pc}}".
 *
 * @property int $id
 * @property int|null $uniacid
 * @property int|null $created_at 创建时间
 * @property int|null $updated_at 修改时间
 * @property string|null $main_title 网站标题
 * @property string|null $secondary_title 网站副标题
 * @property string|null $description 网站描述
 * @property string|null $keywords 网站关键词
 * @property string|null $policeicp 备案信息
 * @property string|null $xapp_qrcode 小程序二维码
 * @property string|null $xapp_bg
 * @property string|null $copyright; 版权信息
 */
class Pc extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%pc}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['uniacid', 'created_at', 'updated_at'], 'integer'],
            [['description', 'keywords'], 'string'],
            [['main_title', 'secondary_title', 'policeicp', 'xapp_qrcode','xapp_bg','copyright'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uniacid' => 'Uniacid',
            'created_at' => '创建时间',
            'updated_at' => '修改时间',
            'main_title' => '网站标题',
            'secondary_title' => '网站副标题',
            'description' => '网站描述',
            'keywords' => '网站关键词',
            'policeicp' => '备案信息',
            'xapp_qrcode' => '小程序二维码',
            'xapp_bg' => '',
            'copyright'=>'版权信息'
        ];
    }

    public function behaviors()
    {
        return [
            [
                'class' => \yii\behaviors\TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at'],
                    \yii\db\ActiveRecord::EVENT_BEFORE_UPDATE => ['updated_at'],
                ]
            ]
        ];
    }


    public function afterSave($insert, $changedAttributes)
    {
        \Yii::$app->cache->flush();
        parent::afterSave($insert, $changedAttributes);
    }
}
