<?php

namespace app\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%more}}".
 *
 * @property int $id
 * @property int $uniacid
 * @property string $name 小程序名称
 * @property string $icon_url 图标
 * @property string $appid appid
 * @property string $path 路径
 * @property string|null $qrcode_url 二维码
 * @property string $info 介绍
 * @property int|null $created_at
 */
class More extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%more}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['uniacid', 'created_at'], 'integer'],
            [['name', 'icon_url', 'appid', 'path', 'info'], 'required'],
            [['name', 'icon_url', 'appid', 'path', 'qrcode_url', 'info'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uniacid' => 'Uniacid',
            'name' => '小程序名称',
            'icon_url' => '图标',
            'appid' => 'appid',
            'path' => '路径',
            'qrcode_url' => '二维码',
            'info' => '介绍',
            'created_at' => 'Created At',
        ];
    }

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at']
                ]
            ]
        ];
    }
}
