<?php

namespace app\models;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "{{%make}}".
 *
 * @property int $id
 * @property int $uniacid
 * @property string $openid
 * @property int $item_id
 * @property int|null $created_at
 * @property int $is_platform 平台：1=小程序,2=H5
 */
class Make extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%make}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['uniacid', 'item_id', 'created_at', 'is_platform'], 'integer'],
            [['openid'], 'required'],
            [['openid'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uniacid' => 'Uniacid',
            'openid' => 'Openid',
            'item_id' => 'Item ID',
            'created_at' => 'Created At',
            'is_platform' => '平台：1=小程序,2=H5',
        ];
    }
    public function behaviors()
	{
		return [
			[
				'class'=>TimestampBehavior::className(),
				'attributes' => [
					ActiveRecord::EVENT_BEFORE_INSERT=>['created_at'],
				]
			]
		];
	}

}
