<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%item}}".
 *
 * @property int $id
 * @property int $uniacid 微擎id
 * @property string $name 名称
 * @property string $color 支持颜色-json
 * @property int|null $is_home 1=首页显示
 * @property string|null $icon_url
 * @property int $width_px 像素-宽
 * @property int $height_px 像素-高
 * @property int $width_mm 尺寸-宽
 * @property int $height_mm 尺寸-高
 * @property int|null $sort 排序
 * @property float|null $price 价格
 * @property int $api_id 接口id
 * @property int|null $category 规格分类：1=常用寸照，2=各类签证，3=各类证件
 * @property int|null $dpi
 * @property string|null $file_size_msg
 */
class Item extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id','uniacid','is_home','status'],'integer'],
            ['name','required'],
            ['name','string','max'=>255],
            ['name','trim']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uniacid' => '微擎id',
            'name' => '名称',
            'color' => '支持颜色-json',
            'is_home' => '1=首页显示',
            'icon_url' => 'Icon Url',
            'width_px' => '像素-宽',
            'height_px' => '像素-高',
            'width_mm' => '尺寸-宽',
            'height_mm' => '尺寸-高',
            'sort' => '排序',
            'price' => '价格',
            'api_id' => '接口id',
            'category' => '规格分类：1=常用寸照，2=各类签证，3=各类证件',
            'dpi' => 'Dpi',
            'file_size_msg' => 'File Size Msg',
        ];
    }

}
