<?php
/**
 * @link:http://www.fullzy.net/
 * @copyright: Copyright (c) 2018 郑州鹧应网络科技责任有限公司
 * Created by PhpStorm.
 * User: kangjincang
 * Date: 2019/6/18
 * Time: 上午12:00
 */

define('TABLEPREFIX','zzzy_');

if (!function_exists('core')) {
    function getCore()
    {
        if (class_exists('Yii')){
            return \Yii::$app;
        }
        require(__DIR__ . '/vendor/autoload.php');
        require(__DIR__ . '/vendor/yiisoft/yii2/Yii.php');
        require __DIR__ . '/config/function.php';
        $config = require(__DIR__ . '/config/web.php');
        return new \yii\web\Application($config);
    }
}

if (!function_exists('zy_tablename')) {
    function zy_tablename($table)
    {
        return '`zzzy_' . $table . '`';
    }
}


if (!function_exists('zy_pdo_tableexists')) {
    function zy_pdo_tableexists($tablename)
    {
        if (empty($tablename)) return false;
        $sql = "SHOW TABLES LIKE '" . TABLEPREFIX . $tablename . "'";
        $data = pdo_fetch($sql, array());
        if (!empty($data)) {
            $data = array_values($data);
            if (in_array(TABLEPREFIX . $tablename, $data)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}


if (!function_exists('zy_pdo_fieldexists')) {
    function zy_pdo_fieldexists($tablename, $fieldname = '')
    {
        if (!zy_pdo_tableexists($tablename))
            return false;
        $sql = "DESCRIBE " . zy_tablename($tablename) . " `{$fieldname}`";
        $isexists = pdo_fetch($sql, array());
        return !empty($isexists) ? true : false;
    }
}


if (!function_exists('zy_pdo_valexists')) {
    function zy_pdo_valexists($tablename, $id){
        $sql = "select id from " . zy_tablename($tablename) . "  where id ={$id} limit 1";
        $isexists = pdo_fetch($sql, array());
        return !empty($isexists) ? true : false;
    }

}



