<?php
$params = require __DIR__ . '/params.php';
if(is_ind()){
    $db = is_file(__DIR__.'/ind_db.php') ? require __DIR__ . '/ind_db.php' : '';
}else{
    $db = require __DIR__ . '/db.php';
    $we7_config = $config;
}
$config = [
    'id' => 'core',
    'language' => 'zh-CN',
    'timeZone' => 'Asia/Shanghai',
    'defaultRoute' => 'common/index',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'components' => [
        'request' => [
            'cookieValidationKey' => 'zheying/20190601',
            'csrfParam' => '_csrf_zzzy',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\WxappUser',
            'enableAutoLogin' => true,
            'idParam' => '__user_id',
        ],
        'admin' => [
            'class' => '\yii\web\User',
            'identityClass' => 'app\models\Admin',
            'enableAutoLogin' => true,
            'idParam' => '__admin_id',
            'loginUrl'        => ['common/login'],
        ],
        'webuser' => [
            'class' => '\yii\web\User',
            'identityClass' => 'app\models\WebUser',
            'enableAutoLogin' => true,
            'idParam' => '__h5user_id',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'helpers' => [
            'class' => 'app\components\Helpers',
        ],
        'db' => $db
    ],
    'modules'=>[
        'api' => [
            'class' => 'app\modules\api\Module',
        ],
    ],
    'params' => $params,
];

$config['params']["cookie"] =  $we7_config['cookie'] ?: [
    'pre' => '',
    'domain' => '',
    'path' => '/'
];



return $config;
