#pragma once

#include <Zydis/MetaInfo.h>
#include <Zydis/Mnemonic.h>
#include <zasm/program/instruction.hpp>

namespace zasm::x86
{
    namespace detail
    {
        template<std::uint32_t TID> class Mnemonic : public zasm::InstrMnemonic
        {
        public:
            constexpr Mnemonic()
                : zasm::InstrMnemonic{ TID }
            {
            }
        };
    } // namespace detail

    namespace Mnemonic
    {
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVALID> Invalid{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AAA> Aaa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AAD> Aad{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AAM> Aam{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AAS> Aas{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADC> Adc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADCX> Adcx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADD> Add{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADDPD> Addpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADDPS> Addps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADDSD> Addsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADDSS> Addss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADDSUBPD> Addsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADDSUBPS> Addsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ADOX> Adox{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESDEC> Aesdec{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESDEC128KL> Aesdec128kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESDEC256KL> Aesdec256kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESDECLAST> Aesdeclast{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESDECWIDE128KL> Aesdecwide128kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESDECWIDE256KL> Aesdecwide256kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESENC> Aesenc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESENC128KL> Aesenc128kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESENC256KL> Aesenc256kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESENCLAST> Aesenclast{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESENCWIDE128KL> Aesencwide128kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESENCWIDE256KL> Aesencwide256kl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESIMC> Aesimc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AESKEYGENASSIST> Aeskeygenassist{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_AND> And{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ANDN> Andn{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ANDNPD> Andnpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ANDNPS> Andnps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ANDPD> Andpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ANDPS> Andps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ARPL> Arpl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BEXTR> Bextr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLCFILL> Blcfill{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLCI> Blci{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLCIC> Blcic{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLCMSK> Blcmsk{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLCS> Blcs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLENDPD> Blendpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLENDPS> Blendps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLENDVPD> Blendvpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLENDVPS> Blendvps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLSFILL> Blsfill{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLSI> Blsi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLSIC> Blsic{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLSMSK> Blsmsk{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BLSR> Blsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDCL> Bndcl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDCN> Bndcn{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDCU> Bndcu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDLDX> Bndldx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDMK> Bndmk{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDMOV> Bndmov{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BNDSTX> Bndstx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BOUND> Bound{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BSF> Bsf{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BSR> Bsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BSWAP> Bswap{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BT> Bt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BTC> Btc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BTR> Btr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BTS> Bts{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_BZHI> Bzhi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CALL> Call{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CBW> Cbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CDQ> Cdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CDQE> Cdqe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLAC> Clac{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLC> Clc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLD> Cld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLDEMOTE> Cldemote{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLEVICT0> Clevict0{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLEVICT1> Clevict1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLFLUSH> Clflush{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLFLUSHOPT> Clflushopt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLGI> Clgi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLI> Cli{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLRSSBSY> Clrssbsy{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLTS> Clts{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLUI> Clui{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLWB> Clwb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CLZERO> Clzero{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMC> Cmc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVB> Cmovb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVBE> Cmovbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVL> Cmovl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVLE> Cmovle{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNB> Cmovnb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNBE> Cmovnbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNL> Cmovnl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNLE> Cmovnle{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNO> Cmovno{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNP> Cmovnp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNS> Cmovns{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVNZ> Cmovnz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVO> Cmovo{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVP> Cmovp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVS> Cmovs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMOVZ> Cmovz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMP> Cmp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPPD> Cmppd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPPS> Cmpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPSB> Cmpsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPSD> Cmpsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPSQ> Cmpsq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPSS> Cmpss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPSW> Cmpsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPXCHG> Cmpxchg{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPXCHG16B> Cmpxchg16b{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CMPXCHG8B> Cmpxchg8b{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_COMISD> Comisd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_COMISS> Comiss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CPUID> Cpuid{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CQO> Cqo{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CRC32> Crc32{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTDQ2PD> Cvtdq2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTDQ2PS> Cvtdq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPD2DQ> Cvtpd2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPD2PI> Cvtpd2pi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPD2PS> Cvtpd2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPI2PD> Cvtpi2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPI2PS> Cvtpi2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPS2DQ> Cvtps2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPS2PD> Cvtps2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTPS2PI> Cvtps2pi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTSD2SI> Cvtsd2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTSD2SS> Cvtsd2ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTSI2SD> Cvtsi2sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTSI2SS> Cvtsi2ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTSS2SD> Cvtss2sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTSS2SI> Cvtss2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTTPD2DQ> Cvttpd2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTTPD2PI> Cvttpd2pi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTTPS2DQ> Cvttps2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTTPS2PI> Cvttps2pi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTTSD2SI> Cvttsd2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CVTTSS2SI> Cvttss2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CWD> Cwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_CWDE> Cwde{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DAA> Daa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DAS> Das{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DEC> Dec{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DELAY> Delay{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DIV> Div{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DIVPD> Divpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DIVPS> Divps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DIVSD> Divsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DIVSS> Divss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DPPD> Dppd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_DPPS> Dpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_EMMS> Emms{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENCLS> Encls{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENCLU> Enclu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENCLV> Enclv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENCODEKEY128> Encodekey128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENCODEKEY256> Encodekey256{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENDBR32> Endbr32{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENDBR64> Endbr64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENQCMD> Enqcmd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENQCMDS> Enqcmds{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ENTER> Enter{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_EXTRACTPS> Extractps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_EXTRQ> Extrq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_F2XM1> F2xm1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FABS> Fabs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FADD> Fadd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FADDP> Faddp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FBLD> Fbld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FBSTP> Fbstp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCHS> Fchs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVB> Fcmovb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVBE> Fcmovbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVE> Fcmove{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVNB> Fcmovnb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVNBE> Fcmovnbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVNE> Fcmovne{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVNU> Fcmovnu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCMOVU> Fcmovu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCOM> Fcom{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCOMI> Fcomi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCOMIP> Fcomip{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCOMP> Fcomp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCOMPP> Fcompp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FCOS> Fcos{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FDECSTP> Fdecstp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FDISI8087_NOP> Fdisi8087_nop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FDIV> Fdiv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FDIVP> Fdivp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FDIVR> Fdivr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FDIVRP> Fdivrp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FEMMS> Femms{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FENI8087_NOP> Feni8087_nop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FFREE> Ffree{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FFREEP> Ffreep{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FIADD> Fiadd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FICOM> Ficom{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FICOMP> Ficomp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FIDIV> Fidiv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FIDIVR> Fidivr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FILD> Fild{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FIMUL> Fimul{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FINCSTP> Fincstp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FIST> Fist{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FISTP> Fistp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FISTTP> Fisttp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FISUB> Fisub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FISUBR> Fisubr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLD> Fld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLD1> Fld1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDCW> Fldcw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDENV> Fldenv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDL2E> Fldl2e{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDL2T> Fldl2t{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDLG2> Fldlg2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDLN2> Fldln2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDPI> Fldpi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FLDZ> Fldz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FMUL> Fmul{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FMULP> Fmulp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNCLEX> Fnclex{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNINIT> Fninit{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNOP> Fnop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNSAVE> Fnsave{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNSTCW> Fnstcw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNSTENV> Fnstenv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FNSTSW> Fnstsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FPATAN> Fpatan{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FPREM> Fprem{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FPREM1> Fprem1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FPTAN> Fptan{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FRNDINT> Frndint{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FRSTOR> Frstor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSCALE> Fscale{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSETPM287_NOP> Fsetpm287_nop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSIN> Fsin{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSINCOS> Fsincos{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSQRT> Fsqrt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FST> Fst{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSTP> Fstp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSTPNCE> Fstpnce{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSUB> Fsub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSUBP> Fsubp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSUBR> Fsubr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FSUBRP> Fsubrp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FTST> Ftst{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FUCOM> Fucom{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FUCOMI> Fucomi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FUCOMIP> Fucomip{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FUCOMP> Fucomp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FUCOMPP> Fucompp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FWAIT> Fwait{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXAM> Fxam{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXCH> Fxch{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXRSTOR> Fxrstor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXRSTOR64> Fxrstor64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXSAVE> Fxsave{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXSAVE64> Fxsave64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FXTRACT> Fxtract{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FYL2X> Fyl2x{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_FYL2XP1> Fyl2xp1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_GETSEC> Getsec{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_GF2P8AFFINEINVQB> Gf2p8affineinvqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_GF2P8AFFINEQB> Gf2p8affineqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_GF2P8MULB> Gf2p8mulb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_HADDPD> Haddpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_HADDPS> Haddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_HLT> Hlt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_HRESET> Hreset{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_HSUBPD> Hsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_HSUBPS> Hsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_IDIV> Idiv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_IMUL> Imul{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_IN> In{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INC> Inc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INCSSPD> Incsspd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INCSSPQ> Incsspq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INSB> Insb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INSD> Insd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INSERTPS> Insertps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INSERTQ> Insertq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INSW> Insw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INT> Int{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INT1> Int1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INT3> Int3{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INTO> Into{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVD> Invd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVEPT> Invept{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVLPG> Invlpg{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVLPGA> Invlpga{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVLPGB> Invlpgb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVPCID> Invpcid{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_INVVPID> Invvpid{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_IRET> Iret{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_IRETD> Iretd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_IRETQ> Iretq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JB> Jb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JBE> Jbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JCXZ> Jcxz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JECXZ> Jecxz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JKNZD> Jknzd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JKZD> Jkzd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JL> Jl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JLE> Jle{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JMP> Jmp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNB> Jnb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNBE> Jnbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNL> Jnl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNLE> Jnle{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNO> Jno{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNP> Jnp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNS> Jns{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JNZ> Jnz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JO> Jo{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JP> Jp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JRCXZ> Jrcxz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JS> Js{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_JZ> Jz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KADDB> Kaddb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KADDD> Kaddd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KADDQ> Kaddq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KADDW> Kaddw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KAND> Kand{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDB> Kandb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDD> Kandd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDN> Kandn{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDNB> Kandnb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDND> Kandnd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDNQ> Kandnq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDNR> Kandnr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDNW> Kandnw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDQ> Kandq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KANDW> Kandw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KCONCATH> Kconcath{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KCONCATL> Kconcatl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KEXTRACT> Kextract{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMERGE2L1H> Kmerge2l1h{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMERGE2L1L> Kmerge2l1l{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMOV> Kmov{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMOVB> Kmovb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMOVD> Kmovd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMOVQ> Kmovq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KMOVW> Kmovw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KNOT> Knot{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KNOTB> Knotb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KNOTD> Knotd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KNOTQ> Knotq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KNOTW> Knotw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KOR> Kor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORB> Korb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORD> Kord{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORQ> Korq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORTEST> Kortest{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORTESTB> Kortestb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORTESTD> Kortestd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORTESTQ> Kortestq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORTESTW> Kortestw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KORW> Korw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTLB> Kshiftlb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTLD> Kshiftld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTLQ> Kshiftlq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTLW> Kshiftlw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTRB> Kshiftrb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTRD> Kshiftrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTRQ> Kshiftrq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KSHIFTRW> Kshiftrw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KTESTB> Ktestb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KTESTD> Ktestd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KTESTQ> Ktestq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KTESTW> Ktestw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KUNPCKBW> Kunpckbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KUNPCKDQ> Kunpckdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KUNPCKWD> Kunpckwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXNOR> Kxnor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXNORB> Kxnorb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXNORD> Kxnord{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXNORQ> Kxnorq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXNORW> Kxnorw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXOR> Kxor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXORB> Kxorb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXORD> Kxord{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXORQ> Kxorq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_KXORW> Kxorw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LAHF> Lahf{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LAR> Lar{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LDDQU> Lddqu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LDMXCSR> Ldmxcsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LDS> Lds{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LDTILECFG> Ldtilecfg{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LEA> Lea{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LEAVE> Leave{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LES> Les{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LFENCE> Lfence{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LFS> Lfs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LGDT> Lgdt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LGS> Lgs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LIDT> Lidt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LLDT> Lldt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LLWPCB> Llwpcb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LMSW> Lmsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LOADIWKEY> Loadiwkey{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LODSB> Lodsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LODSD> Lodsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LODSQ> Lodsq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LODSW> Lodsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LOOP> Loop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LOOPE> Loope{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LOOPNE> Loopne{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LSL> Lsl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LSS> Lss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LTR> Ltr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LWPINS> Lwpins{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LWPVAL> Lwpval{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_LZCNT> Lzcnt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MASKMOVDQU> Maskmovdqu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MASKMOVQ> Maskmovq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MAXPD> Maxpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MAXPS> Maxps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MAXSD> Maxsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MAXSS> Maxss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MCOMMIT> Mcommit{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MFENCE> Mfence{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MINPD> Minpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MINPS> Minps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MINSD> Minsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MINSS> Minss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MONITOR> Monitor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MONITORX> Monitorx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MONTMUL> Montmul{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOV> Mov{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVAPD> Movapd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVAPS> Movaps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVBE> Movbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVD> Movd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVDDUP> Movddup{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVDIR64B> Movdir64b{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVDIRI> Movdiri{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVDQ2Q> Movdq2q{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVDQA> Movdqa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVDQU> Movdqu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVHLPS> Movhlps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVHPD> Movhpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVHPS> Movhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVLHPS> Movlhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVLPD> Movlpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVLPS> Movlps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVMSKPD> Movmskpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVMSKPS> Movmskps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTDQ> Movntdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTDQA> Movntdqa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTI> Movnti{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTPD> Movntpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTPS> Movntps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTQ> Movntq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTSD> Movntsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVNTSS> Movntss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVQ> Movq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVQ2DQ> Movq2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSB> Movsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSD> Movsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSHDUP> Movshdup{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSLDUP> Movsldup{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSQ> Movsq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSS> Movss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSW> Movsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSX> Movsx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVSXD> Movsxd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVUPD> Movupd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVUPS> Movups{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MOVZX> Movzx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MPSADBW> Mpsadbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MUL> Mul{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MULPD> Mulpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MULPS> Mulps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MULSD> Mulsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MULSS> Mulss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MULX> Mulx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MWAIT> Mwait{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_MWAITX> Mwaitx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_NEG> Neg{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_NOP> Nop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_NOT> Not{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_OR> Or{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ORPD> Orpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ORPS> Orps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_OUT> Out{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_OUTSB> Outsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_OUTSD> Outsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_OUTSW> Outsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PABSB> Pabsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PABSD> Pabsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PABSW> Pabsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PACKSSDW> Packssdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PACKSSWB> Packsswb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PACKUSDW> Packusdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PACKUSWB> Packuswb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDB> Paddb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDD> Paddd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDQ> Paddq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDSB> Paddsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDSW> Paddsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDUSB> Paddusb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDUSW> Paddusw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PADDW> Paddw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PALIGNR> Palignr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PAND> Pand{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PANDN> Pandn{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PAUSE> Pause{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PAVGB> Pavgb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PAVGUSB> Pavgusb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PAVGW> Pavgw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PBLENDVB> Pblendvb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PBLENDW> Pblendw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCLMULQDQ> Pclmulqdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPEQB> Pcmpeqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPEQD> Pcmpeqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPEQQ> Pcmpeqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPEQW> Pcmpeqw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPESTRI> Pcmpestri{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPESTRM> Pcmpestrm{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPGTB> Pcmpgtb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPGTD> Pcmpgtd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPGTQ> Pcmpgtq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPGTW> Pcmpgtw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPISTRI> Pcmpistri{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCMPISTRM> Pcmpistrm{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PCONFIG> Pconfig{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PDEP> Pdep{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PEXT> Pext{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PEXTRB> Pextrb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PEXTRD> Pextrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PEXTRQ> Pextrq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PEXTRW> Pextrw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PF2ID> Pf2id{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PF2IW> Pf2iw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFACC> Pfacc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFADD> Pfadd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFCMPEQ> Pfcmpeq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFCMPGE> Pfcmpge{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFCMPGT> Pfcmpgt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFCPIT1> Pfcpit1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFMAX> Pfmax{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFMIN> Pfmin{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFMUL> Pfmul{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFNACC> Pfnacc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFPNACC> Pfpnacc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFRCP> Pfrcp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFRCPIT2> Pfrcpit2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFRSQIT1> Pfrsqit1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFSQRT> Pfsqrt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFSUB> Pfsub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PFSUBR> Pfsubr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHADDD> Phaddd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHADDSW> Phaddsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHADDW> Phaddw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHMINPOSUW> Phminposuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHSUBD> Phsubd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHSUBSW> Phsubsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PHSUBW> Phsubw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PI2FD> Pi2fd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PI2FW> Pi2fw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PINSRB> Pinsrb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PINSRD> Pinsrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PINSRQ> Pinsrq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PINSRW> Pinsrw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMADDUBSW> Pmaddubsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMADDWD> Pmaddwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMAXSB> Pmaxsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMAXSD> Pmaxsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMAXSW> Pmaxsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMAXUB> Pmaxub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMAXUD> Pmaxud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMAXUW> Pmaxuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMINSB> Pminsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMINSD> Pminsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMINSW> Pminsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMINUB> Pminub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMINUD> Pminud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMINUW> Pminuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVMSKB> Pmovmskb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVSXBD> Pmovsxbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVSXBQ> Pmovsxbq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVSXBW> Pmovsxbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVSXDQ> Pmovsxdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVSXWD> Pmovsxwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVSXWQ> Pmovsxwq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVZXBD> Pmovzxbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVZXBQ> Pmovzxbq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVZXBW> Pmovzxbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVZXDQ> Pmovzxdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVZXWD> Pmovzxwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMOVZXWQ> Pmovzxwq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULDQ> Pmuldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULHRSW> Pmulhrsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULHRW> Pmulhrw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULHUW> Pmulhuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULHW> Pmulhw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULLD> Pmulld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULLW> Pmullw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PMULUDQ> Pmuludq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POP> Pop{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POPA> Popa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POPAD> Popad{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POPCNT> Popcnt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POPF> Popf{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POPFD> Popfd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POPFQ> Popfq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_POR> Por{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCH> Prefetch{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCHNTA> Prefetchnta{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCHT0> Prefetcht0{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCHT1> Prefetcht1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCHT2> Prefetcht2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCHW> Prefetchw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PREFETCHWT1> Prefetchwt1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSADBW> Psadbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSHUFB> Pshufb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSHUFD> Pshufd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSHUFHW> Pshufhw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSHUFLW> Pshuflw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSHUFW> Pshufw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSIGNB> Psignb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSIGND> Psignd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSIGNW> Psignw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSLLD> Pslld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSLLDQ> Pslldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSLLQ> Psllq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSLLW> Psllw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSMASH> Psmash{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSRAD> Psrad{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSRAW> Psraw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSRLD> Psrld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSRLDQ> Psrldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSRLQ> Psrlq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSRLW> Psrlw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBB> Psubb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBD> Psubd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBQ> Psubq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBSB> Psubsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBSW> Psubsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBUSB> Psubusb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBUSW> Psubusw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSUBW> Psubw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PSWAPD> Pswapd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PTEST> Ptest{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PTWRITE> Ptwrite{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKHBW> Punpckhbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKHDQ> Punpckhdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKHQDQ> Punpckhqdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKHWD> Punpckhwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKLBW> Punpcklbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKLDQ> Punpckldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKLQDQ> Punpcklqdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUNPCKLWD> Punpcklwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUSH> Push{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUSHA> Pusha{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUSHAD> Pushad{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUSHF> Pushf{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUSHFD> Pushfd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PUSHFQ> Pushfq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PVALIDATE> Pvalidate{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_PXOR> Pxor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RCL> Rcl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RCPPS> Rcpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RCPSS> Rcpss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RCR> Rcr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDFSBASE> Rdfsbase{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDGSBASE> Rdgsbase{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDMSR> Rdmsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDPID> Rdpid{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDPKRU> Rdpkru{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDPMC> Rdpmc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDPRU> Rdpru{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDRAND> Rdrand{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDSEED> Rdseed{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDSSPD> Rdsspd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDSSPQ> Rdsspq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDTSC> Rdtsc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RDTSCP> Rdtscp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RET> Ret{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RMPADJUST> Rmpadjust{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RMPUPDATE> Rmpupdate{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ROL> Rol{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ROR> Ror{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RORX> Rorx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ROUNDPD> Roundpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ROUNDPS> Roundps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ROUNDSD> Roundsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_ROUNDSS> Roundss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RSM> Rsm{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RSQRTPS> Rsqrtps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RSQRTSS> Rsqrtss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_RSTORSSP> Rstorssp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SAHF> Sahf{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SALC> Salc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SAR> Sar{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SARX> Sarx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SAVEPREVSSP> Saveprevssp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SBB> Sbb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SCASB> Scasb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SCASD> Scasd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SCASQ> Scasq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SCASW> Scasw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SEAMCALL> Seamcall{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SEAMOPS> Seamops{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SEAMRET> Seamret{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SENDUIPI> Senduipi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SERIALIZE> Serialize{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETB> Setb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETBE> Setbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETL> Setl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETLE> Setle{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNB> Setnb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNBE> Setnbe{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNL> Setnl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNLE> Setnle{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNO> Setno{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNP> Setnp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNS> Setns{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETNZ> Setnz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETO> Seto{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETP> Setp{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETS> Sets{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETSSBSY> Setssbsy{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SETZ> Setz{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SFENCE> Sfence{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SGDT> Sgdt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA1MSG1> Sha1msg1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA1MSG2> Sha1msg2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA1NEXTE> Sha1nexte{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA1RNDS4> Sha1rnds4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA256MSG1> Sha256msg1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA256MSG2> Sha256msg2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHA256RNDS2> Sha256rnds2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHL> Shl{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHLD> Shld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHLX> Shlx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHR> Shr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHRD> Shrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHRX> Shrx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHUFPD> Shufpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SHUFPS> Shufps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SIDT> Sidt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SKINIT> Skinit{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SLDT> Sldt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SLWPCB> Slwpcb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SMSW> Smsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SPFLT> Spflt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SQRTPD> Sqrtpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SQRTPS> Sqrtps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SQRTSD> Sqrtsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SQRTSS> Sqrtss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STAC> Stac{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STC> Stc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STD> Std{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STGI> Stgi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STI> Sti{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STMXCSR> Stmxcsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STOSB> Stosb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STOSD> Stosd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STOSQ> Stosq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STOSW> Stosw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STR> Str{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STTILECFG> Sttilecfg{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_STUI> Stui{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SUB> Sub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SUBPD> Subpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SUBPS> Subps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SUBSD> Subsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SUBSS> Subss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SWAPGS> Swapgs{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SYSCALL> Syscall{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SYSENTER> Sysenter{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SYSEXIT> Sysexit{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_SYSRET> Sysret{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_T1MSKC> T1mskc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TDCALL> Tdcall{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TDPBF16PS> Tdpbf16ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TDPBSSD> Tdpbssd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TDPBSUD> Tdpbsud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TDPBUSD> Tdpbusd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TDPBUUD> Tdpbuud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TEST> Test{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TESTUI> Testui{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TILELOADD> Tileloadd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TILELOADDT1> Tileloaddt1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TILERELEASE> Tilerelease{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TILESTORED> Tilestored{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TILEZERO> Tilezero{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TLBSYNC> Tlbsync{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TPAUSE> Tpause{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TZCNT> Tzcnt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TZCNTI> Tzcnti{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_TZMSK> Tzmsk{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UCOMISD> Ucomisd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UCOMISS> Ucomiss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UD0> Ud0{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UD1> Ud1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UD2> Ud2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UIRET> Uiret{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UMONITOR> Umonitor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UMWAIT> Umwait{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UNPCKHPD> Unpckhpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UNPCKHPS> Unpckhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UNPCKLPD> Unpcklpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_UNPCKLPS> Unpcklps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_V4FMADDPS> V4fmaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_V4FMADDSS> V4fmaddss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_V4FNMADDPS> V4fnmaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_V4FNMADDSS> V4fnmaddss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDNPD> Vaddnpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDNPS> Vaddnps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDPD> Vaddpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDPH> Vaddph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDPS> Vaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDSD> Vaddsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDSETSPS> Vaddsetsps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDSH> Vaddsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDSS> Vaddss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDSUBPD> Vaddsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VADDSUBPS> Vaddsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VAESDEC> Vaesdec{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VAESDECLAST> Vaesdeclast{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VAESENC> Vaesenc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VAESENCLAST> Vaesenclast{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VAESIMC> Vaesimc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VAESKEYGENASSIST> Vaeskeygenassist{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VALIGND> Valignd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VALIGNQ> Valignq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VANDNPD> Vandnpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VANDNPS> Vandnps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VANDPD> Vandpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VANDPS> Vandps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBLENDMPD> Vblendmpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBLENDMPS> Vblendmps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBLENDPD> Vblendpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBLENDPS> Vblendps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBLENDVPD> Vblendvpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBLENDVPS> Vblendvps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTF128> Vbroadcastf128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTF32X2> Vbroadcastf32x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTF32X4> Vbroadcastf32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTF32X8> Vbroadcastf32x8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTF64X2> Vbroadcastf64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTF64X4> Vbroadcastf64x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTI128> Vbroadcasti128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTI32X2> Vbroadcasti32x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTI32X4> Vbroadcasti32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTI32X8> Vbroadcasti32x8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTI64X2> Vbroadcasti64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTI64X4> Vbroadcasti64x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTSD> Vbroadcastsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VBROADCASTSS> Vbroadcastss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCMPPD> Vcmppd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCMPPH> Vcmpph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCMPPS> Vcmpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCMPSD> Vcmpsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCMPSH> Vcmpsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCMPSS> Vcmpss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCOMISD> Vcomisd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCOMISH> Vcomish{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCOMISS> Vcomiss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCOMPRESSPD> Vcompresspd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCOMPRESSPS> Vcompressps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTDQ2PD> Vcvtdq2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTDQ2PH> Vcvtdq2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTDQ2PS> Vcvtdq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTFXPNTDQ2PS> Vcvtfxpntdq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTFXPNTPD2DQ> Vcvtfxpntpd2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTFXPNTPD2UDQ> Vcvtfxpntpd2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTFXPNTPS2DQ> Vcvtfxpntps2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTFXPNTPS2UDQ> Vcvtfxpntps2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTFXPNTUDQ2PS> Vcvtfxpntudq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTNE2PS2BF16> Vcvtne2ps2bf16{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTNEPS2BF16> Vcvtneps2bf16{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPD2DQ> Vcvtpd2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPD2PH> Vcvtpd2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPD2PS> Vcvtpd2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPD2QQ> Vcvtpd2qq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPD2UDQ> Vcvtpd2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPD2UQQ> Vcvtpd2uqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2DQ> Vcvtph2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2PD> Vcvtph2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2PS> Vcvtph2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2PSX> Vcvtph2psx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2QQ> Vcvtph2qq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2UDQ> Vcvtph2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2UQQ> Vcvtph2uqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2UW> Vcvtph2uw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPH2W> Vcvtph2w{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2DQ> Vcvtps2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2PD> Vcvtps2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2PH> Vcvtps2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2PHX> Vcvtps2phx{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2QQ> Vcvtps2qq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2UDQ> Vcvtps2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTPS2UQQ> Vcvtps2uqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTQQ2PD> Vcvtqq2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTQQ2PH> Vcvtqq2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTQQ2PS> Vcvtqq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSD2SH> Vcvtsd2sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSD2SI> Vcvtsd2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSD2SS> Vcvtsd2ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSD2USI> Vcvtsd2usi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSH2SD> Vcvtsh2sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSH2SI> Vcvtsh2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSH2SS> Vcvtsh2ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSH2USI> Vcvtsh2usi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSI2SD> Vcvtsi2sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSI2SH> Vcvtsi2sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSI2SS> Vcvtsi2ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSS2SD> Vcvtss2sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSS2SH> Vcvtss2sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSS2SI> Vcvtss2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTSS2USI> Vcvtss2usi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPD2DQ> Vcvttpd2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPD2QQ> Vcvttpd2qq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPD2UDQ> Vcvttpd2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPD2UQQ> Vcvttpd2uqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPH2DQ> Vcvttph2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPH2QQ> Vcvttph2qq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPH2UDQ> Vcvttph2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPH2UQQ> Vcvttph2uqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPH2UW> Vcvttph2uw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPH2W> Vcvttph2w{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPS2DQ> Vcvttps2dq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPS2QQ> Vcvttps2qq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPS2UDQ> Vcvttps2udq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTPS2UQQ> Vcvttps2uqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTSD2SI> Vcvttsd2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTSD2USI> Vcvttsd2usi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTSH2SI> Vcvttsh2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTSH2USI> Vcvttsh2usi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTSS2SI> Vcvttss2si{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTTSS2USI> Vcvttss2usi{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUDQ2PD> Vcvtudq2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUDQ2PH> Vcvtudq2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUDQ2PS> Vcvtudq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUQQ2PD> Vcvtuqq2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUQQ2PH> Vcvtuqq2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUQQ2PS> Vcvtuqq2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUSI2SD> Vcvtusi2sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUSI2SH> Vcvtusi2sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUSI2SS> Vcvtusi2ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTUW2PH> Vcvtuw2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VCVTW2PH> Vcvtw2ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDBPSADBW> Vdbpsadbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDIVPD> Vdivpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDIVPH> Vdivph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDIVPS> Vdivps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDIVSD> Vdivsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDIVSH> Vdivsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDIVSS> Vdivss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDPBF16PS> Vdpbf16ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDPPD> Vdppd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VDPPS> Vdpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VERR> Verr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VERW> Verw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXP223PS> Vexp223ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXP2PD> Vexp2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXP2PS> Vexp2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXPANDPD> Vexpandpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXPANDPS> Vexpandps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTF128> Vextractf128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTF32X4> Vextractf32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTF32X8> Vextractf32x8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTF64X2> Vextractf64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTF64X4> Vextractf64x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTI128> Vextracti128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTI32X4> Vextracti32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTI32X8> Vextracti32x8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTI64X2> Vextracti64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTI64X4> Vextracti64x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VEXTRACTPS> Vextractps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFCMADDCPH> Vfcmaddcph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFCMADDCSH> Vfcmaddcsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFCMULCPH> Vfcmulcph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFCMULCSH> Vfcmulcsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFIXUPIMMPD> Vfixupimmpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFIXUPIMMPS> Vfixupimmps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFIXUPIMMSD> Vfixupimmsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFIXUPIMMSS> Vfixupimmss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFIXUPNANPD> Vfixupnanpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFIXUPNANPS> Vfixupnanps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD132PD> Vfmadd132pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD132PH> Vfmadd132ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD132PS> Vfmadd132ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD132SD> Vfmadd132sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD132SH> Vfmadd132sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD132SS> Vfmadd132ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD213PD> Vfmadd213pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD213PH> Vfmadd213ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD213PS> Vfmadd213ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD213SD> Vfmadd213sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD213SH> Vfmadd213sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD213SS> Vfmadd213ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD231PD> Vfmadd231pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD231PH> Vfmadd231ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD231PS> Vfmadd231ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD231SD> Vfmadd231sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD231SH> Vfmadd231sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD231SS> Vfmadd231ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADD233PS> Vfmadd233ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDCPH> Vfmaddcph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDCSH> Vfmaddcsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDPD> Vfmaddpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDPS> Vfmaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSD> Vfmaddsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSS> Vfmaddss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB132PD> Vfmaddsub132pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB132PH> Vfmaddsub132ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB132PS> Vfmaddsub132ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB213PD> Vfmaddsub213pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB213PH> Vfmaddsub213ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB213PS> Vfmaddsub213ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB231PD> Vfmaddsub231pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB231PH> Vfmaddsub231ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUB231PS> Vfmaddsub231ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUBPD> Vfmaddsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMADDSUBPS> Vfmaddsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB132PD> Vfmsub132pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB132PH> Vfmsub132ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB132PS> Vfmsub132ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB132SD> Vfmsub132sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB132SH> Vfmsub132sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB132SS> Vfmsub132ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB213PD> Vfmsub213pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB213PH> Vfmsub213ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB213PS> Vfmsub213ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB213SD> Vfmsub213sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB213SH> Vfmsub213sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB213SS> Vfmsub213ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB231PD> Vfmsub231pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB231PH> Vfmsub231ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB231PS> Vfmsub231ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB231SD> Vfmsub231sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB231SH> Vfmsub231sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUB231SS> Vfmsub231ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD132PD> Vfmsubadd132pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD132PH> Vfmsubadd132ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD132PS> Vfmsubadd132ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD213PD> Vfmsubadd213pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD213PH> Vfmsubadd213ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD213PS> Vfmsubadd213ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD231PD> Vfmsubadd231pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD231PH> Vfmsubadd231ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADD231PS> Vfmsubadd231ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADDPD> Vfmsubaddpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBADDPS> Vfmsubaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBPD> Vfmsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBPS> Vfmsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBSD> Vfmsubsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMSUBSS> Vfmsubss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMULCPH> Vfmulcph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFMULCSH> Vfmulcsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD132PD> Vfnmadd132pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD132PH> Vfnmadd132ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD132PS> Vfnmadd132ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD132SD> Vfnmadd132sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD132SH> Vfnmadd132sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD132SS> Vfnmadd132ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD213PD> Vfnmadd213pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD213PH> Vfnmadd213ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD213PS> Vfnmadd213ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD213SD> Vfnmadd213sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD213SH> Vfnmadd213sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD213SS> Vfnmadd213ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD231PD> Vfnmadd231pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD231PH> Vfnmadd231ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD231PS> Vfnmadd231ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD231SD> Vfnmadd231sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD231SH> Vfnmadd231sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADD231SS> Vfnmadd231ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADDPD> Vfnmaddpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADDPS> Vfnmaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADDSD> Vfnmaddsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMADDSS> Vfnmaddss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB132PD> Vfnmsub132pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB132PH> Vfnmsub132ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB132PS> Vfnmsub132ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB132SD> Vfnmsub132sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB132SH> Vfnmsub132sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB132SS> Vfnmsub132ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB213PD> Vfnmsub213pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB213PH> Vfnmsub213ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB213PS> Vfnmsub213ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB213SD> Vfnmsub213sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB213SH> Vfnmsub213sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB213SS> Vfnmsub213ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB231PD> Vfnmsub231pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB231PH> Vfnmsub231ph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB231PS> Vfnmsub231ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB231SD> Vfnmsub231sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB231SH> Vfnmsub231sh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUB231SS> Vfnmsub231ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUBPD> Vfnmsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUBPS> Vfnmsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUBSD> Vfnmsubsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFNMSUBSS> Vfnmsubss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFPCLASSPD> Vfpclasspd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFPCLASSPH> Vfpclassph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFPCLASSPS> Vfpclassps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFPCLASSSD> Vfpclasssd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFPCLASSSH> Vfpclasssh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFPCLASSSS> Vfpclassss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFRCZPD> Vfrczpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFRCZPS> Vfrczps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFRCZSD> Vfrczsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VFRCZSS> Vfrczss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERDPD> Vgatherdpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERDPS> Vgatherdps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF0DPD> Vgatherpf0dpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF0DPS> Vgatherpf0dps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF0HINTDPD> Vgatherpf0hintdpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF0HINTDPS> Vgatherpf0hintdps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF0QPD> Vgatherpf0qpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF0QPS> Vgatherpf0qps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF1DPD> Vgatherpf1dpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF1DPS> Vgatherpf1dps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF1QPD> Vgatherpf1qpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERPF1QPS> Vgatherpf1qps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERQPD> Vgatherqpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGATHERQPS> Vgatherqps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETEXPPD> Vgetexppd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETEXPPH> Vgetexpph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETEXPPS> Vgetexpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETEXPSD> Vgetexpsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETEXPSH> Vgetexpsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETEXPSS> Vgetexpss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETMANTPD> Vgetmantpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETMANTPH> Vgetmantph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETMANTPS> Vgetmantps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETMANTSD> Vgetmantsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETMANTSH> Vgetmantsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGETMANTSS> Vgetmantss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGF2P8AFFINEINVQB> Vgf2p8affineinvqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGF2P8AFFINEQB> Vgf2p8affineqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGF2P8MULB> Vgf2p8mulb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGMAXABSPS> Vgmaxabsps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGMAXPD> Vgmaxpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGMAXPS> Vgmaxps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGMINPD> Vgminpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VGMINPS> Vgminps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VHADDPD> Vhaddpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VHADDPS> Vhaddps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VHSUBPD> Vhsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VHSUBPS> Vhsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTF128> Vinsertf128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTF32X4> Vinsertf32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTF32X8> Vinsertf32x8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTF64X2> Vinsertf64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTF64X4> Vinsertf64x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTI128> Vinserti128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTI32X4> Vinserti32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTI32X8> Vinserti32x8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTI64X2> Vinserti64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTI64X4> Vinserti64x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VINSERTPS> Vinsertps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLDDQU> Vlddqu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLDMXCSR> Vldmxcsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKHD> Vloadunpackhd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKHPD> Vloadunpackhpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKHPS> Vloadunpackhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKHQ> Vloadunpackhq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKLD> Vloadunpackld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKLPD> Vloadunpacklpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKLPS> Vloadunpacklps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOADUNPACKLQ> Vloadunpacklq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VLOG2PS> Vlog2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMASKMOVDQU> Vmaskmovdqu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMASKMOVPD> Vmaskmovpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMASKMOVPS> Vmaskmovps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMAXPD> Vmaxpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMAXPH> Vmaxph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMAXPS> Vmaxps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMAXSD> Vmaxsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMAXSH> Vmaxsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMAXSS> Vmaxss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMCALL> Vmcall{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMCLEAR> Vmclear{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMFUNC> Vmfunc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMINPD> Vminpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMINPH> Vminph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMINPS> Vminps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMINSD> Vminsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMINSH> Vminsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMINSS> Vminss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMLAUNCH> Vmlaunch{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMLOAD> Vmload{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMMCALL> Vmmcall{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVAPD> Vmovapd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVAPS> Vmovaps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVD> Vmovd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDDUP> Vmovddup{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQA> Vmovdqa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQA32> Vmovdqa32{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQA64> Vmovdqa64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQU> Vmovdqu{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQU16> Vmovdqu16{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQU32> Vmovdqu32{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQU64> Vmovdqu64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVDQU8> Vmovdqu8{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVHLPS> Vmovhlps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVHPD> Vmovhpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVHPS> Vmovhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVLHPS> Vmovlhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVLPD> Vmovlpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVLPS> Vmovlps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVMSKPD> Vmovmskpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVMSKPS> Vmovmskps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNRAPD> Vmovnrapd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNRAPS> Vmovnraps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNRNGOAPD> Vmovnrngoapd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNRNGOAPS> Vmovnrngoaps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNTDQ> Vmovntdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNTDQA> Vmovntdqa{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNTPD> Vmovntpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVNTPS> Vmovntps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVQ> Vmovq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVSD> Vmovsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVSH> Vmovsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVSHDUP> Vmovshdup{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVSLDUP> Vmovsldup{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVSS> Vmovss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVUPD> Vmovupd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVUPS> Vmovups{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMOVW> Vmovw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMPSADBW> Vmpsadbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMPTRLD> Vmptrld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMPTRST> Vmptrst{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMREAD> Vmread{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMRESUME> Vmresume{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMRUN> Vmrun{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMSAVE> Vmsave{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMULPD> Vmulpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMULPH> Vmulph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMULPS> Vmulps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMULSD> Vmulsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMULSH> Vmulsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMULSS> Vmulss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMWRITE> Vmwrite{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMXOFF> Vmxoff{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VMXON> Vmxon{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VORPD> Vorpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VORPS> Vorps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VP2INTERSECTD> Vp2intersectd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VP2INTERSECTQ> Vp2intersectq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VP4DPWSSD> Vp4dpwssd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VP4DPWSSDS> Vp4dpwssds{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPABSB> Vpabsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPABSD> Vpabsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPABSQ> Vpabsq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPABSW> Vpabsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSSDW> Vpackssdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSSWB> Vpacksswb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTOREHD> Vpackstorehd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTOREHPD> Vpackstorehpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTOREHPS> Vpackstorehps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTOREHQ> Vpackstorehq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTORELD> Vpackstoreld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTORELPD> Vpackstorelpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTORELPS> Vpackstorelps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKSTORELQ> Vpackstorelq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKUSDW> Vpackusdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPACKUSWB> Vpackuswb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADCD> Vpadcd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDB> Vpaddb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDD> Vpaddd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDQ> Vpaddq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDSB> Vpaddsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDSETCD> Vpaddsetcd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDSETSD> Vpaddsetsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDSW> Vpaddsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDUSB> Vpaddusb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDUSW> Vpaddusw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPADDW> Vpaddw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPALIGNR> Vpalignr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPAND> Vpand{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPANDD> Vpandd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPANDN> Vpandn{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPANDND> Vpandnd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPANDNQ> Vpandnq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPANDQ> Vpandq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPAVGB> Vpavgb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPAVGW> Vpavgw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDD> Vpblendd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDMB> Vpblendmb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDMD> Vpblendmd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDMQ> Vpblendmq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDMW> Vpblendmw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDVB> Vpblendvb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBLENDW> Vpblendw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBROADCASTB> Vpbroadcastb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBROADCASTD> Vpbroadcastd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBROADCASTMB2Q> Vpbroadcastmb2q{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBROADCASTMW2D> Vpbroadcastmw2d{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBROADCASTQ> Vpbroadcastq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPBROADCASTW> Vpbroadcastw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCLMULQDQ> Vpclmulqdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMOV> Vpcmov{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPB> Vpcmpb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPD> Vpcmpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPEQB> Vpcmpeqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPEQD> Vpcmpeqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPEQQ> Vpcmpeqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPEQW> Vpcmpeqw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPESTRI> Vpcmpestri{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPESTRM> Vpcmpestrm{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPGTB> Vpcmpgtb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPGTD> Vpcmpgtd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPGTQ> Vpcmpgtq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPGTW> Vpcmpgtw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPISTRI> Vpcmpistri{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPISTRM> Vpcmpistrm{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPLTD> Vpcmpltd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPQ> Vpcmpq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPUB> Vpcmpub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPUD> Vpcmpud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPUQ> Vpcmpuq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPUW> Vpcmpuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCMPW> Vpcmpw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMB> Vpcomb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMD> Vpcomd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMPRESSB> Vpcompressb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMPRESSD> Vpcompressd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMPRESSQ> Vpcompressq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMPRESSW> Vpcompressw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMQ> Vpcomq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMUB> Vpcomub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMUD> Vpcomud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMUQ> Vpcomuq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMUW> Vpcomuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCOMW> Vpcomw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCONFLICTD> Vpconflictd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPCONFLICTQ> Vpconflictq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPDPBUSD> Vpdpbusd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPDPBUSDS> Vpdpbusds{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPDPWSSD> Vpdpwssd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPDPWSSDS> Vpdpwssds{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERM2F128> Vperm2f128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERM2I128> Vperm2i128{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMB> Vpermb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMD> Vpermd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMF32X4> Vpermf32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMI2B> Vpermi2b{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMI2D> Vpermi2d{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMI2PD> Vpermi2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMI2PS> Vpermi2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMI2Q> Vpermi2q{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMI2W> Vpermi2w{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMIL2PD> Vpermil2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMIL2PS> Vpermil2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMILPD> Vpermilpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMILPS> Vpermilps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMPD> Vpermpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMPS> Vpermps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMQ> Vpermq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMT2B> Vpermt2b{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMT2D> Vpermt2d{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMT2PD> Vpermt2pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMT2PS> Vpermt2ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMT2Q> Vpermt2q{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMT2W> Vpermt2w{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPERMW> Vpermw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXPANDB> Vpexpandb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXPANDD> Vpexpandd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXPANDQ> Vpexpandq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXPANDW> Vpexpandw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXTRB> Vpextrb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXTRD> Vpextrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXTRQ> Vpextrq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPEXTRW> Vpextrw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPGATHERDD> Vpgatherdd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPGATHERDQ> Vpgatherdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPGATHERQD> Vpgatherqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPGATHERQQ> Vpgatherqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDBD> Vphaddbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDBQ> Vphaddbq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDBW> Vphaddbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDD> Vphaddd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDDQ> Vphadddq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDSW> Vphaddsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDUBD> Vphaddubd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDUBQ> Vphaddubq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDUBW> Vphaddubw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDUDQ> Vphaddudq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDUWD> Vphadduwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDUWQ> Vphadduwq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDW> Vphaddw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDWD> Vphaddwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHADDWQ> Vphaddwq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHMINPOSUW> Vphminposuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHSUBBW> Vphsubbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHSUBD> Vphsubd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHSUBDQ> Vphsubdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHSUBSW> Vphsubsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHSUBW> Vphsubw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPHSUBWD> Vphsubwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPINSRB> Vpinsrb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPINSRD> Vpinsrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPINSRQ> Vpinsrq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPINSRW> Vpinsrw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPLZCNTD> Vplzcntd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPLZCNTQ> Vplzcntq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSDD> Vpmacsdd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSDQH> Vpmacsdqh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSDQL> Vpmacsdql{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSSDD> Vpmacssdd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSSDQH> Vpmacssdqh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSSDQL> Vpmacssdql{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSSWD> Vpmacsswd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSSWW> Vpmacssww{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSWD> Vpmacswd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMACSWW> Vpmacsww{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADCSSWD> Vpmadcsswd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADCSWD> Vpmadcswd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADD231D> Vpmadd231d{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADD233D> Vpmadd233d{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADD52HUQ> Vpmadd52huq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADD52LUQ> Vpmadd52luq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADDUBSW> Vpmaddubsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMADDWD> Vpmaddwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMASKMOVD> Vpmaskmovd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMASKMOVQ> Vpmaskmovq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXSB> Vpmaxsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXSD> Vpmaxsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXSQ> Vpmaxsq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXSW> Vpmaxsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXUB> Vpmaxub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXUD> Vpmaxud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXUQ> Vpmaxuq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMAXUW> Vpmaxuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINSB> Vpminsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINSD> Vpminsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINSQ> Vpminsq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINSW> Vpminsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINUB> Vpminub{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINUD> Vpminud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINUQ> Vpminuq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMINUW> Vpminuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVB2M> Vpmovb2m{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVD2M> Vpmovd2m{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVDB> Vpmovdb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVDW> Vpmovdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVM2B> Vpmovm2b{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVM2D> Vpmovm2d{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVM2Q> Vpmovm2q{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVM2W> Vpmovm2w{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVMSKB> Vpmovmskb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVQ2M> Vpmovq2m{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVQB> Vpmovqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVQD> Vpmovqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVQW> Vpmovqw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSDB> Vpmovsdb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSDW> Vpmovsdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSQB> Vpmovsqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSQD> Vpmovsqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSQW> Vpmovsqw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSWB> Vpmovswb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSXBD> Vpmovsxbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSXBQ> Vpmovsxbq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSXBW> Vpmovsxbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSXDQ> Vpmovsxdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSXWD> Vpmovsxwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVSXWQ> Vpmovsxwq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVUSDB> Vpmovusdb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVUSDW> Vpmovusdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVUSQB> Vpmovusqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVUSQD> Vpmovusqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVUSQW> Vpmovusqw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVUSWB> Vpmovuswb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVW2M> Vpmovw2m{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVWB> Vpmovwb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVZXBD> Vpmovzxbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVZXBQ> Vpmovzxbq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVZXBW> Vpmovzxbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVZXDQ> Vpmovzxdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVZXWD> Vpmovzxwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMOVZXWQ> Vpmovzxwq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULDQ> Vpmuldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULHD> Vpmulhd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULHRSW> Vpmulhrsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULHUD> Vpmulhud{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULHUW> Vpmulhuw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULHW> Vpmulhw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULLD> Vpmulld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULLQ> Vpmullq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULLW> Vpmullw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULTISHIFTQB> Vpmultishiftqb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPMULUDQ> Vpmuludq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPOPCNTB> Vpopcntb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPOPCNTD> Vpopcntd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPOPCNTQ> Vpopcntq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPOPCNTW> Vpopcntw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPOR> Vpor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPORD> Vpord{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPORQ> Vporq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPPERM> Vpperm{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCH0> Vprefetch0{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCH1> Vprefetch1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCH2> Vprefetch2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCHE0> Vprefetche0{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCHE1> Vprefetche1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCHE2> Vprefetche2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCHENTA> Vprefetchenta{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPREFETCHNTA> Vprefetchnta{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROLD> Vprold{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROLQ> Vprolq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROLVD> Vprolvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROLVQ> Vprolvq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPRORD> Vprord{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPRORQ> Vprorq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPRORVD> Vprorvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPRORVQ> Vprorvq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROTB> Vprotb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROTD> Vprotd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROTQ> Vprotq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPROTW> Vprotw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSADBW> Vpsadbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSBBD> Vpsbbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSBBRD> Vpsbbrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSCATTERDD> Vpscatterdd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSCATTERDQ> Vpscatterdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSCATTERQD> Vpscatterqd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSCATTERQQ> Vpscatterqq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHAB> Vpshab{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHAD> Vpshad{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHAQ> Vpshaq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHAW> Vpshaw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLB> Vpshlb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLD> Vpshld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLDD> Vpshldd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLDQ> Vpshldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLDVD> Vpshldvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLDVQ> Vpshldvq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLDVW> Vpshldvw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLDW> Vpshldw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLQ> Vpshlq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHLW> Vpshlw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHRDD> Vpshrdd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHRDQ> Vpshrdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHRDVD> Vpshrdvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHRDVQ> Vpshrdvq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHRDVW> Vpshrdvw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHRDW> Vpshrdw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHUFB> Vpshufb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHUFBITQMB> Vpshufbitqmb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHUFD> Vpshufd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHUFHW> Vpshufhw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSHUFLW> Vpshuflw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSIGNB> Vpsignb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSIGND> Vpsignd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSIGNW> Vpsignw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLD> Vpslld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLDQ> Vpslldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLQ> Vpsllq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLVD> Vpsllvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLVQ> Vpsllvq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLVW> Vpsllvw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSLLW> Vpsllw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRAD> Vpsrad{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRAQ> Vpsraq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRAVD> Vpsravd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRAVQ> Vpsravq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRAVW> Vpsravw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRAW> Vpsraw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLD> Vpsrld{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLDQ> Vpsrldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLQ> Vpsrlq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLVD> Vpsrlvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLVQ> Vpsrlvq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLVW> Vpsrlvw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSRLW> Vpsrlw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBB> Vpsubb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBD> Vpsubd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBQ> Vpsubq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBRD> Vpsubrd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBRSETBD> Vpsubrsetbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBSB> Vpsubsb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBSETBD> Vpsubsetbd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBSW> Vpsubsw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBUSB> Vpsubusb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBUSW> Vpsubusw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPSUBW> Vpsubw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTERNLOGD> Vpternlogd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTERNLOGQ> Vpternlogq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTEST> Vptest{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTMB> Vptestmb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTMD> Vptestmd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTMQ> Vptestmq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTMW> Vptestmw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTNMB> Vptestnmb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTNMD> Vptestnmd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTNMQ> Vptestnmq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPTESTNMW> Vptestnmw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKHBW> Vpunpckhbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKHDQ> Vpunpckhdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKHQDQ> Vpunpckhqdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKHWD> Vpunpckhwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKLBW> Vpunpcklbw{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKLDQ> Vpunpckldq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKLQDQ> Vpunpcklqdq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPUNPCKLWD> Vpunpcklwd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPXOR> Vpxor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPXORD> Vpxord{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VPXORQ> Vpxorq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRANGEPD> Vrangepd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRANGEPS> Vrangeps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRANGESD> Vrangesd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRANGESS> Vrangess{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP14PD> Vrcp14pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP14PS> Vrcp14ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP14SD> Vrcp14sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP14SS> Vrcp14ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP23PS> Vrcp23ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP28PD> Vrcp28pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP28PS> Vrcp28ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP28SD> Vrcp28sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCP28SS> Vrcp28ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCPPH> Vrcpph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCPPS> Vrcpps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCPSH> Vrcpsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRCPSS> Vrcpss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VREDUCEPD> Vreducepd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VREDUCEPH> Vreduceph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VREDUCEPS> Vreduceps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VREDUCESD> Vreducesd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VREDUCESH> Vreducesh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VREDUCESS> Vreducess{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDFXPNTPD> Vrndfxpntpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDFXPNTPS> Vrndfxpntps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDSCALEPD> Vrndscalepd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDSCALEPH> Vrndscaleph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDSCALEPS> Vrndscaleps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDSCALESD> Vrndscalesd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDSCALESH> Vrndscalesh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRNDSCALESS> Vrndscaless{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VROUNDPD> Vroundpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VROUNDPS> Vroundps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VROUNDSD> Vroundsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VROUNDSS> Vroundss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT14PD> Vrsqrt14pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT14PS> Vrsqrt14ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT14SD> Vrsqrt14sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT14SS> Vrsqrt14ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT23PS> Vrsqrt23ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT28PD> Vrsqrt28pd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT28PS> Vrsqrt28ps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT28SD> Vrsqrt28sd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRT28SS> Vrsqrt28ss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRTPH> Vrsqrtph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRTPS> Vrsqrtps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRTSH> Vrsqrtsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VRSQRTSS> Vrsqrtss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEFPD> Vscalefpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEFPH> Vscalefph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEFPS> Vscalefps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEFSD> Vscalefsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEFSH> Vscalefsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEFSS> Vscalefss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCALEPS> Vscaleps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERDPD> Vscatterdpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERDPS> Vscatterdps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF0DPD> Vscatterpf0dpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF0DPS> Vscatterpf0dps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF0HINTDPD> Vscatterpf0hintdpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF0HINTDPS> Vscatterpf0hintdps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF0QPD> Vscatterpf0qpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF0QPS> Vscatterpf0qps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF1DPD> Vscatterpf1dpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF1DPS> Vscatterpf1dps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF1QPD> Vscatterpf1qpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERPF1QPS> Vscatterpf1qps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERQPD> Vscatterqpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSCATTERQPS> Vscatterqps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSHUFF32X4> Vshuff32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSHUFF64X2> Vshuff64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSHUFI32X4> Vshufi32x4{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSHUFI64X2> Vshufi64x2{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSHUFPD> Vshufpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSHUFPS> Vshufps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSQRTPD> Vsqrtpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSQRTPH> Vsqrtph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSQRTPS> Vsqrtps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSQRTSD> Vsqrtsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSQRTSH> Vsqrtsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSQRTSS> Vsqrtss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSTMXCSR> Vstmxcsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBPD> Vsubpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBPH> Vsubph{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBPS> Vsubps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBRPD> Vsubrpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBRPS> Vsubrps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBSD> Vsubsd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBSH> Vsubsh{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VSUBSS> Vsubss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VTESTPD> Vtestpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VTESTPS> Vtestps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUCOMISD> Vucomisd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUCOMISH> Vucomish{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUCOMISS> Vucomiss{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUNPCKHPD> Vunpckhpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUNPCKHPS> Vunpckhps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUNPCKLPD> Vunpcklpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VUNPCKLPS> Vunpcklps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VXORPD> Vxorpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VXORPS> Vxorps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VZEROALL> Vzeroall{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_VZEROUPPER> Vzeroupper{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WBINVD> Wbinvd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRFSBASE> Wrfsbase{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRGSBASE> Wrgsbase{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRMSR> Wrmsr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRPKRU> Wrpkru{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRSSD> Wrssd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRSSQ> Wrssq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRUSSD> Wrussd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_WRUSSQ> Wrussq{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XABORT> Xabort{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XADD> Xadd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XBEGIN> Xbegin{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XCHG> Xchg{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XCRYPT_CBC> Xcrypt_cbc{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XCRYPT_CFB> Xcrypt_cfb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XCRYPT_CTR> Xcrypt_ctr{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XCRYPT_ECB> Xcrypt_ecb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XCRYPT_OFB> Xcrypt_ofb{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XEND> Xend{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XGETBV> Xgetbv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XLAT> Xlat{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XOR> Xor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XORPD> Xorpd{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XORPS> Xorps{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XRESLDTRK> Xresldtrk{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XRSTOR> Xrstor{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XRSTOR64> Xrstor64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XRSTORS> Xrstors{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XRSTORS64> Xrstors64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVE> Xsave{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVE64> Xsave64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVEC> Xsavec{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVEC64> Xsavec64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVEOPT> Xsaveopt{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVEOPT64> Xsaveopt64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVES> Xsaves{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSAVES64> Xsaves64{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSETBV> Xsetbv{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSHA1> Xsha1{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSHA256> Xsha256{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSTORE> Xstore{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XSUSLDTRK> Xsusldtrk{};
        static constexpr detail::Mnemonic<ZYDIS_MNEMONIC_XTEST> Xtest{};
    } // namespace Mnemonic

    constexpr bool isBranching(zasm::InstrMnemonic mnemonic)
    {
        switch (mnemonic)
        {
            case Mnemonic::Call:
            case Mnemonic::Ret:
            case Mnemonic::Jb:
            case Mnemonic::Jbe:
            case Mnemonic::Jcxz:
            case Mnemonic::Jecxz:
            case Mnemonic::Jknzd:
            case Mnemonic::Jkzd:
            case Mnemonic::Jl:
            case Mnemonic::Jle:
            case Mnemonic::Jmp:
            case Mnemonic::Jnb:
            case Mnemonic::Jnbe:
            case Mnemonic::Jnl:
            case Mnemonic::Jnle:
            case Mnemonic::Jno:
            case Mnemonic::Jnp:
            case Mnemonic::Jns:
            case Mnemonic::Jnz:
            case Mnemonic::Jo:
            case Mnemonic::Jp:
            case Mnemonic::Jrcxz:
            case Mnemonic::Js:
            case Mnemonic::Jz:
                return true;
        }

        return false;
    }

    constexpr bool isBranching(const InstructionBase& instr)
    {
        return isBranching(instr.getMnemonic());
    }

    constexpr bool isCondBranching(zasm::InstrMnemonic mnemonic)
    {
        switch (mnemonic)
        {
            case Mnemonic::Jb:
            case Mnemonic::Jbe:
            case Mnemonic::Jcxz:
            case Mnemonic::Jecxz:
            case Mnemonic::Jknzd:
            case Mnemonic::Jkzd:
            case Mnemonic::Jl:
            case Mnemonic::Jle:
            case Mnemonic::Jnb:
            case Mnemonic::Jnbe:
            case Mnemonic::Jnl:
            case Mnemonic::Jnle:
            case Mnemonic::Jno:
            case Mnemonic::Jnp:
            case Mnemonic::Jns:
            case Mnemonic::Jnz:
            case Mnemonic::Jo:
            case Mnemonic::Jp:
            case Mnemonic::Jrcxz:
            case Mnemonic::Js:
            case Mnemonic::Jz:
                return true;
        }

        return false;
    }

    constexpr bool isCondBranching(const InstructionBase& instr)
    {
        return isCondBranching(instr.getMnemonic());
    }

    constexpr bool isSyscall(zasm::InstrMnemonic mnemonic)
    {
        return mnemonic == Mnemonic::Syscall;
    }

    constexpr bool isSyscall(const InstructionBase& instr)
    {
        return isSyscall(instr.getMnemonic());
    }

    constexpr bool isCall(zasm::InstrMnemonic mnemonic)
    {
        return mnemonic == Mnemonic::Call;
    }

    constexpr bool isCall(const InstructionBase& instr)
    {
        return isCall(instr.getMnemonic());
    }

    constexpr bool isRet(zasm::InstrMnemonic mnemonic)
    {
        return mnemonic == Mnemonic::Ret;
    }

    constexpr bool isRet(const InstructionBase& instr)
    {
        return isRet(instr.getMnemonic());
    }

    constexpr bool isJmp(zasm::InstrMnemonic mnemonic)
    {
        return mnemonic == Mnemonic::Jmp;
    }

    constexpr bool isJmp(const InstructionBase& instr)
    {
        return isJmp(instr.getMnemonic());
    }

} // namespace zasm::x86
