# Awesome AI books

Some awesome AI related books and pdfs for downloading and learning.

## Preface

**This repo only used for learning, do not use in business.**

Welcome for providing great books in this repo or tell me which great book you need and I will try to append it in this repo, any idea you can create issue or PR here.

Due to github Large file storage limition, all books pdf stored in **Yandex.Disk**.

Some often used **Mathematic Symbols** can refer this [page](https://github.com/zslucky/awesome-AI-books/blob/master/math-symbols.md)

## Content
- [Organization with papers/researchs](https://github.com/zslucky/awesome-AI-books#organization-with-papersresearchs)
- [Training ground](https://github.com/zslucky/awesome-AI-books#training-ground)
- [Books](https://github.com/zslucky/awesome-AI-books#books)
  - [Introductory theory and get start](https://github.com/zslucky/awesome-AI-books#introductory-theory-and-get-start)
  - [Mathematics](https://github.com/zslucky/awesome-AI-books#mathematics)
  - [Data mining](https://github.com/zslucky/awesome-AI-books#data-mining)
  - [Deep Learning](https://github.com/zslucky/awesome-AI-books#deep-learning)
  - [Philosophy](https://github.com/zslucky/awesome-AI-books#philosophy)
- [Quantum with AI](https://github.com/zslucky/awesome-AI-books#quantum-with-ai)
  - [Quantum Basic](https://github.com/zslucky/awesome-AI-books#quantum-basic)
  - [Quantum AI](https://github.com/zslucky/awesome-AI-books#quantum-ai)
  - [Quantum Related Framework](https://github.com/zslucky/awesome-AI-books#quantum-related-framework)
- [Libs With Online Books](https://github.com/zslucky/awesome-AI-books#libs-with-online-books)
  - [Reinforcement Learning](https://github.com/zslucky/awesome-AI-books#reinforcement-learning)
  - [Feature Selection](https://github.com/zslucky/awesome-AI-books#feature-selection)
  - [Machine Learning](https://github.com/zslucky/awesome-AI-books#machine-learning-1)
  - [Deep Learning](https://github.com/zslucky/awesome-AI-books#deep-learning-1)
  - [NLP](https://github.com/zslucky/awesome-AI-books#nlp)
  - [CV](https://github.com/zslucky/awesome-AI-books#cv)
  - [Meta Learning](https://github.com/zslucky/awesome-AI-books#meta-learning)
  - [Transfer Learning](https://github.com/zslucky/awesome-AI-books#transfer-learning)
  - [Auto ML](https://github.com/zslucky/awesome-AI-books#auto-ml)
  - [Dimensionality Reduction](https://github.com/zslucky/awesome-AI-books#dimensionality-reduction)
- [Distributed training](https://github.com/zslucky/awesome-AI-books#distributed-training)

## Organization with papers/researchs

- [arxiv.org](https://arxiv.org/)
- [Science](http://www.sciencemag.org/)
- [Nature](https://www.nature.com/nature/)
- [DeepMind Publications](https://deepmind.com/research/publications/)
- [OpenAI Research](https://openai.com/research/)

## Training ground

- [OpenAI Gym](https://gym.openai.com/): A toolkit for developing and comparing reinforcement learning algorithms. (Can play with [Atari](https://en.wikipedia.org/wiki/Atari), Box2d, MuJoCo etc...)
- [malmo](https://github.com/Microsoft/malmo): Project Malmö is a platform for Artificial Intelligence experimentation and research built on top of Minecraft. 
- [DeepMind Pysc2](https://github.com/deepmind/pysc2): StarCraft II Learning Environment.
- [Procgen](https://github.com/openai/procgen): Procgen Benchmark: Procedurally-Generated Game-Like Gym-Environments.
- [TorchCraftAI](https://torchcraft.github.io/TorchCraftAI/): A bot platform for machine learning research on StarCraft®: Brood War®
- [Valve Dota2](https://developer.valvesoftware.com/wiki/Dota_Bot_Scripting): Dota2 game acessing api. ([CN doc](https://developer.valvesoftware.com/wiki/Dota_Bot_Scripting:zh-cn))
- [Mario AI Framework](https://github.com/amidos2006/Mario-AI-Framework): A Mario AI framework for using AI methods.
- [Google Dopamine](https://github.com/google/dopamine): Dopamine is a research framework for fast prototyping of reinforcement learning algorithms
- [TextWorld](https://github.com/Microsoft/TextWorld): Microsoft - A learning environment sandbox for training and testing reinforcement learning (RL) agents on text-based games.
- [Mini Grid](https://github.com/maximecb/gym-minigrid): Minimalistic gridworld environment for OpenAI Gym
- [MAgent](https://github.com/geek-ai/MAgent): A Platform for Many-agent Reinforcement Learning
- [XWorld](https://github.com/PaddlePaddle/XWorld): A C++/Python simulator package for reinforcement learning
- [Neural MMO](https://github.com/openai/neural-mmo): A Massively Multiagent Game Environment
- [MinAtar](https://github.com/kenjyoung/MinAtar): MinAtar is a testbed for AI agents which implements miniaturized version of several Atari 2600 games.
- [craft-env](https://github.com/Feryal/craft-env): CraftEnv is a 2D crafting environment
- [gym-sokoban](https://github.com/mpSchrader/gym-sokoban): Sokoban is Japanese for warehouse keeper and a traditional video game
- [Pommerman](https://github.com/MultiAgentLearning/playground) Playground hosts Pommerman, a clone of Bomberman built for AI research.
- [gym-miniworld](https://github.com/maximecb/gym-miniworld#introduction) MiniWorld is a minimalistic 3D interior environment simulator for reinforcement learning & robotics research
- [vizdoomgym](https://github.com/shakenes/vizdoomgym) OpenAI Gym wrapper for [ViZDoom](https://github.com/mwydmuch/ViZDoom) (A Doom-based AI Research Platform for Reinforcement Learning from Raw Visual Information) enviroments.
- [ddz-ai](https://github.com/freefuiiismyname/ddz-ai) 以孤立语假设和宽度优先搜索为基础，构建了一种多通道堆叠注意力Transformer结构的斗地主ai


## Books

### Introductory theory and get start

- [Artificial Intelligence-A Modern Approach (3rd Edition)](https://yadi.sk/i/G6NlUUV8SAVimg) - Stuart Russell & peter Norvig
- **COMMERCIAL** [Grokking Artificial Intelligence Algorithms](https://www.manning.com/books/grokking-artificial-intelligence-algorithms) - Rishal Hurbans

### Mathematics

- [A First Course in ProbabilityA First Course in Probability (8th)](https://yadi.sk/i/aDvGdqWlcXxbhQ) - Sheldon M Ross
- [Convex Optimization](https://yadi.sk/i/9KGVXuFJs3kakg) - Stephen Boyd
- [Elements of Information Theory Elements](https://yadi.sk/i/2YWnNsAeBc9qcA) - Thomas Cover & Jay A Thomas
- [Discrete Mathematics and Its Applications 7th](https://yadi.sk/i/-r3jD4gB-8jn1A) - Kenneth H. Rosen
- [Introduction to Linear Algebra (5th)](http://www.mediafire.com/file/f31dl0ghup7e6gk/Introduction_to_Linear_Algebra_5th_-_Gilbert_Strang.pdf/file) - Gilbert Strang
- [Linear Algebra and Its Applications (5th)](https://yadi.sk/i/uWEQVrCquqw1Ug) - David C Lay
- [Probability Theory The Logic of Science](https://yadi.sk/i/TKQYNPSKGNbdUw) - Edwin Thompson Jaynes
- [Probability and Statistics 4th](https://yadi.sk/i/38jrMmEXnJQZqg) - Morris H. DeGroot
- [Statistical Inference (2nd)](https://yadi.sk/i/HWrbKYrYdpNMYw) - Roger Casella
- [信息论基础 (原书Elements of Information Theory Elements第2版)](https://yadi.sk/i/HqGOyAkRCxCwIQ) - Thomas Cover & Jay A Thomas
- [凸优化 (原书Convex Optimization)](https://yadi.sk/i/zUPPAi58v1gfkw) - Stephen Boyd
- [数理统计学教程](https://yadi.sk/i/ikuXCrNgRCEVnw) - 陈希儒
- [数学之美 2th](https://yadi.sk/i/QJPxzK4ZBuF8iQ) - 吴军
- [概率论基础教程 (原书A First Course in ProbabilityA First Course in Probability第9版)](https://yadi.sk/i/wQZQ80UFLFZ48w) - Sheldon M Ross
- [线性代数及其应用 (原书Linear Algebra and Its Applications第3版)](https://yadi.sk/i/cNNBS4eaLleR3g) - David C Lay
- [统计推断 (原书Statistical Inference第二版)](https://yadi.sk/i/ksHAFRUSaoyk9g) - Roger Casella
- [离散数学及其应用 (原书Discrete Mathematics and Its Applications第7版)](https://yadi.sk/i/kJHMmMA4ot66bw) - Kenneth H.Rosen

### Data mining

- [Introduction to Data Mining](https://yadi.sk/i/H7wc_FaMDl9QXQ) - Pang-Ning Tan
- [Programming Collective Intelligence](https://yadi.sk/i/YTjrJWu7kXVrGQ) - Toby Segaran
- [Feature Engineering for Machine Learning](https://yadi.sk/i/WiO7lageMIuIfg) - Amanda Casari, Alice Zheng
- [集体智慧编程](https://yadi.sk/i/0DW5reTrXQ6peQ) - Toby Segaran

### Machine Learning

- [Information Theory, Inference and Learning Algorithms](https://yadi.sk/i/JXYto8yE6PJO8Q) - David J C MacKay
- [Machine Learning](https://yadi.sk/i/03Jg9WMzgD2YlA) - Tom M. Mitchell
- [Pattern Recognition and Machine Learning](https://yadi.sk/i/8ffTCaMH0bM8uQ) - Christopher Bishop
- [The Elements of Statistical Learning](https://yadi.sk/i/hfatiRyBCwfcWw) - Trevor Hastie
- [Machine Learning for OpenCV](https://yadi.sk/i/_UdlHqwuR-Wdxg) - Michael Beyeler ([Source code here](https://github.com/zslucky/awesome-AI-books/tree/master/resources/Machine%20Learning%20for%20OpenCV))
- [机器学习](https://yadi.sk/i/vfoPTRRfgtEQKA) - 周志华
- [机器学习 (原书Machine Learning)](https://yadi.sk/i/jTNv4kzG-lmlYQ) - Tom M. Mitchell
- [统计学习方法](https://yadi.sk/i/R08dbDMOJb3KKw) - 李航

### Deep Learning
- Online Quick learning
  - [Dive into Deep Learning](https://d2l.ai/) - (Using MXNet)An interactive deep learning book with code, math, and discussions.
  - [d2l-pytorch](https://github.com/dsgiitr/d2l-pytorch) - (Dive into Deep Learning) pytorch version.
  - [动手学深度学习](https://zh.d2l.ai/) - (Dive into Deep Learning) for chinese.
- [Deep Learning](https://yadi.sk/i/2fOK_Xib-JlocQ) - Ian Goodfellow & Yoshua Bengio & Aaron Courville
- [Deep Learning Methods and Applications](https://yadi.sk/i/uQAWfeKVmenmkg) - Li Deng & Dong Yu
- [Learning Deep Architectures for AI](https://yadi.sk/i/AWpRq2hSB9RmoQ) - Yoshua Bengio
- [Machine Learning An Algorithmic Perspective (2nd)](https://yadi.sk/i/1gOQ-Y5r4uP6Kw) - Stephen Marsland
- [Neural Network Design (2nd)](https://yadi.sk/i/5LLMPfNcuaPTvQ) - Martin Hagan
- [Neural Networks and Learning Machines (3rd)](https://yadi.sk/i/6s9AauRP1OGT2Q) - Simon Haykin
- [Neural Networks for Applied Sciences and Engineering](https://yadi.sk/i/JK7aj5TsmoC1dA) - Sandhya Samarasinghe
- [深度学习 (原书Deep Learning)](https://yadi.sk/i/DzzZU_QPosSTBQ) - Ian Goodfellow & Yoshua Bengio & Aaron Courville
- [神经网络与机器学习 (原书Neural Networks and Learning Machines)](https://yadi.sk/i/ogQff9JpLEdHMg) - Simon Haykin
- [神经网络设计 (原书Neural Network Design)](https://yadi.sk/i/uR2OAHHgnZHUuw) - Martin Hagan
- **COMMERCIAL** [Interpretable AI](https://www.manning.com/books/interpretable-ai) - Ajay Thampi
- **COMMERCIAL** [Conversational AI](https://www.manning.com/books/conversational-ai) - Andrew R. Freed

### Philosophy
- **COMMERCIAL** [Human Compatible: Artificial Intelligence and the Problem of Control](https://www.amazon.com/Human-Compatible-Artificial-Intelligence-Problem-ebook/dp/B07N5J5FTS) - Stuart Russell
- **COMMERCIAL** [Life 3.0: Being Human in the Age of Artificial Intelligence](https://www.amazon.com/Life-3-0-Being-Artificial-Intelligence/dp/1101946598) - Max Tegmark
- **COMMERCIAL** [Superintelligence: Paths, Dangers, Strategies](https://www.amazon.com/Superintelligence-Dangers-Strategies-Nick-Bostrom/dp/0198739834/ref=pd_sbs_14_t_0/146-0357100-6717505?_encoding=UTF8&pd_rd_i=0198739834&pd_rd_r=676ace91-552c-4865-a8d3-6273db5418bf&pd_rd_w=zYEu2&pd_rd_wg=hQdGQ&pf_rd_p=5cfcfe89-300f-47d2-b1ad-a4e27203a02a&pf_rd_r=DTH77KT4FSVRMJ47GBVQ&psc=1&refRID=DTH77KT4FSVRMJ47GBVQ) - Nick Bostrom

## Quantum with AI

- #### Quantum Basic
  - [Quantum Computing Primer](https://www.dwavesys.com/tutorials/background-reading-series/quantum-computing-primer#h1-0) - D-Wave quantum computing primer
  - [Quantum computing 101](https://uwaterloo.ca/institute-for-quantum-computing/quantum-computing-101) - Quantum computing 101, from University of Waterloo
  - [pdf](https://yadi.sk/i/0VCfWmb3HrrPuw) Quantum Computation and Quantum Information - Nielsen
  - [pdf](https://yadi.sk/i/mHoyVef8RaG0aA) 量子计算和量子信息（量子计算部分）- Nielsen
- #### Quantum AI
  - [Quantum neural networks](http://axon.cs.byu.edu/papers/ezhov.fdisis00.pdf)
  - [An Artificial Neuron Implemented on an Actual Quantum Processor](https://arxiv.org/pdf/1811.02266.pdf)
  - [Classification with Quantum Neural Networks on Near Term Processors](https://arxiv.org/pdf/1802.06002.pdf)
  - [Black Holes as Brains: Neural Networks with Area Law Entropy](https://arxiv.org/pdf/1801.03918.pdf)
- #### Quantum Related Framework
  - [ProjectQ](https://github.com/ProjectQ-Framework/ProjectQ) - ProjectQ is an open source effort for quantum computing.

## Libs With Online Books
- #### GC (Generative Content)
  - [Stable Diffusion](https://github.com/CompVis/stable-diffusion) - [[Paper](https://arxiv.org/abs/2112.10752)] A latent text-to-image diffusion model
  - [Stable Diffusion V2](https://github.com/Stability-AI/stablediffusion) - High-Resolution Image Synthesis with Latent Diffusion Models
  - [GFPGAN](https://github.com/TencentARC/GFPGAN) - [[Paper](https://arxiv.org/abs/2101.04061)] GFPGAN aims at developing Practical Algorithms for Real-world Face Restoration.
  - [ESRGAN](https://github.com/xinntao/ESRGAN) - [[Paper](https://arxiv.org/abs/2107.10833)] ECCV18 Workshops - Enhanced SRGAN. Champion PIRM Challenge on Perceptual Super-Resolution. The training codes are in BasicSR.
  - [CodeFormer](https://github.com/sczhou/CodeFormer) - [[Paper](https://arxiv.org/abs/2206.11253)] - [NeurIPS 2022] Towards Robust Blind Face Restoration with Codebook Lookup Transformer
  - [UniPC](https://github.com/wl-zhao/UniPC) - [[Paper](https://arxiv.org/abs/2302.04867)] UniPC: A Unified Predictor-Corrector Framework for Fast Sampling of Diffusion Models
- #### Reinforcement Learning
  - [A3C](https://arxiv.org/pdf/1602.01783.pdf) - Google DeepMind Asynchronous Advantage Actor-Critic algorithm
  - [Q-Learning](http://www.gatsby.ucl.ac.uk/~dayan/papers/cjch.pdf) SARSA [DQN](https://storage.googleapis.com/deepmind-media/dqn/DQNNaturePaper.pdf) [DDQN](https://arxiv.org/pdf/1509.06461.pdf) - Q-Learning is a value-based Reinforcement Learning algorithm
  - [DDPG](https://arxiv.org/pdf/1509.02971.pdf) - Deep Deterministic Policy Gradient,
  - [Large-Scale Curiosity](https://arxiv.org/pdf/1808.04355.pdf) - Large-Scale Study of Curiosity-Driven Learning
  - [PPO](https://arxiv.org/pdf/1707.06347.pdf) - OpenAI Proximal Policy Optimization Algorithms
  - [RND](https://arxiv.org/pdf/1810.12894.pdf) - OpenAI Random Network Distillation, an exploration bonus for deep reinforcement learning method.
  - [VIME](https://arxiv.org/pdf/1605.09674.pdf) - OpenAI Variational Information Maximizing Exploration
  - [DQV](https://arxiv.org/pdf/1810.00368.pdf) - Deep Quality-Value (DQV) Learning
  - [ERL](https://arxiv.org/pdf/1805.07917.pdf) - Evolution-Guided Policy Gradient in Reinforcement Learning
  - [MF Multi-Agent RL](https://arxiv.org/pdf/1802.05438.pdf) - Mean Field Multi-Agent Reinforcement Learning. (this paper include MF-Q and MF-AC)
  - [MAAC](https://arxiv.org/pdf/1810.02912.pdf) - Actor-Attention-Critic for Multi-Agent Reinforcement Learning
- #### Feature Selection
  - [scikit-feature](http://featureselection.asu.edu/algorithms.php) - A collection of feature selection algorithms, available on [Github](https://github.com/jundongl/scikit-feature)
- #### Machine Learning
  - [Scikit learn](https://scikit-learn.org/stable/) (**Python**) - Machine Learning in Python.
  - [Linfa](https://github.com/rust-ml/linfa) (**Rust**) - spirit of `scikit learn`, a rust ML lib.
  - [Xgboost](https://xgboost.readthedocs.io/en/latest/tutorials/model.html) (**Python, R, JVM, Julia, CLI**) - Xgboost lib's document.
  - [LightGBM](https://lightgbm.readthedocs.io/en/latest/Features.html#) (**Python, R, CLI**) - Microsoft lightGBM lib's features document.
  - [CatBoost](https://arxiv.org/pdf/1706.09516.pdf) (**Python, R, CLI**) - Yandex Catboost lib's key algorithm pdf papper.
  - [StackNet](https://github.com/kaz-Anova/StackNet) (**Java, CLI**) - Some model stacking algorithms implemented in this lib.
  - [RGF](https://arxiv.org/pdf/1109.0887.pdf) - Learning Nonlinear Functions Using `Regularized Greedy Forest` (multi-core implementation [FastRGF](https://github.com/RGF-team/rgf/tree/master/FastRGF))
  - [FM](https://www.csie.ntu.edu.tw/~b97053/paper/Rendle2010FM.pdf), [FastFM](https://arxiv.org/pdf/1505.00641.pdf), [FFM](https://arxiv.org/pdf/1701.04099.pdf), [XDeepFM](https://arxiv.org/pdf/1803.05170.pdf) - Factorization Machines and some extended Algorithms
- #### Deep Learning
  - [GNN Papers](https://github.com/thunlp/GNNPapers) - Must-read papers on graph neural networks (GNN)
  - [EfficientNet](https://arxiv.org/pdf/1905.11946.pdf) - Rethinking Model Scaling for Convolutional Neural Networks
  - [DenseNet](https://arxiv.org/pdf/1608.06993.pdf) - Densely Connected Convolutional Networks
- #### NLP
  - [XLNet](https://arxiv.org/pdf/1906.08237.pdf) - [repo](https://github.com/zihangdai/xlnet) XLNet: Generalized Autoregressive Pretraining for Language Understanding
  - [BERT](https://arxiv.org/pdf/1810.04805.pdf) - Pre-training of Deep Bidirectional Transformers for Language Understanding
  - [GPT-3](https://arxiv.org/pdf/2005.14165.pdf) - Language Models are Few-Shot Learners
- #### CV
  - [Fast R-CNN](https://arxiv.org/pdf/1504.08083.pdf) - Fast Region-based Convolutional Network method (Fast R-CNN) for object detection
  - [Mask R-CNN](https://arxiv.org/pdf/1703.06870.pdf) - Mask R-CNN, extends Faster R-CNN by adding a branch for predicting an object mask in parallel with the existing branch for bounding box recognition.
  - [GQN](http://science.sciencemag.org/content/360/6394/1204/tab-pdf) - DeepMind Generative Query Network, Neural scene representation and rendering
- #### Meta Learning
  - [MAML](https://arxiv.org/pdf/1703.03400.pdf) - Model-Agnostic Meta-Learning for Fast Adaptation of Deep Networks
- #### Transfer Learning
  - [GCN](https://arxiv.org/pdf/1803.08035.pdf) - Zero-shot Recognition via Semantic Embeddings and Knowledge Graphs
- #### Auto ML
  - [Model Search](https://github.com/google/model_search) (**Python**) - Google Model search (MS) is a framework that implements AutoML algorithms for model architecture search at scale. 
  - [TPOT](https://github.com/EpistasisLab/tpot) (**Python**) - TPOT is a lib for AutoML.
  - [Auto-sklearn](https://automl.github.io/auto-sklearn/master/) (**Python**) - auto-sklearn is an automated machine learning toolkit and a drop-in replacement for a scikit-learn estimator
  - [Auto-Keras](https://autokeras.com/) (**Python**) - Auto-Keras is an open source software library for automated machine learning (AutoML). It is developed by DATA Lab
  - [TransmogrifAI](https://docs.transmogrif.ai/en/stable/index.html) (**JVM**) - TransmogrifAI (pronounced trăns-mŏgˈrə-fī) is an AutoML library written in Scala that runs on top of Spark
  - [Auto-WEKAA](http://www.cs.ubc.ca/labs/beta/Projects/autoweka/) - Provides automatic selection of models and hyperparameters for [WEKA](https://www.cs.waikato.ac.nz/ml/weka/).
  - [MLBox](https://github.com/AxeldeRomblay/MLBox) (**Python**) - MLBox is a powerful Automated Machine Learning python library
- #### Pipeline Training
  - [ZenML](https://github.com/maiot-io/zenml) (**Python**) - ZenML is built for ML practitioners who are ramping up their ML workflows towards production
- #### Dimensionality Reduction
  - [t-SNE](http://www.cs.toronto.edu/~hinton/absps/tsne.pdf) (**Non-linear/Non-params**) - T-distributed Stochastic Neighbor Embedding (t-SNE) is a machine learning algorithm for visualization
  - [PCA](https://www.cs.cmu.edu/~elaw/papers/pca.pdf) (**Linear**) - Principal component analysis
  - [LDA](https://www.isip.piconepress.com/publications/reports/1998/isip/lda/lda_theory.pdf) (**Linear**) - Linear Discriminant Analysis
  - [LLE](https://cs.nyu.edu/~roweis/lle/papers/lleintro.pdf) (**Non-linear**) - Locally linear embedding
  - [Laplacian Eigenmaps](http://web.cse.ohio-state.edu/~belkin.8/papers/LEM_NC_03.pdf) - Laplacian Eigenmaps for Dimensionality Reduction and Data Representation
  - [Sammon Mapping](http://homepages.inf.ed.ac.uk/rbf/CVonline/LOCAL_COPIES/AV0910/henderson.pdf) (**Non-linear**) - Sammon mapping is designed to minimise the differences between corresponding inter-point distances in the
two spaces
- #### Data Processing
  - [Pandas](https://github.com/pandas-dev/pandas) (**Python**) - Flexible and powerful data analysis / manipulation library for Python.
  - [Polars](https://github.com/pola-rs/polars) (**Rust, Python**) - Lightning-fast DataFrame library for Rust and Python.

## Distributed training
- [Horovod](https://github.com/horovod/horovod#usage) - Horovod is a distributed training framework for TensorFlow, Keras, PyTorch, and MXNet. The goal of Horovod is to make distributed Deep Learning fast and easy to use.
- [Acme](https://github.com/deepmind/acme) - A Research Framework for (Distributed) Reinforcement Learning. 
- [bagua](https://github.com/BaguaSys/bagua) - Bagua is a flexible and performant distributed training algorithm development framework.

## Support this project
![btc-clean-qrcode](https://user-images.githubusercontent.com/15725589/152709449-f6b7174b-2990-43f6-ac69-c8549fe7310c.png)
![eth-clean-qrcode](https://user-images.githubusercontent.com/15725589/152709451-6c2691f9-dec7-4b60-9d20-9fdded828c8c.png)


## Contributors

### Code Contributors

This project exists thanks to all the people who contribute. [[Contribute](CONTRIBUTING.md)].
<a href="https://github.com/zslucky/awesome-AI-books/graphs/contributors"><img src="https://opencollective.com/awesome-AI-books/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/awesome-AI-books/contribute)]

#### Individuals

<a href="https://opencollective.com/awesome-AI-books"><img src="https://opencollective.com/awesome-AI-books/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/awesome-AI-books/contribute)]

<a href="https://opencollective.com/awesome-AI-books/organization/0/website"><img src="https://opencollective.com/awesome-AI-books/organization/0/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/1/website"><img src="https://opencollective.com/awesome-AI-books/organization/1/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/2/website"><img src="https://opencollective.com/awesome-AI-books/organization/2/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/3/website"><img src="https://opencollective.com/awesome-AI-books/organization/3/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/4/website"><img src="https://opencollective.com/awesome-AI-books/organization/4/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/5/website"><img src="https://opencollective.com/awesome-AI-books/organization/5/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/6/website"><img src="https://opencollective.com/awesome-AI-books/organization/6/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/7/website"><img src="https://opencollective.com/awesome-AI-books/organization/7/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/8/website"><img src="https://opencollective.com/awesome-AI-books/organization/8/avatar.svg"></a>
<a href="https://opencollective.com/awesome-AI-books/organization/9/website"><img src="https://opencollective.com/awesome-AI-books/organization/9/avatar.svg"></a>
