---
title: 版本控制提交规范你会了吗？
date: 2020-09-07
tags:
- "开发规范"
- Java
categories:
- 规范 Standard
isShowComments: true
---

<Boxx/>



<!-- more -->

[[toc]]

## 提交规范的作用

- 提供更多的信息，方便排查与回退
- 过滤关键字，迅速定位
- 方便生成文档

## 提交规范

规范版本记录提交信息，在提交信息中描述新特性、bug 修复和破坏性变更。

提交 message 格式如下:

```text
<类型>[可选的作用域]: <描述>

[可选的正文]

[可选的脚注]
```

## 提交类别

commit 的类型，包涵以下几种：

| code            | info                                                |
| :-------------- | :-------------------------------------------------- |
| `feat: msg`     | **新功能 feature**                                  |
| `fix: msg`      | **修复 bug**                                        |
| `merge: msg`    | **merge**                                           |
| `docs: msg`     | **文档修改**                                        |
| `style: msg`    | **更改了前端样式**                                  |
| `js: msg`       | **更改了前端代码**                                  |
| `refactor: msg` | **重构：即不是新增功能，也不是修改 bug 的代码变动** |
| `test: msg`     | **增加测试**                                        |
| `chore: msg`    | **构建过程或辅助工具的变动**                        |
| `rm: msg`       | **删除文件或代码**                                  |

## 示例：

```yaml
feat($browser): onUrlChange event (popstate/hashchange/polling)

Added new event to $browser:
- forward popstate event if available
- forward hashchange event if popstate not available
- do polling when neither popstate nor hashchange available

Breaks $browser.onHashChange, which was removed (use onUrlChange instead)

---------

fix($compile): couple of unit tests for IE9

Older IEs serialize html uppercased, but IE9 does not...
Would be better to expect case insensitive, unfortunately jasmine does
not allow to user regexps for throw expectations.

Closes #392
Breaks foo.bar api, foo.baz should be used instead

---------

eat(directive): ng:disabled, ng:checked, ng:multiple, ng:readonly, ng:selected

New directives for proper binding these attributes in older browsers (IE).
Added coresponding description, live examples and e2e tests.

Closes #351

---------

feat($compile): simplify isolate scope bindings

Changed the isolate scope binding options to:
  - @attr - attribute binding (including interpolation)
  - =model - by-directional model binding
  - &expr - expression execution binding

This change simplifies the terminology as well as
number of choices available to the developer. It
also supports local name aliasing from the parent.

BREAKING CHANGE: isolate scope bindings definition has changed and
the inject option for the directive controller injection was removed.

To migrate the code follow the example below:

Before:

scope: {
  myAttr: 'attribute',
  myBind: 'bind',
  myExpression: 'expression',
  myEval: 'evaluate',
  myAccessor: 'accessor'
}

After:

scope: {
  myAttr: '@',
  myBind: '@',
  myExpression: '&',
  // myEval - usually not useful, but in cases where the expression is assignable, you can use '='
  myAccessor: '=' // in directive's template change myAccessor() to myAccessor
}

The removed `inject` wasn't generaly useful for directives so there should be no code using it.
```

当然，我们一般不用书写这么详细，在工作中简明扼要即可，如：

```yaml
feat($theme-default): add code group and code block components
```

<Reward/>

