---
title: 单元测试：JUnit4和JUnit5的主要区别
date: 2022-06-22
tags:
- 单元测试
- Java 
categories:
- 后端 Back-end
isShowComments: true
---

<Boxx/>

<!-- more -->

[[toc]]

## 1.不同的注解

大部分注解在 JUnit4 和 JUnit5 中都是一样的，但是有些是不一样的，来快速对比一下：

| 特性                                     | JUnit4       | JUnit5       |
| ---------------------------------------- | ------------ | ------------ |
| 声明一个测试方法                         | @Test        | @Test        |
| 在当前类的所有测试方法执行前要执行的方法 | @BeforeClass | @BeforeAll   |
| 在当前类的所有测试方法执行后要执行的方法 | @AfterClass  | @AfterAll    |
| 每个测试方法执行前要执行的方法           | @Before      | @BeforeEach  |
| 每个测试方法执行后要执行的方法           | @After       | @AfterEach   |
| 忽略某个测试方法或测试类                 | @Ignore      | @Disabled    |
| 动态测试用例生成工厂                     | 无此特性     | @TestFactory |
| 嵌套测试                                 | 无此特性     | @Nested      |
| 标记与过滤                               | @Category    | @Tag         |
| 注册定制扩展点                           | 无此特性     | @ExtendWith  |

可以看出，JUnit5的注解更贴切地表达了它的含义。

## 2.更多的不同

### 2.1 架构

JUnit4把所有的代码都打包到一个jar包。
JUnit5由三个子项目构成：JUnit平台(JUnit Platform)，JUnit Jupiter 和 JUnit Vintage。

- JUnit Platform：它定义了测试引擎（TestEngine）API，用于开发运行在JUnit平台上面的新的测试框架。
- JUnit Jupiter：它拥有所有的新的JUnit注解和测试引擎的实现（Implementation），这个测试引擎的实现能够测试使用新注解开发的测试代码。
- JUnit Vintage：用于支持在JUnit5平台上运行JUnit3和JUnit4编写的测试用例。

### 2.2 JDK版本要求

JUnit4需要Java5或以上版本。
JUnit5需要[Java8](https://so.csdn.net/so/search?q=Java8&spm=1001.2101.3001.7020)或以上版本。

### 2.3 断言Assertions

在JUnit4中，`org.junit.Assert`类拥有所有的断言方法，用于判断输出的结果和期望的值是否相等。它们接受额外的错误描述信息作为方法的第一个参数，比如：

```java
public static void assertEquals(long expected, long actual)
public static void assertEquals(String message, long expected, long actual)
```

在JUnit5中，`org.junit.jupiter.Assertions`包含了大部分assert()系列方法，并且还包含了assertThrows()、assertAll()系列方法。
JUnit5断言方法也有响应的重载实现，用于支持解析错误描述消息，在测试用例执行失败的时候，会输出错误描述信息，比如：

```java
public static void assertEquals(long expected, long actual)
public static void assertEquals(long expected, long actual, String message)
public static void assertEquals(long expected, long actual, Supplier messageSupplier)
```

### 2.4 假定Assumptions

在JUnit4中，`org.junit.Assume`包含了用于假定条件满足的方法，只有满足了这些条件时，测试用例的执行才有意义。它有如下的五个方法：

```java
assumeFalse()
assumeNoException()
assumeNotNull()
assumeThat()
assumeTrue()
```

在JUnit5中，`org.junit.jupiter.api.Assumptions`包含了用于假定条件满足的方法，只有满足了这些条件时，测试用例的执行才有意义。它有如下的三个方法：

```java
assumeFalse()
assumingThat()
assumeTrue()
```

### 2.5 标记与过滤

在JUnit4中，使用`@Category`注解，在JUnit5中，使用`@Tag`注解。

### 2.6 测试用例簇（Test Suites）

在JUnit4中，通过`@RunWith`和`@Suite`注解来指定测试用例簇，比如：

```java
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(Suite.class)
@Suite.SuiteClasses({
        ExceptionTest.class,
        TimeoutTest.class
})
public class JUnit4Example{
}
```

在JUnit5中，通过`@Suite`，`@SelectPackages`和`@SelectedClasses`注解来指定测试用例簇，比如：

```java
import org.junit.platform.runner.JUnitPlatform;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.runner.RunWith;

@Suite
@SelectPackages("com.howtodoinjava.junit5.examples")
public class JUnit5Example{
}
```

### 2.7 JUnit5允许测试非public方法

在JUnit5中，测试类和测试方法不要求一定是public的，我们可以让它们是包作用域的（比如类没有public修饰，方法是protected或者private的，都可以执行）。JUnit5内部使用了反射去寻找测试类和测试方法。反射可以发现非public方法，所以测试类和测试方法就不用非得是public的了。
JUnit5中，测试类也可以没有public构造器，甚至可以有具有参数的构造器，这意味着，拥有无参且public的构造器在JUnit5中不再是强制的了。
比如：

```java
class AppTest {

    private AppTest(TestInfo testInfo) {
        System.out.println("Working on test " + testInfo.getDisplayName());
    }

    @Test
    void test(){
        assertTrue(true);
    }

}
```

### 2.8 第三方集成

在JUnit4中，没有支持与第三方插件或者IDE的集成。如果要集成，需要依赖反射。
JUnit5中，专门有一个子项目用于支持与第三方集成，即JUnit Platform。它定义了测试引擎（TestEngine）API，用于开发运行在JUnit5测试平台上运行的测试框架。

## 3.结论

在这篇JUnit教程中，我们学习了JUnit4和JUnit5的重要区别，和用它们编写的测试用例的区别。虽然它们底层有很多不同，但是主要的不同还是JUnit5引入了多个模块，并且支持第三方编写自定义的运行时引擎。
