ALTER TABLE ZL_MANAGER 
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_MANAGER CASCADE CONSTRAINTS
/

CREATE TABLE ZL_MANAGER
(
  ADMINID               INTEGER,
  ADMINNAME             NVARCHAR2(20) CONSTRAINT ZL_MANAGER_NN NOT NULL,
  ADMINPASSWORD         VARCHAR2(50 BYTE)       NOT NULL,
  USERNAME              NVARCHAR2(20)           NOT NULL,
  ENABLEMULTILOGIN      CHAR(1 BYTE)            DEFAULT '0'                   NOT NULL,
  LOGINTIMES            INTEGER                 DEFAULT 0,
  LASTLOGINIP           VARCHAR2(20 BYTE)       DEFAULT '',
  LASTLOGINTIME         DATE                    DEFAULT SYSDATE,
  LASTLOGOUTTIME        DATE                    DEFAULT SYSDATE,
  LASTMODIFYPWDTIME     DATE                    DEFAULT SYSDATE,
  ISLOCK                CHAR(1 BYTE)            DEFAULT '0',
  ENABLEMODIFYPASSWORD  CHAR(1 BYTE)            DEFAULT '0',
  ADMINROLE             VARCHAR2(1000 BYTE)     DEFAULT '',
  THEME                 VARCHAR2(50 BYTE)       DEFAULT '',
  RANDNUMBER            VARCHAR2(20 BYTE)       DEFAULT ''
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_MANAGER IS '̨ԱϢ'
/

COMMENT ON COLUMN ZL_MANAGER.ADMINID IS 'ԱID'
/

COMMENT ON COLUMN ZL_MANAGER.ADMINNAME IS 'Ա'
/

COMMENT ON COLUMN ZL_MANAGER.ADMINPASSWORD IS 'Ա'
/

COMMENT ON COLUMN ZL_MANAGER.USERNAME IS 'ǰ̨Ա'
/

COMMENT ON COLUMN ZL_MANAGER.ENABLEMULTILOGIN IS 'Ƿ˵¼'
/

COMMENT ON COLUMN ZL_MANAGER.LOGINTIMES IS '¼'
/

COMMENT ON COLUMN ZL_MANAGER.LASTLOGINIP IS '¼IP'
/

COMMENT ON COLUMN ZL_MANAGER.LASTLOGINTIME IS '¼ʱ'
/

COMMENT ON COLUMN ZL_MANAGER.LASTLOGOUTTIME IS '˳̨ʱ'
/

COMMENT ON COLUMN ZL_MANAGER.LASTMODIFYPWDTIME IS '޸ʱ'
/

COMMENT ON COLUMN ZL_MANAGER.ISLOCK IS 'Ƿ'
/

COMMENT ON COLUMN ZL_MANAGER.ENABLEMODIFYPASSWORD IS 'Ƿ޸'
/

COMMENT ON COLUMN ZL_MANAGER.ADMINROLE IS 'Աɫ'
/

COMMENT ON COLUMN ZL_MANAGER.THEME IS '̨ҳ'
/


ALTER TABLE ZL_ADVERTISEMENT
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_ADVERTISEMENT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_ADVERTISEMENT
(
  ADID         INTEGER,
  USERID       INTEGER                          DEFAULT 0,
  ADTYPE       INTEGER                          DEFAULT 1                     NOT NULL,
  ADNAME       NVARCHAR2(100)                   DEFAULT ''                    NOT NULL,
  IMGURL       VARCHAR2(255 BYTE)               DEFAULT '',
  IMGWIDTH     INTEGER                          DEFAULT 0,
  IMGHEIGHT    INTEGER                          DEFAULT 0,
  FLASHWMODE   INTEGER                          DEFAULT 0,
  ADINTRO      NCLOB                            DEFAULT '',
  LINKURL      VARCHAR2(255 BYTE)               DEFAULT '',
  LINKTARGET   INTEGER                          DEFAULT 0,
  LINKALT      VARCHAR2(255 BYTE)               DEFAULT '',
  PRIORITY     INTEGER                          DEFAULT 0,
  SETTING      NCLOB                            DEFAULT '',
  COUNTVIEW    CHAR(1 BYTE)                     DEFAULT '0',
  VIEWSCOUNT   INTEGER                          DEFAULT 0,
  COUNTCLICK   CHAR(1 BYTE)                     DEFAULT '0',
  CLICKS       INTEGER                          DEFAULT 0,
  PASSED       CHAR(1 BYTE)                     DEFAULT '0',
  OVERDUEDATE  DATE                             DEFAULT SYSDATE
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (ADINTRO) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
  LOB (SETTING) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_ADVERTISEMENT IS 'Ϣ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.ADID IS 'ID'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.USERID IS 'ûID'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.ADTYPE IS ''
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.ADNAME IS ''
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.IMGURL IS 'ͼƬ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.IMGWIDTH IS 'ͼƬ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.IMGHEIGHT IS 'ͼƬ߶'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.FLASHWMODE IS '任ģʽ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.ADINTRO IS ''
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.LINKURL IS 'Ŀ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.LINKTARGET IS 'Ŀ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.LINKALT IS 'ʾ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.PRIORITY IS 'ȼ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.SETTING IS ''
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.COUNTVIEW IS 'Ƿʾ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.VIEWSCOUNT IS 'ʾ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.COUNTCLICK IS 'Ƿ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.CLICKS IS ''
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.PASSED IS 'Ƿͨ'
/

COMMENT ON COLUMN ZL_ADVERTISEMENT.OVERDUEDATE IS ''
/


ALTER TABLE ZL_ADZONE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_ADZONE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_ADZONE
(
  ZONEID          INTEGER                       NOT NULL,
  ZONENAME        VARCHAR2(50 BYTE)             DEFAULT ''                    NOT NULL,
  ZONEJSNAME      VARCHAR2(50 BYTE)             DEFAULT ''                    NOT NULL,
  ZONEINTRO       VARCHAR2(255 BYTE)            DEFAULT '',
  ZONETYPE        INTEGER                       DEFAULT 0                     NOT NULL,
  DEFAULTSETTING  CHAR(1 BYTE)                  DEFAULT '0'                   NOT NULL,
  ZONESETTING     VARCHAR2(255 BYTE)            DEFAULT '',
  ZONEWIDTH       INTEGER                       DEFAULT 0,
  ZONEHEIGHT      INTEGER                       DEFAULT 0,
  ACTIVE          CHAR(1 BYTE)                  DEFAULT '0'                   NOT NULL,
  SHOWTYPE        INTEGER                       DEFAULT 0                     NOT NULL,
  UPDATETIME      DATE                          DEFAULT SYSDATE               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_ADZONE IS 'λ'
/

COMMENT ON COLUMN ZL_ADZONE.ZONEID IS 'λID'
/

COMMENT ON COLUMN ZL_ADZONE.ZONENAME IS 'λ'
/

COMMENT ON COLUMN ZL_ADZONE.ZONEJSNAME IS 'λõJSļ'
/

COMMENT ON COLUMN ZL_ADZONE.ZONEINTRO IS 'λע'
/

COMMENT ON COLUMN ZL_ADZONE.ZONETYPE IS 'λ'
/

COMMENT ON COLUMN ZL_ADZONE.DEFAULTSETTING IS 'ǷĬ'
/

COMMENT ON COLUMN ZL_ADZONE.ZONESETTING IS 'λ'
/

COMMENT ON COLUMN ZL_ADZONE.ZONEWIDTH IS 'λ'
/

COMMENT ON COLUMN ZL_ADZONE.ZONEHEIGHT IS 'λ߶'
/

COMMENT ON COLUMN ZL_ADZONE.ACTIVE IS 'Ƿλ'
/

COMMENT ON COLUMN ZL_ADZONE.SHOWTYPE IS 'ʾʽ'
/

COMMENT ON COLUMN ZL_ADZONE.UPDATETIME IS 'ʱ'
/


DROP TABLE ZL_ZONE_ADVERTISEMENT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_ZONE_ADVERTISEMENT
(
  ZONEID  INTEGER                               NOT NULL,
  ADID    INTEGER                               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_ZONE_ADVERTISEMENT IS 'λϢ'
/

COMMENT ON COLUMN ZL_ZONE_ADVERTISEMENT.ZONEID IS 'λID'
/

COMMENT ON COLUMN ZL_ZONE_ADVERTISEMENT.ADID IS 'ID'
/


ALTER TABLE ZL_AUTHOR
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_AUTHOR CASCADE CONSTRAINTS
/

CREATE TABLE ZL_AUTHOR
(
  ID           INTEGER                          NOT NULL,
  USERID       INTEGER,
  TYPE         VARCHAR2(50 BYTE),
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  PASSED       CHAR(1 BYTE)                     DEFAULT '0',
  ONTOP        CHAR(1 BYTE)                     DEFAULT '0',
  ISELITE      CHAR(1 BYTE)                     DEFAULT '0',
  HITS         INTEGER                          DEFAULT 0,
  LASTUSETIME  DATE                             DEFAULT SYSDATE,
  TEMPLATEID   INTEGER                          DEFAULT 0,
  PHOTO        VARCHAR2(255 BYTE)               DEFAULT '',
  INTRO        NCLOB                            DEFAULT '',
  ADDRESS      VARCHAR2(50 BYTE)                DEFAULT '',
  TEL          VARCHAR2(50 BYTE)                DEFAULT '',
  FAX          VARCHAR2(50 BYTE)                DEFAULT '',
  MAIL         VARCHAR2(50 BYTE)                DEFAULT '',
  EMAIL        VARCHAR2(50 BYTE)                DEFAULT '',
  ZIPCODE      VARCHAR2(50 BYTE)                DEFAULT '',
  HOMEPAGE     VARCHAR2(50 BYTE)                DEFAULT '',
  IM           VARCHAR2(50 BYTE)                DEFAULT '',
  SEX          INTEGER                          DEFAULT 0,
  BIRTHDAY     DATE,
  COMPANY      VARCHAR2(50 BYTE),
  DEPARTMENT   VARCHAR2(51 BYTE)
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (INTRO) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_CLIENTREQUIRE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_CLIENTREQUIRE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_CLIENTREQUIRE
(
  REQUIREID    INTEGER                          NOT NULL,
  USERID       INTEGER                          NOT NULL,
  REQUIRE      NCLOB                            DEFAULT ''                    NOT NULL,
  REUQIREDATE  DATE                             DEFAULT SYSDATE               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (REQUIRE) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_CLIENTREQUIRE IS 'ͻ'
/

COMMENT ON COLUMN ZL_CLIENTREQUIRE.REQUIREID IS 'ID'
/

COMMENT ON COLUMN ZL_CLIENTREQUIRE.USERID IS 'ûID'
/

COMMENT ON COLUMN ZL_CLIENTREQUIRE.REQUIRE IS ''
/

COMMENT ON COLUMN ZL_CLIENTREQUIRE.REUQIREDATE IS 'ύʱ'
/


ALTER TABLE ZL_COLLECTEITEM
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_COLLECTEITEM CASCADE CONSTRAINTS
/

CREATE TABLE ZL_COLLECTEITEM
(
  ITEMID        INTEGER                         NOT NULL,
  ITEMNAME      VARCHAR2(50 CHAR)               DEFAULT ''                    NOT NULL,
  TARGETNAME    VARCHAR2(50 CHAR)               DEFAULT ''                    NOT NULL,
  TARGETURL     VARCHAR2(255 BYTE)              DEFAULT ''                    NOT NULL,
  DOCENCODER    VARCHAR2(10 BYTE)               DEFAULT ''                    NOT NULL,
  INTRO         VARCHAR2(255 CHAR)              DEFAULT '',
  NODEID        INTEGER                         DEFAULT 0                     NOT NULL,
  MODELID       INTEGER                         DEFAULT 0                     NOT NULL,
  ISCONTENT     CHAR(1 BYTE)                    DEFAULT '0',
  COLLECTENUM   INTEGER                         DEFAULT 0,
  RPTMODEL      INTEGER                         DEFAULT 0,
  CINTERVAL     INTEGER                         DEFAULT 0,
  LASTEXECTIME  DATE,
  DETECTION     CHAR(1 BYTE)                    DEFAULT '0'
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_COLLECTEITEM IS 'ɼĿ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.TARGETURL IS 'ĿUrl'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.DOCENCODER IS 'ɼ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.NODEID IS '鵵ڵID'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.MODELID IS '鵵ģID'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.ISCONTENT IS 'ĿַǷҳ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.COLLECTENUM IS 'ɼ 0Ϊ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.RPTMODEL IS 'ظģʽ01'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.CINTERVAL IS 'ɼ Ϊλ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.LASTEXECTIME IS 'ϴִʱ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.DETECTION IS 'Ƿͨ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.ITEMID IS 'ɼĿID'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.ITEMNAME IS 'Ŀ'
/

COMMENT ON COLUMN ZL_COLLECTEITEM.TARGETNAME IS 'Ŀվ'
/


ALTER TABLE ZL_COLLECTEPAGE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_COLLECTEPAGE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_COLLECTEPAGE
(
  RULEID      INTEGER                           NOT NULL,
  ITEMID      INTEGER                           NOT NULL,
  FILTERCODE  VARCHAR2(1000 BYTE)               DEFAULT '',
  ISLIST      CHAR(1 BYTE)                      DEFAULT '0',
  LISTSTART   VARCHAR2(1000 BYTE)               DEFAULT '',
  LISTEND     VARCHAR2(1000 BYTE)               DEFAULT '',
  LINKSTART   VARCHAR2(1000 BYTE)               DEFAULT '',
  LINKEND     VARCHAR2(1000 BYTE)               DEFAULT '',
  NEXTLINK    CHAR(1 BYTE)                      DEFAULT '0',
  DETECTION   CHAR(1 BYTE)                      DEFAULT '0',
  ORDERID     INTEGER                           DEFAULT 0
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_COLLECTEPAGE IS 'ɼĿҳ'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.RULEID IS 'ҳID'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.ITEMID IS 'ĿID'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.FILTERCODE IS ''
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.ISLIST IS 'Ƿб'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.LISTSTART IS 'бʼ'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.LISTEND IS 'б'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.LINKSTART IS 'ӿʼ'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.LINKEND IS 'ӽ'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.NEXTLINK IS 'ĿҳǷ¼'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.DETECTION IS 'Ƿͨ'
/

COMMENT ON COLUMN ZL_COLLECTEPAGE.ORDERID IS 'ҳ˳'
/


ALTER TABLE ZL_COMMENT
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_COMMENT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_COMMENT
(
  COMMENTID    INTEGER                          NOT NULL,
  GENERALID    INTEGER                          NOT NULL,
  TITLE        VARCHAR2(255 BYTE)               DEFAULT '',
  CONTENTS     VARCHAR2(1000 BYTE)              NOT NULL,
  AUDITED      CHAR(1 BYTE)                     DEFAULT '0'                   NOT NULL,
  USERID       INTEGER                          NOT NULL,
  COMMENTTIME  DATE                             DEFAULT SYSDATE               NOT NULL,
  SCORE        INTEGER                          DEFAULT 0,
  PK           CHAR(1 BYTE)                     DEFAULT '0'
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_COMMENT IS 'Ϣ'
/

COMMENT ON COLUMN ZL_COMMENT.COMMENTID IS 'ID'
/

COMMENT ON COLUMN ZL_COMMENT.GENERALID IS 'ȫID'
/

COMMENT ON COLUMN ZL_COMMENT.TITLE IS ''
/

COMMENT ON COLUMN ZL_COMMENT.CONTENTS IS ''
/

COMMENT ON COLUMN ZL_COMMENT.AUDITED IS 'Ƿͨ'
/

COMMENT ON COLUMN ZL_COMMENT.USERID IS 'ID'
/

COMMENT ON COLUMN ZL_COMMENT.COMMENTTIME IS 'ʱ'
/

COMMENT ON COLUMN ZL_COMMENT.SCORE IS 'ύ'
/

COMMENT ON COLUMN ZL_COMMENT.PK IS 'PK 0= 1=֧'
/


ALTER TABLE ZL_USER
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_USER CASCADE CONSTRAINTS
/

CREATE TABLE ZL_USER
(
  USERID             INTEGER                    NOT NULL,
  USERNAME           VARCHAR2(50 BYTE)          NOT NULL,
  USERPWD            VARCHAR2(50 BYTE)          NOT NULL,
  GROUPID            INTEGER                    DEFAULT 0                     NOT NULL,
  EMAIL              VARCHAR2(255 BYTE)         NOT NULL,
  QUESTION           VARCHAR2(255 BYTE)         NOT NULL,
  ANSWER             VARCHAR2(255 BYTE)         NOT NULL,
  REGTIME            DATE                       DEFAULT SYSDATE,
  LOGINTIMES         INTEGER                    DEFAULT 0,
  LASTLOGINTIME      DATE                       DEFAULT SYSDATE,
  LASTLOGINIP        VARCHAR2(20 BYTE)          DEFAULT '',
  LASTPWDCHANGETIME  DATE,
  LASTLOCKTIME       DATE,
  STATUS             INTEGER,
  CHECKNUM           VARCHAR2(50 BYTE),
  MSGCOUNT           INTEGER                    DEFAULT 0,
  USEREXP            INTEGER                    DEFAULT 0,
  BALANCE            NUMBER(10,2)               DEFAULT 0,
  PRIVACYSETTING     INTEGER                    DEFAULT 0
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_USER IS 'ԱϢ'
/

COMMENT ON COLUMN ZL_USER.USERID IS 'ԱID'
/

COMMENT ON COLUMN ZL_USER.USERNAME IS 'Ա'
/

COMMENT ON COLUMN ZL_USER.USERPWD IS 'Ա'
/

COMMENT ON COLUMN ZL_USER.GROUPID IS 'ԱID'
/

COMMENT ON COLUMN ZL_USER.EMAIL IS 'Email'
/

COMMENT ON COLUMN ZL_USER.QUESTION IS 'Աʾ'
/

COMMENT ON COLUMN ZL_USER.ANSWER IS 'Աʾ'
/

COMMENT ON COLUMN ZL_USER.REGTIME IS 'עʱ'
/

COMMENT ON COLUMN ZL_USER.LOGINTIMES IS '¼'
/

COMMENT ON COLUMN ZL_USER.LASTLOGINTIME IS '¼ʱ'
/

COMMENT ON COLUMN ZL_USER.LASTLOGINIP IS '¼IP'
/

COMMENT ON COLUMN ZL_USER.LASTPWDCHANGETIME IS '޸ʱ'
/

COMMENT ON COLUMN ZL_USER.LASTLOCKTIME IS 'ʱ'
/

COMMENT ON COLUMN ZL_USER.STATUS IS 'û״̬012δͨʼ֤4δͨԱ֤'
/

COMMENT ON COLUMN ZL_USER.CHECKNUM IS '֤롣ʼ֤'
/

COMMENT ON COLUMN ZL_USER.MSGCOUNT IS 'ɷ'
/

COMMENT ON COLUMN ZL_USER.USEREXP IS 'Ա'
/


ALTER TABLE ZL_NODE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_NODE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_NODE
(
  NODEID            INTEGER                     NOT NULL,
  NODENAME          VARCHAR2(50 BYTE)           NOT NULL,
  NODETYPE          INTEGER                     DEFAULT 1                     NOT NULL,
  NODEDIR           VARCHAR2(10 BYTE)           NOT NULL,
  NODEURL           VARCHAR2(255 BYTE)          DEFAULT '',
  TIPS              VARCHAR2(255 BYTE)          DEFAULT '',
  PARENTID          INTEGER                     DEFAULT 0                     NOT NULL,
  ORDERID           INTEGER                     NOT NULL,
  CHILD             INTEGER,
  DEPTH             INTEGER                     DEFAULT 1,
  NODEPICURL        VARCHAR2(255 BYTE)          DEFAULT '',
  DESCRIPTION       VARCHAR2(255 BYTE)          DEFAULT '',
  META_KEYWORDS     VARCHAR2(255 BYTE)          DEFAULT '',
  META_DESCRIPTION  VARCHAR2(255 BYTE)          DEFAULT '',
  OPENTYPE          CHAR(1 BYTE)                DEFAULT '0',
  PURVIEWTYPE       CHAR(1 BYTE)                DEFAULT '0',
  COMMENTTYPE       CHAR(1 BYTE)                DEFAULT '0',
  HITSOFHOT         INTEGER                     DEFAULT 0,
  LISTTEMPLATEFILE  VARCHAR2(255 BYTE)          DEFAULT '',
  INDEXTEMPLATE     VARCHAR2(255 BYTE)          DEFAULT '',
  CONTENTMODEL      VARCHAR2(1000 BYTE)         DEFAULT '',
  ITEMOPENTYPE      CHAR(1 BYTE)                DEFAULT '0',
  CONTENTHTMLRULE   INTEGER                     DEFAULT 0,
  LISTPAGEHTMLEX    INTEGER                     DEFAULT 0,
  CONTENTFILEEX     INTEGER                     DEFAULT 0,
  HTMLPOSITION      INTEGER                     DEFAULT 0
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_NODE IS 'ݽڵϢ'
/

COMMENT ON COLUMN ZL_NODE.NODEID IS 'ڵID'
/

COMMENT ON COLUMN ZL_NODE.NODENAME IS 'ڵ'
/

COMMENT ON COLUMN ZL_NODE.NODETYPE IS 'ڵ͡0Ϊڵ㣬1ΪĿڵ2Ϊҳ棬3Ϊⲿ'
/

COMMENT ON COLUMN ZL_NODE.NODEDIR IS 'ڵʶĿ¼ֻӢĸ֣Ҫĸͷ'
/

COMMENT ON COLUMN ZL_NODE.NODEURL IS 'ⲿURL'
/

COMMENT ON COLUMN ZL_NODE.TIPS IS 'ڵʾ֧HTML'
/

COMMENT ON COLUMN ZL_NODE.PARENTID IS 'ڵID'
/

COMMENT ON COLUMN ZL_NODE.ORDERID IS '˳'
/

COMMENT ON COLUMN ZL_NODE.CHILD IS 'ӽڵ'
/

COMMENT ON COLUMN ZL_NODE.DEPTH IS 'ڵ'
/

COMMENT ON COLUMN ZL_NODE.NODEPICURL IS 'ĿͼƬַ'
/

COMMENT ON COLUMN ZL_NODE.DESCRIPTION IS 'Ŀ˵'
/

COMMENT ON COLUMN ZL_NODE.META_KEYWORDS IS 'ĿMETAؼ'
/

COMMENT ON COLUMN ZL_NODE.META_DESCRIPTION IS '˵'
/

COMMENT ON COLUMN ZL_NODE.OPENTYPE IS '򿪷ʽ0ԭ'
/

COMMENT ON COLUMN ZL_NODE.PURVIEWTYPE IS 'ĿȨޡ0--Ŀ  1--֤Ŀ'
/

COMMENT ON COLUMN ZL_NODE.COMMENTTYPE IS 'Ȩ01'
/

COMMENT ON COLUMN ZL_NODE.HITSOFHOT IS 'ȵĵСֵ'
/

COMMENT ON COLUMN ZL_NODE.LISTTEMPLATEFILE IS 'бҳģ'
/

COMMENT ON COLUMN ZL_NODE.INDEXTEMPLATE IS 'Ŀҳģ'
/

COMMENT ON COLUMN ZL_NODE.CONTENTMODEL IS 'ѡģ'
/

COMMENT ON COLUMN ZL_NODE.ITEMOPENTYPE IS 'ڵĿĴ򿪷ʽ'
/

COMMENT ON COLUMN ZL_NODE.CONTENTHTMLRULE IS 'ҳļ'
/

COMMENT ON COLUMN ZL_NODE.LISTPAGEHTMLEX IS 'бҳļ'
/

COMMENT ON COLUMN ZL_NODE.CONTENTFILEEX IS 'ҳļչ'
/

COMMENT ON COLUMN ZL_NODE.HTMLPOSITION IS 'ڵĿ¼ɾ̬λ0-Ŀ¼ 1-̳иĿ¼ṹ'
/


DROP TABLE ZL_NODE_MODELTEMPLATE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_NODE_MODELTEMPLATE
(
  NODEID    INTEGER                             NOT NULL,
  MODELID   INTEGER                             NOT NULL,
  TEMPLATE  VARCHAR2(255 BYTE)                  NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_MODEL
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_MODEL CASCADE CONSTRAINTS
/

CREATE TABLE ZL_MODEL
(
  MODELID          INTEGER                      NOT NULL,
  MODELNAME        NVARCHAR2(50)                NOT NULL,
  DESCRIPTION      NVARCHAR2(255),
  TABLENAME        VARCHAR2(50 BYTE)            NOT NULL,
  ITEMNAME         NVARCHAR2(20),
  ITEMUNIT         NVARCHAR2(20),
  ITEMICON         VARCHAR2(255 BYTE),
  CONTENTTEMPLATE  VARCHAR2(255 BYTE),
  MODELTYPE        INTEGER                      DEFAULT 1
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_MODEL IS 'ģͱ'
/

COMMENT ON COLUMN ZL_MODEL.MODELID IS 'ģID'
/

COMMENT ON COLUMN ZL_MODEL.MODELNAME IS 'ģ'
/

COMMENT ON COLUMN ZL_MODEL.DESCRIPTION IS 'ģ˵'
/

COMMENT ON COLUMN ZL_MODEL.TABLENAME IS 'ģ͹ı'
/

COMMENT ON COLUMN ZL_MODEL.ITEMNAME IS 'Ŀƣ¡'
/

COMMENT ON COLUMN ZL_MODEL.ITEMUNIT IS 'Ŀλƪ'
/

COMMENT ON COLUMN ZL_MODEL.ITEMICON IS 'Ŀͼ'
/

COMMENT ON COLUMN ZL_MODEL.CONTENTTEMPLATE IS 'ģ'
/

COMMENT ON COLUMN ZL_MODEL.MODELTYPE IS 'ģ 1-ģ 2-Ʒģ 3-Աģ'
/


ALTER TABLE ZL_MODELFIELD
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_MODELFIELD CASCADE CONSTRAINTS
/

CREATE TABLE ZL_MODELFIELD
(
  FIELDID       INTEGER                         NOT NULL,
  MODELID       INTEGER                         NOT NULL,
  FIELDNAME     VARCHAR2(50 BYTE)               NOT NULL,
  FIELDALIAS    VARCHAR2(50 BYTE)               NOT NULL,
  FIELDTIPS     VARCHAR2(50 BYTE)               DEFAULT '',
  DESCRIPTION   VARCHAR2(255 BYTE)              DEFAULT '',
  ISNOTNULL     CHAR(1 BYTE)                    DEFAULT '0'                   NOT NULL,
  ISSEARCHFORM  CHAR(1 BYTE)                    DEFAULT '0'                   NOT NULL,
  FIELDTYPE     VARCHAR2(30 BYTE)               NOT NULL,
  CONTENT       NCLOB                           DEFAULT '',
  ORDERID       INTEGER                         DEFAULT 1
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (CONTENT) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_MODELFIELD IS 'ģֶα'
/

COMMENT ON COLUMN ZL_MODELFIELD.FIELDID IS 'ֶID'
/

COMMENT ON COLUMN ZL_MODELFIELD.MODELID IS 'ģID'
/

COMMENT ON COLUMN ZL_MODELFIELD.FIELDNAME IS 'ֶ'
/

COMMENT ON COLUMN ZL_MODELFIELD.FIELDALIAS IS 'ֶα ǰ̨ʾ'
/

COMMENT ON COLUMN ZL_MODELFIELD.FIELDTIPS IS 'ֶʾ'
/

COMMENT ON COLUMN ZL_MODELFIELD.DESCRIPTION IS 'ֶ˵'
/

COMMENT ON COLUMN ZL_MODELFIELD.ISNOTNULL IS 'Ƿ Ĭ0'
/

COMMENT ON COLUMN ZL_MODELFIELD.ISSEARCHFORM IS 'Ƿʾ'
/

COMMENT ON COLUMN ZL_MODELFIELD.FIELDTYPE IS 'ֶ'
/

COMMENT ON COLUMN ZL_MODELFIELD.CONTENT IS 'ϸ趨'
/

COMMENT ON COLUMN ZL_MODELFIELD.ORDERID IS ''
/


ALTER TABLE ZL_CORRECT
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_CORRECT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_CORRECT
(
  CORRECTID      INTEGER                        NOT NULL,
  CORRECTURL     VARCHAR2(255 BYTE)             NOT NULL,
  CORRECTTITLE   VARCHAR2(255 BYTE)             NOT NULL,
  CORRECTTYPE    INTEGER                        DEFAULT 0                     NOT NULL,
  CORRECTDETAIL  VARCHAR2(255 BYTE),
  CORRECTPER     VARCHAR2(50 BYTE),
  PEREMAIL       VARCHAR2(50 BYTE)
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_CORRECT IS ''
/

COMMENT ON COLUMN ZL_CORRECT.CORRECTURL IS 'ҳurl'
/

COMMENT ON COLUMN ZL_CORRECT.CORRECTTITLE IS ''
/

COMMENT ON COLUMN ZL_CORRECT.CORRECTTYPE IS '0-ݴ 1- 2-ͼƬ 3-Ӵ'
/

COMMENT ON COLUMN ZL_CORRECT.CORRECTDETAIL IS 'ϸ'
/

COMMENT ON COLUMN ZL_CORRECT.CORRECTPER IS ''
/

COMMENT ON COLUMN ZL_CORRECT.PEREMAIL IS 'Email'
/


ALTER TABLE ZL_DOWNSERVER
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_DOWNSERVER CASCADE CONSTRAINTS
/

CREATE TABLE ZL_DOWNSERVER
(
  SERVERID    INTEGER                           NOT NULL,
  SERVERNAME  VARCHAR2(50 BYTE)                 NOT NULL,
  SERVERURL   VARCHAR2(200 BYTE)                NOT NULL,
  SERVERLOGO  VARCHAR2(255 BYTE),
  ORDERID     INTEGER,
  SHOWTYPE    INTEGER
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_GROUP
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_GROUP CASCADE CONSTRAINTS
/

CREATE TABLE ZL_GROUP
(
  GROUPID      INTEGER                          NOT NULL,
  GROUPNAME    VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(255 BYTE),
  REGSELECT    CHAR(1 BYTE)                     DEFAULT '0'
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_GROUP IS 'Ա'
/

COMMENT ON COLUMN ZL_GROUP.GROUPID IS 'ԱID'
/

COMMENT ON COLUMN ZL_GROUP.GROUPNAME IS 'Ա'
/

COMMENT ON COLUMN ZL_GROUP.DESCRIPTION IS '˵'
/

COMMENT ON COLUMN ZL_GROUP.REGSELECT IS 'עʱǷѡ'
/


ALTER TABLE ZL_GROUPFIELDPERMISSIONS
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_GROUPFIELDPERMISSIONS CASCADE CONSTRAINTS
/

CREATE TABLE ZL_GROUPFIELDPERMISSIONS
(
  ID           INTEGER                          NOT NULL,
  GROUPID      INTEGER                          NOT NULL,
  OPERATECODE  INTEGER                          DEFAULT 0                     NOT NULL,
  PROJECTID    INTEGER                          NOT NULL,
  FIELDID      INTEGER                          NOT NULL,
  FIELDNAME    VARCHAR2(50 BYTE)                NOT NULL,
  IDTYPE       INTEGER                          NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_GROUPFIELDPERMISSIONS IS 'ĿֶλԱȨ'
/

COMMENT ON COLUMN ZL_GROUPFIELDPERMISSIONS.GROUPID IS 'ԱID'
/

COMMENT ON COLUMN ZL_GROUPFIELDPERMISSIONS.OPERATECODE IS 'Ȩ޲'
/

COMMENT ON COLUMN ZL_GROUPFIELDPERMISSIONS.PROJECTID IS 'ĿID'
/

COMMENT ON COLUMN ZL_GROUPFIELDPERMISSIONS.FIELDID IS 'ֶID'
/

COMMENT ON COLUMN ZL_GROUPFIELDPERMISSIONS.FIELDNAME IS 'Ŀֶ'
/

COMMENT ON COLUMN ZL_GROUPFIELDPERMISSIONS.IDTYPE IS 'ID 0 û 1 û'
/


DROP TABLE ZL_GROUPMODEL CASCADE CONSTRAINTS
/

CREATE TABLE ZL_GROUPMODEL
(
  GROUPID    INTEGER                            NOT NULL,
  USERMODEL  INTEGER                            NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_JSTEMPLATE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_JSTEMPLATE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_JSTEMPLATE
(
  JSTEMPLATEID    INTEGER                       NOT NULL,
  JSTEMPLATENAME  VARCHAR2(50 BYTE)             NOT NULL,
  JSTEMPLATEPATH  VARCHAR2(100 BYTE)            NOT NULL,
  JSTEMPLATESIZE  VARCHAR2(50 BYTE)             NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_KEYWORDS
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_KEYWORDS CASCADE CONSTRAINTS
/

CREATE TABLE ZL_KEYWORDS
(
  KEYWORDID     INTEGER                         NOT NULL,
  KEYWORDTEXT   VARCHAR2(200 BYTE)              NOT NULL,
  KEYWORDTYPE   INTEGER                         NOT NULL,
  PRIORITY      INTEGER                         DEFAULT 0                     NOT NULL,
  HITS          INTEGER                         DEFAULT 0                     NOT NULL,
  LASTUSETIME   DATE                            DEFAULT SYSDATE               NOT NULL,
  ARRGENERALID  NCLOB                           DEFAULT '',
  QUOTETIMES    INTEGER                         DEFAULT 0
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (ARRGENERALID) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_LABEL
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_LABEL CASCADE CONSTRAINTS
/

CREATE TABLE ZL_LABEL
(
  LABELID        INTEGER                        NOT NULL,
  LABELNAME      VARCHAR2(50 BYTE)              NOT NULL,
  LABELTYPE      INTEGER                        DEFAULT 1                     NOT NULL,
  LABELCATE      VARCHAR2(50 BYTE),
  LABELDESC      VARCHAR2(255 BYTE),
  LABELPARAM     NCLOB                          DEFAULT '',
  LABELTABLE     VARCHAR2(3000 BYTE)            DEFAULT '',
  LABELFIELD     VARCHAR2(3000 BYTE)            DEFAULT '',
  LABELWHERE     VARCHAR2(3000 BYTE),
  LABELORDER     VARCHAR2(1000 BYTE),
  LABELCONTENT   NCLOB                          DEFAULT '',
  LABELCOUNT     VARCHAR2(50 BYTE)              DEFAULT '',
  LABELIDENTITY  VARCHAR2(255 BYTE)             DEFAULT ''
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (LABELCONTENT) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
  LOB (LABELPARAM) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_LABEL IS 'ǩ'
/

COMMENT ON COLUMN ZL_LABEL.LABELID IS 'ǩID'
/

COMMENT ON COLUMN ZL_LABEL.LABELNAME IS 'ǩ'
/

COMMENT ON COLUMN ZL_LABEL.LABELTYPE IS 'ǩ 1=̬ǩ2=̬ǩ3=ҳб'
/

COMMENT ON COLUMN ZL_LABEL.LABELCATE IS 'ǩ'
/

COMMENT ON COLUMN ZL_LABEL.LABELDESC IS 'ǩ˵'
/

COMMENT ON COLUMN ZL_LABEL.LABELPARAM IS 'ǩ'
/

COMMENT ON COLUMN ZL_LABEL.LABELTABLE IS 'ǩѯ'
/

COMMENT ON COLUMN ZL_LABEL.LABELFIELD IS 'ǩѯֶ'
/

COMMENT ON COLUMN ZL_LABEL.LABELWHERE IS 'ѯ'
/

COMMENT ON COLUMN ZL_LABEL.LABELORDER IS 'ѯ'
/

COMMENT ON COLUMN ZL_LABEL.LABELCONTENT IS 'ǩ'
/

COMMENT ON COLUMN ZL_LABEL.LABELCOUNT IS 'ѯ'
/

COMMENT ON COLUMN ZL_LABEL.LABELIDENTITY IS 'ѯ'
/


ALTER TABLE ZL_LOG
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_LOG CASCADE CONSTRAINTS
/

CREATE TABLE ZL_LOG
(
  LOGID       INTEGER                           NOT NULL,
  CATEGORY    INTEGER                           NOT NULL,
  PRIORITY    INTEGER                           DEFAULT 0                     NOT NULL,
  TITLE       VARCHAR2(255 BYTE)                DEFAULT '',
  MESSAGE     VARCHAR2(3000 BYTE)               DEFAULT '',
  TIMESTAMP   DATE                              DEFAULT SYSDATE,
  USERNAME    VARCHAR2(20 BYTE)                 DEFAULT '',
  USERIP      VARCHAR2(20 BYTE)                 DEFAULT '',
  SOURCE      VARCHAR2(3000 BYTE)               DEFAULT '',
  SCRIPTNAME  VARCHAR2(255 BYTE)                DEFAULT '',
  POSTSTRING  NCLOB                             DEFAULT ''
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (POSTSTRING) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_LOG IS '־'
/

COMMENT ON COLUMN ZL_LOG.CATEGORY IS ''
/

COMMENT ON COLUMN ZL_LOG.PRIORITY IS 'ȼ'
/

COMMENT ON COLUMN ZL_LOG.TITLE IS ''
/

COMMENT ON COLUMN ZL_LOG.MESSAGE IS 'Ϣ'
/

COMMENT ON COLUMN ZL_LOG.TIMESTAMP IS '¼ʱ'
/

COMMENT ON COLUMN ZL_LOG.USERNAME IS 'û'
/

COMMENT ON COLUMN ZL_LOG.USERIP IS 'ûIP'
/

COMMENT ON COLUMN ZL_LOG.SOURCE IS '쳣Դ'
/

COMMENT ON COLUMN ZL_LOG.SCRIPTNAME IS 'Դҳ'
/

COMMENT ON COLUMN ZL_LOG.POSTSTRING IS 'ύ'
/


ALTER TABLE ZL_MESSAGE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_MESSAGE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_MESSAGE
(
  MSGID     INTEGER                             NOT NULL,
  TITLE     VARCHAR2(200 BYTE)                  NOT NULL,
  CONTENT   VARCHAR2(3000 BYTE)                 NOT NULL,
  SENDER    VARCHAR2(20 BYTE)                   NOT NULL,
  INCEPT    VARCHAR2(20 BYTE)                   NOT NULL,
  STATUS    CHAR(1 BYTE)                        DEFAULT '0'                   NOT NULL,
  POSTDATE  DATE                                DEFAULT SYSDATE               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_MESSAGE IS 'վ'
/

COMMENT ON COLUMN ZL_MESSAGE.TITLE IS ''
/

COMMENT ON COLUMN ZL_MESSAGE.CONTENT IS ''
/

COMMENT ON COLUMN ZL_MESSAGE.SENDER IS ''
/

COMMENT ON COLUMN ZL_MESSAGE.INCEPT IS ''
/

COMMENT ON COLUMN ZL_MESSAGE.STATUS IS '״̬ 0δ 1Ѷ'
/

COMMENT ON COLUMN ZL_MESSAGE.POSTDATE IS 'ʱ'
/


DROP TABLE ZL_ONLINE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_ONLINE
(
  USERID      INTEGER                           NOT NULL,
  USERNAME    VARCHAR2(20 BYTE)                 NOT NULL,
  STARTTIME   DATE                              NOT NULL,
  CHANGETIME  DATE                              NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_PAYMENT
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PAYMENT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PAYMENT
(
  PAYMENTID     INTEGER                         NOT NULL,
  USERID        INTEGER                         NOT NULL,
  PAYMENTNUM    VARCHAR2(50 BYTE)               NOT NULL,
  PAYPLATID     INTEGER,
  MONEYPAY      NUMBER(8,2)                     NOT NULL,
  MONEYTRUE     NUMBER(8,2)                     NOT NULL,
  PAYTIME       DATE                            DEFAULT SYSDATE               NOT NULL,
  SUCCESSTIME   DATE,
  STATUS        INTEGER,
  PLATFORMINFO  VARCHAR2(200 BYTE),
  REMARK        VARCHAR2(255 BYTE),
  CSTATUS       CHAR(1 BYTE)                    DEFAULT '0'
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_PAYMENT IS '֧Ϣ'
/

COMMENT ON COLUMN ZL_PAYMENT.USERID IS 'ûID'
/

COMMENT ON COLUMN ZL_PAYMENT.PAYMENTNUM IS '֧'
/

COMMENT ON COLUMN ZL_PAYMENT.PAYPLATID IS '֧ƽ̨ID'
/

COMMENT ON COLUMN ZL_PAYMENT.MONEYPAY IS ''
/

COMMENT ON COLUMN ZL_PAYMENT.MONEYTRUE IS 'ʵʽ'
/

COMMENT ON COLUMN ZL_PAYMENT.PAYTIME IS '֧ʱ'
/

COMMENT ON COLUMN ZL_PAYMENT.SUCCESSTIME IS 'ɹʱ'
/

COMMENT ON COLUMN ZL_PAYMENT.STATUS IS '״̬'
/

COMMENT ON COLUMN ZL_PAYMENT.PLATFORMINFO IS 'ƽ̨Ϣ'
/

COMMENT ON COLUMN ZL_PAYMENT.REMARK IS 'ע'
/

COMMENT ON COLUMN ZL_PAYMENT.CSTATUS IS '״̬ 0δ 1Ѵ'
/


ALTER TABLE ZL_PAYPLAT
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PAYPLAT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PAYPLAT
(
  PAYPLATID    INTEGER                          NOT NULL,
  PAYPLATNAME  VARCHAR2(50 BYTE)                NOT NULL,
  ACCOUNTID    VARCHAR2(50 BYTE)                NOT NULL,
  MD5KEY       VARCHAR2(50 BYTE)                NOT NULL,
  SELLEREMAIL  VARCHAR2(50 BYTE),
  ISDISABLED   CHAR(1 BYTE)                     DEFAULT '0',
  ISDEFAULT    CHAR(1 BYTE)                     DEFAULT '0',
  RATE         NUMBER,
  ORDERID      INTEGER
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_PAYPLAT IS '֧ƽ̨'
/

COMMENT ON COLUMN ZL_PAYPLAT.PAYPLATNAME IS 'ƽ̨'
/

COMMENT ON COLUMN ZL_PAYPLAT.ACCOUNTID IS 'ƽ̨̻ID'
/

COMMENT ON COLUMN ZL_PAYPLAT.MD5KEY IS '֧ƽ̨̻ȫУ'
/

COMMENT ON COLUMN ZL_PAYPLAT.SELLEREMAIL IS 'Email֧ҪEmail'
/

COMMENT ON COLUMN ZL_PAYPLAT.ISDISABLED IS 'Ƿ'
/

COMMENT ON COLUMN ZL_PAYPLAT.ISDEFAULT IS 'ǷĬ֧ƽ̨'
/

COMMENT ON COLUMN ZL_PAYPLAT.RATE IS ''
/

COMMENT ON COLUMN ZL_PAYPLAT.ORDERID IS 'ID'
/


ALTER TABLE ZL_PROJECT
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PROJECT CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PROJECT
(
  PROJECTID          INTEGER                    NOT NULL,
  PROJECTNAME        VARCHAR2(255 BYTE)         NOT NULL,
  PROJECTINTRO       NCLOB                      NOT NULL,
  USERID             INTEGER                    NOT NULL,
  REQUIREID          INTEGER                    NOT NULL,
  STARTDATE          DATE                       NOT NULL,
  ENDDATE            DATE,
  STATUS             INTEGER                    DEFAULT 0,
  PASSED             CHAR(1 BYTE)               DEFAULT '0',
  PROJECTCATEGORYID  INTEGER                    NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
LOB (PROJECTINTRO) STORE AS 
      ( TABLESPACE  USERS 
        ENABLE      STORAGE IN ROW
        CHUNK       8192
        RETENTION
        NOCACHE
        INDEX       (
          TABLESPACE USERS
          STORAGE    (
                      INITIAL          64K
                      NEXT             1
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                     ))
        STORAGE    (
                    INITIAL          64K
                    MINEXTENTS       1
                    MAXEXTENTS       UNLIMITED
                    PCTINCREASE      0
                    BUFFER_POOL      DEFAULT
                   )
      )
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_PROJECTAFFAIRS
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PROJECTAFFAIRS CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PROJECTAFFAIRS
(
  ID              INTEGER                       NOT NULL,
  MAINTITLEID     INTEGER                       NOT NULL,
  SUBTITLEID      INTEGER,
  TITLE           VARCHAR2(255 BYTE),
  CONTENT         VARCHAR2(3000 BYTE)           NOT NULL,
  AUTHORID        INTEGER                       NOT NULL,
  AUTHORNAME      VARCHAR2(50 BYTE),
  EDITTIME        DATE                          DEFAULT SYSDATE,
  LASTMODIFYTIME  DATE                          DEFAULT SYSDATE
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_PROJECTCATEGORY
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PROJECTCATEGORY CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PROJECTCATEGORY
(
  PROJECTCATEGORYID     INTEGER                 NOT NULL,
  PROJECTCATEGORYNAME   VARCHAR2(50 BYTE)       NOT NULL,
  PROJECTCATEGORYINTRO  VARCHAR2(255 BYTE)
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_PROJECTDISCUSS
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PROJECTDISCUSS CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PROJECTDISCUSS
(
  DISCUSSID    INTEGER                          NOT NULL,
  PROJECTID    INTEGER                          NOT NULL,
  WORKID       INTEGER                          NOT NULL,
  USERID       INTEGER                          NOT NULL,
  CONTENT      VARCHAR2(3000 BYTE)              NOT NULL,
  DISCUSSDATE  DATE                             DEFAULT SYSDATE               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_PROJECTFIELD
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PROJECTFIELD CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PROJECTFIELD
(
  ID          INTEGER                           NOT NULL,
  PROJECTID   INTEGER                           NOT NULL,
  FIELDNAME   VARCHAR2(100 BYTE)                NOT NULL,
  ALIAS       VARCHAR2(100 BYTE)                NOT NULL,
  TYPE        VARCHAR2(30 BYTE)                 NOT NULL,
  FIELDVALUE  VARCHAR2(3000 BYTE)               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_PROJECTWORK
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_PROJECTWORK CASCADE CONSTRAINTS
/

CREATE TABLE ZL_PROJECTWORK
(
  WORKID     INTEGER                            NOT NULL,
  WORKNAME   VARCHAR2(255 BYTE)                 NOT NULL,
  WORKINTRO  VARCHAR2(2000 BYTE)                NOT NULL,
  PROJECTID  INTEGER                            NOT NULL,
  APPROVING  INTEGER                            DEFAULT 0,
  STATUS     INTEGER                            DEFAULT 0,
  ENDDATE    DATE                               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_ROLE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_ROLE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_ROLE
(
  ROLEID       INTEGER                          NOT NULL,
  ROLENAME     VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(255 BYTE)
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


DROP TABLE ZL_ROLEPERMISSIONS CASCADE CONSTRAINTS
/

CREATE TABLE ZL_ROLEPERMISSIONS
(
  ROLEID       INTEGER                          NOT NULL,
  OPERATECODE  VARCHAR2(50 BYTE)                NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON COLUMN ZL_ROLEPERMISSIONS.OPERATECODE IS ''
/


ALTER TABLE ZL_SOURCE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_SOURCE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_SOURCE
(
  ID           INTEGER                          NOT NULL,
  TYPE         VARCHAR2(50 BYTE),
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  PASSED       CHAR(1 BYTE)                     DEFAULT '0',
  ONTOP        CHAR(1 BYTE)                     DEFAULT '0',
  ISELITE      CHAR(1 BYTE)                     DEFAULT '0',
  HITS         INTEGER                          DEFAULT 0,
  LASTUSETIME  DATE,
  PHOTO        VARCHAR2(255 BYTE),
  INTRO        VARCHAR2(255 BYTE),
  ADDRESS      VARCHAR2(255 BYTE),
  TEL          VARCHAR2(50 BYTE),
  FAX          VARCHAR2(50 BYTE),
  MAIL         VARCHAR2(50 BYTE),
  EMAIL        VARCHAR2(50 BYTE),
  ZIPCODE      VARCHAR2(50 BYTE),
  HOMEPAGE     VARCHAR2(50 BYTE),
  IM           VARCHAR2(50 BYTE),
  CONTACTER    VARCHAR2(50 BYTE)
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_SPECCATE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_SPECCATE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_SPECCATE
(
  SPECCATEID    INTEGER                         NOT NULL,
  SPECCATENAME  VARCHAR2(50 BYTE)               NOT NULL,
  SPECCATEDIR   VARCHAR2(50 BYTE)               NOT NULL,
  SPECCATEDESC  VARCHAR2(255 BYTE),
  OPENTYPE      CHAR(1 BYTE)                    DEFAULT '0',
  FILEEXT       INTEGER,
  LISTTEMPLATE  VARCHAR2(255 BYTE)
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON COLUMN ZL_SPECCATE.SPECCATENAME IS 'ר'
/

COMMENT ON COLUMN ZL_SPECCATE.SPECCATEDIR IS 'רĿ¼'
/

COMMENT ON COLUMN ZL_SPECCATE.OPENTYPE IS '򿪷ʽ'
/

COMMENT ON COLUMN ZL_SPECCATE.FILEEXT IS 'ļչ'
/

COMMENT ON COLUMN ZL_SPECCATE.LISTTEMPLATE IS 'רбҳģ'
/


ALTER TABLE ZL_SPECIAL
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_SPECIAL CASCADE CONSTRAINTS
/

CREATE TABLE ZL_SPECIAL
(
  SPECID        INTEGER                         NOT NULL,
  SPECNAME      VARCHAR2(50 BYTE)               NOT NULL,
  SPECDIR       VARCHAR2(50 BYTE)               NOT NULL,
  SPECDESC      VARCHAR2(255 BYTE),
  OPENTYPE      CHAR(1 BYTE)                    DEFAULT '0',
  SPECCATE      INTEGER                         NOT NULL,
  LISTFILEEXT   INTEGER,
  LISTTEMPLATE  VARCHAR2(255 BYTE),
  LISTFILERULE  INTEGER                         DEFAULT 0
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_SPECIAL IS 'ר'
/

COMMENT ON COLUMN ZL_SPECIAL.SPECNAME IS 'ר'
/

COMMENT ON COLUMN ZL_SPECIAL.SPECDIR IS 'רĿ¼'
/

COMMENT ON COLUMN ZL_SPECIAL.SPECDESC IS 'ר˵'
/

COMMENT ON COLUMN ZL_SPECIAL.OPENTYPE IS '򿪷ʽ'
/

COMMENT ON COLUMN ZL_SPECIAL.SPECCATE IS 'ר'
/

COMMENT ON COLUMN ZL_SPECIAL.LISTFILEEXT IS 'չ'
/

COMMENT ON COLUMN ZL_SPECIAL.LISTTEMPLATE IS 'бҳģ'
/

COMMENT ON COLUMN ZL_SPECIAL.LISTFILERULE IS 'бҳļ'
/


ALTER TABLE ZL_USEREXPHIS
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_USEREXPHIS CASCADE CONSTRAINTS
/

CREATE TABLE ZL_USEREXPHIS
(
  EXPHISID   INTEGER                            NOT NULL,
  USERID     INTEGER                            NOT NULL,
  HISACTION  VARCHAR2(50 BYTE)                  NOT NULL,
  SCORE      INTEGER                            DEFAULT 0                     NOT NULL,
  DETAIL     VARCHAR2(50 BYTE),
  HISTIME    DATE
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


ALTER TABLE ZL_WORKROLE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_WORKROLE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_WORKROLE
(
  ID      INTEGER                               NOT NULL,
  WORKID  INTEGER                               NOT NULL,
  ROLEID  INTEGER                               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


CREATE UNIQUE INDEX ZL_ADV_PK ON ZL_ADVERTISEMENT
(ADID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_AUTHOR_PK ON ZL_AUTHOR
(ID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_CLIENTREQUIRE_PK ON ZL_CLIENTREQUIRE
(REQUIREID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_COLLECTEITEM_PK ON ZL_COLLECTEITEM
(ITEMID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_COLLECTEPAGE_PK ON ZL_COLLECTEPAGE
(RULEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_COMMENT_PK ON ZL_COMMENT
(COMMENTID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_CORRECT_PK ON ZL_CORRECT
(CORRECTID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_DOWNSERVER_PK ON ZL_DOWNSERVER
(SERVERID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_GROUPFIELDPERMISSIONS_PK ON ZL_GROUPFIELDPERMISSIONS
(ID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_GROUP_PK ON ZL_GROUP
(GROUPID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_JSTEMPLATE_PK ON ZL_JSTEMPLATE
(JSTEMPLATEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_KEYWORDS_PK ON ZL_KEYWORDS
(KEYWORDID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_LABEL_PK ON ZL_LABEL
(LABELID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_LOG_PK ON ZL_LOG
(LOGID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_MANAGER_PK ON ZL_MANAGER
(ADMINID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_MESSAGE_PK ON ZL_MESSAGE
(MSGID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_MODELFIELD_PK ON ZL_MODELFIELD
(FIELDID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_MODEL_PK ON ZL_MODEL
(MODELID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_NODE_PK ON ZL_NODE
(NODEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PAYMENT_PK ON ZL_PAYMENT
(PAYMENTID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PAYPLAT_PK ON ZL_PAYPLAT
(PAYPLATID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PROJECTAFFAIRS_PK ON ZL_PROJECTAFFAIRS
(ID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PROJECTCATEGORY_PK ON ZL_PROJECTCATEGORY
(PROJECTCATEGORYID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PROJECTDISCUSS_PK ON ZL_PROJECTDISCUSS
(DISCUSSID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PROJECTFIELD_PK ON ZL_PROJECTFIELD
(ID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PROJECTWORK_PK ON ZL_PROJECTWORK
(WORKID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_PROJECT_PK ON ZL_PROJECT
(PROJECTID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_ROLE_PK ON ZL_ROLE
(ROLEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_SOURCE_PK ON ZL_SOURCE
(ID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_SPECCATE_PK ON ZL_SPECCATE
(SPECCATEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_SPECIAL_PK ON ZL_SPECIAL
(SPECID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_USEREXPHIS_PK ON ZL_USEREXPHIS
(EXPHISID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_USER_PK ON ZL_USER
(USERID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_WORKROLE_PK ON ZL_WORKROLE
(ID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_ZONE_PK ON ZL_ADZONE
(ZONEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


ALTER TABLE ZL_COMMONMODEL
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_COMMONMODEL CASCADE CONSTRAINTS
/

CREATE TABLE ZL_COMMONMODEL
(
  GENERALID   INTEGER                           NOT NULL,
  NODEID      INTEGER                           NOT NULL,
  MODELID     INTEGER                           NOT NULL,
  ITEMID      INTEGER                           NOT NULL,
  TABLENAME   VARCHAR2(50 BYTE)                 NOT NULL,
  TITLE       VARCHAR2(255 BYTE)                NOT NULL,
  INPUTER     VARCHAR2(50 BYTE),
  HITS        INTEGER                           DEFAULT 0,
  CREATETIME  DATE                              DEFAULT SYSDATE,
  STATUS      INTEGER                           DEFAULT 0,
  ELITELEVEL  INTEGER                           DEFAULT 0,
  INFOID      VARCHAR2(1000 BYTE)               DEFAULT '',
  SPECIALID   VARCHAR2(1000 BYTE)               DEFAULT '',
  ISCREATE    CHAR(1 BYTE)                      DEFAULT '0',
  HTMLLINK    VARCHAR2(1000 BYTE)               DEFAULT '',
  TEMPLATE    VARCHAR2(500 BYTE)                DEFAULT ''
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_COMMONMODEL IS 'վȫϢ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.GENERALID IS 'ȫID'
/

COMMENT ON COLUMN ZL_COMMONMODEL.NODEID IS 'ڵID'
/

COMMENT ON COLUMN ZL_COMMONMODEL.MODELID IS 'ģID'
/

COMMENT ON COLUMN ZL_COMMONMODEL.ITEMID IS 'Ӧļ¼ID'
/

COMMENT ON COLUMN ZL_COMMONMODEL.TABLENAME IS 'ݾݴ洢'
/

COMMENT ON COLUMN ZL_COMMONMODEL.TITLE IS 'ݱ ظ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.INPUTER IS '¼'
/

COMMENT ON COLUMN ZL_COMMONMODEL.HITS IS ''
/

COMMENT ON COLUMN ZL_COMMONMODEL.CREATETIME IS 'ʱ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.STATUS IS 'Ϣ״̬ -2Ϊɾ-1Ϊ˸壬0Ϊˣ99ΪͨΪԶ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.ELITELEVEL IS 'Ƽ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.INFOID IS 'ڵ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.SPECIALID IS 'רID'
/

COMMENT ON COLUMN ZL_COMMONMODEL.ISCREATE IS 'Ƿɾ̬ļ0=δ 1='
/

COMMENT ON COLUMN ZL_COMMONMODEL.HTMLLINK IS 'ɵľ̬ҳַ'
/

COMMENT ON COLUMN ZL_COMMONMODEL.TEMPLATE IS 'Ϊضģ'
/


ALTER TABLE ZL_FAVORITE
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_FAVORITE CASCADE CONSTRAINTS
/

CREATE TABLE ZL_FAVORITE
(
  FAVORITEID    INTEGER                         NOT NULL,
  OWNER         INTEGER                         NOT NULL,
  INFOID        INTEGER                         NOT NULL,
  FAVORITEDATE  DATE                            DEFAULT SYSDATE               NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/

COMMENT ON TABLE ZL_FAVORITE IS 'Աղؼ'
/

COMMENT ON COLUMN ZL_FAVORITE.FAVORITEID IS 'ղID'
/

COMMENT ON COLUMN ZL_FAVORITE.OWNER IS 'ղID'
/

COMMENT ON COLUMN ZL_FAVORITE.INFOID IS 'ղݵID'
/

COMMENT ON COLUMN ZL_FAVORITE.FAVORITEDATE IS 'ղʱ'
/


ALTER TABLE ZL_SPECINFO
 DROP PRIMARY KEY CASCADE
/
DROP TABLE ZL_SPECINFO CASCADE CONSTRAINTS
/

CREATE TABLE ZL_SPECINFO
(
  SPECINFOID  INTEGER                           NOT NULL,
  SPECIALID   INTEGER                           NOT NULL,
  INFOID      INTEGER                           NOT NULL
)
TABLESPACE USERS
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
/


CREATE UNIQUE INDEX ZL_COMMONMODEL_PK ON ZL_COMMONMODEL
(GENERALID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_FAVORITE_PK ON ZL_FAVORITE
(FAVORITEID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


CREATE UNIQUE INDEX ZL_SPECINFO_PK ON ZL_SPECINFO
(SPECINFOID)
LOGGING
TABLESPACE USERS
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOPARALLEL
/


ALTER TABLE ZL_MANAGER ADD (
  CONSTRAINT ZL_MANAGER_PK
 PRIMARY KEY
 (ADMINID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_ADVERTISEMENT ADD (
  CONSTRAINT ZL_ADVERTISEMENT_C02
 CHECK (COUNTCLICK in ('0','1')),
  CONSTRAINT ZL_ADVERTISEMENT_C03
 CHECK (PASSED in ('0','1')),
  CONSTRAINT ZL_ADVERTISEMENT_C01
 CHECK (COUNTVIEW in ('0','1')),
  CONSTRAINT ZL_ADV_PK
 PRIMARY KEY
 (ADID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_ADZONE ADD (
  CONSTRAINT ZL_ADZONE_C01
 CHECK (DEFAULTSETTING in ('0','1')),
  CONSTRAINT ZL_ADZONE_C02
 CHECK (ACTIVE in ('0','1')),
  CONSTRAINT ZL_ZONE_PK
 PRIMARY KEY
 (ZONEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_AUTHOR ADD (
  CONSTRAINT ZL_AUTHOR_PK
 PRIMARY KEY
 (ID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_CLIENTREQUIRE ADD (
  CONSTRAINT ZL_CLIENTREQUIRE_PK
 PRIMARY KEY
 (REQUIREID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_COLLECTEITEM ADD (
  CONSTRAINT ZL_COLLECTEITEM_PK
 PRIMARY KEY
 (ITEMID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_COLLECTEPAGE ADD (
  CONSTRAINT ZL_COLLECTEPAGE_PK
 PRIMARY KEY
 (RULEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_COMMENT ADD (
  CONSTRAINT ZL_COMMENT_PK
 PRIMARY KEY
 (COMMENTID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_USER ADD (
  CONSTRAINT ZL_USER_PK
 PRIMARY KEY
 (USERID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_NODE ADD (
  CONSTRAINT ZL_NODE_PK
 PRIMARY KEY
 (NODEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_MODEL ADD (
  CONSTRAINT ZL_MODEL_PK
 PRIMARY KEY
 (MODELID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_MODELFIELD ADD (
  CONSTRAINT ZL_MODELFIELD_PK
 PRIMARY KEY
 (FIELDID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_CORRECT ADD (
  CONSTRAINT ZL_CORRECT_PK
 PRIMARY KEY
 (CORRECTID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_DOWNSERVER ADD (
  CONSTRAINT ZL_DOWNSERVER_PK
 PRIMARY KEY
 (SERVERID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_GROUP ADD (
  CONSTRAINT ZL_GROUP_PK
 PRIMARY KEY
 (GROUPID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_GROUPFIELDPERMISSIONS ADD (
  CONSTRAINT ZL_GROUPFIELDPERMISSIONS_PK
 PRIMARY KEY
 (ID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_JSTEMPLATE ADD (
  CONSTRAINT ZL_JSTEMPLATE_PK
 PRIMARY KEY
 (JSTEMPLATEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_KEYWORDS ADD (
  CONSTRAINT ZL_KEYWORDS_PK
 PRIMARY KEY
 (KEYWORDID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_LABEL ADD (
  CONSTRAINT ZL_LABEL_PK
 PRIMARY KEY
 (LABELID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_LOG ADD (
  CONSTRAINT ZL_LOG_PK
 PRIMARY KEY
 (LOGID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_MESSAGE ADD (
  CONSTRAINT ZL_MESSAGE_PK
 PRIMARY KEY
 (MSGID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PAYMENT ADD (
  CONSTRAINT ZL_PAYMENT_PK
 PRIMARY KEY
 (PAYMENTID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PAYPLAT ADD (
  CONSTRAINT ZL_PAYPLAT_PK
 PRIMARY KEY
 (PAYPLATID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PROJECT ADD (
  CONSTRAINT ZL_PROJECT_PK
 PRIMARY KEY
 (PROJECTID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PROJECTAFFAIRS ADD (
  CONSTRAINT ZL_PROJECTAFFAIRS_PK
 PRIMARY KEY
 (ID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PROJECTCATEGORY ADD (
  CONSTRAINT ZL_PROJECTCATEGORY_PK
 PRIMARY KEY
 (PROJECTCATEGORYID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PROJECTDISCUSS ADD (
  CONSTRAINT ZL_PROJECTDISCUSS_PK
 PRIMARY KEY
 (DISCUSSID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PROJECTFIELD ADD (
  CONSTRAINT ZL_PROJECTFIELD_PK
 PRIMARY KEY
 (ID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_PROJECTWORK ADD (
  CONSTRAINT ZL_PROJECTWORK_PK
 PRIMARY KEY
 (WORKID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_ROLE ADD (
  CONSTRAINT ZL_ROLE_PK
 PRIMARY KEY
 (ROLEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_SOURCE ADD (
  CONSTRAINT ZL_SOURCE_PK
 PRIMARY KEY
 (ID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_SPECCATE ADD (
  CONSTRAINT ZL_SPECCATE_PK
 PRIMARY KEY
 (SPECCATEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_SPECIAL ADD (
  CONSTRAINT ZL_SPECIAL_PK
 PRIMARY KEY
 (SPECID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_USEREXPHIS ADD (
  CONSTRAINT ZL_USEREXPHIS_PK
 PRIMARY KEY
 (EXPHISID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_WORKROLE ADD (
  CONSTRAINT ZL_WORKROLE_PK
 PRIMARY KEY
 (ID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_COMMONMODEL ADD (
  CONSTRAINT ZL_COMMONMODEL_PK
 PRIMARY KEY
 (GENERALID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_FAVORITE ADD (
  CONSTRAINT ZL_FAVORITE_PK
 PRIMARY KEY
 (FAVORITEID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_SPECINFO ADD (
  CONSTRAINT ZL_SPECINFO_PK
 PRIMARY KEY
 (SPECINFOID)
    USING INDEX 
    TABLESPACE USERS
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
               ))
/

ALTER TABLE ZL_NODE_MODELTEMPLATE ADD (
  CONSTRAINT ZL_NODETEMP_NODEID_FK 
 FOREIGN KEY (NODEID) 
 REFERENCES ZL_NODE (NODEID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_MODELFIELD ADD (
  CONSTRAINT ZL_MODELFIELD_MID_FK 
 FOREIGN KEY (MODELID) 
 REFERENCES ZL_MODEL (MODELID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_GROUPMODEL ADD (
  CONSTRAINT ZL_GROUPMODEL_GROUP_FK 
 FOREIGN KEY (GROUPID) 
 REFERENCES ZL_GROUP (GROUPID))
/

ALTER TABLE ZL_PROJECT ADD (
  CONSTRAINT ZL_PROJECT_USER_FK 
 FOREIGN KEY (USERID) 
 REFERENCES ZL_USER (USERID)
    ON DELETE CASCADE,
  CONSTRAINT ZL_PROJECT_REQUIRE_FK 
 FOREIGN KEY (REQUIREID) 
 REFERENCES ZL_CLIENTREQUIRE (REQUIREID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_ROLEPERMISSIONS ADD (
  CONSTRAINT ZL_ROLEPERMISSIONS_R01 
 FOREIGN KEY (ROLEID) 
 REFERENCES ZL_ROLE (ROLEID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_SPECIAL ADD (
  CONSTRAINT ZL_SPECIAL_R01 
 FOREIGN KEY (SPECCATE) 
 REFERENCES ZL_SPECCATE (SPECCATEID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_USEREXPHIS ADD (
  CONSTRAINT ZL_USEREXPHIS_R01 
 FOREIGN KEY (USERID) 
 REFERENCES ZL_USER (USERID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_WORKROLE ADD (
  CONSTRAINT ZL_WORKROLE_R01 
 FOREIGN KEY (WORKID) 
 REFERENCES ZL_PROJECTWORK (WORKID)
    ON DELETE CASCADE,
  CONSTRAINT ZL_WORKROLE_R02 
 FOREIGN KEY (ROLEID) 
 REFERENCES ZL_GROUPFIELDPERMISSIONS (ID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_COMMONMODEL ADD (
  CONSTRAINT ZL_COMMONMODEL_MID_FK 
 FOREIGN KEY (MODELID) 
 REFERENCES ZL_MODEL (MODELID)
    ON DELETE CASCADE)
/

ALTER TABLE ZL_FAVORITE ADD (
  CONSTRAINT ZL_FAVORITE_USER_FK 
 FOREIGN KEY (OWNER) 
 REFERENCES ZL_USER (USERID)
    ON DELETE CASCADE,
  CONSTRAINT ZL_FAVORITE_INFOID_FK 
 FOREIGN KEY (INFOID) 
 REFERENCES ZL_COMMONMODEL (GENERALID))
/

ALTER TABLE ZL_SPECINFO ADD (
  CONSTRAINT ZL_SPECINFO_R01 
 FOREIGN KEY (SPECIALID) 
 REFERENCES ZL_SPECIAL (SPECID)
    ON DELETE CASCADE,
  CONSTRAINT ZL_SPECINFO_R02 
 FOREIGN KEY (INFOID) 
 REFERENCES ZL_COMMONMODEL (GENERALID)
    ON DELETE CASCADE)
/

DROP PROCEDURE DT_ADVERTISEMENT_ADD
/

CREATE OR REPLACE PROCEDURE        dt_Advertisement_Add
(
 p_ADID ZL_Advertisement.ADID%type,
 p_UserID ZL_Advertisement.UserID%type,
 p_ADType ZL_Advertisement.ADType%type,
 p_ADName ZL_Advertisement.ADName%type,
 p_ImgUrl ZL_Advertisement.ImgUrl%type,
 p_ImgWidth ZL_Advertisement.ImgWidth%type,
 p_ImgHeight ZL_Advertisement.ImgHeight%type,
 p_FlashWmode ZL_Advertisement.FlashWmode%type,
 p_ADIntro ZL_Advertisement.ADIntro%type,
 p_LinkUrl ZL_Advertisement.LinkUrl%type,
 p_LinkTarget ZL_Advertisement.LinkTarget%type,
 p_LinkAlt ZL_Advertisement.LinkAlt%type,
 p_Priority ZL_Advertisement.Priority%type,
 p_Setting ZL_Advertisement.Setting%type,
 p_CountView ZL_Advertisement.CountView%type,
 p_Views ZL_Advertisement.ViewsCount%type,
 p_CountClick ZL_Advertisement.CountClick%type,
 p_Clicks ZL_Advertisement.Clicks%type,
 p_Passed ZL_Advertisement.Passed%type,
 p_OverdueDate ZL_Advertisement.OverdueDate%type
)
AS
BEGIN
   insert into ZL_Advertisement 
   (
   ADID,
   USERID,
   ADType,
   ADName,
   ImgUrl,
   ImgWidth,
   ImgHeight,
   FlashWmode,
   ADIntro,
   LinkUrl,
   LinkTarget,
   LinkAlt,
   Priority,
   Setting,
   CountView,
   ViewsCount,
   CountClick,
   Clicks,
   Passed,
   OverdueDate
 ) values
 (
 p_ADID,
 p_UserID,
 p_ADType,
 p_ADName,
 p_ImgUrl,
 p_ImgWidth,
 p_ImgHeight,
 p_FlashWmode,
 p_ADIntro,
 p_LinkUrl,
 p_LinkTarget,
 p_LinkAlt,
 p_Priority,
 p_Setting,
 p_CountView,
 p_Views,
 p_CountClick,
 p_Clicks,
 p_Passed,
 p_OverdueDate
 );
END dt_Advertisement_Add;
/


DROP PROCEDURE DT_ADVERTISEMENT_CANCELPASSED
/

CREATE OR REPLACE PROCEDURE        dt_Advertisement_CancelPassed
(
strAdId in integer
)
AS
BEGIN
   update ZL_Advertisement set Passed='0' where ADID=strAdId;
END dt_Advertisement_CancelPassed;
/


DROP PROCEDURE DT_ADVERTISEMENT_COPY
/

CREATE OR REPLACE PROCEDURE        dt_advertisement_copy
(
p_ad in integer
)
AS
p_ADID integer;
p_UserID integer;
p_ADType integer;
p_ADName varchar2(100);
p_ImgUrl varchar2(255);
p_ImgWidth integer;
p_ImgHeight integer;
p_FlashWmode integer;
p_ADIntro nclob;
p_LinkUrl varchar2(255);
p_LinkTarget integer;
p_LinkAlt varchar2(255);
p_Priority integer;
p_Setting nclob;
p_CountView char(1);
p_Views integer;
p_CountClick char(1);
p_Clicks integer;
p_Passed char(1);
p_OverdueDate date;
BEGIN
select
 UserID,
 ADType,
 ''+ADName,
 ImgUrl,
 ImgWidth,
 ImgHeight,
 FlashWmode,
 ADIntro,
 LinkUrl,
 LinkTarget,
 LinkAlt,
 Priority,
 Setting,
 CountView,
 ViewsCount,
 CountClick,
 Clicks,
 Passed,
 OverdueDate
 into
 p_UserID,
 p_ADType,
 p_ADName,
 p_ImgUrl,
 p_ImgWidth,
 p_ImgHeight,
 p_FlashWmode,
 p_ADIntro,
 p_LinkUrl,
 p_LinkTarget,
 p_LinkAlt,
 p_Priority,
 p_Setting,
 p_CountView,
 p_Views,
 p_CountClick,
 p_Clicks,
 p_Passed,
 p_OverdueDate
from ZL_Advertisement where ADID=p_ad;
select max(ADID)+1 into p_ADID from ZL_Advertisement;

insert into ZL_Advertisement
  (
   ADID,
   USERID,
   ADType,
   ADName,
   ImgUrl,
   ImgWidth,
   ImgHeight,
   FlashWmode,
   ADIntro,
   LinkUrl,
   LinkTarget,
   LinkAlt,
   Priority,
   Setting,
   CountView,
   ViewsCount,
   CountClick,
   Clicks,
   Passed,
   OverdueDate
 ) values
 (
 p_ADID,
 p_UserID,
 p_ADType,
 p_ADName,
 p_ImgUrl,
 p_ImgWidth,
 p_ImgHeight,
 p_FlashWmode,
 p_ADIntro,
 p_LinkUrl,
 p_LinkTarget,
 p_LinkAlt,
 p_Priority,
 p_Setting,
 p_CountView,
 p_Views,
 p_CountClick,
 p_Clicks,
 p_Passed,
 p_OverdueDate
 );
END dt_advertisement_copy;
/


DROP PROCEDURE DT_ADVERTISEMENT_PASSED
/

CREATE OR REPLACE PROCEDURE        dt_Advertisement_Passed
/******************************************************************************
   NAME:       dt_Advertisement_Passed
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_Advertisement_Passed
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 10:55:13, and 2008-10-11 10:55:13
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
(
strAdId in integer
)
AS
BEGIN
   update ZL_Advertisement set Passed='1' where ADID=strAdId;
END dt_Advertisement_Passed;
/


DROP PROCEDURE DT_ADVERTISEMENT_REMOVE
/

CREATE OR REPLACE PROCEDURE        dt_Advertisement_remove
(
strAdId  in integer
)
AS
BEGIN
   delete from ZL_ZONE_ADVERTISEMENT where ADID=strAdId;
   delete from ZL_Advertisement where ADID=strAdId;   
END dt_Advertisement_remove;
/


DROP PROCEDURE DT_ADVERTISEMENT_UPDATE
/

CREATE OR REPLACE PROCEDURE        dt_Advertisement_Update
(
 p_ADID ZL_Advertisement.ADID%type,
 p_UserID ZL_Advertisement.UserID%type,
 p_ADType ZL_Advertisement.ADType%type,
 p_ADName ZL_Advertisement.ADName%type,
 p_ImgUrl ZL_Advertisement.ImgUrl%type,
 p_ImgWidth ZL_Advertisement.ImgWidth%type,
 p_ImgHeight ZL_Advertisement.ImgHeight%type,
 p_FlashWmode ZL_Advertisement.FlashWmode%type,
 p_ADIntro ZL_Advertisement.ADIntro%type,
 p_LinkUrl ZL_Advertisement.LinkUrl%type,
 p_LinkTarget ZL_Advertisement.LinkTarget%type,
 p_LinkAlt ZL_Advertisement.LinkAlt%type,
 p_Priority ZL_Advertisement.Priority%type,
 p_Setting ZL_Advertisement.Setting%type,
 p_CountView ZL_Advertisement.CountView%type,
 p_Views ZL_Advertisement.ViewsCount%type,
 p_CountClick ZL_Advertisement.CountClick%type,
 p_Clicks ZL_Advertisement.Clicks%type,
 p_Passed ZL_Advertisement.Passed%type,
 p_OverdueDate ZL_Advertisement.OverdueDate%type
)
AS
/******************************************************************************
   NAME:       dt_Advertisement_Update
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_Advertisement_Update
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 10:46:21, and 2008-10-11 10:46:21
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
   update ZL_Advertisement set
   UserID=p_UserID,
   ADType=p_ADType,
   ADName=p_ADName,
   ImgUrl=p_ImgUrl,
   ImgWidth=p_ImgWidth,
   ImgHeight=p_ImgHeight,
   FlashWmode=p_FlashWmode,
   ADIntro=p_ADIntro,
   LinkUrl=p_LinkUrl,
   LinkTarget=p_LinkTarget,
   LinkAlt=p_LinkAlt,Priority=p_Priority,
   Setting=p_Setting,CountView=p_CountView,
   ViewsCount=p_Views,CountClick=p_CountClick,
   Clicks=p_Clicks,
   Passed=p_Passed,
   OverdueDate=p_OverdueDate
   where ADID=p_ADID;
END dt_Advertisement_Update;
/


DROP PROCEDURE DT_ADZONE_ACTIVE
/

CREATE OR REPLACE PROCEDURE dt_ADZone_Active
(
p_ZoneID in integer
)
AS
/******************************************************************************
   NAME:       dt_ADZone_Active
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_ADZone_Active
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 10:50:12, and 2008-10-11 10:50:12
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
   update ZL_AdZone set Active='1' where ZoneID=p_ZoneID;
END dt_ADZone_Active;
/


DROP PROCEDURE DT_ADZONE_ADD
/

CREATE OR REPLACE PROCEDURE dt_ADZone_Add
(
p_ZoneId ZL_AdZone.ZoneID%type,
p_ZoneName ZL_AdZone.ZoneName%type,
p_ZoneJSName ZL_AdZone.ZoneJSName%type,
p_ZoneIntro ZL_AdZone.ZoneIntro%type,
p_ZoneType ZL_AdZone.ZoneType%type,
p_DefaultSetting ZL_AdZone.DefaultSetting%type,
p_ZoneSetting ZL_AdZone.ZoneSetting%type,
p_ZoneWidth ZL_AdZone.ZoneWidth%type,
p_ZoneHeight ZL_AdZone.ZoneHeight%type,
p_Active ZL_AdZone.Active%type,
p_ShowType ZL_AdZone.ShowType%type,
p_UpdateTime ZL_AdZone.UpdateTime%type
)
AS
/******************************************************************************
   NAME:       dt_ADZone_Add
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_ADZone_Add
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 10:56:55, and 2008-10-11 10:56:55
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
insert into ZL_AdZone
(
ZoneID,
ZoneName,
ZoneJSName,
ZoneIntro,
ZoneType,
DefaultSetting,
ZoneSetting,
ZoneWidth,
ZoneHeight,
Active,
ShowType,
UpdateTime
) values(
p_ZoneId,
p_ZoneName,
p_ZoneJSName,
p_ZoneIntro,
p_ZoneType,
p_DefaultSetting,
p_ZoneSetting,
p_ZoneWidth,
p_ZoneHeight,
p_Active,
p_ShowType,
p_UpdateTime
);
END dt_ADZone_Add;
/


DROP PROCEDURE DT_ADZONE_COPY
/

CREATE OR REPLACE PROCEDURE dt_adzone_copy
(
p_zone in integer
)
as
p_ZoneId integer;
p_ZoneName varchar2(50);
p_ZoneJSName varchar2(50);
p_ZoneIntro  varchar2(255);
p_ZoneType   integer ;
p_DefaultSetting char(1);
p_ZoneSetting varchar2(255);
p_ZoneWidth integer ;
p_ZoneHeight integer;
p_Active char(1);
p_ShowType integer;
p_UpdateTime date;
/******************************************************************************
   NAME:       dt_adzone_copy
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_adzone_copy
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 11:06:10, and 2008-10-11 11:06:10
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
select
''+ZoneName,
ZoneJSName,
ZoneIntro,
ZoneType,
DefaultSetting,
ZoneSetting,
ZoneWidth,
ZoneHeight,
Active,
ShowType,
UpdateTime
into
p_ZoneName,
p_ZoneJSName,
p_ZoneIntro,
p_ZoneType,
p_DefaultSetting,
p_ZoneSetting,
p_ZoneWidth,
p_ZoneHeight,
p_Active,
p_ShowType,
p_UpdateTime 
from ZL_AdZone
where ZoneID=p_zone;

select max(ZoneID)+1 into p_ZoneID from ZL_AdZone;
insert into ZL_AdZone
(
ZoneID,
ZoneName,
ZoneJSName,
ZoneIntro,
ZoneType,
DefaultSetting,
ZoneSetting,
ZoneWidth,
ZoneHeight,
Active,
ShowType,
UpdateTime
) values(
p_ZoneId,
p_ZoneName,
p_ZoneJSName,
p_ZoneIntro,
p_ZoneType,
p_DefaultSetting,
p_ZoneSetting,
p_ZoneWidth,
p_ZoneHeight,
p_Active,
p_ShowType,
p_UpdateTime
);
END dt_adzone_copy;
/


DROP PROCEDURE DT_ADZONE_PAUSE
/

CREATE OR REPLACE PROCEDURE dt_ADZone_Pause
(
p_ZoneID in integer
)
AS
/******************************************************************************
   NAME:       dt_ADZone_Pause
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_ADZone_Pause
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 15:27:20, and 2008-10-11 15:27:20
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
   update ZL_AdZone set Active='0' where ZoneID=p_ZoneID;
END dt_ADZone_Pause;
/


DROP PROCEDURE DT_ADZONE_REMOVE
/

CREATE OR REPLACE PROCEDURE        dt_ADZone_Remove
(
p_ZoneID in integer
)
AS
/******************************************************************************
   NAME:       dt_ADZone_Remove
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_ADZone_Remove
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 15:28:58, and 2008-10-11 15:28:58
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
   delete from ZL_ZONE_ADVERTISEMENT where ZoneID=p_ZoneID;
   delete from ZL_AdZone  where ZoneID=p_ZoneID;
END dt_ADZone_Remove;
/


DROP PROCEDURE DT_ADZONE_UPADTE
/

CREATE OR REPLACE PROCEDURE dt_ADZone_Upadte
(
p_ZoneId ZL_AdZone.ZoneID%type,
p_ZoneName ZL_AdZone.ZoneName%type,
p_ZoneJSName ZL_AdZone.ZoneJSName%type,
p_ZoneIntro ZL_AdZone.ZoneIntro%type,
p_ZoneType ZL_AdZone.ZoneType%type,
p_DefaultSetting ZL_AdZone.DefaultSetting%type,
p_ZoneSetting ZL_AdZone.ZoneSetting%type,
p_ZoneWidth ZL_AdZone.ZoneWidth%type,
p_ZoneHeight ZL_AdZone.ZoneHeight%type,
p_Active ZL_AdZone.Active%type,
p_ShowType ZL_AdZone.ShowType%type,
p_UpdateTime ZL_AdZone.UpdateTime%type
)
AS
/******************************************************************************
   NAME:       dt_ADZone_Upadte
   PURPOSE:    

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     dt_ADZone_Upadte
      Sysdate:         2008-10-11
      Date and Time:   2008-10-11, 15:30:24, and 2008-10-11 15:30:24
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
   update ZL_AdZone
   set ZoneName=p_ZoneName,
   ZoneJSName=p_ZoneJSName,
   ZoneIntro=p_ZoneIntro,
   ZoneType=p_ZoneType,
   DefaultSetting=p_DefaultSetting,
   ZoneSetting=p_ZoneSetting,
   ZoneWidth=p_ZoneWidth,
   ZoneHeight=p_ZoneHeight,
   Active=p_Active,
   ShowType=p_ShowType,
   UpdateTime=p_UpdateTime 
   where ZoneID=p_ZoneId;
END dt_ADZone_Upadte;
/


DROP PROCEDURE PR_ADDFIELDTOTABLE
/

CREATE OR REPLACE PROCEDURE PR_AddFieldToTable
(
p_TableName in varchar2,
p_FieldName in varchar2,
p_FieldType in varchar2,
p_DefaultValue in varchar2
)
AS
BEGIN    
    if p_FieldType ='nvarchar' then
		EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' nvarchar2(255) DEFAULT ('''||p_DefaultValue||''')';
	elsif p_FieldType ='varchar' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' varchar2(255) DEFAULT ('''||p_DefaultValue||''')';
    elsif p_FieldType ='ntext' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' nclob DEFAULT ('''||p_DefaultValue||''')';
    elsif p_FieldType ='int' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' integer DEFAULT (0)';
    elsif p_FieldType ='bit' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' char(1) DEFAULT (''0'') check in (''0'',''1'')';
    elsif p_FieldType ='char' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' char(10)';
    elsif p_FieldType ='datetime' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' date DEFAULT (SYSDATE)';
    elsif p_FieldType ='decimal' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' float';
    elsif p_FieldType ='money' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' number(12,2)';
    elsif p_FieldType ='nchar' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' nchar(10)';    
    elsif p_FieldType ='text' then
        EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' clob';	
	elsif p_FieldType ='float' then
		EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' binary_float';
    else
		EXECUTE IMMEDIATE 'ALTER TABLE '||p_TableName||' ADD '||p_FieldName||' varchar2(255) DEFAULT ('''||p_DefaultValue||''')';
	end if;
    commit;
END PR_AddFieldToTable;
/


DROP PROCEDURE PR_AUTHOR_ADD
/

CREATE OR REPLACE PROCEDURE        PR_Author_Add
(
    p_ID ZL_Author.ID%type,
    p_UserId ZL_Author.UserId%type,
    p_Name ZL_Author.Name%type,
    p_Type ZL_Author.Type%type,
    p_Passed ZL_Author.Passed%type,
    p_onTop ZL_Author.onTop%type,
    p_IsElite ZL_Author.IsElite%type,
    p_Hits ZL_Author.Hits%type,
    p_LastUseTime ZL_Author.LastUseTime%type,
    p_TemplateID ZL_Author.TemplateID%type,
    p_Photo ZL_Author.Photo%type,
    p_Intro ZL_Author.Intro%type,
    p_Address ZL_Author.Address%type,
    p_Tel ZL_Author.Tel%type,
    p_Fax ZL_Author.Fax%type,
    p_Mail ZL_Author.Mail%type,
    p_Email ZL_Author.Email%type,
    p_ZipCode ZL_Author.ZipCode%type,
    p_HomePage ZL_Author.HomePage%type,
    p_Im ZL_Author.Im%type,
    p_Sex ZL_Author.Sex%type,
    p_BirthDay ZL_Author.BirthDay%type,
    p_Company ZL_Author.Company%type,
    p_Department ZL_Author.Department%type
)
AS
newID ZL_Author.ID%type;
BEGIN
   select max(ID) into newID from ZL_Author;
   if newID is null then
      newID:=1;
   else
      newID:=newID+1;
   end if;
   INSERT INTO
 ZL_Author(
    ID,
    UserID,
    Type,
    Name,
    Passed,
    onTop,
    IsElite,
    Hits,
    LastUseTime,
    TemplateID,
    Photo,
    Intro,
    Address,
    Tel,
    Fax,
    Mail,
    Email,
    ZipCode,
    HomePage,
    Im,
    Sex,
    BirthDay,
    Company,
    Department
    ) VALUES(
    newID,
    p_UserId,
    p_Type,
    p_Name,
    p_Passed,
    p_onTop,
    p_IsElite,
    p_Hits,
    p_LastUseTime,
    p_TemplateID,
    p_Photo,
    p_Intro,
    p_Address,
    p_Tel,
    p_Fax,
    p_Mail,
    p_Email,
    p_ZipCode,
    p_HomePage,
    p_Im,
    p_Sex,
    p_BirthDay,
    p_Company,
    p_Department);
END PR_Author_Add;
/


DROP PROCEDURE PR_AUTHOR_DELETE
/

CREATE OR REPLACE PROCEDURE        PR_Author_Delete
(
p_ID varchar2
)
AS
BEGIN
   if p_ID is not null then
   EXECUTE IMMEDIATE 'DELETE FROM ZL_Author WHERE ID in('||p_ID||')';
   end if;
END PR_Author_Delete;
/


DROP PROCEDURE PR_AUTHOR_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Author_Update
(
    p_ID ZL_Author.ID%type,     
    p_UserId ZL_Author.UserId%type,
    p_Name ZL_Author.Name%type,
    p_Type ZL_Author.Type%type,
    p_Passed ZL_Author.Passed%type,
    p_onTop ZL_Author.onTop%type,
    p_IsElite ZL_Author.IsElite%type,
    p_Hits ZL_Author.Hits%type,
    p_LastUseTime ZL_Author.LastUseTime%type,
    p_TemplateID ZL_Author.TemplateID%type,
    p_Photo ZL_Author.Photo%type,
    p_Intro ZL_Author.Intro%type,
    p_Address ZL_Author.Address%type,
    p_Tel ZL_Author.Tel%type,
    p_Fax ZL_Author.Fax%type,
    p_Mail ZL_Author.Mail%type,
    p_Email ZL_Author.Email%type,
    p_ZipCode ZL_Author.ZipCode%type,
    p_HomePage ZL_Author.HomePage%type,
    p_Im ZL_Author.Im%type,
    p_Sex ZL_Author.Sex%type,
    p_BirthDay ZL_Author.BirthDay%type,
    p_Company ZL_Author.Company%type,
    p_Department ZL_Author.Department%type
)
AS
BEGIN
   UPDATE ZL_Author SET
		UserID=p_UserId,
        Type=p_Type,Name=p_Name,
        Passed=p_Passed,
        onTop=p_onTop,
        IsElite=p_IsElite,
        Hits=p_Hits,
        LastUseTime=p_LastUseTime,
        TemplateID=p_TemplateID,
        Photo=p_Photo,
        Intro=p_Intro,
        Address=p_Address,
        Tel=p_Tel,
        Fax=p_Fax,
        Mail=p_Mail,
        Email=p_Email,
        ZipCode=p_ZipCode,
        HomePage=p_HomePage,
        Im=p_Im,
        Sex=p_Sex,
        BirthDay=p_BirthDay,
        Company=p_Company,
        Department=p_Department
		WHERE ID=p_ID;
END PR_Author_Update;
/


DROP PROCEDURE PR_CLIENTREQUIRE_ADD
/

CREATE OR REPLACE PROCEDURE PR_ClientRequire_Add
(
p_RequireID ZL_ClientRequire.RequireID%type,
p_Require ZL_ClientRequire.Require%type,
p_UserID ZL_ClientRequire.UserID%type,
p_ReuqireDate ZL_ClientRequire.ReuqireDate%type
)
AS
newID ZL_ClientRequire.RequireID%type;
BEGIN
   select max(RequireID) into newID from ZL_ClientRequire;
   if newID is null then
      newID:=1;
   else
      newID:=newID+1;
   end if;
   INSERT INTO ZL_ClientRequire (
   RequireID,
   Require,
   UserID,
   ReuqireDate 
   ) VALUES (
   newID,
   p_Require,
   p_UserID,
   p_ReuqireDate
   );
END PR_ClientRequire_Add;
/


DROP PROCEDURE PR_CLIENTREQUIRE_DELETE
/

CREATE OR REPLACE PROCEDURE PR_ClientRequire_Delete
(
p_ID in integer
)
AS
BEGIN
   delete from ZL_ClientRequire where RequireID=p_ID;
END PR_ClientRequire_Delete;
/


DROP PROCEDURE PR_CLIENTREQUIRE_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_ClientRequire_Update
(
p_RequireID ZL_ClientRequire.RequireID%type,
p_Require ZL_ClientRequire.Require%type,
p_UserID ZL_ClientRequire.UserID%type,
p_ReuqireDate ZL_ClientRequire.ReuqireDate%type
)
AS
BEGIN
   update ZL_ClientRequire set 
   Require=p_Require,
   UserID=p_UserID,
   ReuqireDate=p_ReuqireDate
   where RequireID=p_RequireID;
END PR_ClientRequire_Update;
/


DROP PROCEDURE PR_COMMENTS_ADD
/

CREATE OR REPLACE PROCEDURE PR_Comments_Add
(
p_CommentID ZL_Comment.CommentID%type,
p_GeneralID ZL_Comment.GeneralID%type,
p_Title ZL_Comment.Title%type,
p_Contents ZL_Comment.Contents%type,
p_Audited ZL_Comment.Audited%type,
p_UserID ZL_Comment.UserID%type,
p_CommentTime ZL_Comment.CommentTime%type,
p_Score ZL_Comment.Score%type,
p_PK ZL_Comment.PK%type
)
AS
newID ZL_Comment.CommentID%type;
BEGIN
   select max(CommentID) into newID from ZL_Comment;
   if newID is Null then
      newID:=1;
   else
      newID:=newID+1;
   end if;
   INSERT INTO ZL_Comment
    (
     CommentID,
     GeneralID,
     Title,
     Contents,
     Audited,
     UserID,
     CommentTime,
     Score,
     PK
    ) VALUES (
     newID,
     p_GeneralID,
     p_Title,
     p_Contents,
     p_Audited,
     p_UserID,
     p_CommentTime,
     p_Score,
     p_PK
    );
END PR_Comments_Add;
/


DROP PROCEDURE PR_COMMENTS_AUDIT
/

CREATE OR REPLACE PROCEDURE PR_Comments_Audit
(
p_CommentID ZL_COMMENT.COMMENTID%Type
)
AS
BEGIN
   UPDATE ZL_Comment SET Audited='1' where CommentID=p_CommentID;
END PR_Comments_Audit;
/


DROP PROCEDURE PR_COMMENTS_DEL
/

CREATE OR REPLACE PROCEDURE PR_Comments_Del
(
p_CommentID ZL_COMMENT.COMMENTID%Type
)
AS
BEGIN
   Delete from ZL_Comment where CommentID=p_CommentID;
END PR_Comments_Del;
/


DROP PROCEDURE PR_CONTENT_ADD
/

CREATE OR REPLACE PROCEDURE PR_Content_Add
(
    P_TableName varchar2,
    P_FieldList varchar2,
    P_FieldValue varchar2,
    P_NodeID ZL_COMMONMODEL.NODEID%type,
    P_ModelID ZL_COMMONMODEL.MODELID%type,
    P_Title ZL_COMMONMODEL.TITLE%type,
    P_Inputer ZL_COMMONMODEL.INPUTER%type,
    P_EliteLevel ZL_COMMONMODEL.ELITELEVEL%type,
	P_InfoID ZL_COMMONMODEL.INFOID%type,
	P_SpecialID ZL_COMMONMODEL.SPECIALID%type
)
AS
newID integer;
nID integer;
BEGIN
   EXECUTE IMMEDIATE 'select max(id) into newID from'||p_TableName;
   if newID is null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   EXECUTE IMMEDIATE 'Insert Into ' ||p_TableName || ' (ID,' || p_FieldList || ') values(' ||newID || p_FieldValue || ')';
   select max(GeneralID) into nID from ZL_CommonModel;
   if nID is null then
   nID:=1;
   else
   nID:=nID+1;
   end if;
   EXECUTE IMMEDIATE 'Insert Into ZL_CommonModel (GeneralID,NodeID,ModelID,ItemID,Title,Inputer,EliteLevel,InfoID,SpecialID)
	 Values ('||nID ||','||p_NodeID||','||p_ModelID||','||newID||','||p_Title||','||p_Inputer||','
	 ||p_EliteLevel||','||p_InfoID||','||p_SpecialID||')';
END PR_Content_Add;
/


DROP PROCEDURE PR_CONTENT_DEL
/

CREATE OR REPLACE PROCEDURE PR_Content_Del
(
TableName varchar2,
pItemID integer,
pGeneralID integer
)
AS
BEGIN
   EXECUTE IMMEDIATE 'Delete From '||TableName||' Where ID='||pItemID;
   EXECUTE IMMEDIATE 'Delete From ZL_CommonModel Where GeneralID='||pGeneralID;
END PR_Content_Del;
/


DROP PROCEDURE PR_CONTENT_READ
/

CREATE OR REPLACE PROCEDURE PR_Content_Read
(
TableName varchar2,
p_ItemID integer
)
AS
BEGIN
   EXECUTE IMMEDIATE 'Select * From '||TableName||' Where ID='||p_ItemID;
END PR_Content_Read;
/


DROP PROCEDURE PR_CONTENT_RESET
/

CREATE OR REPLACE PROCEDURE PR_Content_Reset
(
p_GeneralID ZL_COMMONMODEL.GENERALID%TYPE
)
AS
BEGIN
   UPDATE  ZL_CommonModel SET
	Status=0
	Where GeneralID=p_GeneralID;
END PR_Content_Reset;
/


DROP PROCEDURE PR_CONTENT_RESETALL
/

CREATE OR REPLACE PROCEDURE PR_Content_ResetAll
AS
BEGIN
   UPDATE  ZL_CommonModel SET
	Status=0
	Where Status=-2;
END PR_Content_ResetAll;
/


DROP PROCEDURE PR_CONTENT_SETAUDIT
/

CREATE OR REPLACE PROCEDURE PR_Content_SetAudit
(
p_GeneralID ZL_COMMONMODEL.GENERALID%TYPE
)
AS
BEGIN
   UPDATE  ZL_CommonModel SET
	Status=99
	Where GeneralID=p_GeneralID;
END PR_Content_SetAudit;
/


DROP PROCEDURE PR_CONTENT_SETDEL
/

CREATE OR REPLACE PROCEDURE PR_Content_SetDel
(
p_GeneralID ZL_COMMONMODEL.GENERALID%TYPE
)
AS
BEGIN
   UPDATE  ZL_CommonModel SET
	Status=-2
	Where GeneralID=p_GeneralID;
END PR_Content_SetDel;
/


DROP PROCEDURE PR_CONTENT_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Content_UpDate
(
TableName varchar2,
FieldSet varchar2,
p_Title nvarchar2,
p_EliteLevel integer,
p_InfoID varchar2,
p_SpecialID varchar2,
p_ItemID integer,
p_GeneralID integer
)
AS
BEGIN
   EXECUTE IMMEDIATE 'Update '||TableName ||' Set '||FieldSet||' Where [ID]='||p_ItemID;
   Update ZL_CommonModel Set 
   Title=p_Title,
   EliteLevel=p_EliteLevel,
   InfoID=p_InfoID,
   SpecialID=p_SpecialID Where GeneralID=p_GeneralID;
END PR_Content_UpDate;
/


DROP PROCEDURE PR_CORRECT_ADD
/

CREATE OR REPLACE PROCEDURE        PR_Correct_Add
(
p_CorrectID ZL_CORRECT.CORRECTID%TYPE,
p_CorrectTitle ZL_CORRECT.CORRECTTITLE%TYPE,
p_CorrectUrl ZL_CORRECT.CORRECTURL%TYPE,
p_CorrectType ZL_CORRECT.CORRECTTYPE%TYPE,
p_CorrectDetail ZL_CORRECT.CORRECTDETAIL%TYPE,
p_CorrectPer ZL_CORRECT.CORRECTPER%TYPE,
p_CorrectEmail ZL_CORRECT.PEREMAIL%TYPE
)
AS
newID ZL_CORRECT.CORRECTID%TYPE;
BEGIN
   select max(CorrectID) into newID from ZL_Correct;
   if newID is null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   Insert into ZL_Correct 
(
CorrectID,
CorrectTitle,
CorrectUrl,
CorrectType,
CorrectDetail,
CorrectPer,
PerEmail
) values
(
newID,
p_CorrectTitle,
p_CorrectUrl,
p_CorrectType,
p_CorrectDetail,
p_CorrectPer,
p_CorrectEmail
);
END PR_Correct_Add;
/


DROP PROCEDURE PR_CORRECT_DEL
/

CREATE OR REPLACE PROCEDURE PR_Correct_Del
(
p_CorrectID ZL_CORRECT.CORRECTID%TYPE
)
AS
BEGIN
   Delete from ZL_Correct where CorrectID=p_CorrectID;
END PR_Correct_Del;
/


DROP PROCEDURE PR_DELTABLEFIELD
/

CREATE OR REPLACE PROCEDURE PR_DelTableField
(
TableName varchar2,
FieldName varchar2
)
AS
BEGIN
   EXECUTE IMMEDIATE 'ALTER TABLE '||TableName||' DROP COLUMN'||FieldName;
END PR_DelTableField;
/


DROP PROCEDURE PR_DOWNSERVER_ADD
/

CREATE OR REPLACE PROCEDURE PR_DownServer_Add
(
p_ServerID ZL_DOWNSERVER.SERVERID%TYPE,
p_ServerName ZL_DOWNSERVER.SERVERNAME%TYPE,
p_ServerUrl ZL_DOWNSERVER.SERVERURL%TYPE,
p_ServerLogo ZL_DOWNSERVER.SERVERLOGO%TYPE,
p_OrderID ZL_DOWNSERVER.ORDERID%TYPE,
p_ShowType ZL_DOWNSERVER.SHOWTYPE%TYPE
)
AS
BEGIN
   INSERT INTO
        ZL_DownServer
        (
        ServerID,
        ServerName,
        ServerUrl,
        ServerLogo,
        OrderID,
        ShowType
        )VALUES(
        p_ServerID,
        p_ServerName,
        p_ServerUrl,
        p_ServerLogo,
        p_OrderID,
        p_ShowType
        );  
END PR_DownServer_Add;
/


DROP PROCEDURE PR_DOWNSERVER_DELETE
/

CREATE OR REPLACE PROCEDURE PR_DownServer_Delete
(
p_ServerID varchar2
)
AS
BEGIN
   EXECUTE IMMEDIATE 'DELETE  FROM ZL_DownServer WHERE ServerID  IN ('||p_ServerID||')';
END PR_DownServer_Delete;
/


DROP PROCEDURE PR_DOWNSERVER_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_DownServer_Update
(
p_ServerID ZL_DOWNSERVER.SERVERID%TYPE,
p_ServerName ZL_DOWNSERVER.SERVERNAME%TYPE,
p_ServerUrl ZL_DOWNSERVER.SERVERURL%TYPE,
p_ServerLogo ZL_DOWNSERVER.SERVERLOGO%TYPE,
p_OrderID ZL_DOWNSERVER.ORDERID%TYPE,
p_ShowType ZL_DOWNSERVER.SHOWTYPE%TYPE
)
AS
BEGIN
   UPDATE ZL_DownServer 
	SET ServerName=p_ServerName,
    ServerUrl=p_ServerUrl,
    ServerLogo=p_ServerLogo,
    OrderID=p_OrderID,
    ShowType=p_ShowType WHERE ServerID=p_ServerID;
END PR_DownServer_Update;
/


DROP PROCEDURE PR_DOWNSERVER_UPDATEORDERID
/

CREATE OR REPLACE PROCEDURE PR_DownServer_UpdateOrderId
(
p_ServerID ZL_DOWNSERVER.SERVERID%TYPE,
p_OrderID ZL_DOWNSERVER.ORDERID%TYPE
)
AS
BEGIN
   UPDATE ZL_DownServer 
	SET OrderID=p_OrderID WHERE ServerID=p_ServerID;
END PR_DownServer_UpdateOrderId;
/


DROP PROCEDURE PR_EXPHIS_ADD
/

CREATE OR REPLACE PROCEDURE PR_ExpHis_Add
(
p_ExpHisID ZL_USEREXPHIS.EXPHISID%TYPE,
p_UserID ZL_USEREXPHIS.USERID%TYPE,
p_HisAction ZL_USEREXPHIS.HISACTION%TYPE,
p_detail ZL_USEREXPHIS.DETAIL%TYPE,
p_score ZL_USEREXPHIS.SCORE%TYPE,
p_HisTime ZL_USEREXPHIS.HISTIME%TYPE
)
AS
newID ZL_USEREXPHIS.EXPHISID%TYPE;
BEGIN
select max(ExpHisID) into newID from ZL_UserExpHis;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
Insert Into ZL_UserExpHis
(
ExpHisID,
UserID,
HisAction,
detail,
score,
HisTime
)
values
(
newID,
p_UserID,
p_HisAction,
p_detail,
p_score,
p_HisTime
);
END PR_ExpHis_Add;
/


DROP PROCEDURE PR_FAVORITE_ADD
/

CREATE OR REPLACE PROCEDURE PR_Favorite_Add
(
p_FavoriteID ZL_FAVORITE.FAVORITEID%TYPE,
p_Owner ZL_FAVORITE.OWNER%TYPE,
p_InfoID ZL_FAVORITE.INFOID%TYPE,
p_FavoriteDate ZL_FAVORITE.FAVORITEDATE%TYPE
)
AS
newID ZL_FAVORITE.FAVORITEID%TYPE;
BEGIN
   select max(FavoriteID) into newID from ZL_FAVORITE;
   if newID is null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   Insert Into ZL_Favorite 
   (
   FavoriteID,
   Owner,
   InfoID,
   FavoriteDate
   ) values(
   newID,
   p_Owner,
   p_InfoID,
   p_FavoriteDate
   );
END PR_Favorite_Add;
/


DROP PROCEDURE PR_FAVORITE_DEL
/

CREATE OR REPLACE PROCEDURE PR_Favorite_Del
(
p_FavoriteID ZL_FAVORITE.FAVORITEID%TYPE
)
AS
BEGIN
   Delete from ZL_Favorite Where FavoriteID=p_FavoriteID;
END PR_Favorite_Del;
/


DROP PROCEDURE PR_GROUPFIELDPERMISSIONS_ADD
/

CREATE OR REPLACE PROCEDURE PR_GroupFieldPermissions_Add
(
p_ID ZL_GROUPFIELDPERMISSIONS.ID%TYPE,
p_GroupID ZL_GROUPFIELDPERMISSIONS.GROUPID%TYPE,
p_OperateCode ZL_GROUPFIELDPERMISSIONS.OPERATECODE%TYPE,
p_ProjectID ZL_GROUPFIELDPERMISSIONS.PROJECTID%TYPE,
p_FieldID ZL_GROUPFIELDPERMISSIONS.FIELDID%TYPE,
p_FieldName ZL_GROUPFIELDPERMISSIONS.FIELDNAME%TYPE,
p_IdType ZL_GROUPFIELDPERMISSIONS.IDTYPE%TYPE
)
AS
newID ZL_GROUPFIELDPERMISSIONS.ID%TYPE;
BEGIN
   select max(ID) into newID from ZL_GroupFieldPermissions;
   if newID is Null then
      newID:=1;
   else
      newID:=newID+1;
   end if;
   Insert into ZL_GroupFieldPermissions 
   (
   ID,
   GroupID,
   OperateCode,
   ProjectID,
   FieldID,
   FieldName,
   IdType
   ) values (
   newID,
   p_GroupID,
   p_OperateCode,
   p_ProjectID,
   p_FieldID,
   p_FieldName,
   p_IdType);
END PR_GroupFieldPermissions_Add;
/


DROP PROCEDURE PR_GROUPFIELDPERMISSIONS_UPDAT
/

CREATE OR REPLACE PROCEDURE PR_GroupFieldPermissions_Updat
(
p_ID ZL_GROUPFIELDPERMISSIONS.ID%TYPE,
p_GroupID ZL_GROUPFIELDPERMISSIONS.GROUPID%TYPE,
p_OperateCode ZL_GROUPFIELDPERMISSIONS.OPERATECODE%TYPE,
p_ProjectID ZL_GROUPFIELDPERMISSIONS.PROJECTID%TYPE,
p_FieldID ZL_GROUPFIELDPERMISSIONS.FIELDID%TYPE,
p_FieldName ZL_GROUPFIELDPERMISSIONS.FIELDNAME%TYPE,
p_IdType ZL_GROUPFIELDPERMISSIONS.IDTYPE%TYPE
)
AS
BEGIN
   Update ZL_GroupFieldPermissions set 
   GroupID=p_GroupID,
   OperateCode=p_OperateCode,
   ProjectID=p_ProjectID,
   FieldID=p_FieldID,
   FieldName=p_FieldName,
   IdType=p_IdType where ID=p_ID;
END PR_GroupFieldPermissions_Updat;
/


DROP PROCEDURE PR_GROUP_ADD
/

CREATE OR REPLACE PROCEDURE PR_Group_Add
(
p_GroupID ZL_GROUP.GROUPID%TYPE,
p_GroupName ZL_GROUP.GROUPNAME%TYPE,
p_Description ZL_GROUP.DESCRIPTION%TYPE,
p_RegSelect ZL_GROUP.REGSELECT%TYPE
)
AS
newID ZL_GROUP.GROUPID%TYPE;
BEGIN
   select max(GroupID) into newID from ZL_Group;
   if newID is null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   Insert into ZL_Group 
   (
   GroupID,
   GroupName,
   Description,
   RegSelect
   ) values (
   newID,
   p_GroupName,
   p_Description,
   p_RegSelect
   );
END PR_Group_Add;
/


DROP PROCEDURE PR_GROUP_DEL
/

CREATE OR REPLACE PROCEDURE PR_Group_Del
(
p_GroupID ZL_GROUP.GROUPID%TYPE
)
AS
BEGIN
   delete from ZL_Group where GroupID=p_GroupID;
END PR_Group_Del;
/


DROP PROCEDURE PR_GROUP_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Group_Update
(
p_GroupID ZL_GROUP.GROUPID%TYPE,
p_GroupName ZL_GROUP.GROUPNAME%TYPE,
p_Description ZL_GROUP.DESCRIPTION%TYPE,
p_RegSelect ZL_GROUP.REGSELECT%TYPE
)
AS
BEGIN
   Update ZL_Group set 
   GroupName=p_GroupName,
   Description=p_Description,
   RegSelect=p_RegSelect where GroupID=p_GroupID;
END PR_Group_Update;
/


DROP PROCEDURE PR_KEYWORDS_ADD
/

CREATE OR REPLACE PROCEDURE PR_Keywords_Add
(
p_KeywordID ZL_KEYWORDS.KEYWORDID%TYPE,
p_KeywordText ZL_KEYWORDS.KEYWORDTEXT%TYPE,
p_KeywordType ZL_KEYWORDS.KEYWORDTYPE%TYPE,
p_Priority ZL_KEYWORDS.PRIORITY%TYPE,
p_Hits ZL_KEYWORDS.HITS%TYPE,
p_lastUseTime ZL_KEYWORDS.LASTUSETIME%TYPE,
p_ArrayGeneralId ZL_KEYWORDS.ARRGENERALID%TYPE,
p_QuoteTimes ZL_KEYWORDS.QUOTETIMES%TYPE
)
AS
newID ZL_KEYWORDS.KEYWORDID%TYPE;
BEGIN
   select max(KeywordID) into newID from ZL_Keywords;   
    if newID is Null then
    newID:=1;
    else
    newID:=newID+1;
    end if;
   INSERT INTO ZL_Keywords 
   (
   KEYWORDID,
   KeywordText,
   KeywordType,
   Priority,Hits,
   lastUseTime,
   arrGeneralID,
   QuoteTimes
   ) VALUES (
   newID,
   p_KeywordText,
   p_KeywordType,
   p_Priority, 
   p_Hits, 
   p_lastUseTime,
   p_ArrayGeneralId,
   p_QuoteTimes
   );
END PR_Keywords_Add;
/


DROP PROCEDURE PR_KEYWORDS_DELETE
/

CREATE OR REPLACE PROCEDURE PR_Keywords_Delete
(
p_KeywordID varchar2
)
AS
BEGIN
   EXECUTE IMMEDIATE 'DELETE  FROM ZL_Keywords WHERE KeywordId IN (' || p_KeywordId || ')';
END PR_Keywords_Delete;
/


DROP PROCEDURE PR_KEYWORDS_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Keywords_Update(
p_KeywordID ZL_KEYWORDS.KEYWORDID%TYPE,
p_KeywordText ZL_KEYWORDS.KEYWORDTEXT%TYPE,
p_KeywordType ZL_KEYWORDS.KEYWORDTYPE%TYPE,
p_Priority ZL_KEYWORDS.PRIORITY%TYPE,
p_Hits ZL_KEYWORDS.HITS%TYPE,
p_lastUseTime ZL_KEYWORDS.LASTUSETIME%TYPE,
p_ArrayGeneralId ZL_KEYWORDS.ARRGENERALID%TYPE,
p_QuoteTimes ZL_KEYWORDS.QUOTETIMES%TYPE
)
AS
BEGIN
   UPDATE 
		ZL_Keywords
    SET 
        KeywordText = p_KeywordText,
        Hits=p_Hits,
        KeywordType=p_KeywordType,
        Priority=p_Priority,
        LastUseTime=p_LastUseTime,
        arrGeneralID=p_ArrayGeneralId,
        QuoteTimes=p_QuoteTimes
    WHERE 
         KeywordID = p_KeywordID;
END PR_Keywords_Update;
/


DROP PROCEDURE PR_LABEL_ADD
/

CREATE OR REPLACE PROCEDURE PR_Label_Add
(
pLabelID ZL_LABEL.LABELID%TYPE,
pLabelName ZL_LABEL.LABELNAME%TYPE,
pLabelType ZL_LABEL.LABELTYPE%TYPE,
pLabelCate ZL_LABEL.LABELCATE%TYPE,
pLabelDesc ZL_LABEL.LABELDESC%TYPE,
pLabelParam ZL_LABEL.LABELPARAM%TYPE,
pLabelTable ZL_LABEL.LABELTABLE%TYPE,
pLabelField ZL_LABEL.LABELFIELD%TYPE,
pLabelWhere ZL_LABEL.LABELWHERE%TYPE,
pLabelOrder ZL_LABEL.LABELORDER%TYPE,
pLabelContent ZL_LABEL.LABELCONTENT%TYPE,
pLabelCount ZL_LABEL.LABELCOUNT%TYPE
)
AS
newID ZL_LABEL.LABELID%TYPE;
BEGIN
   select max(labelID) into newID from ZL_Label;
   if newID is Null then
    newID:=1;
    else
    newID:=newID+1;
    end if;
   INSERT INTO ZL_Label 
	(		
		LabelID,
        LabelName,
		LabelType,
		LabelCate,
		LabelDesc,
		LabelParam,
		LabelTable,
		LabelField,
		LabelWhere,
		LabelOrder,
		LabelContent,
		LabelCount
	)
	values
	(		
		newID,
        pLabelName,
		pLabelType,
		pLabelCate,
		pLabelDesc,
		pLabelParam,	
		pLabelTable,
		pLabelField,
		pLabelWhere,
		pLabelOrder,
		pLabelContent,
		pLabelCount
     );
END PR_Label_Add;
/


DROP PROCEDURE PR_LABEL_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Label_Update
(
pLabelID ZL_LABEL.LABELID%TYPE,
pLabelName ZL_LABEL.LABELNAME%TYPE,
pLabelType ZL_LABEL.LABELTYPE%TYPE,
pLabelCate ZL_LABEL.LABELCATE%TYPE,
pLabelDesc ZL_LABEL.LABELDESC%TYPE,
pLabelParam ZL_LABEL.LABELPARAM%TYPE,
pLabelTable ZL_LABEL.LABELTABLE%TYPE,
pLabelField ZL_LABEL.LABELFIELD%TYPE,
pLabelWhere ZL_LABEL.LABELWHERE%TYPE,
pLabelOrder ZL_LABEL.LABELORDER%TYPE,
pLabelContent ZL_LABEL.LABELCONTENT%TYPE,
pLabelCount ZL_LABEL.LABELCOUNT%TYPE
)
AS
BEGIN
   UPDATE ZL_Label
	Set		
		LabelName=pLabelName,
		LabelType=pLabelType,
		LabelCate=pLabelCate,
		LabelDesc=pLabelDesc,
		LabelParam=pLabelParam,
		LabelTable=pLabelTable,
		LabelField=pLabelField,
		LabelWhere=pLabelWhere,
		LabelOrder=pLabelOrder,
		LabelContent=pLabelContent,
		LabelCount=pLabelCount
	Where LabelID=pLabelID;
END PR_Label_Update;
/


DROP PROCEDURE PR_MANAGE_ADD
/

CREATE OR REPLACE PROCEDURE        PR_Manage_Add
(
pAdminName ZL_MANAGER.ADMINNAME%TYPE,
pAdminPassword ZL_MANAGER.ADMINPASSWORD%TYPE,
pUserName ZL_MANAGER.USERNAME%TYPE,
pEnableMultiLogin ZL_MANAGER.ENABLEMULTILOGIN%TYPE,
pLastLoginIp ZL_MANAGER.LASTLOGINIP%TYPE,
pIsLock ZL_MANAGER.ISLOCK%TYPE,
pEnableModifyPassword ZL_MANAGER.ENABLEMODIFYPASSWORD%TYPE,
pAdminRole ZL_MANAGER.ADMINROLE%TYPE,
pTheme ZL_MANAGER.THEME%TYPE,
pRndPassword ZL_MANAGER.RANDNUMBER%TYPE
)
AS
newID ZL_MANAGER.ADMINID%TYPE;
BEGIN
   select max(AdminID) into newID from ZL_Manager;
   if newID is Null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   INSERT INTO ZL_Manager
   (
   AdminID,
AdminName,
AdminPassword,
UserName,
EnableMultiLogin,
LastLoginIP,
IsLock,
EnableModifyPassword,
AdminRole,
Theme,
RandNumber
)VALUES(
newID,
pAdminName,
pAdminPassword,
pUserName,
pEnableMultiLogin,
pLastLoginIp,
pIsLock,
pEnableModifyPassword,
pAdminRole,
pTheme,
pRndPassword
);
END PR_Manage_Add;
/


DROP PROCEDURE PR_MANAGE_UPDATE
/

CREATE OR REPLACE PROCEDURE        PR_Manage_Update
(
pAdminID ZL_MANAGER.ADMINID%TYPE,
pAdminName ZL_MANAGER.ADMINNAME%TYPE,
pAdminPassword ZL_MANAGER.ADMINPASSWORD%TYPE,
pUserName ZL_MANAGER.USERNAME%TYPE,
pEnableMultilogin ZL_MANAGER.ENABLEMULTILOGIN%TYPE,
pLoginTimes ZL_MANAGER.LOGINTIMES%TYPE,
pLastLoginIp ZL_MANAGER.LASTLOGINIP%TYPE,
pLastLoginTime ZL_MANAGER.LASTLOGINTIME%TYPE,
pLastLogoutTime ZL_MANAGER.LASTLOGOUTTIME%TYPE,
pLastModifyPasswordTime ZL_MANAGER.LASTMODIFYPWDTIME%TYPE,
pIsLock ZL_MANAGER.ISLOCK%TYPE,
pEnableModifyPassword ZL_MANAGER.ENABLEMODIFYPASSWORD%TYPE,
pRoleList ZL_MANAGER.ADMINROLE%TYPE,
pTheme ZL_MANAGER.THEME%TYPE
)
AS
BEGIN
   UPDATE ZL_Manager SET 
AdminName=pAdminName,
AdminPassword=pAdminPassword,
UserName=pUserName,
EnableMultilogin=pEnableMultilogin,
LoginTimes=pLoginTimes,
LastLoginIP=pLastLoginIp,
LastLoginTime=pLastLoginTime,
LastLogoutTime=pLastLogoutTime,
LastModifyPwdTime=pLastModifyPasswordTime,
IsLock=pIsLock,
EnableModifyPassword=pEnableModifyPassword,
AdminRole=pRoleList,
Theme=pTheme 
WHERE AdminId=pAdminID;
END PR_Manage_Update;
/


DROP PROCEDURE PR_MODELFIELD_ADD
/

CREATE OR REPLACE PROCEDURE        PR_ModelField_Add
(
pFieldID ZL_MODELFIELD.FIELDID%TYPE,
pModelID ZL_MODELFIELD.MODELID%TYPE,
pFieldName ZL_MODELFIELD.FIELDNAME%TYPE,
pFieldAlias ZL_MODELFIELD.FIELDALIAS%TYPE,
pFieldTips ZL_MODELFIELD.FIELDTIPS%TYPE,
pDescription ZL_MODELFIELD.DESCRIPTION%TYPE,
pIsNotNull ZL_MODELFIELD.ISNOTNULL%TYPE,
pIsSearchForm ZL_MODELFIELD.ISSEARCHFORM%TYPE,
pFieldType ZL_MODELFIELD.FIELDTYPE%TYPE,
pContent ZL_MODELFIELD.CONTENT%TYPE
)
AS
newID ZL_MODELFIELD.FIELDID%TYPE;
pOrderId ZL_MODELFIELD.ORDERID%TYPE;
BEGIN
   select Max(OrderId) into pOrderId from ZL_ModelField where ModelID=pModelID;
    select max(ModelID) into newID from ZL_ModelField;
	if pOrderId is null then
		pOrderId:=0;
	else
		pOrderId:=pOrderId+1;
	end if;
	if newID is Null then
	newID:=1;
	else
	newID:=newID+1;
	end if;
	INSERT INTO ZL_ModelField
	(
		FieldID,
        ModelID,
		FieldName,
		FieldAlias,
		FieldTips,
		Description,
		IsNotNull,
		IsSearchForm,
		FieldType,
		Content,
		OrderId
	)
	 VALUES
	(
		newID,
        pModelID,
		pFieldName,
		pFieldAlias,
		pFieldTips,
		pDescription,
		pIsNotNull,
		pIsSearchForm,
		pFieldType,
		pContent,
		pOrderId
	);
END PR_ModelField_Add;
/


DROP PROCEDURE PR_MODELFIELD_DEL
/

CREATE OR REPLACE PROCEDURE PR_ModelField_Del
(
pFieldID ZL_MODELFIELD.FIELDID%TYPE
)
AS
BEGIN
   delete from ZL_ModelField where FieldID=pFieldID;
END PR_ModelField_Del;
/


DROP PROCEDURE PR_MODELFIELD_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_ModelField_Update
(
pFieldID ZL_MODELFIELD.FIELDID%TYPE,
pModelID ZL_MODELFIELD.MODELID%TYPE,
pFieldName ZL_MODELFIELD.FIELDNAME%TYPE,
pFieldAlias ZL_MODELFIELD.FIELDALIAS%TYPE,
pFieldTips ZL_MODELFIELD.FIELDTIPS%TYPE,
pDescription ZL_MODELFIELD.DESCRIPTION%TYPE,
pIsNotNull ZL_MODELFIELD.ISNOTNULL%TYPE,
pIsSearchForm ZL_MODELFIELD.ISSEARCHFORM%TYPE,
pFieldType ZL_MODELFIELD.FIELDTYPE%TYPE,
pContent ZL_MODELFIELD.CONTENT%TYPE
)
AS
BEGIN
   UPDATE ZL_ModelField 
	SET 
	FieldAlias= pFieldAlias,
	FieldTips=pFieldTips,
	Description = pDescription,
	IsNotNull = pIsNotNull,
	IsSearchForm = pIsSearchForm,
	Content = pContent
	 WHERE FieldID = pFieldID and ModelID=pModelID;
END PR_ModelField_Update;
/


DROP PROCEDURE PR_MODEL_ADD
/

CREATE OR REPLACE PROCEDURE        PR_Model_Add
(
pModelID ZL_MODEL.MODELID%TYPE,
pModelName ZL_MODEL.MODELNAME%TYPE,
pDescription ZL_MODEL.DESCRIPTION%TYPE,
pTableName ZL_MODEL.TABLENAME%TYPE,
pItemName ZL_MODEL.ITEMNAME%TYPE,
pItemUnit ZL_MODEL.ITEMUNIT%TYPE,
pItemIcon ZL_MODEL.ITEMICON%TYPE,
pModelType ZL_MODEL.MODELTYPE%TYPE
)
AS
newID ZL_MODEL.MODELID%TYPE;
BEGIN
    if pModelID=0 then
    
        select max(ModelID) into newID from ZL_MODEL;
        if newID is Null then
        newID:=1;
        else
        newID:=newID+1;
        end if; 
    INSERT INTO 
    ZL_Model 
    (  
        ModelID,
        ModelName,    
        Description, 
        TableName,
        ItemName,
        ItemUnit,  
        ItemIcon,
        ModelType
        )
        VALUES
        (
        newID,
        pModelName,
        pDescription,
        pTableName,
        pItemName,
        pItemUnit,
        pItemIcon,
        pModelType
        );
    -- ڴָݱ
    EXECUTE IMMEDIATE 'CREATE TABLE '|| pTableName||' (ID integer primary key not null)';    
    ELSE
        update ZL_Model set ModelName=pModelName,
        Description=pDescription, 
        TableName=pTableName,
        ItemName=pItemName,
        ItemUnit=pItemUnit,  
        ItemIcon=pItemIcon
    where ModelID=pModelID;
    END if;
END PR_Model_Add;
/


DROP PROCEDURE PR_MODEL_DEL
/

CREATE OR REPLACE PROCEDURE        PR_Model_Del
(
pTableName ZL_MODEL.TABLENAME%TYPE
)
AS
BEGIN
   if pTableName is not null then
   EXECUTE IMMEDIATE 'DROP Table '||pTableName;
   end if;
END PR_Model_Del;
/


DROP PROCEDURE PR_NODES_ADD
/

CREATE OR REPLACE PROCEDURE PR_Nodes_Add
(
pNodeID in out ZL_NODE.NODEID%TYPE,
pNodeName ZL_NODE.NODENAME%TYPE,
pNodeType ZL_NODE.NODETYPE%TYPE,
pTips ZL_NODE.TIPS%TYPE,
pNodeDir ZL_NODE.NODEDIR%TYPE,
pNodeUrl ZL_NODE.NODEURL%TYPE,
pParentID ZL_NODE.PARENTID%TYPE,
pChild ZL_NODE.CHILD%TYPE,
pDepth ZL_NODE.DEPTH%TYPE,
pNodePicUrl ZL_NODE.NODEPICURL%TYPE,
pDescription ZL_NODE.DESCRIPTION%TYPE,
pMeta_Keywords ZL_NODE.META_KEYWORDS%TYPE,
pMeta_Description ZL_NODE.META_DESCRIPTION%TYPE,
pOpenType ZL_NODE.OPENTYPE%TYPE,
pPurviewType ZL_NODE.PURVIEWTYPE%TYPE,
pCommentType ZL_NODE.COMMENTTYPE%TYPE,
pHitsOfHot ZL_NODE.HITSOFHOT%TYPE,
pListTemplateFile ZL_NODE.LISTTEMPLATEFILE%TYPE,
pIndexTemplate ZL_NODE.INDEXTEMPLATE%TYPE,
pContentModel ZL_NODE.CONTENTMODEL%TYPE,
pItemOpenType ZL_NODE.ITEMOPENTYPE%TYPE,
pContentHtmlRule ZL_NODE.CONTENTHTMLRULE%TYPE,
pListPageHtmlEx ZL_NODE.LISTPAGEHTMLEX%TYPE,
pContentFileEx ZL_NODE.CONTENTFILEEX%TYPE,
pHtmlPosition ZL_NODE.HTMLPOSITION%TYPE,
pOrderID ZL_NODE.ORDERID%TYPE
)
AS
newID ZL_NODE.NODEID%TYPE;
BEGIN
   select max(NodeID) into newID from ZL_Node;
   if newID is Null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   INSERT INTO ZL_Node 
(
	NodeID,
	NodeName,
	NodeType,
	Tips,
	NodeDir,
	NodeUrl,
	ParentID,
	Child,
	Depth,
	NodePicUrl,
	Description,
	Meta_Keywords,
	Meta_Description,
	OpenType,
	PurviewType,
	CommentType,
	HitsOfHot,
	ListTemplateFile,
	IndexTemplate,
	ContentModel,
	ItemOpenType,
	ContentHtmlRule,
	ListPageHtmlEx,
	ContentFileEx,
	HtmlPosition,
	OrderID
)
values
(
	newID,
	pNodeName,
	pNodeType,
	pTips,
	pNodeDir,
	pNodeUrl,
	pParentID,
	pChild,
	pDepth,
	pNodePicUrl,
	pDescription,
	pMeta_Keywords,
	pMeta_Description,
	pOpenType,
	pPurviewType,
	pCommentType,
	pHitsOfHot,
	pListTemplateFile,
	pIndexTemplate,
	pContentModel,
	pItemOpenType,
	pContentHtmlRule,
	pListPageHtmlEx,
	pContentFileEx,
	pHtmlPosition,
	pOrderID
);
pNodeID:=newID;
END PR_Nodes_Add;
/


DROP PROCEDURE PR_NODES_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Nodes_Update
(
pNodeID in out ZL_NODE.NODEID%TYPE,
pNodeName ZL_NODE.NODENAME%TYPE,
pNodeType ZL_NODE.NODETYPE%TYPE,
pTips ZL_NODE.TIPS%TYPE,
pNodeDir ZL_NODE.NODEDIR%TYPE,
pNodeUrl ZL_NODE.NODEURL%TYPE,
pParentID ZL_NODE.PARENTID%TYPE,
pChild ZL_NODE.CHILD%TYPE,
pDepth ZL_NODE.DEPTH%TYPE,
pNodePicUrl ZL_NODE.NODEPICURL%TYPE,
pDescription ZL_NODE.DESCRIPTION%TYPE,
pMeta_Keywords ZL_NODE.META_KEYWORDS%TYPE,
pMeta_Description ZL_NODE.META_DESCRIPTION%TYPE,
pOpenType ZL_NODE.OPENTYPE%TYPE,
pPurviewType ZL_NODE.PURVIEWTYPE%TYPE,
pCommentType ZL_NODE.COMMENTTYPE%TYPE,
pHitsOfHot ZL_NODE.HITSOFHOT%TYPE,
pListTemplateFile ZL_NODE.LISTTEMPLATEFILE%TYPE,
pIndexTemplate ZL_NODE.INDEXTEMPLATE%TYPE,
pContentModel ZL_NODE.CONTENTMODEL%TYPE,
pItemOpenType ZL_NODE.ITEMOPENTYPE%TYPE,
pContentHtmlRule ZL_NODE.CONTENTHTMLRULE%TYPE,
pListPageHtmlEx ZL_NODE.LISTPAGEHTMLEX%TYPE,
pContentFileEx ZL_NODE.CONTENTFILEEX%TYPE,
pHtmlPosition ZL_NODE.HTMLPOSITION%TYPE,
pOrderID ZL_NODE.ORDERID%TYPE
)
AS
BEGIN
   UPDATE  ZL_Node SET
	NodeName=pNodeName,
	NodeType=pNodeType,
	Tips=pTips,
	ParentID=pParentId,
	Depth=pDepth,
	Child=pChild,
	NodeDir=pNodeDir,
	NodeUrl=pNodeUrl,
	NodePicUrl=pNodePicUrl,
	Description=pDescription,			
	Meta_Keywords=pMeta_Keywords,
	Meta_Description=pMeta_Description,
	OpenType=pOpenType,
	PurviewType=pPurviewType,
	CommentType=pCommentType,
	HitsOfHot=pHitsOfHot,
	ListTemplateFile=pListTemplateFile,
	IndexTemplate=pIndexTemplate,
	ContentModel=pContentModel,
	ItemOpenType=pItemOpenType,
	ContentHtmlRule=pContentHtmlRule,	
	ListPageHtmlEx=pListPageHtmlEx,
	ContentFileEx=pContentFileEx,
	HtmlPosition=pHtmlPosition,
	OrderID=pOrderID
	Where NodeID=pNodeID;
END PR_Nodes_Update;
/


DROP PROCEDURE PR_NODE_DEL
/

CREATE OR REPLACE PROCEDURE PR_Node_Del
(
pNodeID ZL_NODE.NODEID%TYPE
)
AS
BEGIN
   Delete From ZL_Node Where NodeID=pNodeID;
END PR_Node_Del;
/


DROP PROCEDURE PR_NODE_DELCHILD
/

CREATE OR REPLACE PROCEDURE PR_Node_DelChild
(
pNodeID ZL_NODE.NODEID%TYPE
)
AS
BEGIN
   Delete From ZL_Node Where ParentID=pNodeID;
END PR_Node_DelChild;
/


DROP PROCEDURE PR_PAYMENT_ADD
/

CREATE OR REPLACE PROCEDURE PR_Payment_Add
(
pPaymentID in out ZL_PAYMENT.PAYMENTID%TYPE,
pPaymentNum ZL_PAYMENT.PAYMENTNUM%TYPE,
pUserID ZL_PAYMENT.USERID%TYPE,
pPayPlatID ZL_PAYMENT.PAYPLATID%TYPE,
pMoneyPay ZL_PAYMENT.MONEYPAY%TYPE,
pMoneyTrue ZL_PAYMENT.MONEYTRUE%TYPE,
pPayTime ZL_PAYMENT.PAYTIME%TYPE,
pSuccessTime ZL_PAYMENT.SUCCESSTIME%TYPE,
pStatus ZL_PAYMENT.STATUS%TYPE,
pPlatformInfo ZL_PAYMENT.PLATFORMINFO%TYPE,
pRemark ZL_PAYMENT.REMARK%TYPE
)
AS
newID ZL_PAYMENT.PAYMENTID%TYPE;
BEGIN
   select max(PaymentID) into newID from ZL_Payment;
   if newID is Null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   
insert into ZL_Payment
(
PaymentID,
PaymentNum,
UserID,
PayPlatID,
MoneyPay,
MoneyTrue,
PayTime,
SuccessTime,
Status,
PlatformInfo,
Remark
) values (
newID,
pPaymentNum,
pUserID,
pPayPlatID,
pMoneyPay,
pMoneyTrue,
pPayTime,
pSuccessTime,
pStatus,
pPlatformInfo,
pRemark
);
pPaymentID:=newID;
END PR_Payment_Add;
/


DROP PROCEDURE PR_PAYMENT_DEL
/

CREATE OR REPLACE PROCEDURE PR_Payment_Del
(
pPaymentID ZL_PAYMENT.PAYMENTID%TYPE
)
AS
BEGIN
   delete from ZL_Payment where PaymentID=pPaymentID;
END PR_Payment_Del;
/


DROP PROCEDURE PR_PAYMENT_SET
/

CREATE OR REPLACE PROCEDURE PR_Payment_Set
(
pPaymentID ZL_PAYMENT.PAYMENTID%TYPE
)
AS
BEGIN
   Update  ZL_Payment set CStatus='1' where PaymentID=pPaymentID;
END PR_Payment_Set;
/


DROP PROCEDURE PR_PAYMENT_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Payment_Update
(
pPaymentID in out ZL_PAYMENT.PAYMENTID%TYPE,
pPaymentNum ZL_PAYMENT.PAYMENTNUM%TYPE,
pUserID ZL_PAYMENT.USERID%TYPE,
pPayPlatID ZL_PAYMENT.PAYPLATID%TYPE,
pMoneyPay ZL_PAYMENT.MONEYPAY%TYPE,
pMoneyTrue ZL_PAYMENT.MONEYTRUE%TYPE,
pPayTime ZL_PAYMENT.PAYTIME%TYPE,
pSuccessTime ZL_PAYMENT.SUCCESSTIME%TYPE,
pStatus ZL_PAYMENT.STATUS%TYPE,
pPlatformInfo ZL_PAYMENT.PLATFORMINFO%TYPE,
pRemark ZL_PAYMENT.REMARK%TYPE
)
AS
BEGIN
Update ZL_Payment set 
PaymentNum=pPaymentNum,
UserID=pUserID,
PayPlatID=pPayPlatID,
MoneyPay=pMoneyPay,
MoneyTrue=pMoneyTrue,
PayTime=pPayTime,
SuccessTime=pSuccessTime,
Status=pStatus,
PlatformInfo=pPlatformInfo,
Remark=pRemark
Where PaymentID=pPaymentID;
END PR_Payment_Update;
/


DROP PROCEDURE PR_PAYPLAT_ADDUPDATE
/

CREATE OR REPLACE PROCEDURE PR_PayPlat_AddUpdate
(
pPayPlatID ZL_PAYPLAT.PAYPLATID%TYPE,
pPayPlatName ZL_PAYPLAT.PAYPLATNAME%TYPE,
pAccountID ZL_PAYPLAT.ACCOUNTID%TYPE,
pMD5Key ZL_PAYPLAT.MD5KEY%TYPE,
pRate ZL_PAYPLAT.RATE%TYPE,
pSellerEmail ZL_PAYPLAT.SELLEREMAIL%TYPE,
pOrderID ZL_PAYPLAT.ORDERID%TYPE,
pIsDisabled ZL_PAYPLAT.ISDISABLED%TYPE,
pIsDefault ZL_PAYPLAT.ISDEFAULT%TYPE
)
AS
newID ZL_PAYPLAT.PAYPLATID%TYPE;
BEGIN
if pPayPlatID=0 then
select max(PayplatID) into newID from ZL_PayPlat;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
Insert into ZL_PayPlat
(
PayPlatID,
PayPlatName,
AccountID,
MD5Key,
Rate,
SellerEmail,
OrderID,
IsDisabled,
IsDefault
)values(
newID,
pPayPlatName,
pAccountID,
pMD5Key,
pRate,
pSellerEmail,
pOrderID,
pIsDisabled,
pIsDefault
);
ELSE
Update ZL_PayPlat Set
PayPlatName=pPayPlatName,
AccountID=pAccountID,
MD5Key=pMD5Key,
Rate=pRate,
SellerEmail=pSellerEmail,
OrderID=pOrderID,
IsDisabled=pIsDisabled,
IsDefault=pIsDefault
Where PayPlatID=pPayPlatID;
END if;
END PR_PayPlat_AddUpdate;
/


DROP PROCEDURE PR_PAYPLAT_DEL
/

CREATE OR REPLACE PROCEDURE PR_PayPlat_Del
(
pPayPlatID ZL_PAYPLAT.PAYPLATID%TYPE
)
AS
BEGIN
   delete from ZL_PayPlat Where PayPlatID=pPayPlatID;
END PR_PayPlat_Del;
/


DROP PROCEDURE PR_PAYPLAT_SETDEFAULT
/

CREATE OR REPLACE PROCEDURE PR_PayPlat_SetDefault
(
pPayPlatID ZL_PAYPLAT.PAYPLATID%TYPE
)
AS
BEGIN
Update ZL_PayPlat set IsDefault='1',IsDisabled='0' where PayPlatID=pPayPlatID;
Update ZL_PayPlat set IsDefault='0' where PayPlatID<>pPayPlatID;
END PR_PayPlat_SetDefault;
/


DROP PROCEDURE PR_PROJECTAFFAIRS_ADD
/

CREATE OR REPLACE PROCEDURE PR_ProjectAffairs_Add
(
pID ZL_PROJECTAFFAIRS.ID%TYPE,
pMainTitleID ZL_PROJECTAFFAIRS.MAINTITLEID%TYPE,
pSubTitleID ZL_PROJECTAFFAIRS.SUBTITLEID%TYPE,
pTitle ZL_PROJECTAFFAIRS.TITLE%TYPE,
pContent ZL_PROJECTAFFAIRS.CONTENT%TYPE,
pAuthorID ZL_PROJECTAFFAIRS.AUTHORID%TYPE,
pAuthorName ZL_PROJECTAFFAIRS.AUTHORNAME%TYPE,
pEditTime ZL_PROJECTAFFAIRS.EDITTIME%TYPE,
pLastModifyTime ZL_PROJECTAFFAIRS.LASTMODIFYTIME%TYPE
)
AS
newID ZL_PROJECTAFFAIRS.ID%TYPE;
BEGIN
select max(ID) into newID from ZL_ProjectAffairs;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
Insert into ZL_ProjectAffairs 
(
ID,
MainTitleID,
SubTitleID,
Title,
Content,
AuthorID,
AuthorName,
EditTime,
LastModifyTime
 ) values (
 newID,
 pMainTitleID,
 pSubTitleID,
 pTitle,
 pContent,
 pAuthorID,
 pAuthorName,
 pEditTime,
 pLastModifyTime
);
END PR_ProjectAffairs_Add;
/


DROP PROCEDURE PR_PROJECTAFFAIRS_DELETE
/

CREATE OR REPLACE PROCEDURE PR_ProjectAffairs_Delete
(
pID ZL_PROJECTAFFAIRS.ID%TYPE
)
AS
BEGIN
   delete  from ZL_ProjectAffairs where ID=pID;
END PR_ProjectAffairs_Delete;
/


DROP PROCEDURE PR_PROJECTCATEGORY_ADD
/

CREATE OR REPLACE PROCEDURE PR_ProjectCategory_Add
(
pProjectCategoryID ZL_PROJECTCATEGORY.PROJECTCATEGORYID%TYPE,
pProjectCategoryName ZL_PROJECTCATEGORY.PROJECTCATEGORYNAME%TYPE,
pProjectCategoryIntro ZL_PROJECTCATEGORY.PROJECTCATEGORYINTRO%TYPE
)
AS
newID ZL_PROJECTCATEGORY.PROJECTCATEGORYID%TYPE;
BEGIN
select max(PROJECTCATEGORYID) into newID from ZL_ProjectCategory;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
INSERT INTO ZL_ProjectCategory
(
PROJECTCATEGORYID,
ProjectCategoryName,
ProjectCategoryIntro
) VALUES(
newID,
pProjectCategoryName,
pProjectCategoryIntro
);
END PR_ProjectCategory_Add;
/


DROP PROCEDURE PR_PROJECTCATEGORY_DELETE
/

CREATE OR REPLACE PROCEDURE PR_ProjectCategory_Delete
(
pID ZL_PROJECTCATEGORY.PROJECTCATEGORYID%TYPE
)
AS
BEGIN
   delete from ZL_ProjectCategory where ProjectCategoryID=pID;
END PR_ProjectCategory_Delete;
/


DROP PROCEDURE PR_PROJECTCATEGORY_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_ProjectCategory_Update
(
pProjectCategoryID ZL_PROJECTCATEGORY.PROJECTCATEGORYID%TYPE,
pProjectCategoryName ZL_PROJECTCATEGORY.PROJECTCATEGORYNAME%TYPE,
pProjectCategoryIntro ZL_PROJECTCATEGORY.PROJECTCATEGORYINTRO%TYPE
)
AS
BEGIN
   UPDATE ZL_ProjectCategory SET
ProjectCategoryName=pProjectCategoryName,
ProjectCategoryIntro=pProjectCategoryIntro
 WHERE ProjectCategoryID=pProjectCategoryID;
END PR_ProjectCategory_Update;
/


DROP PROCEDURE PR_PROJECTDISCUSS_ADD
/

CREATE OR REPLACE PROCEDURE PR_ProjectDiscuss_Add
(
pDiscussID ZL_PROJECTDISCUSS.DISCUSSID%TYPE,
pProjectID ZL_PROJECTDISCUSS.PROJECTID%TYPE,
pWorkID ZL_PROJECTDISCUSS.WORKID%TYPE,
pUserID ZL_PROJECTDISCUSS.USERID%TYPE,
pContent ZL_PROJECTDISCUSS.CONTENT%TYPE,
pDiscussDate ZL_PROJECTDISCUSS.DISCUSSDATE%TYPE
)
AS
newID ZL_PROJECTDISCUSS.DISCUSSID%TYPE;
BEGIN
select max(DiscussID) into newID from ZL_ProjectDiscuss;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
INSERT INTO ZL_ProjectDiscuss 
(
DiscussID,
ProjectID,
WorkID,
UserID,
Content,
DiscussDate
) VALUES (
newID,
pProjectID,
pWorkID,
pUserID,
pContent,
pDiscussDate
);
END PR_ProjectDiscuss_Add;
/


DROP PROCEDURE PR_PROJECTDISCUSS_DELETE
/

CREATE OR REPLACE PROCEDURE PR_ProjectDiscuss_Delete
(
pID ZL_PROJECTDISCUSS.DISCUSSID%TYPE
)
AS
BEGIN
   delete from ZL_ProjectDiscuss where DiscussID=pID;
END PR_ProjectDiscuss_Delete;
/


DROP PROCEDURE PR_PROJECTFIELD_ADD
/

CREATE OR REPLACE PROCEDURE PR_ProjectField_Add
(
pID ZL_PROJECTFIELD.ID%TYPE,
pProjectID ZL_PROJECTFIELD.PROJECTID%TYPE,
pFieldName ZL_PROJECTFIELD.FIELDNAME%TYPE,
pAlias ZL_PROJECTFIELD.ALIAS%TYPE,
pType ZL_PROJECTFIELD.TYPE%TYPE,
pFieldValue ZL_PROJECTFIELD.FIELDVALUE%TYPE
)
AS
newID ZL_PROJECTFIELD.ID%TYPE;
BEGIN
select max(ID) into newID from ZL_ProjectField;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
INSERT INTO	ZL_ProjectField
(
ID,
ProjectID,
FieldName,
Alias,
Type,
FieldValue
) VALUES(
newID,
pProjectID,
pFieldName,
pAlias,
pType,
pFieldValue
);
END PR_ProjectField_Add;
/


DROP PROCEDURE PR_PROJECTFIELD_DELETE
/

CREATE OR REPLACE PROCEDURE PR_ProjectField_Delete
(
pID integer
)
AS
BEGIN
   delete from ZL_ProjectField where ProjectID=pID;
END PR_ProjectField_Delete;
/


DROP PROCEDURE PR_PROJECTFIELD_DELETEBYFID
/

CREATE OR REPLACE PROCEDURE PR_ProjectField_DeleteByFid
(
pID ZL_PROJECTFIELD.ID%TYPE
)
AS
BEGIN
   delete from ZL_ProjectField where ID=pID;
END PR_ProjectField_DeleteByFid;
/


DROP PROCEDURE PR_PROJECTFIELD_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_ProjectField_Update
(
pID ZL_PROJECTFIELD.ID%TYPE,
pProjectID ZL_PROJECTFIELD.PROJECTID%TYPE,
pFieldName ZL_PROJECTFIELD.FIELDNAME%TYPE,
pAlias ZL_PROJECTFIELD.ALIAS%TYPE,
pType ZL_PROJECTFIELD.TYPE%TYPE,
pFieldValue ZL_PROJECTFIELD.FIELDVALUE%TYPE
)
AS
BEGIN
   UPDATE ZL_ProjectField SET 
ProjectID=pProjectID,
FieldName=pFieldName,
Alias=pAlias,
Type=pType,
FieldValue=pFieldValue
 WHERE ID=pID;
END PR_ProjectField_Update;
/


DROP PROCEDURE PR_PROJECTWORK_ADD
/

CREATE OR REPLACE PROCEDURE PR_ProjectWork_Add
(
pWorkID ZL_PROJECTWORK.WORKID%TYPE,
pWorkName ZL_PROJECTWORK.WORKNAME%TYPE,
pWorkIntro ZL_PROJECTWORK.WORKINTRO%TYPE,
pProjectID ZL_PROJECTWORK.PROJECTID%TYPE,
pApproving ZL_PROJECTWORK.APPROVING%TYPE,
pStatus ZL_PROJECTWORK.STATUS%TYPE,
pEndDate ZL_PROJECTWORK.ENDDATE%TYPE
)
AS
newID ZL_PROJECTWORK.WORKID%TYPE;
BEGIN
   select max(WorkID) into newID from ZL_ProjectWork;
   if newID is Null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   Insert Into ZL_ProjectWork (
    WorkID,
    WorkName,
    WorkIntro,
    ProjectID,
    Approving,
    Status,
    EndDate
    ) values(
    newID,
    pWorkName,
    pWorkIntro,
    pProjectID,
    pApproving,
    pStatus,
    pEndDate
    );
END PR_ProjectWork_Add;
/


DROP PROCEDURE PR_PROJECTWORK_DEL
/

CREATE OR REPLACE PROCEDURE PR_ProjectWork_Del
(
pID ZL_PROJECTWORK.WORKID%TYPE
)
AS
BEGIN
   delete from ZL_ProjectWork where WorkID=pID;
END PR_ProjectWork_Del;
/


DROP PROCEDURE PR_PROJECTWORK_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_ProjectWork_Update
(
pWorkID ZL_PROJECTWORK.WORKID%TYPE,
pWorkName ZL_PROJECTWORK.WORKNAME%TYPE,
pWorkIntro ZL_PROJECTWORK.WORKINTRO%TYPE,
pProjectID ZL_PROJECTWORK.PROJECTID%TYPE,
pApproving ZL_PROJECTWORK.APPROVING%TYPE,
pStatus ZL_PROJECTWORK.STATUS%TYPE,
pEndDate ZL_PROJECTWORK.ENDDATE%TYPE
)
AS
BEGIN
   UPDATE ZL_ProjectWork SET  
   WorkName=pWorkName,
   WorkIntro=pWorkIntro,
   ProjectID=pProjectID,
   Approving =pApproving,
   Status=pStatus,
   EndDate =pEndDate 
   WHERE WorkID = pWorkID;
END PR_ProjectWork_Update;
/


DROP PROCEDURE PR_PROJECT_ADD
/

CREATE OR REPLACE PROCEDURE PR_Project_Add
(
pProjectID ZL_PROJECT.PROJECTID%TYPE,
pProjectName ZL_PROJECT.PROJECTNAME%TYPE,
pProjectIntro ZL_PROJECT.PROJECTINTRO%TYPE,
pRequireID ZL_PROJECT.REQUIREID%TYPE,
pStartDate ZL_PROJECT.STARTDATE%TYPE,
pEndDate ZL_PROJECT.ENDDATE%TYPE,
pStatus ZL_PROJECT.STATUS%TYPE,
pUserID ZL_PROJECT.USERID%TYPE,
pProCateid ZL_PROJECT.PROJECTCATEGORYID%TYPE
)
AS
newID ZL_PROJECT.PROJECTID%TYPE;
BEGIN
select max(ProjectID) into newID from ZL_Project;
if newID is Null then
newID:=1;
else
newID:=newID+1;
end if;
INSERT INTO ZL_Project 
(
ProjectID,
ProjectName,
ProjectIntro,
RequireID,
StartDate,
EndDate,
Status,
UserID,
ProjectCategoryID
) VALUES (
newID,
pProjectName,
pProjectIntro,
pRequireID,
pStartDate,
pEndDate,
pStatus,
pUserID,
pProCateid
);
END PR_Project_Add;
/


DROP PROCEDURE PR_PROJECT_DELETE
/

CREATE OR REPLACE PROCEDURE PR_Project_Delete
(
pProjectID ZL_PROJECT.PROJECTID%TYPE
)
AS
BEGIN
   delete from ZL_Project where ProjectID=pProjectID;
END PR_Project_Delete;
/


DROP PROCEDURE PR_PROJECT_PASSED
/

CREATE OR REPLACE PROCEDURE PR_Project_Passed
(
pProjectID ZL_PROJECT.PROJECTID%TYPE
)
AS
BEGIN
   update ZL_Project set Passed='1' where ProjectID=pProjectID;
END PR_Project_Passed;
/


DROP PROCEDURE PR_PROJECT_PASSEDCANCEL
/

CREATE OR REPLACE PROCEDURE PR_Project_PassedCancel
(
pProjectID ZL_PROJECT.PROJECTID%TYPE
)
AS
BEGIN
   update ZL_Project set Passed='0' where ProjectID=pProjectID;
END PR_Project_PassedCancel;
/


DROP PROCEDURE PR_PROJECT_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Project_Update
(
pProjectID ZL_PROJECT.PROJECTID%TYPE,
pProjectName ZL_PROJECT.PROJECTNAME%TYPE,
pProjectIntro ZL_PROJECT.PROJECTINTRO%TYPE,
pRequireID ZL_PROJECT.REQUIREID%TYPE,
pStartDate ZL_PROJECT.STARTDATE%TYPE,
pEndDate ZL_PROJECT.ENDDATE%TYPE,
pStatus ZL_PROJECT.STATUS%TYPE,
pUserID ZL_PROJECT.USERID%TYPE,
pProCateid ZL_PROJECT.PROJECTCATEGORYID%TYPE
)
AS
BEGIN
   UPDATE ZL_Project SET    
  ProjectName =pProjectName,
  ProjectCategoryID=pProCateid,
  ProjectIntro=pProjectIntro,
  UserID=pUserID,
  RequireID =pRequireID,
  StartDate=pStartDate,
  Status=pStatus,
  EndDate =pEndDate
    WHERE  ProjectID= pProjectID;
END PR_Project_Update;
/


DROP PROCEDURE PR_SOURCE_DELETE
/

CREATE OR REPLACE PROCEDURE PR_Source_Delete
(
pID varchar2
)
AS
BEGIN
   if pID is not null then
   DELETE FROM ZL_Source WHERE ID in(pID);
   end if;
END PR_Source_Delete;
/


DROP PROCEDURE PR_SOURCE_INSERT
/

CREATE OR REPLACE PROCEDURE PR_Source_Insert
(
    pType ZL_SOURCE.TYPE%TYPE,
    pName ZL_SOURCE.NAME%TYPE,
    pPassed ZL_SOURCE.PASSED%TYPE,
    ponTop ZL_SOURCE.ONTOP%TYPE,
    pIsElite ZL_SOURCE.ISELITE%TYPE,
    pHits ZL_SOURCE.HITS%TYPE,
    pLastUseTime ZL_SOURCE.LASTUSETIME%TYPE,
    pPhoto ZL_SOURCE.PHOTO%TYPE,
    pIntro ZL_SOURCE.INTRO%TYPE,
    pAddress ZL_SOURCE.ADDRESS%TYPE,
    pTel ZL_SOURCE.TEL%TYPE,
    pFax ZL_SOURCE.FAX%TYPE,
    pMail ZL_SOURCE.MAIL%TYPE,
    pEmail ZL_SOURCE.EMAIL%TYPE,
    pZipCode ZL_SOURCE.ZIPCODE%TYPE,
    pHomePage ZL_SOURCE.HOMEPAGE%TYPE,
    pIm ZL_SOURCE.IM%TYPE,
    pContacterName ZL_SOURCE.CONTACTER%TYPE,
    pID ZL_SOURCE.ID%TYPE
)
AS
newID ZL_SOURCE.ID%TYPE;
BEGIN
   select max(ID) into newID from ZL_Source;
   if newID is Null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   INSERT INTO	ZL_Source
	(
    ID,
	Type,
	Name,
	Passed,
	onTop,
	IsElite,
	Hits,
	LastUseTime,
	Photo,
	Intro,
	Address,
	Tel,
	Fax,
	Mail,
	Email,
	ZipCode,
	HomePage,
	Im,
	Contacter
	) VALUES(
    newID,
	pType,
	pName,
	pPassed,
	ponTop,
	pIsElite,
	pHits,
	pLastUseTime,
	pPhoto,
	pIntro,
	pAddress,
	pTel,
	pFax,
	pMail,
	pEmail,
	pZipCode,
	pHomePage,
	pIm,
	pContacterName
	);
END PR_Source_Insert;
/


DROP PROCEDURE PR_SOURCE_UPDATE
/

CREATE OR REPLACE PROCEDURE PR_Source_Update
(
    pType ZL_SOURCE.TYPE%TYPE,
    pName ZL_SOURCE.NAME%TYPE,
    pPassed ZL_SOURCE.PASSED%TYPE,
    ponTop ZL_SOURCE.ONTOP%TYPE,
    pIsElite ZL_SOURCE.ISELITE%TYPE,
    pHits ZL_SOURCE.HITS%TYPE,
    pLastUseTime ZL_SOURCE.LASTUSETIME%TYPE,
    pPhoto ZL_SOURCE.PHOTO%TYPE,
    pIntro ZL_SOURCE.INTRO%TYPE,
    pAddress ZL_SOURCE.ADDRESS%TYPE,
    pTel ZL_SOURCE.TEL%TYPE,
    pFax ZL_SOURCE.FAX%TYPE,
    pMail ZL_SOURCE.MAIL%TYPE,
    pEmail ZL_SOURCE.EMAIL%TYPE,
    pZipCode ZL_SOURCE.ZIPCODE%TYPE,
    pHomePage ZL_SOURCE.HOMEPAGE%TYPE,
    pIm ZL_SOURCE.IM%TYPE,
    pContacterName ZL_SOURCE.CONTACTER%TYPE,
    pID ZL_SOURCE.ID%TYPE
)
AS
BEGIN
   UPDATE ZL_Source SET
		Type=pType,
		Name=pName,
		Passed=pPassed,
		onTop=ponTop,
		IsElite=pIsElite,
		Hits=pHits,
		LastUseTime=pLastUseTime,
		Photo=pPhoto,
		Intro=pIntro,
		Address=pAddress,
		Tel=pTel,
		Fax=pFax,
		Mail=pMail,
		Email=pEmail,
		ZipCode=pZipCode,
		HomePage=pHomePage,
		Im=pIm,
		Contacter=pContacterName
		WHERE ID=pID;
END PR_Source_Update;
/


DROP PROCEDURE PR_SPECCATE_ADDUPDATE
/

CREATE OR REPLACE PROCEDURE PR_SpecCate_AddUpdate
(
    pSpecCateID ZL_SPECCATE.SPECCATEID%TYPE,
    pSpecCateName ZL_SPECCATE.SPECCATENAME%TYPE,
    pSpecCateDir ZL_SPECCATE.SPECCATEDIR%TYPE,
    pSpecCateDesc ZL_SPECCATE.SPECCATEDESC%TYPE,
    pOpenType ZL_SPECCATE.OPENTYPE%TYPE,
    pFileExt ZL_SPECCATE.FILEEXT%TYPE,
    pListTemplate ZL_SPECCATE.LISTTEMPLATE%TYPE
)
AS
newID ZL_SPECCATE.SPECCATEID%TYPE;
BEGIN
  if pSpecCateID=0 then
	select max(SpecCateID) into newID from ZL_SpecCate;
    if newID is Null then
    newID:=1;
    else
    newID:=newID+1;
    end if;
	INSERT INTO 
	ZL_SpecCate 
	(  
    SpecCateID,
	SpecCateName,    
	SpecCateDir, 
	SpecCateDesc,
	OpenType,
	FileExt,  
	ListTemplate
	)
	VALUES
    (
    newID,
    pSpecCateName,
    pSpecCateDir,
    pSpecCateDesc,
	pOpenType,
	pFileExt,
	pListTemplate
	);
  ELSE
	update ZL_SpecCate set 
    SpecCateName=pSpecCateName,
	SpecCateDir=pSpecCateDir, 
	SpecCateDesc=pSpecCateDesc,
	OpenType=pOpenType,
	FileExt=pFileExt,  
	ListTemplate=pListTemplate
	where SpecCateID=pSpecCateID;
  END if;
END PR_SpecCate_AddUpdate;
/


DROP PROCEDURE PR_SPECCATE_DEL
/

CREATE OR REPLACE PROCEDURE PR_SpecCate_Del
(
pSpecCateID ZL_SPECCATE.SPECCATEID%TYPE
)
AS
BEGIN
   Delete from ZL_SpecCate where SpecCateID=pSpecCateID;
END PR_SpecCate_Del;
/


DROP PROCEDURE PR_SPECINFO_ADD
/

CREATE OR REPLACE PROCEDURE PR_SpecInfo_Add
(
pSpecialID ZL_SPECINFO.SPECIALID%TYPE,
pInfoID ZL_SPECINFO.INFOID%TYPE
)
AS
newID ZL_SPECINFO.SPECINFOID%TYPE;
BEGIN
   select max(SpecInfoID) into newID from ZL_SpecInfo;
   if newID is Null then
   newID:=1;
   else
   newID:=newID+1;
   end if;
   Insert Into ZL_SpecInfo (SpecInfoID,SpecialID,InfoID) values(newID,pSpecialID,pInfoID);
END PR_SpecInfo_Add;
/


DROP PROCEDURE PR_SPECINFO_DEL
/

CREATE OR REPLACE PROCEDURE PR_SpecInfo_Del
(
pSpecInfoID ZL_SPECINFO.SPECINFOID%TYPE
)
AS
BEGIN
   Delete from ZL_SpecInfo where SpecInfoID=pSpecInfoID;
END PR_SpecInfo_Del;
/


DROP PROCEDURE PR_SPEC_ADDUPDATE
/

CREATE OR REPLACE PROCEDURE PR_Spec_AddUpdate
(
    pSpecID ZL_SPECIAL.SPECID%TYPE,
    pSpecName ZL_SPECIAL.SPECNAME%TYPE,
    pSpecDir ZL_SPECIAL.SPECDIR%TYPE,
    pSpecDesc ZL_SPECIAL.SPECDESC%TYPE,
    pOpenType ZL_SPECIAL.OPENTYPE%TYPE,
    pSpecCate ZL_SPECIAL.SPECCATE%TYPE,
    pListFileExt ZL_SPECIAL.LISTFILEEXT%TYPE,
    pListFileRule ZL_SPECIAL.LISTFILERULE%TYPE,
    pListTemplate ZL_SPECIAL.LISTTEMPLATE%TYPE
)
AS
newID ZL_SPECIAL.SPECID%TYPE;
BEGIN
 if pSpecID=0 then
    select max(SpecID) into newID from ZL_Special;
    if newID is Null then
    newID:=1;
    else
    newID:=newID+1;
    end if;
    INSERT INTO 
    ZL_Special 
    (
    SpecID,  
	SpecName,    
	SpecDir, 
	SpecDesc,
	OpenType,
	SpecCate,
	ListFileExt,
	ListFileRule,
	ListTemplate	
	)
    VALUES
    (
    newID,
    pSpecName,
    pSpecDir,
    pSpecDesc,
    pOpenType,
    pSpecCate,
    pListFileExt,
	pListFileRule,
	pListTemplate
	);
 ELSE
	update ZL_Special set 
	SpecName=pSpecName,
	SpecDir=pSpecDir, 
	SpecDesc=pSpecDesc,
	OpenType=pOpenType,
	SpecCate=pSpecCate,
	ListFileExt=pListFileExt,
	ListFileRule=pListFileRule,
	ListTemplate=pListTemplate
    where SpecID=pSpecID;	
 END if;
END PR_Spec_AddUpdate;
/


DROP PROCEDURE PR_SPEC_DEL
/

CREATE OR REPLACE PROCEDURE PR_Spec_Del
(
pSpecID ZL_SPECIAL.SPECID%TYPE
)
AS
BEGIN
   Delete from ZL_Special where SpecID=pSpecID;
END PR_Spec_Del;
/


DROP PROCEDURE PR_USERLOCK
/

CREATE OR REPLACE PROCEDURE PR_UserLock
(
pUserID ZL_USER.USERID%TYPE,
pLastLockTime ZL_USER.LASTLOCKTIME%TYPE
)
AS
BEGIN
   Update ZL_User Set Status=1,LastLockTime=pLastLockTime where UserID=pUserID;
END PR_UserLock;
/


DROP PROCEDURE PR_USERMODEL_ADD
/

CREATE OR REPLACE PROCEDURE PR_UserModel_Add
(
pModelID ZL_MODEL.MODELID%TYPE,
pModelName ZL_MODEL.MODELNAME%TYPE,
pDescription ZL_MODEL.DESCRIPTION%TYPE,
pTableName ZL_MODEL.TABLENAME%TYPE,
pItemName ZL_MODEL.ITEMNAME%TYPE,
pItemUnit ZL_MODEL.ITEMUNIT%TYPE,
pItemIcon ZL_MODEL.ITEMICON%TYPE,
pModelType ZL_MODEL.MODELTYPE%TYPE
)
AS
newID ZL_MODEL.MODELID%TYPE;
BEGIN
   select max(ModelID) into newID from ZL_MODEL;
    if newID is Null then
    newID:=1;
    else
    newID:=newID+1;
    end if; 
    INSERT INTO 
    ZL_Model 
    (  
        ModelID,
        ModelName,    
        Description, 
        TableName,
        ItemName,
        ItemUnit,  
        ItemIcon,
        ModelType
        )
        VALUES
        (
        newID,
        pModelName,
        pDescription,
        pTableName,
        pItemName,
        pItemUnit,
        pItemIcon,
        pModelType
        );
    -- ڴָݱ
    EXECUTE IMMEDIATE 'CREATE TABLE '|| pTableName||' (UserID integer Constraint PRIMARY Key NOT NULL)';
END PR_UserModel_Add;
/


DROP PROCEDURE PR_USER_ADDUPDATE
/

CREATE OR REPLACE PROCEDURE        PR_User_AddUpdate
(
pUserID ZL_USER.USERID%TYPE,
pUserName ZL_USER.USERNAME%TYPE,
pUserPwd ZL_USER.USERPWD%TYPE,
pEmail ZL_USER.EMAIL%TYPE,
pQuestion ZL_USER.QUESTION%TYPE,
pAnswer ZL_USER.ANSWER%TYPE,
pRegTime ZL_USER.REGTIME%TYPE,
pLoginTimes ZL_USER.LOGINTIMES%TYPE,
pLastLoginTime ZL_USER.LASTLOGINTIME%TYPE,
pLastLoginIP ZL_USER.LASTLOGINIP%TYPE,
pLastPwdChangeTime ZL_USER.LASTPWDCHANGETIME%TYPE,
pLastLockTime ZL_USER.LASTLOCKTIME%TYPE,
pCheckNum ZL_USER.CHECKNUM%TYPE,
pMsgCount ZL_USER.MSGCOUNT%TYPE,
pGroupID ZL_USER.GROUPID%TYPE,
pUserExp ZL_USER.USEREXP%TYPE,
pStatus ZL_USER.STATUS%TYPE,
pBalance ZL_USER.BALANCE%TYPE,
pPrivacySetting ZL_USER.PRIVACYSETTING%TYPE
)
AS
newID ZL_USER.USERID%TYPE;
BEGIN
   if pUserID=0 then
        select max(UserID) into newID from ZL_User;
        if newID is Null then
        newID:=1;
        else
        newID:=newID+1;
        end if;
		Insert into ZL_User
		(
        UserID,
		UserName,
		UserPwd,
		Email,
		Question,
		Answer,
		RegTime,
		LoginTimes,
		LastLoginTime,
        LastLoginIP,
        LastPwdChangeTime,
        LastLockTime,
        CheckNum,
        MsgCount,
        GroupID,
        UserExp,
        Status,
        Balance,
        PrivacySetting
        )
        VALUES(
        newID,
        pUserName,
        pUserPwd,
        pEmail,
        pQuestion,
        pAnswer,
        pRegTime,
        pLoginTimes,
        pLastLoginTime,
        pLastLoginIP,
        pLastPwdChangeTime,
        pLastLockTime,
        pCheckNum,
        pMsgCount,
        pGroupID,
        pUserExp,
        pStatus,
        pBalance,
        pPrivacySetting
        );

    ELSE

        Update ZL_User SET 
		UserName=pUserName,
		UserPwd=pUserPwd,
		Email=pEmail,
		Question=pQuestion,
		Answer=pAnswer,
		RegTime=pRegTime,
		LoginTimes=pLoginTimes,
		LastLoginTime=pLastLoginTime,
		LastLoginIP=pLastLoginIP,
		LastPwdChangeTime=pLastPwdChangeTime,
		LastLockTime=pLastLockTime,
		CheckNum=pCheckNum,
		MsgCount=pMsgCount,
		GroupID=pGroupID,
		UserExp=pUserExp,
		Status=pStatus,
        Balance=pBalance,
        PrivacySetting=pPrivacySetting
		Where UserID=pUserID;
	END if;
END PR_User_AddUpdate;
/

DROP PACKAGE PKG_SELECT
/

CREATE OR REPLACE PACKAGE        PKG_Select AS
/******************************************************************************
   NAME:       PKG_Select
   PURPOSE:

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        2008-10-11             1. Created this package.
******************************************************************************/
  TYPE T_Cursor IS REF CURSOR;
  PROCEDURE dt_ADZone_GetExportList(p_ZoneID in integer,Re_Cursor out T_Cursor);
  PROCEDURE PR_Author_GetAuthorInfoByID(p_ID in integer,Re_Cursor out T_Cursor);
  PROCEDURE PR_Comment_ByNodeAudit(p_Audited ZL_Comment.Audited%type,p_NodeID integer,Re_Cursor out T_Cursor);
  PROCEDURE PR_Content_Common(p_GeneralID in integer,Re_Cursor out T_Cursor);
  PROCEDURE PR_Content_CreateAll(Re_Cursor out T_Cursor);
  PROCEDURE PR_Content_CreateDate(p_StartTime date,p_endtime date,Re_Cursor out T_Cursor);
  PROCEDURE PR_Content_CreateID(p_StartID integer,p_EndID integer,Re_Cursor out T_Cursor);
  PROCEDURE PR_GetRecordFromPage(
     pTableName varchar2,
	 pIdentity varchar2,
	 pFields varchar2,       
	 pOrderField varchar2,   
	 pSqlWhere varchar2,     
	 pPageSize integer,      
	 pPageIndex integer,       
	 pT_cursor out T_Cursor);

END PKG_Select;
/



DROP PACKAGE BODY PKG_SELECT
/

CREATE OR REPLACE PACKAGE BODY        PKG_Select
AS
PROCEDURE dt_ADZone_GetExportList
(
p_ZoneID in integer,
Re_Cursor out T_Cursor
)
is
begin
open Re_Cursor for 
select * from ZL_Advertisement where ADID in
(select ADID from ZL_Zone_Advertisement where ZoneID=p_ZoneID);
end dt_ADZone_GetExportList;

PROCEDURE PR_Author_GetAuthorInfoByID
(p_ID in integer,
Re_Cursor out T_Cursor)
IS
begin
open Re_Cursor for
select * from ZL_Author where ID=p_ID;
end PR_Author_GetAuthorInfoByID;

PROCEDURE PR_Comment_ByNodeAudit
(
p_Audited ZL_Comment.Audited%type,
p_NodeID integer,
Re_Cursor out T_Cursor
)
AS
begin
open Re_Cursor for
select A.*,B.Title from 
ZL_Comment A left outer join ZL_CommonModel B on A.GeneralID=B.GeneralID 
where A.Audited =p_Audited and B.NodeID=p_NodeID;
end PR_Comment_ByNodeAudit;

PROCEDURE PR_Content_Common
(
p_GeneralID in integer,
Re_Cursor out T_Cursor
)
AS
begin
open Re_Cursor for
Select * from ZL_CommonModel Where GeneralID=p_GeneralID;
END PR_Content_Common;

PROCEDURE PR_Content_CreateAll(Re_Cursor out T_Cursor) AS
Begin
open Re_Cursor for
Select * from ZL_CommonModel Where IsCreate='0';
END PR_Content_CreateAll;

PROCEDURE PR_Content_CreateDate(p_StartTime date,p_endtime date,Re_Cursor out T_Cursor) AS
BEGIN
open Re_Cursor for
select * from ZL_CommonModel Where (CreateTime between p_startTime and p_endTime) and IsCreate='0' order by GeneralID Desc;
END PR_Content_CreateDate;

PROCEDURE PR_Content_CreateID(p_StartID integer,p_EndID integer,Re_Cursor out T_Cursor) AS
BEGIN
open Re_Cursor for
select * from ZL_CommonModel Where (GeneralID between p_startID and p_endID) and IsCreate='0' order by GeneralID Desc;
END PR_Content_CreateID;

PROCEDURE PR_GetRecordFromPage
(
	 pTableName varchar2,
	 pIdentity varchar2,
	 pFields varchar2,       
	 pOrderField varchar2,   
	 pSqlWhere varchar2,     
	 pPageSize integer,      
	 pPageIndex integer,       
	 pT_cursor out T_Cursor
)
AS
p_rowcount integer;             --,
p_pagecount integer;            --ҳ 
v_count_sql varchar2(2000);
v_select_sql varchar2(2000);
p_Start integer;
p_End integer;
BEGIN
--ѯ
v_count_sql:='select count(*) from '||pTableName;
--Ӳѯ(''Ҳis null)
if pSqlWhere is not null  then
   v_count_sql:=v_count_sql||' where '||pSqlWhere;
end if;
--ִвѯ,ѯ
execute immediate v_count_sql into p_rowcount;

--õҳ
p_pagecount:=ceil(p_rowcount/pPageSize);
--ʼͽ
p_Start:=pPageIndex*pPageSize+1;
p_End:=p_Start+pPageSize-1;

--ѯ
v_count_sql:='select '||pFields||' from '||pTableName;
if pSqlWhere is not null then
  v_count_sql:=v_count_sql||' where '||pSqlWhere;
end if;
if pOrderField is not null then
  v_count_sql:=v_count_sql||' order by '||pOrderField;
end if;
v_select_sql:='select * from (select tempTable.*,rownum rn from ('|| v_count_sql;

v_select_sql:=v_select_sql||') tempTable where rownum<='||to_char(p_End)||') where rn>= '||to_char(p_Start);

open pT_cursor for v_select_sql;

END PR_GetRecordFromPage;

END PKG_Select;
/