﻿CREATE TABLE [dbo].[ZL_Guest_BarAuth](
[ID] [int] IDENTITY(1,1) NOT NULL,
[BarID] [int] NULL,
[Uid] [int] NULL,
[UName] [nvarchar](200) NULL,
[Look] [int] NULL,
[Send] [int] NULL,
[Reply] [int] NULL,
CONSTRAINT [PK_ZL_Bar_Auth] PRIMARY KEY CLUSTERED ([ID] ASC)WITH (PAD_INDEX  = OFF) ON [PRIMARY]) ON [PRIMARY]
GO

CREATE TABLE [dbo].[ZL_OAC_swmx](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[content] [text] NULL,
	[Secret] [nvarchar](255) NULL,
	[Urgency] [nvarchar](255) NULL,
	[Importance] [nvarchar](255) NULL,
	[Attach] [nvarchar](255) NULL,
	[UserGroupT] [nvarchar](255) NULL,
	[swrq] [nvarchar](255) NULL,
	[wjwh] [nvarchar](255) NULL,
	[lwjg] [nvarchar](255) NULL,
	[bt] [nvarchar](255) NULL,
	[swxl] [nvarchar](255) NULL,
	[gdlm] [nvarchar](255) NULL,
	[bcqx] [nvarchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[ZL_OAC_swmx] ADD  DEFAULT ('') FOR [Secret]
GO

ALTER TABLE [dbo].[ZL_OAC_swmx] ADD  DEFAULT ('') FOR [Urgency]
GO

ALTER TABLE [dbo].[ZL_OAC_swmx] ADD  DEFAULT ('') FOR [Importance]
GO

ALTER TABLE [dbo].[ZL_OAC_swmx] ADD  DEFAULT ('') FOR [Attach]
GO

ALTER TABLE [dbo].[ZL_OAC_swmx] ADD  DEFAULT ('') FOR [UserGroupT]

GO
CREATE TABLE [dbo].[ZL_User_Cloud](
	[Guid] [uniqueidentifier] NOT NULL,
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[FileName] [nvarchar](500) NULL,
	[VPath] [nvarchar](500) NULL,
	[SFileName] [nvarchar](100) NULL,
	[FileType] [int] NULL,
	[CDate] [datetime] NULL,
	[FileSize] [nvarchar](500) NULL,
	[UpdateDate] [datetime] NULL,
 CONSTRAINT [PK_ZL_User_Cloud_1] PRIMARY KEY CLUSTERED 
(
	[Guid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ZL_User_Cloud] ADD  CONSTRAINT [DF_ZL_User_Cloud_Guid]  DEFAULT (newid()) FOR [Guid]
GO
CREATE TABLE [dbo].[ZL_OAC_qjmx](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[content] [text] NULL,
	[Secret] [nvarchar](255) NULL,
	[Urgency] [nvarchar](255) NULL,
	[Importance] [nvarchar](255) NULL,
	[Attach] [nvarchar](255) NULL,
	[UserGroupT] [nvarchar](255) NULL,
	[qjr] [nvarchar](255) NULL,
	[kssj] [nvarchar](255) NULL,
	[jssj] [nvarchar](255) NULL,
	[qjyy] [nvarchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
ALTER TABLE [dbo].[ZL_OAC_qjmx] ADD  DEFAULT ('') FOR [Secret]
GO
ALTER TABLE [dbo].[ZL_OAC_qjmx] ADD  DEFAULT ('') FOR [Urgency]
GO
ALTER TABLE [dbo].[ZL_OAC_qjmx] ADD  DEFAULT ('') FOR [Importance]
GO
ALTER TABLE [dbo].[ZL_OAC_qjmx] ADD  DEFAULT ('') FOR [Attach]
GO
ALTER TABLE [dbo].[ZL_OAC_qjmx] ADD  DEFAULT ('') FOR [UserGroupT]

GO
CREATE TABLE [dbo].[ZL_Hits](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[GID] [int] NOT NULL,
	[Uid] [int] NULL,
	[UpdateTime] [datetime] NOT NULL,
	[Ip] [nvarchar](50) NULL,
	[status] [int] NULL,
 CONSTRAINT [PK_ZL_Hits] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_OAC_kymx](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[content] [text] NULL,
	[Secret] [nvarchar](255) NULL,
	[Urgency] [nvarchar](255) NULL,
	[Importance] [nvarchar](255) NULL,
	[Attach] [nvarchar](255) NULL,
	[UserGroupT] [nvarchar](255) NULL,
	[kssj] [nvarchar](255) NULL,
	[jssj] [nvarchar](255) NULL,
	[skr] [nvarchar](255) NULL,
	[jyr] [nvarchar](255) NULL,
	[kyjj] [nvarchar](255) NULL,
	[cjr] [nvarchar](255) NULL,
	[kydd] [nvarchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[ZL_OAC_kymx] ADD  DEFAULT ('') FOR [Secret]
GO

ALTER TABLE [dbo].[ZL_OAC_kymx] ADD  DEFAULT ('') FOR [Urgency]
GO

ALTER TABLE [dbo].[ZL_OAC_kymx] ADD  DEFAULT ('') FOR [Importance]
GO

ALTER TABLE [dbo].[ZL_OAC_kymx] ADD  DEFAULT ('') FOR [Attach]
GO

ALTER TABLE [dbo].[ZL_OAC_kymx] ADD  DEFAULT ('') FOR [UserGroupT]
GO
CREATE TABLE [dbo].[ZL_OAC_fwmx](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[content] [text] NULL,
	[Secret] [nvarchar](255) NULL,
	[Urgency] [nvarchar](255) NULL,
	[Importance] [nvarchar](255) NULL,
	[Attach] [nvarchar](255) NULL,
	[UserGroupT] [nvarchar](255) NULL,
	[jjqk] [nvarchar](255) NULL,
	[mj] [nvarchar](255) NULL,
	[ngsw] [nvarchar](255) NULL,
	[ngr] [nvarchar](255) NULL,
	[bmsh] [nvarchar](255) NULL,
	[zs] [nvarchar](255) NULL,
	[cb] [nvarchar](255) NULL,
	[cs] [nvarchar](255) NULL,
	[fh] [nvarchar](255) NULL,
	[xh] [nvarchar](255) NULL,
	[gdlm] [nvarchar](255) NULL,
	[bcqx] [nvarchar](255) NULL,
	[dj] [nvarchar](255) NULL,
	[bhxx] [nvarchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[ZL_OAC_fwmx] ADD  DEFAULT ('') FOR [Secret]
GO

ALTER TABLE [dbo].[ZL_OAC_fwmx] ADD  DEFAULT ('') FOR [Urgency]
GO

ALTER TABLE [dbo].[ZL_OAC_fwmx] ADD  DEFAULT ('') FOR [Importance]
GO

ALTER TABLE [dbo].[ZL_OAC_fwmx] ADD  DEFAULT ('') FOR [Attach]
GO

ALTER TABLE [dbo].[ZL_OAC_fwmx] ADD  DEFAULT ('') FOR [UserGroupT]

GO
CREATE TABLE [dbo].[ZL_QrCode](
[ID] [int] IDENTITY(1,1) NOT NULL,
[ImageUrl] [nvarchar](255) NULL,
[CodeType] [nvarchar](50) NULL,
[CodeLevel] [nvarchar](50) NULL,
[CodeVersion] [int] NULL,
[CodeContents] [nvarchar](255) NULL,
[UserName] [nvarchar](50) NULL,
[Type] [int] NULL,
[CreateTime] [datetime] NULL,
[AppID] [int] NULL,
[Urls] [nvarchar](500) NULL,
CONSTRAINT [PK_ZL_QrCode] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'纠错等级 分为' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_QrCode', @level2type=N'COLUMN',@level2name=N'CodeLevel'
GO

ALTER TABLE [dbo].[ZL_QrCode] ADD  DEFAULT ((0)) FOR [Type]
GO
CREATE TABLE [dbo].[ZL_User_Friend](
[ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NULL,
[Fid] [int] NULL,
[Status] [int] NULL,
[CDate] [datetime] NULL,
CONSTRAINT [PK_ZL_User_Friend] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[ZL_Publish_Node](
[ID] [int] IDENTITY(1,1) NOT NULL,
[Pid] [int] NOT NULL,
[NodeName] [nvarchar](200) NULL,
[Describe] [nvarchar](500) NULL,
[CDate] [datetime] NULL,
[CAdmin] [int] NULL,
[Auth] [nvarchar](500) NULL,) ON [PRIMARY]
GO
CREATE TABLE [dbo].[ZL_Content_Publish](
[ID] [int] IDENTITY(1,1) NOT NULL,
[ImgPath] [nvarchar](300) NULL,
[Json] [nvarchar](4000) NULL,
[Title] [nvarchar](200) NULL,
[CUser] [int] NULL,
[CDate] [datetime] NULL,
[Pid] [int] NULL,
[NewsName] [nvarchar](200) NULL,
[AttachFile] [nvarchar](1000) NULL,
[Nid] [int] NULL) ON [PRIMARY]
GO
CREATE TABLE [dbo].[ZL_Content_Video](
[ID] [int] IDENTITY(1,1) NOT NULL,
[VName] [nvarchar](100) NULL,
[VSize] [nvarchar](500) NULL,
[VTime] [nvarchar](100) NULL,
[UserID] [int] NULL,
[CDate] [datetime] NULL,
[Thumbnail] [nvarchar](1000) NULL,
[Desc] [nvarchar](1000) NULL,
[VPath] [nvarchar](1000) NULL,
CONSTRAINT [PK_ZL_Content_Video] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Content_FileBuy](
[ID] [int] IDENTITY(1,1) NOT NULL,
[Gid] [int] NULL,
[Ranstr] [nvarchar](200) NULL,
[FName] [nvarchar](200) NULL,
[Url] [nvarchar](200) NULL,
[UserID] [int] NULL,
[UserName] [nvarchar](50) NULL,
[BuyPrice] [nvarchar](200) NULL,
[IsMain] [int] NULL,
[Field] [nvarchar](100) NULL,
[CDate] [datetime] NULL,
[EndDate] [datetime] NULL,
CONSTRAINT [PK_ZL_Content_FileBuy] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Guest_Bar](
[ID] [int] IDENTITY(1,1) NOT NULL,
[CateID] [int] NOT NULL,
[Pid] [int] NOT NULL,
[ReplyID] [int] NULL,
[ReplyUserID] [int] NULL,
[Title] [nvarchar](200) NULL,
[MsgContent] [ntext] NULL,
[IP] [nvarchar](200) NULL,
[ColledIDS] [nvarchar](4000) NULL,
[MsgType] [int] NULL,
[Status] [int] NULL,
[CUser] [int] NULL,
[CUName] [nvarchar](50) NULL,
[CDate] [datetime] NULL,
[Subtitle] [nvarchar](3000) NULL,
[PostFlag] [nvarchar](300) NULL,
[Style] [nvarchar](200) NULL,
[OrderFlag] [int] NOT NULL,
[HitCount] [int] NULL,
[IDCode] [nvarchar](50) NULL,
[LikeIDS] [nvarchar](500) NOT NULL,
[R_CUser] [int] NULL,
[R_CUName] [nvarchar](50) NULL,
[R_CDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE [dbo].[ZL_Guest_Bar] ADD  CONSTRAINT [DF_ZL_Guest_Bar_OrderFlag]  DEFAULT ((0)) FOR [OrderFlag]
GO
ALTER TABLE [dbo].[ZL_Guest_Bar] ADD  CONSTRAINT [DF_ZL_Guest_Bar_LikeIDS]  DEFAULT ('') FOR [LikeIDS]

GO
CREATE TABLE [dbo].[ZL_Temp](
[ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NULL,
[UseType] [int] NULL,
[CDate] [datetime] NULL,
[Describe] [nvarchar](500) NULL,
[Str1] [nvarchar](500) NULL,
[Str2] [ntext] NULL,
[Str3] [nvarchar](500) NULL,
[Str4] [nvarchar](500) NULL,
[Str5] [nvarchar](500) NULL,
[Str6] [nvarchar](500) NULL) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_File](
[ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int],
[DownUrl] [nvarchar](100),
[ExtractionCode] [nvarchar](8),
[FileName] [nvarchar](100),
[State] [int],
[FileMD5] [nvarchar](500) NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[ZL_CpsClick] (
[ID] [int] IDENTITY (1, 1) NOT NULL ,
[UserID] [int] NULL ,
[PromotionCode] [nvarchar](10) NULL ,
[Traffic] [int] NULL ,
[IP] [nvarchar](50) NULL ,
[CreateTime] [datetime]
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[ZL_Sns_Messageboard](
[ID] [uniqueidentifier] NULL,
[SendID] [int] NULL,
[InceptID] [int] NULL,
[Mcontent] [text] NULL,
[Addtime] [datetime] NULL,
[RestoreID] [uniqueidentifier] NULL,
[State] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_MyCar](
[Pmid] [int] IDENTITY(1,1) NOT NULL,
[P_uid] [int] NULL,
[Pid] [int] NULL,
[P_buy_time] [datetime] NULL,
[P_last_time] [datetime] NULL,
[P_last_uid] [int] NULL CONSTRAINT [DF_ZL_Sns_MyCar_P_last_uid]  DEFAULT (0),
[P_last_user] [varchar](20) NULL,
[P_action] [int] NULL,
CONSTRAINT [PK_ZL_Sns_MyCar] PRIMARY KEY NONCLUSTERED 
(
[Pmid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Card](
[Card_ID] [int] IDENTITY(1,1) NOT NULL,
[CardNum] [nvarchar](50) NULL,
[CardPwd] [nvarchar](50) NULL,
[PutUserID] [int] NULL,
[AssociateUserID] [int] NULL CONSTRAINT [DF_ZL_Card_AssociateUserID]  DEFAULT (0),
[VIPType] [int] NULL,
[StartTime] [datetime] NULL,
[CircumscribeTime] [datetime] NULL,
[PlyNum] [int] NULL CONSTRAINT [DF_ZL_Card_PlyNum]  DEFAULT (0),
[AddTime] [datetime] NULL CONSTRAINT [DF_ZL_Card_AddTime]  DEFAULT (getdate()),
[CardState] [int] NULL,
CONSTRAINT [PK_ZL_Card] PRIMARY KEY CLUSTERED 
(
[Card_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'卡片编号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'CardNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'卡片密码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'CardPwd'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发放卡片加盟商' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'PutUserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'关联用户' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'AssociateUserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'VIP类型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'VIPType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'第一次使用时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'StartTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'使用年限' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'CircumscribeTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'使用次数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'PlyNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'卡片创建时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'AddTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'卡片状态 1：未开启，2：开启，3：停用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Card', @level2type=N'COLUMN', @level2name=N'CardState'

GO
CREATE TABLE [dbo].[ZL_Sns_MyPose](
[P_uid] [int] NOT NULL,
[P_pose_uid_1] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_uid_1]  DEFAULT (0),
[P_pose_user_1] [varchar](20) NULL,
[P_pose_Pmid_1] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pmid_1]  DEFAULT (0),
[P_pose_Pid_1] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pid_1]  DEFAULT (0),
[P_pose_uid_2] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_uid_2]  DEFAULT (0),
[P_pose_user_2] [varchar](20) NULL,
[P_pose_Pmid_2] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pmid_2]  DEFAULT (0),
[P_pose_Pid_2] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pid_2]  DEFAULT (0),
[P_pose_uid_3] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_uid_3]  DEFAULT (0),
[P_pose_user_3] [varchar](20) NULL,
[P_pose_Pmid_3] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pmid_3]  DEFAULT (0),
[P_pose_Pid_3] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pid_3]  DEFAULT (0),
[P_pose_uid_4] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_uid_4]  DEFAULT (0),
[P_pose_user_4] [varchar](20) NULL,
[P_pose_Pmid_4] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pmid_4]  DEFAULT (0),
[P_pose_Pid_4] [int] NULL CONSTRAINT [DF_ZL_Sns_MyPose_P_pose_Pid_4]  DEFAULT (0),
CONSTRAINT [PK_ZL_Sns_MyPose] PRIMARY KEY NONCLUSTERED 
(
[P_uid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_CardType](
[c_id] [int] IDENTITY(1,1) NOT NULL,
[typename] [nvarchar](100) NULL,
[iscount] [float] NULL,
CONSTRAINT [PK_cardtype] PRIMARY KEY CLUSTERED 
(
[c_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'折扣' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CardType', @level2type=N'COLUMN', @level2name=N'iscount'

GO
CREATE TABLE [dbo].[ZL_Sns_PicCateg](
[ID] [uniqueidentifier] NOT NULL,
[PicCategTitle] [varchar](20) NOT NULL,
[PicCategUserID] [int] NOT NULL,
[TitlePIc] [uniqueidentifier] NULL,
[State] [int] NOT NULL,
[CategTime] [datetime] NOT NULL,
[PicCategPws][nvarchar](50)NULL,
[Video][nvarchar](255)Null
CONSTRAINT [PK_ZL_Sns_PicCateg] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[ZL_Cart](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Cartid] [varchar](255) NULL,
	[userid] [int] NULL,
	[Username] [varchar](255) NULL,
	[Addtime] [datetime] NULL,
	[StoreID] [int] NULL,
	[ProID] [int] NULL,
	[Proname] [nvarchar](500) NULL,
	[Pronum] [int] NULL,
	[AllMoney] [money] NULL,
	[Getip] [varchar](50) NULL,
	[AllIntegral] [money] NULL,
	[FarePrice] [nvarchar](400) NULL,
	[Additional] [ntext] NULL,
	[AllMoney_Json] [nvarchar](500) NULL,
	[code] [varchar](500) NULL,
 CONSTRAINT [PK_ZL_Cart] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'购物车识别ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Cart', @level2type=N'COLUMN', @level2name=N'Cartid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'购买者' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Cart', @level2type=N'COLUMN', @level2name=N'Username'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'购买时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Cart', @level2type=N'COLUMN', @level2name=N'Addtime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所有商品数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Cart', @level2type=N'COLUMN', @level2name=N'Pronum'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'总价' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Cart', @level2type=N'COLUMN', @level2name=N'AllMoney'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'提交IP' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Cart', @level2type=N'COLUMN', @level2name=N'Getip'

GO
CREATE TABLE [dbo].[ZL_Sns_PicCritique](
[ID] [uniqueidentifier] NOT NULL,
[CritiqueContent] [text] NOT NULL,
[PicID] [uniqueidentifier] NOT NULL,
[UserID] [int] NOT NULL,
[CritiqueTime] [datetime] NOT NULL,
 CONSTRAINT [PK_ZL_Sns_PicCritique] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_CartPro](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Orderlistid] [int] NULL,
	[CartID] [int] NULL,
	[ProID] [int] NULL,
	[Pronum] [int] NULL,
	[Username] [varchar](255) NULL,
	[Proname] [varchar](255) NULL,
	[Danwei] [varchar](50) NULL,
	[Shijia] [money] NULL,
	[AllMoney] [money] NULL,
	[Addtime] [datetime] NULL,
	[Bindpro] [nvarchar](50) NULL,
	[ProSeller] [nvarchar](255) NULL,
	[PerID] [nvarchar](50) NULL,
	[city] [nvarchar](50) NULL,
	[type] [int] NULL,
	[Attribute] [nvarchar](1000) NULL,
	[FarePrice] [nvarchar](400) NULL,
	[EndTime] [datetime] NULL,
	[Additional] [ntext] NULL,
	[StoreID] [int] NULL,
	[AllMoney_Json] [nvarchar](500) NULL,
	[AddStatus] [nvarchar](1000) NULL,
	[code] [varchar](500) NULL,
 CONSTRAINT [PK_ZL_CartPro] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_PicTure](
[ID] [uniqueidentifier] NOT NULL,
[PicName] [varchar](50) NULL,
[PicUrl] [varchar](200) NOT NULL,
[Remark] [text] NULL,
[PicCategID] [uniqueidentifier] NOT NULL,
[PicSize] [int] NOT NULL,
[PicUpTime] [datetime] NOT NULL,
 CONSTRAINT [PK_ZL_Sns_PicTure] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_ProductTable](
[ID] [uniqueidentifier] NOT NULL,
[ProductName] [varchar](100) NULL,
[TypeID] [uniqueidentifier] NULL,
[ProductContent] [ntext] NULL,
[Price] [int] NULL,
[VipPrice] [int] NULL,
[ProductPic] [varchar](255) NULL,
[Addtime] [datetime] NULL,
CONSTRAINT [PK_ZL_Sns_ProductTable] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_ChangeProduct](
[P_ID] [int] IDENTITY(1,1) NOT NULL,
[prodID] [int] NULL,
[ExChangeID] [int] NULL,
[PState] [int] NULL,
[num] [int] NULL,
CONSTRAINT [PK_ZL_ChangeProduct] PRIMARY KEY CLUSTERED 
(
[P_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ChangeProduct', @level2type=N'COLUMN', @level2name=N'prodID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'交易表ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ChangeProduct', @level2type=N'COLUMN', @level2name=N'ExChangeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'状态0为申请者商品1为被申请者' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ChangeProduct', @level2type=N'COLUMN', @level2name=N'PState'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ChangeProduct', @level2type=N'COLUMN', @level2name=N'num'

GO
CREATE TABLE [dbo].[ZL_Sns_ProductTypetable](
[ID] [uniqueidentifier] NULL,
[Name] [varchar](100) NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_ChangeTalk](
[T_ID] [int] IDENTITY(1,1) NOT NULL,
[ExChangeID] [int] NULL,
[TContent] [ntext] NULL,
[UserID] [int] NULL,
[ETime] [smalldatetime] NULL CONSTRAINT [DF_ZL_ChangeTalk_ETime]  DEFAULT (getdate()),
CONSTRAINT [PK_ZL_ChangeTalk] PRIMARY KEY CLUSTERED 
(
[T_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'交易表ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ChangeTalk', @level2type=N'COLUMN', @level2name=N'ExChangeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'对话内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ChangeTalk', @level2type=N'COLUMN', @level2name=N'TContent'

GO
CREATE TABLE [dbo].[ZL_Exam_ClassRoom](
	[RoomID] [int] IDENTITY(1,1) NOT NULL,
	[RoomName] [nvarchar](255) NULL,
	[SchoolID] [int] NULL,
	[ClassName] [nvarchar](50) NULL,
	[Room] [nvarchar](10) NULL,
	[Teacher] [nvarchar](255) NULL,
	[Adviser] [nvarchar](255) NULL,
	[Monitor] [nvarchar](255) NULL,
	[Creation] [datetime] NULL,
	[CreateUser] [int] NULL,
	[Integral] [int] NULL,
	[Classinfo] [ntext] NULL,
	[Grade] [int] NULL,
	[IsTrue] [int] NULL,
	[ClassStar] [int] NULL,
	[IsDone] [int] NULL,
 CONSTRAINT [PK_ZL_Exam_ClassRoom] PRIMARY KEY CLUSTERED 
([RoomID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Exam_Version](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[NodeID] [int] NULL,
	[Grade] [int] NULL,
	[VersionName] [nvarchar](200) NULL,
	[VersionTime] [nvarchar](500) NULL,
	[Alias] [nvarchar](200) NULL,
	[Volume] [nvarchar](200) NULL,
	[AdminID] [int] NULL,
	[CDate] [datetime] NULL,
	[Remind] [nvarchar](200) NULL,
 CONSTRAINT [PK_ZL_Exam_Version] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
ALTER TABLE [dbo].[ZL_Exam_ClassRoom] ADD  CONSTRAINT [DF_ZL_Exam_ClassRoom_Integral]  DEFAULT ((0)) FOR [Integral]
GO
ALTER TABLE [dbo].[ZL_Exam_ClassRoom] ADD  CONSTRAINT [DF_ZL_Exam_ClassRoom_IsTrue]  DEFAULT ((0)) FOR [IsTrue]
GO
CREATE TABLE [dbo].[ZL_Sns_ReplayLog](
[ID] [uniqueidentifier] NOT NULL,
[ReplayLpgContext] [text] NULL,
[LogID] [uniqueidentifier] NULL,
[ReplayUserID] [int] NULL,
[ReplayLogTime] [datetime] NULL,
[ReplayFlag] [bit] NULL,
CONSTRAINT [PK_ZL_Sns_ReplayLog] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_Report](
[PRid] [int] IDENTITY(1,1) NOT NULL,
[Pmid] [int] NULL CONSTRAINT [DF_ZL_Sns_Report_Pmid]  DEFAULT (null),
[Pid] [int] NULL CONSTRAINT [DF_ZL_Sns_Report_Pid]  DEFAULT (null),
[Puid] [int] NULL CONSTRAINT [DF_ZL_Sns_Report_Puid]  DEFAULT (null),
[R_to_uid] [int] NULL CONSTRAINT [DF_ZL_Sns_Report_R_to_uid]  DEFAULT (null),
[R_to_time] [datetime] NULL CONSTRAINT [DF_ZL_Sns_Report_R_to_time]  DEFAULT (null),
[R_type] [int] NULL CONSTRAINT [DF_ZL_Sns_Report_R_type]  DEFAULT (null),
CONSTRAINT [PK_ZL_Sns_Report] PRIMARY KEY NONCLUSTERED 
(
[PRid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_SystemBannerTable](
[ID] [int] IDENTITY(1,1) NOT NULL,
[BannerName] [varchar](50) NULL,
[BannerStyle] [varchar](255) NULL,
[BannerIndex] [int] NULL,
[BannerOrder] [int] NULL,
[BannerShow] [int] NULL,
CONSTRAINT [PK_ZL_Sns_SystemBannerTable] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_SystemBannerTable', @level2type=N'COLUMN', @level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_SystemBannerTable', @level2type=N'COLUMN', @level2name=N'BannerName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_SystemBannerTable', @level2type=N'COLUMN', @level2name=N'BannerStyle'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'(1为首页栏目 0为分栏目)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_SystemBannerTable', @level2type=N'COLUMN', @level2name=N'BannerIndex'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_SystemBannerTable', @level2type=N'COLUMN', @level2name=N'BannerOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否显示(0为不显示 1为显示)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_SystemBannerTable', @level2type=N'COLUMN', @level2name=N'BannerShow'

GO
CREATE TABLE [dbo].[ZL_CollectionInfo](
[C_IID] [int] IDENTITY(1,1) NOT NULL,
[ModeID] [int] NULL,
[NodeID] [int] NULL,
[ItemID] [int] NULL,
[CollID] [int] NULL,
[OldUrl] [nvarchar](500) NULL,
[NewUrl] [nvarchar](500) NULL,
[State] [int] NULL,
[AddTime] [nvarchar](50) NULL,
[Remark] [nvarchar](500) NULL,
CONSTRAINT [PK_ZL_CollectionInfo] PRIMARY KEY CLUSTERED 
(
[C_IID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'ModeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'NodeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'ItemID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'CollID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'原网页地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'OldUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'NewUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'状态' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'State'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'AddTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionInfo', @level2type=N'COLUMN', @level2name=N'Remark'

GO
CREATE TABLE [dbo].[ZL_Sns_SystemLog](
[ID] [uniqueidentifier] NOT NULL,
[UserID] [int] NULL,
[ContentID] [uniqueidentifier] NULL,
[LogType] [varchar](20) NULL,
[ModelUrl] [varchar](100) NULL,
[CreateTime] [datetime] NULL,
[LogContent] [varchar](1000) NULL,
[LogTitle] [varchar](100) NULL,
CONSTRAINT [PK_ZL_Sns_SystemLog] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_CollectionItem](
[CItem_ID] [int] IDENTITY(1,1) NOT NULL,
[ItemName] [nvarchar](500) NULL,
[ModeID] [int] NULL,
[NodeID] [nvarchar](200) NULL,
[SpecialID] [nvarchar](200) NULL,
[SiteName] [nvarchar](100) NULL,
[CollUrl] [nvarchar](200) NULL,
[CodinChoice] [int] NULL,
[CollNum] [int] NULL,
[CollOrder] [int] NULL,
[CollContext] [nvarchar](4000) NULL,
[ListSettings] [nvarchar](1000) NULL,
[PageSettings] [nvarchar](1000) NULL,
[InfoPageSettings] [nvarchar](4000) NULL,
[AddTime] [datetime] NULL,
[LastTime] [nvarchar](50) NULL,
[Switch] [int] NULL,
[State] [int] NULL,
[LinkList][ntext] NULL
CONSTRAINT [PK_ZL_CollectionItem] PRIMARY KEY CLUSTERED 
(
[CItem_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'ItemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'ModeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID(多节点使用，隔开）' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'NodeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'专题ID（多专题用，隔开）' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'SpecialID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集网站' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'SiteName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集URL' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'CollUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编码选择' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'CodinChoice'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'指定采集数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'CollNum'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集排序' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'CollOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集简介' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'CollContext'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表设置' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'ListSettings'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分页设置' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'PageSettings'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容页采集设置' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'InfoPageSettings'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'AddTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后采集时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'LastTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集开关，1开始，2停止' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'Switch'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'采集状态' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CollectionItem', @level2type=N'COLUMN', @level2name=N'State'

GO
CREATE TABLE [dbo].[ZL_Sns_UserLog](
[ID] [uniqueidentifier] NOT NULL,
[UserID] [int] NULL,
[LogContext] [text] NULL,
[CreatDate] [datetime] NULL,
[UpdateLogDate] [datetime] NULL,
[LogTypeID] [uniqueidentifier] NULL,
[LogState] [int] NULL,
[LogTitle] [varchar](50) NULL,
[ReadCount] [int] NULL CONSTRAINT [DF_ZL_Sns_UserLog_ReadCount]  DEFAULT (0),
[CriticismCount] [int] NULL CONSTRAINT [DF_ZL_Sns_UserLog_CriticismCount]  DEFAULT (0),
CONSTRAINT [PK_ZL_Sns_UserLog] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Comment](
[CommentID] [int] IDENTITY(1,1) NOT NULL,
[GeneralID] [int] NOT NULL,
[Title] [nvarchar](255) NULL,
[Contents] [nvarchar](300) NOT NULL,
[Audited] [bit] NOT NULL CONSTRAINT [DF_ZL_Comment_Audited]  DEFAULT (0),
[UserID] [int] NOT NULL,
[CommentTime] [datetime] NOT NULL CONSTRAINT [DF_ZL_Comment_CommentTime]  DEFAULT (getdate()),
[Score] [int] NOT NULL CONSTRAINT [DF_ZL_Comment_Score]  DEFAULT (0),
[PK] [bit] NULL CONSTRAINT [DF_ZL_Comment_PK]  DEFAULT (0),
[files] [nvarchar](200) NULL,
[status] [int] NULL CONSTRAINT [DF_ZL_Comment_status]  DEFAULT (0),
[pid] [int] NULL CONSTRAINT [DF_ZL_Comment_pid]  DEFAULT (0),
[Type] [int] NULL CONSTRAINT [DF_ZL_Comment_Type]  DEFAULT (0),
[ReprotIDS] [nvarchar](1000) NOT NULL,
 CONSTRAINT [PK_ZL_Comment] PRIMARY KEY CLUSTERED 
(
	[CommentID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ZL_Comment] ADD  CONSTRAINT [DF_ZL_Comment_ReprotIDS]  DEFAULT ('') FOR [ReprotIDS]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论的标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Comment', @level2type=N'COLUMN', @level2name=N'Title'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=反对 1=支持' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Comment', @level2type=N'COLUMN', @level2name=N'PK'

GO
CREATE TABLE [dbo].[ZL_Comment_Count](
[ID] [int] IDENTITY(1,1) NOT NULL,
[CommentID] [int] NOT NULL,
[IP] [nvarchar](500) NULL,
[UserID] [int] NULL,
[UserName] [nvarchar](100) NULL,
[CDate] [datetime] NULL,
[status] [int] NULL,
[GeneralID] [int] NULL,
CONSTRAINT [PK_ZL_Comment_Count] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_UserLogType](
[ID] [uniqueidentifier] NOT NULL,
[LogTypeName] [varchar](50) NULL,
[CreateTime] [datetime] NULL,
[LogArea] [int] NULL,
[UserID] [int] NULL,
[LogTypePWD] [varchar](32) NULL,
CONSTRAINT [PK_ZL_Sns_UserLogType] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Commodities](
[ID] [int] IDENTITY(1,1) NOT NULL,
[OrderID] [int] NULL CONSTRAINT [DF_ZL_Commodities_OrderID]  DEFAULT (1),
[ItemID] [int] NULL,
[Class] [int] NULL CONSTRAINT [DF_ZL_Commodities_Class]  DEFAULT (0),
[Nodeid] [int] NULL CONSTRAINT [DF_ZL_Commodities_Nodeid]  DEFAULT (0),
[ModelID] [int] NULL,
[Categoryid] [int] NULL CONSTRAINT [DF_ZL_Commodities_Categoryid]  DEFAULT (0),
[ProCode] [varchar](50) NULL,
[BarCode] [varchar](50) NULL,
[Proname] [varchar](255) NULL,
[Kayword] [varchar](255) NULL,
[ProUnit] [varchar](50) NULL,
[Weight] [int] NULL CONSTRAINT [DF_ZL_Commodities_Weight]  DEFAULT (0),
[ServerPeriod] [int] NULL CONSTRAINT [DF_ZL_Commodities_ServerPeriod]  DEFAULT (0),
[ServerType] [int] NULL CONSTRAINT [DF_ZL_Commodities_ServerType]  DEFAULT (0),
[ProClass] [int] NULL CONSTRAINT [DF_ZL_Commodities_ProClass]  DEFAULT (0),
[Properties] [int] NULL CONSTRAINT [DF_ZL_Commodities_Properties]  DEFAULT (0),
[Sales] [int] NULL CONSTRAINT [DF_ZL_Commodities_Sales]  DEFAULT (0),
[Proinfo] [text] NULL,
[Procontent] [text] NULL,
[Clearimg] [varchar](255) NULL,
[Thumbnails] [varchar](255) NULL,
[Producer] [varchar](255) NULL,
[Brand] [varchar](50) NULL,
[Allowed] [int] NULL CONSTRAINT [DF_ZL_Commodities_Allowed]  DEFAULT (0),
[Quota] [int] NULL CONSTRAINT [DF_ZL_Commodities_Quota]  DEFAULT (0),
[DownQuota] [int] NULL CONSTRAINT [DF_ZL_Commodities_DownQuota]  DEFAULT (0),
[Stock] [int] NULL CONSTRAINT [DF_ZL_Commodities_Stock]  DEFAULT (0),
[StockDown] [int] NULL CONSTRAINT [DF_ZL_Commodities_StockDown]  DEFAULT (0),
[JisuanFs] [int] NULL CONSTRAINT [DF_ZL_Commodities_JisuanFs]  DEFAULT (0),
[Rate] [money] NULL CONSTRAINT [DF_ZL_Commodities_Rate]  DEFAULT (0),
[Rateset] [int] NULL,
[Dengji] [int] NULL CONSTRAINT [DF_ZL_Commodities_Dengji]  DEFAULT (0),
[ShiPrice] [money] NULL CONSTRAINT [DF_ZL_Commodities_ShiPrice]  DEFAULT (0),
[LinPrice] [money] NULL CONSTRAINT [DF_ZL_Commodities_LinPrice]  DEFAULT (0),
[MemberPrice] [varchar](255) NULL CONSTRAINT [DF_ZL_Commodities_MemberPrice]  DEFAULT (0 | 0),
[ActPrice] [varchar](255) NULL CONSTRAINT [DF_ZL_Commodities_ActPrice]  DEFAULT (0 | 0),
[Wholesales] [int] NULL CONSTRAINT [DF_ZL_Commodities_Wholesales]  DEFAULT (0),
[Wholesaleone] [int] NULL CONSTRAINT [DF_ZL_Commodities_Wholesaleone]  DEFAULT (0),
[Wholesalesinfo] [varchar](255) NULL CONSTRAINT [DF_ZL_Commodities_Wholesalesinfo]  DEFAULT ('0|0,0|0,0|0'),
[Preset] [varchar](255) NULL,
[Integral] [int] NULL CONSTRAINT [DF_ZL_Commodities_Integral]  DEFAULT (0),
[Propeid] [int] NULL CONSTRAINT [DF_ZL_Commodities_Propeid]  DEFAULT (0),
[Recommend] [int] NULL CONSTRAINT [DF_ZL_Commodities_Recommend]  DEFAULT (0),
[Priority] [int] NULL CONSTRAINT [DF_ZL_Commodities_Priority]  DEFAULT (0),
[MonthClickNum] [int] NULL CONSTRAINT [DF_ZL_Commodities_MonthClickNum]  DEFAULT (0),
[ModeTemplate] [varchar](255) NULL,
[AddUser] [varchar](255) NULL,
[DownCar] [int] NULL CONSTRAINT [DF_ZL_Commodities_DownCar]  DEFAULT (0),
[AddTime] [datetime] NULL CONSTRAINT [DF_ZL_Commodities_AddTime]  DEFAULT (getdate()),
[UpdateTime] [datetime] NULL CONSTRAINT [DF_ZL_Commodities_UpdateTime]  DEFAULT (getdate()),
[TableName] [varchar](50) NULL,
[Istrue] [int] NULL CONSTRAINT [DF_ZL_Commodities_Istrue]  DEFAULT (0),
[Isgood] [int] NULL CONSTRAINT [DF_ZL_Commodities_Isgood]  DEFAULT (0),
[MakeHtml] [int] NULL CONSTRAINT [DF_ZL_Commodities_MakeHtml]  DEFAULT (0),
[Sold] [int] NULL CONSTRAINT [DF_ZL_Commodities_Sold]  DEFAULT (0),
[isnew] [int] NULL CONSTRAINT [DF_ZL_Commodities_isnew]  DEFAULT (0),
[ishot] [int] NULL CONSTRAINT [DF_ZL_Commodities_ishot]  DEFAULT (0),
[isbest] [int] NULL CONSTRAINT [DF_ZL_Commodities_isbest]  DEFAULT (0),	
[ComModelID] [int] NULL,
[AllClickNum] [int] NULL CONSTRAINT [DF_ZL_Commodities_AllClickNum]  DEFAULT (0),
[Largess] [int] NULL CONSTRAINT [DF_ZL_Commodities_Largess]  DEFAULT (0),
[Largesspirx] [money] NULL CONSTRAINT [DF_ZL_Commodities_Largesspirx]  DEFAULT (0),
[ProjectType] [int] NULL CONSTRAINT [DF_ZL_Commodities_ProjectType]  DEFAULT (1),
[ProjectPronum] [int] NULL CONSTRAINT [DF_ZL_Commodities_ProjectPronum]  DEFAULT (1),
[ProjectMoney] [money] NULL CONSTRAINT [DF_ZL_Commodities_ProjectMoney]  DEFAULT (0),
[IntegralNum] [int] NULL CONSTRAINT [DF_ZL_Commodities_IntegralNum]  DEFAULT (1),
[PesentNames] [nvarchar](255) NULL,
[PesentNameid] [int] NULL,
[Recycler] [bit] NULL CONSTRAINT [DF_ZL_Commodities_Recycler]  DEFAULT (0),	
[ProSeller] [nvarchar] (255) NULL,
[GuessType] [int] NULL,
[GuessXML] [nvarchar](1000) NULL,
[FirstNodeID] [int] NULL,
[PointVal] [int] NULL,
[isStand] [int] NULL,
[UserShopID] [int] NULL,
[BookPrice] [money] NULL,
[bookDay] [int] NULL,
[UserType] [int] NULL,
[UserPrice] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
[FestlPrice] [money] NULL,
[FestPeriod] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
[ColonelTime] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
[ColoneDeposit] [money] NULL,
[FarePrice] [nvarchar](400) COLLATE Chinese_PRC_CI_AS NULL,
[ExpRemind] [int] NULL,
[LinPrice_Json] [nvarchar](500) NULL,
[ParentID] [int] NULL,
[UserID] [int] NULL,
[BindIDS] [varchar](4000) NULL,
CONSTRAINT [PK_ZL_Commodities] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET IDENTITY_INSERT [ZL_Commodities] ON
INSERT [ZL_Commodities] ([ID],[OrderID],[ItemID],[Class],[Nodeid],[ModelID],[Categoryid],[ProCode],[Proname],[ProUnit],[Weight],[ServerPeriod],[ServerType],[ProClass],[Properties],[Sales],[Proinfo],[Procontent],[Clearimg],[Thumbnails],[Allowed],[Quota],[DownQuota],[Stock],[StockDown],[JisuanFs],[Rate],[Rateset],[Dengji],[ShiPrice],[LinPrice],[MemberPrice],[ActPrice],[Wholesales],[Wholesaleone],[Preset],[Integral],[Propeid],[Recommend],[Priority],[MonthClickNum],[AddUser],[DownCar],[AddTime],[UpdateTime],[TableName],[Istrue],[Isgood],[MakeHtml],[Sold],[isnew],[ishot],[isbest],[ComModelID],[AllClickNum],[Largess],[Largesspirx],[ProjectType],[ProjectPronum],[ProjectMoney],[IntegralNum],[PesentNameid],[Recycler],[GuessType],[GuessXML],[FirstNodeID],[PointVal],[isStand],[UserShopID],[BookPrice],[bookDay],[UserType],[FestlPrice],[FestPeriod],[ColoneDeposit],[FarePrice],[ParentID],[UserID]) VALUES ( 1,1,1,1,75,6,0,N'2012120145963411137',N'示例商品之一',N'件',0,0,3,1,0,1,N'这个冬天我们奉献最时尚的衣装和折扣...',N'这里放置商品的详细介绍',N'UploadFiles/demo/01.jpg',N'UploadFiles/demo/02.jpg',0,-1,-1,20,1,0,0.0000,1,3,100.0000,80.0000,N'0',N'0',0,1,N'1',0,0,0,0,0,N'admin',0,N'2015/10/13 16:59:52',N'2015/10/13 16:59:52',N'ZL_P_Shop',1,0,0,0,1,0,0,2,91,0,0.0000,7,0,1.0000,0,0,0,1,N'drawback,exchange',2,0,1,0,0.0000,0,0,0.0000,N'2015-08-31|',0.0000,N'1',0,0)
INSERT [ZL_Commodities] ([ID],[OrderID],[ItemID],[Class],[Nodeid],[ModelID],[Categoryid],[ProCode],[Proname],[ProUnit],[Weight],[ServerPeriod],[ServerType],[ProClass],[Properties],[Sales],[Proinfo],[Procontent],[Clearimg],[Thumbnails],[Allowed],[Quota],[DownQuota],[Stock],[StockDown],[JisuanFs],[Rate],[Rateset],[Dengji],[ShiPrice],[LinPrice],[MemberPrice],[ActPrice],[Wholesales],[Wholesaleone],[Integral],[Propeid],[Recommend],[Priority],[MonthClickNum],[AddUser],[DownCar],[AddTime],[UpdateTime],[TableName],[Istrue],[Isgood],[MakeHtml],[Sold],[isnew],[ishot],[isbest],[ComModelID],[AllClickNum],[Largess],[Largesspirx],[ProjectType],[ProjectPronum],[ProjectMoney],[IntegralNum],[PesentNameid],[Recycler],[GuessType],[GuessXML],[FirstNodeID],[PointVal],[UserShopID],[BookPrice],[bookDay],[UserType],[FestlPrice],[FestPeriod],[ColoneDeposit],[FarePrice],[ParentID],[UserID]) VALUES ( 2,2,2,0,75,6,0,N'201212014584333148946',N'示例商品二',N'件',0,0,3,1,0,1,N'源自德国的男装风格',N'源自德国的男装风格，为您的冬天装点一切。',N'UploadFiles/demo/04.jpg',N'UploadFiles/demo/04.jpg',0,-1,-1,20,1,0,0.0000,1,3,988.0000,688.0000,N'0',N'0',0,1,0,0,0,0,0,N'admin',0,N'2015/10/12 8:40:54',N'2015/12/31 8:40:54',N'ZL_P_Shop',1,0,0,0,1,0,0,128,2,0,0.0000,1,0,0.0000,1,0,0,1,N'drawback,exchange',2,0,0,0.0000,0,0,0.0000,N'2015-08-31|',0.0000,N'1',0,0)
INSERT [ZL_Commodities] ([ID],[OrderID],[ItemID],[Class],[Nodeid],[ModelID],[Categoryid],[ProCode],[Proname],[ProUnit],[Weight],[ServerPeriod],[ServerType],[ProClass],[Properties],[Sales],[Proinfo],[Procontent],[Clearimg],[Thumbnails],[Brand],[Allowed],[Quota],[DownQuota],[Stock],[StockDown],[JisuanFs],[Rate],[Rateset],[Dengji],[ShiPrice],[LinPrice],[MemberPrice],[ActPrice],[Wholesales],[Wholesaleone],[Integral],[Propeid],[Recommend],[Priority],[MonthClickNum],[AddUser],[DownCar],[AddTime],[UpdateTime],[TableName],[Istrue],[Isgood],[MakeHtml],[Sold],[isnew],[ishot],[isbest],[ComModelID],[AllClickNum],[Largess],[Largesspirx],[ProjectType],[ProjectPronum],[ProjectMoney],[IntegralNum],[PesentNameid],[Recycler],[GuessType],[GuessXML],[FirstNodeID],[PointVal],[UserShopID],[BookPrice],[bookDay],[UserType],[FestlPrice],[FestPeriod],[ColoneDeposit],[FarePrice],[ParentID],[UserID]) VALUES ( 3,3,3,0,75,6,0,N'20121201533447191785',N'示例商品三',N'件',1,1,3,1,0,1,N'商品简介',N'<p>	商品简介商品简介商品简介商品简介</p>',N'UploadFiles/demo/04.jpg',N'UploadFiles/demo/04.jpg',N'九牧王',0,-1,-1,20,1,0,0.0000,1,3,500.0000,455.0000,N'0',N'0',0,1,0,0,0,0,0,N'admin',0,N'2015/1/20 15:01:19',N'2015/1/20 15:01:19',N'ZL_P_Shop',1,0,0,0,1,0,0,309,0,0,0.0000,1,0,0.0000,1,0,0,1,N'drawback,exchange',2,0,0,0.0000,0,0,0.0000,N'2015-08-31|',0.0000,N'1',0,0)
INSERT [ZL_Commodities] ([ID],[OrderID],[ItemID],[Class],[Nodeid],[ModelID],[Categoryid],[ProCode],[Proname],[ProUnit],[Weight],[ServerPeriod],[ServerType],[ProClass],[Properties],[Sales],[Allowed],[Quota],[DownQuota],[Stock],[StockDown],[JisuanFs],[Rate],[Rateset],[Dengji],[ShiPrice],[LinPrice],[MemberPrice],[ActPrice],[Wholesales],[Wholesaleone],[Integral],[Propeid],[Recommend],[Priority],[MonthClickNum],[AddUser],[DownCar],[AddTime],[UpdateTime],[TableName],[Istrue],[Isgood],[MakeHtml],[Sold],[isnew],[ishot],[isbest],[ComModelID],[AllClickNum],[Largess],[Largesspirx],[ProjectType],[ProjectPronum],[ProjectMoney],[IntegralNum],[PesentNameid],[Recycler],[GuessType],[FirstNodeID],[PointVal],[UserShopID],[BookPrice],[bookDay],[UserType],[FestlPrice],[FestPeriod],[ColoneDeposit],[FarePrice],[ExpRemind],[ParentID],[UserID]) VALUES ( 4,4,27,0,129,6,0,N'2015227116463787783',N'希尔顿套房',N'次',0,0,3,8,0,1,1,-1,-1,10,1,0,0.0000,1,3,300.0000,300.0000,N'0',N'0',0,1,0,0,0,0,0,N'admin',0,N'2015/2/27 11:06:46',N'2015/2/27 11:06:46',N'ZL_P_Shop',1,0,0,0,1,0,0,54,0,0,0.0000,1,0,0.0000,1,0,0,1,2,0,0,0.0000,0,0,0.0000,N'|',0.0000,N'1',0,0,0)
INSERT [ZL_Commodities] ([ID],[OrderID],[ItemID],[Class],[Nodeid],[ModelID],[Categoryid],[ProCode],[Proname],[ProUnit],[Weight],[ServerPeriod],[ServerType],[ProClass],[Properties],[Sales],[Allowed],[Quota],[DownQuota],[Stock],[StockDown],[JisuanFs],[Rate],[Rateset],[Dengji],[ShiPrice],[LinPrice],[MemberPrice],[ActPrice],[Wholesales],[Wholesaleone],[Integral],[Propeid],[Recommend],[Priority],[MonthClickNum],[AddUser],[DownCar],[AddTime],[UpdateTime],[TableName],[Istrue],[Isgood],[MakeHtml],[Sold],[isnew],[ishot],[isbest],[ComModelID],[AllClickNum],[Largess],[Largesspirx],[ProjectType],[ProjectPronum],[ProjectMoney],[IntegralNum],[PesentNameid],[Recycler],[GuessType],[FirstNodeID],[PointVal],[UserShopID],[BookPrice],[bookDay],[UserType],[FestlPrice],[FestPeriod],[ColoneDeposit],[FarePrice],[ExpRemind],[ParentID],[UserID]) VALUES ( 5,5,28,0,129,6,0,N'20152271173162133761',N'旅游商品(成人票)',N'张',0,0,3,7,0,1,0,-1,-1,10,1,0,0.0000,1,3,80.0000,80.0000,N'0',N'0',0,1,0,0,0,0,0,N'admin',0,N'2015/2/27 11:07:31',N'2015/2/27 11:07:31',N'ZL_P_Shop',1,0,0,0,1,0,0,55,0,0,0.0000,1,0,0.0000,1,0,0,1,2,0,0,0.0000,0,0,0.0000,N'|',0.0000,N'1',0,0,0)
INSERT [ZL_Commodities] ([ID],[OrderID],[ItemID],[Class],[Nodeid],[ModelID],[Categoryid],[ProCode],[Proname],[ProUnit],[Weight],[ServerPeriod],[ServerType],[ProClass],[Properties],[Sales],[Allowed],[Quota],[DownQuota],[Stock],[StockDown],[JisuanFs],[Rate],[Rateset],[Dengji],[ShiPrice],[LinPrice],[MemberPrice],[ActPrice],[Wholesales],[Wholesaleone],[Wholesalesinfo],[Integral],[Propeid],[Recommend],[Priority],[MonthClickNum],[AddUser],[DownCar],[AddTime],[UpdateTime],[TableName],[Istrue],[Isgood],[MakeHtml],[Sold],[isnew],[ishot],[isbest],[ComModelID],[AllClickNum],[Largess],[Largesspirx],[ProjectType],[ProjectPronum],[ProjectMoney],[IntegralNum],[PesentNameid],[Recycler],[GuessType],[FirstNodeID],[PointVal],[UserShopID],[BookPrice],[bookDay],[UserType],[FestlPrice],[FestPeriod],[ColoneDeposit],[FarePrice],[ExpRemind],[LinPrice_Json],[ParentID],[UserID]) VALUES ( 6,6,29,0,129,6,0,N'20152271175679146881',N'北京旅游',N'张',0,0,3,7,0,1,0,-1,-1,10,1,0,0.0000,1,3,20.0000,20.0000,N'0',N'0',0,1,N'[{"code":"5bd6u8","Proname":"成人","LinPrice":"120","ShiPrice":"100"},{"code":"pzFU9c","Proname":"儿童","LinPrice":"80","ShiPrice":"50"}]',0,0,0,0,0,N'admin',0,N'2015/2/27 11:07:56',N'2015/10/10 18:32:32',N'ZL_P_Shop',1,0,0,0,1,0,0,56,0,0,0.0000,1,0,0.0000,1,0,0,1,2,0,0,0.0000,0,0,0.0000,N'|',0.0000,N'1',1,N'{
  "purse": "0.00",
  "sicon": "0.00",
  "point": "0.00"
}',0,0)
SET IDENTITY_INSERT [ZL_Commodities] OFF

GO
CREATE TABLE [dbo].[ZL_Sns_UserMoreinfo](
[UserID] [int] IDENTITY(1,1) NOT NULL,
[UserIdcard] [nvarchar](18) NULL,
[UserSex] [bit] NULL,
[UserStature] [nvarchar](3) NULL,
[UserAvoir] [nvarchar](3) NULL,
[UserBir] [nvarchar](50) NULL,
[UserMarry] [nvarchar](50) NULL,
[UserBachelor] [nvarchar](50) NULL,
[UserMonthIn] [nvarchar](50) NULL,
[UserHome] [nvarchar](50) NULL,
[UserChild] [nvarchar](50) NULL,
[UserConsortSex] [nvarchar](4) NULL,
[UserConsortAge] [nvarchar](50) NULL,
[UserConsortWorkArea] [nvarchar](50) NULL,
[UserConsortMarry] [nvarchar](50) NULL,
[UserConsortStature] [nvarchar](50) NULL,
[UserConsortAvoir] [nvarchar](50) NULL,
[UserConsortMonthIN] [nvarchar](50) NULL,
[UserConsortBachelor] [nvarchar](50) NULL,
[UserConsortHome] [nvarchar](50) NULL,
[UserConsortOther] [nvarchar](200) NULL,
[UserSomato] [nvarchar](50) NULL,
[UserBlood] [nvarchar](50) NULL,
[UserProvince] [nvarchar](50) NULL,
[UserCity] [nvarchar](50) NULL,
[UserNation] [nvarchar](50) NULL,
[UserSchool] [nvarchar](50) NULL,
[UserBrother] [nvarchar](50) NULL,
[UserLanguage] [nvarchar](50) NULL,
[UserLifePic4] [nvarchar](100) NULL,
[UserLifePic3] [nvarchar](100) NULL,
[UserLifePic1] [nvarchar](100) NULL,
[UserLife] [nvarchar](50) NULL,
[UserSmoke] [nvarchar](50) NULL,
[UserDrink] [nvarchar](50) NULL,
[UserWork] [nvarchar](50) NULL,
[UserCar] [nvarchar](50) NULL,
[UserCom] [nvarchar](50) NULL,
[UserNeedchild] [nvarchar](50) NULL,
[UserAcctive] [nvarchar](200) NULL,
[UserAth] [nvarchar](200) NULL,
[UserMusic] [nvarchar](200) NULL,
[UserMovie] [nvarchar](200) NULL,
[UserFood] [nvarchar](200) NULL,
[UserArea] [nvarchar](200) NULL,
[UserHeart] [ntext] NULL,
[UserLove] [ntext] NULL,
[UserLifePic2] [nvarchar](100) NULL,
[UserConstellation] [nvarchar](50) NULL,
[Xinyang] [nvarchar] (50)  NULL ,
[Facey] [nvarchar] (500)  NULL ,
[FaceType] [nvarchar] (50)  NULL ,
[HairType] [nvarchar] (50) NULL ,
[Lovepetlife] [nvarchar] (500) NULL ,
[JobAnd] [nvarchar] (255) NULL ,	
 CONSTRAINT [PK_ZL_Sns_UserMoreinfo] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'星座' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Sns_UserMoreinfo', @level2type=N'COLUMN', @level2name=N'UserConstellation'

GO
CREATE TABLE [dbo].[ZL_CommonModel]
(
[GeneralID] [int] IDENTITY(1,1) NOT NULL,
[OrderID] [int] NULL CONSTRAINT [DF_ZL_CommonModel_OrderID]  DEFAULT (1),
[NodeID] [int] NOT NULL,
[ModelID] [int] NOT NULL,
[ItemID] [int] NOT NULL,
[TableName] [nvarchar](50) NOT NULL,
[Title] [nvarchar](255) NOT NULL,
[Inputer] [nvarchar](255) NULL CONSTRAINT [DF_ZL_CommonModel_Inputer]  DEFAULT (''),
[Hits] [int] NULL CONSTRAINT [DF_ZL_CommonModel_Hits]  DEFAULT (0),
[CreateTime] [datetime] NULL CONSTRAINT [DF_ZL_CommonModel_CreateTime]  DEFAULT (getdate()),
[Status] [int] NULL CONSTRAINT [DF_ZL_CommonModel_Status]  DEFAULT (0),
[EliteLevel] [int] NULL CONSTRAINT [DF_ZL_CommonModel_EliteLevel]  DEFAULT (0),
[InfoID] [nvarchar](255) NULL CONSTRAINT [DF_ZL_CommonModel_InfoID]  DEFAULT (''),
[SpecialID] [nvarchar](255) NULL CONSTRAINT [DF_ZL_CommonModel_SpecialID]  DEFAULT (''),
[IsCreate] [int] NULL CONSTRAINT [DF_ZL_CommonModel_IsCreate]  DEFAULT (0),
[HtmlLink] [nvarchar](500) NULL CONSTRAINT [DF_ZL_CommonModel_HtmlLink]  DEFAULT (''),
[Titlecolor] [nvarchar](255) NULL CONSTRAINT [DF_ZL_CommonModel_Titlecolor]  DEFAULT (''),
[Template] [nvarchar](255) NULL,
[Tagkey] [nvarchar](1000) NULL,
[UpDateTime] [datetime] NULL,
[UpDateType] [int] NULL,
[cast_file] [int] NULL,
[because_back] [nvarchar] (200) NULL,
[PdfLink] [nvarchar](500) NULL CONSTRAINT [DF_ZL_CommonModel_PdfLink]  DEFAULT (''),
[Rtype] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL DEFAULT (null),
[SuccessfulUserID] [int] NULL,
[ComplianceUserList] [nvarchar](2000) COLLATE Chinese_PRC_CI_AS NULL,
[Subtitle] [nvarchar](2000) COLLATE Chinese_PRC_CI_AS NULL,
[PYtitle] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
[BidMoney] [money] NULL,
[IsBid] [int] NULL,
[Pronum] [int] NULL,
[ProWeek] [int] NULL,
[BidType] [int] NULL,
[DefaultSkins] [int]  NULL CONSTRAINT [DF_ZL_CommonModel_DefaultSkins]  DEFAULT (0),
[OrederClass] [int] NULL,
[FirstNodeID] [int] NULL,
[TitleStyle] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
[ParentTree] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
[TopImg] [nvarchar](100) COLLATE Chinese_PRC_CI_AS NULL,
[IsCatch] [int]  NULL DEFAULT (0),
[RelatedIDS] [varchar](3000) NULL,
[IsComm] [int] NULL
 CONSTRAINT [PK_ZL_CommonModel] PRIMARY KEY CLUSTERED 
(
	[GeneralID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容全局ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'GeneralID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'NodeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属内容模型ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'ModelID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'相应表的记录ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'ItemID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Title'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'录入者' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Inputer'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'点击数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Hits'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'生成时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'CreateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'信息状态 -2为删除，-1为退稿，0为待审核，99为终审通过，其它为自定义' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Status'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'推荐' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'EliteLevel'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属其他节点数组' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'InfoID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属专题ID数组' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'SpecialID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否已生成0=未生成 1=已生成' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'IsCreate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'生成的静态页面地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'HtmlLink'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'关键字' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Tagkey'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'UpDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新时间类型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'UpDateType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标题颜色' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Titlecolor'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PDF生成地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'PdfLink'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'副标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'Subtitle'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'拼音标题缩写' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'PYtitle'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'内容类别' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'OrederClass'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'第一级节点' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'FirstNodeID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'标题字体' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'TitleStyle'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'首页图片' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CommonModel', @level2type=N'COLUMN', @level2name=N'TopImg'

GO
CREATE TABLE [dbo].[ZL_Sns_UserShopProduct](
[ID] [uniqueidentifier] NOT NULL,
[UserID] [int] NULL,
[ProductID] [uniqueidentifier] NULL,
[ShopDay] [int] NULL,
[Addtime] [datetime] NULL,
[LargessContent] [ntext] NULL,
[LargessID] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_UserShopProduct] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_User_R_GS](
[ID] [uniqueidentifier] NOT NULL,
[UserID] [int] NULL,
[GSID] [uniqueidentifier] NULL,
[CreateTime] [datetime] NULL,
[LastCallTime] [datetime] NULL,
[root][int] NULL,
CONSTRAINT [PK_ZL_Sns_User_R_GS] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Correct](
[CorrectID] [int] IDENTITY(1,1) NOT NULL,
[CorrectUrl] [nvarchar](255) NOT NULL,
[CorrectTitle] [nvarchar](255) NOT NULL,
[CorrectType] [int] NOT NULL CONSTRAINT [DF_ZL_Correct_CorrectType]  DEFAULT (0),
[CorrectDetail] [nvarchar](255) NULL,
[CorrectPer] [nvarchar](50) NULL,
[PerEmail] [nvarchar](50) NULL,
CONSTRAINT [PK_ZL_Correct] PRIMARY KEY CLUSTERED 
(
[CorrectID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0-内容错误 1-错别字 2-图片错误 3-链接错误' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Correct', @level2type=N'COLUMN', @level2name=N'CorrectType'

GO
CREATE TABLE [dbo].[ZL_Sns_User_R_Module](
[ID] [uniqueidentifier] NOT NULL,
[UserID] [int] NULL,
[VisibleDegree] [int] NULL,
[ModuleID] [uniqueidentifier] NULL,
[Taix] [int] NULL,
CONSTRAINT [PK_ZL_Sns_User_R_Module] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_blogTable](
[ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NULL,
[BlogName] [varchar](50) NULL,
[BlogContent] [ntext] NULL,
[BlogState] [int] NULL,
[Addtime] [datetime] NULL,
[CommendState] [int] NULL,
[StyleID] [int] NULL,
[BlogHits] [int] NULL,
CONSTRAINT [PK_ZL_Sns_blogTable] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_CustomerService](
[CS_ID] [int] IDENTITY(1,1) NOT NULL,
[CS_Context] [nvarchar](4000) NULL,
[CS_SendID] [int] NULL,
[CS_SendName] [nvarchar](50) NULL,
[CS_Ctouid] [int] NULL,
[CS_CtoName] [nvarchar](50) NULL,
[CS_AddTime] [datetime] NULL,
[CS_Type] [int] NULL,
[CS_OID] [int] NULL,
[CS_Remrk] [nvarchar](500) NULL,
CONSTRAINT [PK_ZL_CustomerService] PRIMARY KEY CLUSTERED 
(
[CS_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_Context'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发送者ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_SendID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发送者用户名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_SendName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'接收者ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_Ctouid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'接收者用户名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_CtoName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发送时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_AddTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'信息类型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_Type'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'OnlineUsersID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_OID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_CustomerService', @level2type=N'COLUMN', @level2name=N'CS_Remrk'

GO
CREATE TABLE [dbo].[ZL_Source](
[ID] [int] IDENTITY(1,1) NOT NULL,
[Type] [nvarchar](50) NULL CONSTRAINT [DF_ZL_Source_Type]  DEFAULT (0),
[Name] [nvarchar](50) NOT NULL,
[Passed] [bit] NULL CONSTRAINT [DF_ZL_Source_Passed]  DEFAULT (0),
[onTop] [bit] NULL CONSTRAINT [DF_ZL_Source_onTop]  DEFAULT (0),
[IsElite] [bit] NULL CONSTRAINT [DF_ZL_Source_IsElite]  DEFAULT (0),
[Hits] [int] NULL CONSTRAINT [DF_ZL_Source_Hits]  DEFAULT (0),
[LastUseTime] [datetime] NULL,
[Photo] [nvarchar](255) NULL,
[Intro] [nvarchar](255) NULL,
[Address] [nvarchar](50) NULL,
[Tel] [nvarchar](50) NULL,
[Fax] [nvarchar](50) NULL,
[Mail] [nvarchar](50) NULL,
[Email] [nvarchar](50) NULL,
[ZipCode] [int] NULL,
[HomePage] [nvarchar](50) NULL,
[Im] [nvarchar](50) NULL,
[Contacter] [nvarchar](50) NULL,
CONSTRAINT [PK_ZL_Source] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[ZL_Special](
[SpecID] [int] IDENTITY(1,1) NOT NULL,
[SpecName] [nvarchar](50) NOT NULL,
[SpecDir] [nvarchar](50) NOT NULL,
[SpecDesc] [nvarchar](255) NULL,
[OpenType] [bit] NULL CONSTRAINT [DF_ZL_Special_OpenType]  DEFAULT (0),
[SpecCate] [int] NOT NULL,
[ListFileExt] [int] NULL,
[ListTemplate] [nvarchar](255) NULL,
[ListFileRule] [int] NULL CONSTRAINT [DF_ZL_Special_ListFileRule]  DEFAULT (0),
[SpecDescriptive] [nvarchar] (255) NOT NULL,
[SpecKeyword] [nvarchar] (255) NOT NULL,
[SpecPicUrl] [nvarchar] (255) NOT NULL,
[SpecTips] [nvarchar] (255) NOT NULL,
[Pid] [int] NOT NULL,
CONSTRAINT [PK_ZL_Special] PRIMARY KEY CLUSTERED 
(
[SpecID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'专题名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'专题目录' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecDir'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'专题说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecDesc'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'打开方式' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'OpenType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属专题类别' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecCate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'扩展名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'ListFileExt'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表页模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'ListTemplate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表页文件名规则' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'ListFileRule'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'描述' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecDescriptive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'关键字' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecKeyword'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'专题图片' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecPicUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'专题提示' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Special', @level2type=N'COLUMN', @level2name=N'SpecTips'

GO
CREATE TABLE [dbo].[ZL_Datadic](
[Dicid] [int] IDENTITY(1,1) NOT NULL,
[Diccate] [int] NOT NULL CONSTRAINT [DF_ZL_DATADIC_DICCATE]  DEFAULT (0),
[Dicname] [varchar](50) NOT NULL,
[Isused] [bit] NULL,
CONSTRAINT [PK_ZL_DATADIC] PRIMARY KEY CLUSTERED 
(
[Dicid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Datadiccategory](
[Diccateid] [int] IDENTITY(1,1) NOT NULL,
[Categoryname] [varchar](50) NOT NULL,
[Isused] [bit] NULL CONSTRAINT [DF_ZL_DATADICCATEGORY_ISUSED]  DEFAULT (0),
CONSTRAINT [PK_ZL_DATADICCATEGORY] PRIMARY KEY CLUSTERED 
(
[Diccateid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
 
GO
CREATE TABLE [dbo].[ZL_Stock](
[ID] [int] IDENTITY(1,1) NOT NULL,
[stocktype] [int] NULL CONSTRAINT [DF_ZL_Stock_stocktype]  DEFAULT (0),
[danju] [varchar](500) NULL,
[proname] [varchar](500) NULL,
[addtime] [datetime] NULL CONSTRAINT [DF_ZL_Stock_addtime]  DEFAULT (getdate()),
[adduser] [varchar](50) NULL,
[content] [ntext] NULL,
[proid] [int] NULL,
[pronum] [int] NULL CONSTRAINT [DF_ZL_Stock_pronum]  DEFAULT (0),
CONSTRAINT [PK_ZL_Stock] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_StoreStyleTable](
[ID] [int] IDENTITY(1,1) NOT NULL,
[StyleName] [varchar](50) NULL,
[StylePic] [varchar](100) NULL,
[StyleUrl] [varchar](200) NULL,
[ListStyle] [nvarchar](255) NULL,
[ContentStyle] [nvarchar](255) NULL,
[ModelID] [int] NULL,
[IsTrue] [int] NULL
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表页模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_StoreStyleTable', @level2type=N'COLUMN', @level2name=N'ListStyle'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容页模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_StoreStyleTable', @level2type=N'COLUMN', @level2name=N'ContentStyle'

GO
CREATE TABLE [dbo].[ZL_Delivier](
[ID] [int] IDENTITY(1,1) NOT NULL,
[deliname] [varchar](50) NULL,
[deliinfo] [varchar](255) NULL,
[delitype] [money] NULL,
[shuilv] [money] NULL,
[selectto] [int] NULL,
[isuse] [int] NULL CONSTRAINT [DF_ZL_Delivier_isuse]  DEFAULT (1),
[istype] [int] NULL CONSTRAINT [DF_ZL_Delivier_istype]  DEFAULT (1),
[citymoney] [money] NULL,
[citykg] [float] NULL,
[bigcitykg] [float] NULL,
[bigcitymoney] [money] NULL,
[maxcity] [money] NULL,
[outmoney] [money] NULL,
[outkg] [float] NULL,
[bigoutkg] [float] NULL,
[bigoutmoney] [money] NULL,
[maxout] [money] NULL,
[city] [nvarchar](100) NULL,
CONSTRAINT [PK_ZL_Delivier] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_MoneyManage](
[Flow] [int] IDENTITY(1,1) NOT NULL,
[Money_code] [varchar](10) NULL,
[Money_descp] [varchar](20) NULL,
[Money_sign] [varchar](4) NULL,
[Money_rate] [numeric](18, 5) NULL,
[Is_flag] [char](1) NULL,
CONSTRAINT [PK_zl_moneyManage] PRIMARY KEY CLUSTERED 
(
[Flow] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'汇率' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MoneyManage', @level2type=N'COLUMN', @level2name=N'Money_rate'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'1为默认货币，' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MoneyManage', @level2type=N'COLUMN', @level2name=N'Is_flag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1免费2重量计算3固定值' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'istype'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'城市之间基本运费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'citymoney'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'城市之间货物重量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'citykg'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'城市之间货物超出重量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'bigcitykg'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'城市之间每公斤超出运费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'bigcitymoney'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'城市之间最大运费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'maxcity'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'省外基本运费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Delivier', @level2type=N'COLUMN', @level2name=N'outmoney'

GO
CREATE TABLE [dbo].[ZL_Exam_Student](
	[Noteid] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[UserName] [nvarchar](255) NULL,
	[SchoolID] [int] NULL,
	[RoomID] [int] NULL,
	[Addtime] [datetime] NULL,
	[StatusType] [int] NULL,
	[StudentType] [int] NULL,
	[StudentTypeTitle] [nvarchar](50) NULL,
	[Auditing] [int] NULL,
	[AuditingContext] [nvarchar](50) NULL,
	[AuditingUserID] [int] NULL,
	[AuditingUserName] [nvarchar](255) NULL,
 CONSTRAINT [PK_ZL_Exam_Student] PRIMARY KEY CLUSTERED 
(
	[Noteid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'记录ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'Noteid'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学校ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'SchoolID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'班级ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'RoomID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'加入时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'Addtime'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'身份类型 1：学生，2：老师，3：家长' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'StatusType'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学生属性：1、学生' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'StudentType'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学生属性：是学生或班干部；StatusType属性为1时。此属性值有效' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'StudentTypeTitle'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'审核用户 0：未审核，1：审核通过' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'Auditing'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'申请理由' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'AuditingContext'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'审核用户ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'AuditingUserID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'审核用户用户名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exam_Student', @level2type=N'COLUMN',@level2name=N'AuditingUserName'
GO

ALTER TABLE [dbo].[ZL_Exam_Student] ADD  CONSTRAINT [DF_ZL_Student_Addtime]  DEFAULT (getdate()) FOR [Addtime]
GO
CREATE TABLE [dbo].[ZL_DownServer](
[ServerID] [int] NOT NULL,
[ServerName] [nvarchar](50) NULL,
[ServerUrl] [nvarchar](50) NULL,
[ServerLogo] [nvarchar](255) NULL,
[OrderID] [int] NULL,
[ShowType] [int] NULL,
[UrlEncrypt] [int] NULL CONSTRAINT [DF_ZL_DownServer_UrlEncrypt]  DEFAULT (0),
[EncryptKey] [nvarchar](255) NULL CONSTRAINT [DF_ZL_DownServer_EncryptKey]  DEFAULT (''),
[TimeEncrypt] [int] NULL CONSTRAINT [DF_ZL_DownServer_TimeEncrypt]  DEFAULT (0),
[UpTimeuti] [int] NULL CONSTRAINT [DF_ZL_DownServer_UpTimeuti]  DEFAULT (1),
[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_Survey_Addtime]  DEFAULT (getdate()),
[Encryptime] [datetime] NULL CONSTRAINT [DF_ZL_Survey_Encryptime]  DEFAULT (getdate()),
[ReadRoot] [nvarchar](1000) NULL,

CONSTRAINT [PK_ZL_DownServer] PRIMARY KEY CLUSTERED 
(
[ServerID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'加密方式' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_DownServer', @level2type=N'COLUMN', @level2name=N'UrlEncrypt'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'加密密钥' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_DownServer', @level2type=N'COLUMN', @level2name=N'EncryptKey'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'时间戳加密' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_DownServer', @level2type=N'COLUMN', @level2name=N'TimeEncrypt'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新时间戳间隔时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_DownServer', @level2type=N'COLUMN', @level2name=N'UpTimeuti'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_DownServer', @level2type=N'COLUMN', @level2name=N'Addtime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'加密更新时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_DownServer', @level2type=N'COLUMN', @level2name=N'Encryptime'

GO
CREATE TABLE [dbo].[ZL_Survey](
[Surveyid] [int] IDENTITY(1,1) NOT NULL,
[Surveyname] [nvarchar](255) NOT NULL,
[Description] [text] NULL,
[Createdate] [datetime] NULL CONSTRAINT [DF_ZL_Survey_Createdate]  DEFAULT (getdate()),
[Endtime] [datetime] NULL CONSTRAINT [DF_ZL_Survey_Endtime]  DEFAULT (getdate()),
[Isopen] [bit] NULL CONSTRAINT [DF_ZL_Survey_Isopen]  DEFAULT ((1)),
[NeedLogin] [bit] NULL CONSTRAINT [DF_ZL_Survey_NeedLogin]  DEFAULT ((0)),
[Surtype] [int] NULL CONSTRAINT [DF_ZL_Survey_Surtype]  DEFAULT ((1)),
[Iprepeat] [int] NULL CONSTRAINT [DF_ZL_Survey_Iprepeat]  DEFAULT ((1)),
[StartTime] [datetime] NULL CONSTRAINT [DF_ZL_Survey_StartTime]  DEFAULT (getdate()),
[IsStatus] [bit] NULL CONSTRAINT [DF_ZL_Survey_IsStatus]  DEFAULT ((0)), 
[IsCheck] [bit] NULL CONSTRAINT [DF_ZL_Survey_IsCheck]  DEFAULT ((0)),
[IsShow] [int] Null

CONSTRAINT [PK_ZL_Survey] PRIMARY KEY CLUSTERED 
(
[Surveyid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Trademark](
[ID] [int] IDENTITY(1,1) NOT NULL,
[Trname] [varchar](255) NULL,
[Producer] [int] NULL,
[TrClass] [varchar](50) NULL,
[Isuse] [int] NULL CONSTRAINT [DF_ZL_Trademark_Isuse]  DEFAULT (0),
[Istop] [int] NULL CONSTRAINT [DF_ZL_Trademark_Istop]  DEFAULT (0),
[Isbest] [int] NULL CONSTRAINT [DF_ZL_Trademark_Isbest]  DEFAULT (0),
[TrPhoto] [varchar](50) NULL,
[TrContent] [text] NULL,
[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_Trademark_Addtime]  DEFAULT (getdate()),
CONSTRAINT [PK_ZL_Trademark] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_ExChange](
[C_ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NULL,
[PUserID] [int] NULL,
[Talk] [int] NULL CONSTRAINT [DF_ZL_ExChange_Talk]  DEFAULT (1),
[UserChange] [int] NULL CONSTRAINT [DF_ZL_ExChange_UserChange]  DEFAULT (0),
[PUserChange] [int] NULL CONSTRAINT [DF_ZL_ExChange_PUserChange]  DEFAULT (0),
[EState] [int] NULL CONSTRAINT [DF_ZL_ExChange_EState]  DEFAULT (0),
[UserPost] [int] NULL CONSTRAINT [DF_ZL_ExChange_UserPost]  DEFAULT (0),
[PUserPost] [int] NULL CONSTRAINT [DF_ZL_ExChange_PUserPost]  DEFAULT (0),
[UserLock] [int] NULL CONSTRAINT [DF_ZL_ExChange_UserLock]  DEFAULT (0),
[PUserLock] [int] NULL CONSTRAINT [DF_ZL_ExChange_PUserLock]  DEFAULT (0),
CONSTRAINT [PK_ZL_ExChange] PRIMARY KEY CLUSTERED 
(
[C_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'申请USERID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'UserID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'被交换USERID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'PUserID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'交谈是否可见0不可见，1可见' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'Talk'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'申请交换状态1同意，0不同意' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'UserChange'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'被申请方交换状态1同意，0不同意' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'PUserChange'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最终状态1交换成功0交换不成功' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'EState'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否邮寄0没邮寄，1邮寄' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'UserPost'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否邮寄0没邮寄，1邮寄' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'PUserPost'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'申请者锁定' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'UserLock'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'被申请者锁定' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ExChange', @level2type=N'COLUMN', @level2name=N'PUserLock'

GO
CREATE TABLE [dbo].[ZL_User] (
[UserID] [int]  IDENTITY (1, 1)  NOT NULL,
[UserName] [nvarchar]  (255) NOT NULL,
[UserPwd] [nvarchar]  (200) NOT NULL,
[PayPassWord] [nvarchar]  (200) NULL,
[GroupID] [int]  NOT NULL DEFAULT (0),
[Email] [nvarchar]  (50) NOT NULL,
[Question] [nvarchar]  (255) NOT NULL,
[Answer] [nvarchar]  (255) NOT NULL,
[RegTime] [datetime]  NULL DEFAULT (getdate()),
[LoginTimes] [int]  NULL DEFAULT (0),
[LastLoginTime] [datetime]  NULL DEFAULT (getdate()),
[LastLoginIP] [nvarchar]  (50) NULL,
[LastPwdChangeTime] [datetime]  NULL DEFAULT (getdate()),
[LastLockTime] [datetime]  NULL DEFAULT (getdate()),
[Status] [int]  NULL DEFAULT (0),
[CheckNum] [nvarchar]  (50) NULL,
[Purse]      [money]  NULL,
[SilverCoin] [money]  NULL DEFAULT (0),
[UserExp]    [money]  NULL DEFAULT (0),
[UserPoint]  [money]  NULL DEFAULT (0),
[DummyPurse] [money]  NULL DEFAULT (0),
[boffExp]    [int]  NULL DEFAULT (0),
[ConsumeExp] [int]  NULL DEFAULT (0),
[GuestScore] [int]  NULL DEFAULT (0),
[DeadLine]   [datetime]  NULL,
[JoinTime]   [datetime]  NULL DEFAULT (getdate()),
[Permissions] [ntext]  NULL,
[SiteID] [int]  NULL DEFAULT (0),
[Remark] [ntext]  NULL,
[CompanyName] [nvarchar]  (255) NULL,
[CompanyDescribe] [nvarchar]  (500) NULL,
[NHouseID] [int]  NULL,
[IsConfirm] [int]  NULL,
[VIP] [int]  NULL DEFAULT (0),
[salt] [nvarchar]  (500) NULL,
[State] [varchar]  (50) NULL,
[CerificateLogo] [nvarchar]  (100) NULL,
[ApproveType] [varchar]  (50) NULL,
[RegisterIP] [varchar]  (50) NULL,
[CerificateDeadLine] [datetime]  NULL DEFAULT (getdate()),
[RebatesBalance] [money]  NULL,
[PageId] [int]  NULL DEFAULT (0),
[SiteRebateBalance] [money]  NULL DEFAULT (0),
[UserCreit] [int]  NULL DEFAULT (0),
[UpdateTime] [datetime]  NULL,
[NewBlogTime] [datetime]  NULL,
[RoomID] [int]  NULL,
[ParentUserID] [varchar]  (4000) NULL,
[IsAdd2K3] [int]  NULL,
[IsCloud] [int]  NULL DEFAULT (0),
[seturl] [ntext]  NULL,
[StructureID] [nvarchar]  (255) NULL,
[UserRole] [nvarchar]  (255) NULL,
[WorkNum] [nvarchar]  (255) NULL,
[MailSize] [int]  NULL,
[LastActiveTime] [datetime]  NULL,
[ZnPassword] [nvarchar]  (100) NULL,
[HoneyName] [nvarchar]  (100) NULL)

ALTER TABLE [dbo].[ZL_User] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_User] PRIMARY KEY  NONCLUSTERED ( [UserID] )

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'UserID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'UserName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员密码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'UserPwd'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员组' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'GroupID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Email'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员提示问题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Question'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员提示问题答案' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Answer'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'注册时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'RegTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'登录次数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'LoginTimes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最近登录时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'LastLoginTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后登录IP' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'LastLoginIP'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'上次修改密码的时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'LastPwdChangeTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'上次被锁定的时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'LastLockTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户状态。0－－正常，1－－锁定，2－－未通过邮件验证，4－－未通过管理员认证' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Status'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'验证码。用于邮件验证' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'CheckNum'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员积分' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'UserExp'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'卖家积分' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'boffExp'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'消费积分' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'ConsumeExp'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'钱包' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Purse'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'有效期截止时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'DeadLine'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'点券' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'UserPoint'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'加入会员组时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'JoinTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'抢车位虚拟币' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'DummyPurse'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'权限。当该字段为空，使用GroupID的用户组ID。' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Permissions'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'子站ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'SiteID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'Remark'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'证书认证状态(-----[未认证] -----[证书审核中]-----[认证通过])' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'State'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'证书地址' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'CerificateLogo'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'认证类型(国际认证，三包认证.)' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'ApproveType'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商铺认证有效期截止时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'CerificateDeadLine'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'黄页ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_User', @level2type=N'COLUMN',@level2name=N'PageId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'返利余额' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_User', @level2type=N'COLUMN', @level2name=N'RebatesBalance'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分站返利金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_User', @level2type=N'COLUMN',@level2name=N'SiteRebateBalance'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户信誉值' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_User', @level2type=N'COLUMN',@level2name=N'UserCreit'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'打卡时间,修改时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_User', @level2type=N'COLUMN',@level2name=N'UpdateTime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'组织结构ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_User', @level2type=N'COLUMN',@level2name=N'StructureID'

GO
CREATE TABLE [dbo].[ZL_User_Consume](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[PUserID] [int] NULL,
	[MType] [int] NULL,
	[AMount] [money] NULL,
	[CDate] [datetime] NULL,
	[UnitPercent] [nvarchar](50) NULL,
	[UnitAmount] [money] NULL,
	[State] [int] NULL,
	[Remind] [nvarchar](200) NULL,
	[Detail] [nvarchar](200) NULL,
	[BindID] [int] NULL,
 CONSTRAINT [PK_ZL_User_Consume] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[ZL_User_UnitWeek](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Flow] [nvarchar](100) NULL,
	[AMount] [money] NULL,
	[ChildAMount] [money] NULL,
	[ChildIDS] [varchar](8000) NULL,
	[RealUnit] [money] NULL,
	[RealUnit0] [money] NULL,
	[RealUnit10] [money] NULL,
	[RealUnit20] [money] NULL,
	[RealUnit30] [money] NULL,
	[UserID] [int] NULL,
	[PUserID] [int] NULL,
	[CDate] [datetime] NULL,
	[Remind] [nvarchar](200) NULL,
	[State] [int] NULL,
	[LogID] [int] NULL,
	[MyStatus] [int] NULL,
 CONSTRAINT [PK_ZL_User_UnitWeek] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Examinee](
[EID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NOT NULL,
[CompanyID] [int] NOT NULL,
[SendTime] [datetime] NOT NULL CONSTRAINT [DF_ZL_Examinee_SendTime]  DEFAULT (getdate()),
CONSTRAINT [PK_ZL_Examinee] PRIMARY KEY CLUSTERED 
(
[EID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'应试通知ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Examinee', @level2type=N'COLUMN', @level2name=N'EID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'通知接收人ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Examinee', @level2type=N'COLUMN', @level2name=N'UserID'

GO
CREATE TABLE [dbo].[ZL_Favorite](
	[FavoriteID] [int] IDENTITY(1,1) NOT NULL,
	[Owner] [int] NOT NULL,
	[InfoID] [int] NOT NULL,
	[FavoriteDate] [datetime] NOT NULL,
	[FavoriType] [int] NULL,
	[FavUrl] [nvarchar](500) NULL,
	[FavItemID] [nvarchar](50) NULL,
	[Title] [nvarchar](500) NULL
) ON [PRIMARY]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'FavoriteID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏人ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'Owner'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'被收藏内容的ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'InfoID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'FavoriteDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏类型：1为内容收藏,2为商品收藏,3为网店收藏' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'FavoriType'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏URl' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'FavUrl'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏相关内容ID(多个ID以逗号隔开)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Favorite', @level2type=N'COLUMN',@level2name=N'FavItemID'
GO

ALTER TABLE [dbo].[ZL_Favorite] ADD  CONSTRAINT [DF_ZL_Favorite_FavoriteDate]  DEFAULT (getdate()) FOR [FavoriteDate]
GO
CREATE TABLE [dbo].[ZL_UserBase](
[UserID] [int] NOT NULL,
[TrueName] [nvarchar](50) NULL,
[BirthDay] [nvarchar](20) NULL,
[shengxiao] [nvarchar](50) NULL,
[xingzuo] [nvarchar](50) NULL,
[Address] [nvarchar](255) NULL,
[OfficePhone] [nvarchar](50) NULL,
[HomePhone] [nvarchar](50) NULL,
[Fax] [nvarchar](50) NULL,
[ZipCode] [nvarchar](10) NULL,
[PHS] [nvarchar](50) NULL,
[Mobile] [nvarchar](50) NULL,
[UserSex] [bit] NULL CONSTRAINT [DF_ZL_UserBase_UserSex]  DEFAULT (1),
[QQ] [nvarchar](50) NULL,
[MSN] [nvarchar](255) NULL,
[ICQ] [nvarchar](50) NULL,
[UC] [nvarchar](50) NULL,
[Yahoo] [nvarchar](50) NULL,
[IDCard] [nvarchar](50) NULL,
[HomePage] [nvarchar](255) NULL,
[UserFace] [nvarchar](255) NULL,
[FaceWidth] [int] NULL CONSTRAINT [DF_ZL_UserBase_FaceWidth]  DEFAULT (16),
[FaceHeight] [int] NULL CONSTRAINT [DF_ZL_UserBase_FaceHeight]  DEFAULT (16),
[Sign] [nvarchar](1000) NULL,
[Country] [nvarchar](50) NULL,
[Province] [nvarchar](50) NULL,
[City] [nvarchar](50) NULL,
[County] [nvarchar](50) NULL,
[Privacy] [int] NULL CONSTRAINT [DF_ZL_UserBase_Privating]  DEFAULT (0),
[cardType] [nvarchar] (255) NULL ,
[honeyName] [nvarchar] (255)NULL,
[workProvince] [nvarchar](50) NULL,
[workCity] [nvarchar](50) NULL, 
[Bugle] [int] default(0) NULL,
[SFStatus] [int] NULL,
[VIPUser][int] NULL CONSTRAINT [DF_ZL_UserBase_VIPUser]  DEFAULT (0),
[Position] [nvarchar](50) NULL,
[Corp] [nvarchar](50) NULL,
CONSTRAINT [PK_ZL_UserBase] PRIMARY KEY CLUSTERED 
(
[UserID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'真实姓名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'TrueName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'生日' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'BirthDay'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'生肖' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'shengxiao'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'星座' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'xingzuo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'联系地址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Address'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'办公电话' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'OfficePhone'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'家庭电话' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'HomePhone'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'传真号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Fax'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'邮编' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'ZipCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'小灵通' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'PHS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'手机号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Mobile'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'性别' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'UserSex'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'QQ号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'QQ'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'MSN号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'MSN'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ICQ号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'ICQ'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UC号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'UC'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'雅虎通账号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Yahoo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'身份证号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'IDCard'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'个人主页' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'HomePage'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'头像地址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'UserFace'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'头像宽度' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'FaceWidth'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'头像高度' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'FaceHeight'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'签名档' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Sign'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'国家' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Country'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'省' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Province'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'市' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'City'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'县' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'County'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'隐私设定' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Privacy'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'证件类型' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'cardType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'昵称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'honeyName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'工作地址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'workProvince'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'工作城市' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'workCity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'多人视频小喇叭' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Bugle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'征友状态' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'SFStatus'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'VIP会员' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'VIPUser'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'公司职务' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Position'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'公司名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserBase', @level2type=N'COLUMN',@level2name=N'Corp'
GO


CREATE TABLE [dbo].[ZL_Flow](
[ID] [int] IDENTITY(1,1) NOT NULL,
[flowName] [varchar](50) NOT NULL,
[flowDepict] [varchar](50) NOT NULL,
CONSTRAINT [PK_ZL_Flow] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'主键编号自动增长列' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Flow', @level2type=N'COLUMN', @level2name=N'id'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'流程名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Flow', @level2type=N'COLUMN', @level2name=N'flowName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'流程描述' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Flow', @level2type=N'COLUMN', @level2name=N'flowDepict'
GO
SET IDENTITY_INSERT [ZL_Flow] ON
INSERT [ZL_Flow] ([ID],[flowName],[flowDepict]) VALUES ( 1,N'三级审核流程',N'文章需要经过不同角色的管理员审核后,才能在前台看到')
SET IDENTITY_INSERT [ZL_Flow] OFF

GO
CREATE TABLE [dbo].[ZL_UserBaseField](
[FieldID] [int] IDENTITY(1,1) NOT NULL,
[FieldName] [nvarchar](50) NOT NULL,
[FieldAlias] [nvarchar](50) NOT NULL,
[FieldTips] [nvarchar](50) NULL,
[Description] [nvarchar](255) NULL,
[IsNotNull] [bit] NULL CONSTRAINT [DF_ZL_UserBaseField_IsNotNull]  DEFAULT (0),
[FieldType] [nvarchar](50) NOT NULL,
[Content] [ntext] NULL,
[OrderId] [int] NULL CONSTRAINT [DF_ZL_UserBaseField_OrderId]  DEFAULT (1),
[ShowList] [bit] NULL,
[ShowWidth] [int] NULL CONSTRAINT [DF_ZL_UserBaseField_ShowWidth]  DEFAULT (0),
[NoEdit] [int] NULL CONSTRAINT [DF_ZL_UserBaseField_NoEdit]  DEFAULT (0),
CONSTRAINT [PK_ZL_UserBaseField] PRIMARY KEY NONCLUSTERED 
(
[FieldID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'FieldName'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段别名' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'FieldAlias'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段说明' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'FieldTips'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段描述' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'Description'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段允许空，1：允许，2：不允许' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'IsNotNull'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段类型' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'FieldType'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段内容' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'Content'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'OrderId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'列表显示。1：显示，2不显示' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'ShowList'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'显示列宽度' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'ShowWidth'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否允许编辑' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserBaseField', @level2type=N'COLUMN', @level2name=N'NoEdit'

GO
CREATE TABLE [dbo].[ZL_Grade](
[GradeID] [int] IDENTITY(1,1) NOT NULL,
[Cate] [int] NOT NULL,
[ParentID] [int] NOT NULL CONSTRAINT [DF_ZL_Grade_ParentID]  DEFAULT (0),
[GradeName] [nvarchar](50) NOT NULL,
[Grade] [int] NOT NULL CONSTRAINT [DF_ZL_Grade_Grade]  DEFAULT (0),
CONSTRAINT [PK_ZL_Grade] PRIMARY KEY CLUSTERED 
(
[GradeID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'数据ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Grade', @level2type=N'COLUMN', @level2name=N'GradeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分类ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Grade', @level2type=N'COLUMN', @level2name=N'Cate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'父选项ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Grade', @level2type=N'COLUMN', @level2name=N'ParentID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分级选项名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Grade', @level2type=N'COLUMN', @level2name=N'GradeName'

GO

CREATE TABLE [dbo].[ZL_GradeCate](
[CateID] [int] IDENTITY(1,1) NOT NULL,
[CateName] [nvarchar](50) NOT NULL,
[Remark] [nvarchar](255) NULL CONSTRAINT [DF_ZL_GradeCate_Remark]  DEFAULT (''),
[GradeField] [nvarchar](500) NOT NULL,
CONSTRAINT [PK_ZL_GradeCate] PRIMARY KEY CLUSTERED 
(
[CateID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[ZL_Group](
[GroupID] [int] IDENTITY(1,1) NOT NULL,
[GroupName] [nvarchar](50) NOT NULL,
[OtherName] [nvarchar](255) NULL,
[Description] [nvarchar](255) NULL,
[RegSelect] [bit] NULL CONSTRAINT [DF_ZL_UserGroup_RegSelect]  DEFAULT (0),
[IsDefault] [bit] NULL CONSTRAINT [DF__ZL_Group__IsDefa__3ACC9741]  DEFAULT (0),
[CCountPerDay] [int] NULL CONSTRAINT [DF__ZL_Group__CCount__3BC0BB7A]  DEFAULT (0),
[FavCount] [int] NULL CONSTRAINT [DF__ZL_Group__FavCou__3CB4DFB3]  DEFAULT (0),
[ConsumeType] [int] NULL CONSTRAINT [DF__ZL_Group__Consum__3DA903EC]  DEFAULT (0),
[UpGradeMoney] [money]NULL,
[UpSIcon] [money]NULL,
[UpPoint] [money]NULL,
[CompanyGroup] [int] NULL CONSTRAINT [DF__ZL_Group__CompanyGroup]  DEFAULT (0),
[VIPNum] [int] NULL CONSTRAINT [DF__ZL_Group__VIPNum]  DEFAULT (0), 
[VIPGroup] [int] NULL CONSTRAINT [DF__ZL_Group__VIPGroup]  DEFAULT (0),
[RebateRate] [float] NULL,
[Credit] [int] NULL,
[Enroll] [varchar](500) NULL,
[ParentGroupID] [int] NULL,
[SignImg] [nvarchar](200) NULL
CONSTRAINT [PK_ZL_UserGroup] PRIMARY KEY CLUSTERED 
(
[GroupID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户组ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'GroupID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户组名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'GroupName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'别名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'OtherName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'Description'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户注册时是否可选' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'RegSelect'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否默认会员组' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'IsDefault'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'升级所需费用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'UpGradeMoney'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否为企业用组：0-否 1-是' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'CompanyGroup'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'VIP级数：0-否 1-是' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'VIPNum'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否为VIP用组：0-否 1-是' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'VIPGroup'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'每天可发布内容数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'CCountPerDay'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'收藏夹设置' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'FavCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ConsumeType' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Group', @level2type=N'COLUMN', @level2name=N'ConsumeType'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'返利比率' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Group', @level2type=N'COLUMN',@level2name=N'RebateRate'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'信誉值' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Group', @level2type=N'COLUMN',@level2name=N'Credit'

GO
CREATE TABLE [dbo].[ZL_UserExpDomP](
[ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NOT NULL CONSTRAINT [DF_ZL_UserExpDomP_UserID]  DEFAULT (null),
[Score] [money] NOT NULL CONSTRAINT [DF_ZL_UserExpDomP_Score]  DEFAULT (0),
[HisTime] [datetime] NULL CONSTRAINT [DF_ZL_UserExpDomP_HisTime]  DEFAULT (getdate()),
[Operator] [int] NULL,
[Detail] [nvarchar](1000) NULL,
[OperatorIP] [nvarchar](200) NULL,
CONSTRAINT [PK_ZL_UserExpDomP] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserExpDomP', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'金额变化数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserExpDomP', @level2type=N'COLUMN', @level2name=N'Score'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'变更时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserExpDomP', @level2type=N'COLUMN', @level2name=N'HisTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'操作人ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserExpDomP', @level2type=N'COLUMN', @level2name=N'Operator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'详细备注' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserExpDomP', @level2type=N'COLUMN', @level2name=N'Detail'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'操作IP' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserExpDomP', @level2type=N'COLUMN', @level2name=N'OperatorIP'

GO

CREATE TABLE [dbo].[ZL_GroupFieldPermissions](
[ID] [int] IDENTITY(1,1) NOT NULL,
[GroupID] [int] NOT NULL,
[OperateCode] [int] NOT NULL CONSTRAINT [DF_ZL_GroupFieldPermissions_OperateCode]  DEFAULT (0),
[ProjectID] [int] NOT NULL,
[FieldID] [int] NOT NULL,
[FieldName] [nvarchar](255) NOT NULL,
[IdType] [int] NOT NULL,
CONSTRAINT [PK_ZL_GroupFieldPermissions] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员组ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_GroupFieldPermissions', @level2type=N'COLUMN', @level2name=N'GroupID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'权限操作码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_GroupFieldPermissions', @level2type=N'COLUMN', @level2name=N'OperateCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_GroupFieldPermissions', @level2type=N'COLUMN', @level2name=N'ProjectID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_GroupFieldPermissions', @level2type=N'COLUMN', @level2name=N'FieldID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目字段名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_GroupFieldPermissions', @level2type=N'COLUMN', @level2name=N'FieldName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ID类型 0 用户 1 用户组' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_GroupFieldPermissions', @level2type=N'COLUMN', @level2name=N'IdType'

GO
CREATE TABLE [dbo].[ZL_UserExpHis](
[ExpHisID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NOT NULL,
[score] [money] NOT NULL CONSTRAINT [DF_ZL_UserExpHis_score]  DEFAULT (0),
[HisTime] [datetime] NULL CONSTRAINT [DF_ZL_UserExpHis_HisTime]  DEFAULT (getdate()),
[Operator] [int] NULL,
[Detail] [nvarchar](1000) NULL,
[OperatorIP] [nvarchar](200) NULL,
[ScoreType] [int] Null,
[Remark] [nvarchar](200) NULL
CONSTRAINT [PK_ZL_UserExpHis] PRIMARY KEY CLUSTERED 
(
[ExpHisID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_UserFave](
[ID] [int] IDENTITY(1,1) NOT NULL,
[Userid] [int] NULL,
[UserLookId] [int] NULL,
[DataTime] [datetime] NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_GroupModel](
[GroupID] [int] NOT NULL,
[UserModel] [int] NOT NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_UserFriendGroup](
[ID] [int] IDENTITY(1,1) NOT NULL,
[UserID] [int] NULL,
[GroupName] [varchar](50) NULL,
[BlackGroup] [int] NULL,
[OrderID] [int] NULL,
CONSTRAINT [PK_ZL_UserFriendGroup] PRIMARY KEY NONCLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendGroup', @level2type=N'COLUMN', @level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendGroup', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分组名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendGroup', @level2type=N'COLUMN', @level2name=N'GroupName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否是黑名单(1为黑名单)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendGroup', @level2type=N'COLUMN', @level2name=N'BlackGroup'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendGroup', @level2type=N'COLUMN', @level2name=N'OrderID'

GO
CREATE TABLE [dbo].[ZL_Guestbook](
[Gid] [int] IDENTITY(1,1) NOT NULL,
[Parentid] [int] NOT NULL,
[Cateid] [int] NOT NULL,
[Userid] [int] NOT NULL,
[Title] [varchar](200) NULL,
[Tcontent] [text] NOT NULL,
[Gdate] [datetime] NULL,
[Status] [int] NOT NULL,
[IP] [nvarchar](50) NULL,
CONSTRAINT [PK_ZL_GUESTBOOK] PRIMARY KEY CLUSTERED 
(
[Gid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
ALTER TABLE [dbo].[ZL_Guestbook] ADD  CONSTRAINT [DF_ZL_GUESTBOOK_PARENTID]  DEFAULT ((0)) FOR [Parentid]
GO
ALTER TABLE [dbo].[ZL_Guestbook] ADD  CONSTRAINT [DF_ZL_GUESTBOOK_GDATE]  DEFAULT (getdate()) FOR [Gdate]

GO
CREATE TABLE [dbo].[ZL_UserFriendTable](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[FriendID] [int] NULL,
	[GroupID] [int] NULL,
	[Addtime] [datetime] NULL,
	[FriendState] [int] NULL,
	[IsReader] [int] NULL,
 CONSTRAINT [PK_ZL_UserFriendTable] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'好友ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'FriendID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属分组ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'GroupID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'Addtime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'好友状态(0为关注 1为互为好友)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'FriendState'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否已读' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserFriendTable', @level2type=N'COLUMN', @level2name=N'IsReader'

GO
CREATE TABLE [dbo].[ZL_Guestcate](
[Cateid] [int] IDENTITY(1,1) NOT NULL,
[Catename] [varchar](255) NOT NULL,
[GType] [int] NULL,
[ParentID] [int] NOT NULL,
[Permibit] [varchar](255) NULL,
[NeedLog] [int] NULL,
[PostAuth] [int] NULL,
[BarImage] [nvarchar](255) NULL,
[Desc] [nvarchar](500) NULL,
[BarInfo] [nvarchar](255) NULL,
[OrderID] [int] NULL,
[BarOwner] [varchar](500) NULL,
[Status] [int] NULL,
[SendScore] [int] NULL,
[ReplyScore] [int] NULL,
[ZipImgSize] [int] NULL,
[IsPlat] [int] NULL,
CONSTRAINT [PK_ZL_Guestcate] PRIMARY KEY NONCLUSTERED 
(
[Cateid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ZL_Guestcate] ADD  CONSTRAINT [DF__ZL_Guestc__Paren__3CF40B7E]  DEFAULT ((0)) FOR [ParentID]
GO
ALTER TABLE [dbo].[ZL_Guestcate] ADD  CONSTRAINT [DF__ZL_Guestc__Permi__3DE82FB7]  DEFAULT ('') FOR [Permibit]
GO
ALTER TABLE [dbo].[ZL_Guestcate] ADD  CONSTRAINT [DF_ZL_Guestcate_Status]  DEFAULT ((1)) FOR [Status]
GO


CREATE TABLE [dbo].[ZL_Interlocution](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[ProblemTitle] [nvarchar](1000) NULL,
	[ProblemContext] [varchar](2000) NULL,
	[AddTime] [datetime] NULL,
	[RoomID] [int] NULL,
 CONSTRAINT [PK_ZL_Interlocution] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Interlocution', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'问题标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Interlocution', @level2type=N'COLUMN', @level2name=N'ProblemTitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'问题内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Interlocution', @level2type=N'COLUMN', @level2name=N'ProblemContext'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'提问时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Interlocution', @level2type=N'COLUMN', @level2name=N'AddTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'班级ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Interlocution', @level2type=N'COLUMN', @level2name=N'RoomID'


GO
CREATE TABLE [dbo].[ZL_UserShop](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[Class] [int] NULL CONSTRAINT [DF_ZL_UserShop_Class]  DEFAULT (0),
	[Nodeid] [int] NULL CONSTRAINT [DF_ZL_UserShop_Nodeid]  DEFAULT (0),
	[ModelID] [int] NULL,
	[Categoryid] [int] NULL CONSTRAINT [DF_ZL_UserShop_Categoryid]  DEFAULT (0),
	[ProCode] [varchar](50) NULL,
	[BarCode] [varchar](50) NULL,
	[Proname] [varchar](255) NULL,
	[Kayword] [varchar](255) NULL,
	[ProUnit] [varchar](50) NULL,
	[Weight] [int] NULL CONSTRAINT [DF_ZL_UserShop_Weight]  DEFAULT (0),
	[ServerPeriod] [int] NULL CONSTRAINT [DF_ZL_UserShop_ServerPeriod]  DEFAULT (0),
	[ServerType] [int] NULL CONSTRAINT [DF_ZL_UserShop_ServerType]  DEFAULT (0),
	[ProClass] [int] NULL CONSTRAINT [DF_ZL_UserShop_ProClass]  DEFAULT (0),
	[Properties] [int] NULL CONSTRAINT [DF_ZL_UserShop_Properties]  DEFAULT (0),
	[Sales] [int] NULL CONSTRAINT [DF_ZL_UserShop_Sales]  DEFAULT (0),
	[Proinfo] [text] NULL,
	[Procontent] [text] NULL,
	[Clearimg] [varchar](255) NULL,
	[Thumbnails] [varchar](255) NULL,
	[Producer] [varchar](255) NULL,
	[Brand] [varchar](50) NULL,
	[Allowed] [int] NULL CONSTRAINT [DF_ZL_UserShop_Allowed]  DEFAULT (0),
	[Quota] [int] NULL CONSTRAINT [DF_ZL_UserShop_Quota]  DEFAULT (0),
	[DownQuota] [int] NULL CONSTRAINT [DF_ZL_UserShop_DownQuota]  DEFAULT (0),
	[Stock] [int] NULL CONSTRAINT [DF_ZL_UserShop_Stock]  DEFAULT (0),
	[StockDown] [int] NULL CONSTRAINT [DF_ZL_UserShop_StockDown]  DEFAULT (0),
	[JisuanFs] [int] NULL CONSTRAINT [DF_ZL_UserShop_JisuanFs]  DEFAULT (0),
	[Rate] [money] NULL CONSTRAINT [DF_ZL_UserShop_Rate]  DEFAULT (0),
	[Rateset] [int] NULL,
	[Dengji] [int] NULL CONSTRAINT [DF_ZL_UserShop_Dengji]  DEFAULT (0),
	[ShiPrice] [money] NULL CONSTRAINT [DF_ZL_UserShop_ShiPrice]  DEFAULT (0),
	[LinPrice] [money] NULL CONSTRAINT [DF_ZL_UserShop_LinPrice]  DEFAULT (0),
	[MemberPrice] [varchar](255) NULL CONSTRAINT [DF_ZL_UserShop_MemberPrice]  DEFAULT (0 | 0),
	[ActPrice] [varchar](255) NULL CONSTRAINT [DF_ZL_UserShop_ActPrice]  DEFAULT (0 | 0),
	[Wholesales] [int] NULL CONSTRAINT [DF_ZL_UserShop_Wholesales]  DEFAULT (0),
	[Wholesaleone] [int] NULL CONSTRAINT [DF_ZL_UserShop_Wholesaleone]  DEFAULT (0),
	[Wholesalesinfo] [varchar](255) NULL CONSTRAINT [DF_ZL_UserShop_Wholesalesinfo]  DEFAULT ('0|0,0|0,0|0'),
	[Preset] [varchar](255) NULL CONSTRAINT [DF_ZL_UserShop_Preset]  DEFAULT ('0|0|0|{}'),
	[Integral] [int] NULL CONSTRAINT [DF_ZL_UserShop_Integral]  DEFAULT (0),
	[Propeid] [int] NULL CONSTRAINT [DF_ZL_UserShop_Propeid]  DEFAULT (0),
	[Recommend] [int] NULL CONSTRAINT [DF_ZL_UserShop_Recommend]  DEFAULT (0),
	[Priority] [int] NULL CONSTRAINT [DF_ZL_UserShop_Priority]  DEFAULT (0),
	[MonthClickNum] [int] NULL CONSTRAINT [DF_ZL_UserShop_MonthClickNum]  DEFAULT (0),
	[UpdateTime] [datetime] NULL CONSTRAINT [DF_ZL_UserShop_UpdateTime]  DEFAULT (getdate()),
	[ModeTemplate] [varchar](255) NULL,
	[AddUser] [varchar](50) NULL,
	[DownCar] [int] NULL CONSTRAINT [DF_ZL_UserShop_DownCar]  DEFAULT (0),
	[AddTime] [datetime] NULL CONSTRAINT [DF_ZL_UserShop_AddTime]  DEFAULT (getdate()),
	[TableName] [varchar](50) NULL,
	[Istrue] [int] NULL CONSTRAINT [DF_ZL_UserShop_Istrue]  DEFAULT (0),
	[Isgood] [int] NULL CONSTRAINT [DF_ZL_UserShop_Isgood]  DEFAULT (0),
	[MakeHtml] [int] NULL CONSTRAINT [DF_ZL_UserShop_MakeHtml]  DEFAULT (0),
	[Sold] [int] NULL CONSTRAINT [DF_ZL_UserShop_Sold]  DEFAULT (0),
	[isnew] [int] NULL CONSTRAINT [DF_ZL_UserShop_isnew]  DEFAULT (0),
	[ishot] [int] NULL CONSTRAINT [DF_ZL_UserShop_ishot]  DEFAULT (0),
	[isbest] [int] NULL CONSTRAINT [DF_ZL_UserShop_isbest]  DEFAULT (0),
	[ItemID] [int] NULL,
	[ComModelID] [int] NULL,
	[AllClickNum] [int] NULL CONSTRAINT [DF_ZL_UserShop_AllClickNum]  DEFAULT (0),
	[Colonel] [int] NULL CONSTRAINT [DF_ZL_UserShop_Colonel]  DEFAULT (0),
	[ColonelNum] [int] NULL CONSTRAINT [DF_ZL_UserShop_ColonelNum]  DEFAULT (0),
	[ColonelMoney] [money] NULL CONSTRAINT [DF_ZL_UserShop_ColonelMoney]  DEFAULT (0),
	[ColonelNowNum] [int] NULL,
	[ColoneState] [int] NULL,
	[ColonelTime] [datetime] NULL,
	[CautionMoney] [money] NULL,
	[DeliverMoney] [ntext] NULL,
	[OnCalonelTime] [int] NULL CONSTRAINT [DF_ZL_UserShop_OnCalonelTime]  DEFAULT (0),
	[OnCalonelUser] [int] NULL CONSTRAINT [DF_ZL_UserShop_OnCalonelUser]  DEFAULT (0),
	[OnCalonelMoney] [int] NULL CONSTRAINT [DF_ZL_UserShop_OnCalonelMoney]  DEFAULT (0),
	[Isreach] [int] NULL CONSTRAINT [DF_ZL_UserShop_Isreach]  DEFAULT (0),
	[Ismarked] [int] NULL CONSTRAINT [DF_ZL_UserShop_Ismarked]  DEFAULT (0),
	[Isprefer] [int] NULL CONSTRAINT [DF_ZL_UserShop_Isprefer]  DEFAULT (0),
	[UserClass] [int] NULL,
	[UserProductID] [int] NULL,
	[BookPrice] [money] NULL,
	[bookDay] [int] NULL,
	[UserType] [int] NULL,
	[UserPrice] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FestlPrice] [money] NULL,
	[FestPeriod] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[FarePrice] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FareType] [int] NULL,
	[PointVal] [int] NULL,
	[LinPrice_Json] [nvarchar](500) NULL,
	[ParentID] [int] NULL
 CONSTRAINT [PK_ZL_UserShop] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1-团购 2-竟拍' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'Colonel'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'团购数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'ColonelNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'团购价格 竟拍起始价格' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'ColonelMoney'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'当前团购数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'ColonelNowNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'团购竞拍状态 1：开始，2：团购成立，3：结束' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'ColoneState'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'终止时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'ColonelTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'设置竞拍，团购的保证金' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'CautionMoney'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'送货价格' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'DeliverMoney'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'达到发起时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'OnCalonelTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'达到参与人数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'OnCalonelUser'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'达到竞价价格' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'OnCalonelMoney'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'二手闲置' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'Isreach'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'一口价' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'Ismarked'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'优惠' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'Isprefer'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户分类' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserShop', @level2type=N'COLUMN', @level2name=N'UserClass'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'标准商品ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'UserProductID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'预订价' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'BookPrice'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'比节日时间提前多少天为预订价' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'bookDay'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'计价类型：0为会员价,1为按会员组打折' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'UserType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'如果按会员组打折,格式为:会员组ID|价格' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'UserPrice'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'节日价格' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'FestlPrice'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'节日期间:某段时间内为节日价，格式开始时间|结束时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserShop', @level2type=N'COLUMN',@level2name=N'FestPeriod'

GO
CREATE TABLE [dbo].[ZL_UserStock](
[ID] [int] IDENTITY(1,1) NOT NULL,
[stocktype] [int] NULL,
[danju] [varchar](50) NULL,
[proname] [varchar](50) NULL,
[addtime] [datetime] NULL,
[adduser] [varchar](50) NULL,
[content] [ntext] NULL,
[proid] [int] NULL,
[pronum] [int] NULL,
CONSTRAINT [PK_ZL_UserStock] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
ALTER TABLE [dbo].[ZL_UserStock] ADD  CONSTRAINT [DF_ZL_UserStock_stocktype]  DEFAULT ((0)) FOR [stocktype]
GO

ALTER TABLE [dbo].[ZL_UserStock] ADD  CONSTRAINT [DF_ZL_UserStock_addtime]  DEFAULT (getdate()) FOR [addtime]
GO

ALTER TABLE [dbo].[ZL_UserStock] ADD  CONSTRAINT [DF_ZL_UserStock_pronum]  DEFAULT ((0)) FOR [pronum]

GO
CREATE TABLE [dbo].[ZL_Keywords](
	[KeywordID] [int] IDENTITY(1,1) NOT NULL,
	[KeywordText] [nvarchar](200) NOT NULL,
	[KeywordType] [int] NOT NULL,
	[Priority] [int] NOT NULL CONSTRAINT [DF_ZL_Keywords_Priority]  DEFAULT (0),
	[Hits] [int] NOT NULL CONSTRAINT [DF_ZL_Keywords_Hits]  DEFAULT (0),
	[LastUseTime] [datetime] NOT NULL CONSTRAINT [DF_ZL_Keywords_LastUseTime]  DEFAULT (getdate()),
	[ArrGeneralID] [ntext] NULL,
	[QuoteTimes] [int] NULL,
 CONSTRAINT [PK_ZL_Keywords] PRIMARY KEY CLUSTERED 
(
	[KeywordID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]



GO
CREATE TABLE [dbo].[ZL_UserStoreTable](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[StoreName] [varchar](100) NULL,
	[StoreContent] [ntext] NULL,
	[StoreCredit] [int] NULL,
	[StoreVip] [int] NULL,
	[StoreType] [varchar](100) NULL,
	[StoreCash] [decimal](8, 2) NULL,
	[StoreState] [int] NULL,
	[AddTime] [datetime] NULL,
	[StoreProvince] [varchar](100) NULL,
	[StoreCity] [varchar](100) NULL,
 CONSTRAINT [PK_ZL_UserStoreTable] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_UserStoreTypeTable](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[TypeName] [varchar](100) NULL,
 CONSTRAINT [PK_ZL_UserStoreTypeTable] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO

CREATE TABLE [dbo].[ZL_MTit](
	[I_id] [int] IDENTITY(1,1) NOT NULL,
	[Iinfo] [nvarchar](500) NULL,
	[Iurl] [nvarchar](500) NULL,
	[Itype] [int] NULL CONSTRAINT [DF_ZL_MTit_Itype]  DEFAULT (0),
	[Stype] [int] NULL,
	[orderid] [int] NULL CONSTRAINT [DF_ZL_MTit_orderid]  DEFAULT (0),
 CONSTRAINT [PK_ZL_MTit] PRIMARY KEY CLUSTERED 
(
	[I_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'插件名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MTit', @level2type=N'COLUMN', @level2name=N'Iinfo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'插件地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MTit', @level2type=N'COLUMN', @level2name=N'Iurl'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MTit', @level2type=N'COLUMN', @level2name=N'Itype'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否为老师所用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MTit', @level2type=N'COLUMN', @level2name=N'Stype'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MTit', @level2type=N'COLUMN', @level2name=N'orderid'


GO
CREATE TABLE [dbo].[ZL_MailIdiograph](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NULL,
	[AddTime] [datetime] NULL,
	[State] [bit] NULL,
	[Context] [nvarchar](100) NULL,
 CONSTRAINT [PK_ZL_MailIdiograph] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'签名名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MailIdiograph', @level2type=N'COLUMN', @level2name=N'Name'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MailIdiograph', @level2type=N'COLUMN', @level2name=N'AddTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'状态' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MailIdiograph', @level2type=N'COLUMN', @level2name=N'State'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'签名内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MailIdiograph', @level2type=N'COLUMN', @level2name=N'Context'



GO
CREATE TABLE [dbo].[ZL_MailInfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[MailTitle] [nvarchar](500) NULL,
	[MailContext] [text] NULL,
	[MailSendTime] [datetime] NULL,
	[MailAddTime] [datetime] NULL,
	[MailState] [bit] NULL,
	[MailAddRees] [text] NULL,
	[UserID] [int] NOT NULL DEFAULT (0),
	[SendMail] [nvarchar](255) NULL,
	[Files] [nvarchar](500) NULL,
	[MID] int NULL DEFAULT (0)
 CONSTRAINT [PK_ZL_MailInfo] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]



GO
CREATE TABLE [dbo].[ZL_WorkRole] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[AdminID] [int]  NOT NULL,
[Region] [nvarchar]  (50) NULL)

ALTER TABLE [ZL_WorkRole] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_WorkRole] PRIMARY KEY  NONCLUSTERED ( [ID] )

GO
CREATE TABLE [dbo].[ZL_MailManage](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Email] [nvarchar](100) NULL,
	[Postfix] [nvarchar](50) NULL,
	[AddTime] [datetime] NULL,
	[BackMostTime] [datetime] NULL,
	[SubscribeToType] [nvarchar](50) NULL,
	[UserID] [int] NULL,
	[State] [bit] NULL,
 CONSTRAINT [PK_ZL_MailManage] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

 

GO
CREATE TABLE [dbo].[ZL_Zone_Advertisement](
	[ZoneID] [int] NOT NULL,
	[ADID] [int] NOT NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Manager](
	[AdminID] [int] IDENTITY(1,1) NOT NULL,
	[AdminName] [nvarchar](50) NOT NULL,
	[AdminPassword] [nvarchar](100) NOT NULL,
	[UserName] [nvarchar](255) NOT NULL,
	[EnableMultiLogin] [bit] NOT NULL CONSTRAINT [DF_ZL_Manager_EnableMultiLogin]  DEFAULT (0),
	[LoginTimes] [int] NULL CONSTRAINT [DF_ZL_Manager_LoginTimes]  DEFAULT (0),
	[LastLoginIP] [nvarchar](50) NULL CONSTRAINT [DF_ZL_Manager_LastLoginIP]  DEFAULT (''),
	[LastLoginTime] [datetime] NULL CONSTRAINT [DF_ZL_Manager_LastLoginTime]  DEFAULT (getdate()),
	[LastLogoutTime] [datetime] NULL CONSTRAINT [DF_ZL_Manager_LastLogoutTime]  DEFAULT (getdate()),
	[LastModifyPwdTime] [datetime] NULL CONSTRAINT [DF_ZL_Manager_LastModifyPwdTime]  DEFAULT (getdate()),
	[IsLock] [bit] NULL CONSTRAINT [DF_ZL_Manager_IsLock]  DEFAULT (0),
	[IsTable] [bit] NULL CONSTRAINT [DF_ZL_Manager_IsTable]  DEFAULT (0),
	[EnableModifyPassword] [bit] NULL CONSTRAINT [DF_ZL_Manager_EnableModifyPassword]  DEFAULT (1),
	[AdminRole] [ntext] NULL CONSTRAINT [DF_ZL_Manager_AdminRole]  DEFAULT (''),
	[Theme] [nvarchar](4000) NULL CONSTRAINT [DF_ZL_Manager_Theme]  DEFAULT (''),
	[RandNumber] [nvarchar](50) NULL CONSTRAINT [DF_ZL_Manager_RandNumber]  DEFAULT (''),
	[NodeRole] [int] NULL CONSTRAINT [DF_ZL_Manager_NodeRole]  DEFAULT (0),
	[PubRole] [int] NULL CONSTRAINT [DF_ZL_Manager_PubRole]  DEFAULT (0),
	[DefaultStart] [int] NULL CONSTRAINT [DF_ZL_Manager_DefaultStart]  DEFAULT (-99),
	[AdminType] [int] NULL,
	[ManageNode] [nvarchar](500) NULL CONSTRAINT [DF_ZL_Manager_ManageNode]  DEFAULT (''),
	[AddUserID] [int] NULL,
	[AdminTrueName] [nvarchar](50) NOT NULL,
	[StructureID] [nvarchar](255) NULL,
	[CDate] [datetime] NULL
 CONSTRAINT [PK_ZL_Manager] PRIMARY KEY CLUSTERED 
(
	[AdminID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'管理员ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'AdminID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'管理员名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'AdminName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'管理员密码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'AdminPassword'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'前台用户名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'UserName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否允许多人登录' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'EnableMultiLogin'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'登录次数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'LoginTimes'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最近登录IP' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'LastLoginIP'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最近登录时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'LastLoginTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最近退出管理后台时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'LastLogoutTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最近修改密码时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'LastModifyPwdTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否锁定' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'IsLock'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否启用个性桌面' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'IsTable'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否允许修改密码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'EnableModifyPassword'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'管理员角色权限' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'AdminRole'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'后台页面主题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'Theme'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发布内容默认状态' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'DefaultStart'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'管理员类型  1超级管理员，2站点管理员，3普通管理员' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'AdminType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'管理节点,当AdminType为2站点管理员时,该字段记录管理的站点ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'ManageNode'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加该帐号的管理员ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'AddUserID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'组织结构ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Manager', @level2type=N'COLUMN', @level2name=N'StructureID'


GO
CREATE TABLE [dbo].[ZL_Manufacturers](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Producername] [varchar](255) NULL,
	[Smallname] [varchar](255) NULL,
	[CreateTime] [datetime] NULL CONSTRAINT [DF_ZL_Manufacturers_CreateTime]  DEFAULT (getdate()),
	[Coadd] [varchar](255) NULL,
	[Telpho] [varchar](255) NULL,
	[FaxCode] [varchar](50) NULL,
	[PostCode] [varchar](50) NULL,
	[CoWebsite] [varchar](255) NULL,
	[Email] [varchar](50) NULL,
	[CoClass] [varchar](50) NULL,
	[CoPhoto] [varchar](255) NULL,
	[Content] [text] NULL,
	[Istop] [int] NULL CONSTRAINT [DF_ZL_Manufacturers_Istop]  DEFAULT (0),
	[Disable] [int] NULL CONSTRAINT [DF_ZL_Manufacturers_Disable]  DEFAULT (0),
	[Isbest] [int] NULL CONSTRAINT [DF_ZL_Manufacturers_Isbest]  DEFAULT (0),
 CONSTRAINT [PK_ZL_Manufacturers] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_MiUserInfo](
	[M_id] [int] IDENTITY(1,1) NOT NULL,
	[userid] [int] NULL,
	[schoolID] [int] NULL,
	[banji] [nvarchar](255) NULL,
	[prov] [nvarchar](50) NULL,
	[city] [nvarchar](50) NULL,
	[daike] [nvarchar](255) NULL,
	[realname] [nvarchar](255) NULL,
	[type] [int] NULL CONSTRAINT [DF_ZL_MiUserInfo_type]  DEFAULT (0),
 CONSTRAINT [PK_ZL_MiUserInfo] PRIMARY KEY CLUSTERED 
(
	[M_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'[userid]' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'userid'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学校ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'schoolID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'班级' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'banji'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'省' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'prov'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'市' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'city'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'代课' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'daike'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'真实姓名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'realname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'类型老师或学生' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MiUserInfo', @level2type=N'COLUMN', @level2name=N'type'


GO
SET ANSI_NULLS ON
CREATE TABLE [dbo].[ZL_Model](
[ModelID] [int] IDENTITY(1,1) NOT NULL,
[ModelName] [nvarchar](50) NOT NULL,
[Description] [nvarchar](250) NULL,
[TableName] [nvarchar](50) NOT NULL,
[ItemName] [nvarchar](50) NULL,
[ItemUnit] [nvarchar](20) NULL,
[ItemIcon] [nvarchar](255) NULL,
[ContentTemplate] [nvarchar](255) NULL,
[ModelType] [int] NULL CONSTRAINT [DF_ZL_Model_ModelType]  DEFAULT (1),
[MultiFlag] [bit] NULL CONSTRAINT [DF_ZL_Model_MultiFlag]  DEFAULT (0),
[NodeID] [int] NULL CONSTRAINT [DF_ZL_Model_NodeID]  DEFAULT (0),
[SysModel] [int] NULL CONSTRAINT [DF_ZL_Model_SysModel]  DEFAULT (2),
[FromModel] [int] NULL CONSTRAINT [DF_ZL_Model_FromModel]  DEFAULT (0),
[Thumbnail] [nvarchar] (500) NULL ,
[Islotsize][bit]  NULL CONSTRAINT [DF_ZL_Model_Islotsize]  DEFAULT ((0)),
CONSTRAINT [PK_ZL_Model] PRIMARY KEY CLUSTERED 
(
[ModelID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ModelID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ModelName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'Description'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型关联的表名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'TableName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目名称：如文章、新闻' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ItemName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目单位：如篇、条' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ItemUnit'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目图标' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ItemIcon'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ContentTemplate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型类别 1-内容模型 2-商品模型 3-会员模型 4-黄页模型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'ModelType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'识别系统模型字段，1：系统生成模型，2：用户自定义模型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'SysModel'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'复制来源模型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Model', @level2type=N'COLUMN', @level2name=N'FromModel'

GO
CREATE TABLE [dbo].[ZL_ModelField](
[FieldID] [int] IDENTITY(1,1) NOT NULL,
[ModelId] [int] NOT NULL,
[FieldName] [nvarchar](50) NOT NULL,
[FieldAlias] [nvarchar](50) NOT NULL,
[FieldTips] [nvarchar](50) NULL DEFAULT(''),
[Description] [nvarchar](255) NULL DEFAULT(''),
[IsNotNull] [bit] NULL CONSTRAINT [DF_ZL_ModelField_IsNotNull]  DEFAULT (0),
[IsSearchForm] [bit] NULL CONSTRAINT [DF_ZL_ModelField_IsSearchForm]  DEFAULT (0),
[FieldType] [nvarchar](50) NOT NULL,
[Content] [ntext] NULL DEFAULT(''),
[OrderId] [int] NULL CONSTRAINT [DF_ZL_ModelField_OrderId]  DEFAULT (1),
[ShowList] [bit] NULL CONSTRAINT [DF__ZL_ModelF__ShowL__454A25B4]  DEFAULT (0),
[ShowWidth] [int] NULL CONSTRAINT [DF__ZL_ModelF__ShowW__463E49ED]  DEFAULT (0),
[IsShow] [bit] NULL CONSTRAINT [DF_ZL_ModelField_IsShow]  DEFAULT (1),
[IsView] [bit] NULL CONSTRAINT [DF_ZL_ModelField_IsView]  DEFAULT (1),
[IsDownField] [int] NULL CONSTRAINT [DF_ZL_ModelField_IsDownField]  DEFAULT (0),
[DownServerID] [int] NULL CONSTRAINT [DF_ZL_ModelField_DownServerID]  DEFAULT (0),
[RestoreField] [int] NULL CONSTRAINT [DF_ZL_ModelField_Restore]  DEFAULT (0),
[Sys_type] [bit] NULL  DEFAULT (0),
[IsCopy] [int] NULL CONSTRAINT [DF_ZL_ModelField_IsCopy]  DEFAULT (0),
[Islotsize] [bit] NULL CONSTRAINT [DF_ZL_ModelField_Islotsize]  DEFAULT (0),
[IsChain] [bit]  NULL CONSTRAINT [DF_ZL_ModelField_IsChain]  DEFAULT (0),
CONSTRAINT [PK_ZL_ModelField] PRIMARY KEY CLUSTERED 
(
[FieldID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'FieldID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'ModelId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'FieldName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段别名 前台显示用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'FieldAlias'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段提示' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'FieldTips'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'Description'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否必填 默认0否' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'IsNotNull'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否在搜索表单显示' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'IsSearchForm'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'字段类型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'FieldType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'排列序号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'OrderId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否为下载专用字段' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'IsDownField'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'下载服务器ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'DownServerID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'回复显示字段' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'RestoreField'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否可复制 0：不可复制，1：可复制' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ModelField', @level2type=N'COLUMN', @level2name=N'IsCopy'



GO
CREATE TABLE [dbo].[ZL_MultiNode](
	[N_ID] [int] IDENTITY(1,1) NOT NULL,
	[N_ItemID] [int] NULL,
	[N_NodeID] [int] NULL,
 CONSTRAINT [PK_ZL_multiNode] PRIMARY KEY CLUSTERED 
(
	[N_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MultiNode', @level2type=N'COLUMN', @level2name=N'N_NodeID'


GO
CREATE TABLE [dbo].[ZL_Node] (
	[NodeID] [int]  IDENTITY (1, 1)  NOT NULL,
	[NodeName] [nvarchar]  (50) NOT NULL,
	[NodeType] [int]  NOT NULL DEFAULT (0),
	[NodeDir] [nvarchar]  (50) NOT NULL,
	[NodeUrl] [nvarchar]  (255) NULL,
	[NodeListUrl] [nvarchar]  (255) NULL,
	[Tips] [nvarchar]  (4000) NULL,
	[ParentID] [int]  NULL,
	[OrderID] [int]  NULL DEFAULT (0),
	[Child] [int]  NULL,
	[Depth] [int]  NULL DEFAULT (1),
	[NodePicUrl] [nvarchar]  (255) NULL,
	[Description] [nvarchar]  (4000) NULL,
	[Meta_Keywords] [nvarchar]  (4000) NULL,
	[Meta_Description] [nvarchar]  (4000) NULL,
	[OpenType] [bit]  NULL DEFAULT (0),
	[PurviewType] [bit]  NULL DEFAULT (0),
	[CommentType] [nvarchar](5)  NULL DEFAULT ('0'),
	[HitsOfHot] [int]  NULL DEFAULT (0),
	[IndexTemplate] [nvarchar]  (255) NULL,
	[ListTemplateFile] [nvarchar]  (255) NULL,
	[LastinfoTemplate] [nvarchar]  (255) NULL,
	[HotinfoTemplate] [nvarchar]  (255) NULL,
	[ProposeTemplate] [nvarchar]  (255) NULL,
	[ContentModel] [nvarchar]  (255) NULL,
	[ItemOpenType] [bit]  NULL DEFAULT (0),
	[ContentHtmlRule] [int]  NULL DEFAULT (0),
	[ListPageHtmlEx] [int]  NULL DEFAULT (0),
	[ContentFileEx] [int]  NULL DEFAULT (0),
	[HtmlPosition] [int]  NULL DEFAULT (0),
	[NodeListType] [int]  NULL DEFAULT (0),
	[ConsumePoint] [int]  NULL DEFAULT (0),
	[ConsumeType] [int]  NULL DEFAULT (0),
	[ConsumeTime] [int]  NULL DEFAULT (0),
	[ConsumeCount] [int]  NULL DEFAULT (0),
	[Shares] [float]  NULL DEFAULT (0),
	[Custom] [text]  NULL DEFAULT (''),
	[SafeGuard] [int]  NOT NULL DEFAULT ('0'),
	[ItemOpenTypeTrue] [nvarchar]  (50) NULL DEFAULT ('0'),
	[OpenTypeTrue] [nvarchar]  (50) NULL DEFAULT ('0'),
	[NodeBySite] [int]  NULL,
	[SiteConfige] [text]  NULL,
	[Contribute] [int]  NULL DEFAULT (0),
	[SiteContentAudit] [int]  NULL DEFAULT (0),
	[AuditNodeList] [nvarchar]  (1000) NULL,
	[AddPoint] [int]  NULL,
	[AddMoney] [money]  NULL,
	[ClickTimeout] [int]  NULL DEFAULT (1),
	[Purview] [nvarchar]  (1000) NULL,
	[AddUserExp] [int]  NULL,
	[DeducUserExp] [int]  NULL,
	[ListPageEx] [int]  NULL DEFAULT (0),
	[LastinfoPageEx] [int]  NULL DEFAULT (0),
	[HotinfoPageEx] [int]  NULL DEFAULT (0),
	[ProposePageEx] [int]  NULL DEFAULT (0),
	[Viewinglimit] [nvarchar]  (100) NULL)
ALTER TABLE [ZL_Node] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_Node] PRIMARY KEY  NONCLUSTERED ( [NodeID] )
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点类型。0为根节点，1为栏目节点2为单个页面，3为外部链接' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点标识目录，只能是英文字母和数字，并且要以字母开头' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeDir'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'外部链接' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表页URL' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeListUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点提示，不支持HTML' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Tips'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'父栏目ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ParentID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'排序ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'OrderID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'子栏目数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Child'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目深度' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Depth'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目图片地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodePicUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Description'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目META关键词' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Meta_Keywords'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'针对搜索引擎的说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Meta_Description'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'打开方式0原窗口' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'OpenType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目权限。0--开放栏目  1--认证栏目' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'PurviewType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论权限0不允许，1允许' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'CommentType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'热点的点击数最小值' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'HitsOfHot'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表页模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ListTemplateFile'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'栏目首页模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'IndexTemplate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最新信息模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'LastinfoTemplate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'热门信息模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'HotinfoTemplate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'推荐信息模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ProposeTemplate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'选择的内容模型数组' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ContentModel'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点下项目的打开方式' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ItemOpenType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容页的文件名规则' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ContentHtmlRule'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'列表首页的文件名规则' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ListPageHtmlEx'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容页文件扩展名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ContentFileEx'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点目录生成静态位置0-根目录 1-继承父目录结构' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'HtmlPosition'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1-文章，2-商城，3-两个都包含' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeListType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'查看内容消费点券数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ConsumePoint'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'重复收费方式' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ConsumeType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'距离上次收费时间多少小时重新收费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ConsumeTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'重复阅读内容多少次重新收费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ConsumeCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'安全保护' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'SafeGuard'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'会员添加内容分成比例' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Shares'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'自设内容 用{SplitCustom}分隔' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Custom'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'节点转子站  null或0为节点，5为子站' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'NodeBySite'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'当NodeBySite为5时，该字段为站点配置文件' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'SiteConfige'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否允许投稿' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'Contribute'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否需要审核' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'SiteContentAudit'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'指定投稿栏目' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'AuditNodeList'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'点击时间有效范围' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Node', @level2type=N'COLUMN', @level2name=N'ClickTimeout'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'发布内容添加积分数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Node', @level2type=N'COLUMN',@level2name=N'AddUserExp'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'下载内容扣除积分数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Node', @level2type=N'COLUMN',@level2name=N'DeducUserExp'

GO
CREATE TABLE [dbo].[ZL_NodeBindDroit](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[NodeID] [int] NOT NULL,
	[FID] [int] NOT NULL,
 CONSTRAINT [PK_ZL_NodeBindDroit] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



GO
CREATE TABLE [dbo].[ZL_NodeRole](
	[RN_ID] [int] IDENTITY(1,1) NOT NULL,
	[RID] [int] NULL,
	[NID] [int] NULL,
	[look] [int] NULL,
	[Modify] [int] NULL,
	[State] [int] NULL,
	[addTo] [int] NULL,
	[Columns] [int] NULL,
	[Comments] [int] NULL,
	[PNid] [int] NULL CONSTRAINT [DF_ZL_NodeRole_PNid]  DEFAULT (0),
 CONSTRAINT [PK_ZL_NodeRole] PRIMARY KEY CLUSTERED 
(
	[RN_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'角色ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'RID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'NID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'查看' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'look'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'修改' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'Modify'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'审核' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'State'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'addTo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'当前栏目' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'Columns'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_NodeRole', @level2type=N'COLUMN', @level2name=N'Comments'


GO
CREATE TABLE [dbo].[ZL_Node_ModelTemplate](
	[NodeID] [int] NOT NULL,
	[ModelID] [int] NOT NULL,
	[Template] [nvarchar](255) NOT NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Online](
	[UserID] [int] NOT NULL,
	[UserName] [nvarchar](255) NOT NULL,
	[StartTime] [datetime] NOT NULL CONSTRAINT [DF_ZL_Online_LastOnlineTime]  DEFAULT (getdate()),
	[ChangeTime] [datetime] NOT NULL CONSTRAINT [DF_ZL_Online_LastChangTime]  DEFAULT (getdate())
) ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_Orderinfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[OrderNo] [varchar](50) NULL,
	[Reuser] [varchar](255) NULL,
	[Receiver] [varchar](50) NULL,
	[Rename] [varchar](255) NULL,
	[Guojia] [varchar](255) NULL,
	[Shengfen] [varchar](255) NULL,
	[Chengshi] [varchar](255) NULL,
	[Diqu] [varchar](255) NULL,
	[Jiedao] [varchar](255) NULL,
	[ZipCode] [varchar](50) NULL,
	[Phone] [varchar](50) NULL,
	[Email] [varchar](50) NULL,
	[Mobile] [int] NULL,
	[Delivery] [int] NULL,
	[Outstock] [int] NULL,
	[Deliverytime] [int] NULL,
	[Payment] [int] NULL,
	[Invoice] [varchar](2000) NULL,
	[Ordermessage] [text] NULL,
	[Merchandiser] [varchar](50) NULL,
	[Internalrecords] [text] NULL,
	[Ordersamount] [money] NULL,
	[Receivablesamount] [money] NULL,
	[Specifiedprice] [money] NULL,
	[Freight] [money] NULL,
	[Invoiceneeds] [int] NULL,
	[Developedvotes] [int] NULL,
	[OrderStatus] [int] NULL,
	[Paymentstatus] [int] NULL,
	[StateLogistics] [int] NULL,
	[Signed] [int] NULL CONSTRAINT [DF_ZL_Orderinfo_Signed]  DEFAULT (0),
	[Settle] [int] NULL CONSTRAINT [DF_ZL_Orderinfo_Settle]  DEFAULT (0),
	[Aside] [int] NULL CONSTRAINT [DF_ZL_Orderinfo_aside]  DEFAULT (0),
	[Suspended] [int] NULL CONSTRAINT [DF_ZL_Orderinfo_Suspended]  DEFAULT (0),
	[Ordertype] [int] NULL CONSTRAINT [DF_ZL_Orderinfo_Ordertype]  DEFAULT (0),
	[AddTime] [datetime] NULL CONSTRAINT [DF_ZL_Orderinfo_AddTime]  DEFAULT (getdate()),
	[AddUser] [varchar](255) NULL,
	[Userid] [int] NULL,
	[city] [nvarchar](50) NULL,
	[IsCount] [bit] NULL CONSTRAINT [DF_ZL_Orderinfo_IsCount]  DEFAULT (0),
	[Integral] [int] NULL DEFAULT (0),
	[parentID] [int] NULL DEFAULT (0),
	[service_charge] [float] NULL ,
	[Balance_price] [float] NULL ,
	[Freight_remark] [nvarchar](1000) null,
	[Balance_remark][nvarchar](1000) null,
	[Money_rate] [money] null DEFAULT (1),
	[Money_code] [varchar] (4) null,
	[MobileNum] [nvarchar] (20) NULL ,
	[ExpressDelivery] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[InvoType] [int] NULL,
	[Promoter] [int] NULL,
	[ExpressNum] [varchar](400) null,
	[Company] [nvarchar] (400) null,
	[SendPointStatus] [int] NULL DEFAULT (0),
	[Province] [int]  NULL,
	[Extend] [ntext]  NULL,
	[StoreID] [int] NULL DEFAULT (0),
	[AllMoney_Json] [nvarchar](500) NULL,
 CONSTRAINT [PK_ZL_Orderinfo] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Order_Share](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[Title] [nvarchar](200) NULL,
	[Score] [int] NULL,
	[Labels] [nvarchar](400) NULL,
	[MsgContent] [nvarchar](2000) NULL,
	[Imgs] [nvarchar](2000) NULL,
	[IsAnonymous] [int] NULL,
	[CDate] [datetime] NULL,
	[OrderID] [int] NULL,
	[ProID] [int] NULL,
	[Pid] [int] NULL,
	[OrderDate] [datetime] NULL,
	[ReplyID] [int] NULL,
	[ReplyUid] [int] NULL,
 CONSTRAINT [PK_ZL_Order_Share] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Order_Repair](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProNum] [int] NULL,
	[Deailt] [nvarchar](1000) NULL,
	[ProImgs] [nvarchar](2000) NULL,
	[CretType] [nvarchar](100) NULL,
	[ReProType] [int] NULL,
	[TakeProCounty] [nvarchar](500) NULL,
	[TakeProAddress] [nvarchar](1000) NULL,
	[ReProCounty] [nvarchar](500) NULL,
	[ReProAddress] [nvarchar](1000) NULL,
	[UserName] [nvarchar](500) NULL,
	[Phone] [nvarchar](100) NULL,
	[ProID] [int] NULL,
	[CDate] [datetime] NULL,
	[TakeTime] [datetime] NULL,
	[Status] [int] NULL,
	[UserID] [int] NULL,
	[ServiceType] [nvarchar](500) NULL,
	[OrderNO] [nvarchar](500) NULL,
	[CartID] [int] NULL,
	[ApplyType] [int] NULL,
 CONSTRAINT [PK_ZL_OrderRepair] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_PageStyle](
	[PageNodeid] [int] IDENTITY(1,1) NOT NULL,
	[PageNodeName] [varchar](255) NULL,
	[Istrue] [int] NULL CONSTRAINT [DF_ZL_PageNode_Istrue]  DEFAULT (1),
	[Orderid] [int] NULL CONSTRAINT [DF_ZL_PageNode_Orderid]  DEFAULT (0),
	[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_PageNode_Addtime]  DEFAULT (getdate()),
	[IsDefault] [int] NULL CONSTRAINT [DF_ZL_PageStyle_IsDefault]  DEFAULT (0),
	[StylePath] [nvarchar](255) NULL,
	[TemplateIndex] [nvarchar](255) NULL,
	[TemplateIndexPic] [nvarchar](255) NULL,
 CONSTRAINT [PK_ZL_PageNode] PRIMARY KEY CLUSTERED 
(
	[PageNodeid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

SET IDENTITY_INSERT [ZL_PageStyle] ON
INSERT [ZL_PageStyle] ([PageNodeid],[PageNodeName],[Istrue],[Orderid],[Addtime],[IsDefault],[StylePath],[TemplateIndex]) VALUES ( 1,N'体验样式',1,0,N'2014/7/29 8:35:10',1,N'/Template/V3/企业黄页/','企业黄页/企业首页.html')
SET IDENTITY_INSERT [ZL_PageStyle] OFF

GO
CREATE TABLE [dbo].[ZL_PageTemplate](
	[TemplateID] [int] IDENTITY(1,1) NOT NULL,
	[TemplateName] [varchar](50) NOT NULL,
	[TemplateUrl] [varchar](50) NOT NULL,
	[TemplateType] [int] NULL CONSTRAINT [DF_ZL_PageTemplate_TemplateType]  DEFAULT (0),
	[OpenType] [varchar](50) NULL CONSTRAINT [DF_ZL_PageTemplate_OpenType]  DEFAULT ('_blank'),
	[UserGroup] [varchar](50) NULL,
	[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_PageTemplate_Addtime]  DEFAULT (getdate()),
	[IsTrue] [int] NULL CONSTRAINT [DF_ZL_PageTemplate_IsTrue]  DEFAULT (0),
	[Userid] [int] NULL CONSTRAINT [DF_ZL_PageTemplate_Userid]  DEFAULT (0),
	[UserName] [varchar](255) NULL,
	[OrderID] [int] NULL CONSTRAINT [DF_ZL_PageTemplate_OrderID]  DEFAULT (0),
	[ParentID] [int] NULL CONSTRAINT [DF_ZL_PageTemplate_ParentID]  DEFAULT (0),
	[Modelinfo] [text] NULL,
	[identifiers] [varchar](255) NULL,
	[NodeFileEx] [varchar](50) NULL,
	[ContentFileEx] [varchar](50) NULL,
	[Nodeimgurl] [varchar](255) NULL,
	[Nodeimgtext] [varchar](255) NULL,
	[Pagecontent] [text] NULL,
	[PageMetakeyword] [varchar](255) NULL,
	[PageMetakeyinfo] [varchar](255) NULL,
	[linkurl] [varchar](255) NULL,
	[linkimg] [varchar](255) NULL,
	[linktxt] [varchar](255) NULL,
	[ParentNode] [int] NULL CONSTRAINT [DF_ZL_PageTemplate_ParentNode]  DEFAULT (0),
	[NeedAudit] [int] NULL,
 CONSTRAINT [PK_ZL_PageTemplate] PRIMARY KEY CLUSTERED 
(
	[TemplateID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_PayPlat](
	[PayPlatID] [int] IDENTITY(1,1) NOT NULL,
	[UID] [int] NOT NULL,
	[PayClass] [int] NULL,
	[PayPlatName] [nvarchar](255) NOT NULL,
	[AccountID] [nvarchar](255) NULL,
	[MD5Key] [nvarchar](255) NULL,
	[SellerEmail] [nvarchar](255) NULL,
	[IsDisabled] [bit] NULL,
	[IsDefault] [bit] NULL,
	[Rate] [float] NULL,
	[OrderID] [int] NULL,
	[payType] [nvarchar](50) NULL,
	[leadtoGroup] [nvarchar](500) NULL,
	[PayPlatinfo] [nvarchar](1000) NULL,
	[PrivateKey] [nvarchar](200) NULL,
	[PublicKey] [nvarchar](200) NULL,
	[Other] [nvarchar](3000) NULL,
 CONSTRAINT [PK_ZL_PayPlat] PRIMARY KEY CLUSTERED 
([PayPlatID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'支付平台ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'PayPlatID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'支付平台名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'PayPlatName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'支付平台商户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'AccountID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'支付平台商户安全校验码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'MD5Key'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'卖家Email如支付宝需要的卖家Email' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'SellerEmail'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否禁用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'IsDisabled'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否默认支付平台' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'IsDefault'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'手续费' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'Rate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'排序ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'OrderID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支付卡类型 zfk ，a等' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'payType'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'这个通道属于的用户组，各个用户组表示：‘，***，’' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'leadtoGroup'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PayPlat', @level2type=N'COLUMN', @level2name=N'PayPlatinfo'

GO
INSERT INTO ZL_PayPlat ([UID],PayClass,PayPlatName,AccountID,MD5Key,OrderID,IsDisabled,IsDefault,rate) values(0,99,'线下支付','offline','offline',1,0,0,0)
GO

CREATE TABLE [dbo].[ZL_Payment](
	[PaymentID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[PayNo] [nvarchar](200) NULL,
	[PaymentNum] [nvarchar](200) NULL,
	[PayPlatID] [int] NULL,
	[MoneyPay] [money] NULL,
	[MoneyTrue] [money] NULL,
	[PayTime] [datetime] NULL,
	[SuccessTime] [datetime] NULL,
	[Status] [int] NULL,
	[PlatformInfo] [nvarchar](200) NULL,
	[Remark] [nvarchar](255) NULL,
	[CStatus] [bit] NULL,
	[AlipayNO] [nvarchar](100) NULL,
	[ArriveMoney] [money] NULL,
	[ArriveDetail] [nvarchar](500) NULL,
	[MoneyID] [int] NULL,
	[MoneyReal] [money] NULL,
	[IsDel] [int] NULL
 CONSTRAINT [PK_ZL_Payment] PRIMARY KEY CLUSTERED 
([PaymentID] DESC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Permission](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[RoleName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[RoleImg] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Info] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Perlist] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[UserGroup] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[Precedence] [int] NULL CONSTRAINT [DF_ZL_Permission_Precedence]  DEFAULT (0),
	[IsTrue] [bit] NULL CONSTRAINT [DF_ZL_Permission_IsTrue]  DEFAULT (1),
	[Auth_OA] [varchar](8000),
 CONSTRAINT [PK_ZL_Permission] PRIMARY KEY CLUSTERED 
([ID] ASC) WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]) ON [PRIMARY]

SET IDENTITY_INSERT [ZL_Permission] ON
INSERT [ZL_Permission] ([ID],[RoleName],[Info],[Precedence],[IsTrue],[Auth_OA]) VALUES ( 1,N'网页设计师',N'网页设计师',0,1,N'design')
SET IDENTITY_INSERT [ZL_Permission] OFF

GO
CREATE TABLE [dbo].[ZL_PointTrans](
	[PID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[UserPoint] [int] NOT NULL,
	[Detail] [nvarchar](1000) NOT NULL,
	[OperDate] [datetime] NOT NULL CONSTRAINT [DF_ZL_PointTrans_OperDate]  DEFAULT (getdate()),
	[Operator] [int] NOT NULL,
 CONSTRAINT [PK_ZL_PointTrans] PRIMARY KEY CLUSTERED 
(
	[PID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Present](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Prename] [varchar](50) NULL,
	[Pretype] [varchar](50) NULL,
	[procode] [varchar](50) NULL,
	[ShiPrice] [money] NULL,
	[LinPrice] [money] NULL,
	[ProUnit] [varchar](50) NULL,
	[Stock] [int] NULL,
	[StockDown] [int] NULL,
	[Weight] [int] NULL,
	[ServerPeriod] [int] NULL,
	[ServerType] [int] NULL,
	[Preinfo] [text] NULL,
	[precontent] [text] NULL,
	[Clearimg] [varchar](255) NULL,
	[Thumbnails] [varchar](255) NULL,
	[Adduser] [varchar](50) NULL,
	[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_Present_Addtime]  DEFAULT (getdate()),
	[Updatetime] [datetime] NULL CONSTRAINT [DF_ZL_Present_Updatetime]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_Present] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_PrintMode](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Control_Width] [int] NULL,
	[Control_Height] [int] NULL,
	[Bg_width] [int] NULL,
	[Bg_Height] [int] NULL,
	[Bg_URL] [varchar](50) NULL,
	[Mode_Type] [varchar](50) NULL
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[ZL_PrintPic](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Mode_id] [int] NULL,
	[User_id] [int] NULL,
	[Pic_URL] [varchar](50) NULL,
	[Pic_Compound] [varchar](50) NULL
) ON [PRIMARY]



GO
CREATE TABLE [dbo].[ZL_Process](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PName] [varchar](200) NOT NULL,
	[PDepcit] [varchar](5000) NULL,
	[PRole] [varchar](60) NOT NULL,
	[PCode] [int] NOT NULL,
	[PPassName] [varchar](200) NOT NULL,
	[PPassCode] [int] NOT NULL,
	[PNoPassName] [varchar](200) NOT NULL,
	[PNoPassCode] [int] NOT NULL,
	[PFlowId] [int] NOT NULL,
	[NeedCode] [int] NOT NULL
 CONSTRAINT [PK_ZM_Process] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'主键' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'id'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'步骤名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'步骤描述' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PDepcit'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'角色id' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PRole'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'流程步骤序列号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'通过审核名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PPassName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'未通过审核名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PNoPassName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'未通过审核码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PNoPassCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'流程号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Process', @level2type=N'COLUMN', @level2name=N'PFlowId'
GO
SET IDENTITY_INSERT [ZL_Process] ON
INSERT [ZL_Process] ([ID],[PName],[PRole],[PCode],[PPassName],[PPassCode],[PNoPassName],[PNoPassCode],[PFlowId],[NeedCode]) VALUES ( 1,N'初审',N'1,2,3,4,5,6,7,8,9,',1,N'初审',11,N'初审拒绝',-2,1,0)
INSERT [ZL_Process] ([ID],[PName],[PRole],[PCode],[PPassName],[PPassCode],[PNoPassName],[PNoPassCode],[PFlowId],[NeedCode]) VALUES ( 2,N'二审',N'1,2,',2,N'二审',12,N'二审拒绝',-2,1,11)
INSERT [ZL_Process] ([ID],[PName],[PRole],[PCode],[PPassName],[PPassCode],[PNoPassName],[PNoPassCode],[PFlowId],[NeedCode]) VALUES ( 3,N'终审',N'1,2,',3,N'已审核',99,N'不通过',-2,1,12)
SET IDENTITY_INSERT [ZL_Process] OFF

GO
CREATE TABLE [dbo].[ZL_Project](
	[ProjectID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectName] [nvarchar](255) NOT NULL,
	[ProjectIntro] [ntext] NOT NULL,
	[UserID] [int] NOT NULL,
	[RequireID] [int] NOT NULL CONSTRAINT [DF_ZL_Project_RequireID]  DEFAULT (0),
	[StartDate] [datetime] NOT NULL CONSTRAINT [DF_ZL_Project_StartDate]  DEFAULT (getdate()),
	[EndDate] [datetime] NULL,
	[Status] [int] NULL CONSTRAINT [DF_ZL_Project_Status]  DEFAULT (0),
	[Passed] [bit] NULL CONSTRAINT [DF_ZL_Project_Passed]  DEFAULT (0),
	[ProjectCategoryID] [int] NOT NULL CONSTRAINT [DF_ZL_Project_ProjectCategory]  DEFAULT (0),
 CONSTRAINT [PK_ZL_Project] PRIMARY KEY CLUSTERED 
(
	[ProjectID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'项目分类' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Project', @level2type=N'COLUMN', @level2name=N'ProjectCategoryID'

GO
CREATE TABLE [dbo].[ZL_ProjectAffairs](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[MainTitleID] [int] NOT NULL CONSTRAINT [DF_ZL_ProjectAffairs_MainTitleID]  DEFAULT (0),
	[SubTitleID] [int] NULL CONSTRAINT [DF_ZL_ProjectAffairs_SubTitleID]  DEFAULT (0),
	[Title] [nvarchar](50) NULL,
	[Content] [ntext] NOT NULL,
	[AuthorID] [int] NOT NULL,
	[AuthorName] [nvarchar](50) NULL,
	[EditTime] [datetime] NULL CONSTRAINT [DF_ZL_ProjectAffairs_EditTime]  DEFAULT (getdate()),
	[LastModifyTime] [datetime] NULL CONSTRAINT [DF_ZL_ProjectAffairs_LastModifyTime]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_ProjectAffairs] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标识' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'事务中心主标题事务ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'MainTitleID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'副标题事务回复ID，允许为空' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'SubTitleID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'事务标题(回复允许为空)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'Title'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'事务内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'Content'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编辑者ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'AuthorID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编辑者名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'AuthorName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发表的日期' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'EditTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后修改时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectAffairs', @level2type=N'COLUMN', @level2name=N'LastModifyTime'


GO
CREATE TABLE [dbo].[ZL_ProjectCategory](
	[ProjectCategoryID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectCategoryName] [nvarchar](50) NOT NULL,
	[ProjectCategoryIntro] [nvarchar](255) NULL,
 CONSTRAINT [PK_ZL_ProjectCategory] PRIMARY KEY CLUSTERED 
(
	[ProjectCategoryID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_ProjectDiscuss](
	[DiscussID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectID] [int] NOT NULL,
	[WorkID] [int] NOT NULL CONSTRAINT [DF_ZL_ProjectDiscuss_WorkID]  DEFAULT (0),
	[UserID] [int] NOT NULL CONSTRAINT [DF_ZL_ProjectDiscuss_UserID]  DEFAULT (0),
	[Content] [ntext] NOT NULL,
	[DiscussDate] [datetime] NOT NULL CONSTRAINT [DF_ZL_ProjectDiscuss_DiscussDate]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_ProjectDiscuss] PRIMARY KEY CLUSTERED 
(
	[DiscussID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_ProjectField](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectID] [int] NOT NULL,
	[FieldName] [nvarchar](100) NOT NULL,
	[Alias] [nvarchar](100) NOT NULL,
	[Type] [varchar](50) NOT NULL,
	[FieldValue] [ntext] NOT NULL,
 CONSTRAINT [PK_ZL_ProjectField] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO


CREATE TABLE [dbo].[ZL_ProjectWork](
	[WorkID] [int] IDENTITY(1,1) NOT NULL,
	[WorkName] [nvarchar](255) NOT NULL,
	[WorkIntro] [ntext] NOT NULL,
	[ProjectID] [int] NOT NULL,
	[Approving] [int] NULL CONSTRAINT [DF_ZL_ProjectWork_Approving]  DEFAULT (0),
	[Status] [int] NULL CONSTRAINT [DF_ZL_ProjectWork_Status]  DEFAULT (0),
	[EndDate] [datetime] NOT NULL,
 CONSTRAINT [PK_ZL_ProjectWork] PRIMARY KEY CLUSTERED 
(
	[WorkID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'客户满意度' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ProjectWork', @level2type=N'COLUMN', @level2name=N'Approving'



GO
CREATE TABLE [dbo].[ZL_Promotions](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Promoname] [varchar](255) NULL,
	[Promostart] [datetime] NULL,
	[Promoend] [datetime] NULL,
	[Pricetop] [money] NULL,
	[Priceend] [money] NULL,
	[AddUser] [varchar](50) NULL,
	[Integral] [int] NULL CONSTRAINT [DF_ZL_Promotions_Integral]  DEFAULT (0),
	[GetPresent] [int] NULL CONSTRAINT [DF_ZL_Promotions_GetPresent]  DEFAULT (0),
	[Presentmoney] [money] NULL,
	[IntegralTure] [int] NULL CONSTRAINT [DF_ZL_Promotions_IntegralTure]  DEFAULT (0),
	[PromoProlist] [varchar](255) NULL,
	[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_Promotions_Addtime]  DEFAULT (getdate()),
	[TureUser] [varchar](50) NULL,
 CONSTRAINT [PK_ZL_Promotions] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'促销名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Promoname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'起始时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Promostart'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'结束时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Promoend'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'价格上限' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Pricetop'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'价格下限' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Priceend'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加人' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'AddUser'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'积分' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Integral'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'可以得到礼品' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'GetPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'兑换金钱数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Presentmoney'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'可以得到积分' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'IntegralTure'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'礼品名称列表' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'PromoProlist'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'Addtime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加作者' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Promotions', @level2type=N'COLUMN', @level2name=N'TureUser'

GO
CREATE TABLE [dbo].[ZL_Pub](
[Pubid] [int] IDENTITY(1,1) NOT NULL,
[PubName] [nvarchar](255) NULL,
[PubClass] [int] NULL CONSTRAINT [DF_ZL_Pub_PubClass]  DEFAULT (0),
[PubTableName] [nvarchar](255) NULL,
[PubType] [int] NULL CONSTRAINT [DF_ZL_Pub_PubType]  DEFAULT (0),
[PubOneOrMore] [int] NULL CONSTRAINT [DF_ZL_Pub_PubOneOrMore]  DEFAULT (0),
[PubIPOneOrMore] [int] NULL,
[PubTemplate] [nvarchar](1000) NULL,
[PubLoadstr] [nvarchar](1000) NULL,
[PubModelID] [int] NULL CONSTRAINT [DF_ZL_Pub_PubModelID]  DEFAULT (0),
[PubNodeID] [nvarchar](1000) NULL CONSTRAINT [DF_ZL_Pub_PubNodeID]  DEFAULT (0),
[PubTemplateID] [nvarchar](1000) NULL CONSTRAINT [DF_ZL_Pub_PubTemplateID]  DEFAULT (0),
[Pubinfo] [ntext] NULL,
[PubIsTrue] [int] NULL CONSTRAINT [DF_ZL_Pub_PubIsTrue]  DEFAULT (0),
[PubCode] [int] NULL CONSTRAINT [DF_ZL_Pub_PubPubCode]  DEFAULT (0),
[PubLogin] [int] NULL CONSTRAINT [DF_ZL_Pub_PubNeedReg]  DEFAULT (0),
[PubAddnum] [int] NULL CONSTRAINT [DF_ZL_Pub_PubAddnum]  DEFAULT (0),
[PubBindPub] [int] NULL,
[PubShowType] [int] NULL CONSTRAINT [DF_ZL_Pub_PubShowType]  DEFAULT (0),
[PubInputTM] [nvarchar](1000) NULL,
[PubInputLoadStr] [nvarchar](255) NULL,
[PubCreateTime] [datetime] NULL CONSTRAINT [DF_ZL_Pub_PubCreateTime]  DEFAULT (getdate()),
[PubLoginUrl] [nvarchar](255) NULL,
[PubOpenComment] [int] NULL,
[PubEndTime] [datetime] NULL,
[PubIsDel] [int] NULL CONSTRAINT [DF_ZL_Pub_PubIsDel]  DEFAULT (0),
[PubTimeSlot] [int] NULL CONSTRAINT [DF_ZL_Pub_PubTimeSlot]  DEFAULT (10),
[Pubkeep] [int] NULL CONSTRAINT [DF_ZL_Pub_Pubkeep]  DEFAULT (7),
[Puberrmsg] [nvarchar](1000) NULL,
[PubGourl] [nvarchar](1000) NULL,
[PubSiteID] [int] NULL CONSTRAINT [DF_ZL_Pub_PubSiteID]  DEFAULT (0),
[Public] [int] NULL CONSTRAINT [DF_ZL_Pub_Public]  DEFAULT ((1)),
[PubPermissions] [nvarchar](255) NULL,
[Interval][nvarchar](20) NULL,
[PubFlag] [int] NULL,
 CONSTRAINT [PK_ZL_Pub] PRIMARY KEY CLUSTERED
(
[Pubid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'互动ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'Pubid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'互动名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'信息类别(0-内容 1-商城 2-黄页 3-店铺)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubClass'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'互动数据表名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubTableName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'互动类型(0-评论 1-投票 2-活动 3-留言 4-问券调查 5-通用统计)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否多条(0-无限制 1-每人限一条)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubOneOrMore'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'重复IP提交信息次数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubIPOneOrMore'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模板地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubTemplate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'调用字符' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubLoadstr'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模型ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubModelID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'系统节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubNodeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'黄页节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubTemplateID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'Pubinfo'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否需要审核(0-不需要 1-需要审核)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubIsTrue'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否需要验证码(0-不需要 1-需要)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否需要登陆(0-不需要 1-需要)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubLogin'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'参与人数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubAddnum'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'绑定互动' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubBindPub'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'投票显示方式(0-传统 1-柱状 2-圆形)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubShowType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'提交窗口模板' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubInputTM'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'调用提交窗口代码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubInputLoadStr'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubCreateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'设置登陆地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubLoginUrl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否开启评论' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubOpenComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'结束时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubEndTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否被删除 1-删除' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubIsDel'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'间隔时间，单位秒' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubTimeSlot'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'保留天数信息' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'Pubkeep'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新跳转地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubGourl'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'站点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'PubSiteID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'公开' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Pub', @level2type=N'COLUMN', @level2name=N'Public'

GO
SET IDENTITY_INSERT [ZL_Pub] ON
INSERT [ZL_Pub] ([Pubid],[PubName],[PubClass],[PubTableName],[PubType],[PubOneOrMore],[PubIPOneOrMore],[PubTemplate],[PubLoadstr],[PubModelID],[PubNodeID],[PubTemplateID],[PubIsTrue],[PubCode],[PubLogin],[PubAddnum],[PubBindPub],[PubShowType],[PubInputTM],[PubInputLoadStr],[PubCreateTime],[PubOpenComment],[PubEndTime],[PubIsDel],[PubTimeSlot],[Pubkeep],[Puberrmsg],[PubSiteID],[Public]) VALUES ( 2,N'文章投票',0,N'ZL_Pub_WZTP',3,0,0,N'/互动模板/默认留言文章投票模板.html',N'WZTP',17,N'0',N'0',0,0,0,6,0,0,N'/互动模板/默认留言文章投票提交模板.html',N'WZTP',N'2015-1-28 17:21:01',0,N'9999-12-31 23:59:59',0,10,99999999,N'该用户提交信息的数量已经达到上限!',0,1)
INSERT [ZL_Pub] ([Pubid],[PubName],[PubClass],[PubTableName],[PubType],[PubOneOrMore],[PubIPOneOrMore],[PubTemplate],[PubLoadstr],[PubModelID],[PubIsTrue],[PubCode],[PubLogin],[PubAddnum],[PubBindPub],[PubShowType],[PubInputTM],[PubInputLoadStr],[PubCreateTime],[PubOpenComment],[PubEndTime],[PubIsDel],[PubTimeSlot],[Pubkeep],[Puberrmsg],[PubSiteID],[Public]) VALUES ( 3,N'在线调查',6,N'ZL_Pub_ZXDC',4,0,0,N'/互动模板/默认问券在线调查模板.html',N'ZXDC',18,0,0,0,1,0,0,N'/互动模板/默认问券在线调查提交模板.html',N'ZXDC',N'2015-5-6 9:56:05',0,N'9999-12-31 23:59:59',0,10,99999999,N'该用户提交信息的数量已经达到上限!',0,1)
INSERT [ZL_Pub] ([Pubid],[PubName],[PubClass],[PubTableName],[PubType],[PubOneOrMore],[PubIPOneOrMore],[PubTemplate],[PubLoadstr],[PubModelID],[PubIsTrue],[PubCode],[PubLogin],[PubAddnum],[PubBindPub],[PubShowType],[PubInputTM],[PubInputLoadStr],[PubCreateTime],[PubOpenComment],[PubEndTime],[PubIsDel],[PubTimeSlot],[Pubkeep],[Puberrmsg],[PubSiteID],[Public]) VALUES ( 4,N'提问',5,N'ZL_Pub_TW',3,0,0,N'/互动模板/默认留言提问模板.html',N'TW',21,0,0,0,2,0,0,N'/互动模板/默认留言提问提交模板.html',N'TW',N'2015-5-7 19:01:33',0,N'9999-12-31 23:59:59',0,10,99999999,N'该用户提交信息的数量已经达到上限!',0,1)
INSERT [ZL_Pub] ([Pubid],[PubName],[PubClass],[PubTableName],[PubType],[PubOneOrMore],[PubIPOneOrMore],[PubTemplate],[PubLoadstr],[PubModelID],[PubIsTrue],[PubCode],[PubLogin],[PubAddnum],[PubBindPub],[PubShowType],[PubInputTM],[PubInputLoadStr],[PubCreateTime],[PubOpenComment],[PubEndTime],[PubIsDel],[PubTimeSlot],[Pubkeep],[Puberrmsg],[PubSiteID],[Public]) VALUES ( 5,N'问题回答',0,N'ZL_Pub_WTHD',0,0,0,N'/互动模板/默认评论问题回答模板.html',N'WTHD',22,0,0,0,1,0,0,N'/互动模板/默认评论问题回答提交模板.html',N'WTHD',N'2015-5-7 19:01:52',0,N'9999-12-31 23:59:59',0,10,99999999,N'该用户提交信息的数量已经达到上限!',0,1)
INSERT [ZL_Pub] ([Pubid],[PubName],[PubClass],[PubTableName],[PubType],[PubOneOrMore],[PubIPOneOrMore],[PubTemplate],[PubLoadstr],[PubModelID],[PubIsTrue],[PubCode],[PubLogin],[PubAddnum],[PubBindPub],[PubShowType],[PubInputTM],[PubInputLoadStr],[PubCreateTime],[PubOpenComment],[PubEndTime],[PubIsDel],[PubTimeSlot],[Pubkeep],[Puberrmsg],[PubSiteID],[Public]) VALUES ( 6,N'最佳答案',0,N'ZL_Pub_ZJDA',0,0,0,N'/互动模板/默认评论最佳答案模板.html',N'ZJDA',23,0,0,0,0,0,0,N'/互动模板/默认评论最佳答案提交模板.html',N'ZJDA',N'2015-5-7 19:02:04',0,N'9999-12-31 23:59:59',0,10,99999999,N'该用户提交信息的数量已经达到上限!',0,1)
SET IDENTITY_INSERT [ZL_Pub] OFF

GO
CREATE TABLE [dbo].[ZL_Pub_Excel] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[TableName] [nvarchar]  (50) NULL,
[CNames] [ntext]  NULL,
[Fields] [ntext]  NULL,
[UserID] [int]  NULL,
[CreateTime] [datetime]  NULL)
ALTER TABLE [ZL_Pub_Excel] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_Pub_Excel] PRIMARY KEY  NONCLUSTERED ( [ID] )

GO
CREATE TABLE [dbo].[ZL_Question](
[Qid] [int] IDENTITY(1,1) NOT NULL,
[Surveyid] [int] NOT NULL,
[Typeid] [int] NULL CONSTRAINT [DF_ZL_Question_Typeid]  DEFAULT (1),
[Qtitle] [nvarchar](500) NULL,
[Qcontent] [text] NULL,
[Orderid] [int] NULL CONSTRAINT [DF_ZL_Question_Orderid]  DEFAULT (0),
[QuestionCreateTime] [datetime] NULL CONSTRAINT [DF_ZL_Question_QuestionCreateTime]  DEFAULT (getdate()),
[IsNull] [bit] Null,
[Qoption] [nvarchar](4000) NULL,
 CONSTRAINT [PK_ZL_Question] PRIMARY KEY CLUSTERED 
(
[Qid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Result](
[ID] [int] IDENTITY(1,1) NOT NULL,
[Result] [varchar](2000) NULL,
[ResultTime] [datetime] NULL,
[ProblemID] [int] NULL,
[UserID] [int] NULL,
 CONSTRAINT [PK_ZL_Result] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'答案' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Result', @level2type=N'COLUMN', @level2name=N'Result'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'回答时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Result', @level2type=N'COLUMN', @level2name=N'ResultTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'问题ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Result', @level2type=N'COLUMN', @level2name=N'ProblemID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Result', @level2type=N'COLUMN', @level2name=N'UserID'



GO
CREATE TABLE [dbo].[ZL_Role](
[RoleID] [int] IDENTITY(1,1) NOT NULL,
[RoleName] [nvarchar](50) NOT NULL,
[Description] [nvarchar](255) NULL,
[NodeID] [int] NULL,
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'角色ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Role', @level2type=N'COLUMN', @level2name=N'RoleID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'角色名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Role', @level2type=N'COLUMN', @level2name=N'RoleName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'角色描述' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Role', @level2type=N'COLUMN', @level2name=N'Description'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'角色所属节点' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Role', @level2type=N'COLUMN', @level2name=N'NodeID'

GO
CREATE TABLE [dbo].[ZL_RolePermissions](
[RoleID] [int] NOT NULL,
[OperateCode] [nvarchar](50) NOT NULL,
[NodeID] [int] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'操作代码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RolePermissions', @level2type=N'COLUMN', @level2name=N'OperateCode'

GO
CREATE TABLE [dbo].[ZL_RoomActive](
[AID] [int] IDENTITY(1,1) NOT NULL,
[ActiveUserID] [int] NULL,
[ActiveTitle] [nvarchar](225) NULL,
[ActiveContext] [nvarchar](4000) NULL,
[ActiveStateTime] [datetime] NULL,
[ActiveEndTime] [datetime] NULL,
[ActiveAddTime] [datetime] NULL,
[ActivePic] [nvarchar](200) NULL,
[RoomID] [int] NULL,
 CONSTRAINT [PK_Active] PRIMARY KEY CLUSTERED 
(
[AID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动发起人' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActiveUserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActiveTitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActiveContext'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动开始时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActiveStateTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动结束时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActiveEndTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActiveAddTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动图片' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'ActivePic'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'班级ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActive', @level2type=N'COLUMN', @level2name=N'RoomID'

GO
CREATE TABLE [dbo].[ZL_RoomActiveJoin](
[ID] [int] IDENTITY(1,1) NOT NULL,
[ActiveID] [int] NULL,
[UserID] [int] NULL,
[UserName] [nvarchar](255) NULL,
[AddTime] [datetime] NULL,
CONSTRAINT [PK_ZL_RoomActiveJoin] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'活动ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActiveJoin', @level2type=N'COLUMN', @level2name=N'ActiveID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'参与用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActiveJoin', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActiveJoin', @level2type=N'COLUMN', @level2name=N'UserName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomActiveJoin', @level2type=N'COLUMN', @level2name=N'AddTime'

GO
CREATE TABLE [dbo].[ZL_RoomMessage](
[ID] [int] IDENTITY(1,1) NOT NULL,
[SendID] [int] NULL,
[InceptID] [int] NULL,
[Mcontent] [text] NULL,
[Addtime] [datetime] NULL,
[RestoreID] [int] NULL,
[State] [int] NULL,
CONSTRAINT [PK_ZL_RoomMessage] PRIMARY KEY CLUSTERED 
(
[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'留言者' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomMessage', @level2type=N'COLUMN', @level2name=N'SendID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'被留言者' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomMessage', @level2type=N'COLUMN', @level2name=N'InceptID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomMessage', @level2type=N'COLUMN', @level2name=N'Mcontent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomMessage', @level2type=N'COLUMN', @level2name=N'Addtime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'回复ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomMessage', @level2type=N'COLUMN', @level2name=N'RestoreID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0为正常 1为删除' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomMessage', @level2type=N'COLUMN', @level2name=N'State'

GO
CREATE TABLE [dbo].[ZL_RoomNotify](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[NotifyTitle] [nvarchar](200) NULL,
	[NotifyContext] [nvarchar](1000) NULL,
	[AddTime] [datetime] NULL,
	[RoomID] [int] NULL,
	[UserID] [int] NULL,
 CONSTRAINT [PK_RoomNotify] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'通知标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomNotify', @level2type=N'COLUMN', @level2name=N'NotifyTitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'通知内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomNotify', @level2type=N'COLUMN', @level2name=N'NotifyContext'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomNotify', @level2type=N'COLUMN', @level2name=N'AddTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'班级ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomNotify', @level2type=N'COLUMN', @level2name=N'RoomID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomNotify', @level2type=N'COLUMN', @level2name=N'UserID'

GO
CREATE TABLE [dbo].[ZL_RoomUpFile](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[FileName] [nvarchar](100) NULL,
	[UpFileUrl] [nvarchar](300) NULL,
	[Course] [nvarchar](10) NULL,
	[UserType] [int] NULL,
	[FileType] [int] NULL,
	[UserID] [int] NULL,
	[RoomID] [int] NULL,
	[UpDateTime] [datetime] NULL,
	[FileState] [int] NULL,
 CONSTRAINT [PK_ZL_RoomUpFile] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'文件名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'FileName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'上传路径' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'UpFileUrl'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'课程' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'Course'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户类别 1：老师，2：学生' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'UserType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'上传文件类型 1：试题，2：作业' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'FileType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'班级ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'RoomID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'上传时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'UpDateTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'文件状态 1：可下载，2：不可下载：3：待审核' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_RoomUpFile', @level2type=N'COLUMN', @level2name=N'FileState'


GO
CREATE TABLE [dbo].[ZL_Scheme](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SName] [nvarchar](255) NULL,
	[SStartTime] [datetime] NULL,
	[SEndTime] [datetime] NULL,
	[SList] [nvarchar](50) NULL,
	[SAddTime] [datetime] NULL,
	[SType] [int] NULL,
 CONSTRAINT [PK_ZL_Scheme] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'方案名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Scheme', @level2type=N'COLUMN', @level2name=N'SName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'方案有效期开始时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Scheme', @level2type=N'COLUMN', @level2name=N'SStartTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'方案有效期结束时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Scheme', @level2type=N'COLUMN', @level2name=N'SEndTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'方案商品列表' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Scheme', @level2type=N'COLUMN', @level2name=N'SList'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Scheme', @level2type=N'COLUMN', @level2name=N'SAddTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'打折类型，1：按商品分类，2：按商品类型分类' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Scheme', @level2type=N'COLUMN', @level2name=N'SType'


GO
CREATE TABLE [dbo].[ZL_SchemeInfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SIULimit] [int] NULL,
	[SILLimit] [int] NULL,
	[SIAgio] [int] NULL,
	[SID] [int] NULL,
	[SIAddTime] [datetime] NULL,
 CONSTRAINT [PK_ZL_SchemeInfo] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'数量上限' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_SchemeInfo', @level2type=N'COLUMN', @level2name=N'SIULimit'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'数量下限' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_SchemeInfo', @level2type=N'COLUMN', @level2name=N'SILLimit'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'折扣' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_SchemeInfo', @level2type=N'COLUMN', @level2name=N'SIAgio'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'方案ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_SchemeInfo', @level2type=N'COLUMN', @level2name=N'SID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_SchemeInfo', @level2type=N'COLUMN', @level2name=N'SIAddTime'


GO
CREATE TABLE [dbo].[ZL_School](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SchoolName] [nvarchar](255) NULL,
	[Country] [nvarchar](255) NULL,
	[Province] [nvarchar](255) NULL,
	[SchoolType] [int] NULL,
	[Visage] [int] NULL,
	[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_School_Addtime]  DEFAULT (getdate()),
	[SchoolInfo] [ntext] NULL,
 CONSTRAINT [PK_ZL_School] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学校名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'SchoolName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'国家' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'Country'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'省份' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'Province'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学校类型(1-小学 2-中学 3-大学 4-其他)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'SchoolType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学校面貌(1-公办 2-私立)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'Visage'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'Addtime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'学校说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_School', @level2type=N'COLUMN', @level2name=N'SchoolInfo'

GO
CREATE TABLE [dbo].[ZL_ServiceSeat](
	[S_ID] [int] IDENTITY(1,1) NOT NULL,
	[S_Name] [nvarchar](50) NULL,
	[S_AdminID] [int] NULL,
	[S_DateTime] [nvarchar](50) NULL,
	[S_Index] [int] NULL,
	[S_Remrk] [nvarchar](500) NULL,
	[S_Default] [int] NULL,
	[S_FaceImg] [nvarchar](500) NULL,
 CONSTRAINT [PK_ZL_ServiceSeat] PRIMARY KEY CLUSTERED 
(
	[S_ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'席位名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ServiceSeat', @level2type=N'COLUMN', @level2name=N'S_Name'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'管理员编号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ServiceSeat', @level2type=N'COLUMN', @level2name=N'S_AdminID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'设置时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ServiceSeat', @level2type=N'COLUMN', @level2name=N'S_DateTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'显示索引' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ServiceSeat', @level2type=N'COLUMN', @level2name=N'S_Index'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ServiceSeat', @level2type=N'COLUMN', @level2name=N'S_Remrk'


GO
CREATE TABLE [dbo].[ZL_ShopCommentary](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ComType] [int] NULL,
	[Comtitle] [nvarchar](255) NULL,
	[Storeid] [int] NULL,
	[CUserid] [int] NULL,
	[COrderid] [int] NULL,
	[ComContent] [ntext] NULL,
	[ComUser] [nvarchar](100) NULL,
	[Proid] [int] NULL,
	[ProName] [nvarchar](255) NULL,
	[Istopic] [bit] NOT NULL,
	[Putip] [nvarchar](255) NULL,
	[Addtime] [datetime] NULL,
	[ComOption] [int] NULL,
	[Istrue] [bit] NULL,
	[Comid] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论类型 商品评论=0;用户评论=1;交易评论=2' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'ComType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论标题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Comtitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'受评店铺ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Storeid'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'受评论用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'CUserid'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'受评论交易ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'COrderid'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'ComContent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发表用户' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'ComUser'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Proid'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'ProName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否为话题 0-非话题　1-话题' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Istopic'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发布IP地址' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Putip'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发布时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Addtime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'评论选项：好评，中评，差评' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'ComOption'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'所属评论ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopCommentary', @level2type=N'COLUMN', @level2name=N'Comid'

GO
CREATE TABLE [dbo].[ZL_ShopGrade](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[GradeName] [nvarchar](255) NULL,
	[Gradeimg] [nvarchar](255) NULL,
	[CommentNum] [int] NOT NULL,
	[OtherName] [nvarchar](255) NULL,
	[Istrue] [bit] NULL,
	[GradeType] [int] NOT NULL,
	[Imgnum] [int] NULL
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'等级名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'GradeName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'等级图片' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'Gradeimg'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'积分' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'CommentNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'等级别名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'OtherName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'启用状态' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'Istrue'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'等级类型 0-购物等级,1-卖家等级,2-商户等级' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'GradeType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'图片数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopGrade', @level2type=N'COLUMN', @level2name=N'Imgnum'

GO
CREATE TABLE [dbo].[ZL_ShopLable](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[LableName] [nvarchar](255) NULL,
	[LableType] [int] NULL,
	[LableContent] [ntext] NULL,
	[LableInfo] [nvarchar](255) NULL,
	[IsTrue] [bit] NULL,
	[LableClass] [nvarchar](50) NULL,
	[Separator] [nvarchar](255) NULL CONSTRAINT [DF_ZL_ShopLable_Separator]  DEFAULT (''),
	[Initial] [int] NULL CONSTRAINT [DF_ZL_ShopLable_Initial]  DEFAULT (1),
	[Derive] [nvarchar](255) NULL,
	[Fildsinfo] [nvarchar](1000) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标签名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'LableName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标签类型(0-用户标签 1-系统标签)' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'LableType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标签内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'LableContent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标签说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'LableInfo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否启用' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'IsTrue'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标签种类' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'LableClass'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分割符' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'Separator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'初始计算值' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'Initial'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'派生标签' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'Derive'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'参数说明' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopLable', @level2type=N'COLUMN', @level2name=N'Fildsinfo'

GO
CREATE TABLE [dbo].[ZL_ShopNodeinfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Nodeid] [int] NULL,
	[NodeName] [nvarchar](255) NULL,
	[Incorporation] [bit] NOT NULL,
	[Auction] [bit] NOT NULL,
	[Warehouse] [bit] NOT NULL,
	[Comment] [bit] NOT NULL,
	[PageNum] [int] NOT NULL,
	[ShowType] [int] NOT NULL,
	[Anonymity] [bit] NOT NULL,
	[Pointcard] [bit] NOT NULL,
	[Dummymoney] [bit] NOT NULL
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Nodeid'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'节点名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'NodeName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许发布团购' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Incorporation'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许发布竞拍' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Auction'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许自动上架' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Warehouse'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许评论' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Comment'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'每页显示数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'PageNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'默认显示模式 0-列表，1-平铺，2-文字' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'ShowType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许匿名购买' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Anonymity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许使用点卡' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Pointcard'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许使用虚拟货币' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_ShopNodeinfo', @level2type=N'COLUMN', @level2name=N'Dummymoney'

 

GO
CREATE TABLE [dbo].[ZL_Shopconfig](
	[IsOpen] [bit] NOT NULL,
	[BankInfo] [ntext] NULL,
	[Anonymity] [bit] NOT NULL,
	[Pointcard] [bit] NOT NULL,
	[Dummymoney] [bit] NOT NULL,
	[Comment] [bit] NOT NULL,
	[Goodpl] [int] NULL,
	[Centerpl] [int] NULL,
	[Badpl] [int] NULL,
	[Auditing] [int] NULL CONSTRAINT [DF_ZL_Shopconfig_Auditing]  DEFAULT (0),
	[ScorePoint] [int] NULL DEFAULT (0),
	[ChangeOrder] [bit] NUll
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'启用多用户商城' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'IsOpen'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'银行接口信息' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'BankInfo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许匿名购买' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'Anonymity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许使用点卡' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'Pointcard'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许使用虚拟货币' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'Dummymoney'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'允许评论' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'Comment'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'赠送积分折算率（%）' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopconfig', @level2type=N'COLUMN', @level2name=N'ScorePoint'


GO
CREATE TABLE [dbo].[ZL_Shopsearch](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Searchkey] [nvarchar](255) NULL,
	[SearchNum] [int] NULL,
	[Commend] [int] NULL,
	[SearchTime] [datetime] NULL,
	[Class] [nvarchar](255) NULL,
	[Showtop] [bit] NULL
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'搜索关键字' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopsearch', @level2type=N'COLUMN', @level2name=N'Searchkey'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'搜索次数' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopsearch', @level2type=N'COLUMN', @level2name=N'SearchNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'推荐关键字' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopsearch', @level2type=N'COLUMN', @level2name=N'Commend'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'搜索时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopsearch', @level2type=N'COLUMN', @level2name=N'SearchTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分类' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Shopsearch', @level2type=N'COLUMN', @level2name=N'Class'

GO
CREATE TABLE [dbo].[ZL_Sns_Active](
	[ID] [uniqueidentifier] NOT NULL,
	[UserID] [int] NULL,
	[ActiveManage] [uniqueidentifier] NULL,
	[ActiveTitle] [varchar](100) NULL,
	[TypeID] [uniqueidentifier] NULL,
	[ActiveStarttime] [datetime] NULL,
	[ActiveEndtime] [datetime] NULL,
	[ActiveAddress] [varchar](100) NULL,
	[ActiveContent] [text] NULL,
	[ActiveJoinType] [int] NULL,
	[ActiveOther] [int] NULL,
	[ActiveAddtime] [datetime] NULL,
	[ActivePic] [varchar](100) NULL,
 CONSTRAINT [PK_ZL_Sns_Active] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_ActiveJoin](
	[ID] [uniqueidentifier] NOT NULL,
	[ActiveID] [uniqueidentifier] NULL,
	[UserID] [int] NULL,
	[JoinState] [int] NULL,
	[JoinAddtime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Sns_ActiveJoin] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_ActivePic](
	[ID] [uniqueidentifier] NOT NULL,
	[ActiveID] [uniqueidentifier] NULL,
	[PicUrl] [varchar](100) NULL,
	[PicAddtime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Sns_ActivePic] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



GO
CREATE TABLE [dbo].[ZL_Sns_ActiveType](
	[ID] [uniqueidentifier] NOT NULL,
	[TypeName] [varchar](20) NULL,
 CONSTRAINT [PK_ZL_Sns_ActiveType] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_Sns_BlogStyleTable](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StyleName] [varchar](50) NULL,
	[Author] [varchar](50) NULL,
	[StylePic] [varchar](255) NULL,
	[Addtime] [datetime] NULL,
	[StyleState] [int] NULL,
	[UserIndexStyle] [varchar](255) NULL,
	[LogStyle] [varchar](255) NULL,
	[LogShowStyle] [varchar](255) NULL,
	[PhotoStyle] [varchar](255) NULL,
	[PhotoShowStyle] [varchar](255) NULL,
	[PicShowStyle] [varchar](255) NULL,
	[GroupStyle] [varchar](255) NULL,
	[GroupShowStyle] [varchar](255) NULL,
	[GroupTopicShow] [varchar](255) NULL,
 CONSTRAINT [PK_ZL_Sns_BlogStyleTable] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_Sns_BookTable](
	[ID] [uniqueidentifier] NOT NULL,
	[BookTitle] [varchar](100) NULL,
	[BookOtherTitle] [varchar](100) NULL,
	[BookAnthor] [varchar](20) NULL,
	[BookIsbn] [varchar](100) NULL,
	[BookPrice] [smallmoney] NULL,
	[BookConcerm] [varchar](100) NULL,
	[BookYear] [varchar](10) NULL,
	[Bookurl] [varchar](100) NULL,
	[BookContent] [text] NULL,
	[BookState] [int] NULL,
	[BookAddtime] [datetime] NULL,
	[Uid] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_BookTable] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_Sns_CarConfig](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CKey] [varchar](50) NULL,
	[Ctext] [varchar](100) NULL,
	[Cvalue] [varchar](100) NULL,
 CONSTRAINT [PK_ZL_Sns_CarConfig] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_CarLog](
	[Plid] [int] IDENTITY(1,1) NOT NULL,
	[P_uid] [int] NULL CONSTRAINT [DF_ZL_Sns_CarLog_P_uid]  DEFAULT (null),
	[P_type] [int] NULL CONSTRAINT [DF_ZL_Sns_CarLog_P_type]  DEFAULT (null),
	[P_content] [varchar](500) NULL,
	[P_introtime] [datetime] NULL CONSTRAINT [DF_ZL_Sns_CarLog_P_introtime]  DEFAULT (null),
 CONSTRAINT [PK_ZL_Sns_CarLog] PRIMARY KEY NONCLUSTERED 
(
	[Plid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_Carlist](
	[Pid] [int] IDENTITY(1,1) NOT NULL,
	[P_car_name] [varchar](50) NULL,
	[P_car_num] [int] NULL CONSTRAINT [DF_ZL_Sns_Carlist_P_car_num]  DEFAULT (0),
	[P_car_surplus] [int] NULL,
	[P_car_money] [int] NULL,
	[P_car_old] [int] NULL,
	[P_car_img] [varchar](100) NULL,
	[P_car_img_logo] [varchar](100) NULL,
	[P_car_content] [varchar](500) NULL,
	[P_car_check] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_Carlist] PRIMARY KEY NONCLUSTERED 
(
	[Pid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_ChatLog](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NULL,
	[Sex] [varchar](50) NULL,
	[ChatContent] [ntext] NULL,
	[Addtime] [datetime] NULL,
	[ByID] [int] NULL,
	[ChatType] [varchar](50) NULL,
 CONSTRAINT [PK_ZL_Sns_ChatLog] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_CollectTable](
	[ID] [uniqueidentifier] NOT NULL,
	[UserID] [int] NULL,
	[CbyID] [uniqueidentifier] NULL,
	[Cbytype] [int] NULL,
	[Cstate] [int] NULL,
	[CAddtime] [datetime] NULL,
	[LabelName] [text] NULL,
 CONSTRAINT [PK_ZL_Sns_CollectTable] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_CommendCommentOn](
	[ID] [uniqueidentifier] NOT NULL,
	[CommentOnUserID] [int] NULL,
	[CommentOnContext] [varchar](3000) NULL,
	[CommentOnTime] [datetime] NULL,
	[CommentID] [uniqueidentifier] NULL,
 CONSTRAINT [PK_ZL_Sns_CommendCommentOn] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_Sns_CommentAll](
	[ID] [uniqueidentifier] NOT NULL,
	[Ctitle] [varchar](100) NULL,
	[UserID] [int] NULL,
	[Ccontent] [text] NULL,
	[CbyID] [uniqueidentifier] NULL,
	[Caddtime] [datetime] NULL,
	[CbyType] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_CommentAll] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_FileShare](
	[ID] [uniqueidentifier] NOT NULL,
	[UserID] [int] NULL,
	[FactFileName] [varchar](50) NULL,
	[BuildFileName] [varchar](50) NULL,
	[FileURL] [varchar](200) NULL,
	[DownCount] [int] NULL,
	[CreatTime] [datetime] NULL,
	[FileSize] [int] NULL,
	[GSID] [uniqueidentifier] NULL,
	[Mono] [varchar](50) NULL,
 CONSTRAINT [PK_ZL_Sns_FileShare] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_GSHuatee](
	[ID] [uniqueidentifier] NOT NULL,
	[GSID] [uniqueidentifier] NULL,
	[UserID] [int] NULL,
	[ReadCount] [int] NULL,
	[RevertCount] [int] NULL,
	[HuaTeeContent] [varchar](2000) NULL,
	[HuaTeeTitle] [varchar](50) NULL,
	[CreatTime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Sns_GSHuatee] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_GSReverCricicism](
	[ID] [uniqueidentifier] NOT NULL,
	[HuaTeePicID] [uniqueidentifier] NULL,
	[UserID] [int] NULL,
	[Content] [varchar](200) NULL,
	[CreatTime] [datetime] NULL,
	[Flage] [int] NULL,
	[Taxis] [int] NULL,
	[IsRead] [bit] NULL,
 CONSTRAINT [PK_ZL_Sns_GSReverCricicism] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_LinkName](
	[ID] [int] IDENTITY(1,1) NOT FOR REPLICATION NOT NULL,
	[Linkname] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Lkeyword] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[Lwindows] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Lstate] [int] NULL,
 CONSTRAINT [PK_ZL_LinkName_1] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'链接名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_LinkName', @level2type=N'COLUMN', @level2name=N'Linkname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'关键字' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_LinkName', @level2type=N'COLUMN', @level2name=N'Lkeyword'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'链接状态' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_LinkName', @level2type=N'COLUMN', @level2name=N'Lstate'


GO
CREATE TABLE [dbo].[ZL_Sns_GSRoom](
	[ID] [uniqueidentifier] NULL,
	[GSID] [uniqueidentifier] NULL,
	[RoomSize] [float] NULL,
	[UseSize] [float] NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_AdZone](
	[ZoneID] [int] NOT NULL,
	[ZoneName] [nvarchar](100) NULL,
	[ZoneJSName] [nvarchar](100) NULL,
	[ZoneIntro] [nvarchar](255) NULL,
	[ZoneType] [int] NULL CONSTRAINT [DF_ZL_AdZone_ZoneType]  DEFAULT (0),
	[DefaultSetting] [bit] NOT NULL CONSTRAINT [DF_ZL_AdZone_DefaultSetting]  DEFAULT (1),
	[ZoneSetting] [nvarchar](255) NULL,
	[ZoneWidth] [int] NULL CONSTRAINT [DF_ZL_AdZone_ZoneWidth]  DEFAULT (0),
	[ZoneHeight] [int] NULL CONSTRAINT [DF_ZL_AdZone_ZoneHeight]  DEFAULT (0),
	[Active] [bit] NOT NULL CONSTRAINT [DF_ZL_AdZone_Active]  DEFAULT (0),
	[ShowType] [int] NULL CONSTRAINT [DF_ZL_AdZone_ShowType]  DEFAULT (0),
	[UpdateTime] [datetime] NOT NULL CONSTRAINT [DF_ZL_AdZone_UpdateTime]  DEFAULT (getdate()),
	[Sales] [int] NOT NULL,
 CONSTRAINT [PK_ZL_AdZone] PRIMARY KEY CLUSTERED 
(
	[ZoneID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JS文件名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ZoneJSName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'版位介绍' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ZoneIntro'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'版位类型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ZoneType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否默认设置' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'DefaultSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'具体自定义设置信息' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ZoneSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'版位宽度' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ZoneWidth'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'版位高度' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ZoneHeight'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否活动' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'Active'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'显示方式' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'ShowType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AdZone', @level2type=N'COLUMN', @level2name=N'UpdateTime'

GO
CREATE TABLE [dbo].[ZL_Sns_GSType](
	[ID] [uniqueidentifier] NULL,
	[GSTypeName] [varchar](30) NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_AddRessList](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[AddRessContext] [nvarchar](4000) NULL,
 CONSTRAINT [PK_ZL_AddRessList] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AddRessList', @level2type=N'COLUMN', @level2name=N'UserID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'通讯录内容' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AddRessList', @level2type=N'COLUMN', @level2name=N'AddRessContext'


GO
CREATE TABLE [dbo].[ZL_Sns_GatherStrain](
	[ID] [uniqueidentifier] NOT NULL,
	[UserID] [int] NULL,
	[GSName] [varchar](30) NULL,
	[GSIntro] [varchar](200) NULL,
	[GSType] [uniqueidentifier] NULL,
	[GSICO] [varchar](200) NULL,
	[Cryptonym] [bit] NULL,
	[IsPublic] [int] NULL,
	[CreatTime] [datetime] NULL,
	[GSstate] [int] NULL CONSTRAINT [DF_ZL_Sns_GatherStrain_GSstate]  DEFAULT (0),
 CONSTRAINT [PK_ZL_Sns_GatherStrain] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Advertisement](
	[ADID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[ADType] [int] NULL,
	[ADName] [nvarchar](100) NULL,
	[ImgUrl] [nvarchar](255) NULL,
	[ImgWidth] [int] NULL,
	[ImgHeight] [int] NULL,
	[FlashWmode] [int] NULL,
	[ADIntro] [ntext] NULL,
	[LinkUrl] [nvarchar](255) NULL,
	[LinkTarget] [int] NULL,
	[LinkAlt] [nvarchar](255) NULL,
	[Priority] [int] NULL,
	[Setting] [ntext] NULL,
	[CountView] [bit] NOT NULL,
	[Views] [int] NULL,
	[CountClick] [bit] NOT NULL,
	[Clicks] [int] NULL,
	[Passed] [bit] NOT NULL,
	[OverdueDate] [datetime] NULL,
	[ImgUrl1] [nvarchar](255) NULL,
	[ImgHeight1] [int] NULL,
	[ImgWidth1] [int] NULL,
	[LinkUrl1] [nvarchar](255) NULL,
	[LinkTarget1] [int] NULL,
	[LinkAlt1] [nvarchar](255) NULL,
	[ADIntro1] [ntext] NULL,
	[FlashWmode1] [int] NULL,
 CONSTRAINT [PK_ZL_Advertisement] PRIMARY KEY CLUSTERED 
(
	[ADID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_GroupPicCateg](
	[GroupID] [uniqueidentifier] NOT NULL,
	[CategID] [uniqueidentifier] NOT NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Answer](
	[Aid] [int] IDENTITY(1,1) NOT NULL,
	[Surveyid] [int] NOT NULL,
	[Qid] [int] NOT NULL,
	[Answercontent] [nvarchar](1000) NOT NULL,
	[Userid] [int] NULL,
	[Submitdate] [datetime] NULL,
	[Submitip] [varchar](50) NULL,
	[AnswerScore] [int] Null,
 CONSTRAINT [PK_ZL_Answer] PRIMARY KEY CLUSTERED 
(
	[Aid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_HomeCollocate](
	[ID] [uniqueidentifier] NOT NULL,
	[UserID] [int] NULL,
	[ShopID] [uniqueidentifier] NULL,
	[CLeft] [int] NULL,
	[CIndexZ] [int] NULL,
	[CTop] [int] NULL,
	[Addtime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Sns_HomeCollocate] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Answer_Recode](
	[Rid] [int] IDENTITY(1,1) NOT NULL,
	[Sid] [int] NOT NULL,
	[Userid] [int] NOT NULL,
	[Submitip] [varchar](50) ,
	[Submitdate] [datetime] NULL CONSTRAINT [DF_ZL_Answer_Recode_Submitdate]  DEFAULT (getdate()),
	[Status] [int] NOT NULL CONSTRAINT [DF_ZL_ZL_Answer_Recode_Status]  DEFAULT (0)
 CONSTRAINT [PK_ZL_ANSWER_RECODE] PRIMARY KEY CLUSTERED 
(
	[Rid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

 

GO
CREATE TABLE [dbo].[ZL_Sns_HomeHeadCollocate](
	[UserID] [int] NOT NULL,
	[UserHeadPic] [varchar](100) NULL,
	[UserLeft] [int] NULL,
	[UserIndexZ] [int] NULL,
	[UserTop] [int] NULL,
	[CohabitID] [uniqueidentifier] NULL,
	[CohabitHeadPic] [varchar](100) NULL,
	[CohabitLeft] [int] NULL,
	[CohabitIndexZ] [int] NULL,
	[CohabitTop] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_HomeHeadCollocate] PRIMARY KEY NONCLUSTERED 
(
	[UserID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_AuditingState](
	[stateCode] [int] NOT NULL,
	[stateName] [varchar](50) NOT NULL,
	[stateType] [varchar](50) NOT NULL,
 CONSTRAINT [PK_ZL_AuditingState] PRIMARY KEY CLUSTERED 
(
	[stateCode] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'状态名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AuditingState', @level2type=N'COLUMN', @level2name=N'stateName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'状态类型（是否是系统的）' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_AuditingState', @level2type=N'COLUMN', @level2name=N'stateType'
GO
INSERT [ZL_AuditingState] ([stateCode],[stateName],[stateType]) VALUES ( -3,N'草稿',N'自定义')
INSERT [ZL_AuditingState] ([stateCode],[stateName],[stateType]) VALUES ( -1,N'退稿',N'自定义')
INSERT [ZL_AuditingState] ([stateCode],[stateName],[stateType]) VALUES ( 11,N'初审',N'自定义')
INSERT [ZL_AuditingState] ([stateCode],[stateName],[stateType]) VALUES ( 12,N'二审',N'自定义')

GO
CREATE TABLE [dbo].[ZL_Sns_Log](
	[ID] [uniqueidentifier] NOT NULL,
	[LogType] [int] NULL,
	[LogContext] [varchar](2000) NULL,
	[LogTime] [datetime] NULL,
	[UserID] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_Log] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Author](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL CONSTRAINT [DF_ZL_Author_UserID]  DEFAULT (0),
	[Type] [nvarchar](50) NULL,
	[Name] [nvarchar](50) NULL,
	[Passed] [bit] NULL CONSTRAINT [DF_ZL_Author_Passed]  DEFAULT (0),
	[onTop] [bit] NULL CONSTRAINT [DF_ZL_Author_onTop]  DEFAULT (0),
	[IsElite] [bit] NULL CONSTRAINT [DF_ZL_Author_IsElite]  DEFAULT (0),
	[Hits] [int] NULL CONSTRAINT [DF_ZL_Author_Hits]  DEFAULT (0),
	[LastUseTime] [datetime] NULL CONSTRAINT [DF_ZL_Author_LastUseTime]  DEFAULT (getdate()),
	[TemplateID] [int] NULL CONSTRAINT [DF_ZL_Author_TemplateID]  DEFAULT (0),
	[Photo] [nvarchar](255) NULL,
	[Intro] [ntext] NULL,
	[Address] [nvarchar](50) NULL,
	[Tel] [nvarchar](50) NULL,
	[Fax] [nvarchar](50) NULL,
	[Mail] [nvarchar](50) NULL,
	[Email] [nvarchar](50) NULL,
	[ZipCode] [int] NULL,
	[HomePage] [nvarchar](50) NULL,
	[Im] [nvarchar](50) NULL,
	[Sex] [smallint] NULL CONSTRAINT [DF_ZL_Author_Sex]  DEFAULT (0),
	[BirthDay] [datetime] NULL,
	[Company] [nvarchar](50) NULL,
	[Department] [nvarchar](50) NULL,
 CONSTRAINT [PK_ZL_Author] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_Sns_LogCriticism](
	[ID] [uniqueidentifier] NOT NULL,
	[LogID] [uniqueidentifier] NULL,
	[UserID] [int] NULL,
	[CriticismConten] [varchar](2000) NULL,
	[CreatTime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Sns_LogCriticism] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Bbscate](
	[Cateid] [int] IDENTITY(1,1) NOT NULL,
	[CateName] [varchar](50) NOT NULL,
	[Catetype] [int] NULL CONSTRAINT [DF_ZL_Bbscate_Catetype]  DEFAULT (0),
 CONSTRAINT [PK_ZL_Bbscate] PRIMARY KEY CLUSTERED 
(
	[Cateid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Sns_LotMessage](
	[ID] [uniqueidentifier] NULL,
	[MessageContent] [text] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_Bbstips](
	[Tid] [int] IDENTITY(1,1) NOT NULL,
	[Parentid] [int] NOT NULL,
	[Cateid] [int] NOT NULL,
	[Userid] [int] NULL CONSTRAINT [DF_ZL_Bbstips_Userid]  DEFAULT (0),
	[Ttitle] [varchar](50) NULL,
	[Tcontent] [varchar](50) NULL,
	[Tipsclick] [int] NOT NULL CONSTRAINT [DF_ZL_Bbstips_Tipsclick]  DEFAULT (0),
	[Tipsdate] [datetime] NULL CONSTRAINT [DF_ZL_Bbstips_Tipsdate]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_Bbstips] PRIMARY KEY CLUSTERED 
(
	[Tid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



GO
CREATE TABLE [dbo].[ZL_Sns_LotNote](
	[ID] [uniqueidentifier] NOT NULL,
	[StartID] [uniqueidentifier] NULL,
	[EndID] [uniqueidentifier] NULL,
	[MessageID] [uniqueidentifier] NULL,
	[NoteType] [int] NULL,
 CONSTRAINT [PK_ZL_Sns_LotNote] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_BindPro](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BindProID] [int] NULL,
	[ProID] [int] NULL,
	[ProName] [nvarchar](255) NULL,
	[Jiage] [money] NULL CONSTRAINT [DF_ZL_BindPro_Jiage]  DEFAULT (0),
	[Pronum] [int] NULL CONSTRAINT [DF_ZL_BindPro_Pronum]  DEFAULT (0),
 CONSTRAINT [PK_ZL_BindPro] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'绑定商品ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BindPro', @level2type=N'COLUMN', @level2name=N'BindProID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品ID' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BindPro', @level2type=N'COLUMN', @level2name=N'ProID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品名称' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BindPro', @level2type=N'COLUMN', @level2name=N'ProName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'价格' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BindPro', @level2type=N'COLUMN', @level2name=N'Jiage'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品数量' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BindPro', @level2type=N'COLUMN', @level2name=N'Pronum'


GO
CREATE TABLE [dbo].[ZL_Sns_Memo](
	[ID] [uniqueidentifier] NOT NULL,
	[UserID] [int] NULL,
	[MemoTitle] [varchar](100) NULL,
	[MemoContext] [varchar](1000) NULL,
	[MemoTime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Sns_Memo] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_CallNode](
	[C_Nid] [int] IDENTITY(1,1) NOT NULL,
	[CName] [nvarchar](1000) NULL,
	[Ctype] [int] NULL,
 CONSTRAINT [PK_ZL_CallNode] PRIMARY KEY CLUSTERED 
(
	[C_Nid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO
CREATE TABLE [dbo].[ZL_PrintType](
	[PID] [int] IDENTITY(1,1) NOT NULL,
	[P_Name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[P_Ream] [nvarchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
	[P_PicLocality] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[P_AddTime] [datetime] NULL,
	[P_Mask] [int] NULL,
	[P_MaskUrl] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
	[P_Proportion] [nchar](10) COLLATE Chinese_PRC_CI_AS NULL,
	[P_ShopID] [int] NULL,
	[P_ShopType] [int] NULL,
 CONSTRAINT [PK_ZL_PrintType] PRIMARY KEY CLUSTERED 
(
	[PID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'显示图片' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_Ream'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'图片显示位置' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_PicLocality'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_AddTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'遮罩，1：单个遮罩，2：遮罩库' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_Mask'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'遮罩地址' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_MaskUrl'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'图片比例' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_Proportion'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'关联的商品ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_ShopID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否关联商品ID 1：关联，2：不关联' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_PrintType', @level2type=N'COLUMN', @level2name=N'P_ShopType'


GO
CREATE TABLE [dbo].[ZL_Print](
	[P_ID] [int] IDENTITY(1,1) NOT NULL,
	[P_Name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[P_UserID] [int] NULL,
	[P_Type_ID] [int] NULL,
	[P_Ream] [text] COLLATE Chinese_PRC_CI_AS NULL,
	[P_PID] [int] NULL,
	[P_AddTime] [datetime] NULL,
	[P_State] [int] NULL,
	[P_PrintUrl] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'作品名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_UserID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'打印类型' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_Type_ID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'合成内容' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_Ream'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商品ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_PID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_AddTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'状态 1，为打印，2为已打印' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_State'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'已生成打印文件' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Print', @level2type=N'COLUMN', @level2name=N'P_PrintUrl'


GO
CREATE TABLE [dbo].[ZL_UnionInfo](
	[U_ID] [int] IDENTITY(1,1) NOT NULL,
	[MainID] [int] NULL,
	[ChildID] [int] NULL,
	[GFID] [int] NULL,
	[FType] [int] NULL,
	[ISTYPE] [int] NULL,
	[addtime] [datetime] NULL,
	[SID] [int] NULL CONSTRAINT [DF_ZL_UnionInfo_SID]  DEFAULT (0),
 CONSTRAINT [PK_ZL_UnionInfo] PRIMARY KEY CLUSTERED 
(
	[U_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'主站节点ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UnionInfo', @level2type=N'COLUMN', @level2name=N'MainID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'主站节点ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UnionInfo', @level2type=N'COLUMN', @level2name=N'ChildID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'方案ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UnionInfo', @level2type=N'COLUMN', @level2name=N'GFID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'方案类型' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UnionInfo', @level2type=N'COLUMN', @level2name=N'FType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型1节点，2方案，3模型,4文章id,5标签ID,6子站节点，7子站模型,8子站文章id,9子站标签ID,10从表ID.11子站从表ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UnionInfo', @level2type=N'COLUMN', @level2name=N'ISTYPE'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'子站站点ID,主站ID为0' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UnionInfo', @level2type=N'COLUMN', @level2name=N'SID'

GO
CREATE TABLE [dbo].[ZL_IPpara](
	[IP_ID] [int] IDENTITY(1,1) NOT NULL,
	[class_ID] [int] NULL,
	[pro_name] [nvarchar](255) NULL,
	[city_name] [nvarchar](255) NULL,
	[startIP] [int] NULL,
	[endIp] [int] NULL,
 CONSTRAINT [PK_ZL_IPpara] PRIMARY KEY CLUSTERED 
(
	[IP_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'此IP段所属分类ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IPpara', @level2type=N'COLUMN', @level2name=N'class_ID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'此IP段所属省级名' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IPpara', @level2type=N'COLUMN', @level2name=N'pro_name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'此IP段所属城市名' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IPpara', @level2type=N'COLUMN', @level2name=N'city_name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'此IP段起始IP' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IPpara', @level2type=N'COLUMN', @level2name=N'startIP'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'此IP段结束IP' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IPpara', @level2type=N'COLUMN', @level2name=N'endIp'

GO
CREATE TABLE [dbo].[ZL_IPUrl](
	[Url_ID] [int] IDENTITY(1,1) NOT NULL,
	[Url] [nvarchar](255) NULL,
	[class_ID] [int] NULL,
	[Node_ID] [int] NULL,
 CONSTRAINT [PK_ZL_IPUrl] PRIMARY KEY CLUSTERED 
(
	[Url_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'此分类标识' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IPUrl', @level2type=N'COLUMN', @level2name=N'Url_ID'

GO
CREATE TABLE [dbo].[ZL_IPclass](
	[class_ID] [int] IDENTITY(1,1) NOT NULL,
	[leadto_ID] [int] NULL,
	[class_name] [nvarchar](255) NULL,
 CONSTRAINT [PK_ZL_IPclass] PRIMARY KEY CLUSTERED 
(
	[class_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_BossInfo](
	[nodeid] [int] IDENTITY(1,1) NOT NULL,
	[parentid] [int] NULL,
	[shoptype] [int] NULL,
	[userid] [int] NULL,
	[Childs] [int] NULL CONSTRAINT [DF_ZL_BossInfo_Childs]  DEFAULT ((0)),
	[CMoney] [money] NULL,
	[Province] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[city] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[CName] [nchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[Address] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[Agent] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[license] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[CTel] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[CInfo] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[ContractNum] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[AccountPeople] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[Bank] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[BankNum] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[AccountPeople2] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[Bank2] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[BankNum2] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[linkname] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[linksex] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[linkPositions] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[linktel] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[fax] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[PostCode] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[email] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[Documents] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[DocumentsNUm] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_BossInfo] PRIMARY KEY CLUSTERED 
(
	[nodeid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'省' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'Province'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'招商名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'CName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'法定代理人' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'Agent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'营业执照' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'license'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'代理商电话' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'CTel'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'公司介绍' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'CInfo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'合同协议号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'ContractNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'开户人' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'AccountPeople'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'开户银行' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'Bank'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'银行账号' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'BankNum'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'联系人姓名' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'linkname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'性别' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'linksex'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'联系人职务' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'linkPositions'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'联系电话' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'linktel'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'传真' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'fax'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'邮政编码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'PostCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'证件类型' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'Documents'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'证件类型号码' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_BossInfo', @level2type=N'COLUMN', @level2name=N'DocumentsNUm'


GO
CREATE TABLE [dbo].[ZL_MuPic](
	[P_id] [int] IDENTITY(1,1) NOT NULL,
	[p_pic1] [nvarchar](500) NULL,
	[p_pic2] [nvarchar](500) NULL,
	[p_tempid] [int] NULL,
	[p_picid] [nvarchar](500) NULL,
	[p_addtime] [datetime] NULL CONSTRAINT [DF_ZL_MuPic_p_addtime]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_MuPic] PRIMARY KEY CLUSTERED 
(
	[P_id] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'图片ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPic', @level2type=N'COLUMN', @level2name=N'P_id'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'大图' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPic', @level2type=N'COLUMN', @level2name=N'p_pic1'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'小图' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPic', @level2type=N'COLUMN', @level2name=N'p_pic2'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPic', @level2type=N'COLUMN', @level2name=N'p_tempid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'图片ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPic', @level2type=N'COLUMN', @level2name=N'p_picid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPic', @level2type=N'COLUMN', @level2name=N'p_addtime'

GO
CREATE TABLE [dbo].[ZL_MuProduct](
	[p_ID] [int] IDENTITY(1,1) NOT NULL,
	[p_Name] [nvarchar](50) NULL,
	[p_Type] [int] NULL,
	[p_DoublePage] [int] NULL,
	[p_IspageTemplate] [int] NULL,
	[p_num] [int] NULL CONSTRAINT [DF_ZL_MuProduct_p_num]  DEFAULT (0),
	[p_info] [ntext] NULL,
 CONSTRAINT [PK_ZL_MuProduct] PRIMARY KEY CLUSTERED 
(
	[p_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'产品ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_ID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'产品名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'产品类型' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_Type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否为双面' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_DoublePage'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'像册专用/公用Flex模板' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_IspageTemplate'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_num'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'说明' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuProduct', @level2type=N'COLUMN', @level2name=N'p_info'
 

GO
CREATE TABLE [dbo].[ZL_MuClass](
	[cl_ID] [int] IDENTITY(1,1) NOT NULL,
	[cl_PClass] [int] NULL,
	[cl_Name] [nvarchar](500) NULL,
	[cl_Num] [int] NULL CONSTRAINT [DF_ZL_MuC_cl_Num]  DEFAULT (0),
	[cl_GuiGe] [nvarchar](255) NULL,
	[cl_Paiban] [int] NULL CONSTRAINT [DF_ZL_MuClass_cl_Paiban]  DEFAULT (0),
	[cl_Class] [nvarchar](255) NULL,
 CONSTRAINT [PK_ZL_MuC] PRIMARY KEY CLUSTERED 
(
	[cl_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_ID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'产品ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_PClass'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_Num'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'规格' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_GuiGe'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排版分类' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_Paiban'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类类别' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuClass', @level2type=N'COLUMN', @level2name=N'cl_Class'
	
GO
CREATE TABLE [dbo].[ZL_MuPage](
	[U_PageID] [int] IDENTITY(1,1) NOT NULL,
	[U_PClass] [int] NULL,
	[U_Class] [int] NULL,
	[U_Pagenum] [int] NULL,
	[U_PageUrl] [nvarchar](255) NULL,
	[U_Xml] [ntext] NULL,
	[U_Tid] [int] NULL,
 CONSTRAINT [PK_ZL_MuPage] PRIMARY KEY CLUSTERED 
(
	[U_PageID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'产品分类' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPage', @level2type=N'COLUMN', @level2name=N'U_PClass'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPage', @level2type=N'COLUMN', @level2name=N'U_Class'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'页码' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPage', @level2type=N'COLUMN', @level2name=N'U_Pagenum'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分页默认图片' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPage', @level2type=N'COLUMN', @level2name=N'U_PageUrl'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'页面数据' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPage', @level2type=N'COLUMN', @level2name=N'U_Xml'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'礼品ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuPage', @level2type=N'COLUMN', @level2name=N'U_Tid'


	
GO
CREATE TABLE [dbo].[ZL_MuTemp](
	[Mu_ID] [int] IDENTITY(1,1) NOT NULL,
	[Mu_Class] [int] NULL,
	[Mu_Title] [nvarchar](255) NULL,
	[Mu_BackImg] [nvarchar](500) NULL,
	[Mu_Guige] [nvarchar](255) NULL,
	[Mu_UserChange] [int] NULL CONSTRAINT [DF_ZL_MuTemp_Mu_UserChange]  DEFAULT (0),
	[Mu_Xml] [ntext] NULL,
	[Mu_PageType] [int] NULL CONSTRAINT [DF_ZL_MuTemp_Mu_PageType]  DEFAULT (0),
	[Mu_ModelTemp] [int] NULL,
	[Mu_PClass] [int] NULL,
	[Mu_Num] [int] NULL CONSTRAINT [DF_ZL_MuTemp_Mu_Num]  DEFAULT (0),
 CONSTRAINT [PK_ZL_MuT] PRIMARY KEY CLUSTERED 
(
	[Mu_ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板ID' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_ID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板分类' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_Class'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_Title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'背景图片' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_BackImg'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'尺寸规格' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_Guige'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户是否允许修改' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_UserChange'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板内容' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_Xml'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'页面类型（大页，小页）' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_PageType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板类型（页面模板，成套模板）' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_ModelTemp'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'产品分类' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_PClass'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_MuTemp', @level2type=N'COLUMN', @level2name=N'Mu_Num'

GO
 CREATE TABLE [dbo].[ZL_Defray](
	[flow] [int] IDENTITY(1,1) NOT NULL,
	[Pay_name] [varchar](100) NULL,
	[Pay_intf] [varchar](100) NULL,
	[Client_id] [varchar](50) NOT NULL,
	[Title] [varchar](100) NULL,
	[money_code] [varchar](100) NULL,
	[number] [varchar](50) NULL,
 CONSTRAINT [PK_ZL_Defray] PRIMARY KEY CLUSTERED 
(
	[flow] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'方式名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Defray', @level2type=N'COLUMN', @level2name=N'Pay_name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'接品类型' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Defray', @level2type=N'COLUMN', @level2name=N'Pay_intf'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Defray', @level2type=N'COLUMN', @level2name=N'Client_id'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'身份标记' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Defray', @level2type=N'COLUMN', @level2name=N'Title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支持交易货币' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Defray', @level2type=N'COLUMN', @level2name=N'money_code'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支付手续费' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Defray', @level2type=N'COLUMN', @level2name=N'number'


GO
CREATE TABLE [dbo].[ZL_Client_Basic](
	[Flow] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[P_name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[P_alias] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Upper] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Area] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Calling] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Value] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Credit] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Importance] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Connection] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Group] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Source] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Phase] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Client_Type] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL CONSTRAINT [DF_ZL_Client_Basic_Client_Type]  DEFAULT (0),
	[Add_Date] [datetime] NULL CONSTRAINT [DF_Table_1_add_date]  DEFAULT (getdate()),
	[Add_Name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Unit_Name] [nvarchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Unit_Post] [nvarchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Unit_Title] [nvarchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Unit_Class] [nvarchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Unit_Operation] [nvarchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Unit_Address] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[Title] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[FPManID] [int] NULL,
 CONSTRAINT [PK_ZL_Client_Basic] PRIMARY KEY CLUSTERED 
(
	[Code] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'流水号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Flow'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户(企业)编号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Code'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'P_name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户别名' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'P_alias'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上级客户' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Upper'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'区域' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Area'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'行业' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Calling'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'价值评估' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Value'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'信用等级' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Credit'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'重要程度' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Importance'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'关系等级' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Connection'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户组别' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Group'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户来源' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Source'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'阶段' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Phase'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户类别(0为个人，1为企业)' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Client_Type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Add_Date'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'操作员' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Add_Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'单位名称' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Unit_Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'职位' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Unit_Post'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'称谓' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Unit_Title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属部门' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Unit_Class'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'负责业务' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Unit_Operation'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'单位地址' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Unit_Address'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Basic', @level2type=N'COLUMN', @level2name=N'Title'

GO
CREATE TABLE [dbo].[ZL_Client_Enterprise](
	[Flow] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[Bank_Open] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Bank_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Tax_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Co_Status] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Co_Size] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Co_Management] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Reg_Capital] [money] NULL,
	[Sales] [money] NULL,
	[Operation_Bound] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Homepage] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Message_Address] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Phone] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Fax_phone] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Add_Date] [dateTime] NULL,
	[ZipCodeW] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[country] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[province] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[city] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_Client_Enterprise] PRIMARY KEY CLUSTERED 
(
	[Code] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'企业编号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Code'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开户银行' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Bank_Open'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'银行帐号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Bank_Code'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'税号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Tax_Code'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'行业地位' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Co_Status'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'公司规模' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Co_Size'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'经营状态' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Co_Management'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'注册资本' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Reg_Capital'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'年销售额' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Sales'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'业务范围' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Operation_Bound'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'网址' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Enterprise', @level2type=N'COLUMN', @level2name=N'Homepage'

GO
CREATE TABLE [dbo].[ZL_Client_Penson](
	[Flow] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[Id_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS  NULL,
	[Sex] [char](1) COLLATE Chinese_PRC_CI_AS NULL,
	[Native] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Nation] [varchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Marriage] [char](1) COLLATE Chinese_PRC_CI_AS NULL,
	[Finish_School] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Cultrue_Love] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Sport_Love] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Life_Love] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FUN_Love] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Other_Love] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Birthday] [datetime] NULL,
	[Income] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Home_Circs] [nvarchar](100) COLLATE Chinese_PRC_CI_AS NULL,
	[Education] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Message_Address] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Work_Phone] [varchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Home_Phone] [varchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Fax_phone] [varchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Telephone] [varchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Little_Smart] [varchar](12) COLLATE Chinese_PRC_CI_AS NULL,
	[Homepage] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[QQ_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ICQ_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UC_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Email_Address] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[MSN_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[YaoHu_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Aim_Code] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ZipCodeW] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[country] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[province] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[city] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_Client_Penson] PRIMARY KEY CLUSTERED 
(
	[Code] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'客户编号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Code'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'性别（0为女，1为男，2为未知）' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Sex'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'籍贯' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Native'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'民族' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Nation'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'婚姻状况(0为未知，1为未婚，2为已婚，3为离异)' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Marriage'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'毕业学校' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Finish_School'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'文化爱好' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Cultrue_Love'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'体育爱好' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Sport_Love'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'生活爱好' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Life_Love'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'娱乐休闲爱好' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'FUN_Love'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'其他爱好' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Other_Love'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学历' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_Client_Penson', @level2type=N'COLUMN', @level2name=N'Education'

GO
CREATE TABLE [dbo].[ZL_MySubscription](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Reference_ID] [int] NULL,
	[Order_Time] [datetime] NULL,
	[Period] [int] NULL CONSTRAINT [DF_ZL_MySubscription_Period]  DEFAULT (1),
	[Start_Date] [datetime] NULL,
	[Order_Type] [int] NULL,
	[User_Name] [nvarchar](50) NULL,
	[Tel] [nvarchar](50) NULL,
	[Email] [nvarchar](50) NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_SubscriptionCount](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Title] [nvarchar](50) NOT NULL,
	[Classic] [nvarchar](50) NOT NULL,
	[Content] [nvarchar](225) NOT NULL,
	[Price] [decimal](18, 0) NOT NULL,
	[Send] [nvarchar](50) NOT NULL,
	[Logo] [nvarchar](50) NOT NULL,
	[UpdateTime] [datetime] NOT NULL,
	[Hits] [int] NOT NULL
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅的信息编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'Reference_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'Period'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅起始日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'Start_Date'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'信息订购状态,分为：关注；已定；退定' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'Order_Type'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅人（注册帐户名）' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'User_Name'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅人联系电话' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'Tel'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅内容接收邮箱' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_MySubscription', @level2type=N'COLUMN',@level2name=N'Email'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标题' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Title'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'分为：资讯、数据、报告、书刊、其他' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Classic'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'内容' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Content'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'价格' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Price'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'发送方式 ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Send'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'链接图片' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Logo'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'UpdateTime'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'关注度 设为0,根据订阅的人数来设' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SubscriptionCount', @level2type=N'COLUMN',@level2name=N'Hits'

GO
CREATE TABLE [dbo].[ZL_Sns_LookLog](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[userid] [int] NULL,
	[lookid] [int] NULL,
	[looktime] [datetime] NULL CONSTRAINT [DF_ZL_Sns_LookLog_looktime]  DEFAULT (getdate()),
	[lookip] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_Sns_LookLog] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'浏览用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_LookLog', @level2type=N'COLUMN',@level2name=N'userid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'被浏览的用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_LookLog', @level2type=N'COLUMN',@level2name=N'lookid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'浏览时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_LookLog', @level2type=N'COLUMN',@level2name=N'looktime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'浏览者Ip' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_LookLog', @level2type=N'COLUMN',@level2name=N'lookip'

GO
CREATE TABLE [dbo].[ZL_Bid](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Participation] [float] NULL,
	[Compliance] [float] NULL,
	[Successful] [float] NULL,
	[Website] [float] NULL,
 CONSTRAINT [PK_ZL_Bid] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'参与者分成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Bid', @level2type=N'COLUMN',@level2name=N'Participation'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'达标者分成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Bid', @level2type=N'COLUMN',@level2name=N'Compliance'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'中标者' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Bid', @level2type=N'COLUMN',@level2name=N'Successful'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'网站商分成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Bid', @level2type=N'COLUMN',@level2name=N'Website'

GO
CREATE TABLE [dbo].[ZL_BigLog](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[title] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[type] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[num] [int] NULL,
	[Cid] [int] NULL,
	[Ctime] [datetime] NULL CONSTRAINT [DF_ZL_BigLog_Ctime]  DEFAULT (getdate()),
	[userID] [int] NULL,
 CONSTRAINT [PK_ZL_BigLog] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'说明' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BigLog', @level2type=N'COLUMN',@level2name=N'title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BigLog', @level2type=N'COLUMN',@level2name=N'type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'金钱' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BigLog', @level2type=N'COLUMN',@level2name=N'num'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'内容ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BigLog', @level2type=N'COLUMN',@level2name=N'Cid'

GO
CREATE TABLE [dbo].[ZL_SettlementInfoList](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SettlementTitle] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[SettlementID] [nvarchar](2000) COLLATE Chinese_PRC_CI_AS NULL,
	[SettlementAllMoney] [money] NULL,
	[SuccessfulMoney] [money] NULL,
	[ComplianceMoney] [money] NULL,
	[ParticipantsMoney] [money] NULL,
	[WebSiteMoney] [money] NULL,
	[SettlementTime] [datetime] NULL CONSTRAINT [DF_ZL_SettlementInfoList_SettlementTime]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_SettlementInfoList] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结算标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'SettlementTitle'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'关联内容ID列表' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'SettlementID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结算总价格' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'SettlementAllMoney'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'中标者分成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'SuccessfulMoney'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'达标者分成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'ComplianceMoney'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'参与者分成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'ParticipantsMoney'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结算时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_SettlementInfoList', @level2type=N'COLUMN',@level2name=N'SettlementTime'

GO
CREATE TABLE [dbo].[ZL_ProjectsComments](
	[CommentsID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectsID] [int] NULL,
	[ProcessesID] [int] NOT NULL,
	[UserID] [int] NULL,
	[Rating] [int] NULL,
	[Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[CommentsDate] [datetime] NULL,
 CONSTRAINT [PK_ZL_ProjectsComments] PRIMARY KEY CLUSTERED 
(
	[CommentsID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评论ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'CommentsID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评论所属项目ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'ProjectsID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评论所属项目流程ID 为0时是对项目的评论而非对流程的评论' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'ProcessesID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评论者ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'UserID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'项目评分' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'Rating'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评论内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评论时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsComments', @level2type=N'COLUMN',@level2name=N'CommentsDate'

GO

CREATE TABLE [dbo].[ZL_Processes](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Info] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[OpjectID] [int] NULL,
	[Progress] [int] NULL,
	[IsComplete] [int] NULL,
	[CompleteTime] [datetime] NULL,
 CONSTRAINT [PK_ZL_Processes] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'项目流程ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'项目流程名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'项目流程简介' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'Info'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属项目ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'OpjectID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'项目当前进度 单位%' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'Progress'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否完成0-未完成 1-已完成' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'IsComplete'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'完成时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Processes', @level2type=N'COLUMN',@level2name=N'CompleteTime'

GO
CREATE TABLE [dbo].[ZL_ProjectBaseField](
	[FieldID] [int] IDENTITY(1,1) NOT NULL,
	[FieldName] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FieldAlias] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FieldTips] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Description] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[IsNotNull] [bit] NULL,
	[FieldType] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[OrderId] [int] NULL,
	[ShowList] [bit] NULL,
	[ShowWidth] [int] NULL,
	[NoEdit] [int] NULL,
 CONSTRAINT [PK_ZL_ProjectBaseField] PRIMARY KEY CLUSTERED 
(
	[FieldID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'FieldName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段别名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'FieldAlias'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段说明' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'FieldTips'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段描述' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'Description'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段允许空，1：允许，2：不允许' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'IsNotNull'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段类型' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'FieldType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'字段内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'OrderId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'列表显示。1：显示，2不显示' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'ShowList'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'显示列宽度' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'ShowWidth'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否允许修改' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectBaseField', @level2type=N'COLUMN',@level2name=N'NoEdit'

GO
CREATE TABLE [dbo].[ZL_ProjectsBase](
	[ProjectBaseID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectsID] [int] NULL,
 CONSTRAINT [PK_ZL_ProjectsBase] PRIMARY KEY CLUSTERED 
(
	[ProjectBaseID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'主键 ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsBase', @level2type=N'COLUMN',@level2name=N'ProjectBaseID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属项目ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ProjectsBase', @level2type=N'COLUMN',@level2name=N'ProjectsID'

GO
CREATE TABLE [dbo].[ZL_Sns_Kiss](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Title] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[Inputer] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Sendto] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Otherdel] [int] NULL,
	[Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[InputerID] [int] NULL,
	[SendtoID] [int] NULL,
	[SendTime] [datetime] NULL CONSTRAINT [DF_ZL_Sns_Kiss_SendTime]  DEFAULT (getdate()),
	[ReadTime] [datetime] NULL CONSTRAINT [DF_ZL_Sns_Kiss_ReadTime]  DEFAULT (getdate()),
	[IsRead] [int] NULL CONSTRAINT [DF_ZL_Sns_Kiss_IsRead]  DEFAULT (0),
 CONSTRAINT [PK_ZL_Sns_Kiss] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'秋波标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'Title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'作者' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'Inputer'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'目标' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'Sendto'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'对方删除' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'Otherdel'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'秋波内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'InputerID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'对方ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'SendtoID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'发送时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'SendTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'阅读时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'ReadTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否打开' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sns_Kiss', @level2type=N'COLUMN',@level2name=N'IsRead'
 
GO
CREATE TABLE [dbo].[ZL_Search](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](255) NOT NULL,
	[type] [int] NOT NULL,
	[linkType] [int] NULL,
	[state] [int] NULL,
	[linkState] [int] NULL,
	[OpenType] [int] NULL,
	[AdminID] [int] NULL,
	[time] [datetime] NULL,
	[fileUrl] [nvarchar](200) NULL,
	[ico] [nvarchar](200) NULL,
	[Size] [int] NULL,
	[Mobile] [int] NULL,
	[UserGroup] [varchar](8000) NULL,
	[EliteLevel] [int] NULL,
	[OrderID] [int] NULL,
 CONSTRAINT [PK_search] PRIMARY KEY CLUSTERED 
([ID] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

GO
CREATE TABLE [dbo].[ZL_IServer](
	[QuestionId] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[Title] [nvarchar](100) COLLATE Chinese_PRC_CI_AS NULL,
	[Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[Priority] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Type] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ReadCount] [int] NULL CONSTRAINT [DF_ZL_IServer_ReadCount]  DEFAULT (0),
	[SubTime] [datetime] NULL,
	[State] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[SolveTime] [datetime] NULL,
	[Path] [varchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[Root] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RootInfo] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RequestTime] [datetime] NOT NULL,
	[OrderType] [int] NULL CONSTRAINT [DF_ZL_IServer_OrderType]  DEFAULT (0),
 CONSTRAINT [PK_ZL_IServer] PRIMARY KEY CLUSTERED 
(
	[QuestionId] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'问题编号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'QuestionId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'发表问题用户编号' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'UserId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'标题' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'Title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'内容' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'优先级' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'Priority'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'Type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'已读次数' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'ReadCount'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'提交时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'SubTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'状态' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'State'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'解决时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'SolveTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'附件路径' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'Path'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'问题来源' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'Root'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'来源附件信息' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'RootInfo'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'希望解决时间' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_IServer', @level2type=N'COLUMN', @level2name=N'RequestTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订单ID(0-非订单)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServer', @level2type=N'COLUMN',@level2name=N'OrderType'

GO
CREATE TABLE [dbo].[ZL_IServerReply](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[QuestionId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[Title] [nvarchar](100) COLLATE Chinese_PRC_CI_AS NULL,
	[ReplyTime] [datetime] NULL,
	[Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[Path] [varchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[isRead] [int] NULL,
 CONSTRAINT [PK_ZL_IServerReply] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'回复编号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'Id'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'问题编号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'QuestionId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'回复人编号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'UserId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'Title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'回复时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'ReplyTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'回复内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'附件路径' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'Path'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否已读：0为未读,1为已读' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_IServerReply', @level2type=N'COLUMN',@level2name=N'isRead'

GO
CREATE TABLE [dbo].[ZL_Sensitivity](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[keyname] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[istrue] [int] NULL,
 CONSTRAINT [PK_ZL_Sensitivity] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'关键字' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sensitivity', @level2type=N'COLUMN',@level2name=N'keyname'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否启用' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Sensitivity', @level2type=N'COLUMN',@level2name=N'istrue'

GO
CREATE TABLE [dbo].[ZL_UserClass](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Classname] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Classid] [int] NULL,
	[Username] [nvarchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[Shopid] [int] NULL,
	[Orderid] [int] NULL,
	[Classinfo] [nvarchar](2000) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_UserClass] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserClass', @level2type=N'COLUMN',@level2name=N'Classname'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserClass', @level2type=N'COLUMN',@level2name=N'Classid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserClass', @level2type=N'COLUMN',@level2name=N'Username'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商铺ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserClass', @level2type=N'COLUMN',@level2name=N'Shopid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排列ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserClass', @level2type=N'COLUMN',@level2name=N'Orderid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类说明' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserClass', @level2type=N'COLUMN',@level2name=N'Classinfo'

GO
CREATE TABLE [dbo].[ZL_UserRegisterIP](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LimitTime] [int] NULL,
	[IsLimit] [int] NULL,
	[IsIPpart] [int] NULL,
	[BeginIP] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[EndIP] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_UserRegisterManage] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'限制间隔时间(单位为小时)' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserRegisterIP', @level2type=N'COLUMN', @level2name=N'LimitTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否限制(-----0为不限制-----其他为限制)' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserRegisterIP', @level2type=N'COLUMN', @level2name=N'IsLimit'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否设置受限IP段(------0为不设置------其他为设置)' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserRegisterIP', @level2type=N'COLUMN', @level2name=N'IsIPpart'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'受限起始IP' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserRegisterIP', @level2type=N'COLUMN', @level2name=N'BeginIP'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结束IP' ,@level0type=N'USER', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'ZL_UserRegisterIP', @level2type=N'COLUMN', @level2name=N'EndIP'

GO
CREATE TABLE [dbo].[ZL_Papers_System](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[p_name] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[p_type] [int] NOT NULL,
 CONSTRAINT [PK_Papers_System] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试卷名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Papers_System', @level2type=N'COLUMN',@level2name=N'p_name'

GO
CREATE TABLE [dbo].[ZL_Papers_User](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[p_name] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[p_type] [int] NOT NULL,
	[p_User] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NOT NULL,
 CONSTRAINT [PK_ZL_Papers_User] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试卷名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Papers_User', @level2type=N'COLUMN',@level2name=N'p_name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属分类' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Papers_User', @level2type=N'COLUMN',@level2name=N'p_type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Papers_User', @level2type=N'COLUMN',@level2name=N'p_User'

GO
CREATE TABLE [dbo].[ZL_Questions](
	[p_id] [int] IDENTITY(1,1) NOT NULL,
	[p_title] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[p_Difficulty] [int] NULL,
	[p_Class] [int] NULL,
	[p_Views] [int] NULL,
	[p_Inputer] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[p_Type] [int] NULL,
	[p_Knowledge] [int] NOT NULL,
	[p_Answer] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[p_Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[p_CreateTime] [datetime] NULL CONSTRAINT [DF_ZL_Questions_p_CreateTime]  DEFAULT (getdate()),
	[Paper_Id] [int] NOT NULL,
	[p_Order] [int] NULL CONSTRAINT [DF_ZL_Questions_p_Order]  DEFAULT (0)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试题标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'难度' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Difficulty'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Class'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'使用次数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Views'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'作者' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Inputer'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'题型' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'知识点' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Knowledge'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'答案' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Answer'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试题内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_CreateTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属试卷ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'Paper_Id'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试题排序' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions', @level2type=N'COLUMN',@level2name=N'p_Order'

GO
CREATE TABLE [dbo].[ZL_Questions_Class](
	[C_id] [int] IDENTITY(1,1) NOT NULL,
	[C_ClassName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[C_Classid] [int] NULL,
	[C_OrderBy] [int] NOT NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Class', @level2type=N'COLUMN',@level2name=N'C_ClassName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Class', @level2type=N'COLUMN',@level2name=N'C_Classid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Class', @level2type=N'COLUMN',@level2name=N'C_OrderBy'

GO
CREATE TABLE [dbo].[ZL_Questions_Knowledge](
	[k_id] [int] IDENTITY(1,1) NOT NULL,
	[k_name] [nvarchar](200) NOT NULL,
	[k_Class_id] [int] NOT NULL,
	[k_OrderBy] [int] NULL,
	[Status] [int] NULL,
	[Grade] [int] NULL,
	[IsSys] [int] NULL,
	[CDate] [datetime] NULL,
	[CUser] [int] NULL,
	[Pid] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'知识点' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Knowledge', @level2type=N'COLUMN',@level2name=N'k_name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属分类ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Knowledge', @level2type=N'COLUMN',@level2name=N'k_Class_id'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Knowledge', @level2type=N'COLUMN',@level2name=N'k_OrderBy'

GO
CREATE TABLE [dbo].[ZL_Questions_Type](
	[t_id] [int] IDENTITY(1,1) NOT NULL,
	[t_name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
 CONSTRAINT [PK_ZL_Questions_Type] PRIMARY KEY CLUSTERED 
(
	[t_id] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Type', @level2type=N'COLUMN',@level2name=N't_id'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'题型名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_Type', @level2type=N'COLUMN',@level2name=N't_name'

GO
CREATE TABLE [dbo].[ZL_Questions_User](
	[p_id] [int] IDENTITY(1,1) NOT NULL,
	[p_title] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[p_Difficulty] [int] NULL,
	[p_Class] [int] NULL,
	[p_Views] [int] NULL,
	[p_Inputer] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[p_Type] [int] NULL,
	[p_Knowledge] [int] NOT NULL,
	[p_Answer] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[p_Content] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[p_CreateTime] [datetime] NULL CONSTRAINT [DF_ZL_Questions_User_p_CreateTime]  DEFAULT (getdate()),
	[p_User] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[paper_Id] [int] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试题标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'难度' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Difficulty'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'分类' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Class'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'使用次数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Views'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'作者' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Inputer'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'题型' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'知识点' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Knowledge'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'答案' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Answer'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_Content'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_CreateTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'p_User'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属试卷ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Questions_User', @level2type=N'COLUMN',@level2name=N'paper_Id'

GO
CREATE TABLE [dbo].[ZL_Arrive](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ArriveNO] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UserID] [int] NULL,
	[MinAmount] [money]  NULL,
	[MaxAmount] [money]  NULL,
	[Amount] [money] NULL,
	[AgainTime] [datetime] NULL,
	[EndTime] [datetime] NULL,
	[State] [int] NULL,
	[ArriveName] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ArrivePwd] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
	[UseTime] [datetime] NULL,
	[Type][int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'ArriveNO'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'UserID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'Amount'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开始时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'AgainTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结束时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'EndTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'状态' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'State'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'抵用劵名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'ArriveName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'币种' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Arrive', @level2type=N'COLUMN',@level2name=N'Type'

GO
CREATE TABLE [dbo].[ZL_CreateJS](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Jsname] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[JsReadme] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[ContentType] [int] NULL,
	[JsFileName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[JsType] [int] NULL,
	[JsXmlContent] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_CreateJS] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'代码名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_CreateJS', @level2type=N'COLUMN',@level2name=N'Jsname'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'简介' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_CreateJS', @level2type=N'COLUMN',@level2name=N'JsReadme'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'内容代码格式' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_CreateJS', @level2type=N'COLUMN',@level2name=N'ContentType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'文件名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_CreateJS', @level2type=N'COLUMN',@level2name=N'JsFileName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'JS类型' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_CreateJS', @level2type=N'COLUMN',@level2name=N'JsType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'配置XML内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_CreateJS', @level2type=N'COLUMN',@level2name=N'JsXmlContent'

GO
CREATE TABLE [dbo].[ZL_UserPromotions](
	[pid] [int] IDENTITY(1,1) NOT NULL,
	[GroupID] [int] NULL,
	[look] [int] NULL,
	[addTo] [int] NULL,
	[Modify] [int] NULL,
	[Columns] [int] NULL,
	[Comments] [int] NULL,
	[Deleted] [int] NULL,
	[NodeID] [int] NULL,
	[ModelID] [int] NULL,
	[quote] [int] NULL,
	[down][int] NULL,
 CONSTRAINT [PK_ZL_UserPromotions] PRIMARY KEY CLUSTERED 
(
	[pid] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'权限ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'pid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户组ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'GroupID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'查看' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'look'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'addTo'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'修改' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'Modify'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'仅当前节点' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'Columns'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'允许评论' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'Comments'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'删除' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'Deleted'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'节点ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'NodeID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模型ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_UserPromotions', @level2type=N'COLUMN',@level2name=N'ModelID'

GO
CREATE TABLE [dbo].[ZL_BookRead](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[title] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[userId] [int] NULL,
	[effectTime] [datetime] NULL,
	[endTime] [datetime] NULL,
	[IsNotRead] [int] NULL,
	[isAudit] [int] NULL,
	[Reserve] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Gid] [int] NULL,
	[userType] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'title'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订阅者' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'userId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'生效时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'effectTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'到期时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'endTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否终止订阅:0为否,1为是' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'IsNotRead'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否已审核:0为未审核,1为已审核' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'isAudit'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否允许退订' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'Reserve'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'内容ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'Gid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户类型:0为个人,1为用户组' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_BookRead', @level2type=N'COLUMN',@level2name=N'userType'

GO
CREATE TABLE [dbo].[ZL_Examination](
	[ExaID] [int] IDENTITY(1,1) NOT NULL,
	[StuUserName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Stuid] [int] NULL,
	[Generate] [datetime] NULL,
	[Starttime] [datetime] NULL,
	[Endtime] [datetime] NULL,
	[Qlist] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[Total] [int] NULL,
	[Score] [int] NULL,
	[Reviews] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[Examiners] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[RoomID] [int] NULL,
 CONSTRAINT [PK_ZL_Examination] PRIMARY KEY CLUSTERED 
(
	[ExaID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试卷ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'ExaID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'StuUserName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Stuid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'生成时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Generate'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开始考试时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Starttime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结束考试时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Endtime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试题列表(ID)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Qlist'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试卷总数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Total'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考试评分' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Score'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考试评语' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Reviews'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'阅卷人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'Examiners'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考场ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Examination', @level2type=N'COLUMN',@level2name=N'RoomID'

GO
CREATE TABLE [dbo].[ZL_ExAnswer](
	[AnswerID] [int] IDENTITY(1,1) NOT NULL,
	[ExaID] [int] NULL,
	[Stuid] [int] NULL,
	[Answer] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[AnswerTime] [datetime] NULL,
	[Fraction] [int] NULL,
	[Scores] [int] NULL,
	[Examiners] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[RoomID] [int] NULL,
	[StuName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_ExAnswer] PRIMARY KEY CLUSTERED 
(
	[AnswerID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'答题ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'AnswerID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试卷ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'ExaID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'Stuid'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生答案' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'Answer'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'答题时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'AnswerTime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'试题分数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'Fraction'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所得分数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'Scores'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'阅卷人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'Examiners'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考场ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'RoomID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAnswer', @level2type=N'COLUMN',@level2name=N'StuName'

GO
CREATE TABLE [dbo].[ZL_ExAttendance](
	[AttID] [int] IDENTITY(1,1) NOT NULL,
	[Stuid] [int] NULL,
	[LogTime] [datetime] NULL,
	[Logtimeout] [int] NULL,
	[Location] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[StuName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_ExAttendance] PRIMARY KEY CLUSTERED 
(
	[AttID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考勤ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAttendance', @level2type=N'COLUMN',@level2name=N'AttID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学员ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAttendance', @level2type=N'COLUMN',@level2name=N'Stuid'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'登录时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAttendance', @level2type=N'COLUMN',@level2name=N'LogTime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'登录时长' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAttendance', @level2type=N'COLUMN',@level2name=N'Logtimeout'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'当前位置' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAttendance', @level2type=N'COLUMN',@level2name=N'Location'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExAttendance', @level2type=N'COLUMN',@level2name=N'StuName'

GO
CREATE TABLE [dbo].[ZL_ExClassgroup](
	[GroupID] [int] IDENTITY(1,1) NOT NULL,
	[Regulationame] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Regulation] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Ratednumber] [int] NULL,
	[Actualnumber] [int] NULL,
	[Setuptime] [datetime] NULL,
	[Endtime] [datetime] NULL,
	[CourseID] [int] NULL,
	[ShiPrice] [money] NULL,
	[LinPrice] [money] NULL,
	[CourseHour] [int] NULL,
	[Presented] [int] NULL,
	[isCou] [int] NULL,
	[Speaker] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ClassID] [int] NULL
 CONSTRAINT [PK_ZL_ExClassgroup] PRIMARY KEY CLUSTERED 
(
	[GroupID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'班级ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'GroupID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'班级名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Regulationame'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'班级负责人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Regulation'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'额定人数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Ratednumber'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'实际人数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Actualnumber'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开放时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Setuptime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结束时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Endtime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'课程ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'CourseID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'售价' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'ShiPrice'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'优惠价' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'LinPrice'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'课时' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'CourseHour'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订购此班级是否赠送此课程(免费)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Presented'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否打折' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'isCou'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'主讲人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'Speaker'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'课程分类ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExClassgroup', @level2type=N'COLUMN',@level2name=N'ClassID'

GO
CREATE TABLE [dbo].[ZL_Exroom](
	[ExrID] [int] IDENTITY(1,1) NOT NULL,
	[RoomName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Starttime] [datetime] NULL,
	[Endtime] [datetime] NULL,
	[ExaID] [int] NULL,
	[AddTime] [datetime] NULL,
	[Stuidlist] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_Exroom] PRIMARY KEY CLUSTERED 
(
	[ExrID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考场ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exroom', @level2type=N'COLUMN',@level2name=N'ExrID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开始考试时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exroom', @level2type=N'COLUMN',@level2name=N'Starttime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'结束考试时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exroom', @level2type=N'COLUMN',@level2name=N'Endtime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模板试卷ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exroom', @level2type=N'COLUMN',@level2name=N'ExaID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'安排时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exroom', @level2type=N'COLUMN',@level2name=N'AddTime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生ID列表' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Exroom', @level2type=N'COLUMN',@level2name=N'Stuidlist'

GO
CREATE TABLE [dbo].[ZL_ExStudent](
	[Stuid] [int] IDENTITY(1,1) NOT NULL,
	[Stuname] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Stupassword] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Stucardno] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Userid] [int] NULL,
	[Exptime] [datetime] NULL,
	[Lognum] [int] NULL,
	[Examnum] [int] NULL,
	[Logtimeout] [int] NULL,
	[Stugroup] [int] NULL,
	[Regulation] [int] NULL,
	[strCompetence] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[Course] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[Qualified] [int] NULL,
	[Addtime] [datetime] NULL,
 CONSTRAINT [PK_ZL_ExStudent] PRIMARY KEY CLUSTERED 
(
	[Stuid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学员ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Stuid'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Stuname'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'登录密码(二重密码)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Stupassword'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生考号(卡)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Stucardno'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'捆绑用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Userid'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'到期有效时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Exptime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'登陆次数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Lognum'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考试次数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Examnum'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'登录时长' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Logtimeout'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所在组别' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Stugroup'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'监管人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Regulation'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'考生权限' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'strCompetence'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学习课程' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Course'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否合格' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Qualified'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'启用时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudent', @level2type=N'COLUMN',@level2name=N'Addtime'

GO
CREATE TABLE [dbo].[ZL_ExStudytime](
	[StudyID] [int] IDENTITY(1,1) NOT NULL,
	[Stuid] [int] NULL,
	[Course] [int] NULL,
	[Studytime] [nvarchar](2000) COLLATE Chinese_PRC_CI_AS NULL,
	[Resttime] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[Schedule] [int] NULL,
	[Reviews] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_ExStudytime] PRIMARY KEY CLUSTERED 
(
	[StudyID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'培训ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'StudyID'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学员ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'Stuid'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'课程' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'Course'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学习时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'Studytime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'每日学习时间安排' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'Resttime'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'学员当前进度' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'Schedule'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'评语' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ExStudytime', @level2type=N'COLUMN',@level2name=N'Reviews'

GO
SET IDENTITY_INSERT [ZL_Questions] ON
 INSERT [ZL_Questions] ( [p_id] , [p_title] , [p_Difficulty] , [p_Class] , [p_Views] , [p_Inputer] , [p_Type] , [p_Knowledge] , [p_Answer] , 
[p_Content] , [p_CreateTime] , [Paper_Id] ) VALUES ( 1 , 'sdfsf' , 1 , 1 , 1 , 'admin' , 1 , 0 , '' , 'sdfdsfsdsfdsfsd' ,
 '2010-04-17 00:00:00.000' , 0 )
 INSERT [ZL_Questions] ( [p_id] , [p_title] , [p_Difficulty] , [p_Class] , [p_Views] , [p_Inputer] , [p_Type] , [p_Knowledge] , [p_Answer] , 
[p_Content] , [p_CreateTime] , [Paper_Id] ) VALUES ( 2 , '此次抽查' , 2 , 2 , 1 , 'admin' , 2 , 0 , '' , '梵蒂冈但是' ,
 '2010-04-17 00:00:00.000' , 0 )
 INSERT [ZL_Questions] ( [p_id] , [p_title] , [p_Difficulty] , [p_Class] , [p_Views] , [p_Inputer] , [p_Type] , [p_Knowledge] , [p_Answer] , 
[p_Content] , [p_CreateTime] , [Paper_Id] ) VALUES ( 3 , '第一章　声现象' , 1 , 1 , 1 , 'admin' , 3 , 0 , '<div _extended="true" class="daan" 
id="daan-62928">
	<p>
		<span>I=U/R </span><span>电阻一定时，电流与是压成正比</span></p>
	<p>
		<span>U=IR&nbsp; </span><span>电压一定时，电流与电阻成反比</span></p>
	<p>
		<span>R=U/I&nbsp; </span><span>电阻等于电压和电流的比值</span></p>
</div>' , '欧姆定律揭示了I、U、R三个物理量之间的规律，并可以写出三个物理公式。请你分别写出三个公式并说出每个公式所表示的意义？' ,
 '2010-04-17 00:00:00.000' , 0 )
 INSERT [ZL_Questions] ( [p_id] , [p_title] , [p_Difficulty] , [p_Class] , [p_Views] , [p_Inputer] , [p_Type] , [p_Knowledge] , [p_Answer] , 
[p_Content] , [p_CreateTime] , [Paper_Id] ) VALUES ( 4 , '初二物理第二学期期末检测 ' , 4 , 1 , 1 , 'admin' , 3 , 2 , '<div _extended="true" 
class="daan" id="daan-62927">
	<p>
		<span>用电器和电线是串联的，电流相同，但用电器的电阻比电线的电阻要大很多，据</span><span>P=I<sup>2</sup>R</span></p>
	<p>
		<span>&nbsp;&nbsp; </span><span>电阻越大，发热就越厉害。</span></p>
</div>' , '莉莉学习了《电功率》一章的知识后，回家仔细观察了家里的电水壶、电饭锅等较大功率的用电器在工作时的情况是：电水壶、电饭锅都很热而连接
它们的电线却不热。请你和莉莉共同探究这个问题并把你的想法写在下面： ' , '2010-04-17 00:00:00.000' , 0 )
 INSERT [ZL_Questions] ( [p_id] , [p_title] , [p_Difficulty] , [p_Class] , [p_Views] , [p_Inputer] , [p_Type] , [p_Knowledge] , [p_Answer] , 
[p_Content] , [p_CreateTime] , [Paper_Id] ) VALUES ( 5 , '第一章 力' , 2 , 2 , 1 , 'admin' , 3 , 1 , '<div _extended="true" class="daan" 
id="daan-218816">
	<p>
		<span>（</span><span>1</span><span>）由</span><span><sub><img height="44" 
src="http://gzwl.cooco.net.cn/files/down/test/2010/04/14/17/2010041417061723933126.files/image033.gif" width="279" /></sub></span><span>得
</span></p>
	<p>
		<span><sub><img height="44" 
src="http://gzwl.cooco.net.cn/files/down/test/2010/04/14/17/2010041417061723933126.files/image034.gif" width="352" /></sub>&nbsp;&nbsp;&nbsp; 
</span><span>（</span><span>2</span><span>）当</span><span>ab</span><span>棒达到最大速度时有</span><span><sub><img height="44" 
src="http://gzwl.cooco.net.cn/files/down/test/2010/04/14/17/2010041417061723933126.files/image035.gif" width="125" /></sub></span><span>所以
：</span></p>
	<p>
		<span><sub><img height="41" 
src="http://gzwl.cooco.net.cn/files/down/test/2010/04/14/17/2010041417061723933126.files/image036.gif" width="253" /></sub></span></p>
	<p>
		<span>当</span><span>ab</span><span>棒达到最大速度后，撤去外力</span><span>F</span><span>，此后物体的动能全用来克服安培力作功
，所以感应电流产生的热量为：</span><span><sub><img height="41" 
src="http://gzwl.cooco.net.cn/files/down/test/2010/04/14/17/2010041417061723933126.files/image037.gif" width="215" /></sub></span></p>
	<p>
		&nbsp;</p>
</div>' , '水平放置的平行金属框架L=0.2m,质量为0.1kg的金属棒ab放在框架上，并且与框架的两个边垂直。整个装置放于方向竖直向下、B=0.5T的匀强磁场中
，如图所示。金属棒ab在F=2N的水平向右的恒力作用下由静止开始运动。电路中除R=0.05外，其他电阻、摩擦阻力均不考虑。求：① ab速度是5m/s时，棒的加速
度是多大？

② 当ab棒达到最大速度后，撤去外力F，此后感应电流还能产生多少热量？' , '2010-04-17 00:00:00.000' , 0 )
 SET IDENTITY_INSERT [ZL_Questions] OFF

 SET IDENTITY_INSERT [ZL_Questions_Class] ON
 INSERT [ZL_Questions_Class] ( [C_id] , [C_ClassName] , [C_Classid] , [C_OrderBy] ) VALUES ( 1 , '初中物理' , 0 , 0 )
 INSERT [ZL_Questions_Class] ( [C_id] , [C_ClassName] , [C_Classid] , [C_OrderBy] ) VALUES ( 2 , '高中物理' , 0 , 0 )
 INSERT [ZL_Questions_Class] ( [C_id] , [C_ClassName] , [C_Classid] , [C_OrderBy] ) VALUES ( 3 , '第一章、 直线运动' , 1 , 0 )
 INSERT [ZL_Questions_Class] ( [C_id] , [C_ClassName] , [C_Classid] , [C_OrderBy] ) VALUES ( 4 , '第二章、物体的平衡' , 1 , 0 )
 INSERT [ZL_Questions_Class] ( [C_id] , [C_ClassName] , [C_Classid] , [C_OrderBy] ) VALUES ( 5 , '第一章、机械波' , 2 , 0 )
 INSERT [ZL_Questions_Class] ( [C_id] , [C_ClassName] , [C_Classid] , [C_OrderBy] ) VALUES ( 6 , '第二章、固体、液体和气体' , 2 , 0 )
 SET IDENTITY_INSERT [ZL_Questions_Class] OFF

 SET IDENTITY_INSERT [ZL_Questions_Knowledge] ON
 INSERT [ZL_Questions_Knowledge] ( [k_id] , [k_name] , [k_Class_id] , [k_OrderBy] ) VALUES ( 1 , '二、欧姆定律及其应用' , 2 , 0 )
 INSERT [ZL_Questions_Knowledge] ( [k_id] , [k_name] , [k_Class_id] , [k_OrderBy] ) VALUES ( 2 , '四、电与热' , 1 , 0 )
 SET IDENTITY_INSERT [ZL_Questions_Knowledge] OFF

 SET IDENTITY_INSERT [ZL_Questions_Type] ON
 INSERT [ZL_Questions_Type] ( [t_id] , [t_name] ) VALUES ( 1 , '选择题' )
 INSERT [ZL_Questions_Type] ( [t_id] , [t_name] ) VALUES ( 2 , '填空题' )
 INSERT [ZL_Questions_Type] ( [t_id] , [t_name] ) VALUES ( 3 , '应用题' )
 SET IDENTITY_INSERT [ZL_Questions_Type] OFF

GO
CREATE TABLE [dbo].[ZL_RebateOrder](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[OrderNo] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[WebsiteId] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[OrderState] [int] NULL,
	[OrderData] [datetime] NULL,
	[OrderMoney] [money] NULL,
	[ProfileMoney] [money] NULL,
	[Commision] [money] NULL,
	[OrderFbackData] [datetime] NULL,
	[UnionId] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UserId] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ParentRebate] [money] NULL,
	[Shopsite] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[MerNum] [int] NULL,
	[MerPrice] [money] NULL,
	[MerSumPrice] [money] NULL,
	[parentUser] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[parentPUser] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Remark] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[ParentPRebate] [money] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订单编号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'OrderNo'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'网站编号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'WebsiteId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订单状态:0为未确认；1为有效订单；2为无效订单' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'OrderState'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'下单日期' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'OrderData'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订单金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'OrderMoney'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'返利金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'ProfileMoney'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'佣金' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'Commision'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'订单反馈日期' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'OrderFbackData'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'联盟主' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'UnionId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户Id' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'UserId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上一级用户获得返利值' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'ParentRebate'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上上级用户返利比率' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'ParentPRebate'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'广告主(购物商城)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'Shopsite'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商品数量' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'MerNum'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商品单价' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'MerPrice'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商品总价' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'MerSumPrice'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上一级用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'parentUser'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上上级用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'parentPUser'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RebateOrder', @level2type=N'COLUMN',@level2name=N'Remark'

GO
CREATE TABLE [dbo].[ZL_Shopsite](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[url] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Sname] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[cid] [int] NULL,
	[UnionNo] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[aid] [int] NULL,
	[aurl] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[ToParaname] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[lablename] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RebateRate] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[PageRebateRate] [float] NULL,
	[PrantPageRebate] [float] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商城简称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'name'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商城网址' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'url'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商城名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'Sname'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属类别' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'cid'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'联盟的广告主ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'UnionNo'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'最高返利比率' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'RebateRate'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'第一级子站返利比率' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'PageRebateRate'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上一级子站返利比率' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Shopsite', @level2type=N'COLUMN',@level2name=N'PrantPageRebate'

GO
CREATE TABLE [dbo].[ZL_Honor](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[OrderData] [datetime] NULL,
	[HonorMoney] [money] NULL,
	[Fee] [money] NULL,
	[State] [int] NULL,
	[payData] [datetime] NULL,
	[Payinfo] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[userId] [int] NULL,
	[adminId] [int] NULL,
	[type] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'申请时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'OrderData'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'兑现金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'HonorMoney'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'扣除手续费' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'Fee'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'状态' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'State'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支付日期' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'payData'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支付信息' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'Payinfo'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'userId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'负责人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'adminId'
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'兑现类型:0为订单返利,1为分站返利' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Honor', @level2type=N'COLUMN',@level2name=N'type'

GO
CREATE TABLE [dbo].[ZL_Accountinfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BankOfDeposit] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[NameOfDeposit] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Account] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CardID] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Lock] [int] NULL,
	[UserId] [int] NULL,
	[PayId] [int] NULL 
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开户行及支行全称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'BankOfDeposit'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开户人真实姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'NameOfDeposit'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'开户帐号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'Account'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'会员真实姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'Name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'会员身份证号码' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'CardID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否绑定用户真实姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'Lock'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'UserId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支付ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Accountinfo', @level2type=N'COLUMN',@level2name=N'PayId'

GO
CREATE TABLE [dbo].[ZL_Redindulgence](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Account] [money] NULL,
	[UserId] [int] NULL,
	[mail] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[InvitePeople] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FriendName] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Url][ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[isUse] [int] NULL,
	[Type] [int] NULL CONSTRAINT [DF_ZL_Redindulgence_Type]  DEFAULT (0)
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'Account'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'注册链接地址' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'Url'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'UserId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'发送邮箱' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'mail'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'邀请人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'InvitePeople'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'朋友姓名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'FriendName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否已使用:0为未使用,1为已使用' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'isUse'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型:0为返利邀请,1为微博邀请，2为sns邀请' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Redindulgence', @level2type=N'COLUMN',@level2name=N'Type'

GO
CREATE TABLE [dbo].[ZL_Page](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Proname] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[PageTitle] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[KeyWords] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[Description] [nvarchar](2000) COLLATE Chinese_PRC_CI_AS NULL,
	[LOGO] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Domain] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[Style] [int] NULL,
	[HeadHeight] [int] NULL,
	[HeadColor] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CommonModelID] [int] NOT NULL,
	[TableName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Hits] [int] NULL,
	[InfoID] [int] NOT NULL,
	[Best] [int] NULL CONSTRAINT [DF_ZL_Page_Best]  DEFAULT (0),
	[Status] [int] NULL,
	[UserID] [int] NULL,
	[UserName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[ParentPageID] [int] NULL,
	[ParentUserID] [int] NULL,
	[PageInfo] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[TopWords] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[BottonWords] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[CreateTime] [datetime] NULL,
	[NodeStyle] [int] NULL CONSTRAINT [DF_ZL_Page_NodeStyle]  DEFAULT (0),
	[HeadBackGround] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_Page] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'企业名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Proname'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'黄页标题' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'PageTitle'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'关键字' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'KeyWords'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'说明' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Description'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'LOGO' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'LOGO'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'访问域名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Domain'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'风格' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Style'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'导航条高度' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'HeadHeight'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'导航条颜色' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'HeadColor'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'ZL_CommonModel中的ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'CommonModelID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模型名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'TableName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'点击数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Hits'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'模型内容ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'InfoID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'推荐级别' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Best'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'审核状态' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'Status'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'UserID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户名' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'UserName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上级黄页ID(上级商铺)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'ParentPageID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'上级用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'ParentUserID'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'黄页说明' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'PageInfo'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'头部自定义HTML内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'TopWords'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'底部HTML内容' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'BottonWords'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'CreateTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'节点样式' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'NodeStyle'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'导航背景' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Page', @level2type=N'COLUMN',@level2name=N'HeadBackGround'

GO
CREATE TABLE [dbo].[ZL_GiftCard_User](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ShopCardId] [int] NULL,
	[CardNO] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CardPass] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[password] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[remark] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[CardType] [int] NULL,
	[UserId] [int] NULL,
	[OrderData] [datetime] NULL,
	[confirmData] [datetime] NULL,
	[State] [int] NULL,
	[confirmState] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商城礼品ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'ShopCardId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'卡号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'CardNO'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'卡号密码' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'CardPass'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'确认密码' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'password'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'卡类别:1为积分兑换,2为返利金额兑换' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'CardType'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'UserId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'申请时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'OrderData'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'确认日期' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'confirmData'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'兑现状态:0为未兑现,1为已兑现' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'State'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'确认状态' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'confirmState'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_User', @level2type=N'COLUMN',@level2name=N'remark'

GO
CREATE TABLE [dbo].[ZL_GiftCard_shop](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Period] [datetime] NULL,
	[Cardinfo] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[remark] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[Points] [int] NULL,
	[shopId] [int] NULL ,
	[rebateVal] [money] NULL,
	[Days] [int] NULL,
	[Num] [int] NULL,
	[PicUrl] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'有效期' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'Period'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'卡信息' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'Cardinfo'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'remark'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'积分数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'Points'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'返利金额' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'rebateVal'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'限制:几天可兑换一次' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'Days'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商家ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'shopId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'数量' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'Num'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'图片路径' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_GiftCard_shop', @level2type=N'COLUMN',@level2name=N'PicUrl'

GO
CREATE TABLE [dbo].[ZL_RedEnvelope](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[OrderData] [datetime] NULL,
	[OrderState] [int] NULL,
	[DeducFee] [money] NULL,
	[RebateId] [int] NULL ,
	[Remark] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[RedEnvelope] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[type] [int] NULL,
	[Userid] [int] NULL,
	[payData] [datetime] NULL,
	[adminid] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'申请时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'OrderData'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'申请状态' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'OrderState'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'扣除手续费' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'DeducFee'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'红包' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'RedEnvelope'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型:0为现金，1为礼品卡' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'Userid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'返利ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'RebateId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'支付日期' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'payData'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'负责人' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_RedEnvelope', @level2type=N'COLUMN',@level2name=N'adminid'

GO
CREATE TABLE [dbo].[ZL_PointRecord](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[AddTime] [datetime] NULL,
	[Points] [int] NULL,
	[Type] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[Remark] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UserId] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PointRecord', @level2type=N'COLUMN',@level2name=N'AddTime'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所得积分' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PointRecord', @level2type=N'COLUMN',@level2name=N'Points'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'类型' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PointRecord', @level2type=N'COLUMN',@level2name=N'Type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'备注' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PointRecord', @level2type=N'COLUMN',@level2name=N'Remark'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属用户' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PointRecord', @level2type=N'COLUMN',@level2name=N'UserId'


GO
CREATE TABLE [dbo].[ZL_Promotion](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[userId] [int] NULL,
	[LinkUrl] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[PromoUrl] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[type] [char](10) COLLATE Chinese_PRC_CI_AS NULL,
	[AllinaceUrl] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_ZL_Promotion] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'推广用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Promotion', @level2type=N'COLUMN',@level2name=N'userId'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'原始地址' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Promotion', @level2type=N'COLUMN',@level2name=N'LinkUrl'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'推广URl' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Promotion', @level2type=N'COLUMN',@level2name=N'PromoUrl'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'链接类型:1为链接注册推广,2为红包涵注册,3为商品,4为商城,5为活动' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Promotion', @level2type=N'COLUMN',@level2name=N'type'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'联盟地址(实际链接地址)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Promotion', @level2type=N'COLUMN',@level2name=N'AllinaceUrl'

GO
CREATE TABLE [dbo].[ZL_Allianceinfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[alanceName] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[uid] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[pass] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[wid] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'联盟名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Allianceinfo', @level2type=N'COLUMN',@level2name=N'alanceName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'帐号' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Allianceinfo', @level2type=N'COLUMN',@level2name=N'uid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'密码' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Allianceinfo', @level2type=N'COLUMN',@level2name=N'pass'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'网站编号(该网站在联盟的id)' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Allianceinfo', @level2type=N'COLUMN',@level2name=N'wid'

GO
CREATE TABLE [dbo].[ZL_PromoCount](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PromotionUrl] [nvarchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[sid] [int] NULL,
	[linkCount] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'推广Url' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PromoCount', @level2type=N'COLUMN',@level2name=N'PromotionUrl'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商家id' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PromoCount', @level2type=N'COLUMN',@level2name=N'sid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'点击链接次数' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_PromoCount', @level2type=N'COLUMN',@level2name=N'linkCount'

GO
CREATE TABLE [dbo].[ZL_ShopsiteClass](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[cid] [int] NULL
) ON [PRIMARY]
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'商家分类' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ShopsiteClass', @level2type=N'COLUMN',@level2name=N'name'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'所属分类' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_ShopsiteClass', @level2type=N'COLUMN',@level2name=N'cid'

GO
CREATE TABLE [dbo].[ZL_Regsterapi](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Userid] [int] NULL,
	[Url] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Pageid] [int] NULL
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'用户ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Regsterapi', @level2type=N'COLUMN',@level2name=N'Userid'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'接口路径' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Regsterapi', @level2type=N'COLUMN',@level2name=N'Url'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'黄页ID' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_Regsterapi', @level2type=N'COLUMN',@level2name=N'Pageid'

GO
CREATE TABLE [dbo].[ZL_3DMusic](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[MusicName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[MusicUrl] [nvarchar](1000) COLLATE Chinese_PRC_CI_AS NULL,
	[IsTrue] [int] NULL,
	[AddTime] [datetime] NULL CONSTRAINT [DF_ZL_AddTime]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'音乐名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DMusic', @level2type=N'COLUMN',@level2name=N'MusicName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'音乐地址' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DMusic', @level2type=N'COLUMN',@level2name=N'MusicUrl'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否启用' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DMusic', @level2type=N'COLUMN',@level2name=N'IsTrue'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DMusic', @level2type=N'COLUMN',@level2name=N'AddTime'

GO
CREATE TABLE [dbo].[ZL_3DPanoramic](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PanoramicName] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[Istrue] [int] NULL CONSTRAINT [DF_ZL_Panoramic_Istrue]  DEFAULT (1),
	[Callabel] [nvarchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[PanoramicViewList] [ntext] COLLATE Chinese_PRC_CI_AS NULL,
	[OrderBy] [int] NULL CONSTRAINT [DF_ZL_Panoramic_OrderBy]  DEFAULT (0),
	[Addtime] [datetime] NULL CONSTRAINT [DF_ZL_Panoramic_Addtime]  DEFAULT (getdate()),
 CONSTRAINT [PK_ZL_Panoramic] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'全景名称' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DPanoramic', @level2type=N'COLUMN',@level2name=N'PanoramicName'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'是否启用' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DPanoramic', @level2type=N'COLUMN',@level2name=N'Istrue'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'调用标签' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DPanoramic', @level2type=N'COLUMN',@level2name=N'Callabel'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'全景地图' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DPanoramic', @level2type=N'COLUMN',@level2name=N'PanoramicViewList'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'排序' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DPanoramic', @level2type=N'COLUMN',@level2name=N'OrderBy'
GO
EXEC dbo.sp_addextendedproperty @name=N'MS_Description', @value=N'添加时间' , @level0type=N'USER',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ZL_3DPanoramic', @level2type=N'COLUMN',@level2name=N'Addtime'
GO


 SET IDENTITY_INSERT [ZL_3DMusic] ON
 INSERT [ZL_3DMusic] ( [ID] , [MusicName] , [MusicUrl] , [IsTrue] , [AddTime] ) VALUES ( 1 , '梦中的婚礼' , 'http://www.czsan.com/hl.mp3' , 1 , '2010-06-19 11:12:05.000' )
 INSERT [ZL_3DMusic] ( [ID] , [MusicName] , [MusicUrl] , [IsTrue] , [AddTime] ) VALUES ( 2 , '卡农' , 'http://yt-jy.cn/newEbiz1/535yt-jyres/images/images/11.mp3' , 1 , '2010-06-19 11:12:19.750' )
 INSERT [ZL_3DMusic] ( [ID] , [MusicName] , [MusicUrl] , [IsTrue] , [AddTime] ) VALUES ( 3 , '献给爱丽丝' , 'http://www.ehuayu.com/uploadfile/audio/171.mp3' , 1 , '2010-06-19 11:12:40.970' )
 INSERT [ZL_3DMusic] ( [ID] , [MusicName] , [MusicUrl] , [IsTrue] , [AddTime] ) VALUES ( 4 , '罗密欧与朱丽叶' , 'http://mp3.ysmp.net.cn/beijingyinyue/10000hb/罗密欧与朱丽叶.mp3' , 1 , '2010-06-19 11:12:58.923' )
 INSERT [ZL_3DMusic] ( [ID] , [MusicName] , [MusicUrl] , [IsTrue] , [AddTime] ) VALUES ( 5 , '蓝色的爱' , 'http://www.fzjsjx.com/upload/zydir/39/z20081028_5876_4027.mp3' , 1 , '2010-06-19 11:13:30.297' )
 SET IDENTITY_INSERT [ZL_3DMusic] OFF

 SET IDENTITY_INSERT [ZL_3DPanoramic] ON
 INSERT [ZL_3DPanoramic] ( [ID] , [PanoramicName] , [Istrue] , [Callabel] , [PanoramicViewList] , [OrderBy] , [Addtime] ) VALUES ( 1 , '全景范例：夏日农庄' , 1 , '' , '<musiclist>
<music_url name="梦中的婚礼">http://www.czsan.com/hl.mp3</music_url>
<music_url name="卡农">http://yt-jy.cn/newEbiz1/535yt-jyres/images/images/11.mp3</music_url>
<music_url name="献给爱丽丝">http://www.ehuayu.com/uploadfile/audio/171.mp3</music_url>
<music_url name="罗密欧与朱丽叶">http://mp3.ysmp.net.cn/beijingyinyue/10000hb/罗密欧与朱丽叶.mp3</music_url>
<music_url name="蓝色的爱">http://www.fzjsjx.com/upload/zydir/39/z20081028_5876_4027.mp3</music_url>
</musiclist>
<Panoramic>
<Panoramic_name>场景1</Panoramic_name>
<Panoramic_option><ScanName>场景1</ScanName>
<ScanPic>UploadFiles/pano/20106191124478908535.jpg</ScanPic>
<MapPic>UploadFiles/pano/20106191125288599326.jpg</MapPic>
<TopLogo>/Panoramic3D/assets/opt/logo.png</TopLogo>
<defaultTopLogo></defaultTopLogo>
<LoGoLink>http://www.zoomla.cn/</LoGoLink>
<defaultlink></defaultlink>
<BottomLogo>/Panoramic3D/assets/opt/Bottonlogo.png</BottomLogo>
<DefaultBottomLogo></DefaultBottomLogo>
<BottomLogoLink>http://www.zoomla.cn/</BottomLogoLink>
<DefaultBottomLogoLink></DefaultBottomLogoLink>
<InputButtonPic>/Panoramic3D/assets/opt/goto.png</InputButtonPic>
<ReturnButtonPic>/Panoramic3D/assets/opt/goreturn.png</ReturnButtonPic>
<OtherButtonPic>/Panoramic3D/assets/opt/gourl.png</OtherButtonPic>
<AutoMarquee>on</AutoMarquee>
<ShowMap>on</ShowMap>
<camz>-595</camz><campanangle>221</campanangle><camtiltangle>-1</camtiltangle><camtargetpanangle>221</camtargetpanangle><camtargettiltangle>-1</camtargettiltangle><putintxt><btn>Putin0: x:0 y:0 z:-1150 rotationX:90 rotationY:-180</btn></putintxt><returnbuttontxt><btn>returnbutton0: x:-1013 y:18 z:543 rotationX:90 rotationY:-61</btn></returnbuttontxt><OtherButtontxt><btn>OtherButton0: x:574 y:48 z:995 rotationX:90 rotationY:29.000000000000004</btn></OtherButtontxt><OtherButton0><url>http://wwww.zoomla.cn</url><opentype>新窗口弹出</opentype></OtherButton0></Panoramic_option>
</Panoramic>

<Panoramic>
<Panoramic_name>场景2</Panoramic_name>
<Panoramic_option><ScanName>场景2</ScanName>
<ScanPic>UploadFiles/pano/20106191126489218705.jpg</ScanPic>
<MapPic>UploadFiles/pano/20106191127225464218.jpg</MapPic>
<TopLogo>/Panoramic3D/assets/opt/logo.png</TopLogo>
<defaultTopLogo></defaultTopLogo>
<LoGoLink>http://www.zoomla.cn</LoGoLink>
<defaultlink></defaultlink>
<BottomLogo>/Panoramic3D/assets/opt/Bottonlogo.png</BottomLogo>
<DefaultBottomLogo></DefaultBottomLogo>
<BottomLogoLink>http://www.zoomla.cn</BottomLogoLink>
<DefaultBottomLogoLink></DefaultBottomLogoLink>
<InputButtonPic>/Panoramic3D/assets/opt/goto.png</InputButtonPic>
<ReturnButtonPic>/Panoramic3D/assets/opt/goreturn.png</ReturnButtonPic>
<OtherButtonPic>/Panoramic3D/assets/opt/gourl.png</OtherButtonPic>
<AutoMarquee>on</AutoMarquee>
<ShowMap>on</ShowMap>
<camz>-612</camz><campanangle>219</campanangle><camtiltangle>3</camtiltangle><camtargetpanangle>219</camtargetpanangle><camtargettiltangle>3</camtargettiltangle><putintxt><btn>Putin0: x:0 y:0 z:-1150 rotationX:90 rotationY:-180</btn></putintxt><returnbuttontxt><btn>returnbutton0: x:-1129 y:-6 z:-215 rotationX:90 rotationY:-100</btn></returnbuttontxt><OtherButtontxt><btn>OtherButton0: x:395 y:54 z:1079 rotationX:90 rotationY:20</btn></OtherButtontxt><OtherButton0><url>http://www.hx008.cn</url><opentype>本窗口弹出</opentype></OtherButton0></Panoramic_option>
</Panoramic>

<Panoramic>
<Panoramic_name>场景3</Panoramic_name>
<Panoramic_option><ScanName>场景3</ScanName>
<ScanPic>UploadFiles/pano/20106191129378751947.jpg</ScanPic>
<MapPic>UploadFiles/pano/2010619113034215942.jpg</MapPic>
<TopLogo>/Panoramic3D/assets/opt/logo.png</TopLogo>
<defaultTopLogo></defaultTopLogo>
<LoGoLink>http://www.zoomla.cn</LoGoLink>
<defaultlink></defaultlink>
<BottomLogo>/Panoramic3D/assets/opt/Bottonlogo.png</BottomLogo>
<DefaultBottomLogo></DefaultBottomLogo>
<BottomLogoLink>http://www.zoomla.cn</BottomLogoLink>
<DefaultBottomLogoLink></DefaultBottomLogoLink>
<InputButtonPic>/Panoramic3D/assets/opt/goto.png</InputButtonPic>
<ReturnButtonPic>/Panoramic3D/assets/opt/goreturn.png</ReturnButtonPic>
<OtherButtonPic>/Panoramic3D/assets/opt/gourl.png</OtherButtonPic>
<AutoMarquee>on</AutoMarquee>
<ShowMap>on</ShowMap>
<camz>70</camz><campanangle>275</campanangle><camtiltangle>6</camtiltangle><camtargetpanangle>275</camtargetpanangle><camtargettiltangle>6</camtargettiltangle><putintxt><btn>Putin0: x:0 y:0 z:-1150 rotationX:90 rotationY:-180</btn></putintxt><returnbuttontxt><btn>returnbutton0: x:-554 y:-138 z:1007 rotationX:90 rotationY:-28</btn></returnbuttontxt><OtherButtontxt><btn>OtherButton0: x:1145 y:-126 z:-102 rotationX:90 rotationY:95</btn></OtherButtontxt><OtherButton0><url>http://bbs.zoomal.cn</url><opentype>本窗口弹出</opentype></OtherButton0></Panoramic_option>
</Panoramic>
<autoplay>1</autoplay>
' , 0 , '2010-06-19 13:04:52.390' )
 SET IDENTITY_INSERT [ZL_3DPanoramic] OFF

--ZL_S_shop
CREATE TABLE [dbo].[ZL_S_shop] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[pics] [ntext]  NULL DEFAULT ('')
)

CREATE TABLE [dbo].[ZL_C_Factory] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[wzbt] [nvarchar]  (255) NULL DEFAULT (''),
[gsmc] [nvarchar]  (255) NULL DEFAULT (''),
[jf] [nvarchar]  (255) NULL DEFAULT (''),
[yf] [nvarchar]  (255) NULL DEFAULT (''))

ALTER TABLE [ZL_C_Factory] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_Factory] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_Factory] ON
SET IDENTITY_INSERT [ZL_C_Factory] OFF

--副表
CREATE TABLE [dbo].[ZL_C_Announce] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[content] [ntext]  NULL DEFAULT (''),
[author] [nvarchar]  (255) NULL DEFAULT ('')
)
ALTER TABLE [ZL_C_Announce] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_Announce] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_Announce] ON
INSERT [ZL_C_Announce] ([ID],[content],[author]) VALUES ( 1,N'<p>
	人与电脑交互的界面，应该有什么样的体验？</p>
<p>我们大体可以认为其发展经历了以下四个时期：</p>
<p>1、鼠标健盘控制时期：原始的键盘、尤其是鼠标控制，使人类的一只手解放出来了，今天还有好多用电脑喜欢是&ldquo;左手插裤袋、右手动鼠标&rdquo;的形式&amp;^_^&amp;。</p>
<p>2、声控设备控制时期：声音的控制有了物联网的雏形，但由于声音的多源化，即使今天，我们也不能良好的使用之，而apple等公司却依然在孜孜努力。</p>
<p>3、触控设备控制时期：LCD等技术的成熟，使触控更加方便易用。</p>
<p>3、体感控制交互时期：体感使人的双手得到了全身心的解放，从而为我们创造了无限的想象力。</p>
<p>当全新的用户交互体验到来的时候，</p>
<p>HTML5、AJAX、站群技术、智能控制技术、云技术纷纷上阵，</p>
<p>人们要面对的不再是单一的技术。</p>
<p>&nbsp;</p>
<p><em>PS：2011年全球销售最火的IT设备不是Iphone，也不是ipad，而是源自微软的kinect。</em></p>
<p>&nbsp;</p>
<p>Kinect已经用于医院、儿童、超市等领域，</p>
<p>而如何和WEB交互？</p>
<p>这是以技术领先的Zoomla!逐浪CMS以及无数同行的使命，</p>
<p>我们将不断的深化相应研发，推进相关工作。</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>附：基于Kinect体感软件研发与Zoomla!逐浪CMS研发成果展示</p>
<p>
	<a href="http://www.zoomla.cn/corp/video/1839.shtml">http://www.zoomla.cn/corp/video/1839.shtml</a></p>
<div id="topcontrol" style="right: 5px; bottom: 5px; position: fixed; cursor: pointer; opacity: 1;" title="鐐瑰嚮鍥炲埌椤堕儴锛�">
	<img original="/App_Themes/UserThem/images/up.jpg" src="/App_Themes/UserThem/images/up.jpg" style="width: 18px; height: 58px;" /></div>',N'admin')
INSERT [ZL_C_Announce] ([ID],[content],[author]) VALUES ( 2,N'<p>
	全世界有多少种语言？</p>
<p>我们无法详细调查。</p>
<p>&nbsp;</p>
<p>但据权威统计，全世界的小语种语言正面临着死亡的威胁。</p>
<p>&nbsp;</p>
<p>这个星球因为差异而美丽，</p>
<p>全球化却让语言之美黯然失色。</p>
<p>nbsp;</p>
<p>而从Zoomla!逐浪CMS5.5SP1版起（现已向商业用户投递），</p>
<p>我们将支持多语言。</p>
<p>&nbsp;</p>
<p>首批支持的语言包括：</p>
<p>
中文简体</p>
<p>
中文繁体</p>
<p>英语-美国</p>
<p>法语</p>
<p>德语</p>
<p>意大利语</p>
<p>俄语</p>
<p>日语等七大类语言。</p>
<p>&nbsp;</p>
<p>用户不再需要为各个版本进行独立开发，而是基于语言包技术（不同于普通CMS只能切换网页语言，而是实际上的程序语言变换），</p>
<p>快速实现网站的开发应用。</p>
<p>&nbsp;</p>
<p>面向国际化的Zoomla!逐浪CMS，</p>
<p>技术创新的Zoomla!逐浪CMS，</p>
<p>欢迎广大用户加入商业客户阵营，享受VIP待遇，购买详见：</p>
<p><a href="http://www.zoomla.cn/corp/about/151.shtml">http://www.zoomla.cn/corp/about/151.shtml</a></p>',N'admin')
INSERT [ZL_C_Announce] ([ID],[content],[author]) VALUES ( 3,N'<p>
	北京时间2012年3月2日南京消息：</p>
<p>&nbsp;</p>
<p>领先的CMS厂商-Zoomla!逐浪CMS走进南京工业职业技术学院，并与国际教育学院的师生们进行良好的交流、使用培训，同时确定合作意向，将建立起包括网站开发、Web设计、体感与物联网技术研发等多个领域的合作。</p>
<p>&nbsp;</p>
<p>作为&quot;国家示范性高等职业院校建设计划&quot;首批建设28家学校之一，南京工业职业技术学院代表了当今中国最优秀的职业教育，而Zoomla!逐浪CMS始终立足于一流的中国网站内核CMS，专注于技术、服务于科技，二者有着高度的吻合，同时我们将不断的拓展与各学校、教育机构的合作，为中国教育门户网站开发与计算机教育事业做出贡献！</p>
<p>&nbsp;</p>
<p>南京工业职业技术学院最初是我国近现代著名民主革命家、社会活动家、教育家黄炎培先生于1918年在上海创办的中华职业学校--我国教育史上第一所专门从事职业教育并以&quot;职业学校&quot;冠名的学校。90年的办学历史大致分为四个阶段：1918-1952年为中华职业学校时期；1952-1960年为上海机械学校时期；1960-1999年为南京机电学校时期；1999起进入南京工业职业技术学院时期。学院先后为国家培养了八万余名各类建设和管理人才，伟大的无产阶级革命家张闻天、著名数学家华罗庚、革命烈士江竹筠就是他们中的杰出代表。</p>',N'admin')
INSERT [ZL_C_Announce] ([ID],[content],[author]) VALUES ( 4,N'<p>
	带着春的信息与全体逐浪人的智慧结晶，</p>
<p>Zoomla!逐浪CMS智能加密与同步教学系统于北京时间2012年4月16日全面发布，代表了WEB应用技术与教学教育结合的新趋势，引领国内教育软件产业的新方向。</p>
<p>nbsp;</p>
<p>
	与市面上其它同类产品相比，Zoomla！逐浪CMS智能加密与同步教学系统拥有四大优势：<br />
	<strong>一、原生态支持PPT与标准课件</strong>：标准的PPT课件不需要转成其它格式，即可以实现底层的严格加密，从而确保课件原汁原味、声色俱佳，提升教学效果。<br />
	<strong>二、硬件加密、安全可靠</strong>：基于全新的硬件加密技术，做到安全可靠，万无一失。<br />
	<strong>三、与Zoomla!逐浪CMS应用一体、无限扩展支持</strong>：避免传统软件的更新缺陷，集成Zoomla!逐浪CMS国内顶尖团队的智慧结晶，可以与WEB应用相结合，层叠更新， 即减少硬件成本，又能提升应用体你验。<br />
	<strong>四、基于最新的微软平台开发技术，彰显技术魅力</strong>：Zoomla！逐浪CMS智能加密与同步教学系统采用最新的微软高端研发技术，目前已经通过windows xp、windows 7、windows 8等版本测试，得到了完美的验证，具备良好的兼容优势与二次开发能力。</p>',N'admin')
INSERT [ZL_C_Announce] ([ID],[content],[author]) VALUES ( 5,N'<p>
	竹外桃花三两枝,<br />
	春江水暖鸭先知。<br />
	蒌蒿满地芦芽短,<br />
	正是河豚欲上时。</p>
<p>&nbsp;</p>
<p>有些食物因价格昂贵，令芸芸众生望而却步。<br />
	有些食物即使你愿意一掷千金，也不一定寻觅得到。<br />
	还有一些食物，哪怕你腰缠万贯，纵然将其无偿供奉在你面前，你也不见得敢吃。</p>
<p>同样是开拓创新，</p>
<p>力求登峰造极，</p>
<p>为中国互联网的创新和成长提供高端支持。</p>
<p>&nbsp;</p>
<p>今天的互联网同样，</p>
<p>马云&ldquo;教父&rdquo;所描绘的&ldquo;开网店就是创业&rdquo;的神话已经成为泡沫。</p>
<p>电子商务行业，</p>
<p>人人信奉&ldquo;你做什么之前首先想想腾讯会不会下手&rdquo;，</p>
<p>那么互联网创新的源泉来自哪里？</p>
<p>&nbsp;</p>
<p>Zoomla!逐浪CMS作为国内领先的网站内核系统厂商，</p>
<p>始终力求创新，</p>
<p>从独创的模型与子站应用，</p>
<p>到基于云技术的模型获取，</p>
<p>恪守以创新本质、打造开放系统，</p>
<p>专注于核心级的网站内核解决方案。</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>如果我们要靠弹窗和广告来赢利，</p>
<p>五年前我们就不会这样定位产品；</p>
<p>来我们将更加力求创新，</p>
<p>纯粹的产品和技术研发之路，</p>
<p>并将在2012年上半年推出更加先进的Zoomla!逐浪CMS6.0版，</p>
<p>集成更加优秀的应用体验与功能、全新的用户界面、并集成新zoomla!逐浪CMS官网，</p>
<p>盛大发布</p>
<p>
	回馈广大用户的支持，</p>
<p>
	敬请期待！</p>',N'admin')
SET IDENTITY_INSERT [ZL_C_Announce] OFF

Go
CREATE TABLE [dbo].[ZL_C_Article] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[author] [nvarchar]  (255) NULL DEFAULT (''),
[source] [nvarchar]  (255) NULL DEFAULT (''),
[synopsis] [ntext]  NULL DEFAULT (''),
[content] [ntext]  NULL DEFAULT (''),
[Edit] [nvarchar]  (255) NULL DEFAULT (''),
[pic] [nvarchar]  (255) NULL DEFAULT (''),
[pages] [nvarchar]  (255) NULL DEFAULT (''),
[K_pages] [nvarchar]  (255) NULL DEFAULT (''))

ALTER TABLE [ZL_C_Article] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_Article] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_Article] ON
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[pic],[K_pages]) VALUES ( 1,N'admin',N'本站原创',N'<p>
&nbsp;</p>
<p>
<img alt="" border="0" src="/UploadFiles/stu/jpg/Water2012050602502847.jpg" style="cursor: pointer;" /></p>
<p align="center">
	1953：弧线机关枪</p>
<p>
	<br />
	&nbsp;</p>
<p align="center">
	&nbsp;</p>
<p align="left">
	&nbsp;</p>
<p style="text-indent: 28px; margin-top: 10px;">
	<font style="font-size: 14px;">这是一款非常符合逻辑思维但不符合实用逻辑的枪，你不可能知道它会打到哪。因此，特别适用于那些&ldquo;打哪指哪&rdquo;的家伙来用。</font></p>',N'本站编辑',N'demo/ad4.jpg',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[pic],[K_pages]) VALUES ( 2,N'admin',N'本站原创',N'你也来张吧！',N'
<p>围观各种奇葩情侣照 你也来张吧</p>',N'本站编辑',N'demo/ad3.jpg',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[pic],[K_pages]) VALUES ( 3,N'admin',N'本站原创',N'娱乐行业中的劳动模范',N'<p>
	<font size="4">正文：俗话说:三百六十行，行行出状元，任何一个行业都会有自己的劳动模范,娱乐圈自然也不例外.娱乐圈除了那些拼命三郎的男明星外,一些美女明星也是巾帼不让须眉,用辛勤与汗水打造属于自己的成功!下面娱魅力就盘点下娱乐圈那些"美女劳模"吧!</font></p>',N'本站编辑',N'demo/ad2.jpg',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[pic],[K_pages]) VALUES ( 4,N'admin',N'本站原创',N'代号河豚-逐浪CMS2 x1.4版发布计划,汇聚智能门户与云计算引擎的Zoomla!逐浪CMS',N'<p align="center">
	&nbsp;</p>
<p align="center">
	&nbsp;</p>
<p align="center">
	<font size="5"><font color="red"><strong>最新Zoomla！逐浪CMS汇聚智能门户与云计算引擎的Zoomla!逐浪CMS2 x1.4全面发布</strong></font></font></p>
<p align="center">
	&nbsp;</p>
<p align="center">
	<font size="5"><font color="red"><strong><strong><font color="#ff0000" size="5">每</font></strong>月最新IDC排名更新 就在华夏互联官网（<a href="http://www.hx008.com">www.hx008.com</a>）</strong></font></font></p>',N'本站编辑',N'demo/ad1.jpg',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 14,N'admin',N'本站原创',N'<p>
	汇聚智能门户与云计算引擎的Zoomla!逐浪CMS<br />
	&nbsp;</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[K_pages]) VALUES ( 6,N'admin',N'本站原创',N'关于我们',N'<p>
	　　<br />
	<span style="color: rgb(255, 102, 0);"><span style="font-size: 12px;">三年前，我们说做CMS人家说我们是开玩笑。<br />
	二年前，我们做要做Oracle高端开发，人家以为我们是痴人说梦。<br />
	一年前，我们说要做独立知识产权高端站群系统，别人以为是笑话。<br />
	现在，这一切都是现实&hellip;&hellip;<br />
	--2008年的&ldquo;发哥&rdquo;，反复重复这几句话。<br />
	--今天读这些话，理想已实现而梦想还很遥远。</span></span></p>
<p>
	&nbsp;</p>
<p>
	<span style="color: rgb(255, 102, 0);"><span style="font-size: 12px;">在我们的开发团队中，<br />
	我们亲切的称男生为&ldquo;华仔&rdquo;--因为我们来自华夏互联的核心开发体系；<br />
	我们亲切的称女生为&ldquo;浪花&rdquo;--因为每天开心、积极向上是我们的生命态度。</span></span></p>
<p>
	&nbsp;</p>
<p>
	<span style="color: rgb(255, 102, 0);"><span style="font-size: 12px;">随便找一家网吧，所有的系统都是打着&lsquo;长沙明智&rsquo;、&lsquo;湖南斯普林&rsquo;字样--湖南比江西强；<br />
	武汉华中重镇，统领华中，IT产业规模远远超过江西；<br />
	南有深圳广州领衔全国，每年江西学子趋之若鹜；<br />
	往东不说上海，杭州作为&ldquo;中国互联网之都&rdquo;亦仅望其项背；<br />
	所有一切说明江西的软件研发水平是最低的、<br />
	所有一切说明我们处于整个产业盆地的最低谷！<br />
	--我们从来都是以此锥股前行。<br />
	<br />
	直到今天我们在中国IT与软件最高地上海成立全资公司、<br />
	直到今天我们问鼎中国软件研发最核心动脉浦东创业，<br />
	上海+南昌两大研发团队、两大全资公司集团化运作，<br />
	脚比路更长、站着浙赣线丈量世界，<br />
	还是我们的信条，<br />
	因为我们矢志：做中国最好的CMS与WEB研发厂商！</span></span><br />
	&nbsp;</p>
<p>
	　　&ldquo;追逐未来、只争第一&rdquo;--上海逐一软件科技有限公司旗下拥有逐浪软件、华夏互联、华夏营销网三大门户，集有上海、南昌两大全资集团化研发公司，逾十年网站开发与解决方案服务经验，服务包括政府、军工、外企、世界五百强企业和诸多本土站长，致力于打造最优秀的网站内核管理系统，是目前国内最大的CMS研发法人机构，其规模远远超过四川腹地、佛山大良等诸地同行厂商。<br />
	　　逐浪&reg;CMS作为国内顶尖、华中地区（苏、浙、皖、湘、鄂、豫、赣）唯一自主知识产权的网站管理系统（CMS）开发商，独有的&ldquo;沙箱&rdquo;开发理念，赢得了高端用户和开发者推崇，完全开放的软件体制更是行业翘楚。<br />
	　　目前Zoomla!逐浪CMS已经具备内容管理、商城、网店、站群、OA、文档输出、FLEX、社区、公会、CRM、项目管理等多个模块，且是国内唯一同步提供MSSQL与Oracle两大数据库计算的高端CMS厂商，也是国内首家通过ISO9001国际质量标准体系认证的网站内容内核管理系统服务商。Zoomla!逐浪CMS采用模板与数据完全剥离、独有的沙箱开发思想，面向中国特色的业务流程功能服务，并利用自主的Z-power模板引擎体系，为用户提供了节点无限生成、可多库并存、自由设计、可视化风格操作的网站开发新体验。<br />
	　　更重要的是，逐浪CMS在注重模板应用和视觉体系的同时，摒弃传统的&ldquo;为了模板而套模板&rdquo;的思维，将所有的节点功能完全开放，用户可以自由组织系统架构和应用体系，最大化的解放了站长与开发者的精力，让用户关心核业务处理，把一切面向用户开放，成就客户，共荣发展。</p>
<div>
	　　我们只专注WEB研发，<br />
	　　我们只专注为企业和门户提供服务，<br />
	　　我们只乐于数据处理和面向开发者服务。<br />
	　　我们不是&ldquo;专注于政务&rdquo;的系统集成商，<br />
	　　我们不是&ldquo;开公司找&lsquo;风投&rsquo;&rdquo;的所谓公司。<br />
	　　我们只是一个严谨开发的软件厂商，<br />
	　　我们只是在乎每一个细节的执行和Case的攻克破茧，<br />
	　　我们只为理想和事业追逐未来，<br />
	　　让我们一同进入Zoomla!逐浪CMS的自由开发世界。</div>
<div>WEB未来由我们构建！</div>
<div>
	&nbsp;</div>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[K_pages]) VALUES ( 10,N'admin',N'本站原创',N'dfd',N'<p>
	df</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 11,N'admin',N'本站原创',N'<p>
	ddd</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 12,N'admin',N'本站原创',N'<p>
	sssssssssss</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 13,N'admin',N'本站原创',N'<p>
	sds</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 15,N'admin',N'本站原创',N'<p>
	&nbsp;融聚移动应用与桌面软件平台<br />&nbsp;</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 16,N'admin',N'本站原创',N'<p>
	多门户子站切换系统<br />&nbsp;</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 17,N'admin',N'本站原创',N'<p>
	千万级数据库负载测试级别<br />&nbsp;</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[pic],[K_pages]) VALUES ( 18,N'admin',N'本站原创',N'逐浪软件可以自由的更换界面深受站长的喜爱，这一切而且是免费的...',N'<p>
	云台百套模板智能切换<br />&nbsp;</p>',N'本站编辑',N'demo/ad1.jpg',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 7,N'admin',N'本站原创',N'<p>
	<strong>逐浪软件上海研发中心</strong><br />
	公司地址：上海市浦东新区东方路1881弄东方城市花园79号703#<br />售前咨询：021-50391046 50391047 13918895839</p><div>
	传真FAX：021-50391047-8009</div><div>
	邮编：200122<br />
	[轨道交通六号线到临沂新村站下车，往东三里桥方向步行十分钟左右即可]</div>
<div>
	[轨道交通七号线到杨高南路站下车，往东三里桥方向步行两分钟左右即可]</div>
<div>&nbsp;</div><div>
	<strong>逐浪软件南昌研发中心</strong>
	<div>
		<strong>地址：</strong>南昌市站前路96号天集大厦14F（老福山往东南昌银行大楼）</div>
	<div>
		<strong>电话：</strong>0791-86161900 86161700<br />
		<strong>7&times;24小时客户服务热线：</strong>13177777714 / 13816455553</div>
	<div>
		<strong>邮编：</strong>330002<br />
		企业推广与建站请咨询<strong>品牌建站专家热线:13177777714</strong><br />
		传真：0791-86161900-8009</div>
	<div>
		<div style="text-align: left;">
			南昌市内各路公交均直达。</div>
	</div>
	<p>
		&nbsp;</p>
	<p>
		咨询QQ：69250566 184886758 745151353 515846139 544472213 779630567 785782963 184886759<br />
		MSN：<a href="msnim:chat?contact=wzff_3@hotmail.com" target="_blank" title="">wzff_3@hotmail.com</a><br />
		E-mail：<a href="mailto:web@hx008.com">web@hx008.com</a></p>
	<div>
		<a href="http://www.v.hx008.com/member.php?module=mysupport"><strong><font color="#ff0000">商业认证用户售后服务中心</font></strong></a>[<a href="http://www.v.hx008.com/register.php">点此注册</a>]<br />
		<a href="http://2009.hx008.com/guestbook/"><strong>非商业认证用户开放服务中心</strong></a>[<a href="http://2009.hx008.com/Reg/User_Reg.asp">点此注册</a>]<br />
		<br />
		&rarr;<a href="http://2009.hx008.com/Article/class7/help7/200609/563.shtml">售后服务支持流程请点这里&gt;&gt;</a><br />
		&rarr;<a href="http://2009.hx008.com/Article/class7/help7/200607/705.shtml">关于不把MSN或QQ作为首要售后服务支持的说明</a></div>
	<div>
		&nbsp;</div>
	<p>
		&nbsp;</p>
	<div align="left">
		<span style="font-size: 9pt;"><strong>About [www.zoomla.cn]</strong></span></div>
	<div align="left">
		<strong>Company Name:</strong> Jiangxi Joined Industries CO.,LTD</div>
	<div align="left">
		<span style="font-size: 9pt;"><strong>Address:</strong><span style="color: rgb(102, 102, 102); font-size: 9pt;">502Rooms,the second units of 28 buliding,Rong Chang Xinyuan district,NO.139 South Jiangda Road,NanChang City,Jiangxi</span><span style="color: rgb(97, 97, 97); font-size: 8.5pt;"> Province, P.R.China</span><span style="color: rgb(102, 102, 102); font-size: 9pt;">.</span></span><br />
		<strong>Zip code:</strong> 330002<br />
		<strong>Tel:</strong>021-50391046 50391047 0791-86161900,86161700</div>
	<div align="left">
		<strong>Fax:</strong>0791-86161900</div>
	<div align="left">
		<strong>Website:</strong>www.zoomla.cn</div>
	<div align="left">
		<strong>E-mail:</strong>web@zoomla.cn</div>
	<div align="left">
		&nbsp;</div>
	<div align="left">
		&nbsp;</div>
	<div align="left">
		[提示：我们致力于推进繁荣正直的永续实体研发企业，并无任何融资或借贷计划，请风投企业勿扰]</div>
</div>
<p>
	&nbsp;</p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[content],[Edit],[K_pages]) VALUES ( 8,N'admin',N'本站原创',N'<p>
	　</p>
<p>
	<font color="#0089f7">本声明适用于您使用逐浪软件(以下简称&quot;本网站&quot;)所提供的各种工具和服务(以下简称&quot;服务&quot;)。</font><br />
	&nbsp;</p>
<p>
	　 1、 总则：您通过用户注册页面进入本网站即表示您已经同意自己与本网订立本协议。本网站可随时执行全权决定更改&ldquo;条款&rdquo;。如&ldquo;条款&rdquo;有任何变更，本网将在本网站上刊载公告作为通知。经修订的&ldquo;条款&rdquo;一经在本网站上公布后，立即自动生效。<br />
	　　 2、 关于版权及言论问题：用户在使用本站系统过程中，不得发布侵犯党和国家利益的言论，不得发布泄露国家机密的言论，不得发布有损害他们声誉的言论，不得发布侵犯他人版权的言论等。用户在论坛、留言板以及个人网站上所发布、转载的文章所引起的版权问题以及因文章内包含毁谤、诋毁、攻击他人的信息等一切纠纷或后果由用户自行承担，本网概不负责。<br />
	　　 本网站尊重他人的任何权利，同时也要求我们的使用者也尊重他人之权利。本网站在适当情况下，有权自行决定删除侵犯他人权利的文章终止侵害或违反他人权利之使用者的帐号。<br />
	　　对于相关文章版权，属于原创者归作者所有，逐浪软件仅为撷取作为科研之用，并不进行任何的赢利与创收行为，作者、著作权与版所有者一旦认为侵犯权益，请第一时间通知我们，我们将立即删除并配合处理；对于作者投稿文章，我们均视作者主动授权发布与放弃稿酬行为。<br />
	　　 3、 关于经营活动：本网支持用户在使用站系统过程中，进行合法的经营，但因为用户过失所造成的后果由用户自行承担，一切未经过本网官方认可的经营活动均与本官方站点无关。<br />
	　　 4、 关于用户资料：&ldquo;您的资料&rdquo;包括您在注册、使用本站服务过程中、在任何公开信息场合或通过任何电子邮件形式，向本站或其他用户提供的任何资料。您应对&ldquo;您的资料&rdquo;负全部责任，而本站仅作为您在网上发布和刊登&quot;您的资料&quot;的被动渠道。<br />
	　　如果您在本网站注册，您同意：<br />
	　　根据本网站所刊载的会员资料表格的要求，提供关于您或贵公司的真实、准确、完整和反映当前情况的资料；<br />
	　　本网站维持并及时更新会员资料，使其保持真实、准确、完整和反映当前情况。倘若您提供任何不真实、不准确、不完整或不能反映当前情况的资料，或本网有合理理由怀疑该资料不真实、不准确、不完整或不能反映当前情况，本网站有权暂停或终止您在本网站的注册身份及资料。<br />
	　　 5、 关于帐号的安全性：在登记过程中，您将选择会员注册名和密码。您须自行负责对您的会员注册名和密码保密，且须对您在会员注册名和密码下发生的所有活动承担责任。<br />
	　　 6、 系统的版权：本网对所有开发的或合作开发的服务的知识产权拥有所有权或使用权，这些服务受到适用的知识产权、版权、商标、服务商标、专利或其他法律的保护。<br />
	　　 7、 用户利益保障：本站将定期对用户数据进行备份工作，如因为操作失误、黑客攻击以及服务器故障引起的数据损失，本网将尽可能地恢复，但这种情况下所导致的损失为不可抗拒因素，本站具有免责权利。但用户有权要求本网根据服务停止时间采取延期使用的补救措施。但如果因为本站经营不善而导致本站服务无法继续，用户有权要求本网将用户数据返还用户或者寻找其他途径以妥善解决，以保障用户合法权利。　　 　　<br />
	　　8、 逐浪软件保障会员的隐私与要求，逐浪软件遵守国际公约、中华人民共和国法律与版权规定，用户一旦注册成为逐浪软件会员，即视认可逐浪软件定期与不定期发出要约邀请、商务邮件与通知，作为官方服务的一部份存在。<br />
	　　 9、 作为商业网站开发，任何时候客户只要接触源码、内核与后台，即视认可项目开发。因QQ、MSN等即时服务的不确定性，容易造成客户信息丢失，无论任何时候我们都放弃以QQ、MSN等平台作为服务并以此为凭据的权利，我们只接受正规的传真、书面、网上业务平台提交、电子邮件即时申请服务。<br />
	　　10、 逐浪软件将动态更新、发布公告，并于本网站[网址：www.hx008.com]发布，网站公示信息作为版权与法律申明的一部份，纳入服务权益与协议约定。<br />
	　　11、 逐浪软件官网刊登信息中可能包含一部份版权不明信息，我们刊发这部份信息是用于知识性研究，如果有冒犯请随时联系我们，我们收到反馈后即立即删除。<br />
	　　12、 无论任何条件，逐浪软件优先保留法律允许范围内的最终解释权，常年法律顾问：朗秋|<a href="http://www.hx008.com/corp/1240.shtml" target="_blank">刘平律师</a>。<br />
	<br />
	<font color="#0000ff">本网站核心程序使《逐浪CMS智能建站管理系统》，更多网站建设资讯详见<a href="http://www.zoomla.cn">www.zoomla.cn</a>。</font></p>',N'本站编辑',N'0')
INSERT [ZL_C_Article] ([ID],[author],[source],[synopsis],[content],[Edit],[K_pages]) VALUES ( 9,N'admin',N'本站原创',N'鸣谢名单',N'<p>
	鸣谢名单：</p>
<p>
	Zoomla！逐浪CMS</p>
<p>
	华夏互联</p>
<p>
	上海逐一软件</p>',N'本站编辑',N'0')
SET IDENTITY_INSERT [ZL_C_Article] OFF

GO
CREATE TABLE [dbo].[ZL_C_FriendSite] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[url] [nvarchar]  (255) NULL DEFAULT (''),
[logo] [nvarchar]  (255) NULL DEFAULT (''),
[leis] [nvarchar]  (255) NULL DEFAULT (''))

ALTER TABLE [ZL_C_FriendSite] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_FriendSite] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_FriendSite] ON
INSERT [ZL_C_FriendSite] ([ID],[url],[logo],[leis]) VALUES ( 1,N'http://www.hx008.com',N'http://hx008.com/images/logo.gif',N'合作网站')
INSERT [ZL_C_FriendSite] ([ID],[url],[leis]) VALUES ( 2,N'http://www.1th.com',N'合作网站')
INSERT [ZL_C_FriendSite] ([ID],[url],[logo],[leis]) VALUES ( 3,N'http://home.hx008.com/',N'http://www.hx008.com/Template/hx008/style/images/logo.jpg',N'合作网站')
INSERT [ZL_C_FriendSite] ([ID],[url],[logo],[leis]) VALUES ( 4,N'http://www.zoomla.cn',N'http://zoomla.cn/skin/2010/images/logo.j',N'合作网站')
SET IDENTITY_INSERT [ZL_C_FriendSite] OFF

Go
CREATE TABLE [dbo].[ZL_C_Photo] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[author] [nvarchar]  (255) NULL,
[content] [ntext]  NULL,
[source] [nvarchar]  (255) NULL DEFAULT (''),
[PhotoUrlThum] [nvarchar]  (255) NULL DEFAULT (''),
[PhotoUrl] [ntext]  NULL DEFAULT (''),
[synopsis] [ntext]  NULL DEFAULT (''))

ALTER TABLE [ZL_C_Photo] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_Photo] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_Photo] ON
INSERT [ZL_C_Photo] ([ID],[author],[content],[source],[PhotoUrlThum],[PhotoUrl],[synopsis]) VALUES ( 1,N'admin',N'<p>
产品展示：</p>
<p>无限节点生成</p>
<p>一对一专家级指导</p>
<p>科技实业缔造未来</p>
<p>专业解决方案服务商</p>
<p>可卸式自由模板设计</p>',N'本站原创',N'demo/ad2.jpg',N'图片地址1|http://www.zoomla.cn/skin/default/productshow1.jpg$图片地址2|http://www.zoomla.cn/skin/default/productshow2.jpg$图片地址3|http://www.zoomla.cn/skin/default/productshow3.jpg$图片地址4|http://www.zoomla.cn/skin/default/productshow4.jpg$图片地址5|http://www.zoomla.cn/skin/default/productshow7.jpg',N'无限节点生成、一对一专家级指导、科技实业缔造未来、专业解决方案服务商、可卸式自由模板设计')
SET IDENTITY_INSERT [ZL_C_Photo] OFF

GO
CREATE TABLE [dbo].[ZL_C_RedirectLink] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[RedirectLink] [nvarchar]  (255) NULL DEFAULT (''))

ALTER TABLE [ZL_C_RedirectLink] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_RedirectLink] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_RedirectLink] ON
INSERT [ZL_C_RedirectLink] ([ID],[RedirectLink]) VALUES ( 1,N'http://www.zoomla.cn/mtv/')
INSERT [ZL_C_RedirectLink] ([ID],[RedirectLink]) VALUES ( 2,N'http://www.zoomla.cn/corp/video/1880.shtml')
SET IDENTITY_INSERT [ZL_C_RedirectLink] OFF

GO
CREATE TABLE [dbo].[ZL_C_soft] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[source] [nvarchar]  (255) NULL DEFAULT (''),
[explain] [ntext]  NULL DEFAULT (''),
[content] [ntext]  NULL DEFAULT (''),
[Edit] [nvarchar]  (255) NULL DEFAULT (''),
[Soft_pic] [nvarchar]  (255) NULL DEFAULT (''),
[DownUrlthum] [nvarchar]  (255) NULL DEFAULT (''),
[DownUrl] [ntext]  NULL DEFAULT ('')
)
ALTER TABLE [ZL_C_soft] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_soft] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_soft] ON
INSERT [ZL_C_soft] ([ID],[source],[explain],[content],[Edit],[Soft_pic],[DownUrl]) VALUES ( 1,N'本站原创',N'《福地》写一百年来，王兴一家三代在大沙漠里追寻一个名叫“紫城”的的地方。只有到了紫城，才能活得幸福。他们在追寻紫城的过程中，表现出异乎寻常的顽强意志和牺牲精神。为了走紫城，王家第一代王兴葬身茫茫沙海；为了走紫城，王家第二代王孚宁肯娶一个嫁过人的佣人为妻，只因为佣人能为他生下儿子；为了走紫城，王孚美丽漂亮的妹妹王幻幻忍痛放弃最心爱的恋人杨二狗，嫁给丑陋不堪却身体强健的陈老大；为了走紫城，王孚不惜动用家法，活活烧死反',N'<p>
《福地》写一百年来，王兴一家三代在大沙漠里追寻一个名叫&ldquo;紫城&rdquo;的的地方。只有到了紫城，才能活得幸福。他们在追寻紫城的过程中，表现出异乎寻常的顽强意志和牺牲精神。为了走紫城，王家第一代王兴葬身茫茫沙海；为了走紫城，王家第二代王孚宁肯娶一个嫁过人的佣人为妻，只因为佣人能为他生下儿子；为了走紫城，王孚美丽漂亮的妹妹王幻幻忍痛放弃最心爱的恋人杨二狗，嫁给丑陋不堪却身体强健的陈老大；为了走紫城，王孚不惜动用家法，活活烧死反对走紫城的二儿子王仁&hellip;&hellip;</p>
<p>改革开放后，王家第三代王颖又成为新的暴发户。面对现代化优裕便捷的生活，王颖依然感到不幸福，依然感到彷徨和失落，他日思夜梦向往的，依然是沙漠深处的那座紫城。最后，他亲手杀死因吸毒而败家的儿子，又到大沙漠里追寻那座神圣的紫城去了。</p>',N'本站编辑',N'http://vipbook.sinaedge.com/bookcover/tiny85/215/cover_85f34d57ddd0837da51f94e9bd008e7e.jpg',N'图片地址1|http://vipbook.sinaedge.com/bookcover/tiny85/215/cover_85f34d57ddd0837da51f94e9bd008e7e.jpg')
SET IDENTITY_INSERT [ZL_C_soft] OFF

GO
CREATE TABLE [dbo].[ZL_C_video] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[author] [nvarchar]  (255) NULL DEFAULT (''),
[source] [nvarchar]  (255) NULL DEFAULT (''),
[synopsis] [ntext]  NULL DEFAULT (''),
[content] [ntext]  NULL DEFAULT (''),
[url] [nvarchar]  (255) NULL DEFAULT (''),
[pic] [nvarchar]  (255) NULL DEFAULT (''),
[Edit] [nvarchar]  (255) NULL DEFAULT (''))

ALTER TABLE [ZL_C_video] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_video] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_video] ON
INSERT [ZL_C_video] ([ID],[author],[source],[synopsis],[content],[url],[pic],[Edit]) VALUES ( 1,N'admin',N'本站原创',N'逐浪软件',N'<p>
逐浪软件</p>',N'http://www.zoomla.cn/down/zoomla_video.flv',N'3D/200912/200912111913258191.jpg',N'本站编辑')
SET IDENTITY_INSERT [ZL_C_video] OFF

GO
CREATE TABLE [dbo].[ZL_C_Info] (
[ID] [int]  IDENTITY (1, 1)  NOT NULL,
[lxr] [nvarchar]  (255) NULL DEFAULT (''),
[tel] [nvarchar]  (255) NULL DEFAULT (''),
[qq] [nvarchar]  (255) NULL DEFAULT (''),
[content] [ntext]  NULL DEFAULT (''),
[addr] [nvarchar]  (255) NULL DEFAULT (''),
[slPic] [nvarchar]  (255) NULL DEFAULT (''),
[pics] [ntext]  NULL DEFAULT (''),
[synopsis] [ntext]  NULL DEFAULT (''))

ALTER TABLE [ZL_C_Info] WITH NOCHECK ADD  CONSTRAINT [PK_ZL_C_Info] PRIMARY KEY  NONCLUSTERED ( [ID] )
SET IDENTITY_INSERT [ZL_C_Info] ON
INSERT [ZL_C_Info] ([ID],[lxr],[tel],[qq],[content],[addr],[slPic],[synopsis]) VALUES ( 1,N'登峰文化传媒',N'13556666660',N'1202121245',N'<p>
	景德镇登峰文化传媒有限公司，是一家秉承了工艺美院深厚的学术文化，激发学生社会实践的青春热情，整合校园内部优质资源为的商业生产力。开创一条&ldquo;教以致才，学以致用，商以致功&rdquo;的新型商业营销模式。公司致力于为企业及个人提供专业化、个性化、市场化的视觉营销服务，以帮助客户从容应对须臾万变的现代营销市场&hellip;&hellip;<br />
	联系我时，请说是在景德镇为民网上看到的，谢谢！</p>',N'北京市|北京辖区|西城区',N'http://vipbook.sinaedge.com/bookcover/tiny85/215/cover_85f34d57ddd0837da51f94e9bd008e7e.jpg',N'景德镇登峰文化传媒有限公司，是一家秉承了工艺美院深厚的学术文化，激发学生社会实践的青春热情，整合校园内部优质资源为的商业生产力。开创一条“教以致才，学以致用，商以致功”的新型商业营销模式。公司致力于为企业及个人提供专业化、个性化、市场化的视觉营销服务，以帮助客户从容应对须臾万变的现代营销市场……')
INSERT [ZL_C_Info] ([ID],[lxr],[tel],[qq],[content],[addr],[slPic],[pics]) VALUES ( 2,N'魏先生',N'13556666660',N'1032542421',N'<p>
&nbsp;</p>
<p>本人出售自用私家车07年吉利自由舰，银灰色，车况良好，售价2万，非诚勿扰。<br />
	联系我时，请说是在景德镇为民网上看到的，谢谢！</p>',N'江西省|南昌市|东湖区',N'jlxx/jpg/2012/5/2012050710494995340.jpg',N'图片地址1|jlxx/jpg/2012/5/2012050710494995340.jpg')
INSERT [ZL_C_Info] ([ID],[lxr],[tel],[qq],[content],[addr],[slPic],[synopsis]) VALUES ( 8,N'yansh',N'0791-8303888',N'1032542421',N'<p>
	二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd</p>
<p>二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd</p>
<p>二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd</p>',N'北京市|北京辖区|东城区',N'http://vipbook.sinaedge.com/bookcover/tiny85/215/cover_85f34d57ddd0837da51f94e9bd008e7e.jpg',N'二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd二手房新想dd')
INSERT [ZL_C_Info] ([ID],[lxr],[tel],[qq],[content],[addr],[slPic],[synopsis]) VALUES ( 9,N'zoomla',N'0791-8303888',N'1032542421',N'<p>
	是对方是否</p><p>是对方是否</p>
<p>是对方是否</p>
<p>是对方是否</p>
<p>是对方是否</p>',N'北京市|北京辖区|东城区',N'demo/ad1.jpg',N'是对方是否')
SET IDENTITY_INSERT [ZL_C_Info] OFF

 CREATE TABLE [dbo].[ZL_Page_Content] (  [ID] [int] IDENTITY (1, 1) NOT NULL , [Content] [ntext] NULL )
 ALTER TABLE [dbo].[ZL_Page_Content] WITH NOCHECK ADD CONSTRAINT [DF_ZL_Page_Content_Content] DEFAULT ('') FOR [Content],CONSTRAINT [PK_ZL_Page_Content] PRIMARY KEY  NONCLUSTERED ( [ID] )

CREATE TABLE [dbo].[ZL_U_comp] (  [ID] [int] IDENTITY (1, 1) NOT NULL ,  [UserID] [int] NOT NULL , [UserName] [varchar] (255) NULL ,  [Styleid] [int] NULL , [Recycler] [bit] NULL , [IsCreate] [bit] NULL , [NewTime] [datetime]  NULL , [name] [nvarchar] (255) NULL , [time] [nvarchar] (255) NULL , [info] [ntext] NULL , [jobs] [nvarchar] (255) NULL )
 ALTER TABLE [dbo].[ZL_U_comp] WITH NOCHECK ADD CONSTRAINT [DF_ZL_U_comp_UserID] DEFAULT (null) FOR [UserID],CONSTRAINT [DF_ZL_U_comp_Styleid] DEFAULT (0) FOR [Styleid],CONSTRAINT [DF_ZL_U_comp_Recycler] DEFAULT (0) FOR [Recycler],CONSTRAINT [DF_ZL_U_comp_IsCreate] DEFAULT (0) FOR [IsCreate],CONSTRAINT [DF_ZL_U_comp_name] DEFAULT ('') FOR [name],CONSTRAINT [DF_ZL_U_comp_time] DEFAULT ('') FOR [time],CONSTRAINT [DF_ZL_U_comp_info] DEFAULT ('') FOR [info],CONSTRAINT [DF_ZL_U_comp_jobs] DEFAULT ('是') FOR [jobs],CONSTRAINT [PK_ZL_U_comp] PRIMARY KEY  NONCLUSTERED ( [ID] )

 CREATE TABLE [dbo].[ZL_U_jl] (  [ID] [int] IDENTITY (1, 1) NOT NULL ,  [UserID] [int] NOT NULL , [UserName] [varchar] (255) NULL ,  [Styleid] [int] NULL , [Recycler] [bit] NULL , [IsCreate] [bit] NULL , [NewTime] [datetime]  NULL , [jiguan] [nvarchar] (255) NULL , [hukou] [nvarchar] (255) NULL , [zhuanye] [nvarchar] (255) NULL , [zhiwei] [nvarchar] (255) NULL , [name] [nvarchar] (255) NULL , [sex] [nvarchar] (255) NULL )
 ALTER TABLE [dbo].[ZL_U_jl] WITH NOCHECK ADD CONSTRAINT [DF_ZL_U_jl_UserID] DEFAULT (null) FOR [UserID],CONSTRAINT [DF_ZL_U_jl_Styleid] DEFAULT (0) FOR [Styleid],CONSTRAINT [DF_ZL_U_jl_Recycler] DEFAULT (0) FOR [Recycler],CONSTRAINT [DF_ZL_U_jl_IsCreate] DEFAULT (0) FOR [IsCreate],CONSTRAINT [DF_ZL_U_jl_jiguan] DEFAULT ('') FOR [jiguan],CONSTRAINT [DF_ZL_U_jl_hukou] DEFAULT ('') FOR [hukou],CONSTRAINT [DF_ZL_U_jl_zhuanye] DEFAULT ('') FOR [zhuanye],CONSTRAINT [DF_ZL_U_jl_zhiwei] DEFAULT ('') FOR [zhiwei],CONSTRAINT [DF_ZL_U_jl_name] DEFAULT ('') FOR [name],CONSTRAINT [DF_ZL_U_jl_sex] DEFAULT ('') FOR [sex],CONSTRAINT [PK_ZL_U_jl] PRIMARY KEY  NONCLUSTERED ( [ID] )

 CREATE TABLE [dbo].[ZL_U_zp] (  [ID] [int] IDENTITY (1, 1) NOT NULL ,  [UserID] [int] NOT NULL , [UserName] [varchar] (255) NULL ,  [Styleid] [int] NULL , [Recycler] [bit] NULL , [IsCreate] [bit] NULL , [NewTime] [datetime]  NULL , [name] [varchar] (255) NULL , [edu] [varchar] (255) NULL , [shi] [varchar] (255) NULL , [menoy] [nvarchar] (255) NULL )
 ALTER TABLE [dbo].[ZL_U_zp] WITH NOCHECK ADD CONSTRAINT [DF_ZL_U_zp_UserID] DEFAULT (null) FOR [UserID],CONSTRAINT [DF_ZL_U_zp_Styleid] DEFAULT (0) FOR [Styleid],CONSTRAINT [DF_ZL_U_zp_Recycler] DEFAULT (0) FOR [Recycler],CONSTRAINT [DF_ZL_U_zp_IsCreate] DEFAULT (0) FOR [IsCreate],CONSTRAINT [DF_ZL_U_zp_menoy] DEFAULT ('') FOR [menoy],CONSTRAINT [PK_ZL_U_zp] PRIMARY KEY  NONCLUSTERED ( [ID] )

SET IDENTITY_INSERT [ZL_Model] ON
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 1,N'公告',N'发布简明信息',N'ZL_C_Announce',N'公告',N'条',N'glyphicon glyphicon-list-alt',N'内容页/默认公告内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 2,N'文章模型',N'用于装载常见的文章信息，如文章、新闻、资讯等。',N'ZL_C_Article',N'文章',N'篇',N'fa fa-file-word-o',N'内容页/两列式标准内容页.html',1,1,0,1,0,1)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 3,N'图库模型',N'可发布图文并茂的信息，并通过丰富的图片展示分享网络的乐趣。',N'ZL_C_Photo',N'图片',N'张',N'fa fa-file-photo-o',N'内容页/默认图库模型内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 4,N'下载模型',N'基于文件发布与资源共享的功能，并可进行下载收费等二次开发。',N'ZL_C_soft',N'软件',N'个',N'glyphicon glyphicon-save',N'内容页/默认下载模型内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 5,N'转向链接模型',N'访客点击此模型下信息，则跳入指定第三方链接，便于流量管理。',N'ZL_C_RedirectLink',N'跳转',N'个',N'glyphicon glyphicon-link',N'内容页/默认转向链接模型内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 6,N'商品模型',N'建立起商品模型用于销售，开展网上电子业务。',N'ZL_P_Shop',N'商品',N'件',N'glyphicon glyphicon-shopping-cart',N'内容页/默认商品模型内容页.html',2,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 7,N'视频模型',N'基于FLV等类型的视频发布系统，高速视频抢占信息时代之商机。',N'ZL_C_video',N'视频',N'个',N'glyphicon glyphicon-film',N'内容页/默认视频模型内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 8,N'友情链接',N'通过与网民交换友情链接，提升网站PR值和友好的互访机制。',N'ZL_C_FriendSite',N'网站',N'个',N'glyphicon glyphicon-hand-right',N'内容页/默认友情链接内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 9,N'默认申请样式',N'默认申请样式',N'ZL_Reg_Page',10,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 10,N'企业信息',N'ZL_U_comp',N'信息',N'条',N'glyphicon glyphicon-euro',3,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 11,N'招聘信息',N'提供给企业用户发布招聘信息',N'ZL_U_ZP',N'信息',3,1,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 12,N'个人简历',N'提供给个人用户录入',N'ZL_U_jl',N'信息',3,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 17,N'留言文章投票的模型',N'ZL_Pub_WZTP',N'留言',N'条',N'glyphicon glyphicon-align-center',N'/互动模板/默认留言文章投票模板.html',7,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 18,N'问券在线调查的模型',N'ZL_Pub_ZXDC',N'问券',N'条',N'glyphicon glyphicon-file',N'/互动模板/默认问券在线调查模板.html',7,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 19,N'信息模型',N'ZL_C_Info',N'信息',N'条',N'fa  fa-file-text-o',N'内容页/默认信息模型内容页.html',1,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 20,N'店铺商品',N'ZL_S_shop',N'商品',N'件',N'glyphicon glyphicon-home',N'内容页/默认店铺商品内容页.html',5,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 21,N'留言提问的模型',N'ZL_Pub_TW',N'留言',N'条',N'glyphicon glyphicon-align-center',N'/互动模板/默认留言提问模板.html',7,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 22,N'评论问题回答的模型',N'ZL_Pub_WTHD',N'评论',N'条',N'glyphicon glyphicon-align-center',N'/互动模板/默认评论问题回答模板.html',7,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 23,N'评论最佳答案的模型',N'ZL_Pub_ZJDA',N'评论',N'条',N'glyphicon glyphicon-align-center',N'/互动模板/默认评论最佳答案模板.html',7,0,0,0,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Islotsize]) VALUES ( 24,N'店铺申请',N'ZL_Store_reg',N'店铺',N'个',N'glyphicon glyphicon-shopping-cart',N'内容页/默认店铺申请内容页.html',6,1,0,1,0,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[Description],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 25,N'文件工厂模型',N'用字段信息配合Word模板，生成新的Word文档.',N'ZL_C_Factory',N'文件工厂',N'份',N'glyphicon glyphicon-file',N'/内容页/默认文件工厂模型内容页.html',1,1,0,1,0,1,0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 35,N'收文模型',N'ZL_OAC_swmx',N'文章',N'篇',N'Default.gif',N'内容页/默认收文模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 36,N'发文模型',N'ZL_OAC_fwmx',N'文章',N'篇',N'Default.gif',N'内容页/默认发文模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 37,N'请假模型',N'ZL_OAC_qjmx',N'文章',N'篇',N'Default.gif',N'内容页/默认请假模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 38,N'会议模型',N'ZL_OAC_kymx',N'文章',N'篇',N'Default.gif',N'内容页/默认会议模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 39,N'收文模型',N'ZL_OAC_swmx',N'文章',N'篇',N'glyphicon glyphicon-briefcase',N'内容页/默认收文模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 40,N'收文模型',N'ZL_OAC_swmx',N'文章',N'篇',N'glyphicon glyphicon-briefcase',N'内容页/默认收文模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 41,N'发文模型',N'ZL_OAC_fwmx',N'文章',N'篇',N'glyphicon glyphicon-briefcase',N'内容页/默认发文模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 42,N'请假模型',N'ZL_OAC_qjmx',N'文章',N'篇',N'glyphicon glyphicon-bookmark',N'内容页/默认请假模型内容页.html',12,1,0,1,0,N'0',0)
INSERT [ZL_Model] ([ModelID],[ModelName],[TableName],[ItemName],[ItemUnit],[ItemIcon],[ContentTemplate],[ModelType],[MultiFlag],[NodeID],[SysModel],[FromModel],[Thumbnail],[Islotsize]) VALUES ( 43,N'会议模型',N'ZL_OAC_kymx',N'文章',N'篇',N'glyphicon glyphicon-compressed',N'内容页/默认会议模型内容页.html',12,1,0,1,0,N'0',0)
SET IDENTITY_INSERT [ZL_Model] OFF

SET IDENTITY_INSERT [ZL_ModelField] ON
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1,0,N'Title',N'内容标题',1,0,N'TextType',0,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2,0,N'NodeID',N'所属节点',1,0,N'TextType',1,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 3,0,N'SpecialID',N'所属专题',0,0,N'TextType',2,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 4,0,N'InfoID',N'其他节点',0,0,N'TextType',3,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 5,0,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 6,0,N'Hits',N'点击数',0,0,N'NumType',5,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 7,0,N'GeneralID',N'内容ID',0,0,N'TextType',6,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 8,0,N'Tagkey',N'关键字',0,0,N'TextType',7,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 9,0,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 10,0,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 12,0,N'IsCreate',N'是否已生成',0,0,N'NumType',10,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 13,0,N'InPuter',N'录入者',0,0,N'TextType',11,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 14,0,N'Status',N'状态',0,0,N'NumType',12,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 15,0,N'UpDateTime',N'更新时间',0,0,N'DateType',13,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 16,0,N'CreateTime',N'生成时间',0,0,N'DateType',14,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 17,0,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 18,0,N'PdfLink',N'PDF地址',0,0,N'TextType',16,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 19,0,N'tablename',N'表名',1,0,N'TextType',17,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 20,0,N'ItemID',N'表的记录',0,0,N'TextType',18,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 21,0,N'Template',N'模板',0,0,N'TextType',19,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 22,0,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 23,0,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 24,0,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 25,0,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 26,1,N'Title',N'公告标题',1,0,N'TextType',N'TitleSize=30,IsPassword=text,DefaultValue=',0,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 27,1,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 28,1,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 29,1,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 30,1,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 31,1,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 32,1,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 33,1,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 34,1,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 35,1,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 36,1,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 37,1,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 38,1,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 39,1,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 40,1,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 41,1,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 42,1,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 43,1,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 44,1,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 45,1,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 46,1,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 47,1,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 48,1,N'FirstNodeID',N'根节点ID',0,0,N'NumType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 49,1,N'TitleStyle',N'标题样式',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 50,1,N'content',N'公告内容',0,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=3',22,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 51,1,N'author',N'发布者',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 52,2,N'Title',N'内容标题',1,0,N'TextType',N'TitleSize=30,IsPassword=text,DefaultValue=',0,1,0,1,1,0,0,0,1,0,1,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 53,2,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 54,2,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 55,2,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 56,2,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 57,2,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 58,2,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 59,2,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 60,2,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 61,2,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 62,2,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 63,2,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 64,2,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 65,2,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 66,2,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 67,2,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 68,2,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 69,2,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 70,2,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 71,2,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 72,2,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 73,2,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 74,2,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 75,2,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 76,2,N'author',N'作者',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者',20,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 77,2,N'source',N'来源',1,0,N'OptionType',N'1=本站原创|本站原创$0||网络摘抄|网络摘抄$0||网友投稿|网友投稿$0,Property=True,Default=',21,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 78,2,N'synopsis',N'简介',0,0,N'MultipleTextType',N'Width=715,Height=80',22,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 79,2,N'content',N'内容',1,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=3',23,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 80,2,N'Edit',N'责任编辑',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=本站编辑',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 81,2,N'pic',N'附属图片',0,0,N'PicType',N'Warter=0,MaxPicSize=102400,PicFileExt=jpg|gif|bmp|jpeg|png',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 82,2,N'pages',N'分页字符数',N'请输入分页字符数,为空则不分页。',0,0,N'TextType',N'TitleSize=8,IsPassword=text,DefaultValue=',26,1,0,1,1,0,0,0,0,0,1,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 83,2,N'K_pages',N'分页形式',N'如选择手动分页,则请将[PageCode/]手动分页符放到想要分页的位置即可。',0,0,N'OptionType',N'1=不分页|0$0||自动分页|1$0||手动分页|2$0,Property=True,Default=',27,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 84,3,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 85,3,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 86,3,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 87,3,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 88,3,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 89,3,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 90,3,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 91,3,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 92,3,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 93,3,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 94,3,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 95,3,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 96,3,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 97,3,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 98,3,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 99,3,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 100,3,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 101,3,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 102,3,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 103,3,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 104,3,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 105,3,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 106,3,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 107,3,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 108,3,N'source',N'来源',1,0,N'OptionType',N'1=本站原创|本站原创$0||佚名|佚名$0||无名氏|无名氏$0||网友投稿|网友投稿$0,Property=True,Default=',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 111,4,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 112,4,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 113,4,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 114,4,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 115,4,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 116,4,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 117,4,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 118,4,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 119,4,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 120,4,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 121,4,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 122,4,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 123,4,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 124,4,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 125,4,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 126,4,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 127,4,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 128,4,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 129,4,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 130,4,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 131,4,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 132,4,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 133,4,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 134,4,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 135,4,N'source',N'来源',1,0,N'OptionType',N'1=本站原创|本站原创$0||佚名|佚名$0||无名氏|无名氏$0||网友投稿|网友投稿$0,Property=True,Default=',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 136,4,N'explain',N'简介',0,0,N'MultipleTextType',N'Width=500,Height=200',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 137,4,N'content',N'下载说明',1,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=3',26,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 138,4,N'Edit',N'责任编辑',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=本站编辑',27,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 139,4,N'Soft_pic',N'软件缩略图',0,0,N'PicType',N'Warter=0,MaxPicSize=102400,PicFileExt=jpg|jpeg|bmp|gif|png',28,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 140,5,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 141,5,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 142,5,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 143,5,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 144,5,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 145,5,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 146,5,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 147,5,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 148,5,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 149,5,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 150,5,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 151,5,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 152,5,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 153,5,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 154,5,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 155,5,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 156,5,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 157,5,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 158,5,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 159,5,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 160,5,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 161,5,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 162,5,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 163,5,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 164,5,N'RedirectLink',N'跳转网址',1,0,N'SuperLinkType',N'TitleSize=50,DefaultValue=http://',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 165,6,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 166,6,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 167,6,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 168,6,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 169,6,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 170,6,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 171,6,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 172,6,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 173,6,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 174,6,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 175,6,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 176,6,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 177,6,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 178,6,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 179,6,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 180,6,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 181,6,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 182,6,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 183,6,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 184,6,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 185,6,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 186,6,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 187,6,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 188,6,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 189,6,N'is_chu',N'是否促销',0,0,N'OptionType',N'2=否||是,Property=True,Default=',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 190,7,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 191,7,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 192,7,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 193,7,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 194,7,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 195,7,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 196,7,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 197,7,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 198,7,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 199,7,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 200,7,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 201,7,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 202,7,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 203,7,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 204,7,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 205,7,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 206,7,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 207,7,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 208,7,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 209,7,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 210,7,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 211,7,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 212,7,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 213,7,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 214,7,N'author',N'作者',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 215,7,N'source',N'来源',1,0,N'OptionType',N'1=本站原创|本站原创$0||网络摘抄|网络摘抄$0||网友投稿|网友投稿$0,Property=True,Default=',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 216,7,N'synopsis',N'简介',0,0,N'MultipleTextType',N'Width=500,Height=200',26,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 217,7,N'content',N'视频说明',0,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=2',27,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 218,7,N'url',N'视频地址',N'请输入视频网址，如http://www.zoomla.cn/video.flv',1,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=http://',28,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 219,8,N'Title',N'网站名称',1,0,N'TextType',N'TitleSize=30,IsPassword=text,DefaultValue=',0,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 220,8,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 221,8,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 222,8,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 223,8,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 224,8,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 225,8,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 226,8,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 227,8,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 228,8,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 229,8,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 230,8,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 231,8,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 232,8,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 233,8,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 234,8,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 235,8,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 236,8,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 237,8,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 238,8,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 239,8,N'Subtitle',N'副标题',0,0,N'TextType',20,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 240,8,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 241,8,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 242,8,N'TitleStyle',N'标题样式',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 243,8,N'url',N'网址',1,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=http://',21,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 244,8,N'logo',N'网站LOGO',N'输入网站LOGO地址',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',22,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 245,8,N'leis',N'链接类型',0,0,N'OptionType',N'1=合作网站||媒体推介||财经分享||学术研究,Property=True,Default=',20,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 250,10,N'Content',N'详细信息',0,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=3',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 251,7,N'pic',N'缩略图',N'用于显示视频播放效果的缩图略，推荐为JPG格式。',0,0,N'PicType',N'Warter=0,MaxPicSize=102400,PicFileExt=jpg|jpeg|bmp|gif|png',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 252,7,N'Edit',N'责任编辑',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=本站编辑',26,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 254,10,N'name',N'企业名称',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',0,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 255,11,N'name',N'职位名称',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',0,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 256,11,N'menoy',N'薪资待遇',0,0,N'OptionType',N'1=1500以下|1500以下||1500-2000|1500-2000||2000-3000|2000-3000||3000-4000|3000-4000||4000-5000|4000-5000||5000以上|5000以上||面议|面议,Property=True,Default=',1,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 257,11,N'edu',N'学历要求',0,0,N'OptionType',N'1=不限学历|不限学历||高中以上|高中以上||中专以上|中专以上||大学以上|大学以上||更高学历|更高学历,Property=True,Default=',2,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 258,11,N'shi',N'就职形式',0,0,N'OptionType',N'1=全职|全职||兼职|兼职||家政|家政||临时工|临时工,Property=True,Default=',3,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 259,10,N'time',N'成立时间',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',1,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 260,10,N'info',N'公司简介',0,0,N'MultipleTextType',N'Width=500,Height=200',2,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 261,10,N'jobs',N'求职职位',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',3,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 262,12,N'jiguan',N'籍贯',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',2,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 263,12,N'hukou',N'户口',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',3,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 264,12,N'zhuanye',N'专业',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',4,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 265,12,N'zhiwei',N'求职职位',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',5,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 266,12,N'name',N'个人姓名',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',0,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 267,12,N'sex',N'性别',0,0,N'OptionType',N'2=男||女,Property=True,Default=',1,0,10,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 324,3,N'Content',N'图库说明',0,0,N'MultipleHtmlType',N'Width=715,Height=200,IsEditor=3',28,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 325,3,N'author',N'作者',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 975,6,N'size',N'尺寸',0,0,N'ListBoxType',N'1=M|L|S',26,0,0,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 976,6,N'color',N'颜色',0,0,N'ListBoxType',N'1=白色|紫色|蓝色|红色',27,0,0,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 980,6,N'Nums',N'商品参数',0,0,N'ListBoxType',N'3=2008款|2008款$0||2009款|2009款$0||2010款|2010款$0||2011款|2011款$0||2012款|2012款$0',29,0,0,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1049,3,N'PhotoUrl',N'图片地址',0,0,N'SwfFileUpload',N'MaxFileSize=102400,UploadFileExt=jpg|gif|bmp|png|jpeg',29,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1050,3,N'PhotoUrlThum',N'缩略图',0,0,N'PicType',N'Warter=0,MaxPicSize=102400,PicFileExt=jpg|gif|bmp|png|jpeg',30,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1051,4,N'DownUrl',N'下载地址',0,0,N'SwfFileUpload',N'MaxFileSize=102400,UploadFileExt=rar|zip|doc|docx|xls|ppt|pptx|pps',29,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1080,6,N'picture',N'多图片',0,0,N'SwfFileUpload',N'ChkFileSize=0,FileSizeField=,MaxFileSize=102400,UploadFileExt=jpg|gif|bmp|png|jpeg',30,0,0,1,0,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1081,18,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1082,18,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1083,18,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1084,18,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1085,18,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1086,18,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1087,18,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1088,18,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1089,18,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1090,18,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1091,18,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1092,18,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1093,18,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1094,18,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1095,18,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1096,18,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1097,18,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1098,18,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1099,18,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1100,18,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1101,18,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1102,18,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1103,18,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1104,18,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1105,19,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1106,19,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1107,19,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1108,19,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1109,19,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1110,19,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1111,19,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1112,19,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1113,19,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1114,19,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1115,19,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1116,19,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1117,19,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1118,19,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1119,19,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1120,19,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1121,19,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1122,19,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1123,19,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1124,19,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1125,19,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1126,19,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1127,19,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1128,19,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1129,19,N'lxr',N'联系人',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1130,19,N'tel',N'联系电话',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1131,19,N'qq',N'QQ/MSN',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',26,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1132,19,N'content',N'详细信息',0,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=1',27,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1133,19,N'addr',N'所属地区',0,0,N'GradeOptionType',N'GradeCate=a,Direction=0',28,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1134,19,N'pics',N'图片上传',0,0,N'MultiPicType',N'ChkThumb=1,ThumbField=slPic,Warter=0,MaxPicSize=102400,PicFileExt=jpg|gif|bmp|png|jpeg',29,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1135,3,N'synopsis',N'简介',0,0,N'MultipleTextType',N'Width=500,Height=60',31,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1136,19,N'synopsis',N'简介',0,0,N'MultipleTextType',N'Width=500,Height=60',30,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1137,20,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1138,20,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1139,20,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1140,20,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1141,20,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1142,20,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1143,20,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1144,20,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1145,20,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1146,20,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1147,20,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1148,20,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1149,20,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1150,20,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1151,20,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1152,20,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1153,20,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1154,20,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1155,20,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1156,20,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1157,20,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1158,20,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1159,20,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1160,20,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1162,21,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1163,21,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1164,21,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1165,21,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1166,21,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1167,21,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1168,21,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1169,21,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1170,21,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1171,21,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1172,21,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1173,21,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1174,21,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1175,21,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1176,21,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1177,21,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1178,21,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1179,21,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1180,21,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1181,21,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1182,21,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1183,21,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1184,21,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1185,21,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1186,22,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1187,22,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1188,22,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1189,22,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1190,22,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1191,22,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1192,22,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1193,22,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1194,22,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1195,22,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1196,22,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1197,22,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1198,22,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1199,22,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1200,22,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1201,22,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1202,22,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1203,22,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1204,22,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1205,22,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1206,22,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1207,22,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1208,22,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1209,22,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1210,23,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1211,23,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1212,23,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1213,23,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1214,23,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1215,23,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1216,23,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1217,23,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1218,23,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1219,23,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1220,23,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1221,23,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1222,23,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1223,23,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1224,23,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1225,23,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1226,23,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1227,23,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1228,23,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1229,23,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1230,23,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1231,23,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1232,23,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1233,23,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1234,21,N'ClassLevel1',N'问题大类',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1235,21,N'ClassLevel2',N'问题小类',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1237,22,N'tuijian',N'精彩问题推荐',0,0,N'OptionType',N'1=是||否,Property=True,Default=',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1238,22,N'setresult',N'设为答案',0,0,N'OptionType',N'1=是||否,Property=True,Default=',26,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1239,22,N'getid',N'问题ID',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',27,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1240,22,N'textfield',N'参考资料',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',28,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1241,23,N'daid',N'答案id',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1242,23,N'getid',N'问题ID',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1243,24,N'area',N'所属地区',0,0,N'GradeOptionType',N'GradeCate=a,Direction=0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1244,24,N'logo',N'店铺logo',0,0,N'PicType',N'Warter=0,MaxPicSize=102400,PicFileExt=bmp|jpg|gif|jpeg|png',1,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1245,24,N'content',N'店铺介绍',0,0,N'MultipleHtmlType',N'Width=600,Height=400,IsEditor=2',2,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1246,24,N'lxr',N'联系人',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',3,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1247,24,N'tel',N'联系方式',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',4,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1248,24,N'addr',N'详细地址',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',5,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1249,24,N'weibo',N'官方微博',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',6,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1250,24,N'map',N'地图位置',N'200*200',0,0,N'MultipleTextType',N'Width=500,Height=80',7,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1251,24,N'tyy',N'tyy',0,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=2',8,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1252,14,N'ee',N'ee',0,0,N'MultipleHtmlType',N'Width=715,Height=400,IsEditor=2',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1254,25,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1255,25,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1256,25,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1257,25,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1258,25,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1259,25,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1260,25,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1261,25,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1262,25,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1263,25,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1264,25,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1265,25,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1266,25,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1267,25,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1268,25,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1269,25,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1270,25,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1271,25,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1272,25,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1273,25,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1274,25,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1275,25,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1276,25,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1277,25,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[Description],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1278,25,N'wzbt',N'[文章标题]',N'程序会将Word模板中的"文章标题"一词，替换为用户指定的值',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=替换后的值',24,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1279,25,N'jf',N'[甲方]',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',25,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1280,25,N'yf',N'[乙方]',0,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',26,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1281,25,N'gsmc',N'[公司名称]',1,0,N'TextType',N'TitleSize=35,IsPassword=text,DefaultValue=',27,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1282,0,N'TopImg',N'扩展图片',0,0,N'TextType',23,1,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1481,20,N'pics',N'图片展示',0,0,N'Images',N'IsWater=1',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1482,26,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1483,26,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1484,26,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1485,26,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1486,26,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1487,26,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1488,26,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1489,26,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1490,26,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1491,26,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1492,26,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1493,26,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1494,26,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1495,26,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1496,26,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1497,26,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1498,26,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1499,26,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1500,26,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1501,26,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1502,26,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1503,26,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1504,26,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1505,26,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1506,26,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1507,26,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1508,26,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1509,26,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1510,26,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1511,26,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1512,26,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1513,26,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1514,26,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1515,26,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1516,26,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1517,26,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1518,26,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1519,26,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1520,26,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1521,26,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1522,26,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1523,26,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1524,26,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1525,26,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1526,26,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1527,26,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1528,26,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1529,26,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1530,26,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1531,26,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1532,26,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1533,26,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1534,26,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1535,26,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1536,26,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1537,26,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1538,27,N'a''d''s''fa''s''d''f',N'adsfasdf',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1539,26,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1540,26,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1541,26,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1542,26,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1543,26,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1544,26,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1545,26,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1546,26,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1547,26,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1548,26,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1549,26,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1550,26,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1551,26,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1552,26,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1553,26,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1554,26,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1555,26,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1556,26,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1557,26,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1558,26,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1559,26,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1560,26,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1561,26,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1562,26,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1563,26,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1564,26,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1565,26,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1566,26,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1567,26,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1568,26,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1569,26,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1570,29,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1571,29,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1572,29,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1573,29,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1574,29,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1575,29,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1576,29,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1577,29,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1578,29,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1579,29,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1580,29,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1581,29,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1582,29,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1583,29,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1584,29,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1585,29,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1586,29,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1587,29,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1588,29,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1589,29,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1590,29,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1591,29,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1592,29,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1593,29,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1594,29,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1595,29,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1596,29,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1597,29,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1598,29,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1599,29,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1600,29,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1601,26,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1602,26,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1603,26,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1604,26,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1605,26,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1606,26,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1607,26,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1608,26,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1609,26,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1610,26,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1611,26,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1612,26,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1613,26,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1614,26,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1615,26,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1616,26,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1617,26,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1618,26,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1619,26,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1620,26,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1621,26,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1622,26,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1623,26,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1624,26,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1625,26,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1626,26,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1627,26,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1628,26,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1629,26,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1630,26,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1631,26,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1632,31,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1633,31,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1634,31,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1635,31,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1636,31,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1637,31,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1638,31,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1639,31,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1640,31,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1641,31,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1642,31,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1643,31,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1644,31,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1645,31,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1646,31,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1647,31,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1648,31,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1649,31,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1650,31,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1651,31,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1652,31,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1653,31,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1654,31,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1655,31,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1656,31,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1657,31,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1658,31,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1659,31,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1660,31,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1661,31,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1662,31,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1663,32,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1664,32,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1665,32,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1666,32,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1667,32,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1668,32,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1669,32,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1670,32,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1671,32,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1672,32,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1673,32,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1674,32,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1675,32,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1676,32,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1677,32,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1678,32,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1679,32,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1680,32,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1681,32,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1682,32,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1683,32,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1684,32,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1685,32,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1686,32,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1687,32,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1688,32,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1689,32,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1690,32,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1691,32,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1692,32,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1693,32,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1694,26,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1695,26,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1696,26,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1697,26,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1698,26,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1699,26,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1700,26,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1701,26,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1702,26,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1703,26,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1704,26,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1705,26,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1706,26,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1707,26,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1708,26,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1709,26,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1710,26,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1711,26,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1712,26,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1713,26,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1714,26,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1715,26,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1716,26,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1717,26,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1718,26,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1719,26,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1720,26,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1721,26,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1722,26,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1723,26,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1724,26,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1725,26,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1726,26,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1727,26,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1728,26,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1729,26,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1730,26,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1731,26,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1732,26,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1733,26,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1734,26,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1735,26,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1736,26,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1737,26,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1738,26,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1739,26,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1740,26,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1741,26,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1742,26,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1743,26,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1744,26,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1745,26,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1746,26,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1747,26,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1748,26,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1749,26,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1750,35,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1751,35,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1752,35,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1753,35,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1754,35,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1755,35,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1756,35,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1757,35,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1758,35,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1759,35,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1760,35,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1761,35,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1762,35,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1763,35,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1764,35,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1765,35,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1766,35,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1767,35,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1768,35,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1769,35,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1770,35,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1771,35,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1772,35,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1773,35,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1774,35,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1775,35,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1776,35,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1777,35,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1778,35,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1779,35,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1780,35,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1781,35,N'swrq',N'收文日期',0,0,N'DateType',N'Type=1',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1782,35,N'wjwh',N'文件文号',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1783,35,N'lwjg',N'来文机关',0,0,N'MultipleTextType',N'Width=500,Height=100,SelUser=False,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1784,35,N'bt',N'标题',0,0,N'MultipleTextType',N'Width=500,Height=100,SelUser=False,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1785,35,N'swxl',N'收文序列',0,0,N'ListBoxType',N'2=信字|信字$0||职成字|职成字$0||社管字|社管字$0||中招字|中招字$0||校建字|校建字$0||稳定字|稳定字$0||资助字|资助字$0||校外字|校外字$0||文|文$0||字|字$0||办字|办字$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1786,35,N'gdlm',N'归档类目',0,0,N'ListBoxType',N'2=归档类目一|归档类目一$0||归档类目二|归档类目二$0||归档类目三|归档类目三$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1787,35,N'bcqx',N'保存期限',0,0,N'ListBoxType',N'1=保存一年|保存一年$0||保存二年|保存二年$0||保存五年|保存五年$0||保存十年|保存十年$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1788,36,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1789,36,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1790,36,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1791,36,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1792,36,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1793,36,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1794,36,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1795,36,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1796,36,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1797,36,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1798,36,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1799,36,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1800,36,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1801,36,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1802,36,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1803,36,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1804,36,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1805,36,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1806,36,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1807,36,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1808,36,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1809,36,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1810,36,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1811,36,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1812,36,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1813,36,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1814,36,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1815,36,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1816,36,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1817,36,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1818,36,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1819,36,N'jjqk',N'紧急情况',0,0,N'OptionType',N'1=比较急|比较急$0||一般|一般$0,Property=True,Default=',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1820,36,N'mj',N'密级',0,0,N'OptionType',N'1=重要|重要$0||一般|一般$0||很重要|很重要$0,Property=True,Default=',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1821,36,N'ngsw',N'拟稿单位',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue=,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1822,36,N'ngr',N'拟稿人',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser},SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1823,36,N'bmsh',N'部门审核',0,0,N'OptionType',N'2=审核通过|审核通过$0||未通过|未通过$0,Property=True,Default=',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1824,36,N'zs',N'主送',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1825,36,N'cb',N'抄报',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue=,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1826,36,N'cs',N'抄送',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue=,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1827,36,N'fh',N'复核',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1828,36,N'xh',N'校核',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1829,36,N'gdlm',N'归档类目',0,0,N'ListBoxType',N'2=定期一年|定期一年$0||定期三年|定期三年$0||定期七年|定期七年$0||定期十年|定期十年$0||永久|永久$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1830,36,N'bcqx',N'保存期限',0,0,N'ListBoxType',N'2=保存一年|保存一年$0||保存五年|保存五年$0||保存十年|保存十年$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1831,36,N'dj',N'等级',0,0,N'ListBoxType',N'2=重要|重要$0||一般|一般$0||很重要|很重要$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1832,36,N'bhxx',N'编号选项',0,0,N'ListBoxType',N'2=信字|信字$0||职成字|职成字$0||社管字|社管字$0||中招字|中招字$0||校建字|校建字$0||稳定字|稳定字$0||资助字|资助字$0||校外字|校外字$0||文|文$0||字|字$0||办字|办字$0',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1833,37,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1834,37,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1835,37,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1836,37,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1837,37,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1838,37,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1839,37,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1840,37,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1841,37,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1842,37,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1843,37,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1844,37,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1845,37,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1846,37,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1847,37,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1848,37,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1849,37,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1850,37,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1851,37,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1852,37,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1853,37,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1854,37,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1855,37,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1856,37,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1857,37,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1858,37,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1859,37,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1860,37,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1861,37,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1862,37,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1863,37,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1864,37,N'qjr',N'请假人',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser}|匿名|本站作者,SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1865,37,N'kssj',N'开始时间',0,0,N'DateType',N'Type=1',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1866,37,N'jssj',N'结束时间',0,0,N'DateType',N'Type=1',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1867,37,N'qjyy',N'请假原因',0,0,N'MultipleTextType',N'Width=500,Height=100,SelUser=False,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1868,38,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1869,38,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1870,38,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1871,38,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1872,38,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1873,38,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1874,38,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1875,38,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1876,38,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1877,38,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1878,38,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1879,38,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1880,38,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1881,38,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1882,38,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1883,38,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1884,38,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1885,38,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1886,38,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1887,38,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1888,38,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1889,38,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1890,38,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1891,38,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1892,38,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1893,38,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1894,38,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1895,38,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1896,38,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1897,38,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1898,38,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1899,38,N'kssj',N'开始时间',0,0,N'DateType',N'Type=1',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1900,38,N'jssj',N'结束时间',0,0,N'DateType',N'Type=1',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1901,38,N'skr',N'参会人',0,0,N'MultipleTextType',N'Width=500,Height=200,SelUser=True,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1902,38,N'jyr',N'纪要人',0,0,N'MultipleTextType',N'Width=300,Height=100,SelUser=True,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1903,38,N'kyjj',N'会议简介',0,0,N'MultipleTextType',N'Width=500,Height=300,SelUser=False,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1904,38,N'cjr',N'创建人',0,0,N'TextType',N'TitleSize=300,IsPassword=text,DefaultValue={nowuser},SelVideo=False,SelIcon=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[Content],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1905,38,N'kydd',N'会议地点',0,0,N'MultipleTextType',N'Width=500,Height=200,SelUser=False,Down=False',0,1,0,1,1,0,0,0,0,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1909,35,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1910,35,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1911,35,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1912,35,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1913,35,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1914,35,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1915,35,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1916,35,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1917,35,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1918,35,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1919,35,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1920,35,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1921,35,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1922,35,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1923,35,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1924,35,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1925,35,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1926,35,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1927,35,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1928,35,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1929,35,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1930,35,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1931,35,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1932,35,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1933,35,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1934,35,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1935,35,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1936,35,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1937,35,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1938,35,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1939,35,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1940,36,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1941,36,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1942,36,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1943,36,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1944,36,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1945,36,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1946,36,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1947,36,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1948,36,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1949,36,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1950,36,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1951,36,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1952,36,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1953,36,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1954,36,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1955,36,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1956,36,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1957,36,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1958,36,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1959,36,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1960,36,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1961,36,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1962,36,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1963,36,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1964,36,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1965,36,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1966,36,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1967,36,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1968,36,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1969,36,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1970,36,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1971,37,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1972,37,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1973,37,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1974,37,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1975,37,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1976,37,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1977,37,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1978,37,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1979,37,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1980,37,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1981,37,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1982,37,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1983,37,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1984,37,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1985,37,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1986,37,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1987,37,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1988,37,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1989,37,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1990,37,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1991,37,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1992,37,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1993,37,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1994,37,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1995,37,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1996,37,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1997,37,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1998,37,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 1999,37,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2000,37,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2001,37,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2002,38,N'Title',N'内容标题',1,0,N'TextType',0,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2003,38,N'NodeID',N'所属节点',1,0,N'TextType',1,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2004,38,N'SpecialID',N'所属专题',0,0,N'TextType',2,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2005,38,N'InfoID',N'其他节点',0,0,N'TextType',3,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2006,38,N'Titlecolor',N'标题颜色',0,0,N'TextType',4,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2007,38,N'Hits',N'点击数',0,0,N'NumType',5,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2008,38,N'GeneralID',N'内容ID',0,0,N'TextType',6,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2009,38,N'Tagkey',N'关键字',0,0,N'TextType',7,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2010,38,N'EliteLevel',N'推荐级别',0,0,N'NumType',8,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2011,38,N'HtmlLink',N'静态页面地址',0,0,N'TextType',9,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2012,38,N'IsCreate',N'是否已生成',0,0,N'NumType',10,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2013,38,N'InPuter',N'录入者',0,0,N'TextType',11,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2014,38,N'Status',N'状态',0,0,N'NumType',12,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2015,38,N'UpDateTime',N'更新时间',0,0,N'DateType',13,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2016,38,N'CreateTime',N'生成时间',0,0,N'DateType',14,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2017,38,N'UpDateType',N'更新时间类型',0,0,N'NumType',15,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2018,38,N'PdfLink',N'PDF地址',0,0,N'TextType',16,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2019,38,N'tablename',N'表名',1,0,N'TextType',17,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2020,38,N'ItemID',N'表的记录',0,0,N'TextType',18,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2021,38,N'Template',N'模板',0,0,N'TextType',19,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2022,38,N'Subtitle',N'副标题',0,0,N'TextType',20,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2023,38,N'PYtitle',N'拼音缩写',0,0,N'TextType',21,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2024,38,N'FirstNodeID',N'根节点ID',0,0,N'NumType',22,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2025,38,N'TitleStyle',N'标题样式',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2026,38,N'TopImg',N'扩展图片',0,0,N'TextType',23,0,0,1,1,0,0,0,1,0,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2027,38,N'content',N'内容',1,0,N'MultipleHtmlType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2028,38,N'Secret',N'机密',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2029,38,N'Urgency',N'紧急程度',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2030,38,N'Importance',N'重要性',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2031,38,N'Attach',N'附件',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
INSERT [ZL_ModelField] ([FieldID],[ModelId],[FieldName],[FieldAlias],[IsNotNull],[IsSearchForm],[FieldType],[OrderId],[ShowList],[ShowWidth],[IsShow],[IsView],[IsDownField],[DownServerID],[RestoreField],[Sys_type],[IsCopy],[Islotsize],[IsChain]) VALUES ( 2032,38,N'UserGroupT',N'所属部门',1,0,N'TextType',0,1,0,0,1,0,0,0,1,1,0,0)
SET IDENTITY_INSERT [ZL_ModelField] OFF
 
SET IDENTITY_INSERT [ZL_MoneyManage] ON
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 1 , 'CNY' , '人民币' , '￥' , 10.00000 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 2 , 'HKD' , '港币' , 'HK＄' , 0.80000 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 6 , 'USD' , '美元' , '$' ,6.30000 , '1' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 3 , 'RUB' , '卢布' , 'Re.' , 55.00000 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 4 , 'NOK' , '挪威克朗' , '32' , .25500 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 5 , 'MYR' , '马元' , 'M.＄' , .55000 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 7 , 'GBP' , '英镑' , '￡' , .25000 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 8 , 'EUR' , '欧元' , '€ ' , .25500 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 9 , 'TWD' , '新台币' , 'c$' , 5.00000 , '0' )
INSERT [ZL_MoneyManage] ( [Flow] , [Money_code] , [Money_descp] , [Money_sign] , [Money_rate] , [Is_flag] ) VALUES ( 10 , 'JPY' , '日元' , 'J.￥' , .50000 , '0' )
SET IDENTITY_INSERT [ZL_MoneyManage] OFF

SET IDENTITY_INSERT [ZL_Guestcate] ON
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog]) VALUES ( 1,N'用户留言',0,0,1)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog]) VALUES ( 2,N'站长互动',0,0,0)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog]) VALUES ( 3,N'互动帮助',0,0,1)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[BarInfo],[OrderID]) VALUES ( 4,N'技术专区',1,0,0,N'Recommend',0)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[BarInfo],[OrderID]) VALUES ( 5,N'生活空间',1,0,0,N'Recommend',0)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 6,N'官方服务',1,0,0,0)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 7,N'网页设计',1,4,0,2)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 8,N'资源共享',1,4,0,3)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 9,N'客服投诉',1,6,0,0)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 10,N'项目外包',1,4,0,4)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 13,N'版主会议室',1,6,1,0)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 14,N'程序人生',1,4,0,1)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 15,N'站务公告',1,6,0,2)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 16,N'地市动态',1,5,0,5)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 17,N'多彩生活',1,5,0,6)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 18,N'血拼购物',1,5,0,7)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 19,N'同城交友',1,5,0,8)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 20,N'二手置换',1,5,0,9)
INSERT [ZL_Guestcate] ([Cateid],[Catename],[GType],[ParentID],[NeedLog],[OrderID]) VALUES ( 21,N'诗书琴画',1,5,0,10)
SET IDENTITY_INSERT [ZL_Guestcate] OFF

SET IDENTITY_INSERT [ZL_Guest_Bar] ON
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[PostFlag],[OrderFlag]) VALUES ( 1,7,0,0,0,N'11个实用经典的SQL小贴士',N'H4sIAAAAAAAEALMpsDM0fLJj1dN1855PWfF8d//T1h3PZ7UEB/o83dD/YsuWp4tX2yQV6dvZZOamKxQXJdsq6YcW5OQnprhl5qQW66ek5ubrJ6aY6GUVpCspFJdU5qTaKikplGSWgBgwCaB2/QI7AD94t4prAAAA',1,99,0,N'匿名用户',N'2015/1/15 13:45:32',N'11个实用经典的SQL小贴士<br/><p><img src="/UploadFiles/demo/ad4.jpg" style="" title="ad4.jpg"/></p><ul class=''thumbul''></ul>',N',Recommend,''',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[PostFlag],[OrderFlag]) VALUES ( 2,7,0,0,0,N'商城网站php源码模板 时尚简约大方 支持电脑手机微信app版本',N'H4sIAAAAAAAEALMpsHs6te3p/L7neyc+Xz2zIKPg2a4Jzxc0Plux8Nnc/QrPpm97umHW83UNz3cte7pk+bNpOxWeTVn/rKfx+ZStL1omPuvsfjZn19N9657sX5hYUPC8s+PZnDU2SUX6djaZuekKxUXJtkr6oQU5+Ykpbpk5qcX6Kam5+fqJKcZ6WQXpSgrFJZU5qbZKSgolmSUgBkwCqF2/wA4ALVhlkpsAAAA=',1,99,0,N'匿名用户',N'2015/1/15 13:45:39',N'商城网站php源码模板时尚简约大方支持电脑手机微信app版本<br/><p><img src="/UploadFiles/demo/ad3.jpg" style="" title="ad3.jpg"/></p><ul class=''thumbul''></ul>',N',Recommend,''',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[PostFlag],[OrderFlag]) VALUES ( 3,8,0,0,0,N'CSS的50个代码片段',N'H4sIAAAAAAAEALMpsHMODn4+q8XU4MmOVU92L36+oPF5Z/uzdVvV8pKKC6xt9AvsANhc1C4kAAAA',1,99,0,N'匿名用户',N'2015/1/15 13:45:45',N'CSS的50个代码片段<br/><ul class=''thumbul''></ul>',N',Recommend,''',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 4,8,0,0,0,N'我是小白，怎么在一天内有自己的网站',N'H4sIAAAAAAAEAAE6AMX/PHA+5oiR5piv5bCP55m977yM5oCO5LmI5Zyo5LiA5aSp5YaF5pyJ6Ieq5bex55qE572R56uZPC9wPjFtPFc6AAAA',1,99,0,N'匿名用户',N'2015/1/15 13:45:53',N'我是小白，怎么在一天内有自己的网站<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 5,10,0,0,0,N'JavaScript继承详解（三）',N'H4sIAAAAAAAEAAEmANn/PHA+SmF2YVNjcmlwdOe7p+aJv+ivpuino++8iOS4ie+8iTwvcD4T5bJGJgAAAA==',1,99,0,N'匿名用户',N'2015/1/15 13:46:00',N'JavaScript继承详解（三）<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 6,10,0,0,0,N'清新优雅鲜花店商城模板分享，支持手机+微信+app',N'H4sIAAAAAAAEAAFIALf/PHA+5riF5paw5LyY6ZuF6bKc6Iqx5bqX5ZWG5Z+O5qih5p2/5YiG5Lqr77yM5pSv5oyB5omL5py6K+W+ruS/oSthcHA8L3A+TtdmlEgAAAA=',1,99,0,N'匿名用户',N'2015/1/15 13:46:07',N'清新优雅鲜花店商城模板分享，支持手机+微信+app<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 7,14,0,0,0,N'JavaScript继承详解',N'H4sIAAAAAAAEALMpsPNKLEsMTi7KLCh5vnv5s879L9Yve7F8sVpeUnGBtY1+gR0AP0wj2yMAAAA=',1,99,0,N'匿名用户',N'2015/1/15 13:46:18',N'JavaScript继承详解<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 8,14,0,0,0,N'Bootstrap-布局系统杂记',N'H4sIAAAAAAAEAAEpANb/PHA+Qm9vdHN0cmFwLeW4g+WxgOezu+e7n+adguiusCZuYnNwOzwvcD6n3qYiKQAAAA==',1,99,0,N'匿名用户',N'2015/1/15 13:46:25',N'Bootstrap-布局系统杂记<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 9,16,0,0,0,N'scrollWidth,clientWidth,offsetWidth的区别',N'H4sIAAAAAAAEALMpsLNJVMgoSk2zVcooKSmw0tdPSirWq8rPz81J1EvO0y/OyC8vyS/ITNY1tjAzNzXTSywuqFCyK04uys/JCc9MKcnQSc7JTM0rgbDz09KKUyHs57Nanvbsetqx2kY/0U4tL6m4wNpGv8AOAG7bygNyAAAA',1,99,0,N'匿名用户',N'2015/1/15 13:46:32',N'scrollWidth,clientWidth,offsetWidth的区别<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 10,16,0,0,0,N'移动web滑屏框架分享',N'H4sIAAAAAAAEAAEoANf/PHA+56e75Yqod2Vi5ruR5bGP5qGG5p625YiG5LqrJm5ic3A7PC9wPqYVNRkoAAAA',1,99,0,N'匿名用户',N'2015/1/15 13:48:19',N'移动web滑屏框架分享<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag],[HitCount]) VALUES ( 11,17,0,0,0,N'推荐一个威客网，一元就可以提现了。',N'H4sIAAAAAAAEAAFAAL//PHA+5o6o6I2Q5LiA5Liq5aiB5a6i572R77yM5LiA5YWD5bCx5Y+v5Lul5o+Q546w5LqG44CCJm5ic3A7PC9wPm+Iy+dAAAAA',1,99,0,N'匿名用户',N'2015/1/15 13:48:27',N'推荐一个威客网，一元就可以提现了。<br/><ul class=''thumbul''></ul>',0,1)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag]) VALUES ( 12,17,0,0,0,N'CSS选择器、优先级与匹配原理',N'H4sIAAAAAAAEAAE0AMv/PHA+Q1NT6YCJ5oup5Zmo44CB5LyY5YWI57qn5LiO5Yy56YWN5Y6f55CGJm5ic3A7PC9wPggH6cA0AAAA',1,99,1,N'admin',N'2015/1/15 16:03:04',N'CSS选择器、优先级与匹配原理<br/><ul class=''thumbul''></ul>',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[PostFlag],[OrderFlag]) VALUES ( 13,18,0,0,0,N'11款导航PNG源文件',N'H4sIAAAAAAAEALMpsDM0fLZm39P1e150rArwc3+2a8Kzae1Pdm+zSSrSt7PJzE1XKC5KtlXSDy3IyU9MccvMSS3WT0nNzddPTDHSyypIV1IoLqnMSbVVUlIoySwBMWASQO36BXYAaEmsS2IAAAA=',1,99,1,N'admin',N'2015/1/15 16:03:12',N'11款导航PNG源文件<br/><p><img src="/UploadFiles/demo/ad2.jpg" style="" title="ad2.jpg"/></p><ul class=''thumbul''></ul>',N',Recommend,''',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[PostFlag],[OrderFlag]) VALUES ( 14,18,0,0,0,N'设计人应该知道设计中常见的劫难，和秒秒学来看看吧！',N'H4sIAAAAAAAEALMpsLPJzE1XKC5KtlXSDy3IyU9MccvMSS3WT0nNzddPTDHVyypIV1IoLqnMSbVVUlIoySwBMWAS+nY2+kAjhqUpSUUQNgCauhkGJAEAAA==',1,99,1,N'admin',N'2015/1/15 16:03:54',N'<br/><ul class=''thumbul''><li class=''thumbli''><img src="/UploadFiles/demo/ad5.jpg" style="" title="ad5.jpg"/></li><li class=''thumbli''><img src="/UploadFiles/demo/ad5.jpg" style="" title="ad5.jpg"/></li><li class=''thumbli''><img src="/UploadFiles/demo/01.jpg" style="" title="01.jpg"/></li><li class=''thumbli''><img src="/UploadFiles/demo/ad5.jpg" style="" title="ad5.jpg"/></li></ul>',N',Recommend,''',0)
INSERT [ZL_Guest_Bar] ([ID],[CateID],[Pid],[ReplyID],[ReplyUserID],[Title],[MsgContent],[MsgType],[Status],[CUser],[CUName],[CDate],[Subtitle],[OrderFlag],[HitCount]) VALUES ( 15,19,0,0,0,N'摘一段优酷视频来自贴吧',N'H4sIAAAAAAAEAD2PsU7DMBCGX8XyHhtVDAglnWDoUgmpA+thX2KrTnyK7ZgwISZG3oKRhaXidYrgMUhC1en0///dr+9KWv9+fP68HI5fz8fD6/fbuxCixPYBNYsjYcWByFkF0fpOPhbBeLXPMGBROwiGMzWNUHHUyRY17FEXg9XoOSOXGtsFgmYqMTHStZQ5Z9GC6n2L2oJQvpWNlw3GpYwcjNhzFnp1vvj3xOjTPi37J4MMyWC1vN/u7lbbm83Tdnc7ykGEXHOWrY6m4perC84M2sbEiq+uJpFbryea2MMM1mMXZ04YZyshZ857qngNLkyixS6dBTjnc1C9pQhK4fxyh8NMuyR1cm5KEbtTlVyXktZ/iL78N14BAAA=',1,99,0,N'匿名用户',N'2015/1/15 16:45:38',N'说点什么吧...<br/><ul class=''thumbul''><li class=''thumbli''><img src=''/App_Themes/Guest/images/Bar/videologo.png'' data-type=''quotevideo'' data-content=''http://player.youku.com/player.php/sid/XNTQ2NDIzNTEy/v.swf''/></li></ul>',0,1)
SET IDENTITY_INSERT [ZL_Guest_Bar] OFF

INSERT [ZL_GroupModel] ( [GroupID] , [UserModel] ) VALUES ( 2 , 0 )
INSERT [ZL_GroupModel] ( [GroupID] , [UserModel] ) VALUES ( 1 , 0 )

 SET IDENTITY_INSERT [ZL_Group] ON
 INSERT [ZL_Group] ( [GroupID] , [GroupName] , [OtherName] , [Description] , [RegSelect] , [IsDefault] , [CCountPerDay] , [FavCount] , [ConsumeType] , [UpGradeMoney] , [CompanyGroup] , [VIPNum] , [VIPGroup] , [RebateRate] ,[ParentGroupID] ) VALUES ( 1 , '普通会员' , '普通' , '普通会员注册' , 1 , 1 , 0 , 0 , 0 , .0000 , 0 , 0 , 0 , 0.69999998807907104 , 0 )
 INSERT [ZL_Group] ( [GroupID] , [GroupName] , [OtherName] , [Description] , [RegSelect] , [IsDefault] , [CCountPerDay] , [FavCount] , [ConsumeType] , [UpGradeMoney] , [CompanyGroup] , [VIPNum] , [VIPGroup] , [RebateRate] ,[ParentGroupID] ) VALUES ( 2 , '企业会员' , '企业' , '企业用户注册' , 1 , 0 , 0 , 0 , 0 , .0000 , 1 , 0 , 0 , 0.80000001192092896 , 0 )
 SET IDENTITY_INSERT [ZL_Group] OFF

 SET IDENTITY_INSERT [ZL_Grade] ON

INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 1,1,0,N'北京市',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 2,1,0,N'上海市',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 3,1,0,N'天津市',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 4,1,0,N'重庆市',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 5,1,0,N'河北省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 6,1,0,N'江苏省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 7,1,0,N'安徽省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 8,1,1,N'海淀区',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 9,1,1,N'朝阳区',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 10,1,7,N'合肥',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 11,1,7,N'安庆',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 12,1,7,N'蚌埠',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 13,1,7,N'巢湖',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 14,1,7,N'池州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 15,1,7,N'滁州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 16,1,7,N'阜阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 17,1,7,N'淮北',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 18,1,7,N'淮南',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 19,1,7,N'黄山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 20,1,7,N'六安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 21,1,7,N'马鞍山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 22,1,7,N'宿州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 23,1,7,N'铜陵',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 24,1,7,N'芜湖',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 25,1,7,N'宣城',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 26,1,7,N'亳州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 27,1,5,N'石家庄',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 28,1,5,N'保定',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 29,1,5,N'沧州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 30,1,5,N'承德',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 31,1,5,N'邯郸',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 32,1,5,N'衡水',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 33,1,5,N'廊坊',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 34,1,5,N'秦皇岛',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 35,1,5,N'唐山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 36,1,5,N'邢台',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 37,1,5,N'张家口',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 38,1,6,N'南京',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 39,1,6,N'常州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 40,1,6,N'淮安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 41,1,6,N'连云港',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 42,1,6,N'南通',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 43,1,6,N'苏州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 44,1,6,N'宿迁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 45,1,6,N'泰州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 46,1,6,N'无锡',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 47,1,6,N'徐州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 48,1,6,N'盐城',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 49,1,6,N'扬州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 50,1,6,N'镇江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 51,1,0,N'福建省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 52,1,51,N'福州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 53,1,51,N'龙岩',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 54,1,51,N'南平',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 55,1,51,N'宁德',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 56,1,51,N'莆田',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 57,1,51,N'泉州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 58,1,51,N'三明',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 59,1,51,N'厦门',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 60,1,51,N'漳州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 61,1,0,N'甘肃省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 62,1,61,N'兰州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 63,1,61,N'白银',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 64,1,61,N'定西',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 65,1,61,N'甘南藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 66,1,61,N'嘉峪关',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 67,1,61,N'金昌',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 68,1,61,N'酒泉',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 69,1,61,N'临夏回族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 70,1,61,N'陇南',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 71,1,61,N'淮南',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 72,1,61,N'平凉',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 73,1,61,N'庆阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 74,1,61,N'天水',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 75,1,61,N'武威',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 76,1,61,N'张掖',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 77,1,0,N'广东省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 78,1,77,N'深圳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 79,1,77,N'潮州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 80,1,77,N'东莞',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 81,1,77,N'佛山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 82,1,77,N'广州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 83,1,77,N'河源',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 84,1,77,N'惠州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 85,1,77,N'江门',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 86,1,77,N'揭阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 87,1,77,N'茂名',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 89,1,77,N'梅州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 90,1,77,N'清远',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 91,1,77,N'汕头',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 92,1,77,N'汕尾',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 93,1,77,N'韶关',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 94,1,77,N'阳江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 95,1,77,N'云浮',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 96,1,77,N'湛江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 98,1,77,N'肇庆',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 99,1,77,N'中山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 100,1,77,N'珠海',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 101,1,0,N'广西省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 102,1,101,N'南宁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 103,1,101,N'百色',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 104,1,101,N'北海',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 105,1,101,N'崇左',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 106,1,101,N'防城港',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 107,1,101,N'桂林',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 108,1,101,N'贵港',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 109,1,101,N'河池',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 110,1,101,N'贺州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 111,1,101,N'来宾',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 112,1,101,N'柳州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 113,1,101,N'钦州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 114,1,101,N'梧州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 115,1,101,N'玉林',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 116,1,0,N'贵州省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 117,1,116,N'贵阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 118,1,116,N'安顺',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 119,1,116,N'毕节',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 120,1,116,N'六盘水',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 121,1,116,N'黔东南苗族侗族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 122,1,116,N'黔南布依族苗族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 123,1,116,N'黔西南布依族苗族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 124,1,116,N'遵义',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 125,1,0,N'海南省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 126,1,125,N'海口',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 127,1,125,N'白沙黎族自治县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 128,1,125,N'保亭黎族苗族自治县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 129,1,125,N'昌江黎族自治县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 130,1,125,N'澄迈县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 131,1,125,N'定安县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 132,1,125,N'东方',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 133,1,125,N'乐东黎族自治县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 134,1,125,N'临高县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 135,1,125,N'陵水黎族自治县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 136,1,125,N'琼海',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 137,1,125,N'琼中黎族苗族自治县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 138,1,125,N'三亚',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 139,1,125,N'屯昌县',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 140,1,125,N'万宁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 141,1,125,N'文昌',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 142,1,125,N'五指山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 143,1,125,N'儋州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 144,1,0,N'河北省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 145,1,144,N'保定',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 146,1,144,N'沧州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 147,1,144,N'承德',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 148,1,144,N'邯郸',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 149,1,144,N'衡水',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 150,1,144,N'廊坊',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 151,1,144,N'秦皇岛',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 152,1,144,N'唐山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 153,1,144,N'邢台',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 154,1,144,N'张家口',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 156,1,0,N'河南省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 157,1,156,N'郑州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 158,1,156,N'安阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 159,1,156,N'鹤壁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 160,1,156,N'济源',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 161,1,156,N'焦作',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 162,1,156,N'开封',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 163,1,156,N'洛阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 164,1,156,N'南阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 165,1,156,N'平顶山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 166,1,156,N'三门峡',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 167,1,156,N'商丘',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 168,1,156,N'新乡',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 169,1,156,N'信阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 170,1,156,N'许昌',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 171,1,156,N'周口',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 172,1,156,N'驻马店',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 173,1,156,N'漯河',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 174,1,156,N'濮阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 175,1,0,N'黑龙江',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 176,1,175,N'哈尔滨',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 177,1,175,N'大庆',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 178,1,175,N'大兴安岭',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 179,1,175,N'鹤岗',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 180,1,175,N'黑河',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 181,1,175,N'鸡西',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 182,1,175,N'佳木斯',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 183,1,175,N'牡丹江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 184,1,175,N'七台河',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 185,1,175,N'齐齐哈尔',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 186,1,175,N'双鸭山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 187,1,175,N'绥化',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 188,1,175,N'伊春',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 189,1,0,N'湖北省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 190,1,189,N'武汉',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 191,1,189,N'鄂州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 192,1,189,N'恩施土家族苗族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 193,1,189,N'黄冈',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 194,1,189,N'黄石',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 195,1,189,N'荆门',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 196,1,189,N'荆州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 197,1,189,N'潜江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 198,1,189,N'神农架林区',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 199,1,189,N'十堰',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 200,1,189,N'随州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 201,1,189,N'天门',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 202,1,189,N'仙桃',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 203,1,189,N'咸宁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 204,1,189,N'襄樊',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 205,1,189,N'襄樊',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 206,1,189,N'宜昌',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 207,1,0,N'湖南省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 208,1,207,N'长沙',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 209,1,207,N'常德',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 210,1,207,N'郴州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 211,1,207,N'衡阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 212,1,207,N'娄底',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 213,1,207,N'邵阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 214,1,207,N'湘潭',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 215,1,207,N'湘西土家族苗族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 216,1,207,N'益阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 217,1,207,N'永州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 218,1,207,N'岳阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 219,1,207,N'张家界',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 220,1,207,N'株洲',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 221,1,0,N'吉林省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 222,1,221,N'白城',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 223,1,221,N'白山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 224,1,221,N'长春',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 225,1,221,N'辽源',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 226,1,221,N'四平',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 227,1,221,N'松原',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 228,1,221,N'通化',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 229,1,221,N'延边朝鲜族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 230,1,0,N'江西省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 231,1,230,N'南昌',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 232,1,230,N'九江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 233,1,230,N'抚州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 234,1,230,N'赣州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 235,1,230,N'吉安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 236,1,230,N'景德镇',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 237,1,230,N'萍乡',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 238,1,230,N'上饶',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 239,1,230,N'新余',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 240,1,230,N'宜春',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 241,1,230,N'鹰潭',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 242,1,0,N'辽宁省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 243,1,242,N'沈阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 244,1,242,N'鞍山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 245,1,242,N'本溪',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 246,1,242,N'朝阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 247,1,242,N'大连',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 248,1,242,N'丹东',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 249,1,242,N'抚顺',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 250,1,242,N'阜新',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 251,1,242,N'葫芦岛',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 252,1,242,N'锦州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 253,1,242,N'辽阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 254,1,242,N'盘锦',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 255,1,242,N'铁岭',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 256,1,242,N'营口',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 257,1,0,N'内蒙古',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 258,1,257,N'包头',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 259,1,257,N'阿拉善盟',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 261,1,257,N'巴彦淖尔盟',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 262,1,257,N'赤峰',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 263,1,257,N'鄂尔多斯',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 264,1,257,N'呼和浩特',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 265,1,257,N'呼伦贝尔',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 266,1,257,N'通辽',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 267,1,257,N'乌海',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 268,1,257,N'乌兰察布盟',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 269,1,257,N'锡林郭勒盟',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 270,1,257,N'兴安盟',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 271,1,0,N'宁夏',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 272,1,271,N'银川',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 273,1,271,N'固原',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 274,1,271,N'石嘴山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 275,1,271,N'吴忠',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 276,1,0,N'青海省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 277,1,276,N'西宁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 278,1,276,N'果洛藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 279,1,276,N'海北藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 280,1,276,N'海南藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 281,1,276,N'海西蒙古族藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 282,1,276,N'黄南藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 283,1,276,N'玉树藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 284,1,0,N'山东省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 285,1,284,N'济南',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 286,1,284,N'滨州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 287,1,284,N'德州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 288,1,284,N'东营',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 289,1,284,N'菏泽',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 290,1,284,N'济宁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 291,1,284,N'莱芜',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 292,1,284,N'聊城',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 293,1,284,N'临沂',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 294,1,284,N'青岛',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 295,1,284,N'日照',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 296,1,284,N'泰安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 297,1,284,N'威海',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 298,1,284,N'潍坊',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 299,1,284,N'烟台',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 300,1,284,N'枣庄',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 301,1,284,N'淄博',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 302,1,0,N'山西省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 303,1,302,N'太原',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 304,1,302,N'长治',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 305,1,302,N'大同',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 306,1,302,N'晋城',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 307,1,302,N'晋中',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 308,1,302,N'临汾',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 309,1,302,N'吕梁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 310,1,302,N'朔州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 311,1,302,N'忻州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 312,1,302,N'阳泉',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 313,1,302,N'运城',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 314,1,0,N'陕西省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 315,1,314,N'西安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 316,1,314,N'安康',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 317,1,314,N'宝鸡',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 318,1,314,N'汉中',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 319,1,314,N'商洛',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 320,1,314,N'铜川',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 321,1,314,N'渭南',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 322,1,314,N'咸阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 323,1,314,N'延安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 324,1,314,N'榆林',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 325,1,2,N'上海',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 326,1,0,N'四川省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 327,1,326,N'成都',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 328,1,326,N'阿坝藏族羌族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 329,1,326,N'巴中',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 330,1,326,N'达州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 331,1,326,N'德阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 332,1,326,N'甘孜藏族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 333,1,326,N'广安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 334,1,326,N'广元',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 335,1,326,N'乐山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 336,1,326,N'凉山彝族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 337,1,326,N'眉山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 338,1,326,N'绵阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 339,1,326,N'南充',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 340,1,326,N'内江',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 341,1,326,N'攀枝花',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 342,1,326,N'遂宁',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 343,1,326,N'雅安',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 344,1,326,N'宜宾',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 345,1,326,N'资阳',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 346,1,326,N'自贡',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 347,1,326,N'泸州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 348,1,3,N'天津',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 349,1,0,N'西藏',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 350,1,349,N'拉萨',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 351,1,349,N'阿里',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 352,1,349,N'昌都',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 353,1,349,N'林芝',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 354,1,349,N'那曲',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 355,1,349,N'日喀则',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 356,1,349,N'山南',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 357,1,0,N'新疆',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 358,1,357,N'乌鲁木齐',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 359,1,357,N'阿克苏',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 361,1,357,N'巴音郭楞蒙古自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 362,1,357,N'博尔塔拉蒙古自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 363,1,357,N'昌吉回族自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 364,1,357,N'哈密',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 365,1,357,N'和田',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 366,1,357,N'喀什',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 367,1,357,N'克拉玛依',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 368,1,357,N'克孜勒苏柯尔克孜自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 369,1,357,N'石河子',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 370,1,357,N'图木舒克',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 371,1,357,N'吐鲁番',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 372,1,357,N'五家渠',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 373,1,357,N'伊犁哈萨克自治州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 374,1,0,N'浙江省',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 375,1,374,N'杭州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 376,1,374,N'湖州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 377,1,374,N'嘉兴',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 378,1,374,N'金华',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 379,1,374,N'丽水',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 380,1,374,N'宁波',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 381,1,374,N'绍兴',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 382,1,374,N'台州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 383,1,374,N'温州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 384,1,374,N'舟山',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 385,1,374,N'衢州',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 386,1,4,N'重庆',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 387,1,1,N'丰台区',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 388,1,1,N'通州区',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 389,2,0,N'电脑/网络',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 390,2,0,N'生活',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 391,2,0,N'医疗健康',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 392,2,0,N'体育/运动',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 393,2,0,N'电子数码',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 394,2,0,N'商业/理财',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 395,2,0,N'教育/科学',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 396,2,0,N'社会民生',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 397,2,0,N'文化/艺术',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 398,2,0,N'游戏',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 399,2,0,N'娱乐休闲',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 400,2,0,N'烦恼',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 401,2,0,N'资源共享',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 402,2,389,N'电脑装机',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 403,2,389,N'硬件',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 404,2,389,N'软件',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 405,2,389,N'反病毒',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 406,2,389,N'互联网',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 407,2,390,N'服装/首饰',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 408,2,390,N'美容/塑身',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 409,2,390,N'美食/烹饪',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 410,2,390,N'购车养车',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 411,2,390,N'交通出行',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 412,2,390,N'购物',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 413,2,391,N'内科',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 414,2,391,N'外科',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 415,2,391,N'妇产科',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 416,2,391,N'儿科',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 417,2,391,N'五官科',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 418,2,391,N'人体常识',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 419,2,392,N'足球',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 420,2,392,N'篮球',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 421,2,392,N'健身',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 422,2,392,N'赛车/F1',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 423,2,392,N'运动用品',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 424,2,392,N'武术搏击',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 425,2,393,N'手机购买',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 426,2,393,N'手机使用',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 427,2,393,N'照相机/摄像机',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 428,2,393,N'MP4/MP3',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 429,2,394,N'股票',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 430,2,394,N'财务税务',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 431,2,394,N'银行业务',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 432,2,394,N'创业投资',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 433,2,394,N'贸易',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 434,2,394,N'个人理财',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 435,2,395,N'升学入学',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 436,2,395,N'学习帮助',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 437,2,395,N'职业教育',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 438,2,395,N'英语考试',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 439,2,395,N'出国/留学',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 440,2,395,N'理工学科',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 441,2,396,N'法律',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 442,2,396,N'公务办理',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 443,2,396,N'时事政治',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 444,2,396,N'宗教',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 445,2,396,N'求职就业',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 446,2,397,N'文学',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 447,2,397,N'历史话题',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 448,2,397,N'民俗传统',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 449,2,397,N'器乐/声乐',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 450,2,397,N'舞蹈',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 451,2,397,N'书画美术',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 452,2,398,N'网络游戏',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 453,2,398,N'单机游戏',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 454,2,398,N'电视游戏',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 455,2,398,N'手机游戏',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 456,2,398,N'小游戏',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 457,2,399,N'音乐',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 458,2,399,N'电影',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 459,2,399,N'电视',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 460,2,399,N'动漫',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 461,2,399,N'星座/运势',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 462,2,399,N'宠物',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 463,2,400,N'恋爱',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 464,2,400,N'夫妻',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 465,2,400,N'家庭关系',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 466,2,400,N'校园生活',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 467,2,400,N'情感情绪',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 468,2,400,N'交友技巧',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 469,2,401,N'视频共享',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 470,2,401,N'音频/歌曲共享',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 471,2,401,N'软件共享',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 472,2,401,N'文档/报告共享',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 474,3,0,N'人物',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 475,3,0,N'文化',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 476,3,0,N'技术',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 477,3,0,N'历史',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 478,3,0,N'艺术',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 479,3,0,N'生活',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 480,3,0,N'地理',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 481,3,0,N'社会',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 482,3,0,N'体育',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 483,3,0,N'自然',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 484,3,0,N'科学',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 485,3,0,N'经济',1)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 486,3,474,N'自然科学',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 487,3,474,N'人文领域',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 488,3,474,N'社会科学',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 489,3,474,N'文学领域',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 490,3,474,N'军事领域',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 491,3,474,N'艺术领域',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 492,3,474,N'体育领域',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 493,3,474,N'虚拟人物',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 494,3,486,N'科学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 495,3,486,N'医学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 496,3,486,N'数学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 497,3,486,N'物理学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 498,3,486,N'化学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 499,3,486,N'农学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 500,3,486,N'农业学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 501,3,486,N'古生物学家',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 502,3,486,N'医师',3)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 503,3,475,N'文学',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 504,3,475,N'中华文化',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 505,3,475,N'文物古迹',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 506,3,475,N'学派',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 507,3,475,N'宗教',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 508,3,475,N'民俗',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 509,3,475,N'语种',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 510,3,475,N'网络文化',2)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 515,5,0,N'基础',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 516,5,0,N'容易',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 517,5,0,N'中等',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 518,5,0,N'偏难',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 519,5,0,N'极难',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 520,6,0,N'一年级',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 521,6,0,N'二年级',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 522,6,0,N'三年级',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 523,6,0,N'四年级',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 524,6,0,N'五年级',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 525,6,0,N'六年级',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 526,6,0,N'初一',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 527,6,0,N'初二',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 528,6,0,N'初三',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 529,6,0,N'高一',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 530,6,0,N'高二',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 531,6,0,N'高三',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 532,7,0,N'人教版',0)
INSERT [ZL_Grade] ([GradeID],[Cate],[ParentID],[GradeName],[Grade]) VALUES ( 533,7,0,N'15黄冈版',0)

SET IDENTITY_INSERT [ZL_Grade] OFF

 SET IDENTITY_INSERT [ZL_Defray] ON
 INSERT [ZL_Defray] ( [flow] , [Pay_name] , [Pay_intf] , [Client_id] , [Title] , [money_code] , [number] ) VALUES ( 2 , 'Paypal或Visa,Master,Solo等银行卡在线支付' , 'PayPal外贸必选(标准版)' , 'server@hx008.cn' , 'zoomla' , 'CNY,USD,EUR,GBP,CAD,AUD,NZD,RUB,HKD,TWD,KRW,SGD,JPY,MYR,CHF,SEK,DKK,PLZ,HUF,CSK,' , 'p*0.05' )
 SET IDENTITY_INSERT [ZL_Defray] OFF

 SET IDENTITY_INSERT [ZL_Datadiccategory] ON
 INSERT [ZL_Datadiccategory] ( [Diccateid] , [Categoryname] , [Isused] ) VALUES ( 1 , '地区选择' , 1 )
 INSERT [ZL_Datadiccategory] ( [Diccateid] , [Categoryname] , [Isused] ) VALUES ( 2 , '学历信息' , 1 )
 INSERT [ZL_Datadiccategory] ( [Diccateid] , [Categoryname] , [Isused] ) VALUES ( 3 , '从事行业' , 1 )
 SET IDENTITY_INSERT [ZL_Datadiccategory] OFF

 SET IDENTITY_INSERT [ZL_Datadic] ON
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 1 , 1 , '北京' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 2 , 1 , '上海' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 3 , 1 , '天津' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 4 , 1 , '重庆' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 5 , 1 , '江苏' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 6 , 1 , '浙江' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 7 , 1 , '广东' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 8 , 1 , '海南' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 9 , 1 , '福建' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 10 , 1 , '山东' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 11 , 1 , '江西' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 12 , 1 , '四川' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 13 , 1 , '安徽' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 14 , 1 , '河北' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 15 , 1 , '河南' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 16 , 1 , '湖北' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 17 , 1 , '湖南' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 18 , 1 , '陕西' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 19 , 1 , '山西' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 20 , 1 , '黑龙' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 21 , 1 , '辽宁' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 22 , 1 , '吉林' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 23 , 1 , '广西' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 24 , 1 , '云南' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 25 , 1 , '贵州' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 26 , 1 , '甘肃' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 27 , 1 , '内蒙' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 28 , 1 , '宁夏' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 29 , 1 , '西藏' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 30 , 1 , '新疆' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 31 , 1 , '青海' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 32 , 1 , '香港' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 33 , 1 , '澳门' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 34 , 1 , '台湾' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 35 , 1 , '国外' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 36 , 2 , '在读学生' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 37 , 2 , '应届毕业生' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 38 , 2 , '一年以上' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 39 , 2 , '二年以上' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 40 , 2 , '三年以上' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 41 , 2 , '五年以上' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 42 , 2 , '八年以上' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 43 , 2 , '十年以上' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 44 , 3 , '计算机硬件' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 45 , 3 , '计算机软件' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 46 , 3 , '互联网开发及应用' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 47 , 3 , 'IT-管理' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 48 , 3 , 'IT-品管' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 49 , 3 , '技术支持及其它' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 50 , 3 , '通信技术' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 51 , 3 , '销售管理' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 52 , 3 , '销售人员' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 53 , 3 , '销售行政及商务' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 54 , 3 , '客服及技术支持' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 55 , 3 , '银行' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 56 , 3 , '保险' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 57 , 3 , '质量安全管理' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 58 , 3 , '工程机械' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 59 , 3 , '能源' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 60 , 3 , '汽车' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 61 , 3 , '技工' , 1 )
 INSERT [ZL_Datadic] ( [Dicid] , [Diccate] , [Dicname] , [Isused] ) VALUES ( 62 , 3 , '服装' , 1 )
 SET IDENTITY_INSERT [ZL_Datadic] OFF

SET IDENTITY_INSERT ZL_Node ON
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ListTemplateFile],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[LastInfoTemplate],[HotinfoTemplate],[ProposeTemplate]) VALUES ( 1,N'资讯中心',1,N'news',0,2,7,1,0,0,1,0,N'频道首页/资讯频道首页.html',N'全站首页_门户.html',N'2,5',0,2,3,3,1,1,5,4,1,4,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,'栏目列表/打印页面.html',N'栏目列表/加载跟多帖子列表.html',N'全站首页_主页.html')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ListTemplateFile],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 2,N'在线商城',1,N'shop',0,9,11,1,0,0,1,0,N'频道首页/商城频道首页.html',N'栏目列表/商城对比页面.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 3,N'网店频道',1,N'mall',0,8,10,1,0,0,1,0,N'频道首页/店铺频道首页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 8,N'男人',1,N'NR',3,1,5,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 9,N'女人',1,N'NR',3,2,1,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 10,N'服饰',1,N'FS',3,3,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 11,N'美容',1,N'MR',3,4,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 12,N'美容',1,N'MR',3,5,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 13,N'时尚',1,N'SS',3,6,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 15,N'母婴',1,N'MY',3,8,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 16,N'手机数码',1,N'SJSM',3,9,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 17,N'运动',1,N'YD',3,10,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 18,N'机票/酒店',1,N'JPJD',3,11,0,2,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 19,N'运动/户外/健身',1,N'sport',8,1,10,3,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 20,N'男装/T恤/衬衫',1,N'man',8,2,12,3,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 21,N'休闲裤/牛仔裤/内衣',1,N'ku',8,3,9,3,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 22,N'男鞋/休闲鞋/皮鞋',1,N'shoes',8,4,9,3,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 23,N'男女箱包/出门配件',1,N'bao',8,5,10,3,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 24,N'女鞋',1,N'shoes',9,1,0,3,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 25,N'耐克',1,N'NK',19,1,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 26,N'彪马',1,N'BM',19,2,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 27,N'李宁',1,N'LN',19,3,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 28,N'阿迪',1,N'AD',19,4,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 29,N'匡威',1,N'KW',19,5,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 30,N'Kappa',1,N'KAPPA',19,6,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 31,N'运动套装',1,N'YDTZ',19,7,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 32,N'专柜代购',1,N'ZGDG',19,8,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 33,N'08款',1,N'K08',19,9,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 34,N'三叶草',1,N'SYC',19,10,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 35,N'T恤',1,N'TX',20,1,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 36,N'衬衫',1,N'CS',20,2,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 37,N'polo衫',1,N'POLOS',20,3,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 38,N'纯棉',1,N'CM',20,4,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 39,N'夹克',1,N'JK',20,5,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 40,N'马甲',1,N'MJ',20,6,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 41,N'秋装',1,N'QZ',20,7,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 42,N'西装',1,N'XZ',20,8,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 43,N'卫衣',1,N'WY',20,9,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 44,N'外套',1,N'WT',20,10,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 45,N'jack',1,N'JACK',20,11,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 46,N'jones',1,N'JONES',20,12,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 47,N'直筒裤',1,N'ZTK',21,1,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 48,N'牛仔裤',1,N'NZK',21,2,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 49,N'休闲裤',1,N'XXK',21,3,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 50,N'休闲西裤',1,N'XXXK',21,4,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 51,N'工装裤',1,N'GZK',21,5,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 52,N'短裤',1,N'DK',21,6,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 53,N'新款秋裤',1,N'XKQK',21,7,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 54,N'ck内裤',1,N'CKNK',21,8,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 55,N'内衣',1,N'NY',21,9,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 56,N'帆布鞋',1,N'FBX',22,1,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 57,N'运动鞋',1,N'YDX',22,2,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 58,N'休闲鞋',1,N'XXX',22,3,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 59,N'热卖男鞋',1,N'RMNX',22,4,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 60,N'皮鞋',1,N'PX',22,5,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 61,N'男靴',1,N'NX',22,6,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 62,N'篮球鞋',1,N'LQX',22,7,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 63,N'户外靴',1,N'HWX',22,8,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 64,N'板鞋',1,N'BX',22,9,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 65,N'斜挎包',1,N'XKB',23,1,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 66,N'手提包',1,N'STB',23,2,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 67,N'休闲包',1,N'XXB',23,3,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 68,N'单肩包',1,N'DJB',23,4,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 69,N'爱车族',1,N'ACZ',23,5,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 70,N'汽车坐垫',1,N'QCZD',23,6,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 71,N'皮带',1,N'PD',23,7,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 72,N'眼镜',1,N'YJ',23,8,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 73,N'饰品',1,N'SP',23,9,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 74,N'秋款帽',1,N'QKM',23,10,0,4,0,0,1,0,N'栏目列表/店铺商品列表页.html',N'20',0,2,3,3,1,5,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 75,N'服饰鞋帽',1,N'fsxm',2,1,1,2,0,0,1,0,N'栏目列表/商城列表页.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[NodeUrl],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[Custom],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 76,N'网站公告',1,N'Announce',N'/Announce/index.html',105,1,0,2,0,0,1,0,N'栏目列表/通用一列子栏目列表.html',N'1,5',0,2,3,3,1,1,0,0,0,0,0,N'sdffasdsdfsafasd{SplitCustom}',0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 77,N'网站帮助',1,N'help',0,13,8,1,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 78,N'公司信息',1,N'gsxx',105,1,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)

INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[Custom],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[LastInfoTemplate]) VALUES ( 79,N'新闻动态',1,N'stu',1,2,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,N'asdfasfsafsa{SplitCustom}',0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[LastInfoTemplate]) VALUES ( 80,N'国际新闻',1,N'GJXW',1,3,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[LastInfoTemplate]) VALUES ( 81,N'经典阅读',1,N'JDYD',1,4,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[LastInfoTemplate]) VALUES ( 82,N'海外文摘',1,N'HWWZ',1,5,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[LastInfoTemplate]) VALUES ( 83,N'奇闻轶事',1,N'qi',1,6,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,0)

INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 84,N'资源下载',1,N'down',0,3,6,1,0,0,1,0,N'频道首页/多列并排频道首页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 85,N'图库中心',1,N'photo',0,4,12,1,0,0,1,0,N'频道首页/图库频道首页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 86,N'在线视频',1,N'Movie',0,6,2,1,0,0,1,0,N'频道首页/视频频道首页.html',N'7',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[LastinfoTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 87,N'人才招聘',1,N'job',105,7,0,2,0,0,1,0,N'频道首页/招聘频道首页.html',N'内容页/招聘模型内容页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 88,N'友情链接',1,N'Friendsite',0,24,0,1,0,0,1,0,N'栏目列表/友情链接栏目列表.html',N'8',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 89,N'计算机资料',1,N'JSJZL',84,1,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'4,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 90,N'行业资料',1,N'XYZL',84,2,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'4,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 91,N'管理资料',1,N'GLZL',84,3,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'4,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 92,N'电子书籍',1,N'DZSJ',84,4,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'4,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 93,N'音乐下载',1,N'YLXZ',84,5,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'4,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 94,N'程序源码',1,N'soft',84,6,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'4,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 95,N'科技视频',1,N'KJSP',86,1,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'7',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 96,N'娱乐视频',1,N'YLSP',86,2,0,2,0,0,1,0,N'栏目列表/一列式左小右大子栏目列表.html',N'7',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 97,N'产品图库',1,N'CPTK',85,1,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 98,N'明星收藏',1,N'MXSC',85,2,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 99,N'分类信息',1,N'fenlei',0,5,9,1,0,0,1,0,N'频道首页/分类信息频道首页.html',N'19',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 100,N'头条新闻',1,N'ttxw',1,1,0,2,0,0,1,0,N'栏目列表/通用一列子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 101,N'服务信息',1,N'fwxx',99,15,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'19',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 102,N'跳蚤市场',1,N'tzsc',99,16,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'19',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 103,N'交友征婚',1,N'jyzh',99,17,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'19',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 104,N'车辆信息',1,N'jlxx',99,18,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'19',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 105,N'官方信息',1,N'about',0,12,5,1,0,0,1,0,N'2',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 106,N'网站地图',2,N'WZDT',105,11,0,2,0,1,1,0,N'栏目列表/网站地图.html',N'/栏目列表/网站地图.html',0,0,3,0,1,0,0,0,0,0,0,1,N'0',N'0',0,0,0,0,0.0000,0,0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 107,N'搞笑趣图',1,N'gxqt',85,19,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 108,N'科技图说',1,N'kjty',85,20,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 109,N'风景名胜',1,N'fjms',85,21,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 110,N'精品贴图',1,N'jptt',85,22,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 111,N'美女图片',1,N'mntp',85,22,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 112,N'精品贴图',1,N'jptt',85,22,0,2,0,0,1,0,N'栏目列表/通用图库列表页.html',N'3',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_blank',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[LastinfoTemplate],[HotinfoTemplate],[ProposeTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 113,N'问答系统',1,N'ask',0,10,18,1,0,0,1,0,N'问答系统/所有问答列表.html',N'问答系统/问吧首页.html',N'问答系统/搜索已解答问答列表页.html',N'/问答系统/所有未解答问答列表页.html',N'/问答系统/所有零问答列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 114,N'问吧公告',1,N'wbgg',113,24,0,2,0,0,1,0,N'栏目列表/通用一列子栏目列表.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[HotinfoTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 115,N'全部问题',1,N'qbwt',113,25,0,2,0,0,1,0,N'问答系统/问答列表小类.html',N'问答系统/问答列表.html',N'问答系统/搜索已解答问答列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 116,N'已解决问题',1,N'yjjwt',113,26,0,2,0,0,1,0,N'问答系统/已解答问答列表页小类.html',N'问答系统/已解答问答列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 117,N'待解决问题',1,N'djjwt',113,27,0,2,0,0,1,0,N'问答系统/待解决问答列表页小类.html',N'问答系统/待解决问答列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 118,N'零回答',1,N'lhd',113,28,0,2,0,0,1,0,N'问答系统/零问答列表页小类.html',N'问答系统/零问答列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 119,N'提问',1,N'tw',113,29,0,2,0,0,1,0,N'问答系统/问答提交页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 120,N'问题显示',1,N'wtxs',113,30,0,2,0,0,1,0,N'/问答系统/待解决内容页.html',N'问答系统/已解决内容页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 121,N'问答推荐',1,N'wdtj',113,31,0,2,0,0,1,0,N'5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 122,N'问答分类',1,N'wdfl',113,32,0,2,0,0,1,0,N'问答系统/问答分类页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 123,N'店铺信息',1,N'mall',0,11,9,1,0,0,1,0,N'栏目列表/店铺列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 124,N'店铺公告',1,N'dpgg',123,34,0,2,0,0,1,0,N'栏目列表/店铺信息列表页.html',N'店铺模版/店铺信息列表页.html',N'2',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 125,N'促销信息',1,N'cxxx',123,36,0,2,0,0,1,0,N'栏目列表/店铺信息列表页.html',N'店铺模版/店铺信息列表页.html',N'2',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 126,N'店铺商品',1,N'dpsp',123,35,0,2,0,0,1,0,N'店铺模版/店铺商品列表页.html',0,2,3,3,1,0,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx],[Viewinglimit]) VALUES ( 127,N'人才招聘',1,N'rczp',123,37,0,2,0,0,1,0,N'栏目列表/店铺信息列表页.html',N'店铺模版/店铺信息列表页.html',N'2',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3,N'1=0|2=0')
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 128,N'店铺模版/店铺首页.html',2,N'DPJS',123,33,0,2,0,0,0,0,N'店铺模版/店铺商品列表页.html',N'店铺模版/店铺介绍页.html',0,0,3,0,1,0,0,0,0,0,0,1,N'0',N'0',0,0,0,0,0.0000,0,0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 129,N'日常用品',1,N'rcyp',2,38,0,2,0,0,1,0,N'栏目列表/商城列表页.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 130,N'手机数码',1,N'sjsm',2,39,0,2,0,0,1,0,N'栏目列表/商城列表页.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 131,N'体育用品',1,N'tyyp',2,40,0,2,0,0,1,0,N'栏目列表/商城列表页.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 132,N'珠宝首饰',1,N'zbss',2,41,0,2,0,0,1,0,N'栏目列表/商城列表页.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 133,N'营养美食',1,N'yyms',2,42,0,2,0,0,1,0,N'栏目列表/商城列表页.html',N'6',0,2,3,3,1,2,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 134,N'产品与服务',1,N'cpyfw',77,43,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 135,N'常见问题',1,N'cjwt',77,44,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 136,N'技术主机联盟',1,N'jzzjlm',77,45,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 137,N'模板及插件下载',1,N'mbjcjxz',77,46,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 138,N'推荐信息',1,N'tjxx',99,47,0,2,0,0,1,0,N'栏目列表/通用资讯子栏目列表页.html',N'19',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 139,N'促销信息',1,N'cxxx',105,48,0,2,0,0,1,0,N'栏目列表/通用列表页.html',N'2,5',0,2,3,3,1,1,0,0,0,0,0,0,N'_blank',N'0',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup>-1,1,2</ViewGroup><ViewSunGroup>-1,1,2</ViewSunGroup><input>-1,1,2</input><forum>1,2</forum>',0,0,3,3,3,3)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[Tips],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[ListTemplateFile],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) 
VALUES ( 140,N'微门户',2,N'wei',N'用于微门户展示（如移动访问、WebApp、微信接入展示）等。',0,25,0,1,0,1,1,0,N'微门户.html',N'微门户.html',N'',0,0,3,0,0,0,0,0,0,0,0,1,N'',N'0',0,0,0,0,0.0000,0,N'',0,0,0,0,0,0)
INSERT [ZL_Node] ([NodeID],[NodeName],[NodeType],[NodeDir],[ParentID],[OrderID],[Child],[Depth],[OpenType],[PurviewType],[CommentType],[HitsOfHot],[IndexTemplate],[ContentModel],[ItemOpenType],[ContentHtmlRule],[ListPageHtmlEx],[ContentFileEx],[HtmlPosition],[NodeListType],[ConsumePoint],[ConsumeType],[ConsumeTime],[ConsumeCount],[Shares],[SafeGuard],[ItemOpenTypeTrue],[OpenTypeTrue],[NodeBySite],[Contribute],[SiteContentAudit],[AddPoint],[AddMoney],[ClickTimeout],[Purview],[AddUserExp],[DeducUserExp],[ListPageEx],[LastinfoPageEx],[HotinfoPageEx],[ProposePageEx]) VALUES ( 143,N'文件工厂',1,N'wjgc',0,50,0,1,0,0,0,0,N'频道首页/律所通首页.html',N'25',0,2,3,3,1,1,0,0,0,0,0,0,N'_self',N'_self',0,0,0,0,0.0000,1,N'<View>allUser</View><ViewGroup></ViewGroup><ViewSunGroup></ViewSunGroup><input></input><forum>1,2</forum>',0,0,3,3,3,3)

SET IDENTITY_INSERT ZL_Node OFF


INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 1,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 76,1,N'内容页/默认公告内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 77,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 77,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 78,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 78,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 79,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 79,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 80,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 80,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 82,2,N'内容页/默认文章模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 82,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 85,3,N'内容页/仿新浪幻灯片_图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 81,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 81,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 83,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 83,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 84,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 88,8,N'内容页/默认友情链接内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 76,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 86,7,N'内容页/默认视频模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 75,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 89,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 89,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 84,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 90,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 90,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 91,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 91,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 92,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 92,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 93,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 93,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 94,4,N'内容页/默认下载模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 94,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 97,3,N'内容页/默认图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 98,3,N'内容页/默认图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 2,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 99,19,N'内容页/默认信息模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 95,7,N'内容页/默认视频模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 96,7,N'内容页/默认视频模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 100,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 100,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 101,19,N'内容页/默认信息模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 102,19,N'内容页/默认信息模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 105,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 107,3,N'内容页/仿新浪幻灯片_图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 108,3,N'内容页/仿新浪幻灯片_图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 109,3,N'内容页/仿新浪幻灯片_图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 112,3,N'内容页/仿新浪幻灯片_图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 121,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 114,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 114,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 3,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 124,2,N'/店铺模版/店铺首页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 125,2,N'/店铺模版/店铺信息列表页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 127,2,N'/店铺模版/店铺信息内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 129,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 130,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 131,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 132,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 133,6,N'内容页/默认商品模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 134,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 134,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 135,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 135,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 136,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 136,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 137,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 137,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 138,19,N'内容页/默认信息模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 139,2,N'内容页/两列式标准内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 139,5,N'内容页/默认转向链接模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 103,19,N'内容页/默认信息模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 104,19,N'内容页/默认信息模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 111,3,N'内容页/仿新浪幻灯片_图库模型内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 25,20,N'店铺模版/店铺首页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 8,20,N'店铺模版/店铺商品列表页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 19,20,N'店铺模版/店铺商品列表页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 26,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 27,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 28,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 29,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 30,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 31,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 32,20,N'店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 33,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 34,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 20,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 35,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 36,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 37,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 38,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 39,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 40,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 41,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 42,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 43,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 44,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 45,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 46,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 21,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 47,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 48,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 49,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 50,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 51,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 52,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 53,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 54,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 55,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 22,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 56,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 57,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 58,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 59,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 60,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 61,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 62,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 63,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 64,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 23,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 65,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 66,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 67,20,N'/店铺模版/默认店铺商品内容页.html')
INSERT [ZL_Node_ModelTemplate] ([NodeID],[ModelID],[Template]) VALUES ( 68,20,