/**
*
* name:cnGame.js	
*`author:cson
*`date:2012-2-7
*`version:1.0
*
**/	

(function(win,undefined){
	var canvasPos;
	/**
	*ȡcanvasҳλ
	**/	  
	var getCanvasPos=function(canvas){
		var left = 0;
		var top = 0;
		while (canvas.offsetParent) {
			left += canvas.offsetLeft;
			top += canvas.offsetTop;
			canvas = canvas.offsetParent;

		}
		return [left, top];

	}
	
	var _cnGame={
		/**
		 *ʼ
		**/
		init:function(id,options){
			options=options||{};
			this.canvas = this.core.$(id||"canvas");	
			this.context = this.canvas.getContext('2d');
			this.width = options.width||800;
			this.height = options.height||600;
			this.title = this.core.$$('title')[0];
			canvasPos=getCanvasPos(this.canvas);
			this.x=canvasPos[0]||0;
			this.y=canvasPos[1]||0;
			this.canvas.width=this.width;
			this.canvas.height=this.height;
			this.canvas.style.left=this.x +"px";
			this.canvas.style.top=this.y +"px";
			
		},
		/**
		 *ռ,ִӦ
		**/
		register:function(nameSpace,func){
			var nsArr=nameSpace.split(".");
			var parent=win;
			for(var i=0,len=nsArr.length;i<len;i++){
				(typeof parent[nsArr[i]]=='undefined')&&(parent[nsArr[i]]={});
				parent=parent[nsArr[i]];
			}
			if(func){
				func.call(parent,this);	
			}
			return parent;
		},
		/**
		 *
		**/
		clean:function(){
			this.context.clearRect(this.width,this.height);
		}
		
		
		
			
	}
			  
		  	  
	win["cnGame"]=_cnGame;		  
		  
		  



/**
 *
 *ߺ
 *
**/
cnGame.register("cnGame.core",function(cg){
		/**
		idȡԪ
		**/
		this.$=function(id){
			return document.getElementById(id);		
		};
		/**
		ǩȡԪ
		**/
		this.$$=function(tagName,parent){
			parent=parent||document;
			return parent.getElementsByTagName(tagName);	
		};
		/**
		ȡԪ
		**/
		this.$Class=function(className,parent){
			var arr=[],result=[];
			parent=parent||document;
			arr=this.$$("*");
			for(var i=0,len=arr.length;i<len;i++){
				if((" "+arr[i].className+" ").indexOf(" "+className+" ")>0){
					result.push(arr[i]);
				}
			}
			return result;	
		};
		/**
		¼
		**/
		this.bindHandler=(function(){
							
						if(window.addEventListener){
							return function(elem,type,handler){
								elem.addEventListener(type,handler,false);
								
							}
						}
						else if(window.attachEvent){
							return function(elem,type,handler){
								elem.attachEvent("on"+type,handler);
							}
						}
		})();
		/**
		¼
		**/
		this.removeHandler=(function(){
						if(window.removeEventListerner){
							return function(elem,type,handler){
								elem.removeEventListerner(type,handler,false);
								
							}
						}
						else if(window.detachEvent){
							return function(elem,type,handler){
								elem.detachEvent("on"+type,handler);
							}
						}
		})();
		/**
		ȡ¼
		**/
		this.getEventObj=function(eve){
			return eve||win.event;
		};
		/**
		ȡ¼Ŀ
		**/
		this.getEventTarget=function(eve){
			var eve=this.getEventObj(eve);
			return eve.target||eve.srcElement;
		};
		/**
		ֹĬΪ
		**/
		this.preventDefault=function(eve){
			if(eve.preventDefault){
				eve.preventDefault();
			}
			else{
				eve.returnValue=false;
			}
			
		};
		/**
		ȡʽ
		**/
		this.getComputerStyle = (function() {
			var body=document.body||document.documentElement;
			if(body.currentStyle){
				return function(elem){
					return elem.currentStyle;
				}
			}
			else if(document.defaultView.getComputedStyle){
				return function(elem){
					return document.defaultView.getComputedStyle(elem, null);	
				}
			}
			
		})();
		/**
		ǷΪundefined
		**/
		this.isUndefined=function(elem){
			return typeof elem==='undefined';
		},
		/**
		ǷΪ
		**/
		this.isArray=function(elem){
			return Object.prototype.toString.call(elem)==="[object Array]";
		};
		/**
		ǷΪObject
		**/
		this.isObject=function(elem){
			return elem===Object(elem);
		};
		/**
		ǷΪַ
		**/
		this.isString=function(elem){
			return Object.prototype.toString.call(elem)==="[object String]";
		};
		/**
		ǷΪֵ
		**/
		this.isNum=function(elem){
			return Object.prototype.toString.call(elem)==="[object Number]";
		};
		/**
		 *ƶ
		**/
		this.extend=function(destination,source,isCover){
			var isUndefined=this.isUndefined;
			(isUndefined(isCover))&&(isCover=true);
			for(var name in source){
				if(isCover||isUndefined(destination[name])){
					destination[name]=source[name];
				}
			
			}
			return destination;
		};
		/**
		 *ԭͼ̳ж
		**/
		this.inherit=function(child,parent){
			var func=function(){};
			func.prototype=parent.prototype;
			child.prototype=new func();
			child.prototype.constructor=child;
			child.prototype.parent=parent;
		};
	
});

/**
 *
 *Դ
 *
**/
cnGame.register("cnGame",function(cg){
	
	var file_type = {}
 	file_type["json"] = "json"
 	file_type["wav"] = "audio"
 	file_type["mp3"] = "audio"
	file_type["ogg"] = "audio"
 	file_type["png"] = "image"
	file_type["jpg"] = "image"
 	file_type["jpeg"] = "image"
	file_type["gif"] = "image"
	file_type["bmp"] = "image"
	file_type["tiff"] = "image"
	var postfix_regexp = /\.([a-zA-Z0-9]+)/;
	/**
	 *ԴϵĴ
	**/	
	var resourceLoad=function(self,type){
		return function(){
			self.loadedCount+=1;
			type=="image"&&(self.loadedImgs[this.srcPath]=this);
			type=="audio"&&(self.loadedAudios[this.srcPath]=this);
			this.onLoad=null;					//֤ͼƬonLoadִһκ
			self.loadedPercent=Math.floor(self.loadedCount/self.sum*100);
			self.onLoad&&self.onLoad(self.loadedPercent);
			if(self.loadedPercent===100){
				self.loadedCount=0;
				self.loadedPercent=0;
				type=="image"&&(self.loadingImgs={});
				type=="audio"&&(self.loadingAudios={});
				if(self.gameObj&&self.gameObj.initialize){
					self.gameObj.initialize(self.startOptions);
					if(cg.loop&&!cg.loop.stop){//һѭ
						cg.loop.end();
					}
					cg.loop=new cg.GameLoop(self.gameObj);//ʼϷѭ
					cg.loop.start();
				}	
			}
		}
	}
	
	/**
	 *ͼ
	**/	
	var loader={
		sum:0,			//ͼƬ
		loadedCount:0,	//ͼƬѼ
		loadingImgs:{}, //δͼƬ
		loadedImgs:{},	//ѼͼƬ
		loadingAudios:{},//δƵ
		loadedAudios:{},//ѼƵ
		/**
		 *ͼأ֮Ϸ
		**/	
		start:function(gameObj,options){//options:srcArray,onload
			var srcArr=options.srcArray;
			this.gameObj=gameObj;
			this.startOptions=options.startOptions;//ϷʼҪĳʼ
			this.onLoad=options.onLoad;
			cg.spriteList.clean();
			
			if(cg.core.isArray(srcArr)){ 
				this.sum=srcArr.length;
				for(var i=0,len=srcArr.length;i<len;i++){
					var path=srcArr[i];
					var suffix=srcArr[i].substring(srcArr[i].lastIndexOf(".")+1);
					var type=file_type[suffix];
					if(type=="image"){		
						this.loadingImgs[path]=new Image();
						cg.core.bindHandler(this.loadingImgs[path],"load",resourceLoad(this,type));
						this.loadingImgs[path].src=path;
						this.loadingImgs[path].srcPath=path;//ûоԶ任src
					}
					else if(type=="audio"){
						this.loadingAudios[path]=new Audio(path);
						cg.core.bindHandler(this.loadingAudios[path],"canplay",resourceLoad(this,type));
						this.loadingAudios[path].onload=resourceLoad(this,type);
						this.loadingAudios[path].src=path;
						this.loadingAudios[path].srcPath=path;//ûоԶ任src
					}
				}
					
			}
			
		}
		
	}
	
	
	this.loader=loader;
});




/**
 *
 *canvas״
 *
**/
cnGame.register("cnGame.shape",function(cg){

	/**
	 *rightbottom
	**/	
	var resetRightBottom=function(elem){
		elem.right=elem.x+elem.width;
		elem.bottom=elem.y+elem.height;	
	}
	/**
	 *ζ
	**/										
	var rect=function(options){
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(options);
		}
		this.init(options);
	}
	rect.prototype={
		/**
		 *ʼ
		**/
		init:function(options){
			/**
			 *Ĭֵ
			**/												
			var defaultObj={
				x:0,
				y:0,
				width:100,
				height:100,
				style:"red",
				isFill:true
				
			};
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.setOptions(options);
		
			resetRightBottom(this);
		},
		/**
		 *ò
		**/	
		setOptions:function(options){
			this.x=options.x||this.x;
			this.y=options.y||this.y;
			this.width=options.width||this.width;
			this.height=options.height||this.height;	
			this.style=options.style||this.style;
			this.isFill=options.isFill||this.isFill;
		},
		/**
		 *ƾ
		**/	
		draw:function(){
			var context=cg.context;
			if(this.isFill){
				context.fillStyle = this.style;
				context.fillRect(this.x, this.y, this.width, this.height);
			}
			else{
				context.strokeStyle = this.style;
				context.strokeRect(this.x, this.y, this.width, this.height);
			}
			
  			return this;
			
		},
		/**
		 *ƶһ
		**/	
		move:function(dx,dy){
			dx=dx||0;
			dy=dy||0;
			this.x+=dx;
			this.y+=dy;
			resetRightBottom(this);
			return this;
		},
		/**
		 *ƶضλ
		**/	
		moveTo:function(x,y){
			x=x||this.x;
			y=y||this.y;
			this.x=x;
			this.y=y;
			resetRightBottom(this);
			return this;
		},
		/**
		 *θıһС
		**/	
		resize:function(dWidth,dHeight){
			dWidth=dWidth||0;
			dHeight=dHeight||0;
			this.width+=dWidth;
			this.height+=dHeight;
			resetRightBottom(this);
			return this;
			
		},
		/**
		 *θı䵽ضС
		**/	
		resizeTo:function(width,height){
			width=width||this.width;
			height=height||this.height;
			this.width=width;
			this.height=height;
			resetRightBottom(this);
			return this;
		}
	}
	
	/**
	 *Բζ
	**/		
	var circle=function(options){
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(options);
		}
		this.init(options);
	}
	circle.prototype={
		/**
		 *ʼ
		**/
		init:function(options){
			/**
			 *Ĭֵ
			**/
			var defaultObj={
				x:100,
				y:100,
				r:100,
				startAngle:0,
				endAngle:Math.PI*2,
				antiClock:false,
				style:"red",
				isFill:true
			};
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.setOptions(options);
		
		},
		/**
		 *ò
		**/
		setOptions:function(options){
			this.x=options.x||this.x;
			this.y=options.y||this.y;
			this.r=options.r||this.r;
			this.startAngle=options.startAngle||this.startAngle;
			this.endAngle=options.endAngle||this.endAngle;
			this.antiClock=options.antiClock||this.antiClock;
			this.isFill=options.isFill||this.isFill;
			this.style=options.style||this.style;
		},
		/**
		 *Բ
		**/
		draw:function(){
			var context=cg.context;
			context.beginPath();
			context.arc(this.x,this.y,this.r,this.startAngle,this.endAngle,this.antiClock);
			context.closePath();
			if(this.isFill){
				context.fillStyle=this.style;
				context.fill();
			}
			else{
				context.strokeStyle=this.style;
				context.stroke();
			}
			
		},
		/**
		 *Բƶһ
		**/	
		move:function(dx,dy){
			dx=dx||0;
			dy=dy||0;
			this.x+=dx;
			this.y+=dy;
			return this;
		},
		/**
		 *Բƶضλ
		**/	
		moveTo:function(x,y){
			x=x||this.x;
			y=y||this.y;
			this.x=x;
			this.y=y;
			return this;
		},
		/**
		 *ԲθıһС
		**/	
		resize:function(dr){
			dr=dr||0;
			this.r+=dr;
			return this;
			
		},
		/**
		 *Բθı䵽ضС
		**/	
		resizeTo:function(r){
			r=r||this.r;
			this.r=r;
			return this;
		}	
	}
	/**
	 *Բθı䵽ضС
	**/	
	var text=function(text,options){
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(text,options);
		}
		this.init(text,options);
	
	}
	text.prototype={
		/**
		 *ʼ
		**/
		init:function(text,options){
			/**
			 *Ĭֵ
			**/
			var defaultObj={
				x:100,
				y:100,
				style:"red",
				isFill:true
				
			};
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.setOptions(options);
			this.text=text;		
		},
		/**
		*
		**/
		draw:function(){
			var context=cg.context;
			(!cg.core.isUndefined(this.font))&&(context.font=this.font);
			(!cg.core.isUndefined(this.textBaseline))&&(context.textBaseline=this.textBaseline);
			(!cg.core.isUndefined(this.textAlign))&&(context.textAlign=this.textAlign);
			(!cg.core.isUndefined(this.maxWidth))&&(context.maxWidth=this.maxWidth);
			if(this.isFill){
				context.fillStyle=this.style;
				this.maxWidth?context.fillText(this.text,this.x,this.y,this.maxWidth):context.fillText(this.text,this.x,this.y);
			}
			else{
				context.strokeStyle=this.style;
				this.maxWidth?context.strokeText(this.text,this.x,this.y,this.maxWidth):context.strokeText(this.text,this.x,this.y);
			}
		},
		/**
		*ò
		**/
		setOptions:function(options){
			this.x=options.x||this.x;
			this.y=options.y||this.y;
			this.maxWidth=options.maxWidth||this.maxWidth;
			this.font=options.font||this.font;
			this.textBaseline=options.textBaseline||this.textBaseline;
			this.textAlign=options.textAlign||this.textAlign;
			this.isFill=options.isFill||this.isFill;
			this.style=options.style||this.style;
			
		}
	}
	
	this.Text=text;
	this.Rect=rect;
	this.Circle=circle;
	
});



/**
 *
 *¼ģ
 *
**/
cnGame.register("cnGame.input",function(cg){
											
	this.mouseX=0;
	this.mouseY=0;
	/**
	 *¼canvasڵλ
	**/	
	var recordMouseMove=function(eve){
		var pageX,pageY,x,y;
		eve=cg.core.getEventObj(eve);
	    pageX = eve.pageX || eve.clientX + document.documentElement.scrollLeft - document.documentElement.clientLeft;
		pageY = eve.pageY || eve.clientY + document.documentElement.scrollTop - document.documentElement.clientTop;
		cg.input.mouseX=pageX-cg.x;
		cg.input.mouseY=pageY-cg.y;
	}		
	
	cg.core.bindHandler(window,"mousemove",recordMouseMove);
	
	/**
	 *µļļ
	**/	
	var pressed_keys={};
	/**
	 *ҪֹĬΪļļ
	**/	
	var preventDefault_keys={};
	/**
	 *̰´Ĵ
	**/	
	var keydown_callbacks={};
	/**
	 *̵𴥷Ĵ
	**/	
	var keyup_callbacks={};

	
	/**
	 *̰ͼ
	**/	
	var k=[];
	k[8] = "backspace"
	k[9] = "tab"
	k[13] = "enter"
	k[16] = "shift"
	k[17] = "ctrl"
	k[18] = "alt"
	k[19] = "pause"
	k[20] = "capslock"
	k[27] = "esc"
	k[32] = "space"
	k[33] = "pageup"
	k[34] = "pagedown"
	k[35] = "end"
	k[36] = "home"
	k[37] = "left"
	k[38] = "up"
	k[39] = "right"
	k[40] = "down" 
	k[45] = "insert"
	k[46] = "delete"
	
	k[91] = "leftwindowkey"
	k[92] = "rightwindowkey"
	k[93] = "selectkey"
	k[106] = "multiply"
	k[107] = "add"
	k[109] = "subtract"
	k[110] = "decimalpoint"
	k[111] = "divide"
	
	k[144] = "numlock"
	k[145] = "scrollock"
	k[186] = "semicolon"
	k[187] = "equalsign"
	k[188] = "comma"
	k[189] = "dash"
	k[190] = "period"
	k[191] = "forwardslash"
	k[192] = "graveaccent"
	k[219] = "openbracket"
	k[220] = "backslash"
	k[221] = "closebracket"
	k[222] = "singlequote"
	
	var numpadkeys = ["numpad1","numpad2","numpad3","numpad4","numpad5","numpad6","numpad7","numpad8","numpad9"]
	var fkeys = ["f1","f2","f3","f4","f5","f6","f7","f8","f9"]
	var numbers = ["0","1","2","3","4","5","6","7","8","9"]
	var letters = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]
	for(var i = 0; numbers[i]; i++)     { k[48+i] = numbers[i] }
	for(var i = 0; letters[i]; i++)     { k[65+i] = letters[i] }
	for(var i = 0; numpadkeys[i]; i++)  { k[96+i] = numpadkeys[i] }
	for(var i = 0; fkeys[i]; i++)       { k[112+i] = fkeys[i] }
	
	/**
	 *¼̰µļ
	**/	
	var recordPress=function(eve){
		eve=cg.core.getEventObj(eve);
		var keyName=k[eve.keyCode];
		pressed_keys[keyName]=true;	
		if(keydown_callbacks[keyName]){
			for(var i=0,len=keydown_callbacks[keyName].length;i<len;i++){
				keydown_callbacks[keyName][i]();
				
			}
		
		}
		if(keydown_callbacks["allKeys"]){
			for(var i=0,len=keydown_callbacks["allKeys"].length;i<len;i++){
				keydown_callbacks["allKeys"][i]();
				
			}
		}
		if(preventDefault_keys[keyName]){
			cg.core.preventDefault(eve);
		}
	}
	/**
	 *¼ɿļ
	**/	
	var recordUp=function(eve){
		eve=cg.core.getEventObj(eve);
		var keyName=k[eve.keyCode];
		pressed_keys[keyName]=false;
		if(keyup_callbacks[keyName]){
			for(var i=0,len=keyup_callbacks[keyName].length;i<len;i++){
				keyup_callbacks[keyName][i]();
				
			}	
		}
		if(keyup_callbacks["allKeys"]){
			for(var i=0,len=keyup_callbacks["allKeys"].length;i<len;i++){
				keyup_callbacks["allKeys"][i]();
				
			}
		}
		if(preventDefault_keys[keyName]){
			cg.core.preventDefault(eve);
		}
	}
	cg.core.bindHandler(window,"keydown",recordPress);
	cg.core.bindHandler(window,"keyup",recordUp);
	
	/**
	 *жĳǷ
	**/	
	this.isPressed=function(keyName){
		return !!pressed_keys[keyName];	
	};
	/**
	 *ֹĳµĬΪ
	**/	
	this.preventDefault=function(keyName){
		if(cg.core.isArray(keyName)){
			for(var i=0,len=keyName.length;i<len;i++){
				arguments.callee.call(this,keyName[i]);
			}
		}
		else{
			preventDefault_keys[keyName]=true;
		}
	}
	/**
	 *󶨼̰¼
	**/	
	this.onKeyDown=function(keyName,handler){
		keyName=keyName||"allKeys";
		if(cg.core.isUndefined(keydown_callbacks[keyName])){
			keydown_callbacks[keyName]=[];							
		}
		keydown_callbacks[keyName].push(handler);
	
	}
	/**
	 *󶨼̵¼
	**/	
	this.onKeyUp=function(keyName,handler){
		keyName=keyName||"allKeys";
		if(cg.core.isUndefined(keyup_callbacks[keyName])){
			keyup_callbacks[keyName]=[];							
		}
		keyup_callbacks[keyName].push(handler);
	
	}
	/**
	 *̰¼
	**/	
	this.clearDownCallbacks=function(keyName){
		if(keyName){
			keydown_callbacks[keyName]=[];
		}
		else{
			keydown_callbacks={};
		}
		
	}
	/**
	 *̵¼
	**/	
	this.clearUpCallbacks=function(keyName){
		if(keyName){
			keyup_callbacks[keyName]=[];
		}
		else{
			keyup_callbacks={};
		}
		
	}											
});
		
/**
 *
 *ײ
 *
**/
cnGame.register("cnGame.collision",function(cg){
	/**
	 *;μײ
	**/	
	this.col_Point_Rect=function(pointX,pointY,rectObj){
		return (pointX>=rectObj.x&&pointX<=rectObj.right||pointY>=rectObj.y&&pointY<=rectObj.bottom);		
	}
	/**
	 *κ;μײ
	**/	
	this.col_Between_Rects=function(rectObjA,rectObjB){
		return ((rectObjA.right>=rectObjB.x&&rectObjA.right<=rectObjB.right||rectObjA.x>=rectObjB.x&&rectObjA.x<=rectObjB.right)&&(rectObjA.bottom>=rectObjB.y&&rectObjA.bottom<=rectObjB.bottom||rectObjA.y<=rectObjB.bottom&&rectObjA.bottom>=rectObjB.y));		
	}
	/**
	 *Բμײ
	**/	
	this.col_Point_Circle=function(pointX,pointY,circleObj){
		return(Math.pow((pointX-circleObj.x),2)+Math.pow((pointY-circleObj.y),2)<Math.pow(circleObj.r,2));
		
	}
	/**
	 *ԲκԲμײ
	**/	
	this.col_between_Circles=function(circleObjA,circleObjB){
		return(Math.pow((circleObjA.x-circleObjB.x),2)+Math.pow((circleObjA.y-circleObjB.y),2)<Math.pow((circleObjA.r+circleObjB).r,2));
		
	}
										
});

/**
 *
 *
 *
**/
cnGame.register("cnGame",function(cg){
	
	/**
	 *֡
	**/
	var path=1;
		
	/**
	 *ȡ֡
	**/
	var caculateFrames=function(options){
		var frames=[];
		var width=options.width;
		var height=options.height;
		var beginX=options.beginX;
		var beginY=options.beginY;
		var frameSize=options.frameSize;
		var direction=options.direction;
		var x,y;
		/* ÿһ֡ľȷλ */
		if(direction=="right"){
			for(var y=beginY;y<height;y+=frameSize[1]){
				for(var x=beginX;x<width;x+=frameSize[0]){
					var frame={};
					frame.x=x;
					frame.y=y;
					frames.push(frame);
				
				}
				
			}
		}
		else{
			for(var x=beginX;x<width;x+=frameSize[0]){
				for(var y=beginY;y<height;y+=frameSize[1]){
					var frame={};
					frame.x=x;
					frame.y=y;
					frames.push(frame);
				
				}
				
			}		
			
		}
		return frames;
		
	}
	/**
	 *֡ͼĴͼƬ
	**/	
	spriteSheet=function(id,src,options){
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(id,src,options);
		}
		this.init(id,src,options);
	}
	spriteSheet.prototype={
		/**
		 *ʼ
		**/
		init:function(id,src,options){
			
			/**
			 *Ĭ϶
			**/	
			var defaultObj={
				x:0,
				y:0,
				width:120,
				height:40,
				frameSize:[40,40],
				frameDuration:100,
				direction:"right",	//
				beginX:0,
				beginY:0,
				loop:false,
				bounce:false		
			};
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.id=id;									//spriteSheetid
			this.src=src;								//ͼƬַ
			this.x=options.x;							//Xλ
			this.y=options.y;							//Yλ
			this.width=options.width;					//ͼƬĿ
			this.height=options.height;					//ͼƬĸ߶
			this.image=cg.loader.loadedImgs[this.src]; //ͼƬ
			this.frameSize=options.frameSize;			//ÿ֡ߴ
			this.frameDuration=options.frameDuration;	//ÿ֡ʱ
			this.direction=options.direction;			//ȡ֡ķ򣨴һϵ£
			this.currentIndex=0;						//Ŀǰ֡
			this.beginX=options.beginX;					//ȡͼƬʼλX
			this.beginY=options.beginY;					//ͼͼƬʼλY
			this.loop=options.loop;						//Ƿѭ
			this.bounce=options.bounce;					//Ƿ
			this.onFinish=options.onFinish;				//ϺĻص
			this.frames=caculateFrames(options);		//֡Ϣ
			this.now=new Date().getTime();				//ǰʱ
			this.last=new Date().getTime();			//һ֡ʼʱ
		},
		/**
		 *֡
		**/	
		update:function(){
			
			this.now=new Date().getTime();
			var frames=this.frames;
			if((this.now-this.last)>this.frameDuration){//֡update
				var currentIndex=this.currentIndex;
				var length=this.frames.length;
				this.last=this.now;
				
				if(currentIndex>=length-1){
					if(this.loop){	//ѭ
						return frames[this.currentIndex=0];	
					}
					else if(!this.bounce){//ûѭûֹͣһ֡
						this.onFinish&&this.onFinish();
						this.onFinish=undefined;
						return frames[currentIndex];
					}
				}
				if((this.bounce)&&((currentIndex>=length-1&&path>0)||(currentIndex<=0&&path<0))){	//
					path*=(-1);
				}
				this.currentIndex+=path;
				
			}
			return frames[this.currentIndex];
		},
		/**
		 *ض֡
		**/
		index:function(index){
			this.currentIndex=index;
			return this.frames[this.currentIndex];	
		},
		/**
		 *ȡʱ֡
		**/
		getCurrentFrame:function(){
			return this.frames[this.currentIndex];	
		},
		/**
		 *ضλûƸ֡
		**/
		draw:function(){
			
			var currentFrame=this.getCurrentFrame();
			var width=this.frameSize[0];
			var height = this.frameSize[1];
			cg.context.drawImage(this.image,currentFrame.x,currentFrame.y,width,height,this.x,this.y,width,height);
		}
		
	}
	this.SpriteSheet=spriteSheet;
										
});

/**
 *
 *sprite
 *
**/
cnGame.register("cnGame",function(cg){
								  
	var postive_infinity=Number.POSITIVE_INFINITY;			
	
	var sprite=function(id,options){
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(id,options);
		}
		this.init(id,options);
	}
	sprite.prototype={
		/**
		 *ʼ
		**/
		init:function(options){
			
			/**
			 *Ĭ϶
			**/	
			var defaultObj={
				x:0,
				y:0,
				imgX:0,
				imgY:0,
				width:32,
				height:32,
				angle:0,
				speedX:0,
				speedY:0,
				rotateSpeed:0,
				aR:0,
				aX:0,
				aY:0,
				maxSpeedX:postive_infinity,
				maxSpeedY:postive_infinity,
				maxX:postive_infinity,
				maxY:postive_infinity,
				minX:-postive_infinity,
				minY:-postive_infinity,
				minAngle:-postive_infinity,
				maxAngle:postive_infinity
			};
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.x=options.x;
			this.y=options.y;
			this.angle=options.angle;
			this.width=options.width;
			this.height=options.height;
			this.angle=options.angle;
			this.speedX=options.speedX;
			this.speedY=options.speedY;
			this.rotateSpeed=options.rotateSpeed;
			this.aR=options.aR;
			this.aX=options.aX;
			this.aY=options.aY;
			this.maxSpeedX=options.maxSpeedX;
			this.maxSpeedY=options.maxSpeedY;
			this.maxX=options.maxX;
			this.maxY=options.maxY;
			this.maxAngle=options.maxAngle;
			this.minAngle=options.minAngle;
			this.minX=options.minX;
			this.minY=options.minY;
			this.spriteSheetList={};
			
			if(options.src){	//ͼƬ·
				this.setCurrentImage(options.src,options.imgX,options.imgY);
			}
			else if(options.spriteSheet){//spriteSheet
				this.addAnimation(options.spriteSheet);		
				setCurrentAnimation(options.spriteSheet);
			}
			
		},
		/**
		 *ذspriteľζ
		**/
		getRect:function(){
			return new cg.shape.Rect({x:this.x,y:this.y,width:this.width,height:this.height});
			
		},
		/**
		 *Ӷ
		**/
		addAnimation:function(spriteSheet){
			this.spriteSheetList[spriteSheet.id]=spriteSheet;	
		},
		/**
		 *õǰʾ
		**/
		setCurrentAnimation:function(id){//ɴidspriteSheet
			if(!this.isCurrentAnimation(id)){
				if(cg.core.isString(id)){
					this.spriteSheet=this.spriteSheetList[id];
					this.image=this.imgX=this.imgY=undefined;
				}
				else if(cg.core.isObject(id)){
					this.spriteSheet=id;
					this.addAnimation(id);
					this.image=this.imgX=this.imgY=undefined;
				}
			}
		
		},
		/**
		 *жϵǰǷΪidĶ
		**/
		isCurrentAnimation:function(id){
			if(cg.core.isString(id)){
				return (this.spriteSheet&&this.spriteSheet.id===id);
			}
			else if(cg.core.isObject(id)){
				return this.spriteSheet===id;
			}
		},
		/**
		 *õǰʾͼ
		**/
		setCurrentImage:function(src,imgX,imgY){
			if(!this.isCurrentImage(src,imgX,imgY)){
				imgX=imgX||0;
				imgY=imgY||0;
				this.image=cg.loader.loadedImgs[src];	
				this.imgX=imgX;
				this.imgY=imgY;	
				this.spriteSheet=undefined;
			}
		},
		/**
		 *жϵǰͼǷΪsrcͼ
		**/
		isCurrentImage:function(src,imgX,imgY){
			imgX=imgX||0;
			imgY=imgY||0;
			var image=this.image;
			if(cg.core.isString(src)){
				return (image&&image.srcPath===src&&this.imgX===imgX&&this.imgY===imgY);
			}
		},
			/**
		 *ƶ
		**/
		setMovement:function(options){
			isUndefined=cg.core.isUndefined;
			isUndefined(options.speedX)?this.speedX=this.speedX:this.speedX=options.speedX;
			isUndefined(options.speedY)?this.speedY=this.speedY:this.speedY=options.speedY;
			isUndefined(options.rotateSpeed)?this.rotateSpeed=this.rotateSpeed:this.rotateSpeed=options.rotateSpeed;
			isUndefined(options.aX)?this.aR=this.aR:this.aR=options.aR;
			isUndefined(options.aX)?this.aX=this.aX:this.aX=options.aX;
			isUndefined(options.aY)?this.aY=this.aY:this.aY=options.aY;
			isUndefined(options.maxX)?this.maxX=this.maxX:this.maxX=options.maxX;
			isUndefined(options.maxY)?this.maxY=this.maxY:this.maxY=options.maxY;
			isUndefined(options.maxAngle)?this.maxAngle=this.maxAngle:this.maxAngle=options.maxAngle;
			isUndefined(options.minAngle)?this.minAngle=this.minAngle:this.minAngle=options.minAngle;
			isUndefined(options.minX)?this.minX=this.minX:this.minX=options.minX;
			isUndefined(options.minY)?this.minY=this.minY:this.minY=options.minY;
			isUndefined(options.maxSpeedX)?this.maxSpeedX=this.maxSpeedX:this.maxSpeedX=options.maxSpeedX;	
			isUndefined(options.maxSpeedY)?this.maxSpeedY=this.maxSpeedY:this.maxSpeedY=options.maxSpeedY;	
			
			
		},
		/**
		 *ƶصʼֵ
		**/
		resetMovement:function(){
			this.speedX=0;
			this.speedY=0;
			this.rotateSpeed=0;
			this.aX=0;
			this.aY=0;
			this.aR=0;
			this.maxSpeedX=postive_infinity;
			this.maxSpeedY=postive_infinity;
			this.maxX=postive_infinity;
			this.minX=-postive_infinity;
			this.maxY=postive_infinity;
			this.minY=-postive_infinity;
			this.maxAngle=postive_infinity;
			this.minAngle=-postive_infinity;
		},
			/**
		 *λú֡
		**/
		update:function(duration){//duration:֡ʱ λ
			this.speedX=this.speedX+this.aX*duration;	
			if(this.maxSpeedX<0){
				this.maxSpeedX*=-1;
			}
			if(this.speedX<0){
				this.speedX=Math.max(this.speedX,this.maxSpeedX*-1)	;
			}
			else{
				this.speedX=Math.min(this.speedX,this.maxSpeedX);
			}
	
			this.speedY=this.speedY+this.aY*duration;	
			if(this.maxSpeedY<0){
				this.maxSpeedY*=-1;
			}
			if(this.speedY<0){
				this.speedY=Math.max(this.speedY,this.maxSpeedY*-1)	;
			}
			else{
				this.speedY=Math.min(this.speedY,this.maxSpeedY);
			}
			this.rotateSpeed=this.rotateSpeed+this.aR*duration;	
		
			this.rotate(this.rotateSpeed).move(this.speedX,this.speedY);
		
			if(this.spriteSheet){//spriteSheet
				this.spriteSheet.x=this.x
				this.spriteSheet.y=this.y;
				this.spriteSheet.update();
			}
		},
		/**
		 *Ƴsprite
		**/
		draw:function(){
			var context=cg.context;
			var halfWith;
			var halfHeight;
			if(this.spriteSheet){
				this.spriteSheet.x=this.x
				this.spriteSheet.y=this.y;
				this.spriteSheet.draw();
			}
			else if(this.image){
				context.save()
				halfWith=this.width/2;
				halfHeight=this.height/2;
				context.translate(this.x+halfWith, this.y+halfHeight);
				context.rotate(this.angle * Math.PI / 180*-1);
				context.drawImage(this.image,this.imgX,this.imgY,this.width,this.height,-halfWith,-halfHeight,this.width,this.height);
				context.restore();
			}
		
		},
		/**
		 *ƶһ
		**/
		move:function(dx,dy){
			dx=dx||0;
			dy=dy||0;
			var x=this.x+dx;
			var y=this.y+dy;
			this.x=Math.min(Math.max(this.minX,x),this.maxX);
			this.y=Math.min(Math.max(this.minY,y),this.maxY);
			return this;
			
		},
		/**
		 *ƶĳ
		**/
		moveTo:function(x,y){
			this.x=Math.min(Math.max(this.minX,x),this.maxX);
			this.y=Math.min(Math.max(this.minY,y),this.maxY);
			return this;
		},
		/**
		 *תһǶ
		**/
		rotate:function(da){
			da=da||0;
			var angle=this.angle+da;
			
			this.angle=Math.min(Math.max(this.minAngle,angle),this.maxAngle);
			return this;
		},
		/**
		 *תһǶ
		**/
		rotateTo:function(a){
			this.angle=Math.min(Math.max(this.minAngle,a),this.maxAngle);
			return this;
			
		},
		/**
		 *ıһߴ
		**/
		resize:function(dw,dh){
			this.width+=dw;
			this.height+=dh;
			return this;
		},
		/**
		 *ı䵽һߴ
		**/
		resizeTo:function(width,height){
			this.width=width;
			this.height=height;
			return this;
		}
		
	}
	this.Sprite=sprite;							  
								  
});
/**
 *
 *spriteб
 *
**/
cnGame.register("cnGame",function(cg){
								  
	var spriteList={
		length:0,
		add:function(sprite){
			Array.prototype.push.call(this,sprite);
		},
		remove:function(sprite){
			for(var i=0,len=this.length;i<len;i++){
				if(this[i]===sprite){
					Array.prototype.splice.call(this,i,1);
				}
			}
		},
		clean:function(){
			for(var i=0,len=this.length;i<len;i++){
				Array.prototype.pop.call(this);
			}	
		}
	}
	this.spriteList=spriteList;
});

/**
 *
 *Ϸѭ
 *
**/
cnGame.register("cnGame",function(cg){

	var timeId;
	var interval;
	/**
	*ѭ
	**/	
	var loop=function(){
		var self=this;
		return function(){
			if(!self.pause&&!self.stop){
				var now=new Date().getTime();
				var duration=(now-self.lastTime)/1000;//֡ʱ
				var spriteList=cg.spriteList;
				self.loopDuration=(self.startTime-self.now)/1000;
		
				if(self.gameObj.update){//Ϸupdate
					self.gameObj.update(duration);
				}
				if(self.gameObj.draw){
					cg.context.clearRect(0,0,cg.width,cg.height);
					self.gameObj.draw();
				}
				for(var i=0,len=spriteList.length;i<len;i++){//sprite
				
					spriteList[i].update(duration);
					spriteList[i].draw();
				}
				self.lastTime=now;
			}
			timeId=window.setTimeout(arguments.callee,interval);
		}
	}
	
	var gameLoop=function(gameObj,options){
	
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(gameObj,options);
		}
		this.init(gameObj,options);	
	}
	gameLoop.prototype={
		/**
		 *ʼ
		**/
		init:function(gameObj,options){
			/**
			 *Ĭ϶
			**/	
			var defaultObj={
				fps:30
			};
			options=options||{};
			
			options=cg.core.extend(defaultObj,options);
			this.gameObj=gameObj;
			this.fps=options.fps;
			interval=1000/this.fps;
			
			this.pause=false;
			this.stop=true;
		},
			
		/**
		 *ʼѭ
		**/	
		start:function(){
			if(this.stop){		//ǽ״̬Կʼ
				this.stop=false;
				var now=new Date().getTime();
				this.startTime=now;
				this.lastTime=now;
				this.loopDuration=0;	
				loop.call(this)();	
			}	
		},		/**
		 *ѭ
		**/	
		run:function(){
			this.pause=false;	
		},
		/**
		 *ͣѭ
		**/	
		pause:function(){
			this.pause=true;	
		},
		/**
		 *ֹͣѭ
		**/	
		end:function(){
			this.stop=true;
			window.clearTimeout(timeId);
		}
		
		
	}
	this.GameLoop=gameLoop;
});

/**
 *
 *ͼ
 *
**/
cnGame.register("cnGame",function(cg){
							  							  
	var map=function(mapMatrix,options){
		
		if(!(this instanceof arguments.callee)){
			return new arguments.callee(mapMatrix,options);
		}
		this.init(mapMatrix,options);
	}
	map.prototype={
		/**
		 *ʼ
		**/	
		init:function(mapMatrix,options){
			/**
			 *Ĭ϶
			**/	
			var defaultObj={
				cellSize:[32,32],   //
				beginX:0,		    //ͼʼx
				beginY:0			//ͼʼy
		
			};
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.mapMatrix=mapMatrix;
			this.cellSize=options.cellSize;
			this.beginX=options.beginX;
			this.beginY=options.beginY;
			this.row=mapMatrix.length;//ж
				
		},
		/**
		 *mapmap
		**/	
		draw:function(options){//options{"1":{src:"xxx.png",x:0,y:0},"2":{src:"xxx.png",x:1,y:1}}
			var mapMatrix=this.mapMatrix;
			var beginX=this.beginX;
			var beginY=this.beginY;
			var cellSize=this.cellSize;
			var currentRow;
			var currentCol
			var currentObj;
			var row=this.row;
			var img;
			for(var i=beginY,ylen=beginY+row*cellSize[1];i<ylen;i+=cellSize[1]){	//ݵͼ󣬻ÿ
					currentRow=(i-beginY)/cellSize[1];
				for(var j=beginX,xlen=beginX+mapMatrix[currentRow].length*cellSize[0];j<xlen;j+=cellSize[0]){
					currentCol=(j-beginX)/cellSize[0];
					currentObj=options[mapMatrix[currentRow][currentCol]];
					currentObj.x=currentObj.x||0;
					currentObj.y=currentObj.y||0;
					img=cg.loader.loadedImgs[currentObj.src];
					cg.context.drawImage(img,currentObj.x,currentObj.y,cellSize[0],cellSize[1],j,i,cellSize[0],cellSize[1]);//ضͼ
				}
			}
		
		},
		/**
		 *ȡضڵͼдڵķֵ
		**/
		getPosValue:function(x,y){
			if(cg.core.isObject(x)){
				y=x.y;
				x=x.x;
			}
			var isUndefined=cg.core.isUndefined;
			y=Math.floor(y/this.cellSize[1]);
			x=Math.floor(x/this.cellSize[0]);
			if(!isUndefined(this.mapMatrix[y])&&!isUndefined(this.mapMatrix[y][x])){
				return this.mapMatrix[y][x];
			}
			return undefined;
		},
		/**
		 *ȡضڵͼдڵķ
		**/
		getCurrentIndex:function(x,y){
			if(cg.core.isObject(x)){
				y=x.y;
				x=x.x;
			}
			return [Math.floor(x/this.cellSize[0]),Math.floor(y/this.cellSize[1])];
		},
		/**
		 *ȡضǷպغ
		**/
		isMatchCell:function(x,y){
			if(cg.core.isObject(x)){
				y=x.y;
				x=x.x;
			}
			return (x%this.cellSize[0]==0)&&(y%this.cellSize[1]==0);
		},
		/**
		 *õͼӦλõֵ
		**/
		setPosValue:function(x,y,value){
			this.mapMatrix[y][x]=value;	
		}
		
	}
	this.Map=map;
									   
});

/**
 *
 *
 *
**/
cnGame.register("cnGame",function(cg){
	
	/**
	 *ʹָڿview
	**/
	var inside=function(sprite){
		var dir=sprite.insideDir;
		if(dir!="y"){
			if(sprite.x<0){
				sprite.x=0;
			}
			else if(sprite.x>this.width-sprite.width){
				sprite.x=this.width-sprite.width;
			}
		}
		if(dir!="x"){
			if(sprite.y<0){
				sprite.y=0;
			}
			else if(sprite.y>this.height-sprite.height){
				sprite.y=this.height-sprite.height;
			}
		}
			
	}
	
	var view=function(options){
		this.init(options);
		
	}
	view.prototype={
	
		/**
		 *ʼ
		**/
		init:function(options){
			/**
			 *Ĭ϶
			**/
			var defaultObj={
				width:cg.width,
				height:cg.height,
				imgWidth:cg.width,
				imgHeight:cg.height,
				x:0,
				y:0
				
			}
			options=options||{};
			options=cg.core.extend(defaultObj,options);
			this.player=options.player;
			this.width=options.width;
			this.height=options.height;
			this.imgWidth=options.imgWidth;
			this.imgHeight=options.imgHeight;
			this.centerX=this.width/2;
			this.src=options.src;
			this.x=options.x;
			this.y=options.y;
			this.insideArr=[];
			this.isLoop=false;;
			this.isCenterPlayer=false;
			this.onEnd=options.onEnd;
			
		},
		/**
		 *ʹplayerλñڳе֮ǰƶ
		**/
		centerPlayer:function(isLoop){
			isLoop=isLoop||false;
			this.isLoop=isLoop;
			this.isCenterPlayer=true;
		},
		/**
		 *ʹλñڳ
		**/
		insideView:function(sprite,dir){//dirΪ޶ĸviewڣֵΪxy޶
			if(cg.core.isArray(sprite)){
				for(var i=0,len=sprite.length;i<len;i++){
					arguments.callee.call(this,sprite[i],dir);
				}
			}
			else{
				sprite.insideDir=dir;
				this.insideArr.push(sprite);
			}
		},
		/**
		 *ƶʱĸ
		**/
		update:function(spritelist){//sprite
			if(this.isCenterPlayer){
				if(this.player.x>this.centerX){
					if(this.x<this.imgWidth-this.width){
						var marginX=this.player.x-this.centerX;	
						this.x+=marginX;
						if(spritelist){
							for(var i=0,len=spritelist.length;i<len;i++){
								if(spritelist[i]==this.player){
									spritelist[i].x=this.centerX;
								}
								else{
									spritelist[i].x-=marginX;	
								}
							}
						}
					}
					else if(this.isLoop){
						if(spritelist){
							for(var i=0,len=spritelist.length;i<len;i++){
								if(spritelist[i]!=this.player){
									spritelist[i].move(this.imgWidth-this.width);
								}
							}
						}
						this.x=0;
					}
					else{
						this.onEnd&&this.onEnd();
					}
				}
			}
			for(var i=0,len=this.insideArr.length;i<len;i++){
				inside.call(this,this.insideArr[i]);
			}
		},
		/**
		 *Ƴ
		**/
		draw:function(){
			cg.context.drawImage(cg.loader.loadedImgs[this.src],this.x,this.y,this.width,this.height,0,0,this.width,this.height);
		}
		
		
	}
	this.View=view;
});

})(window,undefined);

