﻿# InnerLibs 🦞
 ### Uma biblioteca de classes e métodos para .NET. Opções flexiveis e fáceis de usar para simplificar e manter seu código limpo.
 
O projeto nasceu a partir da nescessidade de repetir os códigos em diversos projetos. No início era uma classe com alguns métodos que precisavam sempre ser modificados em cada projeto. Hoje InnerLibs conta com mais de 120 métodos de extensão para as mais diversas operaçoes comuns.
 
### Veja algumas de nossas funções:

 - Conexão com Bancos de Dados simplificada utilizando `InnerLibs`
 - Classe de representação geográfica/Endereço `InnerLibs.AddressInfo` com integração a API dos Correios;
 - Conversão de números para algarismos romanos e vice versa;
 - Conversão de números para sua forma extensa;
 - Classe para criação e edição de vCards;
 - Calculo de prazo de entrega baseado em jornada de trabalho utilizando `InnerLibs`;
 - Vários manipuladores e validadores de Texto;
 - Identificação de MIME Type a partir da extensão de arquivos;
 - Geradores de expressões lambda para filtros compativel com `EntityFramework` e `LINQ to SQL`;
 - Classes para gerar `DOT Language` a partir de outras classes;
 - Extensões para `System.Console`;
 - Classe com lista e filtros de Cidades e Estados do Brasil;
 - Manipuladores de cor e imagem;
 - Classes e interfaces para adaptação de APIs para `Select2`;
 - Ajuste ortográfico básico;
 - SoundEx em português;
 - Classes para manipulação de impressoras térmicas (ESCPOS) (`InnerLibs.Printer`);
 - Validador de CPF, CNPJ, Telefone etc.;
 - Extensões para LINQ;
 
# License

The MIT License (MIT)

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
