-- MySQL Script generated by MySQL Workbench
-- Mon Jul 25 15:10:08 2022
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema survey_schema
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `survey_schema` ;

-- -----------------------------------------------------
-- Schema survey_schema
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `survey_schema` DEFAULT CHARACTER SET utf8 ;
USE `survey_schema` ;

-- -----------------------------------------------------
-- Table `survey_schema`.`users`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `survey_schema`.`users` ;

CREATE TABLE IF NOT EXISTS `survey_schema`.`users` (
                                                       `id_user` INT NOT NULL AUTO_INCREMENT,
                                                       `email` VARCHAR(45) NOT NULL,
                                                       `password` VARCHAR(40) NOT NULL,
                                                       `registration_date` DATE NOT NULL DEFAULT curdate(),
                                                       `user_role` ENUM('ADMIN', 'USER') NULL DEFAULT NULL,
                                                       `user_status` ENUM('ACTIVE', 'BANNED') NULL DEFAULT NULL,
                                                       PRIMARY KEY (`id_user`))
    ENGINE = InnoDB
    DEFAULT CHARACTER SET = utf8mb3;

CREATE UNIQUE INDEX `email_UNIQUE` ON `survey_schema`.`users` (`email` ASC) VISIBLE;

CREATE INDEX `role_id_fk_idx` ON `survey_schema`.`users` (`user_role` ASC) VISIBLE;

CREATE INDEX `status_id_fk_idx` ON `survey_schema`.`users` (`user_status` ASC) VISIBLE;


INSERT INTO `survey_schema`.`users` (`email`, `password`, `user_role`, `user_status`) VALUES ('admin@admin.com', '7c222fb2927d828af22f592134e8932480637c0d', 'ADMIN', 'ACTIVE');


-- -----------------------------------------------------
-- Table `survey_schema`.`themes`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `survey_schema`.`themes` ;

CREATE TABLE IF NOT EXISTS `survey_schema`.`themes` (
                                                        `id_theme` INT NOT NULL AUTO_INCREMENT,
                                                        `theme_name` VARCHAR(200) NOT NULL,
                                                        `theme_status` ENUM('WAITING', 'CONFIRMED') NOT NULL DEFAULT 'WAITING',
                                                        PRIMARY KEY (`id_theme`))
    ENGINE = InnoDB
    DEFAULT CHARACTER SET = utf8mb3;

CREATE UNIQUE INDEX `theme_name_UNIQUE` ON `survey_schema`.`themes` (`theme_name` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `survey_schema`.`surveys`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `survey_schema`.`surveys` ;

CREATE TABLE IF NOT EXISTS `survey_schema`.`surveys` (
                                                         `id_survey` INT NOT NULL AUTO_INCREMENT,
                                                         `survey_name` TEXT NOT NULL,
                                                         `survey_description` TEXT NULL DEFAULT NULL,
                                                         `survey_status` ENUM('NOT_STARTED', 'STARTED', 'CLOSED') NULL DEFAULT NULL,
                                                         `theme_id` INT NULL DEFAULT NULL,
                                                         `creator_id` INT NULL DEFAULT NULL,
                                                         `start_date_time` DATETIME NULL DEFAULT NULL,
                                                         `close_date_time` DATETIME NULL DEFAULT NULL,
                                                         PRIMARY KEY (`id_survey`),
                                                         CONSTRAINT `creator_id_fk`
                                                             FOREIGN KEY (`creator_id`)
                                                                 REFERENCES `survey_schema`.`users` (`id_user`)
                                                                 ON DELETE CASCADE
                                                                 ON UPDATE CASCADE,
                                                         CONSTRAINT `theme_id_fk`
                                                             FOREIGN KEY (`theme_id`)
                                                                 REFERENCES `survey_schema`.`themes` (`id_theme`)
                                                                 ON DELETE SET NULL
                                                                 ON UPDATE CASCADE)
    ENGINE = InnoDB
    DEFAULT CHARACTER SET = utf8mb3;

CREATE INDEX `creator_id_fk_idx` ON `survey_schema`.`surveys` (`creator_id` ASC) VISIBLE;

CREATE INDEX `theme_id_fk_idx` ON `survey_schema`.`surveys` (`theme_id` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `survey_schema`.`questions`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `survey_schema`.`questions` ;

CREATE TABLE IF NOT EXISTS `survey_schema`.`questions` (
                                                           `id_question` INT NOT NULL AUTO_INCREMENT,
                                                           `formulation` TEXT NOT NULL,
                                                           `select_multiple` TINYINT(1) NOT NULL DEFAULT '0',
                                                           `survey_id` INT NULL DEFAULT NULL,
                                                           PRIMARY KEY (`id_question`),
                                                           CONSTRAINT `question_quiz_id_fk`
                                                               FOREIGN KEY (`survey_id`)
                                                                   REFERENCES `survey_schema`.`surveys` (`id_survey`)
                                                                   ON DELETE CASCADE
                                                                   ON UPDATE CASCADE)
    ENGINE = InnoDB
    DEFAULT CHARACTER SET = utf8mb3;

CREATE INDEX `question_quiz_id_fk_idx` ON `survey_schema`.`questions` (`survey_id` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `survey_schema`.`question_answers`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `survey_schema`.`question_answers` ;

CREATE TABLE IF NOT EXISTS `survey_schema`.`question_answers` (
                                                                  `id_question_answer` INT NOT NULL AUTO_INCREMENT,
                                                                  `answer` TEXT NOT NULL,
                                                                  `selected_count` INT NOT NULL DEFAULT '0',
                                                                  `question_id` INT NULL DEFAULT NULL,
                                                                  PRIMARY KEY (`id_question_answer`),
                                                                  CONSTRAINT `question_id_fk`
                                                                      FOREIGN KEY (`question_id`)
                                                                          REFERENCES `survey_schema`.`questions` (`id_question`)
                                                                          ON DELETE CASCADE
                                                                          ON UPDATE CASCADE)
    ENGINE = InnoDB
    DEFAULT CHARACTER SET = utf8mb3;

CREATE INDEX `question_id_fk_idx` ON `survey_schema`.`question_answers` (`question_id` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `survey_schema`.`survey_user_attempts`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `survey_schema`.`survey_user_attempts` ;

CREATE TABLE IF NOT EXISTS `survey_schema`.`survey_user_attempts` (
                                                                      `id_survey_user_attempt` INT NOT NULL AUTO_INCREMENT,
                                                                      `finished_date_time` DATETIME NOT NULL,
                                                                      `survey_id` INT NULL DEFAULT NULL,
                                                                      `user_id` INT NULL DEFAULT NULL,
                                                                      PRIMARY KEY (`id_survey_user_attempt`),
                                                                      CONSTRAINT `attempt_quiz_id_fk`
                                                                          FOREIGN KEY (`survey_id`)
                                                                              REFERENCES `survey_schema`.`surveys` (`id_survey`)
                                                                              ON DELETE CASCADE
                                                                              ON UPDATE CASCADE,
                                                                      CONSTRAINT `attempt_user_id_fk`
                                                                          FOREIGN KEY (`user_id`)
                                                                              REFERENCES `survey_schema`.`users` (`id_user`)
                                                                              ON DELETE SET NULL
                                                                              ON UPDATE CASCADE)
    ENGINE = InnoDB
    DEFAULT CHARACTER SET = utf8mb3;

CREATE INDEX `attempt_quiz_id_fk_idx` ON `survey_schema`.`survey_user_attempts` (`survey_id` ASC) VISIBLE;

CREATE INDEX `attempt_user_id_fk_idx` ON `survey_schema`.`survey_user_attempts` (`user_id` ASC) VISIBLE;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;