# How to Contribute

First off, thanks for taking the time to contribute!👏

## Fork the Repository 🍴

1. Start by forking the repository. You can do this by clicking the "Fork" button in the upper right corner of the repository page. This will create a copy of the repository in your GitHub account.

## Clone Your Fork 📥

2. Clone your newly created fork of the repository to your local machine with the following command:

   ```bash
   git clone https://github.com/your-username/static_status.git
   ```

## Create a New Branch 🌿

3. Create a new branch for the specific issue or feature you are working on. Use a descriptive branch name:

   ```bash
   git checkout -b "branch_name"
   ```

## Submitting Changes 🚀

4. Make your desired changes to the codebase.

5. Stage your changes using the following command:

   ```bash
   git add .
   ```

6. Commit your changes with a clear and concise commit message:

   ```bash
   git commit -m "A brief summary of the commit."
   ```

## Push Your Changes 🚢

7. Push your local commits to your remote repository:

   ```bash
   git push origin "branch_name"
   ```

## Create a Pull Request 🌟

8. Go to your forked repository on GitHub and click on the "New Pull Request" button. This will open a new pull request to the original repository.

## Coding Style 📝

Start reading the code, and you'll get the hang of it. It is optimized for readability:

- Variables must be uppercase and should begin with MY\_.
- Functions must be lowercase.
- Check your shell scripts with ShellCheck before submitting.
- Please use tabs to indent.

One more thing:

Keep it simple! 👍

Thanks! ❤️❤️❤️
