# AI Landing Page Generator

[![License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

## Description

![A landing page generator](/public/logo.png)

The AI Landing Page Generator is a powerful tool that allows you to quickly create stunning landing pages using artificial intelligence. With this generator, you can save time and effort by automating the process of designing and coding landing pages. It is now experimental and only supports the creation of landing pages with HTML and Tailwind CSS.

## Installation

1. Clone the repository: `git clone https://github.com/zinedkaloc/aipage.dev.git`
2. Install the required dependencies: `pnpm install`
3. Navigate to the project directory `cd aipage.dev`
4. Copy the `.env.example` file to `.env` and fill in the required information.

> Note: If you are not comfortable with creating OPENAI_API_KEY, please reach out to me at [zinedkaloc](https://twitter.com/zinedkaloc) and I will be happy to help you.

## Usage

1. Run the generator: `pnpm dev`
2. Open the browser and go to `http://localhost:3000`
3. Describe your website and click on the "Enter".
4. Wait for the genie to generate the landing page.

### Test prompts

> A landing page for a design studio located in New york. They make websites and custom logos. All the work is very stylish and minimalist. The page should include a contact form a some call to actions as well as a link to the portfolio.

> A landing page for an interior architecture company based in Istanbul. They specialize in creating exceptional spatial designs and innovative interior solutions. Their work showcases a unique blend of style, minimalism, and functionality. The landing page should feature a captivating design with using gradients, including a contact form, compelling call-to-action elements, and a prominent link to their portfolio.

> A landing page for a cutting-edge technology company based in Istanbul. They specialize in developing innovative software solutions and advanced technological products. Their work is known for its sleek design, seamless user experience, and transformative capabilities. The landing page should feature a modern design, including a contact form, compelling call-to-action elements, and a prominent link to their product offerings.

## Roadmap

- [x] Create a basic landing page generator.
- [x] Display the generated landing page in the main page with an iframe.
- [ ] Update text input to textarea and add submit button.
- [ ] Add support to download the generated landing page as a zip file.
- [ ] Add support to deploy the generated landing page to Vercel or Netlify with a single click.
- [ ] Add support for dark mode.
- [ ] Add support for multiple pages.
- [ ] Add support for multiple languages.

This project is still in its early stages of development. If you have any suggestions or ideas, please feel free to open an issue or submit a pull request.

## Contributing

Thank you for considering contributing to this project! To contribute, follow these steps:

1. Fork the repository.
2. Create a new branch for your feature/fix: `git checkout -b feature/your-feature-name`.
3. Add your changes with: `git add .`.
4. Make your changes and commit them: `git commit -m "Add your feature description"`.
5. Push to the branch: `git push origin feature/your-feature-name`.
6. Open a pull request to the `master` branch of the original repository. Provide a clear and descriptive title and description for your pull request. Include any relevant information or context that would help with the review process.
7. Wait for the maintainers to review your pull request. Make any necessary changes or address any feedback provided.
8. Once your pull request is approved, it will be merged into the `master` branch.

Congratulations on your contribution!

## License

This project is licensed under the [MIT License](LICENSE).

## Contact

For any inquiries or feedback, please reach out to us at [zinedkaloc](https://twitter.com/zinedkaloc).
