# 简易版站内搜索
## 基于校内新闻搜索引擎
------------------------------------------------------------------------------------------------------
- 实现思路：将校园网的全部新闻爬取下来，存储到MySQL数据库，然后对数据库中的标题进行分词，然后将分词结果做成索引表。输入一个查询内容，对查询内容进行分词，与数据库中的分词表进行匹配，映射出对应的URL，然后返回结果。

## 开发环境
- Python3.6
- mysql 5.4

## 依赖库
- pymysql：python与MySQL的接口
- jieba  ：分词的python库

----------------------------------------------------
## 整体架构
1. 爬虫部分
   爬虫使用scrapy框架，爬取辽宁工程技术大学的新闻网。
   scrapy框架分主要部分说明：
    - IntuSpider.py文件：网页信息的主要提取过程，使用嵌套循环调用，采用深度优先算法进行递归调用，解析辽工大的所有html新闻页面，提取所需要的信息(标题、url),保存到item对象中，该框架会进一步调用pipeline.py文件对所存对象处理。爬虫所用的解析方式是xpath
    - items.py  定义需要爬取的对象。
    - pipeline.py 将保存的对象通过mysql接口，存储到mysql数据库中，数据库字段内容分别是title和url。
    其他文件都是一些配置文件，并且几乎没有进行改动，改动地点都注释了。爬虫部分到此结束。

2. 搜索引擎部分
    搜索引擎整体思路：将所存储到数据库中的标题进行分词，建立关键词的索引。其次，根据关键词的出现频率，建立关键字和出现次数的索引表。
    主要文件说明：
    - Intu.py: 数据库建表，取爬虫爬取到的数据，进行分词，分别存储到前向表和后向表。
    - forward.py: 前向表，定义类组件`forwardIndexTableItem`,指定表中数组内容，在前向表类`forwardIndexTable`中，进行标题的分词并储存数据库表中。
    - lexicon:分词，定义操作：通过单词获取其ID、通过ID获取单词，建立分词表、载入分词表；
    - backwardList：后向表，处理前向表中的数据，主要功能是通过前向表中的内容，将单词的id和新闻标题的docID，还有其集合存储在数据库中。
    - seachEngine: 搜索引擎类，直接运行此文件，可以通过查询你输入的单词，返回对应的标题和url。其核心也是对所输入的内容进行分词，然后根据关键词，对命中关键词的个数的多少，排序对应的标题，然后打印前10行。

3. 注意点和不足：
   1. 首先，该爬虫是静态的，其数据在爬取完一次后，存储到数据库，不能根据网页的变动实时更新。如果数据库中有重复标题，插入数据会失败。需要清除表在重新爬取。
   2. 数据库内容是固定的，搜索的时候，如果关键字在数据库中没有索引，其将没有搜索结果。
   3. 搜索的命中率跟结巴分词的准确性是相关的，爬虫的效率不是很高，3W条数据爬了将近5个小时。爬取的时候，其网页的布局很清除，我爬取的新闻没有重复的，所有专门的url去重算法，只是为了防止重复数据的出现，用了python的列表进行去重。
   4. 未来可能补一个网页，通过网页站点进行搜索，做一个网页界面出来。
   5. 爬虫跟搜索是独立的，其他的新闻网也是可以爬取的，只需该爬虫部分就行。
--------------------------------------------------------------------------------------------------------------------------
## 使用方法
- 依赖环境准备：python3的环境,scrapy的框架,pymysql安装，jieba分词库的安装,mysql的安装，mysql建立mytable数据库,建立intu数据表。
- 先git clone 到指定目录
- 在windows下开启控制台，进入对应文件夹,输入`scrapy crawl Intu`
- 等待爬取结果，爬取完毕结束。
- 运行seachEngine.py文件，输入你查询的文字内容

----------------------------------------------------------------------------------------------------------------

	



