SET NAMES utf8mb4;
SET
FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for sys_calendar
-- ----------------------------
DROP TABLE IF EXISTS `sys_calendar`;
CREATE TABLE `sys_calendar`
(
    `day_date`     date    NOT NULL COMMENT '日期',
    `type`         tinyint UNSIGNED NOT NULL COMMENT '类型: 0工作日、1周末、2节日、3调休',
    `week`         tinyint NOT NULL COMMENT '星期',
    `wage`         tinyint NOT NULL DEFAULT 1 COMMENT '薪资倍数',
    `holiday_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节假日名称',
    `lunaryear`    varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '农历年',
    `lunarmonth`   varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '农历月',
    `lunarday`     varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '农历日',
    `shengxiao`    varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生肖',
    `ganzhi`       varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '干支',
    `star`         varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '星座',
    PRIMARY KEY (`day_date`) USING BTREE,
    INDEX          `idx_type`(`type`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-万年历' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_calendar
-- ----------------------------
INSERT INTO `sys_calendar`
VALUES ('2010-01-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-01-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-02-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-03-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-04-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-05-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-06-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-07-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-08-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-09-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-10-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-11-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2010-12-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-01-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-02-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-03-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-04-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-05-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-06-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-07-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-08-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-09-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-10-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-11-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2011-12-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-01-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-02-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-03-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-04-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-05-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-06-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-07-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-08-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-09-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-10-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-11-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2012-12-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-01', 2, 2, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-02', 2, 3, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-03', 2, 4, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-05', 3, 6, 1, '元旦后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-06', 3, 7, 1, '元旦后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-01-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-09', 2, 6, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-10', 2, 7, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-11', 2, 1, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-12', 2, 2, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-13', 2, 3, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-14', 2, 4, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-15', 2, 5, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-16', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-17', 3, 7, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-02-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-03-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-04', 2, 4, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-05', 2, 5, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-06', 2, 6, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-07', 3, 7, 1, '清明节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-27', 3, 6, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-28', 3, 7, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-29', 2, 1, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-04-30', 2, 2, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-01', 2, 3, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-05-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-08', 3, 6, 1, '端午节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-09', 3, 7, 1, '端午节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-10', 2, 1, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-11', 2, 2, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-12', 2, 3, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-06-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-07-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-08-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-19', 2, 4, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-20', 2, 5, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-21', 2, 6, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-22', 3, 7, 1, '中秋节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-29', 3, 7, 1, '国庆节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-09-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-01', 2, 2, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-02', 2, 3, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-03', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-04', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-05', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-06', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-07', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-12', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-10-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-11-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2013-12-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-01', 2, 3, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-26', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-01-31', 2, 5, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-01', 2, 6, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-02', 2, 7, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-03', 2, 1, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-04', 2, 2, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-05', 2, 3, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-06', 2, 4, 2, '初七', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-08', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-02-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-03-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-05', 2, 6, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-06', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-07', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-04-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-01', 2, 4, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-02', 2, 5, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-03', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-04', 3, 7, 1, '劳动节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-05-31', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-01', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-02', 2, 1, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-06-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-07-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-08-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-06', 2, 6, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-07', 2, 7, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-08', 2, 1, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-28', 3, 7, 1, '国庆节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-09-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-01', 2, 3, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-02', 2, 4, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-03', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-04', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-05', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-06', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-07', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-11', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-10-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-11-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2014-12-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-01', 2, 4, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-02', 2, 5, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-03', 2, 6, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-04', 3, 7, 1, '元旦后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-01-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-15', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-18', 2, 3, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-19', 2, 4, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-20', 2, 5, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-21', 2, 6, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-22', 2, 7, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-23', 2, 1, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-24', 2, 2, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-02-28', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-03-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-04', 2, 6, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-05', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-06', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-04-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-01', 2, 5, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-02', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-03', 2, 7, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-05-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-20', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-21', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-22', 2, 1, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-06-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-07-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-08-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-03', 2, 4, 3, '抗战胜利日', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-04', 2, 5, 2, '抗战胜利日', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-05', 2, 6, 2, '抗战胜利日', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-06', 3, 7, 1, '抗战胜利日后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-26', 2, 6, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-27', 2, 7, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-09-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-01', 2, 4, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-02', 2, 5, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-03', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-04', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-05', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-06', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-07', 2, 3, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-10', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-10-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-11-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2015-12-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-01', 2, 5, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-02', 2, 6, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-03', 2, 7, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-01-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-06', 3, 6, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-07', 2, 7, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-08', 2, 1, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-09', 2, 2, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-10', 2, 3, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-11', 2, 4, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-12', 2, 5, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-13', 2, 6, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-14', 3, 7, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-02-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-03-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-02', 2, 6, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-03', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-04', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-04-30', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-01', 2, 7, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-02', 2, 1, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-05-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-09', 2, 4, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-10', 2, 5, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-11', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-12', 3, 7, 1, '端午节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-06-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-07-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-08-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-15', 2, 4, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-16', 2, 5, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-17', 2, 6, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-18', 3, 7, 1, '中秋节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-09-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-01', 2, 6, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-02', 2, 7, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-03', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-04', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-05', 2, 3, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-06', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-07', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-08', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-09', 3, 7, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-10-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-11-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2016-12-31', 2, 6, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-01', 2, 7, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-02', 2, 1, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-22', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-27', 2, 5, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-28', 2, 6, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-29', 2, 7, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-30', 2, 1, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-01-31', 2, 2, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-01', 2, 3, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-02', 2, 4, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-04', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-02-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-03-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-01', 3, 6, 1, '清明前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-02', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-03', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-04', 2, 2, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-29', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-04-30', 2, 7, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-01', 2, 1, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-27', 3, 6, 1, '端午节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-28', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-29', 2, 1, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-30', 2, 2, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-05-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-06-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-07-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-08-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-09-30', 3, 6, 1, '中秋和国庆前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-01', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-02', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-03', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-04', 2, 3, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-05', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-06', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-07', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-08', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-10-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-11-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-30', 2, 6, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2017-12-31', 2, 7, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-01', 2, 1, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-01-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-11', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-15', 2, 4, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-16', 2, 5, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-17', 2, 6, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-18', 2, 7, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-19', 2, 1, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-20', 2, 2, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-21', 2, 3, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-24', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-02-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-03-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-05', 2, 4, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-06', 2, 5, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-07', 2, 6, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-08', 3, 7, 1, '清明节补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-28', 3, 6, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-29', 2, 7, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-04-30', 2, 1, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-01', 2, 2, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-05-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-16', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-17', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-18', 2, 1, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-06-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-07-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-08-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-22', 2, 6, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-23', 2, 7, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-24', 2, 1, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-29', 3, 6, 1, '国庆前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-09-30', 3, 7, 1, '国庆前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-01', 2, 1, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-02', 2, 2, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-03', 2, 3, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-04', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-05', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-06', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-07', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-10-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-11-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-29', 3, 6, 1, '元旦前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-30', 2, 7, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2018-12-31', 2, 1, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-01', 2, 2, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-01-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-02', 3, 6, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-03', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-04', 2, 1, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-05', 2, 2, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-06', 2, 3, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-07', 2, 4, 3, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-08', 2, 5, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-09', 2, 6, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-10', 2, 7, 2, '春节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-02-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-03-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-05', 2, 5, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-06', 2, 6, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-07', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-28', 3, 7, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-04-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-01', 2, 3, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-02', 2, 4, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-03', 2, 5, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-04', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-05', 3, 7, 1, '劳动节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-05-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-07', 2, 5, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-08', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-09', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-06-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-07-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-08-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-13', 2, 5, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-14', 2, 6, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-15', 2, 7, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-29', 3, 7, 1, '国庆节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-09-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-01', 2, 2, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-02', 2, 3, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-03', 2, 4, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-04', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-05', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-06', 2, 7, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-07', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-12', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-10-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-11-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2019-12-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-01', 2, 3, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-19', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-24', 2, 5, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-25', 2, 6, 3, '初一', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-26', 2, 7, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-27', 2, 1, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-28', 2, 2, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-29', 2, 3, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-30', 2, 4, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-01-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-01', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-02-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-03-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-04', 2, 6, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-05', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-06', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-26', 3, 7, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-04-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-01', 2, 5, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-02', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-03', 2, 7, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-04', 2, 1, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-05', 2, 2, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-09', 3, 6, 1, '劳动节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-05-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-25', 2, 4, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-26', 2, 5, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-27', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-28', 3, 7, 1, '端午节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-06-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-07-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-08-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-27', 3, 7, 1, '国庆节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-09-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-01', 2, 4, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-02', 2, 5, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-03', 2, 6, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-04', 2, 7, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-05', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-06', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-07', 2, 3, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-08', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-10', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-10-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-11-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2020-12-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-01', 2, 5, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-02', 2, 6, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-03', 2, 7, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-01-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-07', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-11', 2, 4, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-12', 2, 5, 3, '初一', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-13', 2, 6, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-14', 2, 7, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-15', 2, 1, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-16', 2, 2, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-17', 2, 3, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-20', 3, 6, 1, '春节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-02-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-03-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-03', 2, 6, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-04', 2, 7, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-05', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-25', 3, 7, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-04-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-01', 2, 6, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-02', 2, 7, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-03', 2, 1, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-04', 2, 2, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-05', 2, 3, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-08', 3, 6, 1, '劳动节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-05-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-12', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-13', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-14', 2, 1, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-06-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-07-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-01', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-02', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-08-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-18', 3, 6, 1, '中秋节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-19', 2, 7, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-20', 2, 1, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-21', 2, 2, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-26', 3, 7, 1, '国庆节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-09-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-01', 2, 5, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-02', 2, 6, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-03', 2, 7, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-04', 2, 1, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-05', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-06', 2, 3, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-07', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-09', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-10-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-11-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2021-12-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-01', 2, 6, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-02', 2, 7, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-03', 2, 1, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-29', 3, 6, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-30', 3, 7, 1, '春节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-01-31', 2, 1, 2, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-01', 2, 2, 3, '初一', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-02', 2, 3, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-03', 2, 4, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-04', 2, 5, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-05', 2, 6, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-06', 2, 7, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-02-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-03-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-02', 3, 6, 1, '清明节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-03', 2, 7, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-04', 2, 1, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-05', 2, 2, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-24', 3, 7, 1, '劳动节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-04-30', 2, 6, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-01', 2, 7, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-02', 2, 1, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-03', 2, 2, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-04', 2, 3, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-07', 3, 6, 1, '劳动节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-05-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-03', 2, 5, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-04', 2, 6, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-05', 2, 7, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-06-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-07-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-01', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-02', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-03', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-08', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-08-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-10', 2, 6, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-11', 2, 7, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-12', 2, 1, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-09-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-01', 2, 6, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-02', 2, 7, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-03', 2, 1, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-04', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-05', 2, 3, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-06', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-07', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-08', 3, 6, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-09', 3, 7, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-10-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-11-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-12', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-13', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-14', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2022-12-31', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-01', 2, 7, 3, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-02', 2, 1, 2, '元旦', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-03', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-04', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-05', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-06', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-07', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-09', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-10', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-21', 2, 6, 3, '除夕', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-22', 2, 7, 3, '初一', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-23', 2, 1, 3, '初二', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-24', 2, 2, 3, '初三', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-25', 2, 3, 2, '初四', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-26', 2, 4, 2, '初五', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-27', 2, 5, 2, '初六', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-01-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-02-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-03-31', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-03', 2, 1, 3, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-04', 2, 2, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-05', 2, 3, 2, '清明节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-04-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-01', 2, 1, 3, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-02', 2, 2, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-03', 2, 3, 2, '劳动节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-04', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-05', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-06', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-07', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-08', 3, 1, 1, '劳动节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-09', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-10', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-11', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-12', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-13', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-14', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-15', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-16', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-17', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-18', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-19', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-20', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-21', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-22', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-23', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-24', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-25', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-26', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-27', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-28', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-29', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-30', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-05-31', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-01', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-02', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-03', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-04', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-05', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-06', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-07', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-08', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-09', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-10', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-11', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-12', 2, 1, 3, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-13', 2, 2, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-14', 2, 3, 2, '端午节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-15', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-16', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-17', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-18', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-19', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-20', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-21', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-22', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-23', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-24', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-25', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-26', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-27', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-28', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-29', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-06-30', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-01', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-02', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-03', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-04', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-05', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-06', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-07', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-08', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-09', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-10', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-11', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-12', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-13', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-14', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-15', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-16', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-17', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-18', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-19', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-20', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-21', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-22', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-23', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-24', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-25', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-26', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-27', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-28', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-29', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-30', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-07-31', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-01', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-02', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-03', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-04', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-05', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-06', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-07', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-08', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-09', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-10', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-11', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-12', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-13', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-14', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-15', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-16', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-17', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-18', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-19', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-20', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-21', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-22', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-23', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-24', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-25', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-26', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-27', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-28', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-29', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-30', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-08-31', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-18', 3, 1, 1, '中秋节前补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-19', 2, 2, 3, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-20', 2, 3, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-21', 2, 4, 2, '中秋节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-09-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-01', 2, 7, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-02', 2, 1, 3, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-03', 2, 2, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-04', 2, 3, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-05', 2, 4, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-06', 2, 5, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-07', 2, 6, 2, '国庆节', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-08', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-09', 3, 1, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-10', 3, 2, 1, '国庆节后补班', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-11', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-12', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-13', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-14', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-15', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-16', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-17', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-18', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-19', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-20', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-21', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-22', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-23', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-24', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-25', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-26', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-27', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-28', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-29', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-30', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-10-31', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-01', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-02', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-03', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-04', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-05', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-06', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-07', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-08', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-09', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-10', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-11', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-12', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-13', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-14', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-15', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-16', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-17', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-18', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-19', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-20', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-21', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-22', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-23', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-24', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-25', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-26', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-27', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-28', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-29', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-11-30', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-01', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-02', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-03', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-04', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-05', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-06', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-07', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-08', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-09', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-10', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-11', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-12', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-13', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-14', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-15', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-16', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-17', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-18', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-19', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-20', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-21', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-22', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-23', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-24', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-25', 0, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-26', 0, 2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-27', 0, 3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-28', 0, 4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-29', 0, 5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-30', 1, 6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_calendar`
VALUES ('2023-12-31', 1, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

SET
FOREIGN_KEY_CHECKS = 1;
