## 用户权限控制
### 1.功能的控制
控制不同角色的用户，看到不同的菜单/按钮，执行不同的操作。    
比如审核员可以看到订单审核的按钮，其它角色看不到；比如管理员可以看到操作日志的菜单，其它角色看不到。

### 2.数据的控制
控制不同类型/部门/租户/角色的用户，按照业务逻辑，看到不同的数据。    
比如管理员能看到所有的订单信息；A部门的管理员只能看到A部门的订单信息。
   
## 设计思路
总体基于RBAC，为了解决基于角色过于麻烦的问题，增加单用户授权。既支持基于单用户赋予权限，也可以基于角色授予权限。

- 主表：用户、角色、部门、权限
- 关联表：用户与角色关联表、用户/角色与权限关联表

### 疑问
1. 用户/角色与权限关联表为什么还要区分角色和用户?
- 基于角色授权的话，若一些特殊的操作，只希望授权给个别人，按RBAC必须先创建一个角色，将权限赋予角色，最后将角色赋予用户，操作过于麻烦
- 基于用户授权的话，每次新增用户进来，都需要重新授权，也过于麻烦。
- 因此，兼容两者，对于不同的需求情况，选择合适的授权方式。

2. 为什么不将角色和部门关联起来?
- 部门是为了过滤数据，尽量与功能权限区分开来

3. 为什么将menu_permissions字段冗余到了uc_menu_scope表?
- 为了方便查询某个用户的权限，不用再去菜单表级联查询；
- uc_menu_scope中的内容，必须严格和menu表中保持一致，menu表的删除和修改(修改权限)一定要同步到uc_menu_scope中。

4. 为什么role_id用String做自定义编码?
- 在实践中，经常遇到需要在前端或者代码端控制查询某个角色的用户，或者只有某个角色可以操作，用id的话没有辨识度，因此改用String。

5. 超级管理员怎么控制权限?
- 不单独设置超级管理员角色，在用户表中通过type来区分管理员，然后在判断权限的时候，对于管理员，直接将menu表所有权限给用户，不做关联表过滤。

## 参考
1. [大型SaaS系统的数据范围权限设计与实现](https://mp.weixin.qq.com/s/PaL0A1geHTOl5HKsF0t_YQ)
