# 地理区域相关功能
在系统开发中,有许多功能都与地理区域相关,包括所在省市区镇四级信息以及经纬度等信息。

## 行政区域
国内的行政区域数据比较复杂,公开数据会存在不准确和不及时等问题,目前使用[AreaCity-JsSpider-StatsGov](https://github.com/xiangyuecn/AreaCity-JsSpider-StatsGov/)提供的四级区域数据与三级区域边界数据。
注意1. 未找到公开免费的四级乡镇的经纬度数据
注意2. 行政区域会存在变更等情况

## 地理坐标系
原始坐标WGS84--(国测局对于国内(电子)地图，要求必须至少采用GCJ-02做加密)-->GCJ02-->(部分厂商二次加密)-->BD09/Mapbar
高德、百度等厂商会提供接口，将非自己的坐标系转换为自己的。
也有算法可以自主转换，见GpsUtils

| 代码     | 名称      | 描述                       |
|--------|---------|--------------------------|
| WGS84  | 地球坐标系   | Google地图采用,未加密,GPS设备原始取得 |
| GCJ02  | 火星坐标系(国测局坐标) | 谷歌中国地图、腾讯地图、高德地图使用       |
| BD09   | 百度坐标系   | 百度地图使用                   |
| MapBar | 图吧坐标系   | 图吧使用                     |

### ps
1.搜索周边范围mysql实现
ROUND(6378.138*2*ASIN(SQRT(POW(SIN((${lat}*PI()/180-lat*PI()/180)/2),2)+COS(${lat}*PI()/180)*COS(lat*PI()/180)*POW(SIN((${lng}*PI()/180-lng*PI()/180)/2),2)))*1000) as distance
