# 接口规范

基本遵守类似Restful风格定义接口

## 命名约束

数据接口命名遵循/model/entity/action的分层接口。比如

1. /model/entity/list 列表接口 返回列表数据,注意传参limit限制条数
2. /model/entity/page 分页接口 返回分页数据,见下面关于分页的描述
3. /model/entity/info 详情接口 传参实体主键,返回实体数据
4. /model/entity/save 保存接口 传参不带主键实体,返回保存成功后的带有主键的实体数据
5. /model/entity/update 更新接口 传参带主键实体,返回保存成功后的带有主键的实体数据
6. /model/entity/changeState 修改状态接口

## 方法约束

请求方法限制Post和Get,所有数据操作(对数据有改动)接口一律Post,查询接口也尽量Post。  
Post接口以@RequestBody(application/json)为主,尽量避免@RequetParam(form-data和x-www-form-urlencoded)形式的接口传递。

## 安全认证约束

通过Shiro完成接口的用户认证和权限管理。

## 其它约束

1. 约束http方法的使用

虽然http定义了很多方法,实践过程中忽略Restful中的请求方法区分,所有的请求都采用GET和POST,提高沟通效率。其中Post接口，参数一律使用@RequestBody提交。

2. 返回内容符合数据格式

服务端无论发生任何错误,都不允许出现超出上述数据结构的返回内容,包括但不局限于nginx错误消息、无返回内容、html格式的返回消息等

3. 返回内容格式统一

在同一个接口中返回内容的数据格式，在成功状态下保持一致，避免出现不同格式的数据，便于前端处理

4. 禁止将详细的代码级别错误消息返回

出于系统安全考虑,在生产环境中,禁止将详细的代码错误比如Exception的消息和trace返回。 为了便于定位问题,应该讲错误消息记录在错误日志表或日志文件中。

5. 禁止使用PathVariable

由于Spring的[PathVariable寻址性能问题](https://tech.imdada.cn/2015/12/23/springmvc-restful-optimize/),性能会随着接口数量变大而下降。 虽然有解决办法,但都会带来额外的接口调用修改,因此禁止使用PathVariable。 因此而带来的url地址不符合restful规范,只能是做妥协。

6. 不允许使用http method来区分接口

不允许出现同路径不同method来区分接口,比如相同的路径`uc/user`,用post方法表示新增,delete方法表示删除,put方法表示修改。 所有不同的接口都必须在路径上作出区分,便于沟通和定位问题。

## 附

### 附1：数据结构

所有接口返回的数据无论成功还是失败,都遵守如下结构,对应代码中的pojo.Result类。

```text
{
  success: true,
  code: 0,
  msg: "success",
  time: 1575537043055,
  data: {}
}
```

| 参数 | 释义    | 举例                                            |
| :--- |:------|:----------------------------------------------|
| success | 结果    | 请求是否成功                                        |
| code | 状态码   | 0成功,其他值表示失败,比如500服务器内部错误,401token失效 |
| msg | 消息    | 正确或者错误消息                                      |
| time | 时间戳   | 服务器返回接口时的Unix时间戳                             |
| data | 响应消息体 | 实际的返回消息,可能是实体、列表、分页实体                         |

### 附2：分页参数

| 参数 | 释义 | 举例 |
| :--- | :--- | :--- |
| page | 当前页码 | 默认1,从1开始数 |
| limit | 每页记录数 | 默认10,实践过程需约定最大值,避免出现性能和数据泄露问题 |

### 附3：分页数据结构

| 参数 | 释义 | 举例 |
| :--- | :--- | :--- |
| page | 当前页码 | 同传参 |
| limit | 每页记录数 | 同传参 |
| lastPage | 是否最后页 | true是最后一页,false不是最后一页,用于前端判断是否还需要继续翻页,当然前端也可以通过total和page来计算 |
| total | 总记录数 | 100 |
| list | 列表数据 |  |

### 附4：错误码定义

| 参数  | 释义   |
|:----|:-----|
| 401 | 授权失败 |
| 403 | 访问受限 |
