package com.nb6868.onex.common.exception;

/**
 * 错误编码
 * 1000以下为内置错误,参考HTTP状态码
 *
 * 1000以上，由5位数字组成，前2位为模块编码，后3位为业务编码
 *
 * @author Charles zhangchaoxu@gmail.com
 */
public interface ErrorCode {

    int SUCCESS = 0;

    int INTERNAL_SERVER_ERROR = 500;
    int ERROR_REQUEST = 400;
    int UNAUTHORIZED = 401;
    int FORBIDDEN = 403;
    int NOT_FOUND = 404;
    int METHOD_NOT_ALLOWED = 405;

    int ACCESS_TOKEN_FORBID = 10401;

    int COMMON_ERROR = 10000;
    int NOT_NULL = 10001;
    int DB_RECORD_EXISTS = 10002;
    int PARAMS_GET_ERROR = 10003;
    int ACCOUNT_PASSWORD_ERROR = 10004;
    int ACCOUNT_DISABLE = 10005;
    int IDENTIFIER_NOT_NULL = 10006;
    int TENANT_EMPTY = 10080;
    int DEPT_EMPTY = 10081;
    int AREA_EMPTY = 10082;
    int TENANT_NOT_MATCH = 10083;
    int CAPTCHA_ERROR = 10007;
    int SUB_MENU_EXIST = 10008;
    int PASSWORD_ERROR = 10009;
    int ACCOUNT_NOT_EXIST = 10010;
    int UPLOAD_FILE_EMPTY = 10019;
    int TOKEN_NOT_EMPTY = 10020;
    int TOKEN_INVALID = 10021;
    int ACCOUNT_LOCK = 10022;
    int ACT_DEPLOY_FORMAT_ERROR = 10023;
    int OSS_UPLOAD_FILE_ERROR = 10024;
    int SEND_SMS_ERROR = 10025;
    int REDIS_ERROR = 10027;
    int JOB_ERROR = 10028;
    int INVALID_SYMBOL = 10029;
    int JSON_FORMAT_ERROR = 10030;
    int SMS_CONFIG_ERROR = 10031;
    int UNKNOWN_LOGIN_TYPE = 10032;
    int DB_RECORD_NOT_EXISTED = 10033;
    int SEND_PUSH_ERROR = 10034;
    int HAS_SUB_RECORD = 10035;
    int HAS_DUPLICATED_RECORD = 10036;
    int OSS_CONFIG_ERROR = 10037;
    int PUSH_CONFIG_ERROR = 10038;
    int MAIL_CONFIG_ERROR = 10039;
    int DB_VIOLATION_ERROR = 10040;
    int FILE_EXCEED_MAX_FILE_SIZE = 10041;
    int AES_ENCRYPT_ERROR = 10044;
    int SMS_TPL_NOT_EXISTED = 10045;
    int ID_NOT_NULL_IN_SAVE = 10046;
    int ID_NULL_IN_UPDATE = 10047;
    int PARENT_NOT_EXISTED = 10048;
    int PARENT_EQ_SELF = 10049;
    int RECORD_NOT_EXISTED = 10050;
    int GUEST_FORBIDDEN = 10052;
    int PARAM_CFG_ERROR = 10053;
    int EXCEL_EXPORT_ERROR = 10054;
    int EXCEL_IMPORT_ERROR = 10055;
    int OAUTH_NOT_BIND_ERROR = 10056;
    int IP_BLACK = 10060;
    int JOB_NO_RUN = 10070;

}
