export var ZenCustomizableUI = new (class {
  constructor() {}

  TYPE_TOOLBAR = 'toolbar';
  defaultSidebarIcons = ['zen-sidepanel-button', 'zen-workspaces-button', 'downloads-button'];

  startup(CustomizableUIInternal) {
    CustomizableUIInternal.registerArea(
      'zen-sidebar-top-buttons',
      {
        type: this.TYPE_TOOLBAR,
        defaultPlacements: ['preferences-button', 'zen-expand-sidebar-button', 'zen-profile-button'],
        defaultCollapsed: null,
      },
      true
    );
    CustomizableUIInternal.registerArea(
      'zen-sidebar-icons-wrapper',
      {
        type: this.TYPE_TOOLBAR,
        defaultPlacements: this.defaultSidebarIcons,
        defaultCollapsed: null,
      },
      true
    );
  }

  // We do not have access to the window object here
  init(window) {
    this._addSidebarButtons(window);
    this._hideToolbarButtons(window);
  }

  _addSidebarButtons(window) {
    const sidebarBox = window.MozXULElement.parseXULToFragment(`
      <toolbar id="zen-sidebar-top-buttons"
        fullscreentoolbar="true" 
        class="browser-toolbar customization-target zen-dont-hide-on-fullscreen"
        brighttext="true"
        data-l10n-id="tabs-toolbar"
        customizable="true"
        context="toolbar-context-menu"
        flex="1"
        skipintoolbarset="true"
        customizationtarget="zen-sidebar-top-buttons-customization-target"
        mode="icons">
        <hbox id="zen-sidebar-top-buttons-customization-target" class="customization-target" flex="1">
          <toolbarbutton removable="true" class="chromeclass-toolbar-additional toolbarbutton-1 zen-sidebar-action-button" id="zen-expand-sidebar-button" data-l10n-id="sidebar-zen-expand" cui-areatype="toolbar" oncommand="gZenVerticalTabsManager.toggleExpand();"></toolbarbutton>
          <toolbarbutton id="zen-profile-button" 
            class="zen-sidebar-action-button toolbarbutton-1 chromeclass-toolbar-additional"
            delegatesanchor="true"
            onmousedown="ZenProfileDialogUI.showSubView(this, event)"
            onkeypress="ZenProfileDialogUI.showSubView(this, event)"
            consumeanchor="zen-profile-button"
            closemenu="none"
            data-l10n-id="toolbar-button-account"
            cui-areatype="toolbar"
            badged="true"
            removable="true">
            <vbox>
              <image id="zen-profile-button-icon" />
            </vbox>
          </toolbarbutton>
        </hbox>
      </toolbar>
    `);
    window.document.getElementById('navigator-toolbox').prepend(sidebarBox);

    const newTab = window.document.getElementById('vertical-tabs-newtab-button');
    newTab.classList.add('zen-sidebar-action-button');

    const wrapper = window.document.createXULElement('toolbarbutton');
    wrapper.id = 'zen-workspaces-button';
    window.document.getElementById('zen-sidebar-icons-wrapper').prepend(wrapper);

    for (let id of this.defaultSidebarIcons) {
      const elem = window.document.getElementById(id);
      if (!elem) continue;
      elem.setAttribute('removable', 'true');
    }

    this._moveWindowButtons(window);
  }

  _moveWindowButtons(window) {
    const windowControls = window.document.getElementsByClassName('titlebar-buttonbox-container');
    const toolboxIcons = window.document.getElementById('zen-sidebar-top-buttons-customization-target');
    if (window.AppConstants.platform === 'macosx') {
      for (let i = 0; i < windowControls.length; i++) {
        if (i === 0) {
          toolboxIcons.prepend(windowControls[i]);
          continue;
        }
        windowControls[i].remove();
      }
    }
  }

  _hideToolbarButtons(window) {
    const elementsToHide = ['alltabs-button'];
    for (let id of elementsToHide) {
      const elem = window.document.getElementById(id);
      if (elem) {
        elem.setAttribute('hidden', 'true');
      }
    }
  }

  registerToolbarNodes(window) {
    window.CustomizableUI.registerToolbarNode(window.document.getElementById('zen-sidebar-top-buttons'));
    window.CustomizableUI.registerToolbarNode(window.document.getElementById('zen-sidebar-icons-wrapper'));
  }
})();
