<?php
/*
 * @Author: 云业科技
 * @Date: 2023-01-05 00:12:05
 * @LastEditTime: 2023-01-05 17:58:38
 * @LastEditors: 云业科技
 * @Description: 
 * @FilePath: \v221.yunyecms.yunyehui.cn\core\lib\application.class.php
 * 
 */
define('IN_YUNYECMS', true);
class application
{
	/**
	 * 构造函数
	 */
	public function __construct()
	{
		$param = core::load_class('param');
		define('ROUTE_G', $param->route_g());
		define('ROUTE_M', $param->route_m());
		define('ROUTE_C', $param->route_c());
		define('ROUTE_A', $param->route_a());
		$this->init();
	}
	/**
	 * 调用件事
	 */
	private function init()
	{
		$controller = $this->load_controller();
		if (method_exists($controller, ROUTE_A)) {
			if (preg_match('/^[_]/i', ROUTE_A)) {
				exit('You are visiting the action is to protect the private action');
			} else {
				call_user_func(array($controller, ROUTE_A));
			}
		} else {
			exit('Action does not exist.');
		}
	}
	/**
	 * 加载控制器
	 * @param string $filename
	 * @param string $m
	 * @return obj
	 */
	private function load_controller($filename = '', $m = '', $g = '')
	{
		if (empty($filename)) $filename = ROUTE_C;
		if (empty($m)) $m = ROUTE_M;
		if (empty($g)) $g = ROUTE_G;
		$CPATH = ROUTE_G == "addons" ? YUNYECMS_ADDONS : YUNYECMS_CORE . $g . DIRECTORY_SEPARATOR;
		$filepath = $CPATH . $m . DIRECTORY_SEPARATOR . $filename . '.php';
		if (file_exists($filepath)) {
			$classname = $filename;
			include $filepath;
			if (class_exists($classname)) {
				return new $classname;
			} else {
				APP_DEBUG ? exit('Controller file ' . $filepath . ' does not exist.') : redirect(ROOT . '404.html');
			}
		} else {
			APP_DEBUG ? exit('Controller file ' . $filepath . ' does not exist.') : redirect(ROOT . '404.html');
		}
	}
}
