<?php
/**
 * 微信支付接口类库   
 */
defined('IN_YUNYECMS') or exit('No permission.');
core::load_class('base',false);
core::load_fun('content');
core::load_fun('tree');
core::load_fun('shop');
class wxpay_native extends base {
	    public $db;
	    public $orderdata;
       //在类初始化方法中，引入相关类库    
		function __construct() {
		 $this->db = core::load_model('content_model');
		 parent::__construct();
		 islogin(); 
			require_once YUNYECMS_EXTEND.'wxpay'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'WxPay.Api.php'; 
			require_once YUNYECMS_EXTEND.'wxpay'.DIRECTORY_SEPARATOR.'WxPay.NativePay.php'; 
			require_once YUNYECMS_EXTEND.'wxpay'.DIRECTORY_SEPARATOR.'log.php'; 
		 }
	
        public function nativepay($orderdata){	
			$logHandler= new CLogFileHandler("./logs/".date('Y-m-d').'.log');
			$log = Log::Init($logHandler, 15);
			
			$notify = new NativePay();
			$url1 = $notify->GetPrePayUrl("123456789");
			//模式二
			/**
			 * 流程：
			 * 1、调用统一下单，取得code_url，生成二维码
			 * 2、用户扫描二维码，进行支付
			 * 3、支付完成之后，微信服务器会通知支付成功
			 * 4、在支付成功通知中需要查单确认是否真正支付成功（见：notify.php）
			 */
			$input = new WxPayUnifiedOrder();
			$input->SetBody($orderdata['body']);
			$input->SetAttach($orderdata['attach']);
			$input->SetOut_trade_no($orderdata['out_trade_no']);
			$input->SetTotal_fee($orderdata['total_fee']);
			$input->SetTime_start(date("YmdHis"));
			$input->SetTime_expire(date("YmdHis", time() + 600));
			$input->SetGoods_tag("test");
			$input->SetNotify_url("http:// www.dazhiku8.com/core/extend/wxpay/notify.php");
			$input->SetTrade_type("NATIVE");
			$input->SetProduct_id("123456789");
			$result = $notify->GetPayUrl($input);
			$url2 = $result["code_url"];
			return $url2;
       }
	//打印输出数组信息
	function printf_info($data)
	{
		foreach($data as $key=>$value){
			echo "<font color='#00ff55;'>$key</font> :  ".htmlspecialchars($value, ENT_QUOTES)." <br/>";
		}
	}

	
	
   
}
?>