<?php
defined('IN_YUNYECMSAdmin') or exit('No permission.');
core::load_admin_class('admin');
class membergroup_orders extends YUNYE_admin
{
	function __construct()
	{
		parent::__construct();
		$this->db = core::load_model('membergroup_orders_model');
	}
	//加载首页
	public function init()
	{
		if (!getroot('shop', 'ordersview')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', "lang") . '\" target=\"maincontent\">系统</a></li><li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'membergroup') . '\" target=\"maincontent\">会员组</a></li><li class=\"breadcrumb-item active\">会员升级订单</li>';
		if (!getroot('users', 'logs')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		$pagesize = 20;
		$sqlquery = "select * from `#yunyecms_membergroup_orders`  ";
		$where = " where sn<>'' ";
		$sqlcnt = " select count(*) from `#yunyecms_membergroup_orders` ";
		$order = " order by `addtime` desc,`updatetime` desc,`id` desc ";
		if (isset($_REQUEST)) {
			if (!empty($_REQUEST["searchkey"])) {
				$searchkey = usafestr(trim($_REQUEST["searchkey"]));
				$where = $where . " and ( `sn`  like '%{$searchkey}%' or  `title`  like '%{$searchkey}%' )";
			}
		}
		$pagearr = $this->db->pagelist($sqlcnt, $sqlquery, $where, $order, $pagesize);
		if ($pagearr["count"] != 0) {
			$list = $pagearr["query"];
			foreach ($list as $key => $var) {
				$list[$key]["member"] = $this->db->getbyid($var["userid"], "member");
			}
			$page = $pagearr["page"];
		}
		require tpl_adm('membergroup_orders_list');
	}

	public function add()
	{
		if (!empty($_GET["id"])) {
			$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'membergroup') . '\" target=\"maincontent\">会员组</a></li><li class=\"breadcrumb-item active\">修改订单</li>';
			$id = trim($_GET["id"]);
			if (!is_numeric($id)) {
				messagebox("订单参数错误", url_admin('init'));
			}
			$id = usafestr($id);
			$row = $this->db->find("select * from `#yunyecms_membergroup_orders` where `id`= {$id}");
			if (empty($row)) {
				messagebox("该订单不存在", $_SERVER['HTTP_REFERER']);
			}
			$yyact = "edit";
		}
		if (isset($_POST["yyact"])) {
			$_POST = ustripslashes($_POST);
			$data["title"] = usafestr($_POST["title"]);
			$data["mobile"] = usafestr($_POST["mobile"]);
			$data["name"] = usafestr($_POST["name"]);
			$data["address"] = usafestr($_POST["address"]);
			$data["money"] = usafestr($_POST["money"]);
			$data["remark"] = usafestr($_POST["remark"]);
			$data["updatetime"] = time();
			$data["status"] = usafestr($_POST["status"]);
			if (empty($data["title"])) {
				messagebox("订单标题不能为空，谢谢!", $_SERVER['HTTP_REFERER']);
			}
			if ($_POST["yyact"] == "edit") {
				if (!getroot('shop', 'ordersedit')) {
					messagebox(Lan('no_permission'), 'back', "warn");
				}
				$id = usafestr($_POST["id"]);
				if (!$this->check_exist($id)) {
					messagebox("该订单不存在！", url_admin('init'), "warn");
				}
				$retres = $this->db->update($data, "id={$id}", "membergroup_orders");
				if ($retres) {
					$doing = "修改会员升级订单—" . $data["title"];
					$yyact = "Update_membergroup_orders";
					insert_admlogs($doing, $yyact);
					messagebox("会员升级订单信息更新成功！", url_admin('init'), "success");
				} else {
					messagebox("会员升级订单信息更新失败！", url_admin('init'), "error");
				}
			}
		}
		require tpl_adm('membergroup_orders_edit');
	}

	public function finaldelete()
	{
		if (!getroot('shop', 'ordersdel')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		$id = $_REQUEST["id"];
		if (!is_array($id)) {
			$id = compact('id');
		}
		$idarray = $id;
		if (isset($idarray)) {
			foreach ($idarray as $key => $var) {
				if (!is_numeric($var)) {
					messagebox("错误的参数！", 'back', "warn");
				}
				$idarray[$key] = usafestr($var);
			}
			$idarray = implode(",", $idarray);
			$retres = $this->db->delete("id in ({$idarray})", "membergroup_orders");
			if ($retres !== false) {
				messagebox(Lan('admin_delete_success'), url_admin('init', 'membergroup_orders'), "success");
			} else {
				messagebox(Lan('admin_delete_error'), url_admin('init', 'membergroup_orders'), "warn");
			}
		} else {
			messagebox(Lan('admin_delall_lessone'), url_admin('init', 'membergroup_orders'), "warn");
		}
	}

	function export_excel()
	{
		if (!getroot('shop', 'ordersview')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		$strsql = "select sn,money,title,timelimit_name,userid,name,address,mobile,addtime,status from `#yunyecms_membergroup_orders` order by addtime desc";
		$xlsData = $this->db->select($strsql);
		$xlsName  = "会员升级订单";
		foreach ($xlsData as $k => $var) {
			$status = $var['status'];
			$strstus = "";
			switch ($status) {
				case 0:
					$strstus = "未付款";
					break;
				case 1:
					$strstus = "已付款";
					break;
				case 2:
					$strstus = "已完成";
					break;
				default:
					$strstus = "未付款";
			}
			$xlsData[$k]['addtime'] = date("Y-m-d h:i:s", $xlsData[$k]['addtime']);
			$xlsData[$k]['status'] = $strstus;
		}
		$xlsCell  = array(
			array('sn', '订单号'),
			array('money', '价格'),
			array('title', '产品'),
			array('timelimit_name', '期限'),
			array('name', '收货人姓名'),
			array('mobile', '电话'),
			array('address', '收货地址'),
			array('status', '订单状态'),
			array('addtime', '时间'),
		);
		exportExcel($xlsName, $xlsCell, $xlsData);
	}


	public function check()
	{
		if (!getroot('shop', 'ordersedit')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		parent::infocheck("membergroup_orders", $this->db);
	}

	public function nocheck()
	{
		if (!getroot('shop', 'ordersedit')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		parent::infonocheck("membergroup_orders", $this->db);
	}


	private function check_exist($id)
	{
		$id = trim($id);
		if (empty($id)) {
			return false;
		} else {
			if (!is_numeric($id)) {
				return false;
			}
			if ($this->db->find("select count(*) as cnt from `#yunyecms_membergroup_orders` where `id`= {$id}")) {
				return true;
			}
		}
	}
}
