<?php
defined('IN_YUNYECMSAdmin') or exit('No permission.');
core::load_admin_class('admin');
class membergroup_goods extends YUNYE_admin
{
	function __construct()
	{
		parent::__construct();
		$this->db = core::load_model('membergroup_goods_model');
		if (!getroot('member', 'view')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
	}
	//加载首页
	public function init()
	{
		$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', "membergroup_goods") . '\" target=\"maincontent\">系统</a></li><li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'membergroup_goods') . '\" target=\"maincontent\">会员升级产品管理</a></li><li class=\"breadcrumb-item active\">会员升级产品列表</li>';
		if (!getroot('users', 'logs')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		$pagesize = 20;
		$sqlquery = "select * from `#yunyecms_membergroup_goods`  ";
		$where = " where 1=1 and goods_title<>'' ";
		$sqlcnt = " select count(*) from `#yunyecms_membergroup_goods` ";
		$order = " order by `addtime` desc ";
		if (isset($_REQUEST)) {
			if (!empty($_REQUEST["searchkey"])) {
				$searchkey = usafestr(trim($_REQUEST["searchkey"]));
				$where = $where . " and ( `goods_title`  like '%{$searchkey}%' )";
			}
		}
		$pagearr = $this->db->pagelist($sqlcnt, $sqlquery, $where, $order, $pagesize);
		if ($pagearr["count"] != 0) {
			$list = $pagearr["query"];
			foreach ($list as $key => $var) {
				$list[$key]["membergroupname"] = GetMemberGroupName($var["groupid"]);
				if (!empty($list[$key]["time_limit"])) {
					$list[$key]["time_limit"] = unserialize($list[$key]["time_limit"]);
				}
			}
			$page = $pagearr["page"];
		}
		require tpl_adm('membergroup_goods_list');
	}


	public function add()
	{
		$timelimit = getmember_timelimit();
		$membergroup = $this->db->select("select * from `#yunyecms_membergroup` order by ordernum asc");
		if (!empty($_GET["id"])) {
			$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'membergroup_goods') . '\" target=\"maincontent\">会员升级产品管理</a></li><li class=\"breadcrumb-item active\">修改会员升级产品</li>';
			$id = trim($_GET["id"]);
			if (!is_numeric($id)) {
				messagebox("会员升级产品参数错误", url_admin('init'));
			}
			$rsinfo = $this->db->find("select * from `#yunyecms_membergroup_goods` where `goods_id`= {$id}");
			if (empty($rsinfo)) {
				messagebox("会员升级产品不存在", $_SERVER['HTTP_REFERER']);
			} else {
				if (!empty($rsinfo["time_limit"])) {
					$rsinfo["time_limit"] = unserialize($rsinfo["time_limit"]);
				}
			}
			$yyact = "edit";
		} else {
			$yyact = yyact_get("add");
			$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'member') . '\" target=\"maincontent\">用户</a></li><li><a href=\"' . url_admin('init', 'membergroup_goods') . '\" target=\"maincontent\">会员升级产品管理</a></li><li class=\"breadcrumb-item active\">增加会员升级产品</li>';
			$sqlordermax = "select max(ordernum) as maxordernum from `#yunyecms_membergroup_goods`";
			$ordermaxquery = $this->db->find($sqlordermax);
			$ordermax = $ordermaxquery["maxordernum"] + 1;
		}
		if (isset($_POST["yyact"])) {
			$_POST = ustripslashes($_POST);
			$data["goods_title"] = usafestr(trim($_POST["goods_title"]));
			$data["goods_title_en"] = usafestr(trim($_POST["goods_title_en"]));
			$data["pic"] = uhtmlspecialchars(trim($_POST["pic"]));
			$data["ordernum"] = usafestr(trim($_POST["ordernum"]));
			$data["price"] = usafestr(trim($_POST["price"]));
			$data["groupid"] = usafestr(trim($_POST["groupid"]));
			$time_limit = $_POST["time_limit"];
			if (!empty($time_limit) && is_array($time_limit)) {
				foreach ($time_limit as $key => $var) {
					$time_limit[$key]['id'] = usafestr(trim($var["id"]));
					$time_limit[$key]['name'] = usafestr(trim($var["name"]));
					$time_limit[$key]['price'] = usafestr(trim($var["price"]));
					$time_limit[$key]['ordernum'] = usafestr(trim($var["ordernum"]));
				}
			}
			$time_limit = serialize($time_limit);
			$data["time_limit"] = $time_limit;
			$data["addtime"] = time();
			$data["updatetime"] = time();
			$data["status"] = 1;
			if (isset($_POST["content"])) {
				$data["content"] = uhtmlspecialchars(trim($_POST["content"]));
			}
			if (isset($_POST["content_en"])) {
				$data["content_en"] = uhtmlspecialchars(trim($_POST["content_en"]));
			}
			if (empty($data["goods_title"])) {
				messagebox("会员升级产品标题不能为空，谢谢!", $_SERVER['HTTP_REFERER']);
			}

			if ($_POST["yyact"] == "add") {
				$retres = $this->db->insert($data);
				if ($retres) {
					$doing = "添加会员升级产品—" . $data["title"];
					$yyact = "Add_Membergroup_goods";
					insert_admlogs($doing, $yyact);
					messagebox("添加会员升级产品成功！", url_admin('init'), "success");
				} else {
					messagebox("添加会员升级产品失败！", url_admin('init'), "error");
				}
			}
			if ($_POST["yyact"] == "edit") {
				$id = $_POST["id"];
				if (!$this->check_exist($id)) {
					messagebox("该消息不存在！", url_admin('init'), "warn");
				}
				$retres = $this->db->update($data, "goods_id={$id}", "membergroup_goods");
				if ($retres) {
					$doing = "更新会员升级产品—" . $data["title"];
					$yyact = "Update_Membergroup_goods";
					insert_admlogs($doing, $yyact);
					messagebox("会员升级产品更新成功！", url_admin('init'), "success");
				} else {
					messagebox("会员升级产品更新失败！", url_admin('init'), "error");
				}
			}
		}
		require tpl_adm('membergroup_goods_add');
	}

	public function finaldelete()
	{
		if (!getroot('info', 'del')) {
			messagebox(Lan('no_permission'), 'back');
		}
		$id = $_REQUEST["id"];
		if (!is_array($id)) {
			$id = compact('id');
		}
		$idarray = $id;
		foreach ($idarray as $key => $var) {
			if (!is_numeric($var)) {
				messagebox("错误的参数！", 'back', "warn");
			}
			$var = usafestr($var);
			$idarray[$key] = $var;
			$curmodelnr = $this->db->find("select goods_id,pic,content from `#yunyecms_membergroup_goods` where `goods_id`= {$var}");
			if ($curmodelnr) {
				$thumb = $curmodelnr["pic"];
				$ct_content = $curmodelnr["content"];
				$ct_content_img = getcontentimg($ct_content);
				if (!empty($thumb)) {
					file_delete($thumb);
				}
				foreach ($ct_content_img as $key3 => $var3) {
					file_delete($var3);
				}
			}
		}
		if (isset($idarray)) {
			$idarray = implode(",", $idarray);
			$retres = $this->db->delete("goods_id in ({$idarray})", "membergroup_goods");
			if ($retres !== false) {
				$yyact = "Membergroup_goods_Del";
				$logcontent['tablename'] = "membergroup_goods";
				$logcontent['action'] = $yyact;
				$logcontent['ids'] = serialize($id);
				$logcontent = serialize($logcontent);
				$doing = "删除会员升级产品：{$idarray} ";
				insert_admlogs($doing, $yyact, $logcontent);
				messagebox(Lan('admin_delete_success'), $_SERVER['HTTP_REFERER'], "success");
			} else {
				messagebox(Lan('admin_delete_error'), $_SERVER['HTTP_REFERER'], "warn");
			}
		} else {
			messagebox(Lan('admin_delete_error'), $_SERVER['HTTP_REFERER'], "warn");
		}
	}

	public function check()
	{
		parent::infocheck("membergroup_goods", $this->db);
	}

	public function nocheck()
	{
		parent::infonocheck("membergroup_goods", $this->db);
	}

	private function check_exist($id)
	{
		$id = trim($id);
		if (empty($id)) {
			return false;
		} else {
			if (!is_numeric($id)) {
				return false;
			}
			if ($this->db->find("select count(*) as cnt from `#yunyecms_membergroup_goods` where `goods_id`= {$id}")) {
				return true;
			}
		}
	}
}
