<?php
defined('IN_YUNYECMSAdmin') or exit('No permission.');
core::load_admin_class('admin');
class homeset extends YUNYE_admin
{
	private $lang;  //默认语言
	function __construct()
	{
		parent::__construct();
		$this->db = core::load_model('homeset_model');
		$this->lang = getlangid();
		if (!getroot('homeset', 'view')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
	}
	//加载首页
	public function init()
	{
		$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', "homeset") . '\" target=\"maincontent\">系统</a></li><li  class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'homeset') . '\" target=\"maincontent\">首页模块管理</a></li><li class=\"breadcrumb-item active\">首页模块列表</li>';
		if (!getroot('homeset', 'view')) {
			messagebox(Lan('no_permission'), 'back', "warn");
		}
		$pagesize = 20;
		$sqlquery = "select * from `#yunyecms_homeset`  ";
		$where = " where  title<>'' and lang={$this->lang}  ";
		$sqlcnt = " select count(*) from `#yunyecms_homeset` ";
		$order = " order by `ordernum` asc ";
		if (isset($_REQUEST)) {
			if (!empty($_REQUEST["searchkey"])) {
				$searchkey = usafestr(trim($_REQUEST["searchkey"]));
				$where = $where . " and ( `title`  like '%{$searchkey}%' )";
			}
		}
		$pagearr = $this->db->pagelist($sqlcnt, $sqlquery, $where, $order, $pagesize);
		if ($pagearr["count"] != 0) {
			$list = $pagearr["query"];
			foreach ($list as $key => $var) {
				if ($var['catid']) {
					$list[$key]['catname'] = $this->db->getfield('title', $var['catid'], 'category');
				}
				$list[$key]['pic'] = dopic($var['pic']);
				if ($var['modelid']) {
					$list[$key]['model'] = getmodel($var['modelid']);
				}
			}
			$page = $pagearr["page"];
		}
		require tpl_adm('homeset_list');
	}


	public function add()
	{
		$lang_list = getalllang();
		foreach ($lang_list as $kk => $vv) {
			$lang_list[$kk]['lang_icon'] = dopic($vv['lang_icon']);
		}
		$langid = intval($this->lang);
		$nums = count($lang_list);
		$tablename = 'homeset';
		$modearr = get_dismode();
		$stylearr = get_homestyle();
		if (!empty($_GET["id"])) {
			$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'homeset') . '\" target=\"maincontent\">首页模块管理</a></li><li class=\"breadcrumb-item active\">修改首页模块</li>';
			$id = trim($_GET["id"]);
			if (!is_numeric($id)) {
				messagebox("首页模块参数错误", url_admin('init'));
			}
			$rsinfo = $this->db->find("select * from `#yunyecms_{$tablename}` where `id`= {$id}");
			if (empty($rsinfo)) {
				messagebox("该信息不存在，谢谢!", $_SERVER['HTTP_REFERER']);
			} else {
				$syn = $rsinfo['syn'];
			}
			if ($rsinfo['pic']) $rsinfo['pic'] = dopic($rsinfo['pic']);
			foreach ($lang_list as $kk => $vv) {
				$lid = $vv['id'];
				$ldef = $vv['isdefault'];
				if ($syn) {
					$rs_shadow[$lid] = $this->db->find("select * from `#yunyecms_{$tablename}` where `syn`= {$syn} and lang={$lid}");
				} else {
					$rs_shadow[$lid] = $this->db->find("select * from `#yunyecms_{$tablename}` where `syn`= {$id} and lang={$lid}");
				}
				if ($row_shadow[$lid]['pic']) $row_shadow[$lid]['pic'] = dopic($row_shadow[$lid]['pic']);
			}
			$yyact = "edit";
		} else {
			$yyact = yyact_get("add");
			$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'member') . '\" target=\"maincontent\">用户</a></li><li  class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'homeset') . '\" target=\"maincontent\">首页模块管理</a></li><li class=\"breadcrumb-item active\">增加首页模块</li>';
			$sqlordermax = "select max(ordernum) as maxordernum from `#yunyecms_homeset`";
			$ordermaxquery = $this->db->find($sqlordermax);
			$ordermax = $ordermaxquery["maxordernum"] + 1;
		}
		if (isset($_POST["yyact"])) {
			$_POST = ustripslashes($_POST);
			$data["catid"] = usafestr(trim($_POST["catid"]));
			$data['modelid'] = getmodelid($data["catid"]);
			$data['modeltype'] = getmodeltype($data["modelid"]);
			$data['mode'] = usafestr(trim($_POST["mode"]));
			$data['style'] = usafestr(trim($_POST["style"]));
			$data["pic"] = usafepic(revpic(trim($_POST["pic"])));
			$data["ordernum"] = usafestr(trim($_POST["ordernum"]));
			$data["addtime"] = time();
			$data["status"] = 1;
			foreach ($lang_list as $kk => $vv) {
				$lid = $vv['id'];
				$ldef = $vv['isdefault'];
				if ($ldef == 1) {
					$data["title"] = usafestr(trim($_POST["title_{$lid}"]));
					$data["title_en"] = usafestr(trim($_POST["title_en_{$lid}"]));
					$data['num'] = intval(trim($_POST["num_{$lid}"]));
					$data['url'] = uhtmlspecialchars(trim($_POST["url_{$lid}"]));
					$data["isdisplay"] = usafestr(trim($_POST["isdisplay_{$lid}"]));
					if (uhtmlspecialchars(trim($_POST["picfile_{$lid}"]))) $data["picfile"] = uhtmlspecialchars(trim($_POST["picfile{$lid}"]));
					$data['summary'] = uhtmlspecialchars(trim($_POST["summary_{$lid}"]));
					$data['lang'] = $lid;
					if (isset($_POST["content_{$lid}"])) {
						$data["content"] = revimgs(trim($_POST["content_{$lid}"]));
					}
				} else {
					$postcatid = usafestr(trim($_POST["catid"]));
					$psyn = $this->db->getfield('syn', $postcatid, 'category');
					if ($psyn) {
						$catecheck = $this->db->find("select * from `#yunyecms_category` where `syn`= {$psyn} and lang={$lid}");
						if ($catecheck) {
							$data_shadow[$lid]['catid'] = $catecheck["id"];
						} else {
							messagebox("{$vv['title']}栏目不能为空，请先添加栏目!", $_SERVER['HTTP_REFERER']);
						}
					} else {
						messagebox("栏目参数错误，请重新选择!", $_SERVER['HTTP_REFERER']);
					}
					$data_shadow[$lid]['modelid'] = getmodelid($data_shadow[$lid]['catid']);
					$data_shadow[$lid]['modeltype'] = getmodeltype($data_shadow[$lid]["modelid"]);
					$data_shadow[$lid]['title'] = uhtmlspecialchars(trim($_POST["title_{$lid}"]));
					$data_shadow[$lid]['title_en'] = uhtmlspecialchars(trim($_POST["title_en_{$lid}"]));
					$data_shadow[$lid]['num'] = intval(trim($_POST["num_{$lid}"]));
					$data_shadow[$lid]["isdisplay"] = usafestr(trim($_POST["isdisplay_{$lid}"]));
					$data_shadow[$lid]['url'] = uhtmlspecialchars(trim($_POST["url_{$lid}"]));
					if (uhtmlspecialchars(trim($_POST["picfile_{$lid}"]))) $data_shadow[$lid]["picfile"] = uhtmlspecialchars(trim($_POST["picfile{$lid}"]));
					$data_shadow[$lid]['summary'] = uhtmlspecialchars(trim($_POST["summary_{$lid}"]));
					$data_shadow[$lid]['lang'] = $lid;
					$data_shadow[$lid]['pic'] = $data["pic"];
					$data_shadow[$lid]['mode'] = $data["mode"];
					$data_shadow[$lid]['style'] = $data["style"];
					$data_shadow[$lid]['ordernum'] = $data["ordernum"];
					$data_shadow[$lid]['status'] = 1;
					if (isset($_POST["content_{$lid}"])) {
						$data_shadow[$lid]["content"] = revimgs(trim($_POST["content_{$lid}"]));
					}
				}
			}

			if (empty($data["title"])) {
				messagebox("首页模块标题不能为空，谢谢!", $_SERVER['HTTP_REFERER']);
			}
			if ($_POST["yyact"] == "add") {
				$data["addtime"] = time();
				$data["status"] = 1;
				//计算记录编号  
				$data["number"] = create_number($tablename, $this->lang);
				$insertid = $this->db->insert($data, $tablename, true);
				if ($insertid) {
					//同步新增其他语言版记录
					$syndata['syn'] = $insertid;
					$retsyn = $this->db->update($syndata, array('id' => $insertid), $tablename);
					if ($retsyn) {
						foreach ($lang_list as $kk => $vv) {
							$lid = $vv['id'];
							$ldef = $vv['isdefault'];
							$data_shadow[$lid]['syn'] = $insertid;
							$data_shadow[$lid]["addtime"] = time();
							$data_shadow[$lid]["number"] = $data["number"];;
							if ($ldef != 1) {
								$retsynadd[$lid] = $this->db->insert($data_shadow[$lid], $tablename);
							}
						}
						//$this->db->Autocommit_commit(); 
					} else {
						$this->db->Autocommit_rollback();
					}
					$doing = "添加首页模块—" . $data["title"];
					$yyact = "Add_homeset";
					insert_admlogs($doing, $yyact);
					messagebox("添加首页模块成功！", url_admin('init'), "success");
				} else {
					messagebox("添加首页模块失败！", url_admin('init'), "error");
				}
			}
			if ($_POST["yyact"] == "edit") {
				$id = $_POST["id"];
				if (!$this->check_exist($id)) {
					messagebox("该消息不存在！", url_admin('init'), "warn");
				}
				$crow = $this->db->find("select * from `#yunyecms_{$tablename}`  where `id`= {$id}");
				$data["addtime"] = strtotime(trim($_POST["addtime"]));
				$retres = $this->db->update($data, "id={$id}", "homeset");
				if ($retres) {
					//同步更新其他语言版
					foreach ($lang_list as $kk => $vv) {
						$lid = $vv['id'];
						$ldef = $vv['isdefault'];
						$rs_check = $this->db->GetCount("select count(*) from `#yunyecms_{$tablename}` where `syn`= {$crow['syn']} and lang={$lid}");
						if ($rs_check) {
							$data_shadow[$lid]["addtime"] = $data["addtime"];
							$retsynadd[$lid] = $this->db->update($data_shadow[$lid], array("syn" => $id, "lang" => $lid), $tablename);
						} else {
							$data_shadow[$lid]['syn'] = $crow['syn'];
							$data_shadow[$lid]['number'] = create_number($tablename, $this->lang);
							$data_shadow[$lid]["addtime"] = $crow['addtime'];
							$data_shadow[$lid]["updatetime"] = $crow['updatetime'];
							$data_shadow[$lid]["admin_userid"] = $this->admuser["userid"];
							$retsynadd[$lid] = $this->db->insert($data_shadow[$lid], $tablename, true);
						}
					}

					$doing = "更新首页模块—" . $data["title"];
					$yyact = "Update_homeset";
					insert_admlogs($doing, $yyact);
					messagebox("首页模块更新成功！", url_admin('init'), "success");
				} else {
					messagebox("首页模块更新失败！", url_admin('init'), "error");
				}
			}
		}
		require tpl_adm('homeset_add');
	}

	public function finaldelete()
	{
		if (!getroot('info', 'del')) {
			messagebox(Lan('no_permission'), 'back');
		}
		$id = $_REQUEST["id"];
		if (!is_array($id)) {
			$id = compact('id');
		}
		$idarray = $id;
		foreach ($idarray as $key => $var) {
			if (!is_numeric($var)) {
				messagebox("错误的参数！", 'back', "warn");
			}
			$var = usafestr($var);
			$idarray[$key] = $var;
			$curmodelnr = $this->db->find("select id,pic,content,syn from `#yunyecms_homeset` where `id`= {$var}");
			if ($curmodelnr) {
				$syn = $curmodelnr["syn"];
				foreach ($curmodelnr as $kk => $vv) {
					$thumb = $vv["pic"];
					$ct_content = uhtmlspecialchars_decode($vv["content"]);
					$ct_content_img = getcontentimg($ct_content);
					if (!empty($thumb)) {
						file_delete($thumb);
					}
					foreach ($ct_content_img as $key3 => $var3) {
						file_delete($var3);
					}
				}
				$retres = $this->db->delete("syn = $syn", 'homeset');
			}
		}
		if (isset($idarray)) {
			if ($retres !== false) {
				$yyact = "homeset_Del";
				$logcontent['tablename'] = "homeset";
				$logcontent['action'] = $yyact;
				$logcontent['ids'] = serialize($id);
				$logcontent = serialize($logcontent);
				$doing = "删除首页模块：{$idarray} ";
				insert_admlogs($doing, $yyact, $logcontent);
				messagebox(Lan('admin_delete_success'), $_SERVER['HTTP_REFERER'], "success");
			} else {
				messagebox(Lan('admin_delete_error'), $_SERVER['HTTP_REFERER'], "warn");
			}
		} else {
			messagebox(Lan('admin_delete_error'), $_SERVER['HTTP_REFERER'], "warn");
		}
	}




	public function check()
	{
		parent::infocheck("homeset", $this->db);
	}

	public function nocheck()
	{
		parent::infonocheck("homeset", $this->db);
	}

	private function check_exist($id)
	{
		$id = trim($id);
		if (empty($id)) {
			return false;
		} else {
			if (!is_numeric($id)) {
				return false;
			}
			if ($this->db->find("select count(*) as cnt from `#yunyecms_homeset` where `id`= {$id}")) {
				return true;
			}
		}
	}
}
