<?php
defined('IN_YUNYECMSAdmin') or exit('No permission.');
core::load_admin_class('admin');
class comment extends YUNYE_admin
{
	function __construct()
	{
		parent::__construct();
		$this->db = core::load_model('common_model', 'comment');
	}
	//加载首页
	public function init()
	{
		$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', "section") . '\" target=\"maincontent\">系统</a></li><li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'section') . '\" target=\"maincontent\">评论管理</a></li><li class=\"breadcrumb-item active\">评论列表</li>';
		$pagesize = 20;
		$sqlquery = "select * from `#yunyecms_comment`  ";
		$where = " where 1=1 and content<>'' ";
		$sqlcnt = " select count(*) from `#yunyecms_comment` ";
		$order = " order by `addtime` desc ";
		if (isset($_REQUEST)) {
			if (!empty($_REQUEST["searchkey"])) {
				$searchkey = usafestr(trim($_REQUEST["searchkey"]));
				$where = $where . " and (`title`  like '%{$searchkey}%' )";
			}
			if (!empty($_REQUEST["id"])) {
				$infoid = intval(trim($_REQUEST["id"]));
				$where = $where . " and ( `infoid`  = '{$infoid}' )";
			}
			if (!empty($_REQUEST["catid"])) {
				$catid = intval(trim($_REQUEST["catid"]));
				$where = $where . " and ( `catid`  = '{$catid}' )";
			}
		}
		$breadcumb = getbreadcumb($catid);
		$breadcumbstr = "";
		foreach ($breadcumb as $kk => $vv) {
			$breadcumbstr = $breadcumbstr . '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('lists', 'content', array("catid" => $vv['id'])) . '\" target=\"maincontent\">' . $vv['title'] . '</a></li>';
		}
		$parnav = $breadcumbstr . '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'section', array('id' => $kcid, 'catid' => $catid)) . '\" target=\"maincontent\">评论</a></li>';
		$pagearr = $this->db->pagelist($sqlcnt, $sqlquery, $where, $order, $pagesize);
		if ($pagearr["count"] != 0) {
			$list = $pagearr["query"];
			foreach ($list as $key => $var) {
				$userid = $var['userid'];
				if ($var['catid'] && $var['flag'] == 1) {
					$list[$key]["info"] = GetContentById($var['infoid'], $var['catid']);
				} else {
					$list[$key]["notice"] = getbyid($var['infoid'], "notice");
				}
				if ($userid) {
					$list[$key]["member"] = getbyid($userid, "member");
				}
			}
			$page = $pagearr["page"];
		}
		require tpl_adm('comment_list');
	}


	public function add()
	{
		if (!empty($_REQUEST["kcid"])) {
			$kcid = intval(trim($_REQUEST["kcid"]));
			$catid = intval(trim($_REQUEST["catid"]));
			$kc = GetContentById($kcid, $catid);
			if (empty($kc)) {
				messagebox("该评论不存在", $_SERVER['HTTP_REFERER']);
			}
		} else {
			messagebox("该评论不存在", $_SERVER['HTTP_REFERER']);
		}
		if (!empty($_GET["id"])) {
			$parnav = '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'section') . '\" target=\"maincontent\">评论管理</a></li><li class=\"breadcrumb-item active\">修改评论</li>';
			$id = trim($_GET["id"]);
			if (!is_numeric($id)) {
				messagebox("评论参数错误", url_admin('init'));
			}
			$rsinfo = $this->db->find("select * from `#yunyecms_comment` where `id`= {$id}");
			if (empty($rsinfo)) {
				messagebox("评论不存在", $_SERVER['HTTP_REFERER']);
			}
			$yyact = "edit";
		} else {
			$yyact = yyact_get("add");
			$breadcumb = getbreadcumb($catid);
			$breadcumbstr = "";
			foreach ($breadcumb as $kk => $vv) {
				$breadcumbstr = $breadcumbstr . '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('lists', 'content', array("catid" => $vv['id'])) . '\" target=\"maincontent\">' . $vv['title'] . '</a></li>';
			}
			$parnav = $breadcumbstr . '<li class=\"breadcrumb-item\"><a href=\"' . url_admin('init', 'section', array('id' => $kcid, 'catid' => $catid)) . '\" target=\"maincontent\">增加评论</a></li>';

			$sqlordermax = "select max(ordernum) as maxordernum from `#yunyecms_comment`";
			$ordermaxquery = $this->db->find($sqlordermax);
			$ordermax = $ordermaxquery["maxordernum"] + 1;
		}
		if (isset($_POST["yyact"])) {
			$_POST = ustripslashes($_POST);
			$data["isgood"] = empty($_POST["isgood"]) ? 0 : usafestr(trim($_POST["isgood"]));
			$data["title"] = usafestr(trim($_POST["title"]));
			$data["pic"] = uhtmlspecialchars(trim($_POST["pic"]));
			$picfile = $_POST['picfile'];
			$data["kcid"] = $kcid;
			$data["catid"] = $catid;
			$data["status"] = 1;
			if (isset($_POST["content"])) {
				$data["content"] = uhtmlspecialchars(trim($_POST["content"]));
			}
			if (empty($data["title"])) {
				messagebox("标题不能为空，谢谢!", $_SERVER['HTTP_REFERER']);
			}
			if ($_POST["yyact"] == "add") {
				$data["addtime"] = time();
				$retres = $this->db->insert($data);
				if ($retres) {
					$doing = "添加评论—" . $data["title"];
					$yyact = "Add_comment";
					insert_admlogs($doing, $yyact);
					messagebox("添加评论成功！", url_admin('init', 'comment', array("id" => $kcid, 'catid' => $catid)), "success");
				} else {
					messagebox("添加评论失败！", url_admin('init', 'comment', array("id" => $kcid, 'catid' => $catid)), "error");
				}
			}
			if ($_POST["yyact"] == "edit") {
				$id = $_POST["id"];
				if (!$this->check_exist($id)) {
					messagebox("该评论不存在！", url_admin('init'), "warn");
				}
				$data["addtime"] = strtotime(trim($_POST["addtime"]));
				$retres = $this->db->update($data, "comment", array('id' => $id));
				if ($retres) {
					$doing = "更新评论—" . $data["title"];
					$yyact = "Update_section";
					insert_admlogs($doing, $yyact);
					messagebox("评论更新成功！", url_admin('init', 'comment', array("id" => $kcid, 'catid' => $catid)), "success");
				} else {
					messagebox("评论更新失败！", url_admin('init', 'comment', array("id" => $kcid, 'catid' => $catid)), "error");
				}
			}
		}
		require tpl_adm('comment_add');
	}

	public function finaldelete()
	{
		if (!getroot('info', 'del')) {
			messagebox(Lan('no_permission'), 'back');
		}
		$id = $_REQUEST["id"];
		if (!is_array($id)) {
			$id = compact('id');
		}
		$idarray = $id;
		foreach ($idarray as $key => $var) {
			if (!is_numeric($var)) {
				messagebox("错误的参数！", 'back', "warn");
			}
			$var = usafestr($var);
			$idarray[$key] = $var;
			$curmodelnr = $this->db->find("select * from `#yunyecms_comment` where `id`= {$var}");
			if ($curmodelnr) {
				//  $thumb=$curmodelnr["pic"];
				// $ct_content=$curmodelnr["content"];
				// $ct_content_img=getcontentimg($ct_content);
				if (!empty($thumb)) {
					//file_delete($thumb);
				}
				foreach ($ct_content_img as $key3 => $var3) {
					//file_delete($var3);
				}
			}
		}

		if (isset($idarray)) {
			$idarray = implode(",", $idarray);
			$retres = $this->db->delete("id in ({$idarray})", "comment");
			if ($retres !== false) {
				$yyact = "section_Del";
				$logcontent['tablename'] = "section";
				$logcontent['action'] = $yyact;
				$logcontent['ids'] = serialize($id);
				$logcontent = serialize($logcontent);
				$doing = "删除评论：{$idarray} ";
				insert_admlogs($doing, $yyact, $logcontent);
				messagebox(Lan('admin_delete_success'), $_SERVER['HTTP_REFERER'], "success");
			} else {
				messagebox(Lan('admin_delete_error'), $_SERVER['HTTP_REFERER'], "warn");
			}
		} else {
			messagebox(Lan('admin_delete_error'), $_SERVER['HTTP_REFERER'], "warn");
		}
	}




	public function check()
	{
		parent::infocheck("comment", $this->db);
	}

	public function nocheck()
	{
		parent::infonocheck("comment", $this->db);
	}

	private function check_exist($id)
	{
		$id = trim($id);
		if (empty($id)) {
			return false;
		} else {
			if (!is_numeric($id)) {
				return false;
			}
			if ($this->db->find("select count(*) as cnt from `#yunyecms_comment` where `id`= {$id}")) {
				return true;
			}
		}
	}
}
