# CSS Reset 「 样式重置 」

## 文件路径

`sass/global/_reset.scss`

## 简介

在没有任何 CSS 的情况下，浏览器都会给标签默认的 CSS 样式，以保证语义化的标签能有初步的展现形式。

不过难受的是，不同的浏览器对于这个基础的样式设定的规则是不一样的，所以会很容易出现兼容性问题。
于是大家有了想将浏览器通过一个基础的 CSS 文件，将这些自定义属性统一成一个样的想法，而这个就是我们大家所熟知的 CSS Reset。

其实要构建自定义的 CSS Reset 是一件比较考验，开发人员对于浏览器默认样式的理解能力的事情。即是你自己非常了解他们之间的差异，这仍然是需要花费大量时间的。

所以通常大家的做法都是在网上借用别人写的 CSS Reset。 比如下面这些在2018年比较火的几个。

![image](https://user-images.githubusercontent.com/7261176/49325433-427cea80-f57d-11e8-983d-663c372fb40a.png)

当然我也是非常推荐大家使用这些流行的 CSS Reset 解决方案，虽然并不是最适合你们团队的最优解，但是胜在省时省力又省心。


## 目录其它 CSS 最佳实践

1. [CSS Variable「 参数 」](../css/variable) 
2. [CSS Mixin 「 辅助方法 」](../css/mixin)
3. [CSS Reset 「 样式重置 」](../css/reset)
4. [CSS Base 「 基础样式 」](../css/base)
5. [ACSS 「 原子化CSS 」](../css/acss)