## 1 工厂方法模式 VS 建造者模式

工厂方法模式注重的是整体对象的创建方式；而建造者模式注重的是部件构建的过程，意在通过一步一步地精确构造创建出一个复杂的对象。

我们举个简单例子来说明两者的差异，如要制造一个超人，如果使用工厂方法模式，直接产生出来的就是一个力大无穷、能够飞翔、内裤外穿的超人；而如果使用建造者模式，则需要组装手、头、脚、躯干等部分，然后再把内裤外穿，于是一个超人就诞生了。

## 2 抽象工厂模式 VS 建造者模式

抽象工厂模式实现**对产品家族的创建，一个产品家族是这样的一系列产品**：具有不同分类维度的产品组合，采用抽象工厂模式则是不需要关心构建过程，只关心什么产品由什么工厂生产即可。

建造者模式则是要求按照指定的蓝图建造产品，它的主要目的是**通过组装零配件而产生一个新产品**。

如果将抽象工厂模式看成汽车配件生产工厂，生产一个产品族的产品，那么建造者模式就是一个汽车组装工厂，通过对部件的组装可以返回一辆完整的汽车。

## 3 三种代理的对比

- jdk代理和CGLIB代理

  使用CGLib实现动态代理，CGLib 底层采用 **ASM 字节码**生成框架，使用字节码技术生成代理类，在JDK1.6之前比使用Java反射效率要高。唯一需要注意的是，CGLib不能对声明为final的类或者方法进行代理，因为CGLib原理是动态生成被代理类的子类。

  在JDK1.6、JDK1.7、JDK1.8逐步对JDK动态代理优化之后，在调用次数较少的情况下，JDK代理效率高于CGLib代理效率，只有当进行大量调用的时候，JDK1.6和JDK1.7比CGLib代理效率低一点，但是到JDK1.8的时候，JDK代理效率高于CGLib代理。所以如果有接口使用 JDK 动态代理，如果没有接口使用 CGLIB 代理。

- 动态代理和静态代理

  动态代理与静态代理相比较，最大的好处是接口中声明的所有方法都被转移到调用处理器一个集中的方法中处理（InvocationHandler.invoke）。这样，在接口方法数量比较多的时候，我们可以进行灵活处理，而不需要像静态代理那样每一个方法进行中转。

  如果接口增加一个方法，静态代理模式除了所有实现类需要实现这个方法外，所有代理类也需要实现此方法。增加了代码维护的复杂度。而动态代理不会出现该问题

## 4 代理 VS 装饰者

静态代理和装饰者模式的区别：

- 相同点：
  - 都要实现与目标类相同的业务接口
  - 在两个类中都要声明目标对象
  - 都可以在不修改目标类的前提下增强目标方法
- 不同点：
  - 目的不同 装饰者是为了增强目标对象 静态代理是为了保护和隐藏目标对象
  - 获取目标对象构建的地方不同 装饰者是由外界传递进来，可以通过构造方法传递 静态代理是在代理类内部创建，以此来隐藏目标对

## 5 策略VS状态

策略模式：策略模式的客户端必须对所有的策略类相当了解，明确当前场景下各种策略的利弊，权衡在当前场景下应该使用哪种策略，也就是是说策略类对客户端是暴露的

状态模式：状态模式依赖于其状态的变化时其内部的行为发生变化，将动作委托到代表当前状态的对象，对外表现为类发生了变化。

策略模式是通过 Context 本身的决策来主动更替使用的strategy对象达到改变行为的目的，状态模式通过**状态转移**来被动的更改当前的State对象，状态的改变发生在运行时。

策略模式提前封装一组可以互相替代的算法族，根据需要动态的选择合适的一个来处理问题，而状态模式处理不同状态下， Context 对象行为不同的问题；

## 6 外观 VS 代理 VS 中介者

**外观模式（Facade Pattern）**
定义一个外观类，外观类隐藏系统的复杂性，为客户端提供简化的方法和对现有系统类方法的委托调用。
例如：二手房交易的中介，属于外观模式。买房者通过中介可以简单地买到二手房，中介自己把联系房东看房砍价、过户、交税这些复杂的事情都搞定了。

**代理模式（Proxy Pattern）**
用一个代理类代表另一个类的功能，但是不改变被代理类的功能。目的是控制对被代理类的访问。

**中介者模式（Mediator Pattern）**
用一个中介对象来封装一系列的对象交互，中介者使各对象不需要显式地相互引用，从而使其耦合松散，而且可以独立地改变它们之间的交互。将各对象之间的网状结构分离为星型结构。
例如：MVC 框架，其中C（控制器）就是 M（模型）和 V（视图）的中介者。微信群是各群员之间的中介者。