## 1 概念

又叫**快照模式**，在不破坏封装性的前提下，捕获一个对象的内部状态，并在该对象之外保存这个状态，以便以后当需要时能将该对象恢复到原先保存的状态。

备忘录模式的主要角色如下：

- 发起人（Originator）角色：记录当前时刻的内部状态信息，提供创建备忘录和恢复备忘录数据的功能，实现其他业务功能，它可以访问备忘录里的所有信息。
- 备忘录（Memento）角色：负责存储发起人的内部状态，在需要的时候提供这些内部状态给发起人。
- 管理者（Caretaker）角色：对备忘录进行管理，提供保存与获取备忘录的功能，但其不能对备忘录的内容进行访问与修改。

## 2 例子

游戏存档。

```java
//游戏
public class GameRate {
    private int rate; //当前进度

    public int getRate() {
        return rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    //保存进度
    public GameRateMemento save() {
        return new GameRateMemento(rate);
    }

    //恢复进度
    public void recoverState(GameRateMemento gameRateMemento) {
        this.rate = gameRateMemento.getRate();
    }

    @Override
    public String toString() {
        return "GameRate{" +
                "rate=" + rate +
                '}';
    }
}

//游戏进度存储类(备忘录类)
public class GameRateMemento {
    private int rate; //进度

    public int getRate() {
        return rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public GameRateMemento(int rate) {
        this.rate = rate;
    }
}

//角色状态管理者类
public class GameRateCaretaker {
    private GameRateMemento gameRateMemento;

    public GameRateMemento getGameRateMemento() {
        return gameRateMemento;
    }

    public void setGameRateMemento(GameRateMemento gameRateMemento) {
        this.gameRateMemento = gameRateMemento;
    }
}

public class TestClient {
    public static void main(String[] args) {
        final GameRate gameRate = new GameRate();
        gameRate.setRate(50);//当前进度 50
        System.out.println(gameRate);
        
        //保存游戏进度
        final GameRateCaretaker gameRateCaretaker = new GameRateCaretaker();
        gameRateCaretaker.setGameRateMemento(gameRate.save());

        gameRate.setRate(70);//进行到 70
        System.out.println(gameRate);

        //回档
        gameRate.recoverState(gameRateCaretaker.getGameRateMemento());
        System.out.println(gameRate);

    }
}
```

## 3 优缺点

优点：

* 给用户提供了一种可以恢复状态的机制，可以使用户能够比较方便地回到某个历史的状态。 * 
* 实现了信息的封装，使得用户不需要关心状态的保存细节。

缺点：

* 消耗资源。如果类的成员变量过多，势必会占用比较大的资源，而且每一次保存都会消耗一定的内存。