## 1 概述

封装一些作用于某种数据结构中的各元素的操作，它可以在不改变这个数据结构的前提下定义作用于这些元素的新的操作，主要将**数据结构与数据操作分离**。

访问者模式包含以下主要角色:

- 抽象访问者（Visitor）角色：定义了对每一个元素`（Element）`访问的行为，它的参数就是可以访问的元素，它的方法个数理论上来讲与元素类个数（Element的实现类个数）是一样的，从这点不难看出，访问者模式要求元素类的个数不能改变。
- 具体访问者（ConcreteVisitor）角色：给出对每一个元素类访问时所产生的具体行为。
- 抽象元素（Element）角色：定义了一个接受访问者的方法（`accept`），其意义是指，每一个元素都要可以被访问者访问。
- 具体元素（ConcreteElement）角色： 提供接受访问方法的具体实现，而这个具体的实现，通常情况下是使用访问者提供的访问该元素类的方法。
- 对象结构（Object Structure）角色：定义当中所提到的对象结构，对象结构是一个抽象表述，具体点可以理解为一个具有容器性质或者复合对象特性的类，它会含有一组元素（`Element`），并且可以迭代这些元素，供访问者访问。

## 2 例子

给宠物喂食，主人可以喂，其他人也可以喂。

- 访问者角色：给宠物喂食的人
- 具体访问者角色：主人、其他人
- 抽象元素角色：动物抽象类
- 具体元素角色：宠物狗、宠物猫
- 结构对象角色：主人家

```java
//创建抽象访问者接口
public interface Person {
    void feed(Cat cat);
    void feed(Dog dog);
}

//创建不同的具体访问者角色（主人和其他人），都需要实现 Person接口
public class Owner implements Person {

    @Override
    public void feed(Cat cat) {
        System.out.println("主人喂食猫");
    }

    @Override
    public void feed(Dog dog) {
        System.out.println("主人喂食狗");
    }
}

public class Someone implements Person {
    @Override
    public void feed(Cat cat) {
        System.out.println("其他人喂食猫");
    }

    @Override
    public void feed(Dog dog) {
        System.out.println("其他人喂食狗");
    }
}

//定义抽象节点 -- 宠物
public interface Animal {
    void accept(Person person);
}

//定义实现Animal接口的 具体节点（元素）
public class Dog implements Animal {

    @Override
    public void accept(Person person) {
        person.feed(this);
        System.out.println("好好吃，汪汪汪！！！");
    }
}

public class Cat implements Animal {

    @Override
    public void accept(Person person) {
        person.feed(this);
        System.out.println("好好吃，喵喵喵！！！");
    }
}

public class Home {
    private List<Animal> nodeList = new ArrayList<Animal>();
    public void action(Person person) {
        for (Animal node : nodeList) {
            node.accept(person);
        }
    }
    //添加操作
    public void add(Animal animal) {
        nodeList.add(animal);
    }
}

public class TestClient {
    public static void main(String[] args) {
        Home home = new Home();
        home.add(new Dog());
        home.add(new Cat());
        Owner owner = new Owner();
        home.action(owner);
        Someone someone = new Someone();
        home.action(someone);
    }
}
```



## 3 优缺点

优点：

- 符合单一职责原则
- 优秀的扩展性
- 灵活性非常高

缺点：

- 具体元素对访问者公布细节，也就是说访问者关注了其他类的内部细节，这是迪米特法则所不建议的
- 具体元素变更比较困难
- 违背了依赖倒转原则。访问者依赖的是具体元素，而不是抽象元素