## 1 概述

又叫门面模式，是一种通过为多个复杂的子系统提供一个一致的接口，而使这些子系统更加容易被访问的模式。该模式**对外有一个统一接口**，外部应用程序不用关心内部子系统的具体的细节，这样会大大降低应用程序的复杂度，提高了程序的可维护性。

外观（Facade）模式包含以下主要角色：

- 外观（Facade）角色：为多个子系统对外提供一个共同的接口。
- 子系统（Sub System）角色：实现系统的部分功能，客户可以通过外观角色访问它。

## 2 例子

启动一台电脑，电脑内部，包括 CPU 启动、硬盘启动、内存启动等，但是我们无需关心这些细节，电脑自提供一个开机的方法。

```java
//电脑接口
public interface Computer {
    void open();
}

//CPU
public class Cpu implements Computer {
    @Override
    public void open() {
        System.out.println("启动CPU");
    }
}

//硬盘
public class Ssd implements Computer {
    @Override
    public void open() {
        System.out.println("启动硬盘");
    }
}

//内存
public class Ddr implements Computer {
    @Override
    public void open() {
        System.out.println("启动内存");
    }
}

//外观类
public class Facade {
    private Computer cpu;
    private Computer ddr;
    private Computer ssd;
    public Facade() {
       cpu = new Cpu();
       ddr = new Ddr();
       ssd = new Ssd();
    }

    public void open() {
        cpu.open();
        ddr.open();
        ssd = new Ssd();
    }
}

public class TestClient {
    public static void main(String[] args) {
        //创建外观对象
        Facade facade = new Facade();
        //客户端直接与外观对象进行交互
        facade.open();
    }
}
```

## 3 优缺点

优点：

- 降低了子系统与客户端之间的**耦合度**，使得子系统的变化不会影响调用它的客户类。
- 对客户屏蔽了子系统组件，减少了客户处理的对象数目，并使得子系统使用起来更加容易。

缺点：

- 不符合开闭原则，修改很麻烦。