## 1 适配器模式

适配器模式(Adapter Pattern)：将某个类的接口转换成客户端期望的另一个接口表示，主的目的是兼容性，让原本因接口不匹配不能一起工作的两个类可以协同工作，其别名为包装器(Wrapper)，属于结构型模式，主要分为三类：类适配器模式、对象适配器模式、接口适配器模式。

## 2 工作原理

1. 适配器模式：将一个类的接口转换成另一种接口，让原本接口不兼容的类可以兼容。
2. 从用户的角度看不到被适配者，是解耦的。
3. 用户调用适配器转化出来的目标接口方法，适配器再调用被适配者的相关接口方法。
4. 用户收到反馈结果，感觉只是和目标接口交互。

## 3 类适配器模式

手机需要 5V（dst 目标）充电 ，现在有 220V 交流电（src 被适配者），需要转接头转成 5V（充电器）。

```java
//适配接口
public interface IVoltage5V {
    int output5V();
}

public class Phone {
    public void charging(IVoltage5V iVoltage5V){
        if (iVoltage5V.output5V() > 5){
            System.out.println("不能充电");
        }else if (iVoltage5V.output5V() == 5){
            System.out.println("可以充电");
        }

    }
}

//被适配的类
public class Voltage220V {
    //输出 220V 的电压
    public int output220V() {
        int src = 220;
        System.out.println("电压 = " + src + "伏");
        return src;
    }
}

//适配器类
public class VoltageAdapter extends Voltage220V implements IVoltage5V {
    @Override
    public int output5V() {
        int output220V = output220V();
        //转换成 5v
        return output220V / 44;
    }
}

public class TestClient {
    public static void main(String[] args) {
        VoltageAdapter adapter = new VoltageAdapter();
        Phone phone = new Phone();
        phone.charging(adapter);
    }
}

```

1. Java 是单继承机制，所以类适配器需要继承 src 类这一点算是一个缺点, 因为这要求 dst 必须是接口，有一定局限性。

2. src 类的方法在 Adapter 中都会暴露出来，也增加了使用的成本。

3. 由于其继承了 src 类，所以它可以根据需求重写 src 类的方法，使得 Adapter 的灵活性增强了。

 ## 4 对象适配器模式

基本思路和类的适配器模式相同，只是将 Adapter 类作修改，不是继承 src 类，而是持有 src 类的实例，以解决兼容性的问题。 即：持有 src 类，实现 dst  类接口，完成 src -> dst 的适配。

```java
public class ObjectVoltageAdapter  implements IVoltage5V {
    private Voltage220V voltage220V;
    
    public ObjectVoltageAdapter(Voltage220V voltage220){
        this.voltage220V = voltage220;
    }

    @Override
    public int output5V() {
        int output220V = voltage220V.output220V();
        //转换成 5v
        return output220V / 44;
    }
}

```

1. 对象适配器和类适配器其实算是同一种思想，只不过实现方式不同。

2. 根据合成复用原则，使用组合替代继承， 所以它解决了类适配器必须继承 src 的局限性问题，也不再要求 dst必须是接口。

3. 使用成本更低，更灵活。

## 5 接口适配器模式

当不需要全部实现接口提供的方法时，可先设计一个抽象类实现接口，并为该接口中每个方法提供一个默认实现（空方法），那么该抽象类的子类可有选择地覆盖父类的某些方法来实现需求，适用于一个接口不想使用其所有的方法的情况。