## 1 工厂模式

工厂模式是 Java 中最常用的设计模式之一，属于创建型模式。

## 2 简单工厂模式

简单工厂模式是属于创建型模式，是工厂模式的一种。简单工厂模式是由一个工厂对象决定创建出哪一种产品类的实例。

使用：定义了一个创建对象的类，由这个类来封装实例化对象的行为。

```java
//鼠标工厂，专业生产鼠标，给参数 0，生产小米鼠标，给参数 1，生产华为鼠标。
public interface Mouse {
    void print();
}

public class XMMouse implements Mouse {
    @Override
    public void print() {
        System.out.println("小米鼠标");
    }
}

public class HWMouse implements Mouse {
    @Override
    public void print() {
        System.out.println("华为鼠标");
    }
}


//简单工厂模式 又称 静态工厂模式
public class MouseFactory {
    public static Mouse createMouse(int type) {
        Mouse mouse = null;
        if (type == 0) {
            mouse = new XMMouse();
        }
        if (type == 1) {
            mouse = new HWMouse();
        }
        return mouse;
    }
}

```

优点： 

1. 不需要关心类的创建细节。
2. 扩展性高，如果想增加一个产品，只要扩展一个工厂类就可以。 
3. 屏蔽产品的具体实现，调用者只关心产品的接口。

缺点：每次增加一个产品时，都需要增加一个具体类和对象实现工厂，使得系统中类的个数成倍增加，在一定程度上增加了系统的复杂度，同时也增加了系统具体类的依赖。这并不是什么好事。

## 2 工厂方法模式

工厂方法模式，又称工厂模式、多态工厂模式和虚拟构造器模式，通过工厂父类定义负责创建产品的公共接口，子类负责生产具体对象。

```java
/**
*
* 把鼠标工厂抽象成一个类（接口）。
* 小米鼠标工厂，继承它：小米鼠标。
* 华为鼠标工厂，继承它：华为鼠标。
*
**/
public interface IMouseFactory {
    Mouse createMouse();
}

public class XMMouseFactory implements IMouseFactory {

    @Override
    public Mouse createMouse() {
        return new XMMouse();
    }
}

public class HWMouseFactory implements IMouseFactory {

    @Override
    public Mouse createMouse() {
        return new HWMouse();
    }
}
```

优点：更符合开闭原则，增加一个产品类，则只需要实现其他具体的产品类和具体的工厂类即可；符合单一职责原则，每个工厂只负责生产对应的产品。

缺点：每增加一个产品，就需要实现对应的具体工厂类和具体产品类；每个产品需要有对应的具体工厂和具体产品类。

## 3 抽象工厂模式

抽象工厂模式是围绕一个超级工厂创建其他工厂（提供一套标准），超级工厂又称为其他工厂的工厂。这种类型的设计模式属于创建型模式，它提供了一种创建对象的最佳方式。

```java
/**
*
* 抽象工厂模式也就是不仅生产鼠标，同时生产键盘。也就是 PC 厂商是个父类，有生产鼠标，生产键盘两个接口。
* 小米 PC 工厂继承抽象工厂：小米鼠标 + 小米键盘。
* 华为 PC 工厂继承抽象工厂：华为鼠标 + 华为键盘。
*
**/
public interface IPCFactory {
    Mouse createMouse();

    Keybo createKeybo();
}

public class XMPCFactory implements IPCFactory {

    @Override
    public Mouse createMouse() {
        return new XMMouse();
    }

    @Override
    public Keybo createKeybo() {
        return new XMKeybo();
    }
}

public class HWPCFactory implements IPCFactory {

    @Override
    public Mouse createMouse() {
        return new HWMouse();
    }

    @Override
    public Keybo createKeybo() {
        return new HWKeybo();
    }
}

```

优点：当一个产品族中的多个对象被设计成一起工作时，它能保证客户端始终只使用同一个产品族中的对象。

缺点：产品族扩展非常困难，要增加一个系列的某一产品，既要在抽象的 Creator 里加代码，又要在具体的里面加代码。

## 4 区别

**简单工厂：**

就是有一个专门生产某个产品的类。

鼠标工厂，专业生产鼠标，给参数 0，生产小米鼠标，给参数 1，生产华为鼠标。

**工厂方法（生产一个产品）：**

把鼠标工厂抽象成一个类（接口）。

小米鼠标工厂，继承它：小米鼠标。

华为鼠标工厂，继承它：华为鼠标。

**抽象工厂（生产多个产品）：**

抽象工厂模式也就是不仅生产鼠标，同时生产键盘。也就是 PC 厂商是个父类，有生产鼠标，生产键盘两个接口。

小米 PC 工厂继承抽象工厂：小米鼠标 + 小米键盘。

华为 PC 工厂继承抽象工厂：华为鼠标 + 华为键盘。