## 1 设计模式的目的

编写软件过程中，面临着来自耦合性、内聚性以及可维护性，可扩展性，重用性，灵活性等多方面的挑战，设计模式是为了让程序，具有更好代码重用性、可读性、可扩展性、可靠性。

 设计模式是解决特定问题的一系列套路，是前辈们的代码设计经验的总结，具有一定的普遍性，可以反复使用。

## 2 设计模式的七大原则

### 2.1 单一职责原则

一个类应该只负责一项职责。

### 2.2 接口隔离原则

客户端不应该依赖它不需要的接口，即一个类对另一个类的依赖应该建立在最小的接口上。 

### 2.3 依赖倒置原则

* 高层模块不应该依赖低层模块，二者都应该依赖其抽象。

* 抽象不应该依赖细节，细节应该依赖抽象。

* 依赖倒转(倒置)的中心思想是**面向接口编程**。

* 依赖倒转原则是基于这样的设计理念：相对于细节的多变性，抽象的东西要稳定的多。以抽象为基础搭建的架构比以细节为基础的架构要稳定的多。在 java 中，抽象指的是接口或抽象类，细节就是具体的实现类。

* 使用接口或抽象类的目的是制定好规范，而不涉及任何具体的操作，把展现细节的任务交给他们的实现类去完成。

### 2.4 里式替换原则

* 子类中尽量不要重写父类的方法。
* 任何基类可以出现的地方，子类一定可以出现。
* 里氏替换原则告诉我们，继承实际上让两个类耦合性增强了，在适当的情况下，可以通过聚合，组合，依赖 来解决问题。

### 2.5 开闭原则

*  一个软件实体如类，**模块和函数应该对扩展开放(对提供方)，对修改关闭(对使用方)**。用抽象构建框架，用实现扩展细节。
* 当软件需要变化时，尽量通过扩展软件实体的行为来实现变化，而不是通过修改已有的代码来实现变化。
* 最少知道原则，即一个类对自己依赖的类知道的越少越好。

### 2.6 迪米特原则

* 一个对象应该对其他对象**保持最少的了解**。
* 类与类关系越密切，耦合度越大。
* 又叫最少知道原则，即一个类对自己依赖的类知道的越少越好。

### 2.7 合成复用原则 

* 尽量使用合成/聚合的方式，而不是使用继承。

