## 1 网络层的功能

### 1.1 异构网络互联

#### 1.1.1 异构网络

不同的寻址方案、网络介入机制、差错处理方法、路由选择机制

#### 1.1.2 网络互联

将两个以上的计算机网络，通过一定的方法，用一种或多种通信处理设备（中间设备）**相互连接**起来，构成大网络。

使用物理层或数据链路层的中继系统只是扩大网络，不能称为网络互联。

中继系统：

* 物理层：中继器、集线器（Hub）
* 数据链路层：网桥、交换机
* 网络层：路由器
* 网络层以上：网关

### 1.2 路由与转发

路由器主要的两个功能：

* 路由选择：确定哪一条路径
* 分组转发：当一个分组到达时所采取的动作

### 1.3 拥塞转发

在通信子网中，因出现过量的分组而引起网络性能下降的现象称为拥塞。

## 2 路由算法

### 2.1 静态路由与动态路由

静态路由算法（非自适应路由算法）：管理员手工配置的路由信息

动态路由算法（自适应路由算法）：路由器上的路由表项是通过相互连接的路由器之间彼此交换信息，然后按照一定的算法优化出来，选择最优的路由。

### 2.2 动态路由算法

- 距离-向量路由算法：所有结点都定期地将它们的整个路由选择表传送给所有与之直接相邻的结点。
- 链路状态路由算法：要求每个参与该算法的结点都具有完全的网络拓扑信息，主动测试所有相邻的结点状态，定期把状态传播给其他结点。

### 2.3 层次路由

当网络规模扩大时，路由器的路由表成比例堤增大，所以需要层次路由。

路由选择协议：

- 内部网关协议（IGP）：自治系统内所使用的路由选择协议
- 外部网关协议（EGP）：不同自治系统的路由之间交换路由信息，并负责为分组在不同自治系统之间选择最优的路径

## 3 IPv4

### 3.1 概述

IP 地址：表示路由器主机的接口 ，<网络号>，<主机号> -> 192.168.1.1

### 3.2 IPv4分组

IPv4 即普通使用的 IP （版本 4）

分组格式：

![](../asset/ip数据报的格式.png)

IP数据报分片：

* 最大传送单元（MTU）：一个链路层数据报能承载的最大数据量
  - 以太网：1500B
  - 广域网：一般不超过576B
* 当数据报长度大于链路MTU时，就会进行进行**分片传输**

### 3.3 IPv4 地址与 NAT

IP 地址分类：

![](../asset/分类ip地址.png)

特殊含义地址：

* 主机号全为 1，本网络的广播地址
* 主机号全为 0，本网络本身
* 127.0.0.0，本机本身
* 255.255.255.255，表示整个 TCP/IP网络广播地址
* 0.0.0.0 表示本网络上的本主机

**NET（网络地址转换）**：在专用网连接到因特网的路由器安装 NAT软件，安装了 NAT 软件的路由器叫 NAT路由器，至少有一个有效的外部全球 IP 地址。

### 3.4 子网划分与子网掩码、CIDR

### 3.5 IP地址与硬件地址

### 3.6 地址解释协议（ARP）

### 3.7 动态主机配置协议（DHCP）

### 3.8 网际控制报文协议（ICMP）

## 4 IPV6

### 4.1 功能

### 4.2 IPV6的特点

### 4.3 IPV6地址

### 4.4 IPV4向IPV6过渡

## 5 路由协议

### 5.1 自治系统（AS）

### 5.2 域内路由与域间路由

### 5.3 路由信息协议（RIP）

### 5.4 开放最短路径优先（OSPF）协议

### 5.5 边界网关协议（BGP）

### 5.6 路由协议比较

## 6 IP组播

### 6.1 概念

### 6.2 地址

### 6.3 IGMP 与组播路由算法

## 7 移动IP

### 7.1 概念

### 7.2 通信过程

## 8 网络层设备

### 8.1 路由器的组成和功能

### 8.2 路由表与路由转发