## 1 文件系统基础

### 1.1 文件的相关概念

文件是以**计算机硬盘为载体**的存储在计算机上的信息集合，可以是文本文档、图片、程序。

文件的结构：数据项、记录、文件（有结构文件、无结构式文件）

文件的属性：名称、标识符、类型、位置、大小、保护、时间日期和用户标识

文件的基本操作：创建文件、写文件、读文件、文件重定位、删除文件、截断文件

### 1.2 文件的逻辑结构

* 无结构文件（流式文件）-> 如文本文件
* 有结构文件（记录式文件）：顺序文件、索引文件、索引顺序文件 -> 如数据库

### 1.3 目录结构

使多个用户可以共享使用一个文件

- 单级目录结构

![](../asset/%E5%8D%95%E7%BA%A7%E7%9B%AE%E5%BD%95%E7%BB%93%E6%9E%84.jpg)

- 两级目录结构

  ![](../asset/%E4%B8%A4%E7%BA%A7%E7%9B%AE%E5%BD%95%E7%BB%93%E6%9E%84.jpg)

- 多级目录结构

  ![](../asset/%E6%A0%91%E5%BD%A2%E7%9B%AE%E5%BD%95%E7%BB%93%E6%9E%84.jpg)

- 无环图目录结构

  ![](../asset/%E6%97%A0%E7%8E%AF%E5%9B%BE%E7%9B%AE%E5%BD%95%E7%BB%93%E6%9E%84.jpg)

### 1.4 文件共享

保证不同的用户对文件有不同的操作权限

- 基于索引结点的共享文件（硬链接）
- 利用符号链实现文件共享（软连接）：B 要共享 A 文件 F，创建一个 文件 F（只包含链接文件 F 的路径名） 写入到 B 目录中。

### 1.5 文件保护

* 口令保护

* 加密保护

* 访问控制

## 2 文件系统实现

### 2.1 文件层结构

* 用户调用接口
* 文件目录系统
* 存储控制验证
* 逻辑文件系统关于信息缓冲区
* 物理文件系统
* 辅助分配模块
* 设备管理程序模块

### 2.2 目录实现

* 线性列表
* 哈希表

### 2.3 文件实现

文件分配方式：连续分配、链接分配、索引分配

 ## 3 磁盘组织与管理

### 3.1 磁盘结构

磁盘：是由表面涂有磁性物质的金属或塑料构成的圆形盘片，通过一个称为**磁头**的导体线圈从磁盘存储数据。

![](../asset/磁盘结构.jpg)

### 3.2 磁盘调度算法

* 先来先服务（FCFS）
* 最短寻址时间优先（SSTF）
* 扫描算法（SCAN）
* 循环算法（S-SCAN）

### 3.3 磁盘的管理

* 磁盘初始化：对磁盘进行低级格式化和逻辑格式化
* 引导块：存放自举程序
* 坏块：对于损坏扇区的处理