## 1 内存管理概念

### 1.1 内存管理的基本原理和要求

内存：内存可存放数据，程序执行前需要**先放到内存**中才能被 CPU 处理 -- 缓和 CPU 与硬盘之间的速度矛盾。

功能：

* 内存空间的分配与回收
* 地址转换
* 内存空间的扩充
* 存储保护

####  1.1.1 程序的装入和链接

创建步骤：编译、链接、装入

链接的类型：静态链接、装入时动态链接、运行时动态链接

装入模式：绝对装入、可重定位装入、动态运行时装入 

### 1.2 覆盖与交换

多道程序环境用来扩充内存的方法。

覆盖：将程序分为多个段，常用的段常驻内存，不常用的段需要时才调入内存

交换：内存中某些段移出内存，把外存中具备运行的装入内存

### 1.3 连续分配管理方式

一个程序分配一个连续的内存空间

* 单一连续分配
* 固定分区分配
* 动态分区分配
  * 首次适应算法
  * 最佳适应算法
  * 最坏适应算法
  * 邻近适应算法

### 1.4 非连续分配管理方式

一个程序分散地装入不相邻的内存分区，根据分区大小是否固定，分为**分页存储管理、分段存储管理**。

**分页存储管理**根据运行时是否把作业的所有页面都装入内存才能运行，又分为**基本分页存储管理方式**、**请求分页存储管理方式**。

### 1.5 基本分页存储管理方式

* 分页管理不会产生碎片
* 将主存空间划分为**大小相等且固定的块**，块相对较小，作为主存的基本单位，进程以块为单位空间申请。

### 1.5 基本分段存储管理方式

* 按照**用户进程**中的自然段划分逻辑空间。

### 1.6 段页式管理方式

* 作业的地址空间首先被分为若干逻辑段，每段都有自己的段号
* 每个段分为若干大小固定的页
* 对内存空间的管理仍然和分页存储管理一样
* 会产生碎片

### 1.7 分页和分段区别

- 对程序员的透明性：分页透明，但是分段需要程序员显式划分每个段。
- 地址空间的维度：分页是一维地址空间，分段是二维的。
- 大小是否可以改变：页的大小固定，段的大小可以**动态改变**。
- 出现的原因：分页主要用于实现虚拟内存，从而获得更大的地址空间；分段主要是为了使程序和数据可以被划分为逻辑上独立的地址空间并且有助于共享和保护。

## 2 虚拟内存管理

### 2.1 基本概念

传统存储管理方式的特征：

* 一次性
* 驻留性

局部性原理：

* 时间局部性
* 空间局部性

虚拟存储器的定义：基于局部性原理，程序的一部分装入内存，一部分留在外存，需要的时候调入内存。

特征：多次性、对换性、虚拟性

实现：

* 请求分页存储管理
* 请求分段存储管理
* 请求段页式存储管理

### 2.2 请求分页管理方式

系统建立在基本分页系统基础之上，为了支持虚拟存储器功能而增加了**请求调页功能**和**页面置换功能**

### 2.3 页面置换算法

* 最佳置换算法（OPT）
* 先进先出页面置换算法（FIFO）
* 最近最久未使用置换算法（LRU）
* 时钟置换算法（CLOCK）

### 2.4 页面分配策略

* 固定分配局部置换
* 可变分配全局置换
* 可变分配局部置换

### 2.5 抖动

刚换出的页面又要换入内存。

原因：

* 分配的物理页帧数不足（主要原因）
* 置换算法不当

### 2.6 工作集

某段时间内，进程要访问的页面集合。