## 1 操作系统的基本概念

### 1.1 操作系统的特征

* 并发
* 共享
  - 互斥共享：同一时刻，仅允许一个进程访问，例如打印机
   * 同时访问：一段时间允许多个进程访问，例如，磁盘
* 虚拟
  - 时分复用技术：处理器的分时共享
   * 空分复用技术：虚拟存储器
* 异步：多道程序走走停停，进程以不可预知的速度前进

### 1.2 操作系统的目标和功能

* 作为计算机系统资源的管理者
  - 处理机管理
  - 存储器管理
  - 文件管理
  - 设备管理
* 作为用户与计算机硬件系统之间的接口
  - 命令接口
    - 联机命令接口：交互式命令接口
    - 脱机命令接口：批处理系统，提交一组作业。
  - 程序接口：图形用户界面（GUI）
* 用作扩充机器：覆盖了软件的机器称为扩充机器，又称虚拟机

## 2 操作系统的发展与分类

* 手工操作阶段
* 批处理阶段
  * 单道批处理系统
  * 多道批处理系统
* 分时操作系统
  	* 将处理器运行时间划分为时间片，将时间片分配给不同作业/用户从而占用处理机
  	* 同时性、交互性、独立性、及时性
* 实时操作系统
  * 保证在规定时间内完成某项规定任务
* 分布式计算机系统
* 个人计算机系统

## 3 操作系统的运行环境

程序运行的过程其实就是 CPU 执行机器指令的过程。

### 3.1 操作系统的运行机制

CPU 执行两种性质程序：内核程序、用户自编程序

内核：

* 时钟管理：操作系统对用户提供标准时间，**根据时钟对进程进行管理**，实现进程切换。
* 中断管理：提高多道程序运行环境中的 CPU 利用率。
* 原语（运行原子性）：处于系统的最底层，最接近硬件。
  * 进程管理
  * 存储器管理
  * 设备管理

### 3.2 中断与异常

中断机制：为了核心态与用户态切换。

核心态可以执行用户态无法执行的**特权指令**。

* 中断（外中断）：CPU 指令之外的事件发生（I/O中断、时钟中断）
* 异常（内中断）：CPU 执行指令内部的事件（非法操作码、除零、算术溢出）

系统调用：

* 设备功能
* 文件管理
* 进程管理
* 进程通信
* 内存管理

### 3.3 用户态与内核态

处于内核态（核心态、管态）：运行内核程序，执行**特权指令**

处于用户态（目态）：运行应用程序，执行非特权指令

CPU 有一个寄存器叫程序状态字寄存器（psw），1 代表 内核态，0 代表 用户态

## 4 大内核与为内核

* 大内核：操作系统的主要功能进行集中，提供服务
* 微内核：将内核中的基本功能（如：进程管理）保留在内核中，不需要的核心态功能转移到用户态。（性能问题，需要**频繁的用户态与内核态之间切换**）

