## 1 基本概念
密码学是网络安全、信息安全、区块链等产品的基础，常见的非对称加密、对称加密、散列函数等，都属于密码学范畴。

密码学分为
* 古典密码学
* 近代密码学
* 现代密码学

## 2 古典密码学
* 替换法：固定的信息将原文替换成无法直接阅读的密文信息，i love you -> t hate set 
* 移位法：将原文中的所有字母都在字母表上向后（或向前）按照一个固定数目进行偏移后得出密文，例如恺撒密码， abc -> def。

破解方式：
* 频率分析（概率论）

## 3 近代密码学
恩尼格玛机：是二战时期纳粹德国使用的加密机器，后被英国破译，参与破译的人员有被称为计算机科学之父、人工智能之父的图灵，本质就是移位和替代。

## 4 现代密码学

### 4.1 散列函数
也见杂凑函数、摘要函数或哈希函数，**将任意长度的消息经过运算，变成固定长度数值**，常见的有 MD5、SHA-1、SHA256，多应用在文件校验，数字签名中。

**MD5**:将任意长度的原文生成一个128位（16字节）的哈希值

**SHA-1**:将任意长度的原文生成一个160位（20字节）的哈希值

### 4.2 对称密码
应用**相同的加密密钥和解密密钥**

对称密码分为:
* 序列密码(流密码)：对信息流中的每一个元素（一个字母或一个比特）作为基本的处理单元进行加密。
* 分组密码(块密码)：先对信息流分块，再对每一块分别加密。

### 4.3 非对称密码
有两个密钥：
* 公钥（public key）
* 私钥（private key）

1. 加密和解密运算使用的密钥不同；
2. 公钥加密，私钥解密；
3. 私钥加密（签名），公钥解密（验签）；
4. 公钥可以公开的，大家使用公钥对信息进行加密，再发送给私钥的持有者，私钥持有者使用私钥对信息进行解密，获得信息原文；
5. 私钥只能有一人持有，不用当心被信息被破解；


### 4.4 保证密码安全
* 不要使用常用的密码，如 123456；
* 不同账号尽量不要使用用一个密码，避免一个数据库被脱库，其他都被破解；
* 在设置密码时增加注册时间、注册地点、应用特性等信息，如 beijing20120202