﻿## 1 总览

作为开发者，基础知识非常重要的，尤其一些大厂非常注重基础，基础是一切的根本，在面试时候，如果没有事先准备，很容易被淘汰。笔者整理这套知识点，大大小小的一共几百多条，方便大家查漏补缺。

参考答案[点击这里](https://github.com/yoyiyi/SoleilNotes)

分为以下几个部分

* Java 知识点
* Android 知识点
* 计算机基础知识点
* 算法

## 2 Java 知识点

### 2.1 Java 基础

* Java 语言有什么特点？
* 面向对象三大特征
* Java 和 C++ 的区别?
* import java 和 javax 有什么区别？
* JVM、JDK、JRE 区别？
* Java 语言是编译与解释并存？
* Java 注释
* Java 标识符和关键字
* Oracle JDK 和 OpenJDK 的区别？
* 访问修饰符 public、private、protected、以及不写（默认）时的区别？
* String 是最基本的数据类型吗？
* String s = new String("xyz");创建了几个字符串对象？
*  是否可以继承 String 类？
* float f=3.4;是否正确？
* short s1 = 1; s1 = s1 + 1;有错吗?short s1 = 1; s1 += 1;有错吗？
* int 和 Interger 区别？
* new Integer(120) 与 Integer.valueOf(120) 有何区别？
* &和&&的区别？
* Math.round(11.5) 等于多少？Math.round(-11.5)等于多少？
*  switch 是否能作用在 byte 上，是否能作用在 long 上，是否能作用在String上？
* 用最有效率的方法计算2乘以8
* 数组有没有 length() 方法？String 有没有 length() 方法？
* 在 Java中，如何跳出当前的多重嵌套循？
* 构造器（constructor）是否可被重写（override）？
* 两个对象值相同 x.equals(y) == true，但却可有不同的 hashcode，对不对？
* 当一个对象被当作参数传递到一个方法后，此方法可改变这个对象的属性，并可返回变化后的结果，那么这里到底是值传递还是引用传递？（Java 没有引用传递，只有值传递）
* String 和 StringBuilder、StringBuffer的区别？
* 重载（Overload）和重写（Override）的区别，重载的方法能否根据返回类型进行区分？
* 抽象类（abstract class）和接口（interface）有什么异同？
* char 型变量中能不能存贮一个中文汉字，为什么？
* 静态嵌套类(Static Nested Class)和内部类（Inner Class）的不同？
* 抽象的（abstract）方法是否可同时是静态的（static）,是否可同时是本地方法（native），是否可同时被 synchronized 修饰？
* 一个类中静态（static）方法是否可以调用非静态（non-static）方法？
*  如何实现对象克隆？
* 断点续传?
*  Java 中的 final 关键字有哪些用法？
* try{}里有一个return语句，那么紧跟在这个try后的finally{}里的代码会不会被执行，什么时候被执行，在return前还是后?
* 阐述 final、finally、finalize 的区别？
* Collection和Collections的区别？
* 字符型常量和字符串常量的区别？
* Java 基本类型占用内存大小？
* continue、break、和 return 的区别？
* == 和 equals 区别？
* hashCode() 与 equals()
* 在 Java 中定义一个不做事且没有参数的构造方法的作用？
* 对象的相等与指向他们的引用相等，两者有什么不同?
* 在一个静态方法内调用一个非静态成员为什么是非法的？
*  Object 类常见的方法？
* Java 序列化中如果有些字段不想进行序列化，如何做？
* 重载和重写的区别？
* 成员变量与局部变量区别？
* 类的构造方法的作用是什么? 若一个类没有声明构造方法，该程序能正确执行吗? 为什么?
* 为什么不能通过返回值类型区分重载？
* BIO、NIO、AIO 区别？
* 装箱和拆箱的原理？
* 反射
* Java 泛型
* 泛型类型擦除？
* 获取 Class 对象的方法？
* 反射中创建对象的两种方法？
* 为什么重写 equals 时必须重写 hashCode 方法？
* 解决Hash碰撞冲突方法？
* 深拷贝和浅拷贝？
* 说说 Java 异常体系？
* Java I/O 分为几种？
* 那些状态下 finally 不会被执行？

### 2.2 Java 容器

* ArrayList、LinkedList、Vector 区别？
* list、set、map 区别？
* HashSet、LinkedHashSet、TreeSet 区别、源码？
* HashMap、LinkedHashMap、Hashtable、TreeMap 区别、源码？
* List、Set、Map 区别？
* ArrayList 和 Vector 区别？
* 说说 ConcurrentHashMap？
* ArrayList 扩容机制？
* 说说 ArrayList 源码中 ensureCapacity() 作用吧？
* HashMap 的长度为什么是 2 的幂次方？
* comparable 和 Comparator 的区别?

### 2.3 Java 并发

* sleep() 和 wait() 区别？
* sleep() 方法和 yield() 区别？
* 实现多线程程序有几种实现方式？
* 线程的生命周期？
* 为什么线程启动要调用 start()，而不是直接调用 run()?
* interrupt()、interrupted()、isInterrupted() 区别？
* start()、run() 区别？
* 说说乐观锁、悲观锁、自旋锁、共享锁、独占锁、重量级锁、轻量级锁？
* 说说 synchronized？
* 说说 ReentrantLock ？
* 说说线程的死锁吧？
* 如何避免死锁？
* 程序计数器为什么设计成私有？
* 虚拟机栈和本地方法栈为什么设计成私有？
* 公平锁、非公平锁、可重入锁？
* Semaphore 信号量
* JDK 1.6 synchronized 作了那些优化？
* 说说 ThreadPoolExecutor 构造方法的参数？ 
* 说说 Java 阻塞队列？
* CyclicBarrier、CountDownLatch、Semaphore 的用法？
* 说说 volatile？
* 上下文切换？
* 说说 ThreadLocal ？
* 进程调度算法？
* 线程有哪些基本状态？
* 并发和并行区别？
* 线程和进程区别？
* 了解 CAS 吗？
* 说说 ABA 问题？
* AQS 了解吗？

### 2.4 JVM

* 说说 JVM 运行时数据区？
* 说说 JVM 内存区域？
* Java 对象如何创建的，对象创建过程？
* MinorGC、MajorGC、FullGC 区别？
* 可作为 GC Roots 的对象？
* 垃圾回收算法？
* 类加载机制？
* 类加载器？
* 双亲委派机制？
* 内存分配策略？
* 对象的访问定位有哪几种？
* 虚拟机如何解决内存分配并发问题？
* 可作为 GC Roots 的对象包括几种？
* String s1 = new String("abc");这句话创建了几个字符串对象？
* String.intern() 作用？

### 2.5 设计模式

* 创建者模式
  - 单例模式
  - 工厂模式
  - 原型模式
  - 建造者模式
* 结构型模式
  - 适配器模式
  - 代理模式
  - 装饰者模式
  - 桥接模式
  - 外观模式
  - 享元模式
  - 组合模式
  - 桥接模式
* 行为型模式
  - 模板模式
  - 策略模式
  - 命令模式
  - 职责链模式
  - 状态模式
  - 观察者模式
  - 中介者模式
  - 迭代器模式
  - 访问者模式
  - 备忘录模式
  - 解释器模式

## 3 Android 知识点

* Activity 生命周期
* 横竖屏切换时候 Activity 的生命周期
* ActivityA 跳转 ActivityB 然后 B 按 back 返回 A，各自的生命周期顺序，A 与 B 均不透明？如果B是透明主题的又或是个DialogActivity 呢？
* Android中进程的优先级？
* onSaveInstanceState()方法的作用 ? 何时会被调用？
* Activity的四种启动模式、应用场景 ？
* Activity 常用的标记位 Flags？
* Activity 跟 window，view 之间的关系？
* 如何启动其他应用的 Activity？
* 什么是 ANR？ 如何避免？
* 说说 Android 中的动画？
* ACTION_CANCEL 事件触发？
* 动画的原理？
* 属性动画和 View 动画区别？
* Android 各版本新版本
* Serialzable 和 Parcelable 的区别？
* Android 为每个应用程序分配的内存大小是多少？
* Activity 的 startActivity 和 context 的 startActivity区别？、
* 怎么在Service中创建Dialog对话框？
* 程序A能否接收到程序B的广播？
* 数据加载更多涉及到分页，你是怎么实现的？
* 编译期注解跟运行时注解有何不同？
* 如何解析 xml，以及三种方式的区别？
* 更新 UI 方式？
*  jar 和 aar 的区别？
*  程序自启动？
* BroadcastReceiver，LocalBroadcastReceiver 区别？
* SharedPrefrences 的 apply 和 commit 有什么区别？
* 计算一个view的嵌套层级？
* asset 目录与 res 目录的区别？
* 硬件加速
* 显式 Intent 和隐式 Intent
* 广播传输的数据是否有限制，是多少，为什么要限制？
* 安卓签名机制？
* merge、ViewStub、include 的作用？
* ContentProvider 使用
* Android 怎么加速启动 Activity？
* Json 解析方式的两种区别？
* Fragment懒加载
* Bitmap 使用时候注意什么？
* 多进程场景遇见过么？
* Bitmap 的 recycler()
* 一张Bitmap所占内存以及内存占用的计算
* 数据库升级增加表和删除表都不涉及数据迁移，但是修改表涉及到对原有数据进行迁移,如何实现？
* Canvas.save() 跟 Canvas.restore()的区别
* 为什么bindService可以跟Activity生命周期联动？
* 自定义 view 效率高于xml定义吗？说明理由。
* Gradle 配置多渠道打包
* Service 的生命周期
* 加速启动Activity？
* 断点续传和下载
* Fragment 在 ViewPager 里面的生命周期，滑动 ViewPager 的页面时 Fragment 的生命周期的变化。
* Android中跨进程通讯的几种方式?
* HandlerThread
* IntentService
* 说一说支付流程？
* 如何导入外部数据库
* 如何保证Service不被杀死？
* 简单说说 LinearLayout、FrameLayout、RelativeLayout 性能？
* 说说 scheme 跳转协议？
* 说说 Android 中集合框架？
* Service 和 Activity 在同一个线程吗？
* Service 里面可以弹吐司么？
* 说说 Activity、Intent、Service 是什么关系？
* 简单说一下 IntentService
* Context 是 什 么 ？  一 个 应用有多少个 Context？
*  Context、 Activity、Application 有什么区别？
* 实现竖向的 TextView？TextView 文字描边效果？
* 广播的两种注册方式 ？
* Activity 怎么和 Service 绑定，怎么在Activity 中启动自己对应的 Service？
* 如何将一个 Activity 设置成窗口的样式
* 简单说一下 Activity
* Service 是否在 main thread 中执行, service 里面是否能执行耗时的操作?
* 说说ContentProvider、ContentResolver、ContentObserver 之间的关系？
* ddms 和 traceView 的区别？
* Handler、Thread和HandlerThread的差别
* Android 适配方案
* Android 中 HashMap 的优化
*  AsyncTask 的缺陷和问题，说说他的原理？
* 说说 AndroidManifest.xml？
* Activty 和 Fragmengt 之间怎么通信，Fragmengt 和 Fragmengt怎么通信？
* Android系统架构，你能说说每一层的作用吗？
* 反编译了解吗？
* 为什么 bindService 可以跟Activity生命周期联动？
* oom 是否可以try catch ？
* 如何绕过 9.0 限制
* 你是如何做单元测试的
* 非UI线程可以更新UI吗?
* 怎么控制另外一个进程的View显示？
* Android 程序运行时权限与文件系统权限
* SurfaceView、TextureView、SurfaceTexture、GLSurfaceView？
* Scroller 原理？
* RecyclerView 的性能优化
* ListView 与 RecyclerView 简单对比?
*  Android类加载器
* onStart()与onResume()有什么区别？
* 说说 IdleHandler 
* 同步屏障机制(sync barrier)
* getWidth() 和 getMeasureWidth() 区别
* requestLayout，invalidate，postInvalidate 之间的区别？
* apk安装流程
* app 瘦身
* 64k
* 遇到 Fragment 哪些问题？
* View 绘制
* 如何解决View的事件冲突？
* SharePreference性能优化
* 内存缓存和磁盘缓存是怎么实现的？
* PathClassLoader与DexClassLoader有什么区别？
* SQLite升级
* WebView优化
* 什么是MeasureSpec？
* Fragment的懒加载实现
* DataBinding了解吗，你能说说它具体实现原理吗，有那些缺点？
* MVC、MVP、MVVM 之间有何区别？
* 如何实现一个圆形头像？
* Apk 加密？
* Apk 打包流程？
* Android 匿名共享内存
* MMKV 用过吗、原理？
* 界面刷新机制？
* 打包的时候 v1、v2、v3 签名有何区别？
* Activity启动过程
* ContentProvider启动过程
* Service启动过程
* 广播启动过程
* Binder机制
* 插件化
* 组件化
* 热修复
* 换肤方案
* 事件分发
* 绘制流程
* 源码分析
  * ARouter
  * ButterKnife
  * Dagger2
  * EventBus
  * Glide
  * GreenDao
  * Leakcanary
  * Okhttp
  * Retrofit
  * RxJava
* 性能优化
  * 内存优化
  * 绘制优化
  * 启动优化
  * 数据存储优化
  * 网络优化
  * 电量优化
  * 包体积优化
* Kotlin
  * 谈谈协程？
  * List 与 MutableList 的区别？
  * let、with、run、apply、also 之间的区别应用场景？
  * 注解 @JvmOverloads 的作用？
  * 实现单例的几种常见方式？
  * data class 理解？
  * 集合遍历有哪几种方式？
  * 什么是委托属性？请简要说说其使用场景和原理？
  * Kotlin中 Unit 类型的作用以及与Java中 Void 的区别？
  * Kotlin 中 infix 关键字的原理和使用场景？
  * "==" 和 "===" 区别？
  * 介绍一下伴生对象和静态成员？
  *  kotlin 中 var、val、const val 区别？
  * @JvmField 和 @JvmStatic 的使用
  * @JvmOverloads 的作用？
  * List 与 MutableList 区别？
  * Kotlin 中的数据类型有隐式转换吗？
  * Kotlin中的可见性修饰符有哪些？相比于 Java 有什么区别？
  * 在 Kotlin 中，什么是内联函数？有什么作用？
  * 谈谈 Kotlin 中的 Sequence，为什么它处理集合操作更加高效？
  * 请谈谈 Kotlin 中的 Coroutines，它与线程有什么区别？有哪些优点？
  * Kotlin 中可见型修饰符有哪些？相比于Java有什么区别？
  * 谈谈 Kotlin 中的Unit？它和 Java 中的 void 有什么区别？
  * 如何安全地处理可空类型？
  * 说说 Kotlin中 的 Any 与 Java 中的 Object 有何异同？
  *  Kotlin中 Unit 类型的作用以及与Java中 Void 的区别？
  * 分别通过对象表达式 object 和 lambda 表达式实现的函数式接口内部有何不同？

## 4 计算机基础知识点

* tcp/ip 流量控制和滑动窗口如何实现的，能具体说说嘛？
* DNS 解析过程？
* 三次握手和四次挥手？
* 谈谈 TCP/IP 协议？
* TCP 协议如何保证可靠传输？
* 拥塞控制的算法？
* 在浏览器中输入 url 地址发生了什么？
* URI 和 URL 的区别是什么？
* HTTP1.0、HTTP2.0、HTTP3.0 区别？
* HTTP 和 HTTPS 区别？
* 进程和线程区别？
* 进程有那几种的状态？
* 进程间有哪几种通信方式？
* 线程间的同步方式？（互斥量、信号量、事件）
* 进程间的调度算法？
* 页面置换算法？

## 5 算法

算法无论在面试还是日常开发中都非常重要，可以很好的培养我们编程思维，刷题网站这里推荐 [LeetCode](https://leetcode-cn.com/)，如果有时间起码要刷 300 道，而且要反复刷，刷题可以参考极客算法训练营，五毒神掌。

* 第一遍
  * 5分钟：读题 + 思考
  * 如果没有思路，直接看解法，比较优劣
  * 背诵、默写好的解法
* 第二遍
  * 写代码测试 -> 最优
* 第三遍
  * 过一天，重复做题
* 第四遍
  * 过一周，重复做题
* 第五遍
  * 过一个星期，恢复性训练
* 剑指Offer
  * 数组中重复的数字  	
  * 二维数组中的查找  	
  * 替换空格  	
  * 从尾到头打印链表  重建二叉树  	
  * 用两个栈实现队列  	
  * 斐波那契数列  	
  * 青蛙跳台阶问题  	
  * 旋转数组的最小数字  		
  * 矩阵中的路径  	
  * 机器人的运动范围  	
  * 剪绳子  	
  * 剪绳子 II  	
  * 二进制中1的个数  	
  * 数值的整数次方  	
  * 打印从1到最大的n位数  	
  * 删除链表的节点  	
  * 正则表达式匹配  	
  * 表示数值的字符串  	
  * 调整数组顺序使奇数位于偶数前面  	
  * 链表中倒数第k个节点  	
  * 反转链表  	
  * 合并两个排序的链表  	
  * 树的子结构  	
  * 二叉树的镜像  	
  * 对称的二叉树  	
  * 顺时针打印矩阵  
  * 栈的压入、弹出序列  	
  * 从上到下打印二叉树  	
  * 从上到下打印二叉树 II  	
  * 从上到下打印二叉树 III  
  * 二叉搜索树的后序遍历序列  	
  * 复杂链表的复制  	
  * 二叉搜索树与双向链表  
  * 序列化二叉树  	
  * 字符串的排列  	
  * 数组中出现次数超过一半的数字  
  * 最小的k个数 
  * 数据流中的中位数  	
  * 连续子数组的最大和  	
  * 1～n 整数中 1 出现的次数  
  * 数字序列中某一位的数字  	
  * 把数组排成最小的数  
  * 把数字翻译成字符串  	
  * 礼物的最大价值  
  * 最长不含重复字符的子字符串  	
  * 丑数  
  * 第一个只出现一次的字符  
  * 数组中的逆序对  	
  * 两个链表的第一个公共节点  	
  * 在排序数组中查找数字 I  
  * 0～n-1中缺失的数字  
  * 二叉搜索树的第k大节点  
  * 二叉树的深度  
  * 平衡二叉树  
  * 数组中数字出现的次数  
  * 数组中数字出现的次数 II  
  * 和为s的两个数字  
  * 和为s的连续正数序列  
  * 翻转单词顺序  
  * 左旋转字符串 
  * 滑动窗口的最大值  
  * 队列的最大值  	
  * n个骰子的点数  
  * 扑克牌中的顺子  
  * 圆圈中最后剩下的数字  	  
  * 股票的最大利润  	
  * 求1+2+…+n  	
  * 不用加减乘除做加法  	
  * 构建乘积数组  	 
  * 把字符串转换成整数  	 
  * 二叉搜索树的最近公共祖先  	 
  * 二叉树的最近公共祖先  
* HOT 100
  * 1	两数之和  	
  * 2	两数相加  	
  * 3	无重复字符的最长子串  	
  * 4	寻找两个正序数组的中位数 
  *  5	最长回文子串  	
  * 10	正则表达式匹配  	
  * 11	盛最多水的容器  	
  * 15	三数之和  	
  * 17	电话号码的字母组合  	
  * 19	删除链表的倒数第 N 个结点  	
  * 20	有效的括号  	
  * 21	合并两个有序链表  	
  * 22	括号生成  	
  * 23	合并K个升序链表  	
  * 31	下一个排列  	
  * 32	最长有效括号  	
  * 33	搜索旋转排序数组  	
  * 34	在排序数组中查找元素的第一个和最后一个位置  	
  * 39	组合总和  
  * 42	接雨水  
  * 46	全排列  	
  * 48	旋转图像  	
  * 49	字母异位词分组  
  * 53	最大子序和  
  * 55	跳跃游戏  	
  * 56	合并区间  	
  * 62	不同路径  	
  * 64	最小路径和  	
  * 70	爬楼梯  
  * 72	编辑距离  
  * 75	颜色分类  	
  * 76	最小覆盖子串  	
  * 78	子集  	
  * 79	单词搜索  	
  * 84	柱状图中最大的矩形  
  * 85	最大矩形  	
  * 94	二叉树的中序遍历 
  * 96	不同的二叉搜索树  	
  * 98	验证二叉搜索树  	
  * 101	对称二叉树  
  * 102	二叉树的层序遍历  
  * 104	二叉树的最大深度  	
  * 105	从前序与中序遍历序列构造二叉树  	
  * 114	二叉树展开为链表  
  * 121	买卖股票的最佳时机  	
  * 124	二叉树中的最大路径和  
  * 128	最长连续序列  	
  * 136	只出现一次的数字  	
  * 139	单词拆分  
  * 141	环形链表  	
  * 142	环形链表 II  	
  * 146	LRU 缓存机制  
  * 148	排序链表  	
  * 152	乘积最大子数组  	
  * 155	最小栈  	
  * 160	相交链表  	
  * 169	多数元素  
  * 198	打家劫舍  	
  * 200	岛屿数量  
  * 206	反转链表  	
  * 207	课程表  	
  * 208	实现 Trie (前缀树)  
  * 215	数组中的第K个最大元素  	
  * 221	最大正方形  	
  * 226	翻转二叉树  	
  * 234	回文链表  
  * 236	二叉树的最近公共祖先  
  * 238	除自身以外数组的乘积  	
  * 239	滑动窗口最大值  
  * 240	搜索二维矩阵 II  	
  * 253	会议室 II  	
  * 279	完全平方数  	
  * 283	移动零  
  * 287	寻找重复数  	
  * 297	二叉树的序列化与反序列化  	
  * 300	最长递增子序列  	
  * 301	删除无效的括号  	
  * 309	最佳买卖股票时机含冷冻期  	
  * 312	戳气球  
  * 322	零钱兑换  	
  * 337	打家劫舍 III  	
  * 338	比特位计数  	
  * 347	前 K 个高频元素  	
  * 394	字符串解码  	
  * 399	除法求值  	
  * 406	根据身高重建队列  	
  * 416	分割等和子集  	
  * 437	路径总和 III  	
  * 438	找到字符串中所有字母异位词  	
  * 448	找到所有数组中消失的数字  	
  * 461	汉明距离  	
  * 494	目标和  	
  * 538	把二叉搜索树转换为累加树  	
  * 543	二叉树的直径  	
  * 560	和为K的子数组  	
  * 581	最短无序连续子数组  	
  * 617	合并二叉树  	
  * 621	任务调度器  		
  * 647	回文子串  
  * 739	每日温度  

* 排序算法
  * 冒泡排序
  * 选择排序
  * 插入排序
  * 希尔排序
  * 归并排序
  * 快速排序
  * 堆排序
  * 计数排序
  * 桶排序
  * 基数排序

